//////////////////// timeSeres.js //////////////////////////////////////////////
//	Contains functions needed to process the time series web tool requests
///
///	functions
//	(1) mrRegister()- register the monthly range
//	(2) tsReset()- reset the timeSeries tool
//	(3) createTSgridImap() creates the imap for selecting one or more grids 
//		for averaging
//	(4) selectTSpoints(gridID,xcoord,ycoord)- places grid marker on grid
//	(5) tsClearGrids(0)- clears all grid cell markers; tsClearGrids(1) hides grids
//	(6) registerGrids() registers and processes selected grids, opens imap with node locations
//		in a new window, and creates the time series background image
//	(7) generateTSeries() produces the imap with underlying time series plots
//	(8) selectAYpoints(iflg)
//	(9) deselectTsAyears() 
//	(10) showTSAY()
//	(11) hideTSAY() 
//	(12) prcsTScvar(cvar,grids,mnth1,mnth2)- given a set of grid nodes with ID jjiii, 
//		this functions read all data and forms averages over the months given 
//		by the mnths array.
//	(13) accessTSdata- this reads the raw anomaly time series data from 
//		data/anomts-txt'gridID/cvar/ (input to access code as the filename)
//	(14) processTsAyears-
//	(15) disptsTCIranges- 
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////// mrRegister() ////////////////////////////////
function mrRegister() {
//
	removeDiv(idisp_mnth_range,"disp_mnth_range")
	idisp_mnth_range=0;

//	This function places the monthly range on the global grid map
	tsmnth2=Number(theaMnth);
	var mnth2=mnthNames[Number(theaMnth)-1];
	var ind = document.forms["firstmnth_form"].selectfirstmo.selectedIndex;
	var mnth1 = document.forms["firstmnth_form"].selectfirstmo.options[ind].value;
		for(i=0;i<mnthNames.length;i++) {
		if(mnth1 == mnthNames[i]) tsmnth1 = i+1;
		}
	ayinc=0;
	if(tsmnth1>tsmnth2) ayinc=1;
//alert('monthly range='+mnth1+' through '+mnth2+' ayinc='+ayinc);
//alert('monthly range,tsmnth1='+tsmnth1+' tsmnth2='+tsmnth2);
//
//	generate <div> to place info on map
	if(idisp_mnth_range==0) {
	var dsel = document.createElement('div');
	var divIdName = "disp_mnth_range";
	dsel.setAttribute('id',divIdName);
	dsel.style.left = "610px";
	dsel.style.top = "3px";
	dsel.style.width = "160px";
	dsel.style.position = "absolute";
	dsel.style.z_index = 1500;
	dimage = '<font size=2>Monthly Range: '+mnth1+' to '+mnth2+'</font>';
	dsel.innerHTML = dimage;
	var node = document.getElementById("map");
	node.appendChild(dsel);
	idisp_mnth_range=1;
	}
}  // mrRegister
///////////////////////////////////////// tsReset() ////////////////////////////////
function tsReset() {

	removeDiv(idisp_hplot,"disp_hplot")
	idisp_hplot=0;
	deselectTsAyears(1)
	removeDiv(idisp_hbckg,"disp_hbckg")
	idisp_hbckg=0;
	removeDiv(idisp_hmssg,"disp_hmssg")
	idisp_hmssg=0;
	removeDiv(idisp_hprmbl,"disp_hprmbl")
	idisp_hprmbl=0;
	removeDiv(idisp_hlead,"disp_hlead")
	idisp_hlead=0;
	removeDiv(idisp_hyplot,"disp_hyplot")
	idisp_hyplot=0;
	removeDiv(idisp_htype,"disp_htype")
	idisp_htype=0;
	removeDiv(idisp_hinfo,"disp_hinfo")
	idisp_hinfo=0;
	removeDiv(idisp_anlglist,"disp_anlglist")
	idisp_anlglist=0;
	removeDiv(idisp_back2ay,"disp_back2ay")
	idisp_back2ay=0;
	document.getElementById("map").style.display="block";
//	document.getElementById("disp_deselect_button").style.display="block";
//	document.getElementById("disp_deselect_Ayears").style.display="block";
//	document.getElementById("disp_prcs_Ayears").style.display="block";

//alert('enter tsReset(): firstmnth='+firstmnth);
//	clear the grid selection
//alert('call tsClearGrids(0)');
	tsClearGrids(0);  // resets  tsNselg to 0 and tsgrids.length=0
//	reset month1 selection to theaMnth 
	document.forms["firstmnth_form"].selectfirstmo.selectedIndex=0;
//	remove the month range display on the map
//alert('removing disp_mnth_range');
//	removeDiv(idisp_mnth_range,"disp_mnth_range")
//	idisp_mnth_range=0;
//	remove the time series overlay
//alert('removing theCanvasTS');
	removeDiv(itheCanvasTS,"theCanvasTS")
	itheCanvasTS=0;
//	remove the time-series background and the "process analogs" button
//alert('removing disp_ts_bkgrnd');
	removeDiv(idisp_ts_bkgrnd,"disp_ts_bkgrnd")
	idisp_ts_bkgrnd=0;
//alert('setting disp_mnth_range display to none');
	document.getElementById("disp_mnth_range").style.display="none";
//alert('setting disp_prcs_Ayears display to none');
	document.getElementById("disp_prcs_Ayears").style.display="none";
//alert('setting disp_deselect_Ayears display to none');
	document.getElementById("disp_deselect_Ayears").style.display="none";
//alert('setting disp_deselect_button display to none');
	document.getElementById("disp_deselect_button").style.display="none";

//	show the grid overlay, and register/process button and clear grid button
//alert('setting disp_tsgrid_ovrlay display to block');
	document.getElementById("disp_tsgrid_ovrlay").style.display="block";
//alert('setting disp_prcs_detachB display to block');
	document.getElementById("disp_prcs_detachB").style.display="block";
//alert('setting disp_clear_grids display to block');
	document.getElementById("disp_clear_grids").style.display="block";
//alert('setting disp_detrend_grids display to block');
	document.getElementById("disp_detrend_grids").style.display="block";


}  // tsReset
/////////////////////////////////////// createTSgridImap /////////////////////////////
function createTSgridImap() {
//
//	this function displays the imap containing all grids and process controls for
//	selecting one or more grids for averaging

//	remove previous timeseries grid imap
	removeDiv(idisp_tsgrid_ovrlay,"disp_tsgrid_ovrlay")
	idisp_tsgrid_ovrlay=0;

//	remove Detach Map button
	removeDiv(idisp_detachB,"disp_detachB")
	idisp_detachB=0;

//	creating tsgrid imap
//alert('creating tsgrid imap');
var dmap = document.createElement('div');
var divIdName = "disp_tsgrid_ovrlay";
dmap.setAttribute('id',divIdName);
dmap.style.width = "770px";
dmap.style.height = "402px";
dmap.style.left = "5px";
dmap.style.top = "10px";
dmap.style.position = "absolute";
dmap.style.z_index = 160;
mtxt = '<table class="map_table" width="770" height="402" border="0" cellpadding="0" cellspacing="0">';
mtxt += '<tr><td valign="top">';
mtxt += '<img class="tspoints_imap" src="data/tspoints_imap.jpg" width="770" height="400" border="0" usemap="#ztspoints_imap" alt=""/>';
mtxt += '<map id="ztspoints_imap" name="ztspoints_imap">';
mtxt += '<area shape="circle" coords=" 30,380,3" href="javascript:selectTSpoints( 1073, 30,380)">';
mtxt += '<area shape="circle" coords=" 35,380,3" href="javascript:selectTSpoints( 1074, 35,380)">';
mtxt += '<area shape="circle" coords=" 40,380,3" href="javascript:selectTSpoints( 1075, 40,380)">';
mtxt += '<area shape="circle" coords=" 45,380,3" href="javascript:selectTSpoints( 1076, 45,380)">';
mtxt += '<area shape="circle" coords=" 50,380,3" href="javascript:selectTSpoints( 1077, 50,380)">';
mtxt += '<area shape="circle" coords=" 56,380,3" href="javascript:selectTSpoints( 1078, 56,380)">';
mtxt += '<area shape="circle" coords=" 61,380,3" href="javascript:selectTSpoints( 1079, 61,380)">';
mtxt += '<area shape="circle" coords=" 66,380,3" href="javascript:selectTSpoints( 1080, 66,380)">';
mtxt += '<area shape="circle" coords=" 71,380,3" href="javascript:selectTSpoints( 1081, 71,380)">';
mtxt += '<area shape="circle" coords=" 76,380,3" href="javascript:selectTSpoints( 1082, 76,380)">';
mtxt += '<area shape="circle" coords=" 81,380,3" href="javascript:selectTSpoints( 1083, 81,380)">';
mtxt += '<area shape="circle" coords=" 86,380,3" href="javascript:selectTSpoints( 1084, 86,380)">';
mtxt += '<area shape="circle" coords=" 91,380,3" href="javascript:selectTSpoints( 1085, 91,380)">';
mtxt += '<area shape="circle" coords=" 96,380,3" href="javascript:selectTSpoints( 1086, 96,380)">';
mtxt += '<area shape="circle" coords="101,380,3" href="javascript:selectTSpoints( 1087,101,380)">';
mtxt += '<area shape="circle" coords="106,380,3" href="javascript:selectTSpoints( 1088,106,380)">';
mtxt += '<area shape="circle" coords="112,380,3" href="javascript:selectTSpoints( 1089,112,380)">';
mtxt += '<area shape="circle" coords="117,380,3" href="javascript:selectTSpoints( 1090,117,380)">';
mtxt += '<area shape="circle" coords="122,380,3" href="javascript:selectTSpoints( 1091,122,380)">';
mtxt += '<area shape="circle" coords="127,380,3" href="javascript:selectTSpoints( 1092,127,380)">';
mtxt += '<area shape="circle" coords="132,380,3" href="javascript:selectTSpoints( 1093,132,380)">';
mtxt += '<area shape="circle" coords="137,380,3" href="javascript:selectTSpoints( 1094,137,380)">';
mtxt += '<area shape="circle" coords="142,380,3" href="javascript:selectTSpoints( 1095,142,380)">';
mtxt += '<area shape="circle" coords="147,380,3" href="javascript:selectTSpoints( 1096,147,380)">';
mtxt += '<area shape="circle" coords="152,380,3" href="javascript:selectTSpoints( 1097,152,380)">';
mtxt += '<area shape="circle" coords="157,380,3" href="javascript:selectTSpoints( 1098,157,380)">';
mtxt += '<area shape="circle" coords="162,380,3" href="javascript:selectTSpoints( 1099,162,380)">';
mtxt += '<area shape="circle" coords="168,380,3" href="javascript:selectTSpoints( 1100,168,380)">';
mtxt += '<area shape="circle" coords="173,380,3" href="javascript:selectTSpoints( 1101,173,380)">';
mtxt += '<area shape="circle" coords="178,380,3" href="javascript:selectTSpoints( 1102,178,380)">';
mtxt += '<area shape="circle" coords="183,380,3" href="javascript:selectTSpoints( 1103,183,380)">';
mtxt += '<area shape="circle" coords="188,380,3" href="javascript:selectTSpoints( 1104,188,380)">';
mtxt += '<area shape="circle" coords="193,380,3" href="javascript:selectTSpoints( 1105,193,380)">';
mtxt += '<area shape="circle" coords="198,380,3" href="javascript:selectTSpoints( 1106,198,380)">';
mtxt += '<area shape="circle" coords="203,380,3" href="javascript:selectTSpoints( 1107,203,380)">';
mtxt += '<area shape="circle" coords="208,380,3" href="javascript:selectTSpoints( 1108,208,380)">';
mtxt += '<area shape="circle" coords="213,380,3" href="javascript:selectTSpoints( 1109,213,380)">';
mtxt += '<area shape="circle" coords="218,380,3" href="javascript:selectTSpoints( 1110,218,380)">';
mtxt += '<area shape="circle" coords="224,380,3" href="javascript:selectTSpoints( 1111,224,380)">';
mtxt += '<area shape="circle" coords="229,380,3" href="javascript:selectTSpoints( 1112,229,380)">';
mtxt += '<area shape="circle" coords="234,380,3" href="javascript:selectTSpoints( 1113,234,380)">';
mtxt += '<area shape="circle" coords="239,380,3" href="javascript:selectTSpoints( 1114,239,380)">';
mtxt += '<area shape="circle" coords="244,380,3" href="javascript:selectTSpoints( 1115,244,380)">';
mtxt += '<area shape="circle" coords="249,380,3" href="javascript:selectTSpoints( 1116,249,380)">';
mtxt += '<area shape="circle" coords="254,380,3" href="javascript:selectTSpoints( 1117,254,380)">';
mtxt += '<area shape="circle" coords="259,380,3" href="javascript:selectTSpoints( 1118,259,380)">';
mtxt += '<area shape="circle" coords="264,380,3" href="javascript:selectTSpoints( 1119,264,380)">';
mtxt += '<area shape="circle" coords="269,380,3" href="javascript:selectTSpoints( 1120,269,380)">';
mtxt += '<area shape="circle" coords="274,380,3" href="javascript:selectTSpoints( 1121,274,380)">';
mtxt += '<area shape="circle" coords="280,380,3" href="javascript:selectTSpoints( 1122,280,380)">';
mtxt += '<area shape="circle" coords="285,380,3" href="javascript:selectTSpoints( 1123,285,380)">';
mtxt += '<area shape="circle" coords="290,380,3" href="javascript:selectTSpoints( 1124,290,380)">';
mtxt += '<area shape="circle" coords="295,380,3" href="javascript:selectTSpoints( 1125,295,380)">';
mtxt += '<area shape="circle" coords="300,380,3" href="javascript:selectTSpoints( 1126,300,380)">';
mtxt += '<area shape="circle" coords="305,380,3" href="javascript:selectTSpoints( 1127,305,380)">';
mtxt += '<area shape="circle" coords="310,380,3" href="javascript:selectTSpoints( 1128,310,380)">';
mtxt += '<area shape="circle" coords="315,380,3" href="javascript:selectTSpoints( 1129,315,380)">';
mtxt += '<area shape="circle" coords="320,380,3" href="javascript:selectTSpoints( 1130,320,380)">';
mtxt += '<area shape="circle" coords="325,380,3" href="javascript:selectTSpoints( 1131,325,380)">';
mtxt += '<area shape="circle" coords="330,380,3" href="javascript:selectTSpoints( 1132,330,380)">';
mtxt += '<area shape="circle" coords="336,380,3" href="javascript:selectTSpoints( 1133,336,380)">';
mtxt += '<area shape="circle" coords="341,380,3" href="javascript:selectTSpoints( 1134,341,380)">';
mtxt += '<area shape="circle" coords="346,380,3" href="javascript:selectTSpoints( 1135,346,380)">';
mtxt += '<area shape="circle" coords="351,380,3" href="javascript:selectTSpoints( 1136,351,380)">';
mtxt += '<area shape="circle" coords="356,380,3" href="javascript:selectTSpoints( 1137,356,380)">';
mtxt += '<area shape="circle" coords="361,380,3" href="javascript:selectTSpoints( 1138,361,380)">';
mtxt += '<area shape="circle" coords="366,380,3" href="javascript:selectTSpoints( 1139,366,380)">';
mtxt += '<area shape="circle" coords="371,380,3" href="javascript:selectTSpoints( 1140,371,380)">';
mtxt += '<area shape="circle" coords="376,380,3" href="javascript:selectTSpoints( 1141,376,380)">';
mtxt += '<area shape="circle" coords="381,380,3" href="javascript:selectTSpoints( 1142,381,380)">';
mtxt += '<area shape="circle" coords="386,380,3" href="javascript:selectTSpoints( 1143,386,380)">';
mtxt += '<area shape="circle" coords="392,380,3" href="javascript:selectTSpoints( 1144,392,380)">';
mtxt += '<area shape="circle" coords="397,380,3" href="javascript:selectTSpoints( 1001,397,380)">';
mtxt += '<area shape="circle" coords="402,380,3" href="javascript:selectTSpoints( 1002,402,380)">';
mtxt += '<area shape="circle" coords="407,380,3" href="javascript:selectTSpoints( 1003,407,380)">';
mtxt += '<area shape="circle" coords="412,380,3" href="javascript:selectTSpoints( 1004,412,380)">';
mtxt += '<area shape="circle" coords="417,380,3" href="javascript:selectTSpoints( 1005,417,380)">';
mtxt += '<area shape="circle" coords="422,380,3" href="javascript:selectTSpoints( 1006,422,380)">';
mtxt += '<area shape="circle" coords="427,380,3" href="javascript:selectTSpoints( 1007,427,380)">';
mtxt += '<area shape="circle" coords="432,380,3" href="javascript:selectTSpoints( 1008,432,380)">';
mtxt += '<area shape="circle" coords="437,380,3" href="javascript:selectTSpoints( 1009,437,380)">';
mtxt += '<area shape="circle" coords="442,380,3" href="javascript:selectTSpoints( 1010,442,380)">';
mtxt += '<area shape="circle" coords="447,380,3" href="javascript:selectTSpoints( 1011,447,380)">';
mtxt += '<area shape="circle" coords="453,380,3" href="javascript:selectTSpoints( 1012,453,380)">';
mtxt += '<area shape="circle" coords="458,380,3" href="javascript:selectTSpoints( 1013,458,380)">';
mtxt += '<area shape="circle" coords="463,380,3" href="javascript:selectTSpoints( 1014,463,380)">';
mtxt += '<area shape="circle" coords="468,380,3" href="javascript:selectTSpoints( 1015,468,380)">';
mtxt += '<area shape="circle" coords="473,380,3" href="javascript:selectTSpoints( 1016,473,380)">';
mtxt += '<area shape="circle" coords="478,380,3" href="javascript:selectTSpoints( 1017,478,380)">';
mtxt += '<area shape="circle" coords="483,380,3" href="javascript:selectTSpoints( 1018,483,380)">';
mtxt += '<area shape="circle" coords="488,380,3" href="javascript:selectTSpoints( 1019,488,380)">';
mtxt += '<area shape="circle" coords="493,380,3" href="javascript:selectTSpoints( 1020,493,380)">';
mtxt += '<area shape="circle" coords="498,380,3" href="javascript:selectTSpoints( 1021,498,380)">';
mtxt += '<area shape="circle" coords="503,380,3" href="javascript:selectTSpoints( 1022,503,380)">';
mtxt += '<area shape="circle" coords="509,380,3" href="javascript:selectTSpoints( 1023,509,380)">';
mtxt += '<area shape="circle" coords="514,380,3" href="javascript:selectTSpoints( 1024,514,380)">';
mtxt += '<area shape="circle" coords="519,380,3" href="javascript:selectTSpoints( 1025,519,380)">';
mtxt += '<area shape="circle" coords="524,380,3" href="javascript:selectTSpoints( 1026,524,380)">';
mtxt += '<area shape="circle" coords="529,380,3" href="javascript:selectTSpoints( 1027,529,380)">';
mtxt += '<area shape="circle" coords="534,380,3" href="javascript:selectTSpoints( 1028,534,380)">';
mtxt += '<area shape="circle" coords="539,380,3" href="javascript:selectTSpoints( 1029,539,380)">';
mtxt += '<area shape="circle" coords="544,380,3" href="javascript:selectTSpoints( 1030,544,380)">';
mtxt += '<area shape="circle" coords="549,380,3" href="javascript:selectTSpoints( 1031,549,380)">';
mtxt += '<area shape="circle" coords="554,380,3" href="javascript:selectTSpoints( 1032,554,380)">';
mtxt += '<area shape="circle" coords="559,380,3" href="javascript:selectTSpoints( 1033,559,380)">';
mtxt += '<area shape="circle" coords="565,380,3" href="javascript:selectTSpoints( 1034,565,380)">';
mtxt += '<area shape="circle" coords="570,380,3" href="javascript:selectTSpoints( 1035,570,380)">';
mtxt += '<area shape="circle" coords="575,380,3" href="javascript:selectTSpoints( 1036,575,380)">';
mtxt += '<area shape="circle" coords="580,380,3" href="javascript:selectTSpoints( 1037,580,380)">';
mtxt += '<area shape="circle" coords="585,380,3" href="javascript:selectTSpoints( 1038,585,380)">';
mtxt += '<area shape="circle" coords="590,380,3" href="javascript:selectTSpoints( 1039,590,380)">';
mtxt += '<area shape="circle" coords="595,380,3" href="javascript:selectTSpoints( 1040,595,380)">';
mtxt += '<area shape="circle" coords="600,380,3" href="javascript:selectTSpoints( 1041,600,380)">';
mtxt += '<area shape="circle" coords="605,380,3" href="javascript:selectTSpoints( 1042,605,380)">';
mtxt += '<area shape="circle" coords="610,380,3" href="javascript:selectTSpoints( 1043,610,380)">';
mtxt += '<area shape="circle" coords="615,380,3" href="javascript:selectTSpoints( 1044,615,380)">';
mtxt += '<area shape="circle" coords="621,380,3" href="javascript:selectTSpoints( 1045,621,380)">';
mtxt += '<area shape="circle" coords="626,380,3" href="javascript:selectTSpoints( 1046,626,380)">';
mtxt += '<area shape="circle" coords="631,380,3" href="javascript:selectTSpoints( 1047,631,380)">';
mtxt += '<area shape="circle" coords="636,380,3" href="javascript:selectTSpoints( 1048,636,380)">';
mtxt += '<area shape="circle" coords="641,380,3" href="javascript:selectTSpoints( 1049,641,380)">';
mtxt += '<area shape="circle" coords="646,380,3" href="javascript:selectTSpoints( 1050,646,380)">';
mtxt += '<area shape="circle" coords="651,380,3" href="javascript:selectTSpoints( 1051,651,380)">';
mtxt += '<area shape="circle" coords="656,380,3" href="javascript:selectTSpoints( 1052,656,380)">';
mtxt += '<area shape="circle" coords="661,380,3" href="javascript:selectTSpoints( 1053,661,380)">';
mtxt += '<area shape="circle" coords="666,380,3" href="javascript:selectTSpoints( 1054,666,380)">';
mtxt += '<area shape="circle" coords="671,380,3" href="javascript:selectTSpoints( 1055,671,380)">';
mtxt += '<area shape="circle" coords="677,380,3" href="javascript:selectTSpoints( 1056,677,380)">';
mtxt += '<area shape="circle" coords="682,380,3" href="javascript:selectTSpoints( 1057,682,380)">';
mtxt += '<area shape="circle" coords="687,380,3" href="javascript:selectTSpoints( 1058,687,380)">';
mtxt += '<area shape="circle" coords="692,380,3" href="javascript:selectTSpoints( 1059,692,380)">';
mtxt += '<area shape="circle" coords="697,380,3" href="javascript:selectTSpoints( 1060,697,380)">';
mtxt += '<area shape="circle" coords="702,380,3" href="javascript:selectTSpoints( 1061,702,380)">';
mtxt += '<area shape="circle" coords="707,380,3" href="javascript:selectTSpoints( 1062,707,380)">';
mtxt += '<area shape="circle" coords="712,380,3" href="javascript:selectTSpoints( 1063,712,380)">';
mtxt += '<area shape="circle" coords="717,380,3" href="javascript:selectTSpoints( 1064,717,380)">';
mtxt += '<area shape="circle" coords="722,380,3" href="javascript:selectTSpoints( 1065,722,380)">';
mtxt += '<area shape="circle" coords="727,380,3" href="javascript:selectTSpoints( 1066,727,380)">';
mtxt += '<area shape="circle" coords="733,380,3" href="javascript:selectTSpoints( 1067,733,380)">';
mtxt += '<area shape="circle" coords="738,380,3" href="javascript:selectTSpoints( 1068,738,380)">';
mtxt += '<area shape="circle" coords="743,380,3" href="javascript:selectTSpoints( 1069,743,380)">';
mtxt += '<area shape="circle" coords="748,380,3" href="javascript:selectTSpoints( 1070,748,380)">';
mtxt += '<area shape="circle" coords="753,380,3" href="javascript:selectTSpoints( 1071,753,380)">';
mtxt += '<area shape="circle" coords="758,380,3" href="javascript:selectTSpoints( 1072,758,380)">';
mtxt += '<area shape="circle" coords=" 30,375,3" href="javascript:selectTSpoints( 2073, 30,375)">';
mtxt += '<area shape="circle" coords=" 35,375,3" href="javascript:selectTSpoints( 2074, 35,375)">';
mtxt += '<area shape="circle" coords=" 40,375,3" href="javascript:selectTSpoints( 2075, 40,375)">';
mtxt += '<area shape="circle" coords=" 45,375,3" href="javascript:selectTSpoints( 2076, 45,375)">';
mtxt += '<area shape="circle" coords=" 50,375,3" href="javascript:selectTSpoints( 2077, 50,375)">';
mtxt += '<area shape="circle" coords=" 56,375,3" href="javascript:selectTSpoints( 2078, 56,375)">';
mtxt += '<area shape="circle" coords=" 61,375,3" href="javascript:selectTSpoints( 2079, 61,375)">';
mtxt += '<area shape="circle" coords=" 66,375,3" href="javascript:selectTSpoints( 2080, 66,375)">';
mtxt += '<area shape="circle" coords=" 71,375,3" href="javascript:selectTSpoints( 2081, 71,375)">';
mtxt += '<area shape="circle" coords=" 76,375,3" href="javascript:selectTSpoints( 2082, 76,375)">';
mtxt += '<area shape="circle" coords=" 81,375,3" href="javascript:selectTSpoints( 2083, 81,375)">';
mtxt += '<area shape="circle" coords=" 86,375,3" href="javascript:selectTSpoints( 2084, 86,375)">';
mtxt += '<area shape="circle" coords=" 91,375,3" href="javascript:selectTSpoints( 2085, 91,375)">';
mtxt += '<area shape="circle" coords=" 96,375,3" href="javascript:selectTSpoints( 2086, 96,375)">';
mtxt += '<area shape="circle" coords="101,375,3" href="javascript:selectTSpoints( 2087,101,375)">';
mtxt += '<area shape="circle" coords="106,375,3" href="javascript:selectTSpoints( 2088,106,375)">';
mtxt += '<area shape="circle" coords="112,375,3" href="javascript:selectTSpoints( 2089,112,375)">';
mtxt += '<area shape="circle" coords="117,375,3" href="javascript:selectTSpoints( 2090,117,375)">';
mtxt += '<area shape="circle" coords="122,375,3" href="javascript:selectTSpoints( 2091,122,375)">';
mtxt += '<area shape="circle" coords="127,375,3" href="javascript:selectTSpoints( 2092,127,375)">';
mtxt += '<area shape="circle" coords="132,375,3" href="javascript:selectTSpoints( 2093,132,375)">';
mtxt += '<area shape="circle" coords="137,375,3" href="javascript:selectTSpoints( 2094,137,375)">';
mtxt += '<area shape="circle" coords="142,375,3" href="javascript:selectTSpoints( 2095,142,375)">';
mtxt += '<area shape="circle" coords="147,375,3" href="javascript:selectTSpoints( 2096,147,375)">';
mtxt += '<area shape="circle" coords="152,375,3" href="javascript:selectTSpoints( 2097,152,375)">';
mtxt += '<area shape="circle" coords="157,375,3" href="javascript:selectTSpoints( 2098,157,375)">';
mtxt += '<area shape="circle" coords="162,375,3" href="javascript:selectTSpoints( 2099,162,375)">';
mtxt += '<area shape="circle" coords="168,375,3" href="javascript:selectTSpoints( 2100,168,375)">';
mtxt += '<area shape="circle" coords="173,375,3" href="javascript:selectTSpoints( 2101,173,375)">';
mtxt += '<area shape="circle" coords="178,375,3" href="javascript:selectTSpoints( 2102,178,375)">';
mtxt += '<area shape="circle" coords="183,375,3" href="javascript:selectTSpoints( 2103,183,375)">';
mtxt += '<area shape="circle" coords="188,375,3" href="javascript:selectTSpoints( 2104,188,375)">';
mtxt += '<area shape="circle" coords="193,375,3" href="javascript:selectTSpoints( 2105,193,375)">';
mtxt += '<area shape="circle" coords="198,375,3" href="javascript:selectTSpoints( 2106,198,375)">';
mtxt += '<area shape="circle" coords="203,375,3" href="javascript:selectTSpoints( 2107,203,375)">';
mtxt += '<area shape="circle" coords="208,375,3" href="javascript:selectTSpoints( 2108,208,375)">';
mtxt += '<area shape="circle" coords="213,375,3" href="javascript:selectTSpoints( 2109,213,375)">';
mtxt += '<area shape="circle" coords="218,375,3" href="javascript:selectTSpoints( 2110,218,375)">';
mtxt += '<area shape="circle" coords="224,375,3" href="javascript:selectTSpoints( 2111,224,375)">';
mtxt += '<area shape="circle" coords="229,375,3" href="javascript:selectTSpoints( 2112,229,375)">';
mtxt += '<area shape="circle" coords="234,375,3" href="javascript:selectTSpoints( 2113,234,375)">';
mtxt += '<area shape="circle" coords="239,375,3" href="javascript:selectTSpoints( 2114,239,375)">';
mtxt += '<area shape="circle" coords="244,375,3" href="javascript:selectTSpoints( 2115,244,375)">';
mtxt += '<area shape="circle" coords="249,375,3" href="javascript:selectTSpoints( 2116,249,375)">';
mtxt += '<area shape="circle" coords="254,375,3" href="javascript:selectTSpoints( 2117,254,375)">';
mtxt += '<area shape="circle" coords="259,375,3" href="javascript:selectTSpoints( 2118,259,375)">';
mtxt += '<area shape="circle" coords="264,375,3" href="javascript:selectTSpoints( 2119,264,375)">';
mtxt += '<area shape="circle" coords="269,375,3" href="javascript:selectTSpoints( 2120,269,375)">';
mtxt += '<area shape="circle" coords="274,375,3" href="javascript:selectTSpoints( 2121,274,375)">';
mtxt += '<area shape="circle" coords="280,375,3" href="javascript:selectTSpoints( 2122,280,375)">';
mtxt += '<area shape="circle" coords="285,375,3" href="javascript:selectTSpoints( 2123,285,375)">';
mtxt += '<area shape="circle" coords="290,375,3" href="javascript:selectTSpoints( 2124,290,375)">';
mtxt += '<area shape="circle" coords="295,375,3" href="javascript:selectTSpoints( 2125,295,375)">';
mtxt += '<area shape="circle" coords="300,375,3" href="javascript:selectTSpoints( 2126,300,375)">';
mtxt += '<area shape="circle" coords="305,375,3" href="javascript:selectTSpoints( 2127,305,375)">';
mtxt += '<area shape="circle" coords="310,375,3" href="javascript:selectTSpoints( 2128,310,375)">';
mtxt += '<area shape="circle" coords="315,375,3" href="javascript:selectTSpoints( 2129,315,375)">';
mtxt += '<area shape="circle" coords="320,375,3" href="javascript:selectTSpoints( 2130,320,375)">';
mtxt += '<area shape="circle" coords="325,375,3" href="javascript:selectTSpoints( 2131,325,375)">';
mtxt += '<area shape="circle" coords="330,375,3" href="javascript:selectTSpoints( 2132,330,375)">';
mtxt += '<area shape="circle" coords="336,375,3" href="javascript:selectTSpoints( 2133,336,375)">';
mtxt += '<area shape="circle" coords="341,375,3" href="javascript:selectTSpoints( 2134,341,375)">';
mtxt += '<area shape="circle" coords="346,375,3" href="javascript:selectTSpoints( 2135,346,375)">';
mtxt += '<area shape="circle" coords="351,375,3" href="javascript:selectTSpoints( 2136,351,375)">';
mtxt += '<area shape="circle" coords="356,375,3" href="javascript:selectTSpoints( 2137,356,375)">';
mtxt += '<area shape="circle" coords="361,375,3" href="javascript:selectTSpoints( 2138,361,375)">';
mtxt += '<area shape="circle" coords="366,375,3" href="javascript:selectTSpoints( 2139,366,375)">';
mtxt += '<area shape="circle" coords="371,375,3" href="javascript:selectTSpoints( 2140,371,375)">';
mtxt += '<area shape="circle" coords="376,375,3" href="javascript:selectTSpoints( 2141,376,375)">';
mtxt += '<area shape="circle" coords="381,375,3" href="javascript:selectTSpoints( 2142,381,375)">';
mtxt += '<area shape="circle" coords="386,375,3" href="javascript:selectTSpoints( 2143,386,375)">';
mtxt += '<area shape="circle" coords="392,375,3" href="javascript:selectTSpoints( 2144,392,375)">';
mtxt += '<area shape="circle" coords="397,375,3" href="javascript:selectTSpoints( 2001,397,375)">';
mtxt += '<area shape="circle" coords="402,375,3" href="javascript:selectTSpoints( 2002,402,375)">';
mtxt += '<area shape="circle" coords="407,375,3" href="javascript:selectTSpoints( 2003,407,375)">';
mtxt += '<area shape="circle" coords="412,375,3" href="javascript:selectTSpoints( 2004,412,375)">';
mtxt += '<area shape="circle" coords="417,375,3" href="javascript:selectTSpoints( 2005,417,375)">';
mtxt += '<area shape="circle" coords="422,375,3" href="javascript:selectTSpoints( 2006,422,375)">';
mtxt += '<area shape="circle" coords="427,375,3" href="javascript:selectTSpoints( 2007,427,375)">';
mtxt += '<area shape="circle" coords="432,375,3" href="javascript:selectTSpoints( 2008,432,375)">';
mtxt += '<area shape="circle" coords="437,375,3" href="javascript:selectTSpoints( 2009,437,375)">';
mtxt += '<area shape="circle" coords="442,375,3" href="javascript:selectTSpoints( 2010,442,375)">';
mtxt += '<area shape="circle" coords="447,375,3" href="javascript:selectTSpoints( 2011,447,375)">';
mtxt += '<area shape="circle" coords="453,375,3" href="javascript:selectTSpoints( 2012,453,375)">';
mtxt += '<area shape="circle" coords="458,375,3" href="javascript:selectTSpoints( 2013,458,375)">';
mtxt += '<area shape="circle" coords="463,375,3" href="javascript:selectTSpoints( 2014,463,375)">';
mtxt += '<area shape="circle" coords="468,375,3" href="javascript:selectTSpoints( 2015,468,375)">';
mtxt += '<area shape="circle" coords="473,375,3" href="javascript:selectTSpoints( 2016,473,375)">';
mtxt += '<area shape="circle" coords="478,375,3" href="javascript:selectTSpoints( 2017,478,375)">';
mtxt += '<area shape="circle" coords="483,375,3" href="javascript:selectTSpoints( 2018,483,375)">';
mtxt += '<area shape="circle" coords="488,375,3" href="javascript:selectTSpoints( 2019,488,375)">';
mtxt += '<area shape="circle" coords="493,375,3" href="javascript:selectTSpoints( 2020,493,375)">';
mtxt += '<area shape="circle" coords="498,375,3" href="javascript:selectTSpoints( 2021,498,375)">';
mtxt += '<area shape="circle" coords="503,375,3" href="javascript:selectTSpoints( 2022,503,375)">';
mtxt += '<area shape="circle" coords="509,375,3" href="javascript:selectTSpoints( 2023,509,375)">';
mtxt += '<area shape="circle" coords="514,375,3" href="javascript:selectTSpoints( 2024,514,375)">';
mtxt += '<area shape="circle" coords="519,375,3" href="javascript:selectTSpoints( 2025,519,375)">';
mtxt += '<area shape="circle" coords="524,375,3" href="javascript:selectTSpoints( 2026,524,375)">';
mtxt += '<area shape="circle" coords="529,375,3" href="javascript:selectTSpoints( 2027,529,375)">';
mtxt += '<area shape="circle" coords="534,375,3" href="javascript:selectTSpoints( 2028,534,375)">';
mtxt += '<area shape="circle" coords="539,375,3" href="javascript:selectTSpoints( 2029,539,375)">';
mtxt += '<area shape="circle" coords="544,375,3" href="javascript:selectTSpoints( 2030,544,375)">';
mtxt += '<area shape="circle" coords="549,375,3" href="javascript:selectTSpoints( 2031,549,375)">';
mtxt += '<area shape="circle" coords="554,375,3" href="javascript:selectTSpoints( 2032,554,375)">';
mtxt += '<area shape="circle" coords="559,375,3" href="javascript:selectTSpoints( 2033,559,375)">';
mtxt += '<area shape="circle" coords="565,375,3" href="javascript:selectTSpoints( 2034,565,375)">';
mtxt += '<area shape="circle" coords="570,375,3" href="javascript:selectTSpoints( 2035,570,375)">';
mtxt += '<area shape="circle" coords="575,375,3" href="javascript:selectTSpoints( 2036,575,375)">';
mtxt += '<area shape="circle" coords="580,375,3" href="javascript:selectTSpoints( 2037,580,375)">';
mtxt += '<area shape="circle" coords="585,375,3" href="javascript:selectTSpoints( 2038,585,375)">';
mtxt += '<area shape="circle" coords="590,375,3" href="javascript:selectTSpoints( 2039,590,375)">';
mtxt += '<area shape="circle" coords="595,375,3" href="javascript:selectTSpoints( 2040,595,375)">';
mtxt += '<area shape="circle" coords="600,375,3" href="javascript:selectTSpoints( 2041,600,375)">';
mtxt += '<area shape="circle" coords="605,375,3" href="javascript:selectTSpoints( 2042,605,375)">';
mtxt += '<area shape="circle" coords="610,375,3" href="javascript:selectTSpoints( 2043,610,375)">';
mtxt += '<area shape="circle" coords="615,375,3" href="javascript:selectTSpoints( 2044,615,375)">';
mtxt += '<area shape="circle" coords="621,375,3" href="javascript:selectTSpoints( 2045,621,375)">';
mtxt += '<area shape="circle" coords="626,375,3" href="javascript:selectTSpoints( 2046,626,375)">';
mtxt += '<area shape="circle" coords="631,375,3" href="javascript:selectTSpoints( 2047,631,375)">';
mtxt += '<area shape="circle" coords="636,375,3" href="javascript:selectTSpoints( 2048,636,375)">';
mtxt += '<area shape="circle" coords="641,375,3" href="javascript:selectTSpoints( 2049,641,375)">';
mtxt += '<area shape="circle" coords="646,375,3" href="javascript:selectTSpoints( 2050,646,375)">';
mtxt += '<area shape="circle" coords="651,375,3" href="javascript:selectTSpoints( 2051,651,375)">';
mtxt += '<area shape="circle" coords="656,375,3" href="javascript:selectTSpoints( 2052,656,375)">';
mtxt += '<area shape="circle" coords="661,375,3" href="javascript:selectTSpoints( 2053,661,375)">';
mtxt += '<area shape="circle" coords="666,375,3" href="javascript:selectTSpoints( 2054,666,375)">';
mtxt += '<area shape="circle" coords="671,375,3" href="javascript:selectTSpoints( 2055,671,375)">';
mtxt += '<area shape="circle" coords="677,375,3" href="javascript:selectTSpoints( 2056,677,375)">';
mtxt += '<area shape="circle" coords="682,375,3" href="javascript:selectTSpoints( 2057,682,375)">';
mtxt += '<area shape="circle" coords="687,375,3" href="javascript:selectTSpoints( 2058,687,375)">';
mtxt += '<area shape="circle" coords="692,375,3" href="javascript:selectTSpoints( 2059,692,375)">';
mtxt += '<area shape="circle" coords="697,375,3" href="javascript:selectTSpoints( 2060,697,375)">';
mtxt += '<area shape="circle" coords="702,375,3" href="javascript:selectTSpoints( 2061,702,375)">';
mtxt += '<area shape="circle" coords="707,375,3" href="javascript:selectTSpoints( 2062,707,375)">';
mtxt += '<area shape="circle" coords="712,375,3" href="javascript:selectTSpoints( 2063,712,375)">';
mtxt += '<area shape="circle" coords="717,375,3" href="javascript:selectTSpoints( 2064,717,375)">';
mtxt += '<area shape="circle" coords="722,375,3" href="javascript:selectTSpoints( 2065,722,375)">';
mtxt += '<area shape="circle" coords="727,375,3" href="javascript:selectTSpoints( 2066,727,375)">';
mtxt += '<area shape="circle" coords="733,375,3" href="javascript:selectTSpoints( 2067,733,375)">';
mtxt += '<area shape="circle" coords="738,375,3" href="javascript:selectTSpoints( 2068,738,375)">';
mtxt += '<area shape="circle" coords="743,375,3" href="javascript:selectTSpoints( 2069,743,375)">';
mtxt += '<area shape="circle" coords="748,375,3" href="javascript:selectTSpoints( 2070,748,375)">';
mtxt += '<area shape="circle" coords="753,375,3" href="javascript:selectTSpoints( 2071,753,375)">';
mtxt += '<area shape="circle" coords="758,375,3" href="javascript:selectTSpoints( 2072,758,375)">';
mtxt += '<area shape="circle" coords=" 30,370,3" href="javascript:selectTSpoints( 3073, 30,370)">';
mtxt += '<area shape="circle" coords=" 35,370,3" href="javascript:selectTSpoints( 3074, 35,370)">';
mtxt += '<area shape="circle" coords=" 40,370,3" href="javascript:selectTSpoints( 3075, 40,370)">';
mtxt += '<area shape="circle" coords=" 45,370,3" href="javascript:selectTSpoints( 3076, 45,370)">';
mtxt += '<area shape="circle" coords=" 50,370,3" href="javascript:selectTSpoints( 3077, 50,370)">';
mtxt += '<area shape="circle" coords=" 56,370,3" href="javascript:selectTSpoints( 3078, 56,370)">';
mtxt += '<area shape="circle" coords=" 61,370,3" href="javascript:selectTSpoints( 3079, 61,370)">';
mtxt += '<area shape="circle" coords=" 66,370,3" href="javascript:selectTSpoints( 3080, 66,370)">';
mtxt += '<area shape="circle" coords=" 71,370,3" href="javascript:selectTSpoints( 3081, 71,370)">';
mtxt += '<area shape="circle" coords=" 76,370,3" href="javascript:selectTSpoints( 3082, 76,370)">';
mtxt += '<area shape="circle" coords=" 81,370,3" href="javascript:selectTSpoints( 3083, 81,370)">';
mtxt += '<area shape="circle" coords=" 86,370,3" href="javascript:selectTSpoints( 3084, 86,370)">';
mtxt += '<area shape="circle" coords=" 91,370,3" href="javascript:selectTSpoints( 3085, 91,370)">';
mtxt += '<area shape="circle" coords=" 96,370,3" href="javascript:selectTSpoints( 3086, 96,370)">';
mtxt += '<area shape="circle" coords="101,370,3" href="javascript:selectTSpoints( 3087,101,370)">';
mtxt += '<area shape="circle" coords="106,370,3" href="javascript:selectTSpoints( 3088,106,370)">';
mtxt += '<area shape="circle" coords="112,370,3" href="javascript:selectTSpoints( 3089,112,370)">';
mtxt += '<area shape="circle" coords="117,370,3" href="javascript:selectTSpoints( 3090,117,370)">';
mtxt += '<area shape="circle" coords="122,370,3" href="javascript:selectTSpoints( 3091,122,370)">';
mtxt += '<area shape="circle" coords="127,370,3" href="javascript:selectTSpoints( 3092,127,370)">';
mtxt += '<area shape="circle" coords="132,370,3" href="javascript:selectTSpoints( 3093,132,370)">';
mtxt += '<area shape="circle" coords="137,370,3" href="javascript:selectTSpoints( 3094,137,370)">';
mtxt += '<area shape="circle" coords="142,370,3" href="javascript:selectTSpoints( 3095,142,370)">';
mtxt += '<area shape="circle" coords="147,370,3" href="javascript:selectTSpoints( 3096,147,370)">';
mtxt += '<area shape="circle" coords="152,370,3" href="javascript:selectTSpoints( 3097,152,370)">';
mtxt += '<area shape="circle" coords="157,370,3" href="javascript:selectTSpoints( 3098,157,370)">';
mtxt += '<area shape="circle" coords="162,370,3" href="javascript:selectTSpoints( 3099,162,370)">';
mtxt += '<area shape="circle" coords="168,370,3" href="javascript:selectTSpoints( 3100,168,370)">';
mtxt += '<area shape="circle" coords="173,370,3" href="javascript:selectTSpoints( 3101,173,370)">';
mtxt += '<area shape="circle" coords="178,370,3" href="javascript:selectTSpoints( 3102,178,370)">';
mtxt += '<area shape="circle" coords="183,370,3" href="javascript:selectTSpoints( 3103,183,370)">';
mtxt += '<area shape="circle" coords="188,370,3" href="javascript:selectTSpoints( 3104,188,370)">';
mtxt += '<area shape="circle" coords="193,370,3" href="javascript:selectTSpoints( 3105,193,370)">';
mtxt += '<area shape="circle" coords="198,370,3" href="javascript:selectTSpoints( 3106,198,370)">';
mtxt += '<area shape="circle" coords="203,370,3" href="javascript:selectTSpoints( 3107,203,370)">';
mtxt += '<area shape="circle" coords="208,370,3" href="javascript:selectTSpoints( 3108,208,370)">';
mtxt += '<area shape="circle" coords="213,370,3" href="javascript:selectTSpoints( 3109,213,370)">';
mtxt += '<area shape="circle" coords="218,370,3" href="javascript:selectTSpoints( 3110,218,370)">';
mtxt += '<area shape="circle" coords="224,370,3" href="javascript:selectTSpoints( 3111,224,370)">';
mtxt += '<area shape="circle" coords="229,370,3" href="javascript:selectTSpoints( 3112,229,370)">';
mtxt += '<area shape="circle" coords="234,370,3" href="javascript:selectTSpoints( 3113,234,370)">';
mtxt += '<area shape="circle" coords="239,370,3" href="javascript:selectTSpoints( 3114,239,370)">';
mtxt += '<area shape="circle" coords="244,370,3" href="javascript:selectTSpoints( 3115,244,370)">';
mtxt += '<area shape="circle" coords="249,370,3" href="javascript:selectTSpoints( 3116,249,370)">';
mtxt += '<area shape="circle" coords="254,370,3" href="javascript:selectTSpoints( 3117,254,370)">';
mtxt += '<area shape="circle" coords="259,370,3" href="javascript:selectTSpoints( 3118,259,370)">';
mtxt += '<area shape="circle" coords="264,370,3" href="javascript:selectTSpoints( 3119,264,370)">';
mtxt += '<area shape="circle" coords="269,370,3" href="javascript:selectTSpoints( 3120,269,370)">';
mtxt += '<area shape="circle" coords="274,370,3" href="javascript:selectTSpoints( 3121,274,370)">';
mtxt += '<area shape="circle" coords="280,370,3" href="javascript:selectTSpoints( 3122,280,370)">';
mtxt += '<area shape="circle" coords="285,370,3" href="javascript:selectTSpoints( 3123,285,370)">';
mtxt += '<area shape="circle" coords="290,370,3" href="javascript:selectTSpoints( 3124,290,370)">';
mtxt += '<area shape="circle" coords="295,370,3" href="javascript:selectTSpoints( 3125,295,370)">';
mtxt += '<area shape="circle" coords="300,370,3" href="javascript:selectTSpoints( 3126,300,370)">';
mtxt += '<area shape="circle" coords="305,370,3" href="javascript:selectTSpoints( 3127,305,370)">';
mtxt += '<area shape="circle" coords="310,370,3" href="javascript:selectTSpoints( 3128,310,370)">';
mtxt += '<area shape="circle" coords="315,370,3" href="javascript:selectTSpoints( 3129,315,370)">';
mtxt += '<area shape="circle" coords="320,370,3" href="javascript:selectTSpoints( 3130,320,370)">';
mtxt += '<area shape="circle" coords="325,370,3" href="javascript:selectTSpoints( 3131,325,370)">';
mtxt += '<area shape="circle" coords="330,370,3" href="javascript:selectTSpoints( 3132,330,370)">';
mtxt += '<area shape="circle" coords="336,370,3" href="javascript:selectTSpoints( 3133,336,370)">';
mtxt += '<area shape="circle" coords="341,370,3" href="javascript:selectTSpoints( 3134,341,370)">';
mtxt += '<area shape="circle" coords="346,370,3" href="javascript:selectTSpoints( 3135,346,370)">';
mtxt += '<area shape="circle" coords="351,370,3" href="javascript:selectTSpoints( 3136,351,370)">';
mtxt += '<area shape="circle" coords="356,370,3" href="javascript:selectTSpoints( 3137,356,370)">';
mtxt += '<area shape="circle" coords="361,370,3" href="javascript:selectTSpoints( 3138,361,370)">';
mtxt += '<area shape="circle" coords="366,370,3" href="javascript:selectTSpoints( 3139,366,370)">';
mtxt += '<area shape="circle" coords="371,370,3" href="javascript:selectTSpoints( 3140,371,370)">';
mtxt += '<area shape="circle" coords="376,370,3" href="javascript:selectTSpoints( 3141,376,370)">';
mtxt += '<area shape="circle" coords="381,370,3" href="javascript:selectTSpoints( 3142,381,370)">';
mtxt += '<area shape="circle" coords="386,370,3" href="javascript:selectTSpoints( 3143,386,370)">';
mtxt += '<area shape="circle" coords="392,370,3" href="javascript:selectTSpoints( 3144,392,370)">';
mtxt += '<area shape="circle" coords="397,370,3" href="javascript:selectTSpoints( 3001,397,370)">';
mtxt += '<area shape="circle" coords="402,370,3" href="javascript:selectTSpoints( 3002,402,370)">';
mtxt += '<area shape="circle" coords="407,370,3" href="javascript:selectTSpoints( 3003,407,370)">';
mtxt += '<area shape="circle" coords="412,370,3" href="javascript:selectTSpoints( 3004,412,370)">';
mtxt += '<area shape="circle" coords="417,370,3" href="javascript:selectTSpoints( 3005,417,370)">';
mtxt += '<area shape="circle" coords="422,370,3" href="javascript:selectTSpoints( 3006,422,370)">';
mtxt += '<area shape="circle" coords="427,370,3" href="javascript:selectTSpoints( 3007,427,370)">';
mtxt += '<area shape="circle" coords="432,370,3" href="javascript:selectTSpoints( 3008,432,370)">';
mtxt += '<area shape="circle" coords="437,370,3" href="javascript:selectTSpoints( 3009,437,370)">';
mtxt += '<area shape="circle" coords="442,370,3" href="javascript:selectTSpoints( 3010,442,370)">';
mtxt += '<area shape="circle" coords="447,370,3" href="javascript:selectTSpoints( 3011,447,370)">';
mtxt += '<area shape="circle" coords="453,370,3" href="javascript:selectTSpoints( 3012,453,370)">';
mtxt += '<area shape="circle" coords="458,370,3" href="javascript:selectTSpoints( 3013,458,370)">';
mtxt += '<area shape="circle" coords="463,370,3" href="javascript:selectTSpoints( 3014,463,370)">';
mtxt += '<area shape="circle" coords="468,370,3" href="javascript:selectTSpoints( 3015,468,370)">';
mtxt += '<area shape="circle" coords="473,370,3" href="javascript:selectTSpoints( 3016,473,370)">';
mtxt += '<area shape="circle" coords="478,370,3" href="javascript:selectTSpoints( 3017,478,370)">';
mtxt += '<area shape="circle" coords="483,370,3" href="javascript:selectTSpoints( 3018,483,370)">';
mtxt += '<area shape="circle" coords="488,370,3" href="javascript:selectTSpoints( 3019,488,370)">';
mtxt += '<area shape="circle" coords="493,370,3" href="javascript:selectTSpoints( 3020,493,370)">';
mtxt += '<area shape="circle" coords="498,370,3" href="javascript:selectTSpoints( 3021,498,370)">';
mtxt += '<area shape="circle" coords="503,370,3" href="javascript:selectTSpoints( 3022,503,370)">';
mtxt += '<area shape="circle" coords="509,370,3" href="javascript:selectTSpoints( 3023,509,370)">';
mtxt += '<area shape="circle" coords="514,370,3" href="javascript:selectTSpoints( 3024,514,370)">';
mtxt += '<area shape="circle" coords="519,370,3" href="javascript:selectTSpoints( 3025,519,370)">';
mtxt += '<area shape="circle" coords="524,370,3" href="javascript:selectTSpoints( 3026,524,370)">';
mtxt += '<area shape="circle" coords="529,370,3" href="javascript:selectTSpoints( 3027,529,370)">';
mtxt += '<area shape="circle" coords="534,370,3" href="javascript:selectTSpoints( 3028,534,370)">';
mtxt += '<area shape="circle" coords="539,370,3" href="javascript:selectTSpoints( 3029,539,370)">';
mtxt += '<area shape="circle" coords="544,370,3" href="javascript:selectTSpoints( 3030,544,370)">';
mtxt += '<area shape="circle" coords="549,370,3" href="javascript:selectTSpoints( 3031,549,370)">';
mtxt += '<area shape="circle" coords="554,370,3" href="javascript:selectTSpoints( 3032,554,370)">';
mtxt += '<area shape="circle" coords="559,370,3" href="javascript:selectTSpoints( 3033,559,370)">';
mtxt += '<area shape="circle" coords="565,370,3" href="javascript:selectTSpoints( 3034,565,370)">';
mtxt += '<area shape="circle" coords="570,370,3" href="javascript:selectTSpoints( 3035,570,370)">';
mtxt += '<area shape="circle" coords="575,370,3" href="javascript:selectTSpoints( 3036,575,370)">';
mtxt += '<area shape="circle" coords="580,370,3" href="javascript:selectTSpoints( 3037,580,370)">';
mtxt += '<area shape="circle" coords="585,370,3" href="javascript:selectTSpoints( 3038,585,370)">';
mtxt += '<area shape="circle" coords="590,370,3" href="javascript:selectTSpoints( 3039,590,370)">';
mtxt += '<area shape="circle" coords="595,370,3" href="javascript:selectTSpoints( 3040,595,370)">';
mtxt += '<area shape="circle" coords="600,370,3" href="javascript:selectTSpoints( 3041,600,370)">';
mtxt += '<area shape="circle" coords="605,370,3" href="javascript:selectTSpoints( 3042,605,370)">';
mtxt += '<area shape="circle" coords="610,370,3" href="javascript:selectTSpoints( 3043,610,370)">';
mtxt += '<area shape="circle" coords="615,370,3" href="javascript:selectTSpoints( 3044,615,370)">';
mtxt += '<area shape="circle" coords="621,370,3" href="javascript:selectTSpoints( 3045,621,370)">';
mtxt += '<area shape="circle" coords="626,370,3" href="javascript:selectTSpoints( 3046,626,370)">';
mtxt += '<area shape="circle" coords="631,370,3" href="javascript:selectTSpoints( 3047,631,370)">';
mtxt += '<area shape="circle" coords="636,370,3" href="javascript:selectTSpoints( 3048,636,370)">';
mtxt += '<area shape="circle" coords="641,370,3" href="javascript:selectTSpoints( 3049,641,370)">';
mtxt += '<area shape="circle" coords="646,370,3" href="javascript:selectTSpoints( 3050,646,370)">';
mtxt += '<area shape="circle" coords="651,370,3" href="javascript:selectTSpoints( 3051,651,370)">';
mtxt += '<area shape="circle" coords="656,370,3" href="javascript:selectTSpoints( 3052,656,370)">';
mtxt += '<area shape="circle" coords="661,370,3" href="javascript:selectTSpoints( 3053,661,370)">';
mtxt += '<area shape="circle" coords="666,370,3" href="javascript:selectTSpoints( 3054,666,370)">';
mtxt += '<area shape="circle" coords="671,370,3" href="javascript:selectTSpoints( 3055,671,370)">';
mtxt += '<area shape="circle" coords="677,370,3" href="javascript:selectTSpoints( 3056,677,370)">';
mtxt += '<area shape="circle" coords="682,370,3" href="javascript:selectTSpoints( 3057,682,370)">';
mtxt += '<area shape="circle" coords="687,370,3" href="javascript:selectTSpoints( 3058,687,370)">';
mtxt += '<area shape="circle" coords="692,370,3" href="javascript:selectTSpoints( 3059,692,370)">';
mtxt += '<area shape="circle" coords="697,370,3" href="javascript:selectTSpoints( 3060,697,370)">';
mtxt += '<area shape="circle" coords="702,370,3" href="javascript:selectTSpoints( 3061,702,370)">';
mtxt += '<area shape="circle" coords="707,370,3" href="javascript:selectTSpoints( 3062,707,370)">';
mtxt += '<area shape="circle" coords="712,370,3" href="javascript:selectTSpoints( 3063,712,370)">';
mtxt += '<area shape="circle" coords="717,370,3" href="javascript:selectTSpoints( 3064,717,370)">';
mtxt += '<area shape="circle" coords="722,370,3" href="javascript:selectTSpoints( 3065,722,370)">';
mtxt += '<area shape="circle" coords="727,370,3" href="javascript:selectTSpoints( 3066,727,370)">';
mtxt += '<area shape="circle" coords="733,370,3" href="javascript:selectTSpoints( 3067,733,370)">';
mtxt += '<area shape="circle" coords="738,370,3" href="javascript:selectTSpoints( 3068,738,370)">';
mtxt += '<area shape="circle" coords="743,370,3" href="javascript:selectTSpoints( 3069,743,370)">';
mtxt += '<area shape="circle" coords="748,370,3" href="javascript:selectTSpoints( 3070,748,370)">';
mtxt += '<area shape="circle" coords="753,370,3" href="javascript:selectTSpoints( 3071,753,370)">';
mtxt += '<area shape="circle" coords="758,370,3" href="javascript:selectTSpoints( 3072,758,370)">';
mtxt += '<area shape="circle" coords=" 30,365,3" href="javascript:selectTSpoints( 4073, 30,365)">';
mtxt += '<area shape="circle" coords=" 35,365,3" href="javascript:selectTSpoints( 4074, 35,365)">';
mtxt += '<area shape="circle" coords=" 40,365,3" href="javascript:selectTSpoints( 4075, 40,365)">';
mtxt += '<area shape="circle" coords=" 45,365,3" href="javascript:selectTSpoints( 4076, 45,365)">';
mtxt += '<area shape="circle" coords=" 50,365,3" href="javascript:selectTSpoints( 4077, 50,365)">';
mtxt += '<area shape="circle" coords=" 56,365,3" href="javascript:selectTSpoints( 4078, 56,365)">';
mtxt += '<area shape="circle" coords=" 61,365,3" href="javascript:selectTSpoints( 4079, 61,365)">';
mtxt += '<area shape="circle" coords=" 66,365,3" href="javascript:selectTSpoints( 4080, 66,365)">';
mtxt += '<area shape="circle" coords=" 71,365,3" href="javascript:selectTSpoints( 4081, 71,365)">';
mtxt += '<area shape="circle" coords=" 76,365,3" href="javascript:selectTSpoints( 4082, 76,365)">';
mtxt += '<area shape="circle" coords=" 81,365,3" href="javascript:selectTSpoints( 4083, 81,365)">';
mtxt += '<area shape="circle" coords=" 86,365,3" href="javascript:selectTSpoints( 4084, 86,365)">';
mtxt += '<area shape="circle" coords=" 91,365,3" href="javascript:selectTSpoints( 4085, 91,365)">';
mtxt += '<area shape="circle" coords=" 96,365,3" href="javascript:selectTSpoints( 4086, 96,365)">';
mtxt += '<area shape="circle" coords="101,365,3" href="javascript:selectTSpoints( 4087,101,365)">';
mtxt += '<area shape="circle" coords="106,365,3" href="javascript:selectTSpoints( 4088,106,365)">';
mtxt += '<area shape="circle" coords="112,365,3" href="javascript:selectTSpoints( 4089,112,365)">';
mtxt += '<area shape="circle" coords="117,365,3" href="javascript:selectTSpoints( 4090,117,365)">';
mtxt += '<area shape="circle" coords="122,365,3" href="javascript:selectTSpoints( 4091,122,365)">';
mtxt += '<area shape="circle" coords="127,365,3" href="javascript:selectTSpoints( 4092,127,365)">';
mtxt += '<area shape="circle" coords="132,365,3" href="javascript:selectTSpoints( 4093,132,365)">';
mtxt += '<area shape="circle" coords="137,365,3" href="javascript:selectTSpoints( 4094,137,365)">';
mtxt += '<area shape="circle" coords="142,365,3" href="javascript:selectTSpoints( 4095,142,365)">';
mtxt += '<area shape="circle" coords="147,365,3" href="javascript:selectTSpoints( 4096,147,365)">';
mtxt += '<area shape="circle" coords="152,365,3" href="javascript:selectTSpoints( 4097,152,365)">';
mtxt += '<area shape="circle" coords="157,365,3" href="javascript:selectTSpoints( 4098,157,365)">';
mtxt += '<area shape="circle" coords="162,365,3" href="javascript:selectTSpoints( 4099,162,365)">';
mtxt += '<area shape="circle" coords="168,365,3" href="javascript:selectTSpoints( 4100,168,365)">';
mtxt += '<area shape="circle" coords="173,365,3" href="javascript:selectTSpoints( 4101,173,365)">';
mtxt += '<area shape="circle" coords="178,365,3" href="javascript:selectTSpoints( 4102,178,365)">';
mtxt += '<area shape="circle" coords="183,365,3" href="javascript:selectTSpoints( 4103,183,365)">';
mtxt += '<area shape="circle" coords="188,365,3" href="javascript:selectTSpoints( 4104,188,365)">';
mtxt += '<area shape="circle" coords="193,365,3" href="javascript:selectTSpoints( 4105,193,365)">';
mtxt += '<area shape="circle" coords="198,365,3" href="javascript:selectTSpoints( 4106,198,365)">';
mtxt += '<area shape="circle" coords="203,365,3" href="javascript:selectTSpoints( 4107,203,365)">';
mtxt += '<area shape="circle" coords="208,365,3" href="javascript:selectTSpoints( 4108,208,365)">';
mtxt += '<area shape="circle" coords="213,365,3" href="javascript:selectTSpoints( 4109,213,365)">';
mtxt += '<area shape="circle" coords="218,365,3" href="javascript:selectTSpoints( 4110,218,365)">';
mtxt += '<area shape="circle" coords="224,365,3" href="javascript:selectTSpoints( 4111,224,365)">';
mtxt += '<area shape="circle" coords="229,365,3" href="javascript:selectTSpoints( 4112,229,365)">';
mtxt += '<area shape="circle" coords="234,365,3" href="javascript:selectTSpoints( 4113,234,365)">';
mtxt += '<area shape="circle" coords="239,365,3" href="javascript:selectTSpoints( 4114,239,365)">';
mtxt += '<area shape="circle" coords="244,365,3" href="javascript:selectTSpoints( 4115,244,365)">';
mtxt += '<area shape="circle" coords="249,365,3" href="javascript:selectTSpoints( 4116,249,365)">';
mtxt += '<area shape="circle" coords="254,365,3" href="javascript:selectTSpoints( 4117,254,365)">';
mtxt += '<area shape="circle" coords="259,365,3" href="javascript:selectTSpoints( 4118,259,365)">';
mtxt += '<area shape="circle" coords="264,365,3" href="javascript:selectTSpoints( 4119,264,365)">';
mtxt += '<area shape="circle" coords="269,365,3" href="javascript:selectTSpoints( 4120,269,365)">';
mtxt += '<area shape="circle" coords="274,365,3" href="javascript:selectTSpoints( 4121,274,365)">';
mtxt += '<area shape="circle" coords="280,365,3" href="javascript:selectTSpoints( 4122,280,365)">';
mtxt += '<area shape="circle" coords="285,365,3" href="javascript:selectTSpoints( 4123,285,365)">';
mtxt += '<area shape="circle" coords="290,365,3" href="javascript:selectTSpoints( 4124,290,365)">';
mtxt += '<area shape="circle" coords="295,365,3" href="javascript:selectTSpoints( 4125,295,365)">';
mtxt += '<area shape="circle" coords="300,365,3" href="javascript:selectTSpoints( 4126,300,365)">';
mtxt += '<area shape="circle" coords="305,365,3" href="javascript:selectTSpoints( 4127,305,365)">';
mtxt += '<area shape="circle" coords="310,365,3" href="javascript:selectTSpoints( 4128,310,365)">';
mtxt += '<area shape="circle" coords="315,365,3" href="javascript:selectTSpoints( 4129,315,365)">';
mtxt += '<area shape="circle" coords="320,365,3" href="javascript:selectTSpoints( 4130,320,365)">';
mtxt += '<area shape="circle" coords="325,365,3" href="javascript:selectTSpoints( 4131,325,365)">';
mtxt += '<area shape="circle" coords="330,365,3" href="javascript:selectTSpoints( 4132,330,365)">';
mtxt += '<area shape="circle" coords="336,365,3" href="javascript:selectTSpoints( 4133,336,365)">';
mtxt += '<area shape="circle" coords="341,365,3" href="javascript:selectTSpoints( 4134,341,365)">';
mtxt += '<area shape="circle" coords="346,365,3" href="javascript:selectTSpoints( 4135,346,365)">';
mtxt += '<area shape="circle" coords="351,365,3" href="javascript:selectTSpoints( 4136,351,365)">';
mtxt += '<area shape="circle" coords="356,365,3" href="javascript:selectTSpoints( 4137,356,365)">';
mtxt += '<area shape="circle" coords="361,365,3" href="javascript:selectTSpoints( 4138,361,365)">';
mtxt += '<area shape="circle" coords="366,365,3" href="javascript:selectTSpoints( 4139,366,365)">';
mtxt += '<area shape="circle" coords="371,365,3" href="javascript:selectTSpoints( 4140,371,365)">';
mtxt += '<area shape="circle" coords="376,365,3" href="javascript:selectTSpoints( 4141,376,365)">';
mtxt += '<area shape="circle" coords="381,365,3" href="javascript:selectTSpoints( 4142,381,365)">';
mtxt += '<area shape="circle" coords="386,365,3" href="javascript:selectTSpoints( 4143,386,365)">';
mtxt += '<area shape="circle" coords="392,365,3" href="javascript:selectTSpoints( 4144,392,365)">';
mtxt += '<area shape="circle" coords="397,365,3" href="javascript:selectTSpoints( 4001,397,365)">';
mtxt += '<area shape="circle" coords="402,365,3" href="javascript:selectTSpoints( 4002,402,365)">';
mtxt += '<area shape="circle" coords="407,365,3" href="javascript:selectTSpoints( 4003,407,365)">';
mtxt += '<area shape="circle" coords="412,365,3" href="javascript:selectTSpoints( 4004,412,365)">';
mtxt += '<area shape="circle" coords="417,365,3" href="javascript:selectTSpoints( 4005,417,365)">';
mtxt += '<area shape="circle" coords="422,365,3" href="javascript:selectTSpoints( 4006,422,365)">';
mtxt += '<area shape="circle" coords="427,365,3" href="javascript:selectTSpoints( 4007,427,365)">';
mtxt += '<area shape="circle" coords="432,365,3" href="javascript:selectTSpoints( 4008,432,365)">';
mtxt += '<area shape="circle" coords="437,365,3" href="javascript:selectTSpoints( 4009,437,365)">';
mtxt += '<area shape="circle" coords="442,365,3" href="javascript:selectTSpoints( 4010,442,365)">';
mtxt += '<area shape="circle" coords="447,365,3" href="javascript:selectTSpoints( 4011,447,365)">';
mtxt += '<area shape="circle" coords="453,365,3" href="javascript:selectTSpoints( 4012,453,365)">';
mtxt += '<area shape="circle" coords="458,365,3" href="javascript:selectTSpoints( 4013,458,365)">';
mtxt += '<area shape="circle" coords="463,365,3" href="javascript:selectTSpoints( 4014,463,365)">';
mtxt += '<area shape="circle" coords="468,365,3" href="javascript:selectTSpoints( 4015,468,365)">';
mtxt += '<area shape="circle" coords="473,365,3" href="javascript:selectTSpoints( 4016,473,365)">';
mtxt += '<area shape="circle" coords="478,365,3" href="javascript:selectTSpoints( 4017,478,365)">';
mtxt += '<area shape="circle" coords="483,365,3" href="javascript:selectTSpoints( 4018,483,365)">';
mtxt += '<area shape="circle" coords="488,365,3" href="javascript:selectTSpoints( 4019,488,365)">';
mtxt += '<area shape="circle" coords="493,365,3" href="javascript:selectTSpoints( 4020,493,365)">';
mtxt += '<area shape="circle" coords="498,365,3" href="javascript:selectTSpoints( 4021,498,365)">';
mtxt += '<area shape="circle" coords="503,365,3" href="javascript:selectTSpoints( 4022,503,365)">';
mtxt += '<area shape="circle" coords="509,365,3" href="javascript:selectTSpoints( 4023,509,365)">';
mtxt += '<area shape="circle" coords="514,365,3" href="javascript:selectTSpoints( 4024,514,365)">';
mtxt += '<area shape="circle" coords="519,365,3" href="javascript:selectTSpoints( 4025,519,365)">';
mtxt += '<area shape="circle" coords="524,365,3" href="javascript:selectTSpoints( 4026,524,365)">';
mtxt += '<area shape="circle" coords="529,365,3" href="javascript:selectTSpoints( 4027,529,365)">';
mtxt += '<area shape="circle" coords="534,365,3" href="javascript:selectTSpoints( 4028,534,365)">';
mtxt += '<area shape="circle" coords="539,365,3" href="javascript:selectTSpoints( 4029,539,365)">';
mtxt += '<area shape="circle" coords="544,365,3" href="javascript:selectTSpoints( 4030,544,365)">';
mtxt += '<area shape="circle" coords="549,365,3" href="javascript:selectTSpoints( 4031,549,365)">';
mtxt += '<area shape="circle" coords="554,365,3" href="javascript:selectTSpoints( 4032,554,365)">';
mtxt += '<area shape="circle" coords="559,365,3" href="javascript:selectTSpoints( 4033,559,365)">';
mtxt += '<area shape="circle" coords="565,365,3" href="javascript:selectTSpoints( 4034,565,365)">';
mtxt += '<area shape="circle" coords="570,365,3" href="javascript:selectTSpoints( 4035,570,365)">';
mtxt += '<area shape="circle" coords="575,365,3" href="javascript:selectTSpoints( 4036,575,365)">';
mtxt += '<area shape="circle" coords="580,365,3" href="javascript:selectTSpoints( 4037,580,365)">';
mtxt += '<area shape="circle" coords="585,365,3" href="javascript:selectTSpoints( 4038,585,365)">';
mtxt += '<area shape="circle" coords="590,365,3" href="javascript:selectTSpoints( 4039,590,365)">';
mtxt += '<area shape="circle" coords="595,365,3" href="javascript:selectTSpoints( 4040,595,365)">';
mtxt += '<area shape="circle" coords="600,365,3" href="javascript:selectTSpoints( 4041,600,365)">';
mtxt += '<area shape="circle" coords="605,365,3" href="javascript:selectTSpoints( 4042,605,365)">';
mtxt += '<area shape="circle" coords="610,365,3" href="javascript:selectTSpoints( 4043,610,365)">';
mtxt += '<area shape="circle" coords="615,365,3" href="javascript:selectTSpoints( 4044,615,365)">';
mtxt += '<area shape="circle" coords="621,365,3" href="javascript:selectTSpoints( 4045,621,365)">';
mtxt += '<area shape="circle" coords="626,365,3" href="javascript:selectTSpoints( 4046,626,365)">';
mtxt += '<area shape="circle" coords="631,365,3" href="javascript:selectTSpoints( 4047,631,365)">';
mtxt += '<area shape="circle" coords="636,365,3" href="javascript:selectTSpoints( 4048,636,365)">';
mtxt += '<area shape="circle" coords="641,365,3" href="javascript:selectTSpoints( 4049,641,365)">';
mtxt += '<area shape="circle" coords="646,365,3" href="javascript:selectTSpoints( 4050,646,365)">';
mtxt += '<area shape="circle" coords="651,365,3" href="javascript:selectTSpoints( 4051,651,365)">';
mtxt += '<area shape="circle" coords="656,365,3" href="javascript:selectTSpoints( 4052,656,365)">';
mtxt += '<area shape="circle" coords="661,365,3" href="javascript:selectTSpoints( 4053,661,365)">';
mtxt += '<area shape="circle" coords="666,365,3" href="javascript:selectTSpoints( 4054,666,365)">';
mtxt += '<area shape="circle" coords="671,365,3" href="javascript:selectTSpoints( 4055,671,365)">';
mtxt += '<area shape="circle" coords="677,365,3" href="javascript:selectTSpoints( 4056,677,365)">';
mtxt += '<area shape="circle" coords="682,365,3" href="javascript:selectTSpoints( 4057,682,365)">';
mtxt += '<area shape="circle" coords="687,365,3" href="javascript:selectTSpoints( 4058,687,365)">';
mtxt += '<area shape="circle" coords="692,365,3" href="javascript:selectTSpoints( 4059,692,365)">';
mtxt += '<area shape="circle" coords="697,365,3" href="javascript:selectTSpoints( 4060,697,365)">';
mtxt += '<area shape="circle" coords="702,365,3" href="javascript:selectTSpoints( 4061,702,365)">';
mtxt += '<area shape="circle" coords="707,365,3" href="javascript:selectTSpoints( 4062,707,365)">';
mtxt += '<area shape="circle" coords="712,365,3" href="javascript:selectTSpoints( 4063,712,365)">';
mtxt += '<area shape="circle" coords="717,365,3" href="javascript:selectTSpoints( 4064,717,365)">';
mtxt += '<area shape="circle" coords="722,365,3" href="javascript:selectTSpoints( 4065,722,365)">';
mtxt += '<area shape="circle" coords="727,365,3" href="javascript:selectTSpoints( 4066,727,365)">';
mtxt += '<area shape="circle" coords="733,365,3" href="javascript:selectTSpoints( 4067,733,365)">';
mtxt += '<area shape="circle" coords="738,365,3" href="javascript:selectTSpoints( 4068,738,365)">';
mtxt += '<area shape="circle" coords="743,365,3" href="javascript:selectTSpoints( 4069,743,365)">';
mtxt += '<area shape="circle" coords="748,365,3" href="javascript:selectTSpoints( 4070,748,365)">';
mtxt += '<area shape="circle" coords="753,365,3" href="javascript:selectTSpoints( 4071,753,365)">';
mtxt += '<area shape="circle" coords="758,365,3" href="javascript:selectTSpoints( 4072,758,365)">';
mtxt += '<area shape="circle" coords=" 30,360,3" href="javascript:selectTSpoints( 5073, 30,360)">';
mtxt += '<area shape="circle" coords=" 35,360,3" href="javascript:selectTSpoints( 5074, 35,360)">';
mtxt += '<area shape="circle" coords=" 40,360,3" href="javascript:selectTSpoints( 5075, 40,360)">';
mtxt += '<area shape="circle" coords=" 45,360,3" href="javascript:selectTSpoints( 5076, 45,360)">';
mtxt += '<area shape="circle" coords=" 50,360,3" href="javascript:selectTSpoints( 5077, 50,360)">';
mtxt += '<area shape="circle" coords=" 56,360,3" href="javascript:selectTSpoints( 5078, 56,360)">';
mtxt += '<area shape="circle" coords=" 61,360,3" href="javascript:selectTSpoints( 5079, 61,360)">';
mtxt += '<area shape="circle" coords=" 66,360,3" href="javascript:selectTSpoints( 5080, 66,360)">';
mtxt += '<area shape="circle" coords=" 71,360,3" href="javascript:selectTSpoints( 5081, 71,360)">';
mtxt += '<area shape="circle" coords=" 76,360,3" href="javascript:selectTSpoints( 5082, 76,360)">';
mtxt += '<area shape="circle" coords=" 81,360,3" href="javascript:selectTSpoints( 5083, 81,360)">';
mtxt += '<area shape="circle" coords=" 86,360,3" href="javascript:selectTSpoints( 5084, 86,360)">';
mtxt += '<area shape="circle" coords=" 91,360,3" href="javascript:selectTSpoints( 5085, 91,360)">';
mtxt += '<area shape="circle" coords=" 96,360,3" href="javascript:selectTSpoints( 5086, 96,360)">';
mtxt += '<area shape="circle" coords="101,360,3" href="javascript:selectTSpoints( 5087,101,360)">';
mtxt += '<area shape="circle" coords="106,360,3" href="javascript:selectTSpoints( 5088,106,360)">';
mtxt += '<area shape="circle" coords="112,360,3" href="javascript:selectTSpoints( 5089,112,360)">';
mtxt += '<area shape="circle" coords="117,360,3" href="javascript:selectTSpoints( 5090,117,360)">';
mtxt += '<area shape="circle" coords="122,360,3" href="javascript:selectTSpoints( 5091,122,360)">';
mtxt += '<area shape="circle" coords="127,360,3" href="javascript:selectTSpoints( 5092,127,360)">';
mtxt += '<area shape="circle" coords="132,360,3" href="javascript:selectTSpoints( 5093,132,360)">';
mtxt += '<area shape="circle" coords="137,360,3" href="javascript:selectTSpoints( 5094,137,360)">';
mtxt += '<area shape="circle" coords="142,360,3" href="javascript:selectTSpoints( 5095,142,360)">';
mtxt += '<area shape="circle" coords="147,360,3" href="javascript:selectTSpoints( 5096,147,360)">';
mtxt += '<area shape="circle" coords="152,360,3" href="javascript:selectTSpoints( 5097,152,360)">';
mtxt += '<area shape="circle" coords="157,360,3" href="javascript:selectTSpoints( 5098,157,360)">';
mtxt += '<area shape="circle" coords="162,360,3" href="javascript:selectTSpoints( 5099,162,360)">';
mtxt += '<area shape="circle" coords="168,360,3" href="javascript:selectTSpoints( 5100,168,360)">';
mtxt += '<area shape="circle" coords="173,360,3" href="javascript:selectTSpoints( 5101,173,360)">';
mtxt += '<area shape="circle" coords="178,360,3" href="javascript:selectTSpoints( 5102,178,360)">';
mtxt += '<area shape="circle" coords="183,360,3" href="javascript:selectTSpoints( 5103,183,360)">';
mtxt += '<area shape="circle" coords="188,360,3" href="javascript:selectTSpoints( 5104,188,360)">';
mtxt += '<area shape="circle" coords="193,360,3" href="javascript:selectTSpoints( 5105,193,360)">';
mtxt += '<area shape="circle" coords="198,360,3" href="javascript:selectTSpoints( 5106,198,360)">';
mtxt += '<area shape="circle" coords="203,360,3" href="javascript:selectTSpoints( 5107,203,360)">';
mtxt += '<area shape="circle" coords="208,360,3" href="javascript:selectTSpoints( 5108,208,360)">';
mtxt += '<area shape="circle" coords="213,360,3" href="javascript:selectTSpoints( 5109,213,360)">';
mtxt += '<area shape="circle" coords="218,360,3" href="javascript:selectTSpoints( 5110,218,360)">';
mtxt += '<area shape="circle" coords="224,360,3" href="javascript:selectTSpoints( 5111,224,360)">';
mtxt += '<area shape="circle" coords="229,360,3" href="javascript:selectTSpoints( 5112,229,360)">';
mtxt += '<area shape="circle" coords="234,360,3" href="javascript:selectTSpoints( 5113,234,360)">';
mtxt += '<area shape="circle" coords="239,360,3" href="javascript:selectTSpoints( 5114,239,360)">';
mtxt += '<area shape="circle" coords="244,360,3" href="javascript:selectTSpoints( 5115,244,360)">';
mtxt += '<area shape="circle" coords="249,360,3" href="javascript:selectTSpoints( 5116,249,360)">';
mtxt += '<area shape="circle" coords="254,360,3" href="javascript:selectTSpoints( 5117,254,360)">';
mtxt += '<area shape="circle" coords="259,360,3" href="javascript:selectTSpoints( 5118,259,360)">';
mtxt += '<area shape="circle" coords="264,360,3" href="javascript:selectTSpoints( 5119,264,360)">';
mtxt += '<area shape="circle" coords="269,360,3" href="javascript:selectTSpoints( 5120,269,360)">';
mtxt += '<area shape="circle" coords="274,360,3" href="javascript:selectTSpoints( 5121,274,360)">';
mtxt += '<area shape="circle" coords="280,360,3" href="javascript:selectTSpoints( 5122,280,360)">';
mtxt += '<area shape="circle" coords="285,360,3" href="javascript:selectTSpoints( 5123,285,360)">';
mtxt += '<area shape="circle" coords="290,360,3" href="javascript:selectTSpoints( 5124,290,360)">';
mtxt += '<area shape="circle" coords="295,360,3" href="javascript:selectTSpoints( 5125,295,360)">';
mtxt += '<area shape="circle" coords="300,360,3" href="javascript:selectTSpoints( 5126,300,360)">';
mtxt += '<area shape="circle" coords="305,360,3" href="javascript:selectTSpoints( 5127,305,360)">';
mtxt += '<area shape="circle" coords="310,360,3" href="javascript:selectTSpoints( 5128,310,360)">';
mtxt += '<area shape="circle" coords="315,360,3" href="javascript:selectTSpoints( 5129,315,360)">';
mtxt += '<area shape="circle" coords="320,360,3" href="javascript:selectTSpoints( 5130,320,360)">';
mtxt += '<area shape="circle" coords="325,360,3" href="javascript:selectTSpoints( 5131,325,360)">';
mtxt += '<area shape="circle" coords="330,360,3" href="javascript:selectTSpoints( 5132,330,360)">';
mtxt += '<area shape="circle" coords="336,360,3" href="javascript:selectTSpoints( 5133,336,360)">';
mtxt += '<area shape="circle" coords="341,360,3" href="javascript:selectTSpoints( 5134,341,360)">';
mtxt += '<area shape="circle" coords="346,360,3" href="javascript:selectTSpoints( 5135,346,360)">';
mtxt += '<area shape="circle" coords="351,360,3" href="javascript:selectTSpoints( 5136,351,360)">';
mtxt += '<area shape="circle" coords="356,360,3" href="javascript:selectTSpoints( 5137,356,360)">';
mtxt += '<area shape="circle" coords="361,360,3" href="javascript:selectTSpoints( 5138,361,360)">';
mtxt += '<area shape="circle" coords="366,360,3" href="javascript:selectTSpoints( 5139,366,360)">';
mtxt += '<area shape="circle" coords="371,360,3" href="javascript:selectTSpoints( 5140,371,360)">';
mtxt += '<area shape="circle" coords="376,360,3" href="javascript:selectTSpoints( 5141,376,360)">';
mtxt += '<area shape="circle" coords="381,360,3" href="javascript:selectTSpoints( 5142,381,360)">';
mtxt += '<area shape="circle" coords="386,360,3" href="javascript:selectTSpoints( 5143,386,360)">';
mtxt += '<area shape="circle" coords="392,360,3" href="javascript:selectTSpoints( 5144,392,360)">';
mtxt += '<area shape="circle" coords="397,360,3" href="javascript:selectTSpoints( 5001,397,360)">';
mtxt += '<area shape="circle" coords="402,360,3" href="javascript:selectTSpoints( 5002,402,360)">';
mtxt += '<area shape="circle" coords="407,360,3" href="javascript:selectTSpoints( 5003,407,360)">';
mtxt += '<area shape="circle" coords="412,360,3" href="javascript:selectTSpoints( 5004,412,360)">';
mtxt += '<area shape="circle" coords="417,360,3" href="javascript:selectTSpoints( 5005,417,360)">';
mtxt += '<area shape="circle" coords="422,360,3" href="javascript:selectTSpoints( 5006,422,360)">';
mtxt += '<area shape="circle" coords="427,360,3" href="javascript:selectTSpoints( 5007,427,360)">';
mtxt += '<area shape="circle" coords="432,360,3" href="javascript:selectTSpoints( 5008,432,360)">';
mtxt += '<area shape="circle" coords="437,360,3" href="javascript:selectTSpoints( 5009,437,360)">';
mtxt += '<area shape="circle" coords="442,360,3" href="javascript:selectTSpoints( 5010,442,360)">';
mtxt += '<area shape="circle" coords="447,360,3" href="javascript:selectTSpoints( 5011,447,360)">';
mtxt += '<area shape="circle" coords="453,360,3" href="javascript:selectTSpoints( 5012,453,360)">';
mtxt += '<area shape="circle" coords="458,360,3" href="javascript:selectTSpoints( 5013,458,360)">';
mtxt += '<area shape="circle" coords="463,360,3" href="javascript:selectTSpoints( 5014,463,360)">';
mtxt += '<area shape="circle" coords="468,360,3" href="javascript:selectTSpoints( 5015,468,360)">';
mtxt += '<area shape="circle" coords="473,360,3" href="javascript:selectTSpoints( 5016,473,360)">';
mtxt += '<area shape="circle" coords="478,360,3" href="javascript:selectTSpoints( 5017,478,360)">';
mtxt += '<area shape="circle" coords="483,360,3" href="javascript:selectTSpoints( 5018,483,360)">';
mtxt += '<area shape="circle" coords="488,360,3" href="javascript:selectTSpoints( 5019,488,360)">';
mtxt += '<area shape="circle" coords="493,360,3" href="javascript:selectTSpoints( 5020,493,360)">';
mtxt += '<area shape="circle" coords="498,360,3" href="javascript:selectTSpoints( 5021,498,360)">';
mtxt += '<area shape="circle" coords="503,360,3" href="javascript:selectTSpoints( 5022,503,360)">';
mtxt += '<area shape="circle" coords="509,360,3" href="javascript:selectTSpoints( 5023,509,360)">';
mtxt += '<area shape="circle" coords="514,360,3" href="javascript:selectTSpoints( 5024,514,360)">';
mtxt += '<area shape="circle" coords="519,360,3" href="javascript:selectTSpoints( 5025,519,360)">';
mtxt += '<area shape="circle" coords="524,360,3" href="javascript:selectTSpoints( 5026,524,360)">';
mtxt += '<area shape="circle" coords="529,360,3" href="javascript:selectTSpoints( 5027,529,360)">';
mtxt += '<area shape="circle" coords="534,360,3" href="javascript:selectTSpoints( 5028,534,360)">';
mtxt += '<area shape="circle" coords="539,360,3" href="javascript:selectTSpoints( 5029,539,360)">';
mtxt += '<area shape="circle" coords="544,360,3" href="javascript:selectTSpoints( 5030,544,360)">';
mtxt += '<area shape="circle" coords="549,360,3" href="javascript:selectTSpoints( 5031,549,360)">';
mtxt += '<area shape="circle" coords="554,360,3" href="javascript:selectTSpoints( 5032,554,360)">';
mtxt += '<area shape="circle" coords="559,360,3" href="javascript:selectTSpoints( 5033,559,360)">';
mtxt += '<area shape="circle" coords="565,360,3" href="javascript:selectTSpoints( 5034,565,360)">';
mtxt += '<area shape="circle" coords="570,360,3" href="javascript:selectTSpoints( 5035,570,360)">';
mtxt += '<area shape="circle" coords="575,360,3" href="javascript:selectTSpoints( 5036,575,360)">';
mtxt += '<area shape="circle" coords="580,360,3" href="javascript:selectTSpoints( 5037,580,360)">';
mtxt += '<area shape="circle" coords="585,360,3" href="javascript:selectTSpoints( 5038,585,360)">';
mtxt += '<area shape="circle" coords="590,360,3" href="javascript:selectTSpoints( 5039,590,360)">';
mtxt += '<area shape="circle" coords="595,360,3" href="javascript:selectTSpoints( 5040,595,360)">';
mtxt += '<area shape="circle" coords="600,360,3" href="javascript:selectTSpoints( 5041,600,360)">';
mtxt += '<area shape="circle" coords="605,360,3" href="javascript:selectTSpoints( 5042,605,360)">';
mtxt += '<area shape="circle" coords="610,360,3" href="javascript:selectTSpoints( 5043,610,360)">';
mtxt += '<area shape="circle" coords="615,360,3" href="javascript:selectTSpoints( 5044,615,360)">';
mtxt += '<area shape="circle" coords="621,360,3" href="javascript:selectTSpoints( 5045,621,360)">';
mtxt += '<area shape="circle" coords="626,360,3" href="javascript:selectTSpoints( 5046,626,360)">';
mtxt += '<area shape="circle" coords="631,360,3" href="javascript:selectTSpoints( 5047,631,360)">';
mtxt += '<area shape="circle" coords="636,360,3" href="javascript:selectTSpoints( 5048,636,360)">';
mtxt += '<area shape="circle" coords="641,360,3" href="javascript:selectTSpoints( 5049,641,360)">';
mtxt += '<area shape="circle" coords="646,360,3" href="javascript:selectTSpoints( 5050,646,360)">';
mtxt += '<area shape="circle" coords="651,360,3" href="javascript:selectTSpoints( 5051,651,360)">';
mtxt += '<area shape="circle" coords="656,360,3" href="javascript:selectTSpoints( 5052,656,360)">';
mtxt += '<area shape="circle" coords="661,360,3" href="javascript:selectTSpoints( 5053,661,360)">';
mtxt += '<area shape="circle" coords="666,360,3" href="javascript:selectTSpoints( 5054,666,360)">';
mtxt += '<area shape="circle" coords="671,360,3" href="javascript:selectTSpoints( 5055,671,360)">';
mtxt += '<area shape="circle" coords="677,360,3" href="javascript:selectTSpoints( 5056,677,360)">';
mtxt += '<area shape="circle" coords="682,360,3" href="javascript:selectTSpoints( 5057,682,360)">';
mtxt += '<area shape="circle" coords="687,360,3" href="javascript:selectTSpoints( 5058,687,360)">';
mtxt += '<area shape="circle" coords="692,360,3" href="javascript:selectTSpoints( 5059,692,360)">';
mtxt += '<area shape="circle" coords="697,360,3" href="javascript:selectTSpoints( 5060,697,360)">';
mtxt += '<area shape="circle" coords="702,360,3" href="javascript:selectTSpoints( 5061,702,360)">';
mtxt += '<area shape="circle" coords="707,360,3" href="javascript:selectTSpoints( 5062,707,360)">';
mtxt += '<area shape="circle" coords="712,360,3" href="javascript:selectTSpoints( 5063,712,360)">';
mtxt += '<area shape="circle" coords="717,360,3" href="javascript:selectTSpoints( 5064,717,360)">';
mtxt += '<area shape="circle" coords="722,360,3" href="javascript:selectTSpoints( 5065,722,360)">';
mtxt += '<area shape="circle" coords="727,360,3" href="javascript:selectTSpoints( 5066,727,360)">';
mtxt += '<area shape="circle" coords="733,360,3" href="javascript:selectTSpoints( 5067,733,360)">';
mtxt += '<area shape="circle" coords="738,360,3" href="javascript:selectTSpoints( 5068,738,360)">';
mtxt += '<area shape="circle" coords="743,360,3" href="javascript:selectTSpoints( 5069,743,360)">';
mtxt += '<area shape="circle" coords="748,360,3" href="javascript:selectTSpoints( 5070,748,360)">';
mtxt += '<area shape="circle" coords="753,360,3" href="javascript:selectTSpoints( 5071,753,360)">';
mtxt += '<area shape="circle" coords="758,360,3" href="javascript:selectTSpoints( 5072,758,360)">';
mtxt += '<area shape="circle" coords=" 30,355,3" href="javascript:selectTSpoints( 6073, 30,355)">';
mtxt += '<area shape="circle" coords=" 35,355,3" href="javascript:selectTSpoints( 6074, 35,355)">';
mtxt += '<area shape="circle" coords=" 40,355,3" href="javascript:selectTSpoints( 6075, 40,355)">';
mtxt += '<area shape="circle" coords=" 45,355,3" href="javascript:selectTSpoints( 6076, 45,355)">';
mtxt += '<area shape="circle" coords=" 50,355,3" href="javascript:selectTSpoints( 6077, 50,355)">';
mtxt += '<area shape="circle" coords=" 56,355,3" href="javascript:selectTSpoints( 6078, 56,355)">';
mtxt += '<area shape="circle" coords=" 61,355,3" href="javascript:selectTSpoints( 6079, 61,355)">';
mtxt += '<area shape="circle" coords=" 66,355,3" href="javascript:selectTSpoints( 6080, 66,355)">';
mtxt += '<area shape="circle" coords=" 71,355,3" href="javascript:selectTSpoints( 6081, 71,355)">';
mtxt += '<area shape="circle" coords=" 76,355,3" href="javascript:selectTSpoints( 6082, 76,355)">';
mtxt += '<area shape="circle" coords=" 81,355,3" href="javascript:selectTSpoints( 6083, 81,355)">';
mtxt += '<area shape="circle" coords=" 86,355,3" href="javascript:selectTSpoints( 6084, 86,355)">';
mtxt += '<area shape="circle" coords=" 91,355,3" href="javascript:selectTSpoints( 6085, 91,355)">';
mtxt += '<area shape="circle" coords=" 96,355,3" href="javascript:selectTSpoints( 6086, 96,355)">';
mtxt += '<area shape="circle" coords="101,355,3" href="javascript:selectTSpoints( 6087,101,355)">';
mtxt += '<area shape="circle" coords="106,355,3" href="javascript:selectTSpoints( 6088,106,355)">';
mtxt += '<area shape="circle" coords="112,355,3" href="javascript:selectTSpoints( 6089,112,355)">';
mtxt += '<area shape="circle" coords="117,355,3" href="javascript:selectTSpoints( 6090,117,355)">';
mtxt += '<area shape="circle" coords="122,355,3" href="javascript:selectTSpoints( 6091,122,355)">';
mtxt += '<area shape="circle" coords="127,355,3" href="javascript:selectTSpoints( 6092,127,355)">';
mtxt += '<area shape="circle" coords="132,355,3" href="javascript:selectTSpoints( 6093,132,355)">';
mtxt += '<area shape="circle" coords="137,355,3" href="javascript:selectTSpoints( 6094,137,355)">';
mtxt += '<area shape="circle" coords="142,355,3" href="javascript:selectTSpoints( 6095,142,355)">';
mtxt += '<area shape="circle" coords="147,355,3" href="javascript:selectTSpoints( 6096,147,355)">';
mtxt += '<area shape="circle" coords="152,355,3" href="javascript:selectTSpoints( 6097,152,355)">';
mtxt += '<area shape="circle" coords="157,355,3" href="javascript:selectTSpoints( 6098,157,355)">';
mtxt += '<area shape="circle" coords="162,355,3" href="javascript:selectTSpoints( 6099,162,355)">';
mtxt += '<area shape="circle" coords="168,355,3" href="javascript:selectTSpoints( 6100,168,355)">';
mtxt += '<area shape="circle" coords="173,355,3" href="javascript:selectTSpoints( 6101,173,355)">';
mtxt += '<area shape="circle" coords="178,355,3" href="javascript:selectTSpoints( 6102,178,355)">';
mtxt += '<area shape="circle" coords="183,355,3" href="javascript:selectTSpoints( 6103,183,355)">';
mtxt += '<area shape="circle" coords="188,355,3" href="javascript:selectTSpoints( 6104,188,355)">';
mtxt += '<area shape="circle" coords="193,355,3" href="javascript:selectTSpoints( 6105,193,355)">';
mtxt += '<area shape="circle" coords="198,355,3" href="javascript:selectTSpoints( 6106,198,355)">';
mtxt += '<area shape="circle" coords="203,355,3" href="javascript:selectTSpoints( 6107,203,355)">';
mtxt += '<area shape="circle" coords="208,355,3" href="javascript:selectTSpoints( 6108,208,355)">';
mtxt += '<area shape="circle" coords="213,355,3" href="javascript:selectTSpoints( 6109,213,355)">';
mtxt += '<area shape="circle" coords="218,355,3" href="javascript:selectTSpoints( 6110,218,355)">';
mtxt += '<area shape="circle" coords="224,355,3" href="javascript:selectTSpoints( 6111,224,355)">';
mtxt += '<area shape="circle" coords="229,355,3" href="javascript:selectTSpoints( 6112,229,355)">';
mtxt += '<area shape="circle" coords="234,355,3" href="javascript:selectTSpoints( 6113,234,355)">';
mtxt += '<area shape="circle" coords="239,355,3" href="javascript:selectTSpoints( 6114,239,355)">';
mtxt += '<area shape="circle" coords="244,355,3" href="javascript:selectTSpoints( 6115,244,355)">';
mtxt += '<area shape="circle" coords="249,355,3" href="javascript:selectTSpoints( 6116,249,355)">';
mtxt += '<area shape="circle" coords="254,355,3" href="javascript:selectTSpoints( 6117,254,355)">';
mtxt += '<area shape="circle" coords="259,355,3" href="javascript:selectTSpoints( 6118,259,355)">';
mtxt += '<area shape="circle" coords="264,355,3" href="javascript:selectTSpoints( 6119,264,355)">';
mtxt += '<area shape="circle" coords="269,355,3" href="javascript:selectTSpoints( 6120,269,355)">';
mtxt += '<area shape="circle" coords="274,355,3" href="javascript:selectTSpoints( 6121,274,355)">';
mtxt += '<area shape="circle" coords="280,355,3" href="javascript:selectTSpoints( 6122,280,355)">';
mtxt += '<area shape="circle" coords="285,355,3" href="javascript:selectTSpoints( 6123,285,355)">';
mtxt += '<area shape="circle" coords="290,355,3" href="javascript:selectTSpoints( 6124,290,355)">';
mtxt += '<area shape="circle" coords="295,355,3" href="javascript:selectTSpoints( 6125,295,355)">';
mtxt += '<area shape="circle" coords="300,355,3" href="javascript:selectTSpoints( 6126,300,355)">';
mtxt += '<area shape="circle" coords="305,355,3" href="javascript:selectTSpoints( 6127,305,355)">';
mtxt += '<area shape="circle" coords="310,355,3" href="javascript:selectTSpoints( 6128,310,355)">';
mtxt += '<area shape="circle" coords="315,355,3" href="javascript:selectTSpoints( 6129,315,355)">';
mtxt += '<area shape="circle" coords="320,355,3" href="javascript:selectTSpoints( 6130,320,355)">';
mtxt += '<area shape="circle" coords="325,355,3" href="javascript:selectTSpoints( 6131,325,355)">';
mtxt += '<area shape="circle" coords="330,355,3" href="javascript:selectTSpoints( 6132,330,355)">';
mtxt += '<area shape="circle" coords="336,355,3" href="javascript:selectTSpoints( 6133,336,355)">';
mtxt += '<area shape="circle" coords="341,355,3" href="javascript:selectTSpoints( 6134,341,355)">';
mtxt += '<area shape="circle" coords="346,355,3" href="javascript:selectTSpoints( 6135,346,355)">';
mtxt += '<area shape="circle" coords="351,355,3" href="javascript:selectTSpoints( 6136,351,355)">';
mtxt += '<area shape="circle" coords="356,355,3" href="javascript:selectTSpoints( 6137,356,355)">';
mtxt += '<area shape="circle" coords="361,355,3" href="javascript:selectTSpoints( 6138,361,355)">';
mtxt += '<area shape="circle" coords="366,355,3" href="javascript:selectTSpoints( 6139,366,355)">';
mtxt += '<area shape="circle" coords="371,355,3" href="javascript:selectTSpoints( 6140,371,355)">';
mtxt += '<area shape="circle" coords="376,355,3" href="javascript:selectTSpoints( 6141,376,355)">';
mtxt += '<area shape="circle" coords="381,355,3" href="javascript:selectTSpoints( 6142,381,355)">';
mtxt += '<area shape="circle" coords="386,355,3" href="javascript:selectTSpoints( 6143,386,355)">';
mtxt += '<area shape="circle" coords="392,355,3" href="javascript:selectTSpoints( 6144,392,355)">';
mtxt += '<area shape="circle" coords="397,355,3" href="javascript:selectTSpoints( 6001,397,355)">';
mtxt += '<area shape="circle" coords="402,355,3" href="javascript:selectTSpoints( 6002,402,355)">';
mtxt += '<area shape="circle" coords="407,355,3" href="javascript:selectTSpoints( 6003,407,355)">';
mtxt += '<area shape="circle" coords="412,355,3" href="javascript:selectTSpoints( 6004,412,355)">';
mtxt += '<area shape="circle" coords="417,355,3" href="javascript:selectTSpoints( 6005,417,355)">';
mtxt += '<area shape="circle" coords="422,355,3" href="javascript:selectTSpoints( 6006,422,355)">';
mtxt += '<area shape="circle" coords="427,355,3" href="javascript:selectTSpoints( 6007,427,355)">';
mtxt += '<area shape="circle" coords="432,355,3" href="javascript:selectTSpoints( 6008,432,355)">';
mtxt += '<area shape="circle" coords="437,355,3" href="javascript:selectTSpoints( 6009,437,355)">';
mtxt += '<area shape="circle" coords="442,355,3" href="javascript:selectTSpoints( 6010,442,355)">';
mtxt += '<area shape="circle" coords="447,355,3" href="javascript:selectTSpoints( 6011,447,355)">';
mtxt += '<area shape="circle" coords="453,355,3" href="javascript:selectTSpoints( 6012,453,355)">';
mtxt += '<area shape="circle" coords="458,355,3" href="javascript:selectTSpoints( 6013,458,355)">';
mtxt += '<area shape="circle" coords="463,355,3" href="javascript:selectTSpoints( 6014,463,355)">';
mtxt += '<area shape="circle" coords="468,355,3" href="javascript:selectTSpoints( 6015,468,355)">';
mtxt += '<area shape="circle" coords="473,355,3" href="javascript:selectTSpoints( 6016,473,355)">';
mtxt += '<area shape="circle" coords="478,355,3" href="javascript:selectTSpoints( 6017,478,355)">';
mtxt += '<area shape="circle" coords="483,355,3" href="javascript:selectTSpoints( 6018,483,355)">';
mtxt += '<area shape="circle" coords="488,355,3" href="javascript:selectTSpoints( 6019,488,355)">';
mtxt += '<area shape="circle" coords="493,355,3" href="javascript:selectTSpoints( 6020,493,355)">';
mtxt += '<area shape="circle" coords="498,355,3" href="javascript:selectTSpoints( 6021,498,355)">';
mtxt += '<area shape="circle" coords="503,355,3" href="javascript:selectTSpoints( 6022,503,355)">';
mtxt += '<area shape="circle" coords="509,355,3" href="javascript:selectTSpoints( 6023,509,355)">';
mtxt += '<area shape="circle" coords="514,355,3" href="javascript:selectTSpoints( 6024,514,355)">';
mtxt += '<area shape="circle" coords="519,355,3" href="javascript:selectTSpoints( 6025,519,355)">';
mtxt += '<area shape="circle" coords="524,355,3" href="javascript:selectTSpoints( 6026,524,355)">';
mtxt += '<area shape="circle" coords="529,355,3" href="javascript:selectTSpoints( 6027,529,355)">';
mtxt += '<area shape="circle" coords="534,355,3" href="javascript:selectTSpoints( 6028,534,355)">';
mtxt += '<area shape="circle" coords="539,355,3" href="javascript:selectTSpoints( 6029,539,355)">';
mtxt += '<area shape="circle" coords="544,355,3" href="javascript:selectTSpoints( 6030,544,355)">';
mtxt += '<area shape="circle" coords="549,355,3" href="javascript:selectTSpoints( 6031,549,355)">';
mtxt += '<area shape="circle" coords="554,355,3" href="javascript:selectTSpoints( 6032,554,355)">';
mtxt += '<area shape="circle" coords="559,355,3" href="javascript:selectTSpoints( 6033,559,355)">';
mtxt += '<area shape="circle" coords="565,355,3" href="javascript:selectTSpoints( 6034,565,355)">';
mtxt += '<area shape="circle" coords="570,355,3" href="javascript:selectTSpoints( 6035,570,355)">';
mtxt += '<area shape="circle" coords="575,355,3" href="javascript:selectTSpoints( 6036,575,355)">';
mtxt += '<area shape="circle" coords="580,355,3" href="javascript:selectTSpoints( 6037,580,355)">';
mtxt += '<area shape="circle" coords="585,355,3" href="javascript:selectTSpoints( 6038,585,355)">';
mtxt += '<area shape="circle" coords="590,355,3" href="javascript:selectTSpoints( 6039,590,355)">';
mtxt += '<area shape="circle" coords="595,355,3" href="javascript:selectTSpoints( 6040,595,355)">';
mtxt += '<area shape="circle" coords="600,355,3" href="javascript:selectTSpoints( 6041,600,355)">';
mtxt += '<area shape="circle" coords="605,355,3" href="javascript:selectTSpoints( 6042,605,355)">';
mtxt += '<area shape="circle" coords="610,355,3" href="javascript:selectTSpoints( 6043,610,355)">';
mtxt += '<area shape="circle" coords="615,355,3" href="javascript:selectTSpoints( 6044,615,355)">';
mtxt += '<area shape="circle" coords="621,355,3" href="javascript:selectTSpoints( 6045,621,355)">';
mtxt += '<area shape="circle" coords="626,355,3" href="javascript:selectTSpoints( 6046,626,355)">';
mtxt += '<area shape="circle" coords="631,355,3" href="javascript:selectTSpoints( 6047,631,355)">';
mtxt += '<area shape="circle" coords="636,355,3" href="javascript:selectTSpoints( 6048,636,355)">';
mtxt += '<area shape="circle" coords="641,355,3" href="javascript:selectTSpoints( 6049,641,355)">';
mtxt += '<area shape="circle" coords="646,355,3" href="javascript:selectTSpoints( 6050,646,355)">';
mtxt += '<area shape="circle" coords="651,355,3" href="javascript:selectTSpoints( 6051,651,355)">';
mtxt += '<area shape="circle" coords="656,355,3" href="javascript:selectTSpoints( 6052,656,355)">';
mtxt += '<area shape="circle" coords="661,355,3" href="javascript:selectTSpoints( 6053,661,355)">';
mtxt += '<area shape="circle" coords="666,355,3" href="javascript:selectTSpoints( 6054,666,355)">';
mtxt += '<area shape="circle" coords="671,355,3" href="javascript:selectTSpoints( 6055,671,355)">';
mtxt += '<area shape="circle" coords="677,355,3" href="javascript:selectTSpoints( 6056,677,355)">';
mtxt += '<area shape="circle" coords="682,355,3" href="javascript:selectTSpoints( 6057,682,355)">';
mtxt += '<area shape="circle" coords="687,355,3" href="javascript:selectTSpoints( 6058,687,355)">';
mtxt += '<area shape="circle" coords="692,355,3" href="javascript:selectTSpoints( 6059,692,355)">';
mtxt += '<area shape="circle" coords="697,355,3" href="javascript:selectTSpoints( 6060,697,355)">';
mtxt += '<area shape="circle" coords="702,355,3" href="javascript:selectTSpoints( 6061,702,355)">';
mtxt += '<area shape="circle" coords="707,355,3" href="javascript:selectTSpoints( 6062,707,355)">';
mtxt += '<area shape="circle" coords="712,355,3" href="javascript:selectTSpoints( 6063,712,355)">';
mtxt += '<area shape="circle" coords="717,355,3" href="javascript:selectTSpoints( 6064,717,355)">';
mtxt += '<area shape="circle" coords="722,355,3" href="javascript:selectTSpoints( 6065,722,355)">';
mtxt += '<area shape="circle" coords="727,355,3" href="javascript:selectTSpoints( 6066,727,355)">';
mtxt += '<area shape="circle" coords="733,355,3" href="javascript:selectTSpoints( 6067,733,355)">';
mtxt += '<area shape="circle" coords="738,355,3" href="javascript:selectTSpoints( 6068,738,355)">';
mtxt += '<area shape="circle" coords="743,355,3" href="javascript:selectTSpoints( 6069,743,355)">';
mtxt += '<area shape="circle" coords="748,355,3" href="javascript:selectTSpoints( 6070,748,355)">';
mtxt += '<area shape="circle" coords="753,355,3" href="javascript:selectTSpoints( 6071,753,355)">';
mtxt += '<area shape="circle" coords="758,355,3" href="javascript:selectTSpoints( 6072,758,355)">';
mtxt += '<area shape="circle" coords=" 30,350,3" href="javascript:selectTSpoints( 7073, 30,350)">';
mtxt += '<area shape="circle" coords=" 35,350,3" href="javascript:selectTSpoints( 7074, 35,350)">';
mtxt += '<area shape="circle" coords=" 40,350,3" href="javascript:selectTSpoints( 7075, 40,350)">';
mtxt += '<area shape="circle" coords=" 45,350,3" href="javascript:selectTSpoints( 7076, 45,350)">';
mtxt += '<area shape="circle" coords=" 50,350,3" href="javascript:selectTSpoints( 7077, 50,350)">';
mtxt += '<area shape="circle" coords=" 56,350,3" href="javascript:selectTSpoints( 7078, 56,350)">';
mtxt += '<area shape="circle" coords=" 61,350,3" href="javascript:selectTSpoints( 7079, 61,350)">';
mtxt += '<area shape="circle" coords=" 66,350,3" href="javascript:selectTSpoints( 7080, 66,350)">';
mtxt += '<area shape="circle" coords=" 71,350,3" href="javascript:selectTSpoints( 7081, 71,350)">';
mtxt += '<area shape="circle" coords=" 76,350,3" href="javascript:selectTSpoints( 7082, 76,350)">';
mtxt += '<area shape="circle" coords=" 81,350,3" href="javascript:selectTSpoints( 7083, 81,350)">';
mtxt += '<area shape="circle" coords=" 86,350,3" href="javascript:selectTSpoints( 7084, 86,350)">';
mtxt += '<area shape="circle" coords=" 91,350,3" href="javascript:selectTSpoints( 7085, 91,350)">';
mtxt += '<area shape="circle" coords=" 96,350,3" href="javascript:selectTSpoints( 7086, 96,350)">';
mtxt += '<area shape="circle" coords="101,350,3" href="javascript:selectTSpoints( 7087,101,350)">';
mtxt += '<area shape="circle" coords="106,350,3" href="javascript:selectTSpoints( 7088,106,350)">';
mtxt += '<area shape="circle" coords="112,350,3" href="javascript:selectTSpoints( 7089,112,350)">';
mtxt += '<area shape="circle" coords="117,350,3" href="javascript:selectTSpoints( 7090,117,350)">';
mtxt += '<area shape="circle" coords="122,350,3" href="javascript:selectTSpoints( 7091,122,350)">';
mtxt += '<area shape="circle" coords="127,350,3" href="javascript:selectTSpoints( 7092,127,350)">';
mtxt += '<area shape="circle" coords="132,350,3" href="javascript:selectTSpoints( 7093,132,350)">';
mtxt += '<area shape="circle" coords="137,350,3" href="javascript:selectTSpoints( 7094,137,350)">';
mtxt += '<area shape="circle" coords="142,350,3" href="javascript:selectTSpoints( 7095,142,350)">';
mtxt += '<area shape="circle" coords="147,350,3" href="javascript:selectTSpoints( 7096,147,350)">';
mtxt += '<area shape="circle" coords="152,350,3" href="javascript:selectTSpoints( 7097,152,350)">';
mtxt += '<area shape="circle" coords="157,350,3" href="javascript:selectTSpoints( 7098,157,350)">';
mtxt += '<area shape="circle" coords="162,350,3" href="javascript:selectTSpoints( 7099,162,350)">';
mtxt += '<area shape="circle" coords="168,350,3" href="javascript:selectTSpoints( 7100,168,350)">';
mtxt += '<area shape="circle" coords="173,350,3" href="javascript:selectTSpoints( 7101,173,350)">';
mtxt += '<area shape="circle" coords="178,350,3" href="javascript:selectTSpoints( 7102,178,350)">';
mtxt += '<area shape="circle" coords="183,350,3" href="javascript:selectTSpoints( 7103,183,350)">';
mtxt += '<area shape="circle" coords="188,350,3" href="javascript:selectTSpoints( 7104,188,350)">';
mtxt += '<area shape="circle" coords="193,350,3" href="javascript:selectTSpoints( 7105,193,350)">';
mtxt += '<area shape="circle" coords="198,350,3" href="javascript:selectTSpoints( 7106,198,350)">';
mtxt += '<area shape="circle" coords="203,350,3" href="javascript:selectTSpoints( 7107,203,350)">';
mtxt += '<area shape="circle" coords="208,350,3" href="javascript:selectTSpoints( 7108,208,350)">';
mtxt += '<area shape="circle" coords="213,350,3" href="javascript:selectTSpoints( 7109,213,350)">';
mtxt += '<area shape="circle" coords="218,350,3" href="javascript:selectTSpoints( 7110,218,350)">';
mtxt += '<area shape="circle" coords="224,350,3" href="javascript:selectTSpoints( 7111,224,350)">';
mtxt += '<area shape="circle" coords="229,350,3" href="javascript:selectTSpoints( 7112,229,350)">';
mtxt += '<area shape="circle" coords="234,350,3" href="javascript:selectTSpoints( 7113,234,350)">';
mtxt += '<area shape="circle" coords="239,350,3" href="javascript:selectTSpoints( 7114,239,350)">';
mtxt += '<area shape="circle" coords="244,350,3" href="javascript:selectTSpoints( 7115,244,350)">';
mtxt += '<area shape="circle" coords="249,350,3" href="javascript:selectTSpoints( 7116,249,350)">';
mtxt += '<area shape="circle" coords="254,350,3" href="javascript:selectTSpoints( 7117,254,350)">';
mtxt += '<area shape="circle" coords="259,350,3" href="javascript:selectTSpoints( 7118,259,350)">';
mtxt += '<area shape="circle" coords="264,350,3" href="javascript:selectTSpoints( 7119,264,350)">';
mtxt += '<area shape="circle" coords="269,350,3" href="javascript:selectTSpoints( 7120,269,350)">';
mtxt += '<area shape="circle" coords="274,350,3" href="javascript:selectTSpoints( 7121,274,350)">';
mtxt += '<area shape="circle" coords="280,350,3" href="javascript:selectTSpoints( 7122,280,350)">';
mtxt += '<area shape="circle" coords="285,350,3" href="javascript:selectTSpoints( 7123,285,350)">';
mtxt += '<area shape="circle" coords="290,350,3" href="javascript:selectTSpoints( 7124,290,350)">';
mtxt += '<area shape="circle" coords="295,350,3" href="javascript:selectTSpoints( 7125,295,350)">';
mtxt += '<area shape="circle" coords="300,350,3" href="javascript:selectTSpoints( 7126,300,350)">';
mtxt += '<area shape="circle" coords="305,350,3" href="javascript:selectTSpoints( 7127,305,350)">';
mtxt += '<area shape="circle" coords="310,350,3" href="javascript:selectTSpoints( 7128,310,350)">';
mtxt += '<area shape="circle" coords="315,350,3" href="javascript:selectTSpoints( 7129,315,350)">';
mtxt += '<area shape="circle" coords="320,350,3" href="javascript:selectTSpoints( 7130,320,350)">';
mtxt += '<area shape="circle" coords="325,350,3" href="javascript:selectTSpoints( 7131,325,350)">';
mtxt += '<area shape="circle" coords="330,350,3" href="javascript:selectTSpoints( 7132,330,350)">';
mtxt += '<area shape="circle" coords="336,350,3" href="javascript:selectTSpoints( 7133,336,350)">';
mtxt += '<area shape="circle" coords="341,350,3" href="javascript:selectTSpoints( 7134,341,350)">';
mtxt += '<area shape="circle" coords="346,350,3" href="javascript:selectTSpoints( 7135,346,350)">';
mtxt += '<area shape="circle" coords="351,350,3" href="javascript:selectTSpoints( 7136,351,350)">';
mtxt += '<area shape="circle" coords="356,350,3" href="javascript:selectTSpoints( 7137,356,350)">';
mtxt += '<area shape="circle" coords="361,350,3" href="javascript:selectTSpoints( 7138,361,350)">';
mtxt += '<area shape="circle" coords="366,350,3" href="javascript:selectTSpoints( 7139,366,350)">';
mtxt += '<area shape="circle" coords="371,350,3" href="javascript:selectTSpoints( 7140,371,350)">';
mtxt += '<area shape="circle" coords="376,350,3" href="javascript:selectTSpoints( 7141,376,350)">';
mtxt += '<area shape="circle" coords="381,350,3" href="javascript:selectTSpoints( 7142,381,350)">';
mtxt += '<area shape="circle" coords="386,350,3" href="javascript:selectTSpoints( 7143,386,350)">';
mtxt += '<area shape="circle" coords="392,350,3" href="javascript:selectTSpoints( 7144,392,350)">';
mtxt += '<area shape="circle" coords="397,350,3" href="javascript:selectTSpoints( 7001,397,350)">';
mtxt += '<area shape="circle" coords="402,350,3" href="javascript:selectTSpoints( 7002,402,350)">';
mtxt += '<area shape="circle" coords="407,350,3" href="javascript:selectTSpoints( 7003,407,350)">';
mtxt += '<area shape="circle" coords="412,350,3" href="javascript:selectTSpoints( 7004,412,350)">';
mtxt += '<area shape="circle" coords="417,350,3" href="javascript:selectTSpoints( 7005,417,350)">';
mtxt += '<area shape="circle" coords="422,350,3" href="javascript:selectTSpoints( 7006,422,350)">';
mtxt += '<area shape="circle" coords="427,350,3" href="javascript:selectTSpoints( 7007,427,350)">';
mtxt += '<area shape="circle" coords="432,350,3" href="javascript:selectTSpoints( 7008,432,350)">';
mtxt += '<area shape="circle" coords="437,350,3" href="javascript:selectTSpoints( 7009,437,350)">';
mtxt += '<area shape="circle" coords="442,350,3" href="javascript:selectTSpoints( 7010,442,350)">';
mtxt += '<area shape="circle" coords="447,350,3" href="javascript:selectTSpoints( 7011,447,350)">';
mtxt += '<area shape="circle" coords="453,350,3" href="javascript:selectTSpoints( 7012,453,350)">';
mtxt += '<area shape="circle" coords="458,350,3" href="javascript:selectTSpoints( 7013,458,350)">';
mtxt += '<area shape="circle" coords="463,350,3" href="javascript:selectTSpoints( 7014,463,350)">';
mtxt += '<area shape="circle" coords="468,350,3" href="javascript:selectTSpoints( 7015,468,350)">';
mtxt += '<area shape="circle" coords="473,350,3" href="javascript:selectTSpoints( 7016,473,350)">';
mtxt += '<area shape="circle" coords="478,350,3" href="javascript:selectTSpoints( 7017,478,350)">';
mtxt += '<area shape="circle" coords="483,350,3" href="javascript:selectTSpoints( 7018,483,350)">';
mtxt += '<area shape="circle" coords="488,350,3" href="javascript:selectTSpoints( 7019,488,350)">';
mtxt += '<area shape="circle" coords="493,350,3" href="javascript:selectTSpoints( 7020,493,350)">';
mtxt += '<area shape="circle" coords="498,350,3" href="javascript:selectTSpoints( 7021,498,350)">';
mtxt += '<area shape="circle" coords="503,350,3" href="javascript:selectTSpoints( 7022,503,350)">';
mtxt += '<area shape="circle" coords="509,350,3" href="javascript:selectTSpoints( 7023,509,350)">';
mtxt += '<area shape="circle" coords="514,350,3" href="javascript:selectTSpoints( 7024,514,350)">';
mtxt += '<area shape="circle" coords="519,350,3" href="javascript:selectTSpoints( 7025,519,350)">';
mtxt += '<area shape="circle" coords="524,350,3" href="javascript:selectTSpoints( 7026,524,350)">';
mtxt += '<area shape="circle" coords="529,350,3" href="javascript:selectTSpoints( 7027,529,350)">';
mtxt += '<area shape="circle" coords="534,350,3" href="javascript:selectTSpoints( 7028,534,350)">';
mtxt += '<area shape="circle" coords="539,350,3" href="javascript:selectTSpoints( 7029,539,350)">';
mtxt += '<area shape="circle" coords="544,350,3" href="javascript:selectTSpoints( 7030,544,350)">';
mtxt += '<area shape="circle" coords="549,350,3" href="javascript:selectTSpoints( 7031,549,350)">';
mtxt += '<area shape="circle" coords="554,350,3" href="javascript:selectTSpoints( 7032,554,350)">';
mtxt += '<area shape="circle" coords="559,350,3" href="javascript:selectTSpoints( 7033,559,350)">';
mtxt += '<area shape="circle" coords="565,350,3" href="javascript:selectTSpoints( 7034,565,350)">';
mtxt += '<area shape="circle" coords="570,350,3" href="javascript:selectTSpoints( 7035,570,350)">';
mtxt += '<area shape="circle" coords="575,350,3" href="javascript:selectTSpoints( 7036,575,350)">';
mtxt += '<area shape="circle" coords="580,350,3" href="javascript:selectTSpoints( 7037,580,350)">';
mtxt += '<area shape="circle" coords="585,350,3" href="javascript:selectTSpoints( 7038,585,350)">';
mtxt += '<area shape="circle" coords="590,350,3" href="javascript:selectTSpoints( 7039,590,350)">';
mtxt += '<area shape="circle" coords="595,350,3" href="javascript:selectTSpoints( 7040,595,350)">';
mtxt += '<area shape="circle" coords="600,350,3" href="javascript:selectTSpoints( 7041,600,350)">';
mtxt += '<area shape="circle" coords="605,350,3" href="javascript:selectTSpoints( 7042,605,350)">';
mtxt += '<area shape="circle" coords="610,350,3" href="javascript:selectTSpoints( 7043,610,350)">';
mtxt += '<area shape="circle" coords="615,350,3" href="javascript:selectTSpoints( 7044,615,350)">';
mtxt += '<area shape="circle" coords="621,350,3" href="javascript:selectTSpoints( 7045,621,350)">';
mtxt += '<area shape="circle" coords="626,350,3" href="javascript:selectTSpoints( 7046,626,350)">';
mtxt += '<area shape="circle" coords="631,350,3" href="javascript:selectTSpoints( 7047,631,350)">';
mtxt += '<area shape="circle" coords="636,350,3" href="javascript:selectTSpoints( 7048,636,350)">';
mtxt += '<area shape="circle" coords="641,350,3" href="javascript:selectTSpoints( 7049,641,350)">';
mtxt += '<area shape="circle" coords="646,350,3" href="javascript:selectTSpoints( 7050,646,350)">';
mtxt += '<area shape="circle" coords="651,350,3" href="javascript:selectTSpoints( 7051,651,350)">';
mtxt += '<area shape="circle" coords="656,350,3" href="javascript:selectTSpoints( 7052,656,350)">';
mtxt += '<area shape="circle" coords="661,350,3" href="javascript:selectTSpoints( 7053,661,350)">';
mtxt += '<area shape="circle" coords="666,350,3" href="javascript:selectTSpoints( 7054,666,350)">';
mtxt += '<area shape="circle" coords="671,350,3" href="javascript:selectTSpoints( 7055,671,350)">';
mtxt += '<area shape="circle" coords="677,350,3" href="javascript:selectTSpoints( 7056,677,350)">';
mtxt += '<area shape="circle" coords="682,350,3" href="javascript:selectTSpoints( 7057,682,350)">';
mtxt += '<area shape="circle" coords="687,350,3" href="javascript:selectTSpoints( 7058,687,350)">';
mtxt += '<area shape="circle" coords="692,350,3" href="javascript:selectTSpoints( 7059,692,350)">';
mtxt += '<area shape="circle" coords="697,350,3" href="javascript:selectTSpoints( 7060,697,350)">';
mtxt += '<area shape="circle" coords="702,350,3" href="javascript:selectTSpoints( 7061,702,350)">';
mtxt += '<area shape="circle" coords="707,350,3" href="javascript:selectTSpoints( 7062,707,350)">';
mtxt += '<area shape="circle" coords="712,350,3" href="javascript:selectTSpoints( 7063,712,350)">';
mtxt += '<area shape="circle" coords="717,350,3" href="javascript:selectTSpoints( 7064,717,350)">';
mtxt += '<area shape="circle" coords="722,350,3" href="javascript:selectTSpoints( 7065,722,350)">';
mtxt += '<area shape="circle" coords="727,350,3" href="javascript:selectTSpoints( 7066,727,350)">';
mtxt += '<area shape="circle" coords="733,350,3" href="javascript:selectTSpoints( 7067,733,350)">';
mtxt += '<area shape="circle" coords="738,350,3" href="javascript:selectTSpoints( 7068,738,350)">';
mtxt += '<area shape="circle" coords="743,350,3" href="javascript:selectTSpoints( 7069,743,350)">';
mtxt += '<area shape="circle" coords="748,350,3" href="javascript:selectTSpoints( 7070,748,350)">';
mtxt += '<area shape="circle" coords="753,350,3" href="javascript:selectTSpoints( 7071,753,350)">';
mtxt += '<area shape="circle" coords="758,350,3" href="javascript:selectTSpoints( 7072,758,350)">';
mtxt += '<area shape="circle" coords=" 30,345,3" href="javascript:selectTSpoints( 8073, 30,345)">';
mtxt += '<area shape="circle" coords=" 35,345,3" href="javascript:selectTSpoints( 8074, 35,345)">';
mtxt += '<area shape="circle" coords=" 40,345,3" href="javascript:selectTSpoints( 8075, 40,345)">';
mtxt += '<area shape="circle" coords=" 45,345,3" href="javascript:selectTSpoints( 8076, 45,345)">';
mtxt += '<area shape="circle" coords=" 50,345,3" href="javascript:selectTSpoints( 8077, 50,345)">';
mtxt += '<area shape="circle" coords=" 56,345,3" href="javascript:selectTSpoints( 8078, 56,345)">';
mtxt += '<area shape="circle" coords=" 61,345,3" href="javascript:selectTSpoints( 8079, 61,345)">';
mtxt += '<area shape="circle" coords=" 66,345,3" href="javascript:selectTSpoints( 8080, 66,345)">';
mtxt += '<area shape="circle" coords=" 71,345,3" href="javascript:selectTSpoints( 8081, 71,345)">';
mtxt += '<area shape="circle" coords=" 76,345,3" href="javascript:selectTSpoints( 8082, 76,345)">';
mtxt += '<area shape="circle" coords=" 81,345,3" href="javascript:selectTSpoints( 8083, 81,345)">';
mtxt += '<area shape="circle" coords=" 86,345,3" href="javascript:selectTSpoints( 8084, 86,345)">';
mtxt += '<area shape="circle" coords=" 91,345,3" href="javascript:selectTSpoints( 8085, 91,345)">';
mtxt += '<area shape="circle" coords=" 96,345,3" href="javascript:selectTSpoints( 8086, 96,345)">';
mtxt += '<area shape="circle" coords="101,345,3" href="javascript:selectTSpoints( 8087,101,345)">';
mtxt += '<area shape="circle" coords="106,345,3" href="javascript:selectTSpoints( 8088,106,345)">';
mtxt += '<area shape="circle" coords="112,345,3" href="javascript:selectTSpoints( 8089,112,345)">';
mtxt += '<area shape="circle" coords="117,345,3" href="javascript:selectTSpoints( 8090,117,345)">';
mtxt += '<area shape="circle" coords="122,345,3" href="javascript:selectTSpoints( 8091,122,345)">';
mtxt += '<area shape="circle" coords="127,345,3" href="javascript:selectTSpoints( 8092,127,345)">';
mtxt += '<area shape="circle" coords="132,345,3" href="javascript:selectTSpoints( 8093,132,345)">';
mtxt += '<area shape="circle" coords="137,345,3" href="javascript:selectTSpoints( 8094,137,345)">';
mtxt += '<area shape="circle" coords="142,345,3" href="javascript:selectTSpoints( 8095,142,345)">';
mtxt += '<area shape="circle" coords="147,345,3" href="javascript:selectTSpoints( 8096,147,345)">';
mtxt += '<area shape="circle" coords="152,345,3" href="javascript:selectTSpoints( 8097,152,345)">';
mtxt += '<area shape="circle" coords="157,345,3" href="javascript:selectTSpoints( 8098,157,345)">';
mtxt += '<area shape="circle" coords="162,345,3" href="javascript:selectTSpoints( 8099,162,345)">';
mtxt += '<area shape="circle" coords="168,345,3" href="javascript:selectTSpoints( 8100,168,345)">';
mtxt += '<area shape="circle" coords="173,345,3" href="javascript:selectTSpoints( 8101,173,345)">';
mtxt += '<area shape="circle" coords="178,345,3" href="javascript:selectTSpoints( 8102,178,345)">';
mtxt += '<area shape="circle" coords="183,345,3" href="javascript:selectTSpoints( 8103,183,345)">';
mtxt += '<area shape="circle" coords="188,345,3" href="javascript:selectTSpoints( 8104,188,345)">';
mtxt += '<area shape="circle" coords="193,345,3" href="javascript:selectTSpoints( 8105,193,345)">';
mtxt += '<area shape="circle" coords="198,345,3" href="javascript:selectTSpoints( 8106,198,345)">';
mtxt += '<area shape="circle" coords="203,345,3" href="javascript:selectTSpoints( 8107,203,345)">';
mtxt += '<area shape="circle" coords="208,345,3" href="javascript:selectTSpoints( 8108,208,345)">';
mtxt += '<area shape="circle" coords="213,345,3" href="javascript:selectTSpoints( 8109,213,345)">';
mtxt += '<area shape="circle" coords="218,345,3" href="javascript:selectTSpoints( 8110,218,345)">';
mtxt += '<area shape="circle" coords="224,345,3" href="javascript:selectTSpoints( 8111,224,345)">';
mtxt += '<area shape="circle" coords="229,345,3" href="javascript:selectTSpoints( 8112,229,345)">';
mtxt += '<area shape="circle" coords="234,345,3" href="javascript:selectTSpoints( 8113,234,345)">';
mtxt += '<area shape="circle" coords="239,345,3" href="javascript:selectTSpoints( 8114,239,345)">';
mtxt += '<area shape="circle" coords="244,345,3" href="javascript:selectTSpoints( 8115,244,345)">';
mtxt += '<area shape="circle" coords="249,345,3" href="javascript:selectTSpoints( 8116,249,345)">';
mtxt += '<area shape="circle" coords="254,345,3" href="javascript:selectTSpoints( 8117,254,345)">';
mtxt += '<area shape="circle" coords="259,345,3" href="javascript:selectTSpoints( 8118,259,345)">';
mtxt += '<area shape="circle" coords="264,345,3" href="javascript:selectTSpoints( 8119,264,345)">';
mtxt += '<area shape="circle" coords="269,345,3" href="javascript:selectTSpoints( 8120,269,345)">';
mtxt += '<area shape="circle" coords="274,345,3" href="javascript:selectTSpoints( 8121,274,345)">';
mtxt += '<area shape="circle" coords="280,345,3" href="javascript:selectTSpoints( 8122,280,345)">';
mtxt += '<area shape="circle" coords="285,345,3" href="javascript:selectTSpoints( 8123,285,345)">';
mtxt += '<area shape="circle" coords="290,345,3" href="javascript:selectTSpoints( 8124,290,345)">';
mtxt += '<area shape="circle" coords="295,345,3" href="javascript:selectTSpoints( 8125,295,345)">';
mtxt += '<area shape="circle" coords="300,345,3" href="javascript:selectTSpoints( 8126,300,345)">';
mtxt += '<area shape="circle" coords="305,345,3" href="javascript:selectTSpoints( 8127,305,345)">';
mtxt += '<area shape="circle" coords="310,345,3" href="javascript:selectTSpoints( 8128,310,345)">';
mtxt += '<area shape="circle" coords="315,345,3" href="javascript:selectTSpoints( 8129,315,345)">';
mtxt += '<area shape="circle" coords="320,345,3" href="javascript:selectTSpoints( 8130,320,345)">';
mtxt += '<area shape="circle" coords="325,345,3" href="javascript:selectTSpoints( 8131,325,345)">';
mtxt += '<area shape="circle" coords="330,345,3" href="javascript:selectTSpoints( 8132,330,345)">';
mtxt += '<area shape="circle" coords="336,345,3" href="javascript:selectTSpoints( 8133,336,345)">';
mtxt += '<area shape="circle" coords="341,345,3" href="javascript:selectTSpoints( 8134,341,345)">';
mtxt += '<area shape="circle" coords="346,345,3" href="javascript:selectTSpoints( 8135,346,345)">';
mtxt += '<area shape="circle" coords="351,345,3" href="javascript:selectTSpoints( 8136,351,345)">';
mtxt += '<area shape="circle" coords="356,345,3" href="javascript:selectTSpoints( 8137,356,345)">';
mtxt += '<area shape="circle" coords="361,345,3" href="javascript:selectTSpoints( 8138,361,345)">';
mtxt += '<area shape="circle" coords="366,345,3" href="javascript:selectTSpoints( 8139,366,345)">';
mtxt += '<area shape="circle" coords="371,345,3" href="javascript:selectTSpoints( 8140,371,345)">';
mtxt += '<area shape="circle" coords="376,345,3" href="javascript:selectTSpoints( 8141,376,345)">';
mtxt += '<area shape="circle" coords="381,345,3" href="javascript:selectTSpoints( 8142,381,345)">';
mtxt += '<area shape="circle" coords="386,345,3" href="javascript:selectTSpoints( 8143,386,345)">';
mtxt += '<area shape="circle" coords="392,345,3" href="javascript:selectTSpoints( 8144,392,345)">';
mtxt += '<area shape="circle" coords="397,345,3" href="javascript:selectTSpoints( 8001,397,345)">';
mtxt += '<area shape="circle" coords="402,345,3" href="javascript:selectTSpoints( 8002,402,345)">';
mtxt += '<area shape="circle" coords="407,345,3" href="javascript:selectTSpoints( 8003,407,345)">';
mtxt += '<area shape="circle" coords="412,345,3" href="javascript:selectTSpoints( 8004,412,345)">';
mtxt += '<area shape="circle" coords="417,345,3" href="javascript:selectTSpoints( 8005,417,345)">';
mtxt += '<area shape="circle" coords="422,345,3" href="javascript:selectTSpoints( 8006,422,345)">';
mtxt += '<area shape="circle" coords="427,345,3" href="javascript:selectTSpoints( 8007,427,345)">';
mtxt += '<area shape="circle" coords="432,345,3" href="javascript:selectTSpoints( 8008,432,345)">';
mtxt += '<area shape="circle" coords="437,345,3" href="javascript:selectTSpoints( 8009,437,345)">';
mtxt += '<area shape="circle" coords="442,345,3" href="javascript:selectTSpoints( 8010,442,345)">';
mtxt += '<area shape="circle" coords="447,345,3" href="javascript:selectTSpoints( 8011,447,345)">';
mtxt += '<area shape="circle" coords="453,345,3" href="javascript:selectTSpoints( 8012,453,345)">';
mtxt += '<area shape="circle" coords="458,345,3" href="javascript:selectTSpoints( 8013,458,345)">';
mtxt += '<area shape="circle" coords="463,345,3" href="javascript:selectTSpoints( 8014,463,345)">';
mtxt += '<area shape="circle" coords="468,345,3" href="javascript:selectTSpoints( 8015,468,345)">';
mtxt += '<area shape="circle" coords="473,345,3" href="javascript:selectTSpoints( 8016,473,345)">';
mtxt += '<area shape="circle" coords="478,345,3" href="javascript:selectTSpoints( 8017,478,345)">';
mtxt += '<area shape="circle" coords="483,345,3" href="javascript:selectTSpoints( 8018,483,345)">';
mtxt += '<area shape="circle" coords="488,345,3" href="javascript:selectTSpoints( 8019,488,345)">';
mtxt += '<area shape="circle" coords="493,345,3" href="javascript:selectTSpoints( 8020,493,345)">';
mtxt += '<area shape="circle" coords="498,345,3" href="javascript:selectTSpoints( 8021,498,345)">';
mtxt += '<area shape="circle" coords="503,345,3" href="javascript:selectTSpoints( 8022,503,345)">';
mtxt += '<area shape="circle" coords="509,345,3" href="javascript:selectTSpoints( 8023,509,345)">';
mtxt += '<area shape="circle" coords="514,345,3" href="javascript:selectTSpoints( 8024,514,345)">';
mtxt += '<area shape="circle" coords="519,345,3" href="javascript:selectTSpoints( 8025,519,345)">';
mtxt += '<area shape="circle" coords="524,345,3" href="javascript:selectTSpoints( 8026,524,345)">';
mtxt += '<area shape="circle" coords="529,345,3" href="javascript:selectTSpoints( 8027,529,345)">';
mtxt += '<area shape="circle" coords="534,345,3" href="javascript:selectTSpoints( 8028,534,345)">';
mtxt += '<area shape="circle" coords="539,345,3" href="javascript:selectTSpoints( 8029,539,345)">';
mtxt += '<area shape="circle" coords="544,345,3" href="javascript:selectTSpoints( 8030,544,345)">';
mtxt += '<area shape="circle" coords="549,345,3" href="javascript:selectTSpoints( 8031,549,345)">';
mtxt += '<area shape="circle" coords="554,345,3" href="javascript:selectTSpoints( 8032,554,345)">';
mtxt += '<area shape="circle" coords="559,345,3" href="javascript:selectTSpoints( 8033,559,345)">';
mtxt += '<area shape="circle" coords="565,345,3" href="javascript:selectTSpoints( 8034,565,345)">';
mtxt += '<area shape="circle" coords="570,345,3" href="javascript:selectTSpoints( 8035,570,345)">';
mtxt += '<area shape="circle" coords="575,345,3" href="javascript:selectTSpoints( 8036,575,345)">';
mtxt += '<area shape="circle" coords="580,345,3" href="javascript:selectTSpoints( 8037,580,345)">';
mtxt += '<area shape="circle" coords="585,345,3" href="javascript:selectTSpoints( 8038,585,345)">';
mtxt += '<area shape="circle" coords="590,345,3" href="javascript:selectTSpoints( 8039,590,345)">';
mtxt += '<area shape="circle" coords="595,345,3" href="javascript:selectTSpoints( 8040,595,345)">';
mtxt += '<area shape="circle" coords="600,345,3" href="javascript:selectTSpoints( 8041,600,345)">';
mtxt += '<area shape="circle" coords="605,345,3" href="javascript:selectTSpoints( 8042,605,345)">';
mtxt += '<area shape="circle" coords="610,345,3" href="javascript:selectTSpoints( 8043,610,345)">';
mtxt += '<area shape="circle" coords="615,345,3" href="javascript:selectTSpoints( 8044,615,345)">';
mtxt += '<area shape="circle" coords="621,345,3" href="javascript:selectTSpoints( 8045,621,345)">';
mtxt += '<area shape="circle" coords="626,345,3" href="javascript:selectTSpoints( 8046,626,345)">';
mtxt += '<area shape="circle" coords="631,345,3" href="javascript:selectTSpoints( 8047,631,345)">';
mtxt += '<area shape="circle" coords="636,345,3" href="javascript:selectTSpoints( 8048,636,345)">';
mtxt += '<area shape="circle" coords="641,345,3" href="javascript:selectTSpoints( 8049,641,345)">';
mtxt += '<area shape="circle" coords="646,345,3" href="javascript:selectTSpoints( 8050,646,345)">';
mtxt += '<area shape="circle" coords="651,345,3" href="javascript:selectTSpoints( 8051,651,345)">';
mtxt += '<area shape="circle" coords="656,345,3" href="javascript:selectTSpoints( 8052,656,345)">';
mtxt += '<area shape="circle" coords="661,345,3" href="javascript:selectTSpoints( 8053,661,345)">';
mtxt += '<area shape="circle" coords="666,345,3" href="javascript:selectTSpoints( 8054,666,345)">';
mtxt += '<area shape="circle" coords="671,345,3" href="javascript:selectTSpoints( 8055,671,345)">';
mtxt += '<area shape="circle" coords="677,345,3" href="javascript:selectTSpoints( 8056,677,345)">';
mtxt += '<area shape="circle" coords="682,345,3" href="javascript:selectTSpoints( 8057,682,345)">';
mtxt += '<area shape="circle" coords="687,345,3" href="javascript:selectTSpoints( 8058,687,345)">';
mtxt += '<area shape="circle" coords="692,345,3" href="javascript:selectTSpoints( 8059,692,345)">';
mtxt += '<area shape="circle" coords="697,345,3" href="javascript:selectTSpoints( 8060,697,345)">';
mtxt += '<area shape="circle" coords="702,345,3" href="javascript:selectTSpoints( 8061,702,345)">';
mtxt += '<area shape="circle" coords="707,345,3" href="javascript:selectTSpoints( 8062,707,345)">';
mtxt += '<area shape="circle" coords="712,345,3" href="javascript:selectTSpoints( 8063,712,345)">';
mtxt += '<area shape="circle" coords="717,345,3" href="javascript:selectTSpoints( 8064,717,345)">';
mtxt += '<area shape="circle" coords="722,345,3" href="javascript:selectTSpoints( 8065,722,345)">';
mtxt += '<area shape="circle" coords="727,345,3" href="javascript:selectTSpoints( 8066,727,345)">';
mtxt += '<area shape="circle" coords="733,345,3" href="javascript:selectTSpoints( 8067,733,345)">';
mtxt += '<area shape="circle" coords="738,345,3" href="javascript:selectTSpoints( 8068,738,345)">';
mtxt += '<area shape="circle" coords="743,345,3" href="javascript:selectTSpoints( 8069,743,345)">';
mtxt += '<area shape="circle" coords="748,345,3" href="javascript:selectTSpoints( 8070,748,345)">';
mtxt += '<area shape="circle" coords="753,345,3" href="javascript:selectTSpoints( 8071,753,345)">';
mtxt += '<area shape="circle" coords="758,345,3" href="javascript:selectTSpoints( 8072,758,345)">';
mtxt += '<area shape="circle" coords=" 30,340,3" href="javascript:selectTSpoints( 9073, 30,340)">';
mtxt += '<area shape="circle" coords=" 35,340,3" href="javascript:selectTSpoints( 9074, 35,340)">';
mtxt += '<area shape="circle" coords=" 40,340,3" href="javascript:selectTSpoints( 9075, 40,340)">';
mtxt += '<area shape="circle" coords=" 45,340,3" href="javascript:selectTSpoints( 9076, 45,340)">';
mtxt += '<area shape="circle" coords=" 50,340,3" href="javascript:selectTSpoints( 9077, 50,340)">';
mtxt += '<area shape="circle" coords=" 56,340,3" href="javascript:selectTSpoints( 9078, 56,340)">';
mtxt += '<area shape="circle" coords=" 61,340,3" href="javascript:selectTSpoints( 9079, 61,340)">';
mtxt += '<area shape="circle" coords=" 66,340,3" href="javascript:selectTSpoints( 9080, 66,340)">';
mtxt += '<area shape="circle" coords=" 71,340,3" href="javascript:selectTSpoints( 9081, 71,340)">';
mtxt += '<area shape="circle" coords=" 76,340,3" href="javascript:selectTSpoints( 9082, 76,340)">';
mtxt += '<area shape="circle" coords=" 81,340,3" href="javascript:selectTSpoints( 9083, 81,340)">';
mtxt += '<area shape="circle" coords=" 86,340,3" href="javascript:selectTSpoints( 9084, 86,340)">';
mtxt += '<area shape="circle" coords=" 91,340,3" href="javascript:selectTSpoints( 9085, 91,340)">';
mtxt += '<area shape="circle" coords=" 96,340,3" href="javascript:selectTSpoints( 9086, 96,340)">';
mtxt += '<area shape="circle" coords="101,340,3" href="javascript:selectTSpoints( 9087,101,340)">';
mtxt += '<area shape="circle" coords="106,340,3" href="javascript:selectTSpoints( 9088,106,340)">';
mtxt += '<area shape="circle" coords="112,340,3" href="javascript:selectTSpoints( 9089,112,340)">';
mtxt += '<area shape="circle" coords="117,340,3" href="javascript:selectTSpoints( 9090,117,340)">';
mtxt += '<area shape="circle" coords="122,340,3" href="javascript:selectTSpoints( 9091,122,340)">';
mtxt += '<area shape="circle" coords="127,340,3" href="javascript:selectTSpoints( 9092,127,340)">';
mtxt += '<area shape="circle" coords="132,340,3" href="javascript:selectTSpoints( 9093,132,340)">';
mtxt += '<area shape="circle" coords="137,340,3" href="javascript:selectTSpoints( 9094,137,340)">';
mtxt += '<area shape="circle" coords="142,340,3" href="javascript:selectTSpoints( 9095,142,340)">';
mtxt += '<area shape="circle" coords="147,340,3" href="javascript:selectTSpoints( 9096,147,340)">';
mtxt += '<area shape="circle" coords="152,340,3" href="javascript:selectTSpoints( 9097,152,340)">';
mtxt += '<area shape="circle" coords="157,340,3" href="javascript:selectTSpoints( 9098,157,340)">';
mtxt += '<area shape="circle" coords="162,340,3" href="javascript:selectTSpoints( 9099,162,340)">';
mtxt += '<area shape="circle" coords="168,340,3" href="javascript:selectTSpoints( 9100,168,340)">';
mtxt += '<area shape="circle" coords="173,340,3" href="javascript:selectTSpoints( 9101,173,340)">';
mtxt += '<area shape="circle" coords="178,340,3" href="javascript:selectTSpoints( 9102,178,340)">';
mtxt += '<area shape="circle" coords="183,340,3" href="javascript:selectTSpoints( 9103,183,340)">';
mtxt += '<area shape="circle" coords="188,340,3" href="javascript:selectTSpoints( 9104,188,340)">';
mtxt += '<area shape="circle" coords="193,340,3" href="javascript:selectTSpoints( 9105,193,340)">';
mtxt += '<area shape="circle" coords="198,340,3" href="javascript:selectTSpoints( 9106,198,340)">';
mtxt += '<area shape="circle" coords="203,340,3" href="javascript:selectTSpoints( 9107,203,340)">';
mtxt += '<area shape="circle" coords="208,340,3" href="javascript:selectTSpoints( 9108,208,340)">';
mtxt += '<area shape="circle" coords="213,340,3" href="javascript:selectTSpoints( 9109,213,340)">';
mtxt += '<area shape="circle" coords="218,340,3" href="javascript:selectTSpoints( 9110,218,340)">';
mtxt += '<area shape="circle" coords="224,340,3" href="javascript:selectTSpoints( 9111,224,340)">';
mtxt += '<area shape="circle" coords="229,340,3" href="javascript:selectTSpoints( 9112,229,340)">';
mtxt += '<area shape="circle" coords="234,340,3" href="javascript:selectTSpoints( 9113,234,340)">';
mtxt += '<area shape="circle" coords="239,340,3" href="javascript:selectTSpoints( 9114,239,340)">';
mtxt += '<area shape="circle" coords="244,340,3" href="javascript:selectTSpoints( 9115,244,340)">';
mtxt += '<area shape="circle" coords="249,340,3" href="javascript:selectTSpoints( 9116,249,340)">';
mtxt += '<area shape="circle" coords="254,340,3" href="javascript:selectTSpoints( 9117,254,340)">';
mtxt += '<area shape="circle" coords="259,340,3" href="javascript:selectTSpoints( 9118,259,340)">';
mtxt += '<area shape="circle" coords="264,340,3" href="javascript:selectTSpoints( 9119,264,340)">';
mtxt += '<area shape="circle" coords="269,340,3" href="javascript:selectTSpoints( 9120,269,340)">';
mtxt += '<area shape="circle" coords="274,340,3" href="javascript:selectTSpoints( 9121,274,340)">';
mtxt += '<area shape="circle" coords="280,340,3" href="javascript:selectTSpoints( 9122,280,340)">';
mtxt += '<area shape="circle" coords="285,340,3" href="javascript:selectTSpoints( 9123,285,340)">';
mtxt += '<area shape="circle" coords="290,340,3" href="javascript:selectTSpoints( 9124,290,340)">';
mtxt += '<area shape="circle" coords="295,340,3" href="javascript:selectTSpoints( 9125,295,340)">';
mtxt += '<area shape="circle" coords="300,340,3" href="javascript:selectTSpoints( 9126,300,340)">';
mtxt += '<area shape="circle" coords="305,340,3" href="javascript:selectTSpoints( 9127,305,340)">';
mtxt += '<area shape="circle" coords="310,340,3" href="javascript:selectTSpoints( 9128,310,340)">';
mtxt += '<area shape="circle" coords="315,340,3" href="javascript:selectTSpoints( 9129,315,340)">';
mtxt += '<area shape="circle" coords="320,340,3" href="javascript:selectTSpoints( 9130,320,340)">';
mtxt += '<area shape="circle" coords="325,340,3" href="javascript:selectTSpoints( 9131,325,340)">';
mtxt += '<area shape="circle" coords="330,340,3" href="javascript:selectTSpoints( 9132,330,340)">';
mtxt += '<area shape="circle" coords="336,340,3" href="javascript:selectTSpoints( 9133,336,340)">';
mtxt += '<area shape="circle" coords="341,340,3" href="javascript:selectTSpoints( 9134,341,340)">';
mtxt += '<area shape="circle" coords="346,340,3" href="javascript:selectTSpoints( 9135,346,340)">';
mtxt += '<area shape="circle" coords="351,340,3" href="javascript:selectTSpoints( 9136,351,340)">';
mtxt += '<area shape="circle" coords="356,340,3" href="javascript:selectTSpoints( 9137,356,340)">';
mtxt += '<area shape="circle" coords="361,340,3" href="javascript:selectTSpoints( 9138,361,340)">';
mtxt += '<area shape="circle" coords="366,340,3" href="javascript:selectTSpoints( 9139,366,340)">';
mtxt += '<area shape="circle" coords="371,340,3" href="javascript:selectTSpoints( 9140,371,340)">';
mtxt += '<area shape="circle" coords="376,340,3" href="javascript:selectTSpoints( 9141,376,340)">';
mtxt += '<area shape="circle" coords="381,340,3" href="javascript:selectTSpoints( 9142,381,340)">';
mtxt += '<area shape="circle" coords="386,340,3" href="javascript:selectTSpoints( 9143,386,340)">';
mtxt += '<area shape="circle" coords="392,340,3" href="javascript:selectTSpoints( 9144,392,340)">';
mtxt += '<area shape="circle" coords="397,340,3" href="javascript:selectTSpoints( 9001,397,340)">';
mtxt += '<area shape="circle" coords="402,340,3" href="javascript:selectTSpoints( 9002,402,340)">';
mtxt += '<area shape="circle" coords="407,340,3" href="javascript:selectTSpoints( 9003,407,340)">';
mtxt += '<area shape="circle" coords="412,340,3" href="javascript:selectTSpoints( 9004,412,340)">';
mtxt += '<area shape="circle" coords="417,340,3" href="javascript:selectTSpoints( 9005,417,340)">';
mtxt += '<area shape="circle" coords="422,340,3" href="javascript:selectTSpoints( 9006,422,340)">';
mtxt += '<area shape="circle" coords="427,340,3" href="javascript:selectTSpoints( 9007,427,340)">';
mtxt += '<area shape="circle" coords="432,340,3" href="javascript:selectTSpoints( 9008,432,340)">';
mtxt += '<area shape="circle" coords="437,340,3" href="javascript:selectTSpoints( 9009,437,340)">';
mtxt += '<area shape="circle" coords="442,340,3" href="javascript:selectTSpoints( 9010,442,340)">';
mtxt += '<area shape="circle" coords="447,340,3" href="javascript:selectTSpoints( 9011,447,340)">';
mtxt += '<area shape="circle" coords="453,340,3" href="javascript:selectTSpoints( 9012,453,340)">';
mtxt += '<area shape="circle" coords="458,340,3" href="javascript:selectTSpoints( 9013,458,340)">';
mtxt += '<area shape="circle" coords="463,340,3" href="javascript:selectTSpoints( 9014,463,340)">';
mtxt += '<area shape="circle" coords="468,340,3" href="javascript:selectTSpoints( 9015,468,340)">';
mtxt += '<area shape="circle" coords="473,340,3" href="javascript:selectTSpoints( 9016,473,340)">';
mtxt += '<area shape="circle" coords="478,340,3" href="javascript:selectTSpoints( 9017,478,340)">';
mtxt += '<area shape="circle" coords="483,340,3" href="javascript:selectTSpoints( 9018,483,340)">';
mtxt += '<area shape="circle" coords="488,340,3" href="javascript:selectTSpoints( 9019,488,340)">';
mtxt += '<area shape="circle" coords="493,340,3" href="javascript:selectTSpoints( 9020,493,340)">';
mtxt += '<area shape="circle" coords="498,340,3" href="javascript:selectTSpoints( 9021,498,340)">';
mtxt += '<area shape="circle" coords="503,340,3" href="javascript:selectTSpoints( 9022,503,340)">';
mtxt += '<area shape="circle" coords="509,340,3" href="javascript:selectTSpoints( 9023,509,340)">';
mtxt += '<area shape="circle" coords="514,340,3" href="javascript:selectTSpoints( 9024,514,340)">';
mtxt += '<area shape="circle" coords="519,340,3" href="javascript:selectTSpoints( 9025,519,340)">';
mtxt += '<area shape="circle" coords="524,340,3" href="javascript:selectTSpoints( 9026,524,340)">';
mtxt += '<area shape="circle" coords="529,340,3" href="javascript:selectTSpoints( 9027,529,340)">';
mtxt += '<area shape="circle" coords="534,340,3" href="javascript:selectTSpoints( 9028,534,340)">';
mtxt += '<area shape="circle" coords="539,340,3" href="javascript:selectTSpoints( 9029,539,340)">';
mtxt += '<area shape="circle" coords="544,340,3" href="javascript:selectTSpoints( 9030,544,340)">';
mtxt += '<area shape="circle" coords="549,340,3" href="javascript:selectTSpoints( 9031,549,340)">';
mtxt += '<area shape="circle" coords="554,340,3" href="javascript:selectTSpoints( 9032,554,340)">';
mtxt += '<area shape="circle" coords="559,340,3" href="javascript:selectTSpoints( 9033,559,340)">';
mtxt += '<area shape="circle" coords="565,340,3" href="javascript:selectTSpoints( 9034,565,340)">';
mtxt += '<area shape="circle" coords="570,340,3" href="javascript:selectTSpoints( 9035,570,340)">';
mtxt += '<area shape="circle" coords="575,340,3" href="javascript:selectTSpoints( 9036,575,340)">';
mtxt += '<area shape="circle" coords="580,340,3" href="javascript:selectTSpoints( 9037,580,340)">';
mtxt += '<area shape="circle" coords="585,340,3" href="javascript:selectTSpoints( 9038,585,340)">';
mtxt += '<area shape="circle" coords="590,340,3" href="javascript:selectTSpoints( 9039,590,340)">';
mtxt += '<area shape="circle" coords="595,340,3" href="javascript:selectTSpoints( 9040,595,340)">';
mtxt += '<area shape="circle" coords="600,340,3" href="javascript:selectTSpoints( 9041,600,340)">';
mtxt += '<area shape="circle" coords="605,340,3" href="javascript:selectTSpoints( 9042,605,340)">';
mtxt += '<area shape="circle" coords="610,340,3" href="javascript:selectTSpoints( 9043,610,340)">';
mtxt += '<area shape="circle" coords="615,340,3" href="javascript:selectTSpoints( 9044,615,340)">';
mtxt += '<area shape="circle" coords="621,340,3" href="javascript:selectTSpoints( 9045,621,340)">';
mtxt += '<area shape="circle" coords="626,340,3" href="javascript:selectTSpoints( 9046,626,340)">';
mtxt += '<area shape="circle" coords="631,340,3" href="javascript:selectTSpoints( 9047,631,340)">';
mtxt += '<area shape="circle" coords="636,340,3" href="javascript:selectTSpoints( 9048,636,340)">';
mtxt += '<area shape="circle" coords="641,340,3" href="javascript:selectTSpoints( 9049,641,340)">';
mtxt += '<area shape="circle" coords="646,340,3" href="javascript:selectTSpoints( 9050,646,340)">';
mtxt += '<area shape="circle" coords="651,340,3" href="javascript:selectTSpoints( 9051,651,340)">';
mtxt += '<area shape="circle" coords="656,340,3" href="javascript:selectTSpoints( 9052,656,340)">';
mtxt += '<area shape="circle" coords="661,340,3" href="javascript:selectTSpoints( 9053,661,340)">';
mtxt += '<area shape="circle" coords="666,340,3" href="javascript:selectTSpoints( 9054,666,340)">';
mtxt += '<area shape="circle" coords="671,340,3" href="javascript:selectTSpoints( 9055,671,340)">';
mtxt += '<area shape="circle" coords="677,340,3" href="javascript:selectTSpoints( 9056,677,340)">';
mtxt += '<area shape="circle" coords="682,340,3" href="javascript:selectTSpoints( 9057,682,340)">';
mtxt += '<area shape="circle" coords="687,340,3" href="javascript:selectTSpoints( 9058,687,340)">';
mtxt += '<area shape="circle" coords="692,340,3" href="javascript:selectTSpoints( 9059,692,340)">';
mtxt += '<area shape="circle" coords="697,340,3" href="javascript:selectTSpoints( 9060,697,340)">';
mtxt += '<area shape="circle" coords="702,340,3" href="javascript:selectTSpoints( 9061,702,340)">';
mtxt += '<area shape="circle" coords="707,340,3" href="javascript:selectTSpoints( 9062,707,340)">';
mtxt += '<area shape="circle" coords="712,340,3" href="javascript:selectTSpoints( 9063,712,340)">';
mtxt += '<area shape="circle" coords="717,340,3" href="javascript:selectTSpoints( 9064,717,340)">';
mtxt += '<area shape="circle" coords="722,340,3" href="javascript:selectTSpoints( 9065,722,340)">';
mtxt += '<area shape="circle" coords="727,340,3" href="javascript:selectTSpoints( 9066,727,340)">';
mtxt += '<area shape="circle" coords="733,340,3" href="javascript:selectTSpoints( 9067,733,340)">';
mtxt += '<area shape="circle" coords="738,340,3" href="javascript:selectTSpoints( 9068,738,340)">';
mtxt += '<area shape="circle" coords="743,340,3" href="javascript:selectTSpoints( 9069,743,340)">';
mtxt += '<area shape="circle" coords="748,340,3" href="javascript:selectTSpoints( 9070,748,340)">';
mtxt += '<area shape="circle" coords="753,340,3" href="javascript:selectTSpoints( 9071,753,340)">';
mtxt += '<area shape="circle" coords="758,340,3" href="javascript:selectTSpoints( 9072,758,340)">';
mtxt += '<area shape="circle" coords=" 30,336,3" href="javascript:selectTSpoints(10073, 30,336)">';
mtxt += '<area shape="circle" coords=" 35,336,3" href="javascript:selectTSpoints(10074, 35,336)">';
mtxt += '<area shape="circle" coords=" 40,336,3" href="javascript:selectTSpoints(10075, 40,336)">';
mtxt += '<area shape="circle" coords=" 45,336,3" href="javascript:selectTSpoints(10076, 45,336)">';
mtxt += '<area shape="circle" coords=" 50,336,3" href="javascript:selectTSpoints(10077, 50,336)">';
mtxt += '<area shape="circle" coords=" 56,336,3" href="javascript:selectTSpoints(10078, 56,336)">';
mtxt += '<area shape="circle" coords=" 61,336,3" href="javascript:selectTSpoints(10079, 61,336)">';
mtxt += '<area shape="circle" coords=" 66,336,3" href="javascript:selectTSpoints(10080, 66,336)">';
mtxt += '<area shape="circle" coords=" 71,336,3" href="javascript:selectTSpoints(10081, 71,336)">';
mtxt += '<area shape="circle" coords=" 76,336,3" href="javascript:selectTSpoints(10082, 76,336)">';
mtxt += '<area shape="circle" coords=" 81,336,3" href="javascript:selectTSpoints(10083, 81,336)">';
mtxt += '<area shape="circle" coords=" 86,336,3" href="javascript:selectTSpoints(10084, 86,336)">';
mtxt += '<area shape="circle" coords=" 91,336,3" href="javascript:selectTSpoints(10085, 91,336)">';
mtxt += '<area shape="circle" coords=" 96,336,3" href="javascript:selectTSpoints(10086, 96,336)">';
mtxt += '<area shape="circle" coords="101,336,3" href="javascript:selectTSpoints(10087,101,336)">';
mtxt += '<area shape="circle" coords="106,336,3" href="javascript:selectTSpoints(10088,106,336)">';
mtxt += '<area shape="circle" coords="112,336,3" href="javascript:selectTSpoints(10089,112,336)">';
mtxt += '<area shape="circle" coords="117,336,3" href="javascript:selectTSpoints(10090,117,336)">';
mtxt += '<area shape="circle" coords="122,336,3" href="javascript:selectTSpoints(10091,122,336)">';
mtxt += '<area shape="circle" coords="127,336,3" href="javascript:selectTSpoints(10092,127,336)">';
mtxt += '<area shape="circle" coords="132,336,3" href="javascript:selectTSpoints(10093,132,336)">';
mtxt += '<area shape="circle" coords="137,336,3" href="javascript:selectTSpoints(10094,137,336)">';
mtxt += '<area shape="circle" coords="142,336,3" href="javascript:selectTSpoints(10095,142,336)">';
mtxt += '<area shape="circle" coords="147,336,3" href="javascript:selectTSpoints(10096,147,336)">';
mtxt += '<area shape="circle" coords="152,336,3" href="javascript:selectTSpoints(10097,152,336)">';
mtxt += '<area shape="circle" coords="157,336,3" href="javascript:selectTSpoints(10098,157,336)">';
mtxt += '<area shape="circle" coords="162,336,3" href="javascript:selectTSpoints(10099,162,336)">';
mtxt += '<area shape="circle" coords="168,336,3" href="javascript:selectTSpoints(10100,168,336)">';
mtxt += '<area shape="circle" coords="173,336,3" href="javascript:selectTSpoints(10101,173,336)">';
mtxt += '<area shape="circle" coords="178,336,3" href="javascript:selectTSpoints(10102,178,336)">';
mtxt += '<area shape="circle" coords="183,336,3" href="javascript:selectTSpoints(10103,183,336)">';
mtxt += '<area shape="circle" coords="188,336,3" href="javascript:selectTSpoints(10104,188,336)">';
mtxt += '<area shape="circle" coords="193,336,3" href="javascript:selectTSpoints(10105,193,336)">';
mtxt += '<area shape="circle" coords="198,336,3" href="javascript:selectTSpoints(10106,198,336)">';
mtxt += '<area shape="circle" coords="203,336,3" href="javascript:selectTSpoints(10107,203,336)">';
mtxt += '<area shape="circle" coords="208,336,3" href="javascript:selectTSpoints(10108,208,336)">';
mtxt += '<area shape="circle" coords="213,336,3" href="javascript:selectTSpoints(10109,213,336)">';
mtxt += '<area shape="circle" coords="218,336,3" href="javascript:selectTSpoints(10110,218,336)">';
mtxt += '<area shape="circle" coords="224,336,3" href="javascript:selectTSpoints(10111,224,336)">';
mtxt += '<area shape="circle" coords="229,336,3" href="javascript:selectTSpoints(10112,229,336)">';
mtxt += '<area shape="circle" coords="234,336,3" href="javascript:selectTSpoints(10113,234,336)">';
mtxt += '<area shape="circle" coords="239,336,3" href="javascript:selectTSpoints(10114,239,336)">';
mtxt += '<area shape="circle" coords="244,336,3" href="javascript:selectTSpoints(10115,244,336)">';
mtxt += '<area shape="circle" coords="249,336,3" href="javascript:selectTSpoints(10116,249,336)">';
mtxt += '<area shape="circle" coords="254,336,3" href="javascript:selectTSpoints(10117,254,336)">';
mtxt += '<area shape="circle" coords="259,336,3" href="javascript:selectTSpoints(10118,259,336)">';
mtxt += '<area shape="circle" coords="264,336,3" href="javascript:selectTSpoints(10119,264,336)">';
mtxt += '<area shape="circle" coords="269,336,3" href="javascript:selectTSpoints(10120,269,336)">';
mtxt += '<area shape="circle" coords="274,336,3" href="javascript:selectTSpoints(10121,274,336)">';
mtxt += '<area shape="circle" coords="280,336,3" href="javascript:selectTSpoints(10122,280,336)">';
mtxt += '<area shape="circle" coords="285,336,3" href="javascript:selectTSpoints(10123,285,336)">';
mtxt += '<area shape="circle" coords="290,336,3" href="javascript:selectTSpoints(10124,290,336)">';
mtxt += '<area shape="circle" coords="295,336,3" href="javascript:selectTSpoints(10125,295,336)">';
mtxt += '<area shape="circle" coords="300,336,3" href="javascript:selectTSpoints(10126,300,336)">';
mtxt += '<area shape="circle" coords="305,336,3" href="javascript:selectTSpoints(10127,305,336)">';
mtxt += '<area shape="circle" coords="310,336,3" href="javascript:selectTSpoints(10128,310,336)">';
mtxt += '<area shape="circle" coords="315,336,3" href="javascript:selectTSpoints(10129,315,336)">';
mtxt += '<area shape="circle" coords="320,336,3" href="javascript:selectTSpoints(10130,320,336)">';
mtxt += '<area shape="circle" coords="325,336,3" href="javascript:selectTSpoints(10131,325,336)">';
mtxt += '<area shape="circle" coords="330,336,3" href="javascript:selectTSpoints(10132,330,336)">';
mtxt += '<area shape="circle" coords="336,336,3" href="javascript:selectTSpoints(10133,336,336)">';
mtxt += '<area shape="circle" coords="341,336,3" href="javascript:selectTSpoints(10134,341,336)">';
mtxt += '<area shape="circle" coords="346,336,3" href="javascript:selectTSpoints(10135,346,336)">';
mtxt += '<area shape="circle" coords="351,336,3" href="javascript:selectTSpoints(10136,351,336)">';
mtxt += '<area shape="circle" coords="356,336,3" href="javascript:selectTSpoints(10137,356,336)">';
mtxt += '<area shape="circle" coords="361,336,3" href="javascript:selectTSpoints(10138,361,336)">';
mtxt += '<area shape="circle" coords="366,336,3" href="javascript:selectTSpoints(10139,366,336)">';
mtxt += '<area shape="circle" coords="371,336,3" href="javascript:selectTSpoints(10140,371,336)">';
mtxt += '<area shape="circle" coords="376,336,3" href="javascript:selectTSpoints(10141,376,336)">';
mtxt += '<area shape="circle" coords="381,336,3" href="javascript:selectTSpoints(10142,381,336)">';
mtxt += '<area shape="circle" coords="386,336,3" href="javascript:selectTSpoints(10143,386,336)">';
mtxt += '<area shape="circle" coords="392,336,3" href="javascript:selectTSpoints(10144,392,336)">';
mtxt += '<area shape="circle" coords="397,336,3" href="javascript:selectTSpoints(10001,397,336)">';
mtxt += '<area shape="circle" coords="402,336,3" href="javascript:selectTSpoints(10002,402,336)">';
mtxt += '<area shape="circle" coords="407,336,3" href="javascript:selectTSpoints(10003,407,336)">';
mtxt += '<area shape="circle" coords="412,336,3" href="javascript:selectTSpoints(10004,412,336)">';
mtxt += '<area shape="circle" coords="417,336,3" href="javascript:selectTSpoints(10005,417,336)">';
mtxt += '<area shape="circle" coords="422,336,3" href="javascript:selectTSpoints(10006,422,336)">';
mtxt += '<area shape="circle" coords="427,336,3" href="javascript:selectTSpoints(10007,427,336)">';
mtxt += '<area shape="circle" coords="432,336,3" href="javascript:selectTSpoints(10008,432,336)">';
mtxt += '<area shape="circle" coords="437,336,3" href="javascript:selectTSpoints(10009,437,336)">';
mtxt += '<area shape="circle" coords="442,336,3" href="javascript:selectTSpoints(10010,442,336)">';
mtxt += '<area shape="circle" coords="447,336,3" href="javascript:selectTSpoints(10011,447,336)">';
mtxt += '<area shape="circle" coords="453,336,3" href="javascript:selectTSpoints(10012,453,336)">';
mtxt += '<area shape="circle" coords="458,336,3" href="javascript:selectTSpoints(10013,458,336)">';
mtxt += '<area shape="circle" coords="463,336,3" href="javascript:selectTSpoints(10014,463,336)">';
mtxt += '<area shape="circle" coords="468,336,3" href="javascript:selectTSpoints(10015,468,336)">';
mtxt += '<area shape="circle" coords="473,336,3" href="javascript:selectTSpoints(10016,473,336)">';
mtxt += '<area shape="circle" coords="478,336,3" href="javascript:selectTSpoints(10017,478,336)">';
mtxt += '<area shape="circle" coords="483,336,3" href="javascript:selectTSpoints(10018,483,336)">';
mtxt += '<area shape="circle" coords="488,336,3" href="javascript:selectTSpoints(10019,488,336)">';
mtxt += '<area shape="circle" coords="493,336,3" href="javascript:selectTSpoints(10020,493,336)">';
mtxt += '<area shape="circle" coords="498,336,3" href="javascript:selectTSpoints(10021,498,336)">';
mtxt += '<area shape="circle" coords="503,336,3" href="javascript:selectTSpoints(10022,503,336)">';
mtxt += '<area shape="circle" coords="509,336,3" href="javascript:selectTSpoints(10023,509,336)">';
mtxt += '<area shape="circle" coords="514,336,3" href="javascript:selectTSpoints(10024,514,336)">';
mtxt += '<area shape="circle" coords="519,336,3" href="javascript:selectTSpoints(10025,519,336)">';
mtxt += '<area shape="circle" coords="524,336,3" href="javascript:selectTSpoints(10026,524,336)">';
mtxt += '<area shape="circle" coords="529,336,3" href="javascript:selectTSpoints(10027,529,336)">';
mtxt += '<area shape="circle" coords="534,336,3" href="javascript:selectTSpoints(10028,534,336)">';
mtxt += '<area shape="circle" coords="539,336,3" href="javascript:selectTSpoints(10029,539,336)">';
mtxt += '<area shape="circle" coords="544,336,3" href="javascript:selectTSpoints(10030,544,336)">';
mtxt += '<area shape="circle" coords="549,336,3" href="javascript:selectTSpoints(10031,549,336)">';
mtxt += '<area shape="circle" coords="554,336,3" href="javascript:selectTSpoints(10032,554,336)">';
mtxt += '<area shape="circle" coords="559,336,3" href="javascript:selectTSpoints(10033,559,336)">';
mtxt += '<area shape="circle" coords="565,336,3" href="javascript:selectTSpoints(10034,565,336)">';
mtxt += '<area shape="circle" coords="570,336,3" href="javascript:selectTSpoints(10035,570,336)">';
mtxt += '<area shape="circle" coords="575,336,3" href="javascript:selectTSpoints(10036,575,336)">';
mtxt += '<area shape="circle" coords="580,336,3" href="javascript:selectTSpoints(10037,580,336)">';
mtxt += '<area shape="circle" coords="585,336,3" href="javascript:selectTSpoints(10038,585,336)">';
mtxt += '<area shape="circle" coords="590,336,3" href="javascript:selectTSpoints(10039,590,336)">';
mtxt += '<area shape="circle" coords="595,336,3" href="javascript:selectTSpoints(10040,595,336)">';
mtxt += '<area shape="circle" coords="600,336,3" href="javascript:selectTSpoints(10041,600,336)">';
mtxt += '<area shape="circle" coords="605,336,3" href="javascript:selectTSpoints(10042,605,336)">';
mtxt += '<area shape="circle" coords="610,336,3" href="javascript:selectTSpoints(10043,610,336)">';
mtxt += '<area shape="circle" coords="615,336,3" href="javascript:selectTSpoints(10044,615,336)">';
mtxt += '<area shape="circle" coords="621,336,3" href="javascript:selectTSpoints(10045,621,336)">';
mtxt += '<area shape="circle" coords="626,336,3" href="javascript:selectTSpoints(10046,626,336)">';
mtxt += '<area shape="circle" coords="631,336,3" href="javascript:selectTSpoints(10047,631,336)">';
mtxt += '<area shape="circle" coords="636,336,3" href="javascript:selectTSpoints(10048,636,336)">';
mtxt += '<area shape="circle" coords="641,336,3" href="javascript:selectTSpoints(10049,641,336)">';
mtxt += '<area shape="circle" coords="646,336,3" href="javascript:selectTSpoints(10050,646,336)">';
mtxt += '<area shape="circle" coords="651,336,3" href="javascript:selectTSpoints(10051,651,336)">';
mtxt += '<area shape="circle" coords="656,336,3" href="javascript:selectTSpoints(10052,656,336)">';
mtxt += '<area shape="circle" coords="661,336,3" href="javascript:selectTSpoints(10053,661,336)">';
mtxt += '<area shape="circle" coords="666,336,3" href="javascript:selectTSpoints(10054,666,336)">';
mtxt += '<area shape="circle" coords="671,336,3" href="javascript:selectTSpoints(10055,671,336)">';
mtxt += '<area shape="circle" coords="677,336,3" href="javascript:selectTSpoints(10056,677,336)">';
mtxt += '<area shape="circle" coords="682,336,3" href="javascript:selectTSpoints(10057,682,336)">';
mtxt += '<area shape="circle" coords="687,336,3" href="javascript:selectTSpoints(10058,687,336)">';
mtxt += '<area shape="circle" coords="692,336,3" href="javascript:selectTSpoints(10059,692,336)">';
mtxt += '<area shape="circle" coords="697,336,3" href="javascript:selectTSpoints(10060,697,336)">';
mtxt += '<area shape="circle" coords="702,336,3" href="javascript:selectTSpoints(10061,702,336)">';
mtxt += '<area shape="circle" coords="707,336,3" href="javascript:selectTSpoints(10062,707,336)">';
mtxt += '<area shape="circle" coords="712,336,3" href="javascript:selectTSpoints(10063,712,336)">';
mtxt += '<area shape="circle" coords="717,336,3" href="javascript:selectTSpoints(10064,717,336)">';
mtxt += '<area shape="circle" coords="722,336,3" href="javascript:selectTSpoints(10065,722,336)">';
mtxt += '<area shape="circle" coords="727,336,3" href="javascript:selectTSpoints(10066,727,336)">';
mtxt += '<area shape="circle" coords="733,336,3" href="javascript:selectTSpoints(10067,733,336)">';
mtxt += '<area shape="circle" coords="738,336,3" href="javascript:selectTSpoints(10068,738,336)">';
mtxt += '<area shape="circle" coords="743,336,3" href="javascript:selectTSpoints(10069,743,336)">';
mtxt += '<area shape="circle" coords="748,336,3" href="javascript:selectTSpoints(10070,748,336)">';
mtxt += '<area shape="circle" coords="753,336,3" href="javascript:selectTSpoints(10071,753,336)">';
mtxt += '<area shape="circle" coords="758,336,3" href="javascript:selectTSpoints(10072,758,336)">';
mtxt += '<area shape="circle" coords=" 30,331,3" href="javascript:selectTSpoints(11073, 30,331)">';
mtxt += '<area shape="circle" coords=" 35,331,3" href="javascript:selectTSpoints(11074, 35,331)">';
mtxt += '<area shape="circle" coords=" 40,331,3" href="javascript:selectTSpoints(11075, 40,331)">';
mtxt += '<area shape="circle" coords=" 45,331,3" href="javascript:selectTSpoints(11076, 45,331)">';
mtxt += '<area shape="circle" coords=" 50,331,3" href="javascript:selectTSpoints(11077, 50,331)">';
mtxt += '<area shape="circle" coords=" 56,331,3" href="javascript:selectTSpoints(11078, 56,331)">';
mtxt += '<area shape="circle" coords=" 61,331,3" href="javascript:selectTSpoints(11079, 61,331)">';
mtxt += '<area shape="circle" coords=" 66,331,3" href="javascript:selectTSpoints(11080, 66,331)">';
mtxt += '<area shape="circle" coords=" 71,331,3" href="javascript:selectTSpoints(11081, 71,331)">';
mtxt += '<area shape="circle" coords=" 76,331,3" href="javascript:selectTSpoints(11082, 76,331)">';
mtxt += '<area shape="circle" coords=" 81,331,3" href="javascript:selectTSpoints(11083, 81,331)">';
mtxt += '<area shape="circle" coords=" 86,331,3" href="javascript:selectTSpoints(11084, 86,331)">';
mtxt += '<area shape="circle" coords=" 91,331,3" href="javascript:selectTSpoints(11085, 91,331)">';
mtxt += '<area shape="circle" coords=" 96,331,3" href="javascript:selectTSpoints(11086, 96,331)">';
mtxt += '<area shape="circle" coords="101,331,3" href="javascript:selectTSpoints(11087,101,331)">';
mtxt += '<area shape="circle" coords="106,331,3" href="javascript:selectTSpoints(11088,106,331)">';
mtxt += '<area shape="circle" coords="112,331,3" href="javascript:selectTSpoints(11089,112,331)">';
mtxt += '<area shape="circle" coords="117,331,3" href="javascript:selectTSpoints(11090,117,331)">';
mtxt += '<area shape="circle" coords="122,331,3" href="javascript:selectTSpoints(11091,122,331)">';
mtxt += '<area shape="circle" coords="127,331,3" href="javascript:selectTSpoints(11092,127,331)">';
mtxt += '<area shape="circle" coords="132,331,3" href="javascript:selectTSpoints(11093,132,331)">';
mtxt += '<area shape="circle" coords="137,331,3" href="javascript:selectTSpoints(11094,137,331)">';
mtxt += '<area shape="circle" coords="142,331,3" href="javascript:selectTSpoints(11095,142,331)">';
mtxt += '<area shape="circle" coords="147,331,3" href="javascript:selectTSpoints(11096,147,331)">';
mtxt += '<area shape="circle" coords="152,331,3" href="javascript:selectTSpoints(11097,152,331)">';
mtxt += '<area shape="circle" coords="157,331,3" href="javascript:selectTSpoints(11098,157,331)">';
mtxt += '<area shape="circle" coords="162,331,3" href="javascript:selectTSpoints(11099,162,331)">';
mtxt += '<area shape="circle" coords="168,331,3" href="javascript:selectTSpoints(11100,168,331)">';
mtxt += '<area shape="circle" coords="173,331,3" href="javascript:selectTSpoints(11101,173,331)">';
mtxt += '<area shape="circle" coords="178,331,3" href="javascript:selectTSpoints(11102,178,331)">';
mtxt += '<area shape="circle" coords="183,331,3" href="javascript:selectTSpoints(11103,183,331)">';
mtxt += '<area shape="circle" coords="188,331,3" href="javascript:selectTSpoints(11104,188,331)">';
mtxt += '<area shape="circle" coords="193,331,3" href="javascript:selectTSpoints(11105,193,331)">';
mtxt += '<area shape="circle" coords="198,331,3" href="javascript:selectTSpoints(11106,198,331)">';
mtxt += '<area shape="circle" coords="203,331,3" href="javascript:selectTSpoints(11107,203,331)">';
mtxt += '<area shape="circle" coords="208,331,3" href="javascript:selectTSpoints(11108,208,331)">';
mtxt += '<area shape="circle" coords="213,331,3" href="javascript:selectTSpoints(11109,213,331)">';
mtxt += '<area shape="circle" coords="218,331,3" href="javascript:selectTSpoints(11110,218,331)">';
mtxt += '<area shape="circle" coords="224,331,3" href="javascript:selectTSpoints(11111,224,331)">';
mtxt += '<area shape="circle" coords="229,331,3" href="javascript:selectTSpoints(11112,229,331)">';
mtxt += '<area shape="circle" coords="234,331,3" href="javascript:selectTSpoints(11113,234,331)">';
mtxt += '<area shape="circle" coords="239,331,3" href="javascript:selectTSpoints(11114,239,331)">';
mtxt += '<area shape="circle" coords="244,331,3" href="javascript:selectTSpoints(11115,244,331)">';
mtxt += '<area shape="circle" coords="249,331,3" href="javascript:selectTSpoints(11116,249,331)">';
mtxt += '<area shape="circle" coords="254,331,3" href="javascript:selectTSpoints(11117,254,331)">';
mtxt += '<area shape="circle" coords="259,331,3" href="javascript:selectTSpoints(11118,259,331)">';
mtxt += '<area shape="circle" coords="264,331,3" href="javascript:selectTSpoints(11119,264,331)">';
mtxt += '<area shape="circle" coords="269,331,3" href="javascript:selectTSpoints(11120,269,331)">';
mtxt += '<area shape="circle" coords="274,331,3" href="javascript:selectTSpoints(11121,274,331)">';
mtxt += '<area shape="circle" coords="280,331,3" href="javascript:selectTSpoints(11122,280,331)">';
mtxt += '<area shape="circle" coords="285,331,3" href="javascript:selectTSpoints(11123,285,331)">';
mtxt += '<area shape="circle" coords="290,331,3" href="javascript:selectTSpoints(11124,290,331)">';
mtxt += '<area shape="circle" coords="295,331,3" href="javascript:selectTSpoints(11125,295,331)">';
mtxt += '<area shape="circle" coords="300,331,3" href="javascript:selectTSpoints(11126,300,331)">';
mtxt += '<area shape="circle" coords="305,331,3" href="javascript:selectTSpoints(11127,305,331)">';
mtxt += '<area shape="circle" coords="310,331,3" href="javascript:selectTSpoints(11128,310,331)">';
mtxt += '<area shape="circle" coords="315,331,3" href="javascript:selectTSpoints(11129,315,331)">';
mtxt += '<area shape="circle" coords="320,331,3" href="javascript:selectTSpoints(11130,320,331)">';
mtxt += '<area shape="circle" coords="325,331,3" href="javascript:selectTSpoints(11131,325,331)">';
mtxt += '<area shape="circle" coords="330,331,3" href="javascript:selectTSpoints(11132,330,331)">';
mtxt += '<area shape="circle" coords="336,331,3" href="javascript:selectTSpoints(11133,336,331)">';
mtxt += '<area shape="circle" coords="341,331,3" href="javascript:selectTSpoints(11134,341,331)">';
mtxt += '<area shape="circle" coords="346,331,3" href="javascript:selectTSpoints(11135,346,331)">';
mtxt += '<area shape="circle" coords="351,331,3" href="javascript:selectTSpoints(11136,351,331)">';
mtxt += '<area shape="circle" coords="356,331,3" href="javascript:selectTSpoints(11137,356,331)">';
mtxt += '<area shape="circle" coords="361,331,3" href="javascript:selectTSpoints(11138,361,331)">';
mtxt += '<area shape="circle" coords="366,331,3" href="javascript:selectTSpoints(11139,366,331)">';
mtxt += '<area shape="circle" coords="371,331,3" href="javascript:selectTSpoints(11140,371,331)">';
mtxt += '<area shape="circle" coords="376,331,3" href="javascript:selectTSpoints(11141,376,331)">';
mtxt += '<area shape="circle" coords="381,331,3" href="javascript:selectTSpoints(11142,381,331)">';
mtxt += '<area shape="circle" coords="386,331,3" href="javascript:selectTSpoints(11143,386,331)">';
mtxt += '<area shape="circle" coords="392,331,3" href="javascript:selectTSpoints(11144,392,331)">';
mtxt += '<area shape="circle" coords="397,331,3" href="javascript:selectTSpoints(11001,397,331)">';
mtxt += '<area shape="circle" coords="402,331,3" href="javascript:selectTSpoints(11002,402,331)">';
mtxt += '<area shape="circle" coords="407,331,3" href="javascript:selectTSpoints(11003,407,331)">';
mtxt += '<area shape="circle" coords="412,331,3" href="javascript:selectTSpoints(11004,412,331)">';
mtxt += '<area shape="circle" coords="417,331,3" href="javascript:selectTSpoints(11005,417,331)">';
mtxt += '<area shape="circle" coords="422,331,3" href="javascript:selectTSpoints(11006,422,331)">';
mtxt += '<area shape="circle" coords="427,331,3" href="javascript:selectTSpoints(11007,427,331)">';
mtxt += '<area shape="circle" coords="432,331,3" href="javascript:selectTSpoints(11008,432,331)">';
mtxt += '<area shape="circle" coords="437,331,3" href="javascript:selectTSpoints(11009,437,331)">';
mtxt += '<area shape="circle" coords="442,331,3" href="javascript:selectTSpoints(11010,442,331)">';
mtxt += '<area shape="circle" coords="447,331,3" href="javascript:selectTSpoints(11011,447,331)">';
mtxt += '<area shape="circle" coords="453,331,3" href="javascript:selectTSpoints(11012,453,331)">';
mtxt += '<area shape="circle" coords="458,331,3" href="javascript:selectTSpoints(11013,458,331)">';
mtxt += '<area shape="circle" coords="463,331,3" href="javascript:selectTSpoints(11014,463,331)">';
mtxt += '<area shape="circle" coords="468,331,3" href="javascript:selectTSpoints(11015,468,331)">';
mtxt += '<area shape="circle" coords="473,331,3" href="javascript:selectTSpoints(11016,473,331)">';
mtxt += '<area shape="circle" coords="478,331,3" href="javascript:selectTSpoints(11017,478,331)">';
mtxt += '<area shape="circle" coords="483,331,3" href="javascript:selectTSpoints(11018,483,331)">';
mtxt += '<area shape="circle" coords="488,331,3" href="javascript:selectTSpoints(11019,488,331)">';
mtxt += '<area shape="circle" coords="493,331,3" href="javascript:selectTSpoints(11020,493,331)">';
mtxt += '<area shape="circle" coords="498,331,3" href="javascript:selectTSpoints(11021,498,331)">';
mtxt += '<area shape="circle" coords="503,331,3" href="javascript:selectTSpoints(11022,503,331)">';
mtxt += '<area shape="circle" coords="509,331,3" href="javascript:selectTSpoints(11023,509,331)">';
mtxt += '<area shape="circle" coords="514,331,3" href="javascript:selectTSpoints(11024,514,331)">';
mtxt += '<area shape="circle" coords="519,331,3" href="javascript:selectTSpoints(11025,519,331)">';
mtxt += '<area shape="circle" coords="524,331,3" href="javascript:selectTSpoints(11026,524,331)">';
mtxt += '<area shape="circle" coords="529,331,3" href="javascript:selectTSpoints(11027,529,331)">';
mtxt += '<area shape="circle" coords="534,331,3" href="javascript:selectTSpoints(11028,534,331)">';
mtxt += '<area shape="circle" coords="539,331,3" href="javascript:selectTSpoints(11029,539,331)">';
mtxt += '<area shape="circle" coords="544,331,3" href="javascript:selectTSpoints(11030,544,331)">';
mtxt += '<area shape="circle" coords="549,331,3" href="javascript:selectTSpoints(11031,549,331)">';
mtxt += '<area shape="circle" coords="554,331,3" href="javascript:selectTSpoints(11032,554,331)">';
mtxt += '<area shape="circle" coords="559,331,3" href="javascript:selectTSpoints(11033,559,331)">';
mtxt += '<area shape="circle" coords="565,331,3" href="javascript:selectTSpoints(11034,565,331)">';
mtxt += '<area shape="circle" coords="570,331,3" href="javascript:selectTSpoints(11035,570,331)">';
mtxt += '<area shape="circle" coords="575,331,3" href="javascript:selectTSpoints(11036,575,331)">';
mtxt += '<area shape="circle" coords="580,331,3" href="javascript:selectTSpoints(11037,580,331)">';
mtxt += '<area shape="circle" coords="585,331,3" href="javascript:selectTSpoints(11038,585,331)">';
mtxt += '<area shape="circle" coords="590,331,3" href="javascript:selectTSpoints(11039,590,331)">';
mtxt += '<area shape="circle" coords="595,331,3" href="javascript:selectTSpoints(11040,595,331)">';
mtxt += '<area shape="circle" coords="600,331,3" href="javascript:selectTSpoints(11041,600,331)">';
mtxt += '<area shape="circle" coords="605,331,3" href="javascript:selectTSpoints(11042,605,331)">';
mtxt += '<area shape="circle" coords="610,331,3" href="javascript:selectTSpoints(11043,610,331)">';
mtxt += '<area shape="circle" coords="615,331,3" href="javascript:selectTSpoints(11044,615,331)">';
mtxt += '<area shape="circle" coords="621,331,3" href="javascript:selectTSpoints(11045,621,331)">';
mtxt += '<area shape="circle" coords="626,331,3" href="javascript:selectTSpoints(11046,626,331)">';
mtxt += '<area shape="circle" coords="631,331,3" href="javascript:selectTSpoints(11047,631,331)">';
mtxt += '<area shape="circle" coords="636,331,3" href="javascript:selectTSpoints(11048,636,331)">';
mtxt += '<area shape="circle" coords="641,331,3" href="javascript:selectTSpoints(11049,641,331)">';
mtxt += '<area shape="circle" coords="646,331,3" href="javascript:selectTSpoints(11050,646,331)">';
mtxt += '<area shape="circle" coords="651,331,3" href="javascript:selectTSpoints(11051,651,331)">';
mtxt += '<area shape="circle" coords="656,331,3" href="javascript:selectTSpoints(11052,656,331)">';
mtxt += '<area shape="circle" coords="661,331,3" href="javascript:selectTSpoints(11053,661,331)">';
mtxt += '<area shape="circle" coords="666,331,3" href="javascript:selectTSpoints(11054,666,331)">';
mtxt += '<area shape="circle" coords="671,331,3" href="javascript:selectTSpoints(11055,671,331)">';
mtxt += '<area shape="circle" coords="677,331,3" href="javascript:selectTSpoints(11056,677,331)">';
mtxt += '<area shape="circle" coords="682,331,3" href="javascript:selectTSpoints(11057,682,331)">';
mtxt += '<area shape="circle" coords="687,331,3" href="javascript:selectTSpoints(11058,687,331)">';
mtxt += '<area shape="circle" coords="692,331,3" href="javascript:selectTSpoints(11059,692,331)">';
mtxt += '<area shape="circle" coords="697,331,3" href="javascript:selectTSpoints(11060,697,331)">';
mtxt += '<area shape="circle" coords="702,331,3" href="javascript:selectTSpoints(11061,702,331)">';
mtxt += '<area shape="circle" coords="707,331,3" href="javascript:selectTSpoints(11062,707,331)">';
mtxt += '<area shape="circle" coords="712,331,3" href="javascript:selectTSpoints(11063,712,331)">';
mtxt += '<area shape="circle" coords="717,331,3" href="javascript:selectTSpoints(11064,717,331)">';
mtxt += '<area shape="circle" coords="722,331,3" href="javascript:selectTSpoints(11065,722,331)">';
mtxt += '<area shape="circle" coords="727,331,3" href="javascript:selectTSpoints(11066,727,331)">';
mtxt += '<area shape="circle" coords="733,331,3" href="javascript:selectTSpoints(11067,733,331)">';
mtxt += '<area shape="circle" coords="738,331,3" href="javascript:selectTSpoints(11068,738,331)">';
mtxt += '<area shape="circle" coords="743,331,3" href="javascript:selectTSpoints(11069,743,331)">';
mtxt += '<area shape="circle" coords="748,331,3" href="javascript:selectTSpoints(11070,748,331)">';
mtxt += '<area shape="circle" coords="753,331,3" href="javascript:selectTSpoints(11071,753,331)">';
mtxt += '<area shape="circle" coords="758,331,3" href="javascript:selectTSpoints(11072,758,331)">';
mtxt += '<area shape="circle" coords=" 30,326,3" href="javascript:selectTSpoints(12073, 30,326)">';
mtxt += '<area shape="circle" coords=" 35,326,3" href="javascript:selectTSpoints(12074, 35,326)">';
mtxt += '<area shape="circle" coords=" 40,326,3" href="javascript:selectTSpoints(12075, 40,326)">';
mtxt += '<area shape="circle" coords=" 45,326,3" href="javascript:selectTSpoints(12076, 45,326)">';
mtxt += '<area shape="circle" coords=" 50,326,3" href="javascript:selectTSpoints(12077, 50,326)">';
mtxt += '<area shape="circle" coords=" 56,326,3" href="javascript:selectTSpoints(12078, 56,326)">';
mtxt += '<area shape="circle" coords=" 61,326,3" href="javascript:selectTSpoints(12079, 61,326)">';
mtxt += '<area shape="circle" coords=" 66,326,3" href="javascript:selectTSpoints(12080, 66,326)">';
mtxt += '<area shape="circle" coords=" 71,326,3" href="javascript:selectTSpoints(12081, 71,326)">';
mtxt += '<area shape="circle" coords=" 76,326,3" href="javascript:selectTSpoints(12082, 76,326)">';
mtxt += '<area shape="circle" coords=" 81,326,3" href="javascript:selectTSpoints(12083, 81,326)">';
mtxt += '<area shape="circle" coords=" 86,326,3" href="javascript:selectTSpoints(12084, 86,326)">';
mtxt += '<area shape="circle" coords=" 91,326,3" href="javascript:selectTSpoints(12085, 91,326)">';
mtxt += '<area shape="circle" coords=" 96,326,3" href="javascript:selectTSpoints(12086, 96,326)">';
mtxt += '<area shape="circle" coords="101,326,3" href="javascript:selectTSpoints(12087,101,326)">';
mtxt += '<area shape="circle" coords="106,326,3" href="javascript:selectTSpoints(12088,106,326)">';
mtxt += '<area shape="circle" coords="112,326,3" href="javascript:selectTSpoints(12089,112,326)">';
mtxt += '<area shape="circle" coords="117,326,3" href="javascript:selectTSpoints(12090,117,326)">';
mtxt += '<area shape="circle" coords="122,326,3" href="javascript:selectTSpoints(12091,122,326)">';
mtxt += '<area shape="circle" coords="127,326,3" href="javascript:selectTSpoints(12092,127,326)">';
mtxt += '<area shape="circle" coords="132,326,3" href="javascript:selectTSpoints(12093,132,326)">';
mtxt += '<area shape="circle" coords="137,326,3" href="javascript:selectTSpoints(12094,137,326)">';
mtxt += '<area shape="circle" coords="142,326,3" href="javascript:selectTSpoints(12095,142,326)">';
mtxt += '<area shape="circle" coords="147,326,3" href="javascript:selectTSpoints(12096,147,326)">';
mtxt += '<area shape="circle" coords="152,326,3" href="javascript:selectTSpoints(12097,152,326)">';
mtxt += '<area shape="circle" coords="157,326,3" href="javascript:selectTSpoints(12098,157,326)">';
mtxt += '<area shape="circle" coords="162,326,3" href="javascript:selectTSpoints(12099,162,326)">';
mtxt += '<area shape="circle" coords="168,326,3" href="javascript:selectTSpoints(12100,168,326)">';
mtxt += '<area shape="circle" coords="173,326,3" href="javascript:selectTSpoints(12101,173,326)">';
mtxt += '<area shape="circle" coords="178,326,3" href="javascript:selectTSpoints(12102,178,326)">';
mtxt += '<area shape="circle" coords="183,326,3" href="javascript:selectTSpoints(12103,183,326)">';
mtxt += '<area shape="circle" coords="188,326,3" href="javascript:selectTSpoints(12104,188,326)">';
mtxt += '<area shape="circle" coords="193,326,3" href="javascript:selectTSpoints(12105,193,326)">';
mtxt += '<area shape="circle" coords="198,326,3" href="javascript:selectTSpoints(12106,198,326)">';
mtxt += '<area shape="circle" coords="203,326,3" href="javascript:selectTSpoints(12107,203,326)">';
mtxt += '<area shape="circle" coords="208,326,3" href="javascript:selectTSpoints(12108,208,326)">';
mtxt += '<area shape="circle" coords="213,326,3" href="javascript:selectTSpoints(12109,213,326)">';
mtxt += '<area shape="circle" coords="218,326,3" href="javascript:selectTSpoints(12110,218,326)">';
mtxt += '<area shape="circle" coords="224,326,3" href="javascript:selectTSpoints(12111,224,326)">';
mtxt += '<area shape="circle" coords="229,326,3" href="javascript:selectTSpoints(12112,229,326)">';
mtxt += '<area shape="circle" coords="234,326,3" href="javascript:selectTSpoints(12113,234,326)">';
mtxt += '<area shape="circle" coords="239,326,3" href="javascript:selectTSpoints(12114,239,326)">';
mtxt += '<area shape="circle" coords="244,326,3" href="javascript:selectTSpoints(12115,244,326)">';
mtxt += '<area shape="circle" coords="249,326,3" href="javascript:selectTSpoints(12116,249,326)">';
mtxt += '<area shape="circle" coords="254,326,3" href="javascript:selectTSpoints(12117,254,326)">';
mtxt += '<area shape="circle" coords="259,326,3" href="javascript:selectTSpoints(12118,259,326)">';
mtxt += '<area shape="circle" coords="264,326,3" href="javascript:selectTSpoints(12119,264,326)">';
mtxt += '<area shape="circle" coords="269,326,3" href="javascript:selectTSpoints(12120,269,326)">';
mtxt += '<area shape="circle" coords="274,326,3" href="javascript:selectTSpoints(12121,274,326)">';
mtxt += '<area shape="circle" coords="280,326,3" href="javascript:selectTSpoints(12122,280,326)">';
mtxt += '<area shape="circle" coords="285,326,3" href="javascript:selectTSpoints(12123,285,326)">';
mtxt += '<area shape="circle" coords="290,326,3" href="javascript:selectTSpoints(12124,290,326)">';
mtxt += '<area shape="circle" coords="295,326,3" href="javascript:selectTSpoints(12125,295,326)">';
mtxt += '<area shape="circle" coords="300,326,3" href="javascript:selectTSpoints(12126,300,326)">';
mtxt += '<area shape="circle" coords="305,326,3" href="javascript:selectTSpoints(12127,305,326)">';
mtxt += '<area shape="circle" coords="310,326,3" href="javascript:selectTSpoints(12128,310,326)">';
mtxt += '<area shape="circle" coords="315,326,3" href="javascript:selectTSpoints(12129,315,326)">';
mtxt += '<area shape="circle" coords="320,326,3" href="javascript:selectTSpoints(12130,320,326)">';
mtxt += '<area shape="circle" coords="325,326,3" href="javascript:selectTSpoints(12131,325,326)">';
mtxt += '<area shape="circle" coords="330,326,3" href="javascript:selectTSpoints(12132,330,326)">';
mtxt += '<area shape="circle" coords="336,326,3" href="javascript:selectTSpoints(12133,336,326)">';
mtxt += '<area shape="circle" coords="341,326,3" href="javascript:selectTSpoints(12134,341,326)">';
mtxt += '<area shape="circle" coords="346,326,3" href="javascript:selectTSpoints(12135,346,326)">';
mtxt += '<area shape="circle" coords="351,326,3" href="javascript:selectTSpoints(12136,351,326)">';
mtxt += '<area shape="circle" coords="356,326,3" href="javascript:selectTSpoints(12137,356,326)">';
mtxt += '<area shape="circle" coords="361,326,3" href="javascript:selectTSpoints(12138,361,326)">';
mtxt += '<area shape="circle" coords="366,326,3" href="javascript:selectTSpoints(12139,366,326)">';
mtxt += '<area shape="circle" coords="371,326,3" href="javascript:selectTSpoints(12140,371,326)">';
mtxt += '<area shape="circle" coords="376,326,3" href="javascript:selectTSpoints(12141,376,326)">';
mtxt += '<area shape="circle" coords="381,326,3" href="javascript:selectTSpoints(12142,381,326)">';
mtxt += '<area shape="circle" coords="386,326,3" href="javascript:selectTSpoints(12143,386,326)">';
mtxt += '<area shape="circle" coords="392,326,3" href="javascript:selectTSpoints(12144,392,326)">';
mtxt += '<area shape="circle" coords="397,326,3" href="javascript:selectTSpoints(12001,397,326)">';
mtxt += '<area shape="circle" coords="402,326,3" href="javascript:selectTSpoints(12002,402,326)">';
mtxt += '<area shape="circle" coords="407,326,3" href="javascript:selectTSpoints(12003,407,326)">';
mtxt += '<area shape="circle" coords="412,326,3" href="javascript:selectTSpoints(12004,412,326)">';
mtxt += '<area shape="circle" coords="417,326,3" href="javascript:selectTSpoints(12005,417,326)">';
mtxt += '<area shape="circle" coords="422,326,3" href="javascript:selectTSpoints(12006,422,326)">';
mtxt += '<area shape="circle" coords="427,326,3" href="javascript:selectTSpoints(12007,427,326)">';
mtxt += '<area shape="circle" coords="432,326,3" href="javascript:selectTSpoints(12008,432,326)">';
mtxt += '<area shape="circle" coords="437,326,3" href="javascript:selectTSpoints(12009,437,326)">';
mtxt += '<area shape="circle" coords="442,326,3" href="javascript:selectTSpoints(12010,442,326)">';
mtxt += '<area shape="circle" coords="447,326,3" href="javascript:selectTSpoints(12011,447,326)">';
mtxt += '<area shape="circle" coords="453,326,3" href="javascript:selectTSpoints(12012,453,326)">';
mtxt += '<area shape="circle" coords="458,326,3" href="javascript:selectTSpoints(12013,458,326)">';
mtxt += '<area shape="circle" coords="463,326,3" href="javascript:selectTSpoints(12014,463,326)">';
mtxt += '<area shape="circle" coords="468,326,3" href="javascript:selectTSpoints(12015,468,326)">';
mtxt += '<area shape="circle" coords="473,326,3" href="javascript:selectTSpoints(12016,473,326)">';
mtxt += '<area shape="circle" coords="478,326,3" href="javascript:selectTSpoints(12017,478,326)">';
mtxt += '<area shape="circle" coords="483,326,3" href="javascript:selectTSpoints(12018,483,326)">';
mtxt += '<area shape="circle" coords="488,326,3" href="javascript:selectTSpoints(12019,488,326)">';
mtxt += '<area shape="circle" coords="493,326,3" href="javascript:selectTSpoints(12020,493,326)">';
mtxt += '<area shape="circle" coords="498,326,3" href="javascript:selectTSpoints(12021,498,326)">';
mtxt += '<area shape="circle" coords="503,326,3" href="javascript:selectTSpoints(12022,503,326)">';
mtxt += '<area shape="circle" coords="509,326,3" href="javascript:selectTSpoints(12023,509,326)">';
mtxt += '<area shape="circle" coords="514,326,3" href="javascript:selectTSpoints(12024,514,326)">';
mtxt += '<area shape="circle" coords="519,326,3" href="javascript:selectTSpoints(12025,519,326)">';
mtxt += '<area shape="circle" coords="524,326,3" href="javascript:selectTSpoints(12026,524,326)">';
mtxt += '<area shape="circle" coords="529,326,3" href="javascript:selectTSpoints(12027,529,326)">';
mtxt += '<area shape="circle" coords="534,326,3" href="javascript:selectTSpoints(12028,534,326)">';
mtxt += '<area shape="circle" coords="539,326,3" href="javascript:selectTSpoints(12029,539,326)">';
mtxt += '<area shape="circle" coords="544,326,3" href="javascript:selectTSpoints(12030,544,326)">';
mtxt += '<area shape="circle" coords="549,326,3" href="javascript:selectTSpoints(12031,549,326)">';
mtxt += '<area shape="circle" coords="554,326,3" href="javascript:selectTSpoints(12032,554,326)">';
mtxt += '<area shape="circle" coords="559,326,3" href="javascript:selectTSpoints(12033,559,326)">';
mtxt += '<area shape="circle" coords="565,326,3" href="javascript:selectTSpoints(12034,565,326)">';
mtxt += '<area shape="circle" coords="570,326,3" href="javascript:selectTSpoints(12035,570,326)">';
mtxt += '<area shape="circle" coords="575,326,3" href="javascript:selectTSpoints(12036,575,326)">';
mtxt += '<area shape="circle" coords="580,326,3" href="javascript:selectTSpoints(12037,580,326)">';
mtxt += '<area shape="circle" coords="585,326,3" href="javascript:selectTSpoints(12038,585,326)">';
mtxt += '<area shape="circle" coords="590,326,3" href="javascript:selectTSpoints(12039,590,326)">';
mtxt += '<area shape="circle" coords="595,326,3" href="javascript:selectTSpoints(12040,595,326)">';
mtxt += '<area shape="circle" coords="600,326,3" href="javascript:selectTSpoints(12041,600,326)">';
mtxt += '<area shape="circle" coords="605,326,3" href="javascript:selectTSpoints(12042,605,326)">';
mtxt += '<area shape="circle" coords="610,326,3" href="javascript:selectTSpoints(12043,610,326)">';
mtxt += '<area shape="circle" coords="615,326,3" href="javascript:selectTSpoints(12044,615,326)">';
mtxt += '<area shape="circle" coords="621,326,3" href="javascript:selectTSpoints(12045,621,326)">';
mtxt += '<area shape="circle" coords="626,326,3" href="javascript:selectTSpoints(12046,626,326)">';
mtxt += '<area shape="circle" coords="631,326,3" href="javascript:selectTSpoints(12047,631,326)">';
mtxt += '<area shape="circle" coords="636,326,3" href="javascript:selectTSpoints(12048,636,326)">';
mtxt += '<area shape="circle" coords="641,326,3" href="javascript:selectTSpoints(12049,641,326)">';
mtxt += '<area shape="circle" coords="646,326,3" href="javascript:selectTSpoints(12050,646,326)">';
mtxt += '<area shape="circle" coords="651,326,3" href="javascript:selectTSpoints(12051,651,326)">';
mtxt += '<area shape="circle" coords="656,326,3" href="javascript:selectTSpoints(12052,656,326)">';
mtxt += '<area shape="circle" coords="661,326,3" href="javascript:selectTSpoints(12053,661,326)">';
mtxt += '<area shape="circle" coords="666,326,3" href="javascript:selectTSpoints(12054,666,326)">';
mtxt += '<area shape="circle" coords="671,326,3" href="javascript:selectTSpoints(12055,671,326)">';
mtxt += '<area shape="circle" coords="677,326,3" href="javascript:selectTSpoints(12056,677,326)">';
mtxt += '<area shape="circle" coords="682,326,3" href="javascript:selectTSpoints(12057,682,326)">';
mtxt += '<area shape="circle" coords="687,326,3" href="javascript:selectTSpoints(12058,687,326)">';
mtxt += '<area shape="circle" coords="692,326,3" href="javascript:selectTSpoints(12059,692,326)">';
mtxt += '<area shape="circle" coords="697,326,3" href="javascript:selectTSpoints(12060,697,326)">';
mtxt += '<area shape="circle" coords="702,326,3" href="javascript:selectTSpoints(12061,702,326)">';
mtxt += '<area shape="circle" coords="707,326,3" href="javascript:selectTSpoints(12062,707,326)">';
mtxt += '<area shape="circle" coords="712,326,3" href="javascript:selectTSpoints(12063,712,326)">';
mtxt += '<area shape="circle" coords="717,326,3" href="javascript:selectTSpoints(12064,717,326)">';
mtxt += '<area shape="circle" coords="722,326,3" href="javascript:selectTSpoints(12065,722,326)">';
mtxt += '<area shape="circle" coords="727,326,3" href="javascript:selectTSpoints(12066,727,326)">';
mtxt += '<area shape="circle" coords="733,326,3" href="javascript:selectTSpoints(12067,733,326)">';
mtxt += '<area shape="circle" coords="738,326,3" href="javascript:selectTSpoints(12068,738,326)">';
mtxt += '<area shape="circle" coords="743,326,3" href="javascript:selectTSpoints(12069,743,326)">';
mtxt += '<area shape="circle" coords="748,326,3" href="javascript:selectTSpoints(12070,748,326)">';
mtxt += '<area shape="circle" coords="753,326,3" href="javascript:selectTSpoints(12071,753,326)">';
mtxt += '<area shape="circle" coords="758,326,3" href="javascript:selectTSpoints(12072,758,326)">';
mtxt += '<area shape="circle" coords=" 30,321,3" href="javascript:selectTSpoints(13073, 30,321)">';
mtxt += '<area shape="circle" coords=" 35,321,3" href="javascript:selectTSpoints(13074, 35,321)">';
mtxt += '<area shape="circle" coords=" 40,321,3" href="javascript:selectTSpoints(13075, 40,321)">';
mtxt += '<area shape="circle" coords=" 45,321,3" href="javascript:selectTSpoints(13076, 45,321)">';
mtxt += '<area shape="circle" coords=" 50,321,3" href="javascript:selectTSpoints(13077, 50,321)">';
mtxt += '<area shape="circle" coords=" 56,321,3" href="javascript:selectTSpoints(13078, 56,321)">';
mtxt += '<area shape="circle" coords=" 61,321,3" href="javascript:selectTSpoints(13079, 61,321)">';
mtxt += '<area shape="circle" coords=" 66,321,3" href="javascript:selectTSpoints(13080, 66,321)">';
mtxt += '<area shape="circle" coords=" 71,321,3" href="javascript:selectTSpoints(13081, 71,321)">';
mtxt += '<area shape="circle" coords=" 76,321,3" href="javascript:selectTSpoints(13082, 76,321)">';
mtxt += '<area shape="circle" coords=" 81,321,3" href="javascript:selectTSpoints(13083, 81,321)">';
mtxt += '<area shape="circle" coords=" 86,321,3" href="javascript:selectTSpoints(13084, 86,321)">';
mtxt += '<area shape="circle" coords=" 91,321,3" href="javascript:selectTSpoints(13085, 91,321)">';
mtxt += '<area shape="circle" coords=" 96,321,3" href="javascript:selectTSpoints(13086, 96,321)">';
mtxt += '<area shape="circle" coords="101,321,3" href="javascript:selectTSpoints(13087,101,321)">';
mtxt += '<area shape="circle" coords="106,321,3" href="javascript:selectTSpoints(13088,106,321)">';
mtxt += '<area shape="circle" coords="112,321,3" href="javascript:selectTSpoints(13089,112,321)">';
mtxt += '<area shape="circle" coords="117,321,3" href="javascript:selectTSpoints(13090,117,321)">';
mtxt += '<area shape="circle" coords="122,321,3" href="javascript:selectTSpoints(13091,122,321)">';
mtxt += '<area shape="circle" coords="127,321,3" href="javascript:selectTSpoints(13092,127,321)">';
mtxt += '<area shape="circle" coords="132,321,3" href="javascript:selectTSpoints(13093,132,321)">';
mtxt += '<area shape="circle" coords="137,321,3" href="javascript:selectTSpoints(13094,137,321)">';
mtxt += '<area shape="circle" coords="142,321,3" href="javascript:selectTSpoints(13095,142,321)">';
mtxt += '<area shape="circle" coords="147,321,3" href="javascript:selectTSpoints(13096,147,321)">';
mtxt += '<area shape="circle" coords="152,321,3" href="javascript:selectTSpoints(13097,152,321)">';
mtxt += '<area shape="circle" coords="157,321,3" href="javascript:selectTSpoints(13098,157,321)">';
mtxt += '<area shape="circle" coords="162,321,3" href="javascript:selectTSpoints(13099,162,321)">';
mtxt += '<area shape="circle" coords="168,321,3" href="javascript:selectTSpoints(13100,168,321)">';
mtxt += '<area shape="circle" coords="173,321,3" href="javascript:selectTSpoints(13101,173,321)">';
mtxt += '<area shape="circle" coords="178,321,3" href="javascript:selectTSpoints(13102,178,321)">';
mtxt += '<area shape="circle" coords="183,321,3" href="javascript:selectTSpoints(13103,183,321)">';
mtxt += '<area shape="circle" coords="188,321,3" href="javascript:selectTSpoints(13104,188,321)">';
mtxt += '<area shape="circle" coords="193,321,3" href="javascript:selectTSpoints(13105,193,321)">';
mtxt += '<area shape="circle" coords="198,321,3" href="javascript:selectTSpoints(13106,198,321)">';
mtxt += '<area shape="circle" coords="203,321,3" href="javascript:selectTSpoints(13107,203,321)">';
mtxt += '<area shape="circle" coords="208,321,3" href="javascript:selectTSpoints(13108,208,321)">';
mtxt += '<area shape="circle" coords="213,321,3" href="javascript:selectTSpoints(13109,213,321)">';
mtxt += '<area shape="circle" coords="218,321,3" href="javascript:selectTSpoints(13110,218,321)">';
mtxt += '<area shape="circle" coords="224,321,3" href="javascript:selectTSpoints(13111,224,321)">';
mtxt += '<area shape="circle" coords="229,321,3" href="javascript:selectTSpoints(13112,229,321)">';
mtxt += '<area shape="circle" coords="234,321,3" href="javascript:selectTSpoints(13113,234,321)">';
mtxt += '<area shape="circle" coords="239,321,3" href="javascript:selectTSpoints(13114,239,321)">';
mtxt += '<area shape="circle" coords="244,321,3" href="javascript:selectTSpoints(13115,244,321)">';
mtxt += '<area shape="circle" coords="249,321,3" href="javascript:selectTSpoints(13116,249,321)">';
mtxt += '<area shape="circle" coords="254,321,3" href="javascript:selectTSpoints(13117,254,321)">';
mtxt += '<area shape="circle" coords="259,321,3" href="javascript:selectTSpoints(13118,259,321)">';
mtxt += '<area shape="circle" coords="264,321,3" href="javascript:selectTSpoints(13119,264,321)">';
mtxt += '<area shape="circle" coords="269,321,3" href="javascript:selectTSpoints(13120,269,321)">';
mtxt += '<area shape="circle" coords="274,321,3" href="javascript:selectTSpoints(13121,274,321)">';
mtxt += '<area shape="circle" coords="280,321,3" href="javascript:selectTSpoints(13122,280,321)">';
mtxt += '<area shape="circle" coords="285,321,3" href="javascript:selectTSpoints(13123,285,321)">';
mtxt += '<area shape="circle" coords="290,321,3" href="javascript:selectTSpoints(13124,290,321)">';
mtxt += '<area shape="circle" coords="295,321,3" href="javascript:selectTSpoints(13125,295,321)">';
mtxt += '<area shape="circle" coords="300,321,3" href="javascript:selectTSpoints(13126,300,321)">';
mtxt += '<area shape="circle" coords="305,321,3" href="javascript:selectTSpoints(13127,305,321)">';
mtxt += '<area shape="circle" coords="310,321,3" href="javascript:selectTSpoints(13128,310,321)">';
mtxt += '<area shape="circle" coords="315,321,3" href="javascript:selectTSpoints(13129,315,321)">';
mtxt += '<area shape="circle" coords="320,321,3" href="javascript:selectTSpoints(13130,320,321)">';
mtxt += '<area shape="circle" coords="325,321,3" href="javascript:selectTSpoints(13131,325,321)">';
mtxt += '<area shape="circle" coords="330,321,3" href="javascript:selectTSpoints(13132,330,321)">';
mtxt += '<area shape="circle" coords="336,321,3" href="javascript:selectTSpoints(13133,336,321)">';
mtxt += '<area shape="circle" coords="341,321,3" href="javascript:selectTSpoints(13134,341,321)">';
mtxt += '<area shape="circle" coords="346,321,3" href="javascript:selectTSpoints(13135,346,321)">';
mtxt += '<area shape="circle" coords="351,321,3" href="javascript:selectTSpoints(13136,351,321)">';
mtxt += '<area shape="circle" coords="356,321,3" href="javascript:selectTSpoints(13137,356,321)">';
mtxt += '<area shape="circle" coords="361,321,3" href="javascript:selectTSpoints(13138,361,321)">';
mtxt += '<area shape="circle" coords="366,321,3" href="javascript:selectTSpoints(13139,366,321)">';
mtxt += '<area shape="circle" coords="371,321,3" href="javascript:selectTSpoints(13140,371,321)">';
mtxt += '<area shape="circle" coords="376,321,3" href="javascript:selectTSpoints(13141,376,321)">';
mtxt += '<area shape="circle" coords="381,321,3" href="javascript:selectTSpoints(13142,381,321)">';
mtxt += '<area shape="circle" coords="386,321,3" href="javascript:selectTSpoints(13143,386,321)">';
mtxt += '<area shape="circle" coords="392,321,3" href="javascript:selectTSpoints(13144,392,321)">';
mtxt += '<area shape="circle" coords="397,321,3" href="javascript:selectTSpoints(13001,397,321)">';
mtxt += '<area shape="circle" coords="402,321,3" href="javascript:selectTSpoints(13002,402,321)">';
mtxt += '<area shape="circle" coords="407,321,3" href="javascript:selectTSpoints(13003,407,321)">';
mtxt += '<area shape="circle" coords="412,321,3" href="javascript:selectTSpoints(13004,412,321)">';
mtxt += '<area shape="circle" coords="417,321,3" href="javascript:selectTSpoints(13005,417,321)">';
mtxt += '<area shape="circle" coords="422,321,3" href="javascript:selectTSpoints(13006,422,321)">';
mtxt += '<area shape="circle" coords="427,321,3" href="javascript:selectTSpoints(13007,427,321)">';
mtxt += '<area shape="circle" coords="432,321,3" href="javascript:selectTSpoints(13008,432,321)">';
mtxt += '<area shape="circle" coords="437,321,3" href="javascript:selectTSpoints(13009,437,321)">';
mtxt += '<area shape="circle" coords="442,321,3" href="javascript:selectTSpoints(13010,442,321)">';
mtxt += '<area shape="circle" coords="447,321,3" href="javascript:selectTSpoints(13011,447,321)">';
mtxt += '<area shape="circle" coords="453,321,3" href="javascript:selectTSpoints(13012,453,321)">';
mtxt += '<area shape="circle" coords="458,321,3" href="javascript:selectTSpoints(13013,458,321)">';
mtxt += '<area shape="circle" coords="463,321,3" href="javascript:selectTSpoints(13014,463,321)">';
mtxt += '<area shape="circle" coords="468,321,3" href="javascript:selectTSpoints(13015,468,321)">';
mtxt += '<area shape="circle" coords="473,321,3" href="javascript:selectTSpoints(13016,473,321)">';
mtxt += '<area shape="circle" coords="478,321,3" href="javascript:selectTSpoints(13017,478,321)">';
mtxt += '<area shape="circle" coords="483,321,3" href="javascript:selectTSpoints(13018,483,321)">';
mtxt += '<area shape="circle" coords="488,321,3" href="javascript:selectTSpoints(13019,488,321)">';
mtxt += '<area shape="circle" coords="493,321,3" href="javascript:selectTSpoints(13020,493,321)">';
mtxt += '<area shape="circle" coords="498,321,3" href="javascript:selectTSpoints(13021,498,321)">';
mtxt += '<area shape="circle" coords="503,321,3" href="javascript:selectTSpoints(13022,503,321)">';
mtxt += '<area shape="circle" coords="509,321,3" href="javascript:selectTSpoints(13023,509,321)">';
mtxt += '<area shape="circle" coords="514,321,3" href="javascript:selectTSpoints(13024,514,321)">';
mtxt += '<area shape="circle" coords="519,321,3" href="javascript:selectTSpoints(13025,519,321)">';
mtxt += '<area shape="circle" coords="524,321,3" href="javascript:selectTSpoints(13026,524,321)">';
mtxt += '<area shape="circle" coords="529,321,3" href="javascript:selectTSpoints(13027,529,321)">';
mtxt += '<area shape="circle" coords="534,321,3" href="javascript:selectTSpoints(13028,534,321)">';
mtxt += '<area shape="circle" coords="539,321,3" href="javascript:selectTSpoints(13029,539,321)">';
mtxt += '<area shape="circle" coords="544,321,3" href="javascript:selectTSpoints(13030,544,321)">';
mtxt += '<area shape="circle" coords="549,321,3" href="javascript:selectTSpoints(13031,549,321)">';
mtxt += '<area shape="circle" coords="554,321,3" href="javascript:selectTSpoints(13032,554,321)">';
mtxt += '<area shape="circle" coords="559,321,3" href="javascript:selectTSpoints(13033,559,321)">';
mtxt += '<area shape="circle" coords="565,321,3" href="javascript:selectTSpoints(13034,565,321)">';
mtxt += '<area shape="circle" coords="570,321,3" href="javascript:selectTSpoints(13035,570,321)">';
mtxt += '<area shape="circle" coords="575,321,3" href="javascript:selectTSpoints(13036,575,321)">';
mtxt += '<area shape="circle" coords="580,321,3" href="javascript:selectTSpoints(13037,580,321)">';
mtxt += '<area shape="circle" coords="585,321,3" href="javascript:selectTSpoints(13038,585,321)">';
mtxt += '<area shape="circle" coords="590,321,3" href="javascript:selectTSpoints(13039,590,321)">';
mtxt += '<area shape="circle" coords="595,321,3" href="javascript:selectTSpoints(13040,595,321)">';
mtxt += '<area shape="circle" coords="600,321,3" href="javascript:selectTSpoints(13041,600,321)">';
mtxt += '<area shape="circle" coords="605,321,3" href="javascript:selectTSpoints(13042,605,321)">';
mtxt += '<area shape="circle" coords="610,321,3" href="javascript:selectTSpoints(13043,610,321)">';
mtxt += '<area shape="circle" coords="615,321,3" href="javascript:selectTSpoints(13044,615,321)">';
mtxt += '<area shape="circle" coords="621,321,3" href="javascript:selectTSpoints(13045,621,321)">';
mtxt += '<area shape="circle" coords="626,321,3" href="javascript:selectTSpoints(13046,626,321)">';
mtxt += '<area shape="circle" coords="631,321,3" href="javascript:selectTSpoints(13047,631,321)">';
mtxt += '<area shape="circle" coords="636,321,3" href="javascript:selectTSpoints(13048,636,321)">';
mtxt += '<area shape="circle" coords="641,321,3" href="javascript:selectTSpoints(13049,641,321)">';
mtxt += '<area shape="circle" coords="646,321,3" href="javascript:selectTSpoints(13050,646,321)">';
mtxt += '<area shape="circle" coords="651,321,3" href="javascript:selectTSpoints(13051,651,321)">';
mtxt += '<area shape="circle" coords="656,321,3" href="javascript:selectTSpoints(13052,656,321)">';
mtxt += '<area shape="circle" coords="661,321,3" href="javascript:selectTSpoints(13053,661,321)">';
mtxt += '<area shape="circle" coords="666,321,3" href="javascript:selectTSpoints(13054,666,321)">';
mtxt += '<area shape="circle" coords="671,321,3" href="javascript:selectTSpoints(13055,671,321)">';
mtxt += '<area shape="circle" coords="677,321,3" href="javascript:selectTSpoints(13056,677,321)">';
mtxt += '<area shape="circle" coords="682,321,3" href="javascript:selectTSpoints(13057,682,321)">';
mtxt += '<area shape="circle" coords="687,321,3" href="javascript:selectTSpoints(13058,687,321)">';
mtxt += '<area shape="circle" coords="692,321,3" href="javascript:selectTSpoints(13059,692,321)">';
mtxt += '<area shape="circle" coords="697,321,3" href="javascript:selectTSpoints(13060,697,321)">';
mtxt += '<area shape="circle" coords="702,321,3" href="javascript:selectTSpoints(13061,702,321)">';
mtxt += '<area shape="circle" coords="707,321,3" href="javascript:selectTSpoints(13062,707,321)">';
mtxt += '<area shape="circle" coords="712,321,3" href="javascript:selectTSpoints(13063,712,321)">';
mtxt += '<area shape="circle" coords="717,321,3" href="javascript:selectTSpoints(13064,717,321)">';
mtxt += '<area shape="circle" coords="722,321,3" href="javascript:selectTSpoints(13065,722,321)">';
mtxt += '<area shape="circle" coords="727,321,3" href="javascript:selectTSpoints(13066,727,321)">';
mtxt += '<area shape="circle" coords="733,321,3" href="javascript:selectTSpoints(13067,733,321)">';
mtxt += '<area shape="circle" coords="738,321,3" href="javascript:selectTSpoints(13068,738,321)">';
mtxt += '<area shape="circle" coords="743,321,3" href="javascript:selectTSpoints(13069,743,321)">';
mtxt += '<area shape="circle" coords="748,321,3" href="javascript:selectTSpoints(13070,748,321)">';
mtxt += '<area shape="circle" coords="753,321,3" href="javascript:selectTSpoints(13071,753,321)">';
mtxt += '<area shape="circle" coords="758,321,3" href="javascript:selectTSpoints(13072,758,321)">';
mtxt += '<area shape="circle" coords=" 30,316,3" href="javascript:selectTSpoints(14073, 30,316)">';
mtxt += '<area shape="circle" coords=" 35,316,3" href="javascript:selectTSpoints(14074, 35,316)">';
mtxt += '<area shape="circle" coords=" 40,316,3" href="javascript:selectTSpoints(14075, 40,316)">';
mtxt += '<area shape="circle" coords=" 45,316,3" href="javascript:selectTSpoints(14076, 45,316)">';
mtxt += '<area shape="circle" coords=" 50,316,3" href="javascript:selectTSpoints(14077, 50,316)">';
mtxt += '<area shape="circle" coords=" 56,316,3" href="javascript:selectTSpoints(14078, 56,316)">';
mtxt += '<area shape="circle" coords=" 61,316,3" href="javascript:selectTSpoints(14079, 61,316)">';
mtxt += '<area shape="circle" coords=" 66,316,3" href="javascript:selectTSpoints(14080, 66,316)">';
mtxt += '<area shape="circle" coords=" 71,316,3" href="javascript:selectTSpoints(14081, 71,316)">';
mtxt += '<area shape="circle" coords=" 76,316,3" href="javascript:selectTSpoints(14082, 76,316)">';
mtxt += '<area shape="circle" coords=" 81,316,3" href="javascript:selectTSpoints(14083, 81,316)">';
mtxt += '<area shape="circle" coords=" 86,316,3" href="javascript:selectTSpoints(14084, 86,316)">';
mtxt += '<area shape="circle" coords=" 91,316,3" href="javascript:selectTSpoints(14085, 91,316)">';
mtxt += '<area shape="circle" coords=" 96,316,3" href="javascript:selectTSpoints(14086, 96,316)">';
mtxt += '<area shape="circle" coords="101,316,3" href="javascript:selectTSpoints(14087,101,316)">';
mtxt += '<area shape="circle" coords="106,316,3" href="javascript:selectTSpoints(14088,106,316)">';
mtxt += '<area shape="circle" coords="112,316,3" href="javascript:selectTSpoints(14089,112,316)">';
mtxt += '<area shape="circle" coords="117,316,3" href="javascript:selectTSpoints(14090,117,316)">';
mtxt += '<area shape="circle" coords="122,316,3" href="javascript:selectTSpoints(14091,122,316)">';
mtxt += '<area shape="circle" coords="127,316,3" href="javascript:selectTSpoints(14092,127,316)">';
mtxt += '<area shape="circle" coords="132,316,3" href="javascript:selectTSpoints(14093,132,316)">';
mtxt += '<area shape="circle" coords="137,316,3" href="javascript:selectTSpoints(14094,137,316)">';
mtxt += '<area shape="circle" coords="142,316,3" href="javascript:selectTSpoints(14095,142,316)">';
mtxt += '<area shape="circle" coords="147,316,3" href="javascript:selectTSpoints(14096,147,316)">';
mtxt += '<area shape="circle" coords="152,316,3" href="javascript:selectTSpoints(14097,152,316)">';
mtxt += '<area shape="circle" coords="157,316,3" href="javascript:selectTSpoints(14098,157,316)">';
mtxt += '<area shape="circle" coords="162,316,3" href="javascript:selectTSpoints(14099,162,316)">';
mtxt += '<area shape="circle" coords="168,316,3" href="javascript:selectTSpoints(14100,168,316)">';
mtxt += '<area shape="circle" coords="173,316,3" href="javascript:selectTSpoints(14101,173,316)">';
mtxt += '<area shape="circle" coords="178,316,3" href="javascript:selectTSpoints(14102,178,316)">';
mtxt += '<area shape="circle" coords="183,316,3" href="javascript:selectTSpoints(14103,183,316)">';
mtxt += '<area shape="circle" coords="188,316,3" href="javascript:selectTSpoints(14104,188,316)">';
mtxt += '<area shape="circle" coords="193,316,3" href="javascript:selectTSpoints(14105,193,316)">';
mtxt += '<area shape="circle" coords="198,316,3" href="javascript:selectTSpoints(14106,198,316)">';
mtxt += '<area shape="circle" coords="203,316,3" href="javascript:selectTSpoints(14107,203,316)">';
mtxt += '<area shape="circle" coords="208,316,3" href="javascript:selectTSpoints(14108,208,316)">';
mtxt += '<area shape="circle" coords="213,316,3" href="javascript:selectTSpoints(14109,213,316)">';
mtxt += '<area shape="circle" coords="218,316,3" href="javascript:selectTSpoints(14110,218,316)">';
mtxt += '<area shape="circle" coords="224,316,3" href="javascript:selectTSpoints(14111,224,316)">';
mtxt += '<area shape="circle" coords="229,316,3" href="javascript:selectTSpoints(14112,229,316)">';
mtxt += '<area shape="circle" coords="234,316,3" href="javascript:selectTSpoints(14113,234,316)">';
mtxt += '<area shape="circle" coords="239,316,3" href="javascript:selectTSpoints(14114,239,316)">';
mtxt += '<area shape="circle" coords="244,316,3" href="javascript:selectTSpoints(14115,244,316)">';
mtxt += '<area shape="circle" coords="249,316,3" href="javascript:selectTSpoints(14116,249,316)">';
mtxt += '<area shape="circle" coords="254,316,3" href="javascript:selectTSpoints(14117,254,316)">';
mtxt += '<area shape="circle" coords="259,316,3" href="javascript:selectTSpoints(14118,259,316)">';
mtxt += '<area shape="circle" coords="264,316,3" href="javascript:selectTSpoints(14119,264,316)">';
mtxt += '<area shape="circle" coords="269,316,3" href="javascript:selectTSpoints(14120,269,316)">';
mtxt += '<area shape="circle" coords="274,316,3" href="javascript:selectTSpoints(14121,274,316)">';
mtxt += '<area shape="circle" coords="280,316,3" href="javascript:selectTSpoints(14122,280,316)">';
mtxt += '<area shape="circle" coords="285,316,3" href="javascript:selectTSpoints(14123,285,316)">';
mtxt += '<area shape="circle" coords="290,316,3" href="javascript:selectTSpoints(14124,290,316)">';
mtxt += '<area shape="circle" coords="295,316,3" href="javascript:selectTSpoints(14125,295,316)">';
mtxt += '<area shape="circle" coords="300,316,3" href="javascript:selectTSpoints(14126,300,316)">';
mtxt += '<area shape="circle" coords="305,316,3" href="javascript:selectTSpoints(14127,305,316)">';
mtxt += '<area shape="circle" coords="310,316,3" href="javascript:selectTSpoints(14128,310,316)">';
mtxt += '<area shape="circle" coords="315,316,3" href="javascript:selectTSpoints(14129,315,316)">';
mtxt += '<area shape="circle" coords="320,316,3" href="javascript:selectTSpoints(14130,320,316)">';
mtxt += '<area shape="circle" coords="325,316,3" href="javascript:selectTSpoints(14131,325,316)">';
mtxt += '<area shape="circle" coords="330,316,3" href="javascript:selectTSpoints(14132,330,316)">';
mtxt += '<area shape="circle" coords="336,316,3" href="javascript:selectTSpoints(14133,336,316)">';
mtxt += '<area shape="circle" coords="341,316,3" href="javascript:selectTSpoints(14134,341,316)">';
mtxt += '<area shape="circle" coords="346,316,3" href="javascript:selectTSpoints(14135,346,316)">';
mtxt += '<area shape="circle" coords="351,316,3" href="javascript:selectTSpoints(14136,351,316)">';
mtxt += '<area shape="circle" coords="356,316,3" href="javascript:selectTSpoints(14137,356,316)">';
mtxt += '<area shape="circle" coords="361,316,3" href="javascript:selectTSpoints(14138,361,316)">';
mtxt += '<area shape="circle" coords="366,316,3" href="javascript:selectTSpoints(14139,366,316)">';
mtxt += '<area shape="circle" coords="371,316,3" href="javascript:selectTSpoints(14140,371,316)">';
mtxt += '<area shape="circle" coords="376,316,3" href="javascript:selectTSpoints(14141,376,316)">';
mtxt += '<area shape="circle" coords="381,316,3" href="javascript:selectTSpoints(14142,381,316)">';
mtxt += '<area shape="circle" coords="386,316,3" href="javascript:selectTSpoints(14143,386,316)">';
mtxt += '<area shape="circle" coords="392,316,3" href="javascript:selectTSpoints(14144,392,316)">';
mtxt += '<area shape="circle" coords="397,316,3" href="javascript:selectTSpoints(14001,397,316)">';
mtxt += '<area shape="circle" coords="402,316,3" href="javascript:selectTSpoints(14002,402,316)">';
mtxt += '<area shape="circle" coords="407,316,3" href="javascript:selectTSpoints(14003,407,316)">';
mtxt += '<area shape="circle" coords="412,316,3" href="javascript:selectTSpoints(14004,412,316)">';
mtxt += '<area shape="circle" coords="417,316,3" href="javascript:selectTSpoints(14005,417,316)">';
mtxt += '<area shape="circle" coords="422,316,3" href="javascript:selectTSpoints(14006,422,316)">';
mtxt += '<area shape="circle" coords="427,316,3" href="javascript:selectTSpoints(14007,427,316)">';
mtxt += '<area shape="circle" coords="432,316,3" href="javascript:selectTSpoints(14008,432,316)">';
mtxt += '<area shape="circle" coords="437,316,3" href="javascript:selectTSpoints(14009,437,316)">';
mtxt += '<area shape="circle" coords="442,316,3" href="javascript:selectTSpoints(14010,442,316)">';
mtxt += '<area shape="circle" coords="447,316,3" href="javascript:selectTSpoints(14011,447,316)">';
mtxt += '<area shape="circle" coords="453,316,3" href="javascript:selectTSpoints(14012,453,316)">';
mtxt += '<area shape="circle" coords="458,316,3" href="javascript:selectTSpoints(14013,458,316)">';
mtxt += '<area shape="circle" coords="463,316,3" href="javascript:selectTSpoints(14014,463,316)">';
mtxt += '<area shape="circle" coords="468,316,3" href="javascript:selectTSpoints(14015,468,316)">';
mtxt += '<area shape="circle" coords="473,316,3" href="javascript:selectTSpoints(14016,473,316)">';
mtxt += '<area shape="circle" coords="478,316,3" href="javascript:selectTSpoints(14017,478,316)">';
mtxt += '<area shape="circle" coords="483,316,3" href="javascript:selectTSpoints(14018,483,316)">';
mtxt += '<area shape="circle" coords="488,316,3" href="javascript:selectTSpoints(14019,488,316)">';
mtxt += '<area shape="circle" coords="493,316,3" href="javascript:selectTSpoints(14020,493,316)">';
mtxt += '<area shape="circle" coords="498,316,3" href="javascript:selectTSpoints(14021,498,316)">';
mtxt += '<area shape="circle" coords="503,316,3" href="javascript:selectTSpoints(14022,503,316)">';
mtxt += '<area shape="circle" coords="509,316,3" href="javascript:selectTSpoints(14023,509,316)">';
mtxt += '<area shape="circle" coords="514,316,3" href="javascript:selectTSpoints(14024,514,316)">';
mtxt += '<area shape="circle" coords="519,316,3" href="javascript:selectTSpoints(14025,519,316)">';
mtxt += '<area shape="circle" coords="524,316,3" href="javascript:selectTSpoints(14026,524,316)">';
mtxt += '<area shape="circle" coords="529,316,3" href="javascript:selectTSpoints(14027,529,316)">';
mtxt += '<area shape="circle" coords="534,316,3" href="javascript:selectTSpoints(14028,534,316)">';
mtxt += '<area shape="circle" coords="539,316,3" href="javascript:selectTSpoints(14029,539,316)">';
mtxt += '<area shape="circle" coords="544,316,3" href="javascript:selectTSpoints(14030,544,316)">';
mtxt += '<area shape="circle" coords="549,316,3" href="javascript:selectTSpoints(14031,549,316)">';
mtxt += '<area shape="circle" coords="554,316,3" href="javascript:selectTSpoints(14032,554,316)">';
mtxt += '<area shape="circle" coords="559,316,3" href="javascript:selectTSpoints(14033,559,316)">';
mtxt += '<area shape="circle" coords="565,316,3" href="javascript:selectTSpoints(14034,565,316)">';
mtxt += '<area shape="circle" coords="570,316,3" href="javascript:selectTSpoints(14035,570,316)">';
mtxt += '<area shape="circle" coords="575,316,3" href="javascript:selectTSpoints(14036,575,316)">';
mtxt += '<area shape="circle" coords="580,316,3" href="javascript:selectTSpoints(14037,580,316)">';
mtxt += '<area shape="circle" coords="585,316,3" href="javascript:selectTSpoints(14038,585,316)">';
mtxt += '<area shape="circle" coords="590,316,3" href="javascript:selectTSpoints(14039,590,316)">';
mtxt += '<area shape="circle" coords="595,316,3" href="javascript:selectTSpoints(14040,595,316)">';
mtxt += '<area shape="circle" coords="600,316,3" href="javascript:selectTSpoints(14041,600,316)">';
mtxt += '<area shape="circle" coords="605,316,3" href="javascript:selectTSpoints(14042,605,316)">';
mtxt += '<area shape="circle" coords="610,316,3" href="javascript:selectTSpoints(14043,610,316)">';
mtxt += '<area shape="circle" coords="615,316,3" href="javascript:selectTSpoints(14044,615,316)">';
mtxt += '<area shape="circle" coords="621,316,3" href="javascript:selectTSpoints(14045,621,316)">';
mtxt += '<area shape="circle" coords="626,316,3" href="javascript:selectTSpoints(14046,626,316)">';
mtxt += '<area shape="circle" coords="631,316,3" href="javascript:selectTSpoints(14047,631,316)">';
mtxt += '<area shape="circle" coords="636,316,3" href="javascript:selectTSpoints(14048,636,316)">';
mtxt += '<area shape="circle" coords="641,316,3" href="javascript:selectTSpoints(14049,641,316)">';
mtxt += '<area shape="circle" coords="646,316,3" href="javascript:selectTSpoints(14050,646,316)">';
mtxt += '<area shape="circle" coords="651,316,3" href="javascript:selectTSpoints(14051,651,316)">';
mtxt += '<area shape="circle" coords="656,316,3" href="javascript:selectTSpoints(14052,656,316)">';
mtxt += '<area shape="circle" coords="661,316,3" href="javascript:selectTSpoints(14053,661,316)">';
mtxt += '<area shape="circle" coords="666,316,3" href="javascript:selectTSpoints(14054,666,316)">';
mtxt += '<area shape="circle" coords="671,316,3" href="javascript:selectTSpoints(14055,671,316)">';
mtxt += '<area shape="circle" coords="677,316,3" href="javascript:selectTSpoints(14056,677,316)">';
mtxt += '<area shape="circle" coords="682,316,3" href="javascript:selectTSpoints(14057,682,316)">';
mtxt += '<area shape="circle" coords="687,316,3" href="javascript:selectTSpoints(14058,687,316)">';
mtxt += '<area shape="circle" coords="692,316,3" href="javascript:selectTSpoints(14059,692,316)">';
mtxt += '<area shape="circle" coords="697,316,3" href="javascript:selectTSpoints(14060,697,316)">';
mtxt += '<area shape="circle" coords="702,316,3" href="javascript:selectTSpoints(14061,702,316)">';
mtxt += '<area shape="circle" coords="707,316,3" href="javascript:selectTSpoints(14062,707,316)">';
mtxt += '<area shape="circle" coords="712,316,3" href="javascript:selectTSpoints(14063,712,316)">';
mtxt += '<area shape="circle" coords="717,316,3" href="javascript:selectTSpoints(14064,717,316)">';
mtxt += '<area shape="circle" coords="722,316,3" href="javascript:selectTSpoints(14065,722,316)">';
mtxt += '<area shape="circle" coords="727,316,3" href="javascript:selectTSpoints(14066,727,316)">';
mtxt += '<area shape="circle" coords="733,316,3" href="javascript:selectTSpoints(14067,733,316)">';
mtxt += '<area shape="circle" coords="738,316,3" href="javascript:selectTSpoints(14068,738,316)">';
mtxt += '<area shape="circle" coords="743,316,3" href="javascript:selectTSpoints(14069,743,316)">';
mtxt += '<area shape="circle" coords="748,316,3" href="javascript:selectTSpoints(14070,748,316)">';
mtxt += '<area shape="circle" coords="753,316,3" href="javascript:selectTSpoints(14071,753,316)">';
mtxt += '<area shape="circle" coords="758,316,3" href="javascript:selectTSpoints(14072,758,316)">';
mtxt += '<area shape="circle" coords=" 30,311,3" href="javascript:selectTSpoints(15073, 30,311)">';
mtxt += '<area shape="circle" coords=" 35,311,3" href="javascript:selectTSpoints(15074, 35,311)">';
mtxt += '<area shape="circle" coords=" 40,311,3" href="javascript:selectTSpoints(15075, 40,311)">';
mtxt += '<area shape="circle" coords=" 45,311,3" href="javascript:selectTSpoints(15076, 45,311)">';
mtxt += '<area shape="circle" coords=" 50,311,3" href="javascript:selectTSpoints(15077, 50,311)">';
mtxt += '<area shape="circle" coords=" 56,311,3" href="javascript:selectTSpoints(15078, 56,311)">';
mtxt += '<area shape="circle" coords=" 61,311,3" href="javascript:selectTSpoints(15079, 61,311)">';
mtxt += '<area shape="circle" coords=" 66,311,3" href="javascript:selectTSpoints(15080, 66,311)">';
mtxt += '<area shape="circle" coords=" 71,311,3" href="javascript:selectTSpoints(15081, 71,311)">';
mtxt += '<area shape="circle" coords=" 76,311,3" href="javascript:selectTSpoints(15082, 76,311)">';
mtxt += '<area shape="circle" coords=" 81,311,3" href="javascript:selectTSpoints(15083, 81,311)">';
mtxt += '<area shape="circle" coords=" 86,311,3" href="javascript:selectTSpoints(15084, 86,311)">';
mtxt += '<area shape="circle" coords=" 91,311,3" href="javascript:selectTSpoints(15085, 91,311)">';
mtxt += '<area shape="circle" coords=" 96,311,3" href="javascript:selectTSpoints(15086, 96,311)">';
mtxt += '<area shape="circle" coords="101,311,3" href="javascript:selectTSpoints(15087,101,311)">';
mtxt += '<area shape="circle" coords="106,311,3" href="javascript:selectTSpoints(15088,106,311)">';
mtxt += '<area shape="circle" coords="112,311,3" href="javascript:selectTSpoints(15089,112,311)">';
mtxt += '<area shape="circle" coords="117,311,3" href="javascript:selectTSpoints(15090,117,311)">';
mtxt += '<area shape="circle" coords="122,311,3" href="javascript:selectTSpoints(15091,122,311)">';
mtxt += '<area shape="circle" coords="127,311,3" href="javascript:selectTSpoints(15092,127,311)">';
mtxt += '<area shape="circle" coords="132,311,3" href="javascript:selectTSpoints(15093,132,311)">';
mtxt += '<area shape="circle" coords="137,311,3" href="javascript:selectTSpoints(15094,137,311)">';
mtxt += '<area shape="circle" coords="142,311,3" href="javascript:selectTSpoints(15095,142,311)">';
mtxt += '<area shape="circle" coords="147,311,3" href="javascript:selectTSpoints(15096,147,311)">';
mtxt += '<area shape="circle" coords="152,311,3" href="javascript:selectTSpoints(15097,152,311)">';
mtxt += '<area shape="circle" coords="157,311,3" href="javascript:selectTSpoints(15098,157,311)">';
mtxt += '<area shape="circle" coords="162,311,3" href="javascript:selectTSpoints(15099,162,311)">';
mtxt += '<area shape="circle" coords="168,311,3" href="javascript:selectTSpoints(15100,168,311)">';
mtxt += '<area shape="circle" coords="173,311,3" href="javascript:selectTSpoints(15101,173,311)">';
mtxt += '<area shape="circle" coords="178,311,3" href="javascript:selectTSpoints(15102,178,311)">';
mtxt += '<area shape="circle" coords="183,311,3" href="javascript:selectTSpoints(15103,183,311)">';
mtxt += '<area shape="circle" coords="188,311,3" href="javascript:selectTSpoints(15104,188,311)">';
mtxt += '<area shape="circle" coords="193,311,3" href="javascript:selectTSpoints(15105,193,311)">';
mtxt += '<area shape="circle" coords="198,311,3" href="javascript:selectTSpoints(15106,198,311)">';
mtxt += '<area shape="circle" coords="203,311,3" href="javascript:selectTSpoints(15107,203,311)">';
mtxt += '<area shape="circle" coords="208,311,3" href="javascript:selectTSpoints(15108,208,311)">';
mtxt += '<area shape="circle" coords="213,311,3" href="javascript:selectTSpoints(15109,213,311)">';
mtxt += '<area shape="circle" coords="218,311,3" href="javascript:selectTSpoints(15110,218,311)">';
mtxt += '<area shape="circle" coords="224,311,3" href="javascript:selectTSpoints(15111,224,311)">';
mtxt += '<area shape="circle" coords="229,311,3" href="javascript:selectTSpoints(15112,229,311)">';
mtxt += '<area shape="circle" coords="234,311,3" href="javascript:selectTSpoints(15113,234,311)">';
mtxt += '<area shape="circle" coords="239,311,3" href="javascript:selectTSpoints(15114,239,311)">';
mtxt += '<area shape="circle" coords="244,311,3" href="javascript:selectTSpoints(15115,244,311)">';
mtxt += '<area shape="circle" coords="249,311,3" href="javascript:selectTSpoints(15116,249,311)">';
mtxt += '<area shape="circle" coords="254,311,3" href="javascript:selectTSpoints(15117,254,311)">';
mtxt += '<area shape="circle" coords="259,311,3" href="javascript:selectTSpoints(15118,259,311)">';
mtxt += '<area shape="circle" coords="264,311,3" href="javascript:selectTSpoints(15119,264,311)">';
mtxt += '<area shape="circle" coords="269,311,3" href="javascript:selectTSpoints(15120,269,311)">';
mtxt += '<area shape="circle" coords="274,311,3" href="javascript:selectTSpoints(15121,274,311)">';
mtxt += '<area shape="circle" coords="280,311,3" href="javascript:selectTSpoints(15122,280,311)">';
mtxt += '<area shape="circle" coords="285,311,3" href="javascript:selectTSpoints(15123,285,311)">';
mtxt += '<area shape="circle" coords="290,311,3" href="javascript:selectTSpoints(15124,290,311)">';
mtxt += '<area shape="circle" coords="295,311,3" href="javascript:selectTSpoints(15125,295,311)">';
mtxt += '<area shape="circle" coords="300,311,3" href="javascript:selectTSpoints(15126,300,311)">';
mtxt += '<area shape="circle" coords="305,311,3" href="javascript:selectTSpoints(15127,305,311)">';
mtxt += '<area shape="circle" coords="310,311,3" href="javascript:selectTSpoints(15128,310,311)">';
mtxt += '<area shape="circle" coords="315,311,3" href="javascript:selectTSpoints(15129,315,311)">';
mtxt += '<area shape="circle" coords="320,311,3" href="javascript:selectTSpoints(15130,320,311)">';
mtxt += '<area shape="circle" coords="325,311,3" href="javascript:selectTSpoints(15131,325,311)">';
mtxt += '<area shape="circle" coords="330,311,3" href="javascript:selectTSpoints(15132,330,311)">';
mtxt += '<area shape="circle" coords="336,311,3" href="javascript:selectTSpoints(15133,336,311)">';
mtxt += '<area shape="circle" coords="341,311,3" href="javascript:selectTSpoints(15134,341,311)">';
mtxt += '<area shape="circle" coords="346,311,3" href="javascript:selectTSpoints(15135,346,311)">';
mtxt += '<area shape="circle" coords="351,311,3" href="javascript:selectTSpoints(15136,351,311)">';
mtxt += '<area shape="circle" coords="356,311,3" href="javascript:selectTSpoints(15137,356,311)">';
mtxt += '<area shape="circle" coords="361,311,3" href="javascript:selectTSpoints(15138,361,311)">';
mtxt += '<area shape="circle" coords="366,311,3" href="javascript:selectTSpoints(15139,366,311)">';
mtxt += '<area shape="circle" coords="371,311,3" href="javascript:selectTSpoints(15140,371,311)">';
mtxt += '<area shape="circle" coords="376,311,3" href="javascript:selectTSpoints(15141,376,311)">';
mtxt += '<area shape="circle" coords="381,311,3" href="javascript:selectTSpoints(15142,381,311)">';
mtxt += '<area shape="circle" coords="386,311,3" href="javascript:selectTSpoints(15143,386,311)">';
mtxt += '<area shape="circle" coords="392,311,3" href="javascript:selectTSpoints(15144,392,311)">';
mtxt += '<area shape="circle" coords="397,311,3" href="javascript:selectTSpoints(15001,397,311)">';
mtxt += '<area shape="circle" coords="402,311,3" href="javascript:selectTSpoints(15002,402,311)">';
mtxt += '<area shape="circle" coords="407,311,3" href="javascript:selectTSpoints(15003,407,311)">';
mtxt += '<area shape="circle" coords="412,311,3" href="javascript:selectTSpoints(15004,412,311)">';
mtxt += '<area shape="circle" coords="417,311,3" href="javascript:selectTSpoints(15005,417,311)">';
mtxt += '<area shape="circle" coords="422,311,3" href="javascript:selectTSpoints(15006,422,311)">';
mtxt += '<area shape="circle" coords="427,311,3" href="javascript:selectTSpoints(15007,427,311)">';
mtxt += '<area shape="circle" coords="432,311,3" href="javascript:selectTSpoints(15008,432,311)">';
mtxt += '<area shape="circle" coords="437,311,3" href="javascript:selectTSpoints(15009,437,311)">';
mtxt += '<area shape="circle" coords="442,311,3" href="javascript:selectTSpoints(15010,442,311)">';
mtxt += '<area shape="circle" coords="447,311,3" href="javascript:selectTSpoints(15011,447,311)">';
mtxt += '<area shape="circle" coords="453,311,3" href="javascript:selectTSpoints(15012,453,311)">';
mtxt += '<area shape="circle" coords="458,311,3" href="javascript:selectTSpoints(15013,458,311)">';
mtxt += '<area shape="circle" coords="463,311,3" href="javascript:selectTSpoints(15014,463,311)">';
mtxt += '<area shape="circle" coords="468,311,3" href="javascript:selectTSpoints(15015,468,311)">';
mtxt += '<area shape="circle" coords="473,311,3" href="javascript:selectTSpoints(15016,473,311)">';
mtxt += '<area shape="circle" coords="478,311,3" href="javascript:selectTSpoints(15017,478,311)">';
mtxt += '<area shape="circle" coords="483,311,3" href="javascript:selectTSpoints(15018,483,311)">';
mtxt += '<area shape="circle" coords="488,311,3" href="javascript:selectTSpoints(15019,488,311)">';
mtxt += '<area shape="circle" coords="493,311,3" href="javascript:selectTSpoints(15020,493,311)">';
mtxt += '<area shape="circle" coords="498,311,3" href="javascript:selectTSpoints(15021,498,311)">';
mtxt += '<area shape="circle" coords="503,311,3" href="javascript:selectTSpoints(15022,503,311)">';
mtxt += '<area shape="circle" coords="509,311,3" href="javascript:selectTSpoints(15023,509,311)">';
mtxt += '<area shape="circle" coords="514,311,3" href="javascript:selectTSpoints(15024,514,311)">';
mtxt += '<area shape="circle" coords="519,311,3" href="javascript:selectTSpoints(15025,519,311)">';
mtxt += '<area shape="circle" coords="524,311,3" href="javascript:selectTSpoints(15026,524,311)">';
mtxt += '<area shape="circle" coords="529,311,3" href="javascript:selectTSpoints(15027,529,311)">';
mtxt += '<area shape="circle" coords="534,311,3" href="javascript:selectTSpoints(15028,534,311)">';
mtxt += '<area shape="circle" coords="539,311,3" href="javascript:selectTSpoints(15029,539,311)">';
mtxt += '<area shape="circle" coords="544,311,3" href="javascript:selectTSpoints(15030,544,311)">';
mtxt += '<area shape="circle" coords="549,311,3" href="javascript:selectTSpoints(15031,549,311)">';
mtxt += '<area shape="circle" coords="554,311,3" href="javascript:selectTSpoints(15032,554,311)">';
mtxt += '<area shape="circle" coords="559,311,3" href="javascript:selectTSpoints(15033,559,311)">';
mtxt += '<area shape="circle" coords="565,311,3" href="javascript:selectTSpoints(15034,565,311)">';
mtxt += '<area shape="circle" coords="570,311,3" href="javascript:selectTSpoints(15035,570,311)">';
mtxt += '<area shape="circle" coords="575,311,3" href="javascript:selectTSpoints(15036,575,311)">';
mtxt += '<area shape="circle" coords="580,311,3" href="javascript:selectTSpoints(15037,580,311)">';
mtxt += '<area shape="circle" coords="585,311,3" href="javascript:selectTSpoints(15038,585,311)">';
mtxt += '<area shape="circle" coords="590,311,3" href="javascript:selectTSpoints(15039,590,311)">';
mtxt += '<area shape="circle" coords="595,311,3" href="javascript:selectTSpoints(15040,595,311)">';
mtxt += '<area shape="circle" coords="600,311,3" href="javascript:selectTSpoints(15041,600,311)">';
mtxt += '<area shape="circle" coords="605,311,3" href="javascript:selectTSpoints(15042,605,311)">';
mtxt += '<area shape="circle" coords="610,311,3" href="javascript:selectTSpoints(15043,610,311)">';
mtxt += '<area shape="circle" coords="615,311,3" href="javascript:selectTSpoints(15044,615,311)">';
mtxt += '<area shape="circle" coords="621,311,3" href="javascript:selectTSpoints(15045,621,311)">';
mtxt += '<area shape="circle" coords="626,311,3" href="javascript:selectTSpoints(15046,626,311)">';
mtxt += '<area shape="circle" coords="631,311,3" href="javascript:selectTSpoints(15047,631,311)">';
mtxt += '<area shape="circle" coords="636,311,3" href="javascript:selectTSpoints(15048,636,311)">';
mtxt += '<area shape="circle" coords="641,311,3" href="javascript:selectTSpoints(15049,641,311)">';
mtxt += '<area shape="circle" coords="646,311,3" href="javascript:selectTSpoints(15050,646,311)">';
mtxt += '<area shape="circle" coords="651,311,3" href="javascript:selectTSpoints(15051,651,311)">';
mtxt += '<area shape="circle" coords="656,311,3" href="javascript:selectTSpoints(15052,656,311)">';
mtxt += '<area shape="circle" coords="661,311,3" href="javascript:selectTSpoints(15053,661,311)">';
mtxt += '<area shape="circle" coords="666,311,3" href="javascript:selectTSpoints(15054,666,311)">';
mtxt += '<area shape="circle" coords="671,311,3" href="javascript:selectTSpoints(15055,671,311)">';
mtxt += '<area shape="circle" coords="677,311,3" href="javascript:selectTSpoints(15056,677,311)">';
mtxt += '<area shape="circle" coords="682,311,3" href="javascript:selectTSpoints(15057,682,311)">';
mtxt += '<area shape="circle" coords="687,311,3" href="javascript:selectTSpoints(15058,687,311)">';
mtxt += '<area shape="circle" coords="692,311,3" href="javascript:selectTSpoints(15059,692,311)">';
mtxt += '<area shape="circle" coords="697,311,3" href="javascript:selectTSpoints(15060,697,311)">';
mtxt += '<area shape="circle" coords="702,311,3" href="javascript:selectTSpoints(15061,702,311)">';
mtxt += '<area shape="circle" coords="707,311,3" href="javascript:selectTSpoints(15062,707,311)">';
mtxt += '<area shape="circle" coords="712,311,3" href="javascript:selectTSpoints(15063,712,311)">';
mtxt += '<area shape="circle" coords="717,311,3" href="javascript:selectTSpoints(15064,717,311)">';
mtxt += '<area shape="circle" coords="722,311,3" href="javascript:selectTSpoints(15065,722,311)">';
mtxt += '<area shape="circle" coords="727,311,3" href="javascript:selectTSpoints(15066,727,311)">';
mtxt += '<area shape="circle" coords="733,311,3" href="javascript:selectTSpoints(15067,733,311)">';
mtxt += '<area shape="circle" coords="738,311,3" href="javascript:selectTSpoints(15068,738,311)">';
mtxt += '<area shape="circle" coords="743,311,3" href="javascript:selectTSpoints(15069,743,311)">';
mtxt += '<area shape="circle" coords="748,311,3" href="javascript:selectTSpoints(15070,748,311)">';
mtxt += '<area shape="circle" coords="753,311,3" href="javascript:selectTSpoints(15071,753,311)">';
mtxt += '<area shape="circle" coords="758,311,3" href="javascript:selectTSpoints(15072,758,311)">';
mtxt += '<area shape="circle" coords=" 30,306,3" href="javascript:selectTSpoints(16073, 30,306)">';
mtxt += '<area shape="circle" coords=" 35,306,3" href="javascript:selectTSpoints(16074, 35,306)">';
mtxt += '<area shape="circle" coords=" 40,306,3" href="javascript:selectTSpoints(16075, 40,306)">';
mtxt += '<area shape="circle" coords=" 45,306,3" href="javascript:selectTSpoints(16076, 45,306)">';
mtxt += '<area shape="circle" coords=" 50,306,3" href="javascript:selectTSpoints(16077, 50,306)">';
mtxt += '<area shape="circle" coords=" 56,306,3" href="javascript:selectTSpoints(16078, 56,306)">';
mtxt += '<area shape="circle" coords=" 61,306,3" href="javascript:selectTSpoints(16079, 61,306)">';
mtxt += '<area shape="circle" coords=" 66,306,3" href="javascript:selectTSpoints(16080, 66,306)">';
mtxt += '<area shape="circle" coords=" 71,306,3" href="javascript:selectTSpoints(16081, 71,306)">';
mtxt += '<area shape="circle" coords=" 76,306,3" href="javascript:selectTSpoints(16082, 76,306)">';
mtxt += '<area shape="circle" coords=" 81,306,3" href="javascript:selectTSpoints(16083, 81,306)">';
mtxt += '<area shape="circle" coords=" 86,306,3" href="javascript:selectTSpoints(16084, 86,306)">';
mtxt += '<area shape="circle" coords=" 91,306,3" href="javascript:selectTSpoints(16085, 91,306)">';
mtxt += '<area shape="circle" coords=" 96,306,3" href="javascript:selectTSpoints(16086, 96,306)">';
mtxt += '<area shape="circle" coords="101,306,3" href="javascript:selectTSpoints(16087,101,306)">';
mtxt += '<area shape="circle" coords="106,306,3" href="javascript:selectTSpoints(16088,106,306)">';
mtxt += '<area shape="circle" coords="112,306,3" href="javascript:selectTSpoints(16089,112,306)">';
mtxt += '<area shape="circle" coords="117,306,3" href="javascript:selectTSpoints(16090,117,306)">';
mtxt += '<area shape="circle" coords="122,306,3" href="javascript:selectTSpoints(16091,122,306)">';
mtxt += '<area shape="circle" coords="127,306,3" href="javascript:selectTSpoints(16092,127,306)">';
mtxt += '<area shape="circle" coords="132,306,3" href="javascript:selectTSpoints(16093,132,306)">';
mtxt += '<area shape="circle" coords="137,306,3" href="javascript:selectTSpoints(16094,137,306)">';
mtxt += '<area shape="circle" coords="142,306,3" href="javascript:selectTSpoints(16095,142,306)">';
mtxt += '<area shape="circle" coords="147,306,3" href="javascript:selectTSpoints(16096,147,306)">';
mtxt += '<area shape="circle" coords="152,306,3" href="javascript:selectTSpoints(16097,152,306)">';
mtxt += '<area shape="circle" coords="157,306,3" href="javascript:selectTSpoints(16098,157,306)">';
mtxt += '<area shape="circle" coords="162,306,3" href="javascript:selectTSpoints(16099,162,306)">';
mtxt += '<area shape="circle" coords="168,306,3" href="javascript:selectTSpoints(16100,168,306)">';
mtxt += '<area shape="circle" coords="173,306,3" href="javascript:selectTSpoints(16101,173,306)">';
mtxt += '<area shape="circle" coords="178,306,3" href="javascript:selectTSpoints(16102,178,306)">';
mtxt += '<area shape="circle" coords="183,306,3" href="javascript:selectTSpoints(16103,183,306)">';
mtxt += '<area shape="circle" coords="188,306,3" href="javascript:selectTSpoints(16104,188,306)">';
mtxt += '<area shape="circle" coords="193,306,3" href="javascript:selectTSpoints(16105,193,306)">';
mtxt += '<area shape="circle" coords="198,306,3" href="javascript:selectTSpoints(16106,198,306)">';
mtxt += '<area shape="circle" coords="203,306,3" href="javascript:selectTSpoints(16107,203,306)">';
mtxt += '<area shape="circle" coords="208,306,3" href="javascript:selectTSpoints(16108,208,306)">';
mtxt += '<area shape="circle" coords="213,306,3" href="javascript:selectTSpoints(16109,213,306)">';
mtxt += '<area shape="circle" coords="218,306,3" href="javascript:selectTSpoints(16110,218,306)">';
mtxt += '<area shape="circle" coords="224,306,3" href="javascript:selectTSpoints(16111,224,306)">';
mtxt += '<area shape="circle" coords="229,306,3" href="javascript:selectTSpoints(16112,229,306)">';
mtxt += '<area shape="circle" coords="234,306,3" href="javascript:selectTSpoints(16113,234,306)">';
mtxt += '<area shape="circle" coords="239,306,3" href="javascript:selectTSpoints(16114,239,306)">';
mtxt += '<area shape="circle" coords="244,306,3" href="javascript:selectTSpoints(16115,244,306)">';
mtxt += '<area shape="circle" coords="249,306,3" href="javascript:selectTSpoints(16116,249,306)">';
mtxt += '<area shape="circle" coords="254,306,3" href="javascript:selectTSpoints(16117,254,306)">';
mtxt += '<area shape="circle" coords="259,306,3" href="javascript:selectTSpoints(16118,259,306)">';
mtxt += '<area shape="circle" coords="264,306,3" href="javascript:selectTSpoints(16119,264,306)">';
mtxt += '<area shape="circle" coords="269,306,3" href="javascript:selectTSpoints(16120,269,306)">';
mtxt += '<area shape="circle" coords="274,306,3" href="javascript:selectTSpoints(16121,274,306)">';
mtxt += '<area shape="circle" coords="280,306,3" href="javascript:selectTSpoints(16122,280,306)">';
mtxt += '<area shape="circle" coords="285,306,3" href="javascript:selectTSpoints(16123,285,306)">';
mtxt += '<area shape="circle" coords="290,306,3" href="javascript:selectTSpoints(16124,290,306)">';
mtxt += '<area shape="circle" coords="295,306,3" href="javascript:selectTSpoints(16125,295,306)">';
mtxt += '<area shape="circle" coords="300,306,3" href="javascript:selectTSpoints(16126,300,306)">';
mtxt += '<area shape="circle" coords="305,306,3" href="javascript:selectTSpoints(16127,305,306)">';
mtxt += '<area shape="circle" coords="310,306,3" href="javascript:selectTSpoints(16128,310,306)">';
mtxt += '<area shape="circle" coords="315,306,3" href="javascript:selectTSpoints(16129,315,306)">';
mtxt += '<area shape="circle" coords="320,306,3" href="javascript:selectTSpoints(16130,320,306)">';
mtxt += '<area shape="circle" coords="325,306,3" href="javascript:selectTSpoints(16131,325,306)">';
mtxt += '<area shape="circle" coords="330,306,3" href="javascript:selectTSpoints(16132,330,306)">';
mtxt += '<area shape="circle" coords="336,306,3" href="javascript:selectTSpoints(16133,336,306)">';
mtxt += '<area shape="circle" coords="341,306,3" href="javascript:selectTSpoints(16134,341,306)">';
mtxt += '<area shape="circle" coords="346,306,3" href="javascript:selectTSpoints(16135,346,306)">';
mtxt += '<area shape="circle" coords="351,306,3" href="javascript:selectTSpoints(16136,351,306)">';
mtxt += '<area shape="circle" coords="356,306,3" href="javascript:selectTSpoints(16137,356,306)">';
mtxt += '<area shape="circle" coords="361,306,3" href="javascript:selectTSpoints(16138,361,306)">';
mtxt += '<area shape="circle" coords="366,306,3" href="javascript:selectTSpoints(16139,366,306)">';
mtxt += '<area shape="circle" coords="371,306,3" href="javascript:selectTSpoints(16140,371,306)">';
mtxt += '<area shape="circle" coords="376,306,3" href="javascript:selectTSpoints(16141,376,306)">';
mtxt += '<area shape="circle" coords="381,306,3" href="javascript:selectTSpoints(16142,381,306)">';
mtxt += '<area shape="circle" coords="386,306,3" href="javascript:selectTSpoints(16143,386,306)">';
mtxt += '<area shape="circle" coords="392,306,3" href="javascript:selectTSpoints(16144,392,306)">';
mtxt += '<area shape="circle" coords="397,306,3" href="javascript:selectTSpoints(16001,397,306)">';
mtxt += '<area shape="circle" coords="402,306,3" href="javascript:selectTSpoints(16002,402,306)">';
mtxt += '<area shape="circle" coords="407,306,3" href="javascript:selectTSpoints(16003,407,306)">';
mtxt += '<area shape="circle" coords="412,306,3" href="javascript:selectTSpoints(16004,412,306)">';
mtxt += '<area shape="circle" coords="417,306,3" href="javascript:selectTSpoints(16005,417,306)">';
mtxt += '<area shape="circle" coords="422,306,3" href="javascript:selectTSpoints(16006,422,306)">';
mtxt += '<area shape="circle" coords="427,306,3" href="javascript:selectTSpoints(16007,427,306)">';
mtxt += '<area shape="circle" coords="432,306,3" href="javascript:selectTSpoints(16008,432,306)">';
mtxt += '<area shape="circle" coords="437,306,3" href="javascript:selectTSpoints(16009,437,306)">';
mtxt += '<area shape="circle" coords="442,306,3" href="javascript:selectTSpoints(16010,442,306)">';
mtxt += '<area shape="circle" coords="447,306,3" href="javascript:selectTSpoints(16011,447,306)">';
mtxt += '<area shape="circle" coords="453,306,3" href="javascript:selectTSpoints(16012,453,306)">';
mtxt += '<area shape="circle" coords="458,306,3" href="javascript:selectTSpoints(16013,458,306)">';
mtxt += '<area shape="circle" coords="463,306,3" href="javascript:selectTSpoints(16014,463,306)">';
mtxt += '<area shape="circle" coords="468,306,3" href="javascript:selectTSpoints(16015,468,306)">';
mtxt += '<area shape="circle" coords="473,306,3" href="javascript:selectTSpoints(16016,473,306)">';
mtxt += '<area shape="circle" coords="478,306,3" href="javascript:selectTSpoints(16017,478,306)">';
mtxt += '<area shape="circle" coords="483,306,3" href="javascript:selectTSpoints(16018,483,306)">';
mtxt += '<area shape="circle" coords="488,306,3" href="javascript:selectTSpoints(16019,488,306)">';
mtxt += '<area shape="circle" coords="493,306,3" href="javascript:selectTSpoints(16020,493,306)">';
mtxt += '<area shape="circle" coords="498,306,3" href="javascript:selectTSpoints(16021,498,306)">';
mtxt += '<area shape="circle" coords="503,306,3" href="javascript:selectTSpoints(16022,503,306)">';
mtxt += '<area shape="circle" coords="509,306,3" href="javascript:selectTSpoints(16023,509,306)">';
mtxt += '<area shape="circle" coords="514,306,3" href="javascript:selectTSpoints(16024,514,306)">';
mtxt += '<area shape="circle" coords="519,306,3" href="javascript:selectTSpoints(16025,519,306)">';
mtxt += '<area shape="circle" coords="524,306,3" href="javascript:selectTSpoints(16026,524,306)">';
mtxt += '<area shape="circle" coords="529,306,3" href="javascript:selectTSpoints(16027,529,306)">';
mtxt += '<area shape="circle" coords="534,306,3" href="javascript:selectTSpoints(16028,534,306)">';
mtxt += '<area shape="circle" coords="539,306,3" href="javascript:selectTSpoints(16029,539,306)">';
mtxt += '<area shape="circle" coords="544,306,3" href="javascript:selectTSpoints(16030,544,306)">';
mtxt += '<area shape="circle" coords="549,306,3" href="javascript:selectTSpoints(16031,549,306)">';
mtxt += '<area shape="circle" coords="554,306,3" href="javascript:selectTSpoints(16032,554,306)">';
mtxt += '<area shape="circle" coords="559,306,3" href="javascript:selectTSpoints(16033,559,306)">';
mtxt += '<area shape="circle" coords="565,306,3" href="javascript:selectTSpoints(16034,565,306)">';
mtxt += '<area shape="circle" coords="570,306,3" href="javascript:selectTSpoints(16035,570,306)">';
mtxt += '<area shape="circle" coords="575,306,3" href="javascript:selectTSpoints(16036,575,306)">';
mtxt += '<area shape="circle" coords="580,306,3" href="javascript:selectTSpoints(16037,580,306)">';
mtxt += '<area shape="circle" coords="585,306,3" href="javascript:selectTSpoints(16038,585,306)">';
mtxt += '<area shape="circle" coords="590,306,3" href="javascript:selectTSpoints(16039,590,306)">';
mtxt += '<area shape="circle" coords="595,306,3" href="javascript:selectTSpoints(16040,595,306)">';
mtxt += '<area shape="circle" coords="600,306,3" href="javascript:selectTSpoints(16041,600,306)">';
mtxt += '<area shape="circle" coords="605,306,3" href="javascript:selectTSpoints(16042,605,306)">';
mtxt += '<area shape="circle" coords="610,306,3" href="javascript:selectTSpoints(16043,610,306)">';
mtxt += '<area shape="circle" coords="615,306,3" href="javascript:selectTSpoints(16044,615,306)">';
mtxt += '<area shape="circle" coords="621,306,3" href="javascript:selectTSpoints(16045,621,306)">';
mtxt += '<area shape="circle" coords="626,306,3" href="javascript:selectTSpoints(16046,626,306)">';
mtxt += '<area shape="circle" coords="631,306,3" href="javascript:selectTSpoints(16047,631,306)">';
mtxt += '<area shape="circle" coords="636,306,3" href="javascript:selectTSpoints(16048,636,306)">';
mtxt += '<area shape="circle" coords="641,306,3" href="javascript:selectTSpoints(16049,641,306)">';
mtxt += '<area shape="circle" coords="646,306,3" href="javascript:selectTSpoints(16050,646,306)">';
mtxt += '<area shape="circle" coords="651,306,3" href="javascript:selectTSpoints(16051,651,306)">';
mtxt += '<area shape="circle" coords="656,306,3" href="javascript:selectTSpoints(16052,656,306)">';
mtxt += '<area shape="circle" coords="661,306,3" href="javascript:selectTSpoints(16053,661,306)">';
mtxt += '<area shape="circle" coords="666,306,3" href="javascript:selectTSpoints(16054,666,306)">';
mtxt += '<area shape="circle" coords="671,306,3" href="javascript:selectTSpoints(16055,671,306)">';
mtxt += '<area shape="circle" coords="677,306,3" href="javascript:selectTSpoints(16056,677,306)">';
mtxt += '<area shape="circle" coords="682,306,3" href="javascript:selectTSpoints(16057,682,306)">';
mtxt += '<area shape="circle" coords="687,306,3" href="javascript:selectTSpoints(16058,687,306)">';
mtxt += '<area shape="circle" coords="692,306,3" href="javascript:selectTSpoints(16059,692,306)">';
mtxt += '<area shape="circle" coords="697,306,3" href="javascript:selectTSpoints(16060,697,306)">';
mtxt += '<area shape="circle" coords="702,306,3" href="javascript:selectTSpoints(16061,702,306)">';
mtxt += '<area shape="circle" coords="707,306,3" href="javascript:selectTSpoints(16062,707,306)">';
mtxt += '<area shape="circle" coords="712,306,3" href="javascript:selectTSpoints(16063,712,306)">';
mtxt += '<area shape="circle" coords="717,306,3" href="javascript:selectTSpoints(16064,717,306)">';
mtxt += '<area shape="circle" coords="722,306,3" href="javascript:selectTSpoints(16065,722,306)">';
mtxt += '<area shape="circle" coords="727,306,3" href="javascript:selectTSpoints(16066,727,306)">';
mtxt += '<area shape="circle" coords="733,306,3" href="javascript:selectTSpoints(16067,733,306)">';
mtxt += '<area shape="circle" coords="738,306,3" href="javascript:selectTSpoints(16068,738,306)">';
mtxt += '<area shape="circle" coords="743,306,3" href="javascript:selectTSpoints(16069,743,306)">';
mtxt += '<area shape="circle" coords="748,306,3" href="javascript:selectTSpoints(16070,748,306)">';
mtxt += '<area shape="circle" coords="753,306,3" href="javascript:selectTSpoints(16071,753,306)">';
mtxt += '<area shape="circle" coords="758,306,3" href="javascript:selectTSpoints(16072,758,306)">';
mtxt += '<area shape="circle" coords=" 30,301,3" href="javascript:selectTSpoints(17073, 30,301)">';
mtxt += '<area shape="circle" coords=" 35,301,3" href="javascript:selectTSpoints(17074, 35,301)">';
mtxt += '<area shape="circle" coords=" 40,301,3" href="javascript:selectTSpoints(17075, 40,301)">';
mtxt += '<area shape="circle" coords=" 45,301,3" href="javascript:selectTSpoints(17076, 45,301)">';
mtxt += '<area shape="circle" coords=" 50,301,3" href="javascript:selectTSpoints(17077, 50,301)">';
mtxt += '<area shape="circle" coords=" 56,301,3" href="javascript:selectTSpoints(17078, 56,301)">';
mtxt += '<area shape="circle" coords=" 61,301,3" href="javascript:selectTSpoints(17079, 61,301)">';
mtxt += '<area shape="circle" coords=" 66,301,3" href="javascript:selectTSpoints(17080, 66,301)">';
mtxt += '<area shape="circle" coords=" 71,301,3" href="javascript:selectTSpoints(17081, 71,301)">';
mtxt += '<area shape="circle" coords=" 76,301,3" href="javascript:selectTSpoints(17082, 76,301)">';
mtxt += '<area shape="circle" coords=" 81,301,3" href="javascript:selectTSpoints(17083, 81,301)">';
mtxt += '<area shape="circle" coords=" 86,301,3" href="javascript:selectTSpoints(17084, 86,301)">';
mtxt += '<area shape="circle" coords=" 91,301,3" href="javascript:selectTSpoints(17085, 91,301)">';
mtxt += '<area shape="circle" coords=" 96,301,3" href="javascript:selectTSpoints(17086, 96,301)">';
mtxt += '<area shape="circle" coords="101,301,3" href="javascript:selectTSpoints(17087,101,301)">';
mtxt += '<area shape="circle" coords="106,301,3" href="javascript:selectTSpoints(17088,106,301)">';
mtxt += '<area shape="circle" coords="112,301,3" href="javascript:selectTSpoints(17089,112,301)">';
mtxt += '<area shape="circle" coords="117,301,3" href="javascript:selectTSpoints(17090,117,301)">';
mtxt += '<area shape="circle" coords="122,301,3" href="javascript:selectTSpoints(17091,122,301)">';
mtxt += '<area shape="circle" coords="127,301,3" href="javascript:selectTSpoints(17092,127,301)">';
mtxt += '<area shape="circle" coords="132,301,3" href="javascript:selectTSpoints(17093,132,301)">';
mtxt += '<area shape="circle" coords="137,301,3" href="javascript:selectTSpoints(17094,137,301)">';
mtxt += '<area shape="circle" coords="142,301,3" href="javascript:selectTSpoints(17095,142,301)">';
mtxt += '<area shape="circle" coords="147,301,3" href="javascript:selectTSpoints(17096,147,301)">';
mtxt += '<area shape="circle" coords="152,301,3" href="javascript:selectTSpoints(17097,152,301)">';
mtxt += '<area shape="circle" coords="157,301,3" href="javascript:selectTSpoints(17098,157,301)">';
mtxt += '<area shape="circle" coords="162,301,3" href="javascript:selectTSpoints(17099,162,301)">';
mtxt += '<area shape="circle" coords="168,301,3" href="javascript:selectTSpoints(17100,168,301)">';
mtxt += '<area shape="circle" coords="173,301,3" href="javascript:selectTSpoints(17101,173,301)">';
mtxt += '<area shape="circle" coords="178,301,3" href="javascript:selectTSpoints(17102,178,301)">';
mtxt += '<area shape="circle" coords="183,301,3" href="javascript:selectTSpoints(17103,183,301)">';
mtxt += '<area shape="circle" coords="188,301,3" href="javascript:selectTSpoints(17104,188,301)">';
mtxt += '<area shape="circle" coords="193,301,3" href="javascript:selectTSpoints(17105,193,301)">';
mtxt += '<area shape="circle" coords="198,301,3" href="javascript:selectTSpoints(17106,198,301)">';
mtxt += '<area shape="circle" coords="203,301,3" href="javascript:selectTSpoints(17107,203,301)">';
mtxt += '<area shape="circle" coords="208,301,3" href="javascript:selectTSpoints(17108,208,301)">';
mtxt += '<area shape="circle" coords="213,301,3" href="javascript:selectTSpoints(17109,213,301)">';
mtxt += '<area shape="circle" coords="218,301,3" href="javascript:selectTSpoints(17110,218,301)">';
mtxt += '<area shape="circle" coords="224,301,3" href="javascript:selectTSpoints(17111,224,301)">';
mtxt += '<area shape="circle" coords="229,301,3" href="javascript:selectTSpoints(17112,229,301)">';
mtxt += '<area shape="circle" coords="234,301,3" href="javascript:selectTSpoints(17113,234,301)">';
mtxt += '<area shape="circle" coords="239,301,3" href="javascript:selectTSpoints(17114,239,301)">';
mtxt += '<area shape="circle" coords="244,301,3" href="javascript:selectTSpoints(17115,244,301)">';
mtxt += '<area shape="circle" coords="249,301,3" href="javascript:selectTSpoints(17116,249,301)">';
mtxt += '<area shape="circle" coords="254,301,3" href="javascript:selectTSpoints(17117,254,301)">';
mtxt += '<area shape="circle" coords="259,301,3" href="javascript:selectTSpoints(17118,259,301)">';
mtxt += '<area shape="circle" coords="264,301,3" href="javascript:selectTSpoints(17119,264,301)">';
mtxt += '<area shape="circle" coords="269,301,3" href="javascript:selectTSpoints(17120,269,301)">';
mtxt += '<area shape="circle" coords="274,301,3" href="javascript:selectTSpoints(17121,274,301)">';
mtxt += '<area shape="circle" coords="280,301,3" href="javascript:selectTSpoints(17122,280,301)">';
mtxt += '<area shape="circle" coords="285,301,3" href="javascript:selectTSpoints(17123,285,301)">';
mtxt += '<area shape="circle" coords="290,301,3" href="javascript:selectTSpoints(17124,290,301)">';
mtxt += '<area shape="circle" coords="295,301,3" href="javascript:selectTSpoints(17125,295,301)">';
mtxt += '<area shape="circle" coords="300,301,3" href="javascript:selectTSpoints(17126,300,301)">';
mtxt += '<area shape="circle" coords="305,301,3" href="javascript:selectTSpoints(17127,305,301)">';
mtxt += '<area shape="circle" coords="310,301,3" href="javascript:selectTSpoints(17128,310,301)">';
mtxt += '<area shape="circle" coords="315,301,3" href="javascript:selectTSpoints(17129,315,301)">';
mtxt += '<area shape="circle" coords="320,301,3" href="javascript:selectTSpoints(17130,320,301)">';
mtxt += '<area shape="circle" coords="325,301,3" href="javascript:selectTSpoints(17131,325,301)">';
mtxt += '<area shape="circle" coords="330,301,3" href="javascript:selectTSpoints(17132,330,301)">';
mtxt += '<area shape="circle" coords="336,301,3" href="javascript:selectTSpoints(17133,336,301)">';
mtxt += '<area shape="circle" coords="341,301,3" href="javascript:selectTSpoints(17134,341,301)">';
mtxt += '<area shape="circle" coords="346,301,3" href="javascript:selectTSpoints(17135,346,301)">';
mtxt += '<area shape="circle" coords="351,301,3" href="javascript:selectTSpoints(17136,351,301)">';
mtxt += '<area shape="circle" coords="356,301,3" href="javascript:selectTSpoints(17137,356,301)">';
mtxt += '<area shape="circle" coords="361,301,3" href="javascript:selectTSpoints(17138,361,301)">';
mtxt += '<area shape="circle" coords="366,301,3" href="javascript:selectTSpoints(17139,366,301)">';
mtxt += '<area shape="circle" coords="371,301,3" href="javascript:selectTSpoints(17140,371,301)">';
mtxt += '<area shape="circle" coords="376,301,3" href="javascript:selectTSpoints(17141,376,301)">';
mtxt += '<area shape="circle" coords="381,301,3" href="javascript:selectTSpoints(17142,381,301)">';
mtxt += '<area shape="circle" coords="386,301,3" href="javascript:selectTSpoints(17143,386,301)">';
mtxt += '<area shape="circle" coords="392,301,3" href="javascript:selectTSpoints(17144,392,301)">';
mtxt += '<area shape="circle" coords="397,301,3" href="javascript:selectTSpoints(17001,397,301)">';
mtxt += '<area shape="circle" coords="402,301,3" href="javascript:selectTSpoints(17002,402,301)">';
mtxt += '<area shape="circle" coords="407,301,3" href="javascript:selectTSpoints(17003,407,301)">';
mtxt += '<area shape="circle" coords="412,301,3" href="javascript:selectTSpoints(17004,412,301)">';
mtxt += '<area shape="circle" coords="417,301,3" href="javascript:selectTSpoints(17005,417,301)">';
mtxt += '<area shape="circle" coords="422,301,3" href="javascript:selectTSpoints(17006,422,301)">';
mtxt += '<area shape="circle" coords="427,301,3" href="javascript:selectTSpoints(17007,427,301)">';
mtxt += '<area shape="circle" coords="432,301,3" href="javascript:selectTSpoints(17008,432,301)">';
mtxt += '<area shape="circle" coords="437,301,3" href="javascript:selectTSpoints(17009,437,301)">';
mtxt += '<area shape="circle" coords="442,301,3" href="javascript:selectTSpoints(17010,442,301)">';
mtxt += '<area shape="circle" coords="447,301,3" href="javascript:selectTSpoints(17011,447,301)">';
mtxt += '<area shape="circle" coords="453,301,3" href="javascript:selectTSpoints(17012,453,301)">';
mtxt += '<area shape="circle" coords="458,301,3" href="javascript:selectTSpoints(17013,458,301)">';
mtxt += '<area shape="circle" coords="463,301,3" href="javascript:selectTSpoints(17014,463,301)">';
mtxt += '<area shape="circle" coords="468,301,3" href="javascript:selectTSpoints(17015,468,301)">';
mtxt += '<area shape="circle" coords="473,301,3" href="javascript:selectTSpoints(17016,473,301)">';
mtxt += '<area shape="circle" coords="478,301,3" href="javascript:selectTSpoints(17017,478,301)">';
mtxt += '<area shape="circle" coords="483,301,3" href="javascript:selectTSpoints(17018,483,301)">';
mtxt += '<area shape="circle" coords="488,301,3" href="javascript:selectTSpoints(17019,488,301)">';
mtxt += '<area shape="circle" coords="493,301,3" href="javascript:selectTSpoints(17020,493,301)">';
mtxt += '<area shape="circle" coords="498,301,3" href="javascript:selectTSpoints(17021,498,301)">';
mtxt += '<area shape="circle" coords="503,301,3" href="javascript:selectTSpoints(17022,503,301)">';
mtxt += '<area shape="circle" coords="509,301,3" href="javascript:selectTSpoints(17023,509,301)">';
mtxt += '<area shape="circle" coords="514,301,3" href="javascript:selectTSpoints(17024,514,301)">';
mtxt += '<area shape="circle" coords="519,301,3" href="javascript:selectTSpoints(17025,519,301)">';
mtxt += '<area shape="circle" coords="524,301,3" href="javascript:selectTSpoints(17026,524,301)">';
mtxt += '<area shape="circle" coords="529,301,3" href="javascript:selectTSpoints(17027,529,301)">';
mtxt += '<area shape="circle" coords="534,301,3" href="javascript:selectTSpoints(17028,534,301)">';
mtxt += '<area shape="circle" coords="539,301,3" href="javascript:selectTSpoints(17029,539,301)">';
mtxt += '<area shape="circle" coords="544,301,3" href="javascript:selectTSpoints(17030,544,301)">';
mtxt += '<area shape="circle" coords="549,301,3" href="javascript:selectTSpoints(17031,549,301)">';
mtxt += '<area shape="circle" coords="554,301,3" href="javascript:selectTSpoints(17032,554,301)">';
mtxt += '<area shape="circle" coords="559,301,3" href="javascript:selectTSpoints(17033,559,301)">';
mtxt += '<area shape="circle" coords="565,301,3" href="javascript:selectTSpoints(17034,565,301)">';
mtxt += '<area shape="circle" coords="570,301,3" href="javascript:selectTSpoints(17035,570,301)">';
mtxt += '<area shape="circle" coords="575,301,3" href="javascript:selectTSpoints(17036,575,301)">';
mtxt += '<area shape="circle" coords="580,301,3" href="javascript:selectTSpoints(17037,580,301)">';
mtxt += '<area shape="circle" coords="585,301,3" href="javascript:selectTSpoints(17038,585,301)">';
mtxt += '<area shape="circle" coords="590,301,3" href="javascript:selectTSpoints(17039,590,301)">';
mtxt += '<area shape="circle" coords="595,301,3" href="javascript:selectTSpoints(17040,595,301)">';
mtxt += '<area shape="circle" coords="600,301,3" href="javascript:selectTSpoints(17041,600,301)">';
mtxt += '<area shape="circle" coords="605,301,3" href="javascript:selectTSpoints(17042,605,301)">';
mtxt += '<area shape="circle" coords="610,301,3" href="javascript:selectTSpoints(17043,610,301)">';
mtxt += '<area shape="circle" coords="615,301,3" href="javascript:selectTSpoints(17044,615,301)">';
mtxt += '<area shape="circle" coords="621,301,3" href="javascript:selectTSpoints(17045,621,301)">';
mtxt += '<area shape="circle" coords="626,301,3" href="javascript:selectTSpoints(17046,626,301)">';
mtxt += '<area shape="circle" coords="631,301,3" href="javascript:selectTSpoints(17047,631,301)">';
mtxt += '<area shape="circle" coords="636,301,3" href="javascript:selectTSpoints(17048,636,301)">';
mtxt += '<area shape="circle" coords="641,301,3" href="javascript:selectTSpoints(17049,641,301)">';
mtxt += '<area shape="circle" coords="646,301,3" href="javascript:selectTSpoints(17050,646,301)">';
mtxt += '<area shape="circle" coords="651,301,3" href="javascript:selectTSpoints(17051,651,301)">';
mtxt += '<area shape="circle" coords="656,301,3" href="javascript:selectTSpoints(17052,656,301)">';
mtxt += '<area shape="circle" coords="661,301,3" href="javascript:selectTSpoints(17053,661,301)">';
mtxt += '<area shape="circle" coords="666,301,3" href="javascript:selectTSpoints(17054,666,301)">';
mtxt += '<area shape="circle" coords="671,301,3" href="javascript:selectTSpoints(17055,671,301)">';
mtxt += '<area shape="circle" coords="677,301,3" href="javascript:selectTSpoints(17056,677,301)">';
mtxt += '<area shape="circle" coords="682,301,3" href="javascript:selectTSpoints(17057,682,301)">';
mtxt += '<area shape="circle" coords="687,301,3" href="javascript:selectTSpoints(17058,687,301)">';
mtxt += '<area shape="circle" coords="692,301,3" href="javascript:selectTSpoints(17059,692,301)">';
mtxt += '<area shape="circle" coords="697,301,3" href="javascript:selectTSpoints(17060,697,301)">';
mtxt += '<area shape="circle" coords="702,301,3" href="javascript:selectTSpoints(17061,702,301)">';
mtxt += '<area shape="circle" coords="707,301,3" href="javascript:selectTSpoints(17062,707,301)">';
mtxt += '<area shape="circle" coords="712,301,3" href="javascript:selectTSpoints(17063,712,301)">';
mtxt += '<area shape="circle" coords="717,301,3" href="javascript:selectTSpoints(17064,717,301)">';
mtxt += '<area shape="circle" coords="722,301,3" href="javascript:selectTSpoints(17065,722,301)">';
mtxt += '<area shape="circle" coords="727,301,3" href="javascript:selectTSpoints(17066,727,301)">';
mtxt += '<area shape="circle" coords="733,301,3" href="javascript:selectTSpoints(17067,733,301)">';
mtxt += '<area shape="circle" coords="738,301,3" href="javascript:selectTSpoints(17068,738,301)">';
mtxt += '<area shape="circle" coords="743,301,3" href="javascript:selectTSpoints(17069,743,301)">';
mtxt += '<area shape="circle" coords="748,301,3" href="javascript:selectTSpoints(17070,748,301)">';
mtxt += '<area shape="circle" coords="753,301,3" href="javascript:selectTSpoints(17071,753,301)">';
mtxt += '<area shape="circle" coords="758,301,3" href="javascript:selectTSpoints(17072,758,301)">';
mtxt += '<area shape="circle" coords=" 30,296,3" href="javascript:selectTSpoints(18073, 30,296)">';
mtxt += '<area shape="circle" coords=" 35,296,3" href="javascript:selectTSpoints(18074, 35,296)">';
mtxt += '<area shape="circle" coords=" 40,296,3" href="javascript:selectTSpoints(18075, 40,296)">';
mtxt += '<area shape="circle" coords=" 45,296,3" href="javascript:selectTSpoints(18076, 45,296)">';
mtxt += '<area shape="circle" coords=" 50,296,3" href="javascript:selectTSpoints(18077, 50,296)">';
mtxt += '<area shape="circle" coords=" 56,296,3" href="javascript:selectTSpoints(18078, 56,296)">';
mtxt += '<area shape="circle" coords=" 61,296,3" href="javascript:selectTSpoints(18079, 61,296)">';
mtxt += '<area shape="circle" coords=" 66,296,3" href="javascript:selectTSpoints(18080, 66,296)">';
mtxt += '<area shape="circle" coords=" 71,296,3" href="javascript:selectTSpoints(18081, 71,296)">';
mtxt += '<area shape="circle" coords=" 76,296,3" href="javascript:selectTSpoints(18082, 76,296)">';
mtxt += '<area shape="circle" coords=" 81,296,3" href="javascript:selectTSpoints(18083, 81,296)">';
mtxt += '<area shape="circle" coords=" 86,296,3" href="javascript:selectTSpoints(18084, 86,296)">';
mtxt += '<area shape="circle" coords=" 91,296,3" href="javascript:selectTSpoints(18085, 91,296)">';
mtxt += '<area shape="circle" coords=" 96,296,3" href="javascript:selectTSpoints(18086, 96,296)">';
mtxt += '<area shape="circle" coords="101,296,3" href="javascript:selectTSpoints(18087,101,296)">';
mtxt += '<area shape="circle" coords="106,296,3" href="javascript:selectTSpoints(18088,106,296)">';
mtxt += '<area shape="circle" coords="112,296,3" href="javascript:selectTSpoints(18089,112,296)">';
mtxt += '<area shape="circle" coords="117,296,3" href="javascript:selectTSpoints(18090,117,296)">';
mtxt += '<area shape="circle" coords="122,296,3" href="javascript:selectTSpoints(18091,122,296)">';
mtxt += '<area shape="circle" coords="127,296,3" href="javascript:selectTSpoints(18092,127,296)">';
mtxt += '<area shape="circle" coords="132,296,3" href="javascript:selectTSpoints(18093,132,296)">';
mtxt += '<area shape="circle" coords="137,296,3" href="javascript:selectTSpoints(18094,137,296)">';
mtxt += '<area shape="circle" coords="142,296,3" href="javascript:selectTSpoints(18095,142,296)">';
mtxt += '<area shape="circle" coords="147,296,3" href="javascript:selectTSpoints(18096,147,296)">';
mtxt += '<area shape="circle" coords="152,296,3" href="javascript:selectTSpoints(18097,152,296)">';
mtxt += '<area shape="circle" coords="157,296,3" href="javascript:selectTSpoints(18098,157,296)">';
mtxt += '<area shape="circle" coords="162,296,3" href="javascript:selectTSpoints(18099,162,296)">';
mtxt += '<area shape="circle" coords="168,296,3" href="javascript:selectTSpoints(18100,168,296)">';
mtxt += '<area shape="circle" coords="173,296,3" href="javascript:selectTSpoints(18101,173,296)">';
mtxt += '<area shape="circle" coords="178,296,3" href="javascript:selectTSpoints(18102,178,296)">';
mtxt += '<area shape="circle" coords="183,296,3" href="javascript:selectTSpoints(18103,183,296)">';
mtxt += '<area shape="circle" coords="188,296,3" href="javascript:selectTSpoints(18104,188,296)">';
mtxt += '<area shape="circle" coords="193,296,3" href="javascript:selectTSpoints(18105,193,296)">';
mtxt += '<area shape="circle" coords="198,296,3" href="javascript:selectTSpoints(18106,198,296)">';
mtxt += '<area shape="circle" coords="203,296,3" href="javascript:selectTSpoints(18107,203,296)">';
mtxt += '<area shape="circle" coords="208,296,3" href="javascript:selectTSpoints(18108,208,296)">';
mtxt += '<area shape="circle" coords="213,296,3" href="javascript:selectTSpoints(18109,213,296)">';
mtxt += '<area shape="circle" coords="218,296,3" href="javascript:selectTSpoints(18110,218,296)">';
mtxt += '<area shape="circle" coords="224,296,3" href="javascript:selectTSpoints(18111,224,296)">';
mtxt += '<area shape="circle" coords="229,296,3" href="javascript:selectTSpoints(18112,229,296)">';
mtxt += '<area shape="circle" coords="234,296,3" href="javascript:selectTSpoints(18113,234,296)">';
mtxt += '<area shape="circle" coords="239,296,3" href="javascript:selectTSpoints(18114,239,296)">';
mtxt += '<area shape="circle" coords="244,296,3" href="javascript:selectTSpoints(18115,244,296)">';
mtxt += '<area shape="circle" coords="249,296,3" href="javascript:selectTSpoints(18116,249,296)">';
mtxt += '<area shape="circle" coords="254,296,3" href="javascript:selectTSpoints(18117,254,296)">';
mtxt += '<area shape="circle" coords="259,296,3" href="javascript:selectTSpoints(18118,259,296)">';
mtxt += '<area shape="circle" coords="264,296,3" href="javascript:selectTSpoints(18119,264,296)">';
mtxt += '<area shape="circle" coords="269,296,3" href="javascript:selectTSpoints(18120,269,296)">';
mtxt += '<area shape="circle" coords="274,296,3" href="javascript:selectTSpoints(18121,274,296)">';
mtxt += '<area shape="circle" coords="280,296,3" href="javascript:selectTSpoints(18122,280,296)">';
mtxt += '<area shape="circle" coords="285,296,3" href="javascript:selectTSpoints(18123,285,296)">';
mtxt += '<area shape="circle" coords="290,296,3" href="javascript:selectTSpoints(18124,290,296)">';
mtxt += '<area shape="circle" coords="295,296,3" href="javascript:selectTSpoints(18125,295,296)">';
mtxt += '<area shape="circle" coords="300,296,3" href="javascript:selectTSpoints(18126,300,296)">';
mtxt += '<area shape="circle" coords="305,296,3" href="javascript:selectTSpoints(18127,305,296)">';
mtxt += '<area shape="circle" coords="310,296,3" href="javascript:selectTSpoints(18128,310,296)">';
mtxt += '<area shape="circle" coords="315,296,3" href="javascript:selectTSpoints(18129,315,296)">';
mtxt += '<area shape="circle" coords="320,296,3" href="javascript:selectTSpoints(18130,320,296)">';
mtxt += '<area shape="circle" coords="325,296,3" href="javascript:selectTSpoints(18131,325,296)">';
mtxt += '<area shape="circle" coords="330,296,3" href="javascript:selectTSpoints(18132,330,296)">';
mtxt += '<area shape="circle" coords="336,296,3" href="javascript:selectTSpoints(18133,336,296)">';
mtxt += '<area shape="circle" coords="341,296,3" href="javascript:selectTSpoints(18134,341,296)">';
mtxt += '<area shape="circle" coords="346,296,3" href="javascript:selectTSpoints(18135,346,296)">';
mtxt += '<area shape="circle" coords="351,296,3" href="javascript:selectTSpoints(18136,351,296)">';
mtxt += '<area shape="circle" coords="356,296,3" href="javascript:selectTSpoints(18137,356,296)">';
mtxt += '<area shape="circle" coords="361,296,3" href="javascript:selectTSpoints(18138,361,296)">';
mtxt += '<area shape="circle" coords="366,296,3" href="javascript:selectTSpoints(18139,366,296)">';
mtxt += '<area shape="circle" coords="371,296,3" href="javascript:selectTSpoints(18140,371,296)">';
mtxt += '<area shape="circle" coords="376,296,3" href="javascript:selectTSpoints(18141,376,296)">';
mtxt += '<area shape="circle" coords="381,296,3" href="javascript:selectTSpoints(18142,381,296)">';
mtxt += '<area shape="circle" coords="386,296,3" href="javascript:selectTSpoints(18143,386,296)">';
mtxt += '<area shape="circle" coords="392,296,3" href="javascript:selectTSpoints(18144,392,296)">';
mtxt += '<area shape="circle" coords="397,296,3" href="javascript:selectTSpoints(18001,397,296)">';
mtxt += '<area shape="circle" coords="402,296,3" href="javascript:selectTSpoints(18002,402,296)">';
mtxt += '<area shape="circle" coords="407,296,3" href="javascript:selectTSpoints(18003,407,296)">';
mtxt += '<area shape="circle" coords="412,296,3" href="javascript:selectTSpoints(18004,412,296)">';
mtxt += '<area shape="circle" coords="417,296,3" href="javascript:selectTSpoints(18005,417,296)">';
mtxt += '<area shape="circle" coords="422,296,3" href="javascript:selectTSpoints(18006,422,296)">';
mtxt += '<area shape="circle" coords="427,296,3" href="javascript:selectTSpoints(18007,427,296)">';
mtxt += '<area shape="circle" coords="432,296,3" href="javascript:selectTSpoints(18008,432,296)">';
mtxt += '<area shape="circle" coords="437,296,3" href="javascript:selectTSpoints(18009,437,296)">';
mtxt += '<area shape="circle" coords="442,296,3" href="javascript:selectTSpoints(18010,442,296)">';
mtxt += '<area shape="circle" coords="447,296,3" href="javascript:selectTSpoints(18011,447,296)">';
mtxt += '<area shape="circle" coords="453,296,3" href="javascript:selectTSpoints(18012,453,296)">';
mtxt += '<area shape="circle" coords="458,296,3" href="javascript:selectTSpoints(18013,458,296)">';
mtxt += '<area shape="circle" coords="463,296,3" href="javascript:selectTSpoints(18014,463,296)">';
mtxt += '<area shape="circle" coords="468,296,3" href="javascript:selectTSpoints(18015,468,296)">';
mtxt += '<area shape="circle" coords="473,296,3" href="javascript:selectTSpoints(18016,473,296)">';
mtxt += '<area shape="circle" coords="478,296,3" href="javascript:selectTSpoints(18017,478,296)">';
mtxt += '<area shape="circle" coords="483,296,3" href="javascript:selectTSpoints(18018,483,296)">';
mtxt += '<area shape="circle" coords="488,296,3" href="javascript:selectTSpoints(18019,488,296)">';
mtxt += '<area shape="circle" coords="493,296,3" href="javascript:selectTSpoints(18020,493,296)">';
mtxt += '<area shape="circle" coords="498,296,3" href="javascript:selectTSpoints(18021,498,296)">';
mtxt += '<area shape="circle" coords="503,296,3" href="javascript:selectTSpoints(18022,503,296)">';
mtxt += '<area shape="circle" coords="509,296,3" href="javascript:selectTSpoints(18023,509,296)">';
mtxt += '<area shape="circle" coords="514,296,3" href="javascript:selectTSpoints(18024,514,296)">';
mtxt += '<area shape="circle" coords="519,296,3" href="javascript:selectTSpoints(18025,519,296)">';
mtxt += '<area shape="circle" coords="524,296,3" href="javascript:selectTSpoints(18026,524,296)">';
mtxt += '<area shape="circle" coords="529,296,3" href="javascript:selectTSpoints(18027,529,296)">';
mtxt += '<area shape="circle" coords="534,296,3" href="javascript:selectTSpoints(18028,534,296)">';
mtxt += '<area shape="circle" coords="539,296,3" href="javascript:selectTSpoints(18029,539,296)">';
mtxt += '<area shape="circle" coords="544,296,3" href="javascript:selectTSpoints(18030,544,296)">';
mtxt += '<area shape="circle" coords="549,296,3" href="javascript:selectTSpoints(18031,549,296)">';
mtxt += '<area shape="circle" coords="554,296,3" href="javascript:selectTSpoints(18032,554,296)">';
mtxt += '<area shape="circle" coords="559,296,3" href="javascript:selectTSpoints(18033,559,296)">';
mtxt += '<area shape="circle" coords="565,296,3" href="javascript:selectTSpoints(18034,565,296)">';
mtxt += '<area shape="circle" coords="570,296,3" href="javascript:selectTSpoints(18035,570,296)">';
mtxt += '<area shape="circle" coords="575,296,3" href="javascript:selectTSpoints(18036,575,296)">';
mtxt += '<area shape="circle" coords="580,296,3" href="javascript:selectTSpoints(18037,580,296)">';
mtxt += '<area shape="circle" coords="585,296,3" href="javascript:selectTSpoints(18038,585,296)">';
mtxt += '<area shape="circle" coords="590,296,3" href="javascript:selectTSpoints(18039,590,296)">';
mtxt += '<area shape="circle" coords="595,296,3" href="javascript:selectTSpoints(18040,595,296)">';
mtxt += '<area shape="circle" coords="600,296,3" href="javascript:selectTSpoints(18041,600,296)">';
mtxt += '<area shape="circle" coords="605,296,3" href="javascript:selectTSpoints(18042,605,296)">';
mtxt += '<area shape="circle" coords="610,296,3" href="javascript:selectTSpoints(18043,610,296)">';
mtxt += '<area shape="circle" coords="615,296,3" href="javascript:selectTSpoints(18044,615,296)">';
mtxt += '<area shape="circle" coords="621,296,3" href="javascript:selectTSpoints(18045,621,296)">';
mtxt += '<area shape="circle" coords="626,296,3" href="javascript:selectTSpoints(18046,626,296)">';
mtxt += '<area shape="circle" coords="631,296,3" href="javascript:selectTSpoints(18047,631,296)">';
mtxt += '<area shape="circle" coords="636,296,3" href="javascript:selectTSpoints(18048,636,296)">';
mtxt += '<area shape="circle" coords="641,296,3" href="javascript:selectTSpoints(18049,641,296)">';
mtxt += '<area shape="circle" coords="646,296,3" href="javascript:selectTSpoints(18050,646,296)">';
mtxt += '<area shape="circle" coords="651,296,3" href="javascript:selectTSpoints(18051,651,296)">';
mtxt += '<area shape="circle" coords="656,296,3" href="javascript:selectTSpoints(18052,656,296)">';
mtxt += '<area shape="circle" coords="661,296,3" href="javascript:selectTSpoints(18053,661,296)">';
mtxt += '<area shape="circle" coords="666,296,3" href="javascript:selectTSpoints(18054,666,296)">';
mtxt += '<area shape="circle" coords="671,296,3" href="javascript:selectTSpoints(18055,671,296)">';
mtxt += '<area shape="circle" coords="677,296,3" href="javascript:selectTSpoints(18056,677,296)">';
mtxt += '<area shape="circle" coords="682,296,3" href="javascript:selectTSpoints(18057,682,296)">';
mtxt += '<area shape="circle" coords="687,296,3" href="javascript:selectTSpoints(18058,687,296)">';
mtxt += '<area shape="circle" coords="692,296,3" href="javascript:selectTSpoints(18059,692,296)">';
mtxt += '<area shape="circle" coords="697,296,3" href="javascript:selectTSpoints(18060,697,296)">';
mtxt += '<area shape="circle" coords="702,296,3" href="javascript:selectTSpoints(18061,702,296)">';
mtxt += '<area shape="circle" coords="707,296,3" href="javascript:selectTSpoints(18062,707,296)">';
mtxt += '<area shape="circle" coords="712,296,3" href="javascript:selectTSpoints(18063,712,296)">';
mtxt += '<area shape="circle" coords="717,296,3" href="javascript:selectTSpoints(18064,717,296)">';
mtxt += '<area shape="circle" coords="722,296,3" href="javascript:selectTSpoints(18065,722,296)">';
mtxt += '<area shape="circle" coords="727,296,3" href="javascript:selectTSpoints(18066,727,296)">';
mtxt += '<area shape="circle" coords="733,296,3" href="javascript:selectTSpoints(18067,733,296)">';
mtxt += '<area shape="circle" coords="738,296,3" href="javascript:selectTSpoints(18068,738,296)">';
mtxt += '<area shape="circle" coords="743,296,3" href="javascript:selectTSpoints(18069,743,296)">';
mtxt += '<area shape="circle" coords="748,296,3" href="javascript:selectTSpoints(18070,748,296)">';
mtxt += '<area shape="circle" coords="753,296,3" href="javascript:selectTSpoints(18071,753,296)">';
mtxt += '<area shape="circle" coords="758,296,3" href="javascript:selectTSpoints(18072,758,296)">';
mtxt += '<area shape="circle" coords=" 30,291,3" href="javascript:selectTSpoints(19073, 30,291)">';
mtxt += '<area shape="circle" coords=" 35,291,3" href="javascript:selectTSpoints(19074, 35,291)">';
mtxt += '<area shape="circle" coords=" 40,291,3" href="javascript:selectTSpoints(19075, 40,291)">';
mtxt += '<area shape="circle" coords=" 45,291,3" href="javascript:selectTSpoints(19076, 45,291)">';
mtxt += '<area shape="circle" coords=" 50,291,3" href="javascript:selectTSpoints(19077, 50,291)">';
mtxt += '<area shape="circle" coords=" 56,291,3" href="javascript:selectTSpoints(19078, 56,291)">';
mtxt += '<area shape="circle" coords=" 61,291,3" href="javascript:selectTSpoints(19079, 61,291)">';
mtxt += '<area shape="circle" coords=" 66,291,3" href="javascript:selectTSpoints(19080, 66,291)">';
mtxt += '<area shape="circle" coords=" 71,291,3" href="javascript:selectTSpoints(19081, 71,291)">';
mtxt += '<area shape="circle" coords=" 76,291,3" href="javascript:selectTSpoints(19082, 76,291)">';
mtxt += '<area shape="circle" coords=" 81,291,3" href="javascript:selectTSpoints(19083, 81,291)">';
mtxt += '<area shape="circle" coords=" 86,291,3" href="javascript:selectTSpoints(19084, 86,291)">';
mtxt += '<area shape="circle" coords=" 91,291,3" href="javascript:selectTSpoints(19085, 91,291)">';
mtxt += '<area shape="circle" coords=" 96,291,3" href="javascript:selectTSpoints(19086, 96,291)">';
mtxt += '<area shape="circle" coords="101,291,3" href="javascript:selectTSpoints(19087,101,291)">';
mtxt += '<area shape="circle" coords="106,291,3" href="javascript:selectTSpoints(19088,106,291)">';
mtxt += '<area shape="circle" coords="112,291,3" href="javascript:selectTSpoints(19089,112,291)">';
mtxt += '<area shape="circle" coords="117,291,3" href="javascript:selectTSpoints(19090,117,291)">';
mtxt += '<area shape="circle" coords="122,291,3" href="javascript:selectTSpoints(19091,122,291)">';
mtxt += '<area shape="circle" coords="127,291,3" href="javascript:selectTSpoints(19092,127,291)">';
mtxt += '<area shape="circle" coords="132,291,3" href="javascript:selectTSpoints(19093,132,291)">';
mtxt += '<area shape="circle" coords="137,291,3" href="javascript:selectTSpoints(19094,137,291)">';
mtxt += '<area shape="circle" coords="142,291,3" href="javascript:selectTSpoints(19095,142,291)">';
mtxt += '<area shape="circle" coords="147,291,3" href="javascript:selectTSpoints(19096,147,291)">';
mtxt += '<area shape="circle" coords="152,291,3" href="javascript:selectTSpoints(19097,152,291)">';
mtxt += '<area shape="circle" coords="157,291,3" href="javascript:selectTSpoints(19098,157,291)">';
mtxt += '<area shape="circle" coords="162,291,3" href="javascript:selectTSpoints(19099,162,291)">';
mtxt += '<area shape="circle" coords="168,291,3" href="javascript:selectTSpoints(19100,168,291)">';
mtxt += '<area shape="circle" coords="173,291,3" href="javascript:selectTSpoints(19101,173,291)">';
mtxt += '<area shape="circle" coords="178,291,3" href="javascript:selectTSpoints(19102,178,291)">';
mtxt += '<area shape="circle" coords="183,291,3" href="javascript:selectTSpoints(19103,183,291)">';
mtxt += '<area shape="circle" coords="188,291,3" href="javascript:selectTSpoints(19104,188,291)">';
mtxt += '<area shape="circle" coords="193,291,3" href="javascript:selectTSpoints(19105,193,291)">';
mtxt += '<area shape="circle" coords="198,291,3" href="javascript:selectTSpoints(19106,198,291)">';
mtxt += '<area shape="circle" coords="203,291,3" href="javascript:selectTSpoints(19107,203,291)">';
mtxt += '<area shape="circle" coords="208,291,3" href="javascript:selectTSpoints(19108,208,291)">';
mtxt += '<area shape="circle" coords="213,291,3" href="javascript:selectTSpoints(19109,213,291)">';
mtxt += '<area shape="circle" coords="218,291,3" href="javascript:selectTSpoints(19110,218,291)">';
mtxt += '<area shape="circle" coords="224,291,3" href="javascript:selectTSpoints(19111,224,291)">';
mtxt += '<area shape="circle" coords="229,291,3" href="javascript:selectTSpoints(19112,229,291)">';
mtxt += '<area shape="circle" coords="234,291,3" href="javascript:selectTSpoints(19113,234,291)">';
mtxt += '<area shape="circle" coords="239,291,3" href="javascript:selectTSpoints(19114,239,291)">';
mtxt += '<area shape="circle" coords="244,291,3" href="javascript:selectTSpoints(19115,244,291)">';
mtxt += '<area shape="circle" coords="249,291,3" href="javascript:selectTSpoints(19116,249,291)">';
mtxt += '<area shape="circle" coords="254,291,3" href="javascript:selectTSpoints(19117,254,291)">';
mtxt += '<area shape="circle" coords="259,291,3" href="javascript:selectTSpoints(19118,259,291)">';
mtxt += '<area shape="circle" coords="264,291,3" href="javascript:selectTSpoints(19119,264,291)">';
mtxt += '<area shape="circle" coords="269,291,3" href="javascript:selectTSpoints(19120,269,291)">';
mtxt += '<area shape="circle" coords="274,291,3" href="javascript:selectTSpoints(19121,274,291)">';
mtxt += '<area shape="circle" coords="280,291,3" href="javascript:selectTSpoints(19122,280,291)">';
mtxt += '<area shape="circle" coords="285,291,3" href="javascript:selectTSpoints(19123,285,291)">';
mtxt += '<area shape="circle" coords="290,291,3" href="javascript:selectTSpoints(19124,290,291)">';
mtxt += '<area shape="circle" coords="295,291,3" href="javascript:selectTSpoints(19125,295,291)">';
mtxt += '<area shape="circle" coords="300,291,3" href="javascript:selectTSpoints(19126,300,291)">';
mtxt += '<area shape="circle" coords="305,291,3" href="javascript:selectTSpoints(19127,305,291)">';
mtxt += '<area shape="circle" coords="310,291,3" href="javascript:selectTSpoints(19128,310,291)">';
mtxt += '<area shape="circle" coords="315,291,3" href="javascript:selectTSpoints(19129,315,291)">';
mtxt += '<area shape="circle" coords="320,291,3" href="javascript:selectTSpoints(19130,320,291)">';
mtxt += '<area shape="circle" coords="325,291,3" href="javascript:selectTSpoints(19131,325,291)">';
mtxt += '<area shape="circle" coords="330,291,3" href="javascript:selectTSpoints(19132,330,291)">';
mtxt += '<area shape="circle" coords="336,291,3" href="javascript:selectTSpoints(19133,336,291)">';
mtxt += '<area shape="circle" coords="341,291,3" href="javascript:selectTSpoints(19134,341,291)">';
mtxt += '<area shape="circle" coords="346,291,3" href="javascript:selectTSpoints(19135,346,291)">';
mtxt += '<area shape="circle" coords="351,291,3" href="javascript:selectTSpoints(19136,351,291)">';
mtxt += '<area shape="circle" coords="356,291,3" href="javascript:selectTSpoints(19137,356,291)">';
mtxt += '<area shape="circle" coords="361,291,3" href="javascript:selectTSpoints(19138,361,291)">';
mtxt += '<area shape="circle" coords="366,291,3" href="javascript:selectTSpoints(19139,366,291)">';
mtxt += '<area shape="circle" coords="371,291,3" href="javascript:selectTSpoints(19140,371,291)">';
mtxt += '<area shape="circle" coords="376,291,3" href="javascript:selectTSpoints(19141,376,291)">';
mtxt += '<area shape="circle" coords="381,291,3" href="javascript:selectTSpoints(19142,381,291)">';
mtxt += '<area shape="circle" coords="386,291,3" href="javascript:selectTSpoints(19143,386,291)">';
mtxt += '<area shape="circle" coords="392,291,3" href="javascript:selectTSpoints(19144,392,291)">';
mtxt += '<area shape="circle" coords="397,291,3" href="javascript:selectTSpoints(19001,397,291)">';
mtxt += '<area shape="circle" coords="402,291,3" href="javascript:selectTSpoints(19002,402,291)">';
mtxt += '<area shape="circle" coords="407,291,3" href="javascript:selectTSpoints(19003,407,291)">';
mtxt += '<area shape="circle" coords="412,291,3" href="javascript:selectTSpoints(19004,412,291)">';
mtxt += '<area shape="circle" coords="417,291,3" href="javascript:selectTSpoints(19005,417,291)">';
mtxt += '<area shape="circle" coords="422,291,3" href="javascript:selectTSpoints(19006,422,291)">';
mtxt += '<area shape="circle" coords="427,291,3" href="javascript:selectTSpoints(19007,427,291)">';
mtxt += '<area shape="circle" coords="432,291,3" href="javascript:selectTSpoints(19008,432,291)">';
mtxt += '<area shape="circle" coords="437,291,3" href="javascript:selectTSpoints(19009,437,291)">';
mtxt += '<area shape="circle" coords="442,291,3" href="javascript:selectTSpoints(19010,442,291)">';
mtxt += '<area shape="circle" coords="447,291,3" href="javascript:selectTSpoints(19011,447,291)">';
mtxt += '<area shape="circle" coords="453,291,3" href="javascript:selectTSpoints(19012,453,291)">';
mtxt += '<area shape="circle" coords="458,291,3" href="javascript:selectTSpoints(19013,458,291)">';
mtxt += '<area shape="circle" coords="463,291,3" href="javascript:selectTSpoints(19014,463,291)">';
mtxt += '<area shape="circle" coords="468,291,3" href="javascript:selectTSpoints(19015,468,291)">';
mtxt += '<area shape="circle" coords="473,291,3" href="javascript:selectTSpoints(19016,473,291)">';
mtxt += '<area shape="circle" coords="478,291,3" href="javascript:selectTSpoints(19017,478,291)">';
mtxt += '<area shape="circle" coords="483,291,3" href="javascript:selectTSpoints(19018,483,291)">';
mtxt += '<area shape="circle" coords="488,291,3" href="javascript:selectTSpoints(19019,488,291)">';
mtxt += '<area shape="circle" coords="493,291,3" href="javascript:selectTSpoints(19020,493,291)">';
mtxt += '<area shape="circle" coords="498,291,3" href="javascript:selectTSpoints(19021,498,291)">';
mtxt += '<area shape="circle" coords="503,291,3" href="javascript:selectTSpoints(19022,503,291)">';
mtxt += '<area shape="circle" coords="509,291,3" href="javascript:selectTSpoints(19023,509,291)">';
mtxt += '<area shape="circle" coords="514,291,3" href="javascript:selectTSpoints(19024,514,291)">';
mtxt += '<area shape="circle" coords="519,291,3" href="javascript:selectTSpoints(19025,519,291)">';
mtxt += '<area shape="circle" coords="524,291,3" href="javascript:selectTSpoints(19026,524,291)">';
mtxt += '<area shape="circle" coords="529,291,3" href="javascript:selectTSpoints(19027,529,291)">';
mtxt += '<area shape="circle" coords="534,291,3" href="javascript:selectTSpoints(19028,534,291)">';
mtxt += '<area shape="circle" coords="539,291,3" href="javascript:selectTSpoints(19029,539,291)">';
mtxt += '<area shape="circle" coords="544,291,3" href="javascript:selectTSpoints(19030,544,291)">';
mtxt += '<area shape="circle" coords="549,291,3" href="javascript:selectTSpoints(19031,549,291)">';
mtxt += '<area shape="circle" coords="554,291,3" href="javascript:selectTSpoints(19032,554,291)">';
mtxt += '<area shape="circle" coords="559,291,3" href="javascript:selectTSpoints(19033,559,291)">';
mtxt += '<area shape="circle" coords="565,291,3" href="javascript:selectTSpoints(19034,565,291)">';
mtxt += '<area shape="circle" coords="570,291,3" href="javascript:selectTSpoints(19035,570,291)">';
mtxt += '<area shape="circle" coords="575,291,3" href="javascript:selectTSpoints(19036,575,291)">';
mtxt += '<area shape="circle" coords="580,291,3" href="javascript:selectTSpoints(19037,580,291)">';
mtxt += '<area shape="circle" coords="585,291,3" href="javascript:selectTSpoints(19038,585,291)">';
mtxt += '<area shape="circle" coords="590,291,3" href="javascript:selectTSpoints(19039,590,291)">';
mtxt += '<area shape="circle" coords="595,291,3" href="javascript:selectTSpoints(19040,595,291)">';
mtxt += '<area shape="circle" coords="600,291,3" href="javascript:selectTSpoints(19041,600,291)">';
mtxt += '<area shape="circle" coords="605,291,3" href="javascript:selectTSpoints(19042,605,291)">';
mtxt += '<area shape="circle" coords="610,291,3" href="javascript:selectTSpoints(19043,610,291)">';
mtxt += '<area shape="circle" coords="615,291,3" href="javascript:selectTSpoints(19044,615,291)">';
mtxt += '<area shape="circle" coords="621,291,3" href="javascript:selectTSpoints(19045,621,291)">';
mtxt += '<area shape="circle" coords="626,291,3" href="javascript:selectTSpoints(19046,626,291)">';
mtxt += '<area shape="circle" coords="631,291,3" href="javascript:selectTSpoints(19047,631,291)">';
mtxt += '<area shape="circle" coords="636,291,3" href="javascript:selectTSpoints(19048,636,291)">';
mtxt += '<area shape="circle" coords="641,291,3" href="javascript:selectTSpoints(19049,641,291)">';
mtxt += '<area shape="circle" coords="646,291,3" href="javascript:selectTSpoints(19050,646,291)">';
mtxt += '<area shape="circle" coords="651,291,3" href="javascript:selectTSpoints(19051,651,291)">';
mtxt += '<area shape="circle" coords="656,291,3" href="javascript:selectTSpoints(19052,656,291)">';
mtxt += '<area shape="circle" coords="661,291,3" href="javascript:selectTSpoints(19053,661,291)">';
mtxt += '<area shape="circle" coords="666,291,3" href="javascript:selectTSpoints(19054,666,291)">';
mtxt += '<area shape="circle" coords="671,291,3" href="javascript:selectTSpoints(19055,671,291)">';
mtxt += '<area shape="circle" coords="677,291,3" href="javascript:selectTSpoints(19056,677,291)">';
mtxt += '<area shape="circle" coords="682,291,3" href="javascript:selectTSpoints(19057,682,291)">';
mtxt += '<area shape="circle" coords="687,291,3" href="javascript:selectTSpoints(19058,687,291)">';
mtxt += '<area shape="circle" coords="692,291,3" href="javascript:selectTSpoints(19059,692,291)">';
mtxt += '<area shape="circle" coords="697,291,3" href="javascript:selectTSpoints(19060,697,291)">';
mtxt += '<area shape="circle" coords="702,291,3" href="javascript:selectTSpoints(19061,702,291)">';
mtxt += '<area shape="circle" coords="707,291,3" href="javascript:selectTSpoints(19062,707,291)">';
mtxt += '<area shape="circle" coords="712,291,3" href="javascript:selectTSpoints(19063,712,291)">';
mtxt += '<area shape="circle" coords="717,291,3" href="javascript:selectTSpoints(19064,717,291)">';
mtxt += '<area shape="circle" coords="722,291,3" href="javascript:selectTSpoints(19065,722,291)">';
mtxt += '<area shape="circle" coords="727,291,3" href="javascript:selectTSpoints(19066,727,291)">';
mtxt += '<area shape="circle" coords="733,291,3" href="javascript:selectTSpoints(19067,733,291)">';
mtxt += '<area shape="circle" coords="738,291,3" href="javascript:selectTSpoints(19068,738,291)">';
mtxt += '<area shape="circle" coords="743,291,3" href="javascript:selectTSpoints(19069,743,291)">';
mtxt += '<area shape="circle" coords="748,291,3" href="javascript:selectTSpoints(19070,748,291)">';
mtxt += '<area shape="circle" coords="753,291,3" href="javascript:selectTSpoints(19071,753,291)">';
mtxt += '<area shape="circle" coords="758,291,3" href="javascript:selectTSpoints(19072,758,291)">';
mtxt += '<area shape="circle" coords=" 30,286,3" href="javascript:selectTSpoints(20073, 30,286)">';
mtxt += '<area shape="circle" coords=" 35,286,3" href="javascript:selectTSpoints(20074, 35,286)">';
mtxt += '<area shape="circle" coords=" 40,286,3" href="javascript:selectTSpoints(20075, 40,286)">';
mtxt += '<area shape="circle" coords=" 45,286,3" href="javascript:selectTSpoints(20076, 45,286)">';
mtxt += '<area shape="circle" coords=" 50,286,3" href="javascript:selectTSpoints(20077, 50,286)">';
mtxt += '<area shape="circle" coords=" 56,286,3" href="javascript:selectTSpoints(20078, 56,286)">';
mtxt += '<area shape="circle" coords=" 61,286,3" href="javascript:selectTSpoints(20079, 61,286)">';
mtxt += '<area shape="circle" coords=" 66,286,3" href="javascript:selectTSpoints(20080, 66,286)">';
mtxt += '<area shape="circle" coords=" 71,286,3" href="javascript:selectTSpoints(20081, 71,286)">';
mtxt += '<area shape="circle" coords=" 76,286,3" href="javascript:selectTSpoints(20082, 76,286)">';
mtxt += '<area shape="circle" coords=" 81,286,3" href="javascript:selectTSpoints(20083, 81,286)">';
mtxt += '<area shape="circle" coords=" 86,286,3" href="javascript:selectTSpoints(20084, 86,286)">';
mtxt += '<area shape="circle" coords=" 91,286,3" href="javascript:selectTSpoints(20085, 91,286)">';
mtxt += '<area shape="circle" coords=" 96,286,3" href="javascript:selectTSpoints(20086, 96,286)">';
mtxt += '<area shape="circle" coords="101,286,3" href="javascript:selectTSpoints(20087,101,286)">';
mtxt += '<area shape="circle" coords="106,286,3" href="javascript:selectTSpoints(20088,106,286)">';
mtxt += '<area shape="circle" coords="112,286,3" href="javascript:selectTSpoints(20089,112,286)">';
mtxt += '<area shape="circle" coords="117,286,3" href="javascript:selectTSpoints(20090,117,286)">';
mtxt += '<area shape="circle" coords="122,286,3" href="javascript:selectTSpoints(20091,122,286)">';
mtxt += '<area shape="circle" coords="127,286,3" href="javascript:selectTSpoints(20092,127,286)">';
mtxt += '<area shape="circle" coords="132,286,3" href="javascript:selectTSpoints(20093,132,286)">';
mtxt += '<area shape="circle" coords="137,286,3" href="javascript:selectTSpoints(20094,137,286)">';
mtxt += '<area shape="circle" coords="142,286,3" href="javascript:selectTSpoints(20095,142,286)">';
mtxt += '<area shape="circle" coords="147,286,3" href="javascript:selectTSpoints(20096,147,286)">';
mtxt += '<area shape="circle" coords="152,286,3" href="javascript:selectTSpoints(20097,152,286)">';
mtxt += '<area shape="circle" coords="157,286,3" href="javascript:selectTSpoints(20098,157,286)">';
mtxt += '<area shape="circle" coords="162,286,3" href="javascript:selectTSpoints(20099,162,286)">';
mtxt += '<area shape="circle" coords="168,286,3" href="javascript:selectTSpoints(20100,168,286)">';
mtxt += '<area shape="circle" coords="173,286,3" href="javascript:selectTSpoints(20101,173,286)">';
mtxt += '<area shape="circle" coords="178,286,3" href="javascript:selectTSpoints(20102,178,286)">';
mtxt += '<area shape="circle" coords="183,286,3" href="javascript:selectTSpoints(20103,183,286)">';
mtxt += '<area shape="circle" coords="188,286,3" href="javascript:selectTSpoints(20104,188,286)">';
mtxt += '<area shape="circle" coords="193,286,3" href="javascript:selectTSpoints(20105,193,286)">';
mtxt += '<area shape="circle" coords="198,286,3" href="javascript:selectTSpoints(20106,198,286)">';
mtxt += '<area shape="circle" coords="203,286,3" href="javascript:selectTSpoints(20107,203,286)">';
mtxt += '<area shape="circle" coords="208,286,3" href="javascript:selectTSpoints(20108,208,286)">';
mtxt += '<area shape="circle" coords="213,286,3" href="javascript:selectTSpoints(20109,213,286)">';
mtxt += '<area shape="circle" coords="218,286,3" href="javascript:selectTSpoints(20110,218,286)">';
mtxt += '<area shape="circle" coords="224,286,3" href="javascript:selectTSpoints(20111,224,286)">';
mtxt += '<area shape="circle" coords="229,286,3" href="javascript:selectTSpoints(20112,229,286)">';
mtxt += '<area shape="circle" coords="234,286,3" href="javascript:selectTSpoints(20113,234,286)">';
mtxt += '<area shape="circle" coords="239,286,3" href="javascript:selectTSpoints(20114,239,286)">';
mtxt += '<area shape="circle" coords="244,286,3" href="javascript:selectTSpoints(20115,244,286)">';
mtxt += '<area shape="circle" coords="249,286,3" href="javascript:selectTSpoints(20116,249,286)">';
mtxt += '<area shape="circle" coords="254,286,3" href="javascript:selectTSpoints(20117,254,286)">';
mtxt += '<area shape="circle" coords="259,286,3" href="javascript:selectTSpoints(20118,259,286)">';
mtxt += '<area shape="circle" coords="264,286,3" href="javascript:selectTSpoints(20119,264,286)">';
mtxt += '<area shape="circle" coords="269,286,3" href="javascript:selectTSpoints(20120,269,286)">';
mtxt += '<area shape="circle" coords="274,286,3" href="javascript:selectTSpoints(20121,274,286)">';
mtxt += '<area shape="circle" coords="280,286,3" href="javascript:selectTSpoints(20122,280,286)">';
mtxt += '<area shape="circle" coords="285,286,3" href="javascript:selectTSpoints(20123,285,286)">';
mtxt += '<area shape="circle" coords="290,286,3" href="javascript:selectTSpoints(20124,290,286)">';
mtxt += '<area shape="circle" coords="295,286,3" href="javascript:selectTSpoints(20125,295,286)">';
mtxt += '<area shape="circle" coords="300,286,3" href="javascript:selectTSpoints(20126,300,286)">';
mtxt += '<area shape="circle" coords="305,286,3" href="javascript:selectTSpoints(20127,305,286)">';
mtxt += '<area shape="circle" coords="310,286,3" href="javascript:selectTSpoints(20128,310,286)">';
mtxt += '<area shape="circle" coords="315,286,3" href="javascript:selectTSpoints(20129,315,286)">';
mtxt += '<area shape="circle" coords="320,286,3" href="javascript:selectTSpoints(20130,320,286)">';
mtxt += '<area shape="circle" coords="325,286,3" href="javascript:selectTSpoints(20131,325,286)">';
mtxt += '<area shape="circle" coords="330,286,3" href="javascript:selectTSpoints(20132,330,286)">';
mtxt += '<area shape="circle" coords="336,286,3" href="javascript:selectTSpoints(20133,336,286)">';
mtxt += '<area shape="circle" coords="341,286,3" href="javascript:selectTSpoints(20134,341,286)">';
mtxt += '<area shape="circle" coords="346,286,3" href="javascript:selectTSpoints(20135,346,286)">';
mtxt += '<area shape="circle" coords="351,286,3" href="javascript:selectTSpoints(20136,351,286)">';
mtxt += '<area shape="circle" coords="356,286,3" href="javascript:selectTSpoints(20137,356,286)">';
mtxt += '<area shape="circle" coords="361,286,3" href="javascript:selectTSpoints(20138,361,286)">';
mtxt += '<area shape="circle" coords="366,286,3" href="javascript:selectTSpoints(20139,366,286)">';
mtxt += '<area shape="circle" coords="371,286,3" href="javascript:selectTSpoints(20140,371,286)">';
mtxt += '<area shape="circle" coords="376,286,3" href="javascript:selectTSpoints(20141,376,286)">';
mtxt += '<area shape="circle" coords="381,286,3" href="javascript:selectTSpoints(20142,381,286)">';
mtxt += '<area shape="circle" coords="386,286,3" href="javascript:selectTSpoints(20143,386,286)">';
mtxt += '<area shape="circle" coords="392,286,3" href="javascript:selectTSpoints(20144,392,286)">';
mtxt += '<area shape="circle" coords="397,286,3" href="javascript:selectTSpoints(20001,397,286)">';
mtxt += '<area shape="circle" coords="402,286,3" href="javascript:selectTSpoints(20002,402,286)">';
mtxt += '<area shape="circle" coords="407,286,3" href="javascript:selectTSpoints(20003,407,286)">';
mtxt += '<area shape="circle" coords="412,286,3" href="javascript:selectTSpoints(20004,412,286)">';
mtxt += '<area shape="circle" coords="417,286,3" href="javascript:selectTSpoints(20005,417,286)">';
mtxt += '<area shape="circle" coords="422,286,3" href="javascript:selectTSpoints(20006,422,286)">';
mtxt += '<area shape="circle" coords="427,286,3" href="javascript:selectTSpoints(20007,427,286)">';
mtxt += '<area shape="circle" coords="432,286,3" href="javascript:selectTSpoints(20008,432,286)">';
mtxt += '<area shape="circle" coords="437,286,3" href="javascript:selectTSpoints(20009,437,286)">';
mtxt += '<area shape="circle" coords="442,286,3" href="javascript:selectTSpoints(20010,442,286)">';
mtxt += '<area shape="circle" coords="447,286,3" href="javascript:selectTSpoints(20011,447,286)">';
mtxt += '<area shape="circle" coords="453,286,3" href="javascript:selectTSpoints(20012,453,286)">';
mtxt += '<area shape="circle" coords="458,286,3" href="javascript:selectTSpoints(20013,458,286)">';
mtxt += '<area shape="circle" coords="463,286,3" href="javascript:selectTSpoints(20014,463,286)">';
mtxt += '<area shape="circle" coords="468,286,3" href="javascript:selectTSpoints(20015,468,286)">';
mtxt += '<area shape="circle" coords="473,286,3" href="javascript:selectTSpoints(20016,473,286)">';
mtxt += '<area shape="circle" coords="478,286,3" href="javascript:selectTSpoints(20017,478,286)">';
mtxt += '<area shape="circle" coords="483,286,3" href="javascript:selectTSpoints(20018,483,286)">';
mtxt += '<area shape="circle" coords="488,286,3" href="javascript:selectTSpoints(20019,488,286)">';
mtxt += '<area shape="circle" coords="493,286,3" href="javascript:selectTSpoints(20020,493,286)">';
mtxt += '<area shape="circle" coords="498,286,3" href="javascript:selectTSpoints(20021,498,286)">';
mtxt += '<area shape="circle" coords="503,286,3" href="javascript:selectTSpoints(20022,503,286)">';
mtxt += '<area shape="circle" coords="509,286,3" href="javascript:selectTSpoints(20023,509,286)">';
mtxt += '<area shape="circle" coords="514,286,3" href="javascript:selectTSpoints(20024,514,286)">';
mtxt += '<area shape="circle" coords="519,286,3" href="javascript:selectTSpoints(20025,519,286)">';
mtxt += '<area shape="circle" coords="524,286,3" href="javascript:selectTSpoints(20026,524,286)">';
mtxt += '<area shape="circle" coords="529,286,3" href="javascript:selectTSpoints(20027,529,286)">';
mtxt += '<area shape="circle" coords="534,286,3" href="javascript:selectTSpoints(20028,534,286)">';
mtxt += '<area shape="circle" coords="539,286,3" href="javascript:selectTSpoints(20029,539,286)">';
mtxt += '<area shape="circle" coords="544,286,3" href="javascript:selectTSpoints(20030,544,286)">';
mtxt += '<area shape="circle" coords="549,286,3" href="javascript:selectTSpoints(20031,549,286)">';
mtxt += '<area shape="circle" coords="554,286,3" href="javascript:selectTSpoints(20032,554,286)">';
mtxt += '<area shape="circle" coords="559,286,3" href="javascript:selectTSpoints(20033,559,286)">';
mtxt += '<area shape="circle" coords="565,286,3" href="javascript:selectTSpoints(20034,565,286)">';
mtxt += '<area shape="circle" coords="570,286,3" href="javascript:selectTSpoints(20035,570,286)">';
mtxt += '<area shape="circle" coords="575,286,3" href="javascript:selectTSpoints(20036,575,286)">';
mtxt += '<area shape="circle" coords="580,286,3" href="javascript:selectTSpoints(20037,580,286)">';
mtxt += '<area shape="circle" coords="585,286,3" href="javascript:selectTSpoints(20038,585,286)">';
mtxt += '<area shape="circle" coords="590,286,3" href="javascript:selectTSpoints(20039,590,286)">';
mtxt += '<area shape="circle" coords="595,286,3" href="javascript:selectTSpoints(20040,595,286)">';
mtxt += '<area shape="circle" coords="600,286,3" href="javascript:selectTSpoints(20041,600,286)">';
mtxt += '<area shape="circle" coords="605,286,3" href="javascript:selectTSpoints(20042,605,286)">';
mtxt += '<area shape="circle" coords="610,286,3" href="javascript:selectTSpoints(20043,610,286)">';
mtxt += '<area shape="circle" coords="615,286,3" href="javascript:selectTSpoints(20044,615,286)">';
mtxt += '<area shape="circle" coords="621,286,3" href="javascript:selectTSpoints(20045,621,286)">';
mtxt += '<area shape="circle" coords="626,286,3" href="javascript:selectTSpoints(20046,626,286)">';
mtxt += '<area shape="circle" coords="631,286,3" href="javascript:selectTSpoints(20047,631,286)">';
mtxt += '<area shape="circle" coords="636,286,3" href="javascript:selectTSpoints(20048,636,286)">';
mtxt += '<area shape="circle" coords="641,286,3" href="javascript:selectTSpoints(20049,641,286)">';
mtxt += '<area shape="circle" coords="646,286,3" href="javascript:selectTSpoints(20050,646,286)">';
mtxt += '<area shape="circle" coords="651,286,3" href="javascript:selectTSpoints(20051,651,286)">';
mtxt += '<area shape="circle" coords="656,286,3" href="javascript:selectTSpoints(20052,656,286)">';
mtxt += '<area shape="circle" coords="661,286,3" href="javascript:selectTSpoints(20053,661,286)">';
mtxt += '<area shape="circle" coords="666,286,3" href="javascript:selectTSpoints(20054,666,286)">';
mtxt += '<area shape="circle" coords="671,286,3" href="javascript:selectTSpoints(20055,671,286)">';
mtxt += '<area shape="circle" coords="677,286,3" href="javascript:selectTSpoints(20056,677,286)">';
mtxt += '<area shape="circle" coords="682,286,3" href="javascript:selectTSpoints(20057,682,286)">';
mtxt += '<area shape="circle" coords="687,286,3" href="javascript:selectTSpoints(20058,687,286)">';
mtxt += '<area shape="circle" coords="692,286,3" href="javascript:selectTSpoints(20059,692,286)">';
mtxt += '<area shape="circle" coords="697,286,3" href="javascript:selectTSpoints(20060,697,286)">';
mtxt += '<area shape="circle" coords="702,286,3" href="javascript:selectTSpoints(20061,702,286)">';
mtxt += '<area shape="circle" coords="707,286,3" href="javascript:selectTSpoints(20062,707,286)">';
mtxt += '<area shape="circle" coords="712,286,3" href="javascript:selectTSpoints(20063,712,286)">';
mtxt += '<area shape="circle" coords="717,286,3" href="javascript:selectTSpoints(20064,717,286)">';
mtxt += '<area shape="circle" coords="722,286,3" href="javascript:selectTSpoints(20065,722,286)">';
mtxt += '<area shape="circle" coords="727,286,3" href="javascript:selectTSpoints(20066,727,286)">';
mtxt += '<area shape="circle" coords="733,286,3" href="javascript:selectTSpoints(20067,733,286)">';
mtxt += '<area shape="circle" coords="738,286,3" href="javascript:selectTSpoints(20068,738,286)">';
mtxt += '<area shape="circle" coords="743,286,3" href="javascript:selectTSpoints(20069,743,286)">';
mtxt += '<area shape="circle" coords="748,286,3" href="javascript:selectTSpoints(20070,748,286)">';
mtxt += '<area shape="circle" coords="753,286,3" href="javascript:selectTSpoints(20071,753,286)">';
mtxt += '<area shape="circle" coords="758,286,3" href="javascript:selectTSpoints(20072,758,286)">';
mtxt += '<area shape="circle" coords=" 30,281,3" href="javascript:selectTSpoints(21073, 30,281)">';
mtxt += '<area shape="circle" coords=" 35,281,3" href="javascript:selectTSpoints(21074, 35,281)">';
mtxt += '<area shape="circle" coords=" 40,281,3" href="javascript:selectTSpoints(21075, 40,281)">';
mtxt += '<area shape="circle" coords=" 45,281,3" href="javascript:selectTSpoints(21076, 45,281)">';
mtxt += '<area shape="circle" coords=" 50,281,3" href="javascript:selectTSpoints(21077, 50,281)">';
mtxt += '<area shape="circle" coords=" 56,281,3" href="javascript:selectTSpoints(21078, 56,281)">';
mtxt += '<area shape="circle" coords=" 61,281,3" href="javascript:selectTSpoints(21079, 61,281)">';
mtxt += '<area shape="circle" coords=" 66,281,3" href="javascript:selectTSpoints(21080, 66,281)">';
mtxt += '<area shape="circle" coords=" 71,281,3" href="javascript:selectTSpoints(21081, 71,281)">';
mtxt += '<area shape="circle" coords=" 76,281,3" href="javascript:selectTSpoints(21082, 76,281)">';
mtxt += '<area shape="circle" coords=" 81,281,3" href="javascript:selectTSpoints(21083, 81,281)">';
mtxt += '<area shape="circle" coords=" 86,281,3" href="javascript:selectTSpoints(21084, 86,281)">';
mtxt += '<area shape="circle" coords=" 91,281,3" href="javascript:selectTSpoints(21085, 91,281)">';
mtxt += '<area shape="circle" coords=" 96,281,3" href="javascript:selectTSpoints(21086, 96,281)">';
mtxt += '<area shape="circle" coords="101,281,3" href="javascript:selectTSpoints(21087,101,281)">';
mtxt += '<area shape="circle" coords="106,281,3" href="javascript:selectTSpoints(21088,106,281)">';
mtxt += '<area shape="circle" coords="112,281,3" href="javascript:selectTSpoints(21089,112,281)">';
mtxt += '<area shape="circle" coords="117,281,3" href="javascript:selectTSpoints(21090,117,281)">';
mtxt += '<area shape="circle" coords="122,281,3" href="javascript:selectTSpoints(21091,122,281)">';
mtxt += '<area shape="circle" coords="127,281,3" href="javascript:selectTSpoints(21092,127,281)">';
mtxt += '<area shape="circle" coords="132,281,3" href="javascript:selectTSpoints(21093,132,281)">';
mtxt += '<area shape="circle" coords="137,281,3" href="javascript:selectTSpoints(21094,137,281)">';
mtxt += '<area shape="circle" coords="142,281,3" href="javascript:selectTSpoints(21095,142,281)">';
mtxt += '<area shape="circle" coords="147,281,3" href="javascript:selectTSpoints(21096,147,281)">';
mtxt += '<area shape="circle" coords="152,281,3" href="javascript:selectTSpoints(21097,152,281)">';
mtxt += '<area shape="circle" coords="157,281,3" href="javascript:selectTSpoints(21098,157,281)">';
mtxt += '<area shape="circle" coords="162,281,3" href="javascript:selectTSpoints(21099,162,281)">';
mtxt += '<area shape="circle" coords="168,281,3" href="javascript:selectTSpoints(21100,168,281)">';
mtxt += '<area shape="circle" coords="173,281,3" href="javascript:selectTSpoints(21101,173,281)">';
mtxt += '<area shape="circle" coords="178,281,3" href="javascript:selectTSpoints(21102,178,281)">';
mtxt += '<area shape="circle" coords="183,281,3" href="javascript:selectTSpoints(21103,183,281)">';
mtxt += '<area shape="circle" coords="188,281,3" href="javascript:selectTSpoints(21104,188,281)">';
mtxt += '<area shape="circle" coords="193,281,3" href="javascript:selectTSpoints(21105,193,281)">';
mtxt += '<area shape="circle" coords="198,281,3" href="javascript:selectTSpoints(21106,198,281)">';
mtxt += '<area shape="circle" coords="203,281,3" href="javascript:selectTSpoints(21107,203,281)">';
mtxt += '<area shape="circle" coords="208,281,3" href="javascript:selectTSpoints(21108,208,281)">';
mtxt += '<area shape="circle" coords="213,281,3" href="javascript:selectTSpoints(21109,213,281)">';
mtxt += '<area shape="circle" coords="218,281,3" href="javascript:selectTSpoints(21110,218,281)">';
mtxt += '<area shape="circle" coords="224,281,3" href="javascript:selectTSpoints(21111,224,281)">';
mtxt += '<area shape="circle" coords="229,281,3" href="javascript:selectTSpoints(21112,229,281)">';
mtxt += '<area shape="circle" coords="234,281,3" href="javascript:selectTSpoints(21113,234,281)">';
mtxt += '<area shape="circle" coords="239,281,3" href="javascript:selectTSpoints(21114,239,281)">';
mtxt += '<area shape="circle" coords="244,281,3" href="javascript:selectTSpoints(21115,244,281)">';
mtxt += '<area shape="circle" coords="249,281,3" href="javascript:selectTSpoints(21116,249,281)">';
mtxt += '<area shape="circle" coords="254,281,3" href="javascript:selectTSpoints(21117,254,281)">';
mtxt += '<area shape="circle" coords="259,281,3" href="javascript:selectTSpoints(21118,259,281)">';
mtxt += '<area shape="circle" coords="264,281,3" href="javascript:selectTSpoints(21119,264,281)">';
mtxt += '<area shape="circle" coords="269,281,3" href="javascript:selectTSpoints(21120,269,281)">';
mtxt += '<area shape="circle" coords="274,281,3" href="javascript:selectTSpoints(21121,274,281)">';
mtxt += '<area shape="circle" coords="280,281,3" href="javascript:selectTSpoints(21122,280,281)">';
mtxt += '<area shape="circle" coords="285,281,3" href="javascript:selectTSpoints(21123,285,281)">';
mtxt += '<area shape="circle" coords="290,281,3" href="javascript:selectTSpoints(21124,290,281)">';
mtxt += '<area shape="circle" coords="295,281,3" href="javascript:selectTSpoints(21125,295,281)">';
mtxt += '<area shape="circle" coords="300,281,3" href="javascript:selectTSpoints(21126,300,281)">';
mtxt += '<area shape="circle" coords="305,281,3" href="javascript:selectTSpoints(21127,305,281)">';
mtxt += '<area shape="circle" coords="310,281,3" href="javascript:selectTSpoints(21128,310,281)">';
mtxt += '<area shape="circle" coords="315,281,3" href="javascript:selectTSpoints(21129,315,281)">';
mtxt += '<area shape="circle" coords="320,281,3" href="javascript:selectTSpoints(21130,320,281)">';
mtxt += '<area shape="circle" coords="325,281,3" href="javascript:selectTSpoints(21131,325,281)">';
mtxt += '<area shape="circle" coords="330,281,3" href="javascript:selectTSpoints(21132,330,281)">';
mtxt += '<area shape="circle" coords="336,281,3" href="javascript:selectTSpoints(21133,336,281)">';
mtxt += '<area shape="circle" coords="341,281,3" href="javascript:selectTSpoints(21134,341,281)">';
mtxt += '<area shape="circle" coords="346,281,3" href="javascript:selectTSpoints(21135,346,281)">';
mtxt += '<area shape="circle" coords="351,281,3" href="javascript:selectTSpoints(21136,351,281)">';
mtxt += '<area shape="circle" coords="356,281,3" href="javascript:selectTSpoints(21137,356,281)">';
mtxt += '<area shape="circle" coords="361,281,3" href="javascript:selectTSpoints(21138,361,281)">';
mtxt += '<area shape="circle" coords="366,281,3" href="javascript:selectTSpoints(21139,366,281)">';
mtxt += '<area shape="circle" coords="371,281,3" href="javascript:selectTSpoints(21140,371,281)">';
mtxt += '<area shape="circle" coords="376,281,3" href="javascript:selectTSpoints(21141,376,281)">';
mtxt += '<area shape="circle" coords="381,281,3" href="javascript:selectTSpoints(21142,381,281)">';
mtxt += '<area shape="circle" coords="386,281,3" href="javascript:selectTSpoints(21143,386,281)">';
mtxt += '<area shape="circle" coords="392,281,3" href="javascript:selectTSpoints(21144,392,281)">';
mtxt += '<area shape="circle" coords="397,281,3" href="javascript:selectTSpoints(21001,397,281)">';
mtxt += '<area shape="circle" coords="402,281,3" href="javascript:selectTSpoints(21002,402,281)">';
mtxt += '<area shape="circle" coords="407,281,3" href="javascript:selectTSpoints(21003,407,281)">';
mtxt += '<area shape="circle" coords="412,281,3" href="javascript:selectTSpoints(21004,412,281)">';
mtxt += '<area shape="circle" coords="417,281,3" href="javascript:selectTSpoints(21005,417,281)">';
mtxt += '<area shape="circle" coords="422,281,3" href="javascript:selectTSpoints(21006,422,281)">';
mtxt += '<area shape="circle" coords="427,281,3" href="javascript:selectTSpoints(21007,427,281)">';
mtxt += '<area shape="circle" coords="432,281,3" href="javascript:selectTSpoints(21008,432,281)">';
mtxt += '<area shape="circle" coords="437,281,3" href="javascript:selectTSpoints(21009,437,281)">';
mtxt += '<area shape="circle" coords="442,281,3" href="javascript:selectTSpoints(21010,442,281)">';
mtxt += '<area shape="circle" coords="447,281,3" href="javascript:selectTSpoints(21011,447,281)">';
mtxt += '<area shape="circle" coords="453,281,3" href="javascript:selectTSpoints(21012,453,281)">';
mtxt += '<area shape="circle" coords="458,281,3" href="javascript:selectTSpoints(21013,458,281)">';
mtxt += '<area shape="circle" coords="463,281,3" href="javascript:selectTSpoints(21014,463,281)">';
mtxt += '<area shape="circle" coords="468,281,3" href="javascript:selectTSpoints(21015,468,281)">';
mtxt += '<area shape="circle" coords="473,281,3" href="javascript:selectTSpoints(21016,473,281)">';
mtxt += '<area shape="circle" coords="478,281,3" href="javascript:selectTSpoints(21017,478,281)">';
mtxt += '<area shape="circle" coords="483,281,3" href="javascript:selectTSpoints(21018,483,281)">';
mtxt += '<area shape="circle" coords="488,281,3" href="javascript:selectTSpoints(21019,488,281)">';
mtxt += '<area shape="circle" coords="493,281,3" href="javascript:selectTSpoints(21020,493,281)">';
mtxt += '<area shape="circle" coords="498,281,3" href="javascript:selectTSpoints(21021,498,281)">';
mtxt += '<area shape="circle" coords="503,281,3" href="javascript:selectTSpoints(21022,503,281)">';
mtxt += '<area shape="circle" coords="509,281,3" href="javascript:selectTSpoints(21023,509,281)">';
mtxt += '<area shape="circle" coords="514,281,3" href="javascript:selectTSpoints(21024,514,281)">';
mtxt += '<area shape="circle" coords="519,281,3" href="javascript:selectTSpoints(21025,519,281)">';
mtxt += '<area shape="circle" coords="524,281,3" href="javascript:selectTSpoints(21026,524,281)">';
mtxt += '<area shape="circle" coords="529,281,3" href="javascript:selectTSpoints(21027,529,281)">';
mtxt += '<area shape="circle" coords="534,281,3" href="javascript:selectTSpoints(21028,534,281)">';
mtxt += '<area shape="circle" coords="539,281,3" href="javascript:selectTSpoints(21029,539,281)">';
mtxt += '<area shape="circle" coords="544,281,3" href="javascript:selectTSpoints(21030,544,281)">';
mtxt += '<area shape="circle" coords="549,281,3" href="javascript:selectTSpoints(21031,549,281)">';
mtxt += '<area shape="circle" coords="554,281,3" href="javascript:selectTSpoints(21032,554,281)">';
mtxt += '<area shape="circle" coords="559,281,3" href="javascript:selectTSpoints(21033,559,281)">';
mtxt += '<area shape="circle" coords="565,281,3" href="javascript:selectTSpoints(21034,565,281)">';
mtxt += '<area shape="circle" coords="570,281,3" href="javascript:selectTSpoints(21035,570,281)">';
mtxt += '<area shape="circle" coords="575,281,3" href="javascript:selectTSpoints(21036,575,281)">';
mtxt += '<area shape="circle" coords="580,281,3" href="javascript:selectTSpoints(21037,580,281)">';
mtxt += '<area shape="circle" coords="585,281,3" href="javascript:selectTSpoints(21038,585,281)">';
mtxt += '<area shape="circle" coords="590,281,3" href="javascript:selectTSpoints(21039,590,281)">';
mtxt += '<area shape="circle" coords="595,281,3" href="javascript:selectTSpoints(21040,595,281)">';
mtxt += '<area shape="circle" coords="600,281,3" href="javascript:selectTSpoints(21041,600,281)">';
mtxt += '<area shape="circle" coords="605,281,3" href="javascript:selectTSpoints(21042,605,281)">';
mtxt += '<area shape="circle" coords="610,281,3" href="javascript:selectTSpoints(21043,610,281)">';
mtxt += '<area shape="circle" coords="615,281,3" href="javascript:selectTSpoints(21044,615,281)">';
mtxt += '<area shape="circle" coords="621,281,3" href="javascript:selectTSpoints(21045,621,281)">';
mtxt += '<area shape="circle" coords="626,281,3" href="javascript:selectTSpoints(21046,626,281)">';
mtxt += '<area shape="circle" coords="631,281,3" href="javascript:selectTSpoints(21047,631,281)">';
mtxt += '<area shape="circle" coords="636,281,3" href="javascript:selectTSpoints(21048,636,281)">';
mtxt += '<area shape="circle" coords="641,281,3" href="javascript:selectTSpoints(21049,641,281)">';
mtxt += '<area shape="circle" coords="646,281,3" href="javascript:selectTSpoints(21050,646,281)">';
mtxt += '<area shape="circle" coords="651,281,3" href="javascript:selectTSpoints(21051,651,281)">';
mtxt += '<area shape="circle" coords="656,281,3" href="javascript:selectTSpoints(21052,656,281)">';
mtxt += '<area shape="circle" coords="661,281,3" href="javascript:selectTSpoints(21053,661,281)">';
mtxt += '<area shape="circle" coords="666,281,3" href="javascript:selectTSpoints(21054,666,281)">';
mtxt += '<area shape="circle" coords="671,281,3" href="javascript:selectTSpoints(21055,671,281)">';
mtxt += '<area shape="circle" coords="677,281,3" href="javascript:selectTSpoints(21056,677,281)">';
mtxt += '<area shape="circle" coords="682,281,3" href="javascript:selectTSpoints(21057,682,281)">';
mtxt += '<area shape="circle" coords="687,281,3" href="javascript:selectTSpoints(21058,687,281)">';
mtxt += '<area shape="circle" coords="692,281,3" href="javascript:selectTSpoints(21059,692,281)">';
mtxt += '<area shape="circle" coords="697,281,3" href="javascript:selectTSpoints(21060,697,281)">';
mtxt += '<area shape="circle" coords="702,281,3" href="javascript:selectTSpoints(21061,702,281)">';
mtxt += '<area shape="circle" coords="707,281,3" href="javascript:selectTSpoints(21062,707,281)">';
mtxt += '<area shape="circle" coords="712,281,3" href="javascript:selectTSpoints(21063,712,281)">';
mtxt += '<area shape="circle" coords="717,281,3" href="javascript:selectTSpoints(21064,717,281)">';
mtxt += '<area shape="circle" coords="722,281,3" href="javascript:selectTSpoints(21065,722,281)">';
mtxt += '<area shape="circle" coords="727,281,3" href="javascript:selectTSpoints(21066,727,281)">';
mtxt += '<area shape="circle" coords="733,281,3" href="javascript:selectTSpoints(21067,733,281)">';
mtxt += '<area shape="circle" coords="738,281,3" href="javascript:selectTSpoints(21068,738,281)">';
mtxt += '<area shape="circle" coords="743,281,3" href="javascript:selectTSpoints(21069,743,281)">';
mtxt += '<area shape="circle" coords="748,281,3" href="javascript:selectTSpoints(21070,748,281)">';
mtxt += '<area shape="circle" coords="753,281,3" href="javascript:selectTSpoints(21071,753,281)">';
mtxt += '<area shape="circle" coords="758,281,3" href="javascript:selectTSpoints(21072,758,281)">';
mtxt += '<area shape="circle" coords=" 30,276,3" href="javascript:selectTSpoints(22073, 30,276)">';
mtxt += '<area shape="circle" coords=" 35,276,3" href="javascript:selectTSpoints(22074, 35,276)">';
mtxt += '<area shape="circle" coords=" 40,276,3" href="javascript:selectTSpoints(22075, 40,276)">';
mtxt += '<area shape="circle" coords=" 45,276,3" href="javascript:selectTSpoints(22076, 45,276)">';
mtxt += '<area shape="circle" coords=" 50,276,3" href="javascript:selectTSpoints(22077, 50,276)">';
mtxt += '<area shape="circle" coords=" 56,276,3" href="javascript:selectTSpoints(22078, 56,276)">';
mtxt += '<area shape="circle" coords=" 61,276,3" href="javascript:selectTSpoints(22079, 61,276)">';
mtxt += '<area shape="circle" coords=" 66,276,3" href="javascript:selectTSpoints(22080, 66,276)">';
mtxt += '<area shape="circle" coords=" 71,276,3" href="javascript:selectTSpoints(22081, 71,276)">';
mtxt += '<area shape="circle" coords=" 76,276,3" href="javascript:selectTSpoints(22082, 76,276)">';
mtxt += '<area shape="circle" coords=" 81,276,3" href="javascript:selectTSpoints(22083, 81,276)">';
mtxt += '<area shape="circle" coords=" 86,276,3" href="javascript:selectTSpoints(22084, 86,276)">';
mtxt += '<area shape="circle" coords=" 91,276,3" href="javascript:selectTSpoints(22085, 91,276)">';
mtxt += '<area shape="circle" coords=" 96,276,3" href="javascript:selectTSpoints(22086, 96,276)">';
mtxt += '<area shape="circle" coords="101,276,3" href="javascript:selectTSpoints(22087,101,276)">';
mtxt += '<area shape="circle" coords="106,276,3" href="javascript:selectTSpoints(22088,106,276)">';
mtxt += '<area shape="circle" coords="112,276,3" href="javascript:selectTSpoints(22089,112,276)">';
mtxt += '<area shape="circle" coords="117,276,3" href="javascript:selectTSpoints(22090,117,276)">';
mtxt += '<area shape="circle" coords="122,276,3" href="javascript:selectTSpoints(22091,122,276)">';
mtxt += '<area shape="circle" coords="127,276,3" href="javascript:selectTSpoints(22092,127,276)">';
mtxt += '<area shape="circle" coords="132,276,3" href="javascript:selectTSpoints(22093,132,276)">';
mtxt += '<area shape="circle" coords="137,276,3" href="javascript:selectTSpoints(22094,137,276)">';
mtxt += '<area shape="circle" coords="142,276,3" href="javascript:selectTSpoints(22095,142,276)">';
mtxt += '<area shape="circle" coords="147,276,3" href="javascript:selectTSpoints(22096,147,276)">';
mtxt += '<area shape="circle" coords="152,276,3" href="javascript:selectTSpoints(22097,152,276)">';
mtxt += '<area shape="circle" coords="157,276,3" href="javascript:selectTSpoints(22098,157,276)">';
mtxt += '<area shape="circle" coords="162,276,3" href="javascript:selectTSpoints(22099,162,276)">';
mtxt += '<area shape="circle" coords="168,276,3" href="javascript:selectTSpoints(22100,168,276)">';
mtxt += '<area shape="circle" coords="173,276,3" href="javascript:selectTSpoints(22101,173,276)">';
mtxt += '<area shape="circle" coords="178,276,3" href="javascript:selectTSpoints(22102,178,276)">';
mtxt += '<area shape="circle" coords="183,276,3" href="javascript:selectTSpoints(22103,183,276)">';
mtxt += '<area shape="circle" coords="188,276,3" href="javascript:selectTSpoints(22104,188,276)">';
mtxt += '<area shape="circle" coords="193,276,3" href="javascript:selectTSpoints(22105,193,276)">';
mtxt += '<area shape="circle" coords="198,276,3" href="javascript:selectTSpoints(22106,198,276)">';
mtxt += '<area shape="circle" coords="203,276,3" href="javascript:selectTSpoints(22107,203,276)">';
mtxt += '<area shape="circle" coords="208,276,3" href="javascript:selectTSpoints(22108,208,276)">';
mtxt += '<area shape="circle" coords="213,276,3" href="javascript:selectTSpoints(22109,213,276)">';
mtxt += '<area shape="circle" coords="218,276,3" href="javascript:selectTSpoints(22110,218,276)">';
mtxt += '<area shape="circle" coords="224,276,3" href="javascript:selectTSpoints(22111,224,276)">';
mtxt += '<area shape="circle" coords="229,276,3" href="javascript:selectTSpoints(22112,229,276)">';
mtxt += '<area shape="circle" coords="234,276,3" href="javascript:selectTSpoints(22113,234,276)">';
mtxt += '<area shape="circle" coords="239,276,3" href="javascript:selectTSpoints(22114,239,276)">';
mtxt += '<area shape="circle" coords="244,276,3" href="javascript:selectTSpoints(22115,244,276)">';
mtxt += '<area shape="circle" coords="249,276,3" href="javascript:selectTSpoints(22116,249,276)">';
mtxt += '<area shape="circle" coords="254,276,3" href="javascript:selectTSpoints(22117,254,276)">';
mtxt += '<area shape="circle" coords="259,276,3" href="javascript:selectTSpoints(22118,259,276)">';
mtxt += '<area shape="circle" coords="264,276,3" href="javascript:selectTSpoints(22119,264,276)">';
mtxt += '<area shape="circle" coords="269,276,3" href="javascript:selectTSpoints(22120,269,276)">';
mtxt += '<area shape="circle" coords="274,276,3" href="javascript:selectTSpoints(22121,274,276)">';
mtxt += '<area shape="circle" coords="280,276,3" href="javascript:selectTSpoints(22122,280,276)">';
mtxt += '<area shape="circle" coords="285,276,3" href="javascript:selectTSpoints(22123,285,276)">';
mtxt += '<area shape="circle" coords="290,276,3" href="javascript:selectTSpoints(22124,290,276)">';
mtxt += '<area shape="circle" coords="295,276,3" href="javascript:selectTSpoints(22125,295,276)">';
mtxt += '<area shape="circle" coords="300,276,3" href="javascript:selectTSpoints(22126,300,276)">';
mtxt += '<area shape="circle" coords="305,276,3" href="javascript:selectTSpoints(22127,305,276)">';
mtxt += '<area shape="circle" coords="310,276,3" href="javascript:selectTSpoints(22128,310,276)">';
mtxt += '<area shape="circle" coords="315,276,3" href="javascript:selectTSpoints(22129,315,276)">';
mtxt += '<area shape="circle" coords="320,276,3" href="javascript:selectTSpoints(22130,320,276)">';
mtxt += '<area shape="circle" coords="325,276,3" href="javascript:selectTSpoints(22131,325,276)">';
mtxt += '<area shape="circle" coords="330,276,3" href="javascript:selectTSpoints(22132,330,276)">';
mtxt += '<area shape="circle" coords="336,276,3" href="javascript:selectTSpoints(22133,336,276)">';
mtxt += '<area shape="circle" coords="341,276,3" href="javascript:selectTSpoints(22134,341,276)">';
mtxt += '<area shape="circle" coords="346,276,3" href="javascript:selectTSpoints(22135,346,276)">';
mtxt += '<area shape="circle" coords="351,276,3" href="javascript:selectTSpoints(22136,351,276)">';
mtxt += '<area shape="circle" coords="356,276,3" href="javascript:selectTSpoints(22137,356,276)">';
mtxt += '<area shape="circle" coords="361,276,3" href="javascript:selectTSpoints(22138,361,276)">';
mtxt += '<area shape="circle" coords="366,276,3" href="javascript:selectTSpoints(22139,366,276)">';
mtxt += '<area shape="circle" coords="371,276,3" href="javascript:selectTSpoints(22140,371,276)">';
mtxt += '<area shape="circle" coords="376,276,3" href="javascript:selectTSpoints(22141,376,276)">';
mtxt += '<area shape="circle" coords="381,276,3" href="javascript:selectTSpoints(22142,381,276)">';
mtxt += '<area shape="circle" coords="386,276,3" href="javascript:selectTSpoints(22143,386,276)">';
mtxt += '<area shape="circle" coords="392,276,3" href="javascript:selectTSpoints(22144,392,276)">';
mtxt += '<area shape="circle" coords="397,276,3" href="javascript:selectTSpoints(22001,397,276)">';
mtxt += '<area shape="circle" coords="402,276,3" href="javascript:selectTSpoints(22002,402,276)">';
mtxt += '<area shape="circle" coords="407,276,3" href="javascript:selectTSpoints(22003,407,276)">';
mtxt += '<area shape="circle" coords="412,276,3" href="javascript:selectTSpoints(22004,412,276)">';
mtxt += '<area shape="circle" coords="417,276,3" href="javascript:selectTSpoints(22005,417,276)">';
mtxt += '<area shape="circle" coords="422,276,3" href="javascript:selectTSpoints(22006,422,276)">';
mtxt += '<area shape="circle" coords="427,276,3" href="javascript:selectTSpoints(22007,427,276)">';
mtxt += '<area shape="circle" coords="432,276,3" href="javascript:selectTSpoints(22008,432,276)">';
mtxt += '<area shape="circle" coords="437,276,3" href="javascript:selectTSpoints(22009,437,276)">';
mtxt += '<area shape="circle" coords="442,276,3" href="javascript:selectTSpoints(22010,442,276)">';
mtxt += '<area shape="circle" coords="447,276,3" href="javascript:selectTSpoints(22011,447,276)">';
mtxt += '<area shape="circle" coords="453,276,3" href="javascript:selectTSpoints(22012,453,276)">';
mtxt += '<area shape="circle" coords="458,276,3" href="javascript:selectTSpoints(22013,458,276)">';
mtxt += '<area shape="circle" coords="463,276,3" href="javascript:selectTSpoints(22014,463,276)">';
mtxt += '<area shape="circle" coords="468,276,3" href="javascript:selectTSpoints(22015,468,276)">';
mtxt += '<area shape="circle" coords="473,276,3" href="javascript:selectTSpoints(22016,473,276)">';
mtxt += '<area shape="circle" coords="478,276,3" href="javascript:selectTSpoints(22017,478,276)">';
mtxt += '<area shape="circle" coords="483,276,3" href="javascript:selectTSpoints(22018,483,276)">';
mtxt += '<area shape="circle" coords="488,276,3" href="javascript:selectTSpoints(22019,488,276)">';
mtxt += '<area shape="circle" coords="493,276,3" href="javascript:selectTSpoints(22020,493,276)">';
mtxt += '<area shape="circle" coords="498,276,3" href="javascript:selectTSpoints(22021,498,276)">';
mtxt += '<area shape="circle" coords="503,276,3" href="javascript:selectTSpoints(22022,503,276)">';
mtxt += '<area shape="circle" coords="509,276,3" href="javascript:selectTSpoints(22023,509,276)">';
mtxt += '<area shape="circle" coords="514,276,3" href="javascript:selectTSpoints(22024,514,276)">';
mtxt += '<area shape="circle" coords="519,276,3" href="javascript:selectTSpoints(22025,519,276)">';
mtxt += '<area shape="circle" coords="524,276,3" href="javascript:selectTSpoints(22026,524,276)">';
mtxt += '<area shape="circle" coords="529,276,3" href="javascript:selectTSpoints(22027,529,276)">';
mtxt += '<area shape="circle" coords="534,276,3" href="javascript:selectTSpoints(22028,534,276)">';
mtxt += '<area shape="circle" coords="539,276,3" href="javascript:selectTSpoints(22029,539,276)">';
mtxt += '<area shape="circle" coords="544,276,3" href="javascript:selectTSpoints(22030,544,276)">';
mtxt += '<area shape="circle" coords="549,276,3" href="javascript:selectTSpoints(22031,549,276)">';
mtxt += '<area shape="circle" coords="554,276,3" href="javascript:selectTSpoints(22032,554,276)">';
mtxt += '<area shape="circle" coords="559,276,3" href="javascript:selectTSpoints(22033,559,276)">';
mtxt += '<area shape="circle" coords="565,276,3" href="javascript:selectTSpoints(22034,565,276)">';
mtxt += '<area shape="circle" coords="570,276,3" href="javascript:selectTSpoints(22035,570,276)">';
mtxt += '<area shape="circle" coords="575,276,3" href="javascript:selectTSpoints(22036,575,276)">';
mtxt += '<area shape="circle" coords="580,276,3" href="javascript:selectTSpoints(22037,580,276)">';
mtxt += '<area shape="circle" coords="585,276,3" href="javascript:selectTSpoints(22038,585,276)">';
mtxt += '<area shape="circle" coords="590,276,3" href="javascript:selectTSpoints(22039,590,276)">';
mtxt += '<area shape="circle" coords="595,276,3" href="javascript:selectTSpoints(22040,595,276)">';
mtxt += '<area shape="circle" coords="600,276,3" href="javascript:selectTSpoints(22041,600,276)">';
mtxt += '<area shape="circle" coords="605,276,3" href="javascript:selectTSpoints(22042,605,276)">';
mtxt += '<area shape="circle" coords="610,276,3" href="javascript:selectTSpoints(22043,610,276)">';
mtxt += '<area shape="circle" coords="615,276,3" href="javascript:selectTSpoints(22044,615,276)">';
mtxt += '<area shape="circle" coords="621,276,3" href="javascript:selectTSpoints(22045,621,276)">';
mtxt += '<area shape="circle" coords="626,276,3" href="javascript:selectTSpoints(22046,626,276)">';
mtxt += '<area shape="circle" coords="631,276,3" href="javascript:selectTSpoints(22047,631,276)">';
mtxt += '<area shape="circle" coords="636,276,3" href="javascript:selectTSpoints(22048,636,276)">';
mtxt += '<area shape="circle" coords="641,276,3" href="javascript:selectTSpoints(22049,641,276)">';
mtxt += '<area shape="circle" coords="646,276,3" href="javascript:selectTSpoints(22050,646,276)">';
mtxt += '<area shape="circle" coords="651,276,3" href="javascript:selectTSpoints(22051,651,276)">';
mtxt += '<area shape="circle" coords="656,276,3" href="javascript:selectTSpoints(22052,656,276)">';
mtxt += '<area shape="circle" coords="661,276,3" href="javascript:selectTSpoints(22053,661,276)">';
mtxt += '<area shape="circle" coords="666,276,3" href="javascript:selectTSpoints(22054,666,276)">';
mtxt += '<area shape="circle" coords="671,276,3" href="javascript:selectTSpoints(22055,671,276)">';
mtxt += '<area shape="circle" coords="677,276,3" href="javascript:selectTSpoints(22056,677,276)">';
mtxt += '<area shape="circle" coords="682,276,3" href="javascript:selectTSpoints(22057,682,276)">';
mtxt += '<area shape="circle" coords="687,276,3" href="javascript:selectTSpoints(22058,687,276)">';
mtxt += '<area shape="circle" coords="692,276,3" href="javascript:selectTSpoints(22059,692,276)">';
mtxt += '<area shape="circle" coords="697,276,3" href="javascript:selectTSpoints(22060,697,276)">';
mtxt += '<area shape="circle" coords="702,276,3" href="javascript:selectTSpoints(22061,702,276)">';
mtxt += '<area shape="circle" coords="707,276,3" href="javascript:selectTSpoints(22062,707,276)">';
mtxt += '<area shape="circle" coords="712,276,3" href="javascript:selectTSpoints(22063,712,276)">';
mtxt += '<area shape="circle" coords="717,276,3" href="javascript:selectTSpoints(22064,717,276)">';
mtxt += '<area shape="circle" coords="722,276,3" href="javascript:selectTSpoints(22065,722,276)">';
mtxt += '<area shape="circle" coords="727,276,3" href="javascript:selectTSpoints(22066,727,276)">';
mtxt += '<area shape="circle" coords="733,276,3" href="javascript:selectTSpoints(22067,733,276)">';
mtxt += '<area shape="circle" coords="738,276,3" href="javascript:selectTSpoints(22068,738,276)">';
mtxt += '<area shape="circle" coords="743,276,3" href="javascript:selectTSpoints(22069,743,276)">';
mtxt += '<area shape="circle" coords="748,276,3" href="javascript:selectTSpoints(22070,748,276)">';
mtxt += '<area shape="circle" coords="753,276,3" href="javascript:selectTSpoints(22071,753,276)">';
mtxt += '<area shape="circle" coords="758,276,3" href="javascript:selectTSpoints(22072,758,276)">';
mtxt += '<area shape="circle" coords=" 30,271,3" href="javascript:selectTSpoints(23073, 30,271)">';
mtxt += '<area shape="circle" coords=" 35,271,3" href="javascript:selectTSpoints(23074, 35,271)">';
mtxt += '<area shape="circle" coords=" 40,271,3" href="javascript:selectTSpoints(23075, 40,271)">';
mtxt += '<area shape="circle" coords=" 45,271,3" href="javascript:selectTSpoints(23076, 45,271)">';
mtxt += '<area shape="circle" coords=" 50,271,3" href="javascript:selectTSpoints(23077, 50,271)">';
mtxt += '<area shape="circle" coords=" 56,271,3" href="javascript:selectTSpoints(23078, 56,271)">';
mtxt += '<area shape="circle" coords=" 61,271,3" href="javascript:selectTSpoints(23079, 61,271)">';
mtxt += '<area shape="circle" coords=" 66,271,3" href="javascript:selectTSpoints(23080, 66,271)">';
mtxt += '<area shape="circle" coords=" 71,271,3" href="javascript:selectTSpoints(23081, 71,271)">';
mtxt += '<area shape="circle" coords=" 76,271,3" href="javascript:selectTSpoints(23082, 76,271)">';
mtxt += '<area shape="circle" coords=" 81,271,3" href="javascript:selectTSpoints(23083, 81,271)">';
mtxt += '<area shape="circle" coords=" 86,271,3" href="javascript:selectTSpoints(23084, 86,271)">';
mtxt += '<area shape="circle" coords=" 91,271,3" href="javascript:selectTSpoints(23085, 91,271)">';
mtxt += '<area shape="circle" coords=" 96,271,3" href="javascript:selectTSpoints(23086, 96,271)">';
mtxt += '<area shape="circle" coords="101,271,3" href="javascript:selectTSpoints(23087,101,271)">';
mtxt += '<area shape="circle" coords="106,271,3" href="javascript:selectTSpoints(23088,106,271)">';
mtxt += '<area shape="circle" coords="112,271,3" href="javascript:selectTSpoints(23089,112,271)">';
mtxt += '<area shape="circle" coords="117,271,3" href="javascript:selectTSpoints(23090,117,271)">';
mtxt += '<area shape="circle" coords="122,271,3" href="javascript:selectTSpoints(23091,122,271)">';
mtxt += '<area shape="circle" coords="127,271,3" href="javascript:selectTSpoints(23092,127,271)">';
mtxt += '<area shape="circle" coords="132,271,3" href="javascript:selectTSpoints(23093,132,271)">';
mtxt += '<area shape="circle" coords="137,271,3" href="javascript:selectTSpoints(23094,137,271)">';
mtxt += '<area shape="circle" coords="142,271,3" href="javascript:selectTSpoints(23095,142,271)">';
mtxt += '<area shape="circle" coords="147,271,3" href="javascript:selectTSpoints(23096,147,271)">';
mtxt += '<area shape="circle" coords="152,271,3" href="javascript:selectTSpoints(23097,152,271)">';
mtxt += '<area shape="circle" coords="157,271,3" href="javascript:selectTSpoints(23098,157,271)">';
mtxt += '<area shape="circle" coords="162,271,3" href="javascript:selectTSpoints(23099,162,271)">';
mtxt += '<area shape="circle" coords="168,271,3" href="javascript:selectTSpoints(23100,168,271)">';
mtxt += '<area shape="circle" coords="173,271,3" href="javascript:selectTSpoints(23101,173,271)">';
mtxt += '<area shape="circle" coords="178,271,3" href="javascript:selectTSpoints(23102,178,271)">';
mtxt += '<area shape="circle" coords="183,271,3" href="javascript:selectTSpoints(23103,183,271)">';
mtxt += '<area shape="circle" coords="188,271,3" href="javascript:selectTSpoints(23104,188,271)">';
mtxt += '<area shape="circle" coords="193,271,3" href="javascript:selectTSpoints(23105,193,271)">';
mtxt += '<area shape="circle" coords="198,271,3" href="javascript:selectTSpoints(23106,198,271)">';
mtxt += '<area shape="circle" coords="203,271,3" href="javascript:selectTSpoints(23107,203,271)">';
mtxt += '<area shape="circle" coords="208,271,3" href="javascript:selectTSpoints(23108,208,271)">';
mtxt += '<area shape="circle" coords="213,271,3" href="javascript:selectTSpoints(23109,213,271)">';
mtxt += '<area shape="circle" coords="218,271,3" href="javascript:selectTSpoints(23110,218,271)">';
mtxt += '<area shape="circle" coords="224,271,3" href="javascript:selectTSpoints(23111,224,271)">';
mtxt += '<area shape="circle" coords="229,271,3" href="javascript:selectTSpoints(23112,229,271)">';
mtxt += '<area shape="circle" coords="234,271,3" href="javascript:selectTSpoints(23113,234,271)">';
mtxt += '<area shape="circle" coords="239,271,3" href="javascript:selectTSpoints(23114,239,271)">';
mtxt += '<area shape="circle" coords="244,271,3" href="javascript:selectTSpoints(23115,244,271)">';
mtxt += '<area shape="circle" coords="249,271,3" href="javascript:selectTSpoints(23116,249,271)">';
mtxt += '<area shape="circle" coords="254,271,3" href="javascript:selectTSpoints(23117,254,271)">';
mtxt += '<area shape="circle" coords="259,271,3" href="javascript:selectTSpoints(23118,259,271)">';
mtxt += '<area shape="circle" coords="264,271,3" href="javascript:selectTSpoints(23119,264,271)">';
mtxt += '<area shape="circle" coords="269,271,3" href="javascript:selectTSpoints(23120,269,271)">';
mtxt += '<area shape="circle" coords="274,271,3" href="javascript:selectTSpoints(23121,274,271)">';
mtxt += '<area shape="circle" coords="280,271,3" href="javascript:selectTSpoints(23122,280,271)">';
mtxt += '<area shape="circle" coords="285,271,3" href="javascript:selectTSpoints(23123,285,271)">';
mtxt += '<area shape="circle" coords="290,271,3" href="javascript:selectTSpoints(23124,290,271)">';
mtxt += '<area shape="circle" coords="295,271,3" href="javascript:selectTSpoints(23125,295,271)">';
mtxt += '<area shape="circle" coords="300,271,3" href="javascript:selectTSpoints(23126,300,271)">';
mtxt += '<area shape="circle" coords="305,271,3" href="javascript:selectTSpoints(23127,305,271)">';
mtxt += '<area shape="circle" coords="310,271,3" href="javascript:selectTSpoints(23128,310,271)">';
mtxt += '<area shape="circle" coords="315,271,3" href="javascript:selectTSpoints(23129,315,271)">';
mtxt += '<area shape="circle" coords="320,271,3" href="javascript:selectTSpoints(23130,320,271)">';
mtxt += '<area shape="circle" coords="325,271,3" href="javascript:selectTSpoints(23131,325,271)">';
mtxt += '<area shape="circle" coords="330,271,3" href="javascript:selectTSpoints(23132,330,271)">';
mtxt += '<area shape="circle" coords="336,271,3" href="javascript:selectTSpoints(23133,336,271)">';
mtxt += '<area shape="circle" coords="341,271,3" href="javascript:selectTSpoints(23134,341,271)">';
mtxt += '<area shape="circle" coords="346,271,3" href="javascript:selectTSpoints(23135,346,271)">';
mtxt += '<area shape="circle" coords="351,271,3" href="javascript:selectTSpoints(23136,351,271)">';
mtxt += '<area shape="circle" coords="356,271,3" href="javascript:selectTSpoints(23137,356,271)">';
mtxt += '<area shape="circle" coords="361,271,3" href="javascript:selectTSpoints(23138,361,271)">';
mtxt += '<area shape="circle" coords="366,271,3" href="javascript:selectTSpoints(23139,366,271)">';
mtxt += '<area shape="circle" coords="371,271,3" href="javascript:selectTSpoints(23140,371,271)">';
mtxt += '<area shape="circle" coords="376,271,3" href="javascript:selectTSpoints(23141,376,271)">';
mtxt += '<area shape="circle" coords="381,271,3" href="javascript:selectTSpoints(23142,381,271)">';
mtxt += '<area shape="circle" coords="386,271,3" href="javascript:selectTSpoints(23143,386,271)">';
mtxt += '<area shape="circle" coords="392,271,3" href="javascript:selectTSpoints(23144,392,271)">';
mtxt += '<area shape="circle" coords="397,271,3" href="javascript:selectTSpoints(23001,397,271)">';
mtxt += '<area shape="circle" coords="402,271,3" href="javascript:selectTSpoints(23002,402,271)">';
mtxt += '<area shape="circle" coords="407,271,3" href="javascript:selectTSpoints(23003,407,271)">';
mtxt += '<area shape="circle" coords="412,271,3" href="javascript:selectTSpoints(23004,412,271)">';
mtxt += '<area shape="circle" coords="417,271,3" href="javascript:selectTSpoints(23005,417,271)">';
mtxt += '<area shape="circle" coords="422,271,3" href="javascript:selectTSpoints(23006,422,271)">';
mtxt += '<area shape="circle" coords="427,271,3" href="javascript:selectTSpoints(23007,427,271)">';
mtxt += '<area shape="circle" coords="432,271,3" href="javascript:selectTSpoints(23008,432,271)">';
mtxt += '<area shape="circle" coords="437,271,3" href="javascript:selectTSpoints(23009,437,271)">';
mtxt += '<area shape="circle" coords="442,271,3" href="javascript:selectTSpoints(23010,442,271)">';
mtxt += '<area shape="circle" coords="447,271,3" href="javascript:selectTSpoints(23011,447,271)">';
mtxt += '<area shape="circle" coords="453,271,3" href="javascript:selectTSpoints(23012,453,271)">';
mtxt += '<area shape="circle" coords="458,271,3" href="javascript:selectTSpoints(23013,458,271)">';
mtxt += '<area shape="circle" coords="463,271,3" href="javascript:selectTSpoints(23014,463,271)">';
mtxt += '<area shape="circle" coords="468,271,3" href="javascript:selectTSpoints(23015,468,271)">';
mtxt += '<area shape="circle" coords="473,271,3" href="javascript:selectTSpoints(23016,473,271)">';
mtxt += '<area shape="circle" coords="478,271,3" href="javascript:selectTSpoints(23017,478,271)">';
mtxt += '<area shape="circle" coords="483,271,3" href="javascript:selectTSpoints(23018,483,271)">';
mtxt += '<area shape="circle" coords="488,271,3" href="javascript:selectTSpoints(23019,488,271)">';
mtxt += '<area shape="circle" coords="493,271,3" href="javascript:selectTSpoints(23020,493,271)">';
mtxt += '<area shape="circle" coords="498,271,3" href="javascript:selectTSpoints(23021,498,271)">';
mtxt += '<area shape="circle" coords="503,271,3" href="javascript:selectTSpoints(23022,503,271)">';
mtxt += '<area shape="circle" coords="509,271,3" href="javascript:selectTSpoints(23023,509,271)">';
mtxt += '<area shape="circle" coords="514,271,3" href="javascript:selectTSpoints(23024,514,271)">';
mtxt += '<area shape="circle" coords="519,271,3" href="javascript:selectTSpoints(23025,519,271)">';
mtxt += '<area shape="circle" coords="524,271,3" href="javascript:selectTSpoints(23026,524,271)">';
mtxt += '<area shape="circle" coords="529,271,3" href="javascript:selectTSpoints(23027,529,271)">';
mtxt += '<area shape="circle" coords="534,271,3" href="javascript:selectTSpoints(23028,534,271)">';
mtxt += '<area shape="circle" coords="539,271,3" href="javascript:selectTSpoints(23029,539,271)">';
mtxt += '<area shape="circle" coords="544,271,3" href="javascript:selectTSpoints(23030,544,271)">';
mtxt += '<area shape="circle" coords="549,271,3" href="javascript:selectTSpoints(23031,549,271)">';
mtxt += '<area shape="circle" coords="554,271,3" href="javascript:selectTSpoints(23032,554,271)">';
mtxt += '<area shape="circle" coords="559,271,3" href="javascript:selectTSpoints(23033,559,271)">';
mtxt += '<area shape="circle" coords="565,271,3" href="javascript:selectTSpoints(23034,565,271)">';
mtxt += '<area shape="circle" coords="570,271,3" href="javascript:selectTSpoints(23035,570,271)">';
mtxt += '<area shape="circle" coords="575,271,3" href="javascript:selectTSpoints(23036,575,271)">';
mtxt += '<area shape="circle" coords="580,271,3" href="javascript:selectTSpoints(23037,580,271)">';
mtxt += '<area shape="circle" coords="585,271,3" href="javascript:selectTSpoints(23038,585,271)">';
mtxt += '<area shape="circle" coords="590,271,3" href="javascript:selectTSpoints(23039,590,271)">';
mtxt += '<area shape="circle" coords="595,271,3" href="javascript:selectTSpoints(23040,595,271)">';
mtxt += '<area shape="circle" coords="600,271,3" href="javascript:selectTSpoints(23041,600,271)">';
mtxt += '<area shape="circle" coords="605,271,3" href="javascript:selectTSpoints(23042,605,271)">';
mtxt += '<area shape="circle" coords="610,271,3" href="javascript:selectTSpoints(23043,610,271)">';
mtxt += '<area shape="circle" coords="615,271,3" href="javascript:selectTSpoints(23044,615,271)">';
mtxt += '<area shape="circle" coords="621,271,3" href="javascript:selectTSpoints(23045,621,271)">';
mtxt += '<area shape="circle" coords="626,271,3" href="javascript:selectTSpoints(23046,626,271)">';
mtxt += '<area shape="circle" coords="631,271,3" href="javascript:selectTSpoints(23047,631,271)">';
mtxt += '<area shape="circle" coords="636,271,3" href="javascript:selectTSpoints(23048,636,271)">';
mtxt += '<area shape="circle" coords="641,271,3" href="javascript:selectTSpoints(23049,641,271)">';
mtxt += '<area shape="circle" coords="646,271,3" href="javascript:selectTSpoints(23050,646,271)">';
mtxt += '<area shape="circle" coords="651,271,3" href="javascript:selectTSpoints(23051,651,271)">';
mtxt += '<area shape="circle" coords="656,271,3" href="javascript:selectTSpoints(23052,656,271)">';
mtxt += '<area shape="circle" coords="661,271,3" href="javascript:selectTSpoints(23053,661,271)">';
mtxt += '<area shape="circle" coords="666,271,3" href="javascript:selectTSpoints(23054,666,271)">';
mtxt += '<area shape="circle" coords="671,271,3" href="javascript:selectTSpoints(23055,671,271)">';
mtxt += '<area shape="circle" coords="677,271,3" href="javascript:selectTSpoints(23056,677,271)">';
mtxt += '<area shape="circle" coords="682,271,3" href="javascript:selectTSpoints(23057,682,271)">';
mtxt += '<area shape="circle" coords="687,271,3" href="javascript:selectTSpoints(23058,687,271)">';
mtxt += '<area shape="circle" coords="692,271,3" href="javascript:selectTSpoints(23059,692,271)">';
mtxt += '<area shape="circle" coords="697,271,3" href="javascript:selectTSpoints(23060,697,271)">';
mtxt += '<area shape="circle" coords="702,271,3" href="javascript:selectTSpoints(23061,702,271)">';
mtxt += '<area shape="circle" coords="707,271,3" href="javascript:selectTSpoints(23062,707,271)">';
mtxt += '<area shape="circle" coords="712,271,3" href="javascript:selectTSpoints(23063,712,271)">';
mtxt += '<area shape="circle" coords="717,271,3" href="javascript:selectTSpoints(23064,717,271)">';
mtxt += '<area shape="circle" coords="722,271,3" href="javascript:selectTSpoints(23065,722,271)">';
mtxt += '<area shape="circle" coords="727,271,3" href="javascript:selectTSpoints(23066,727,271)">';
mtxt += '<area shape="circle" coords="733,271,3" href="javascript:selectTSpoints(23067,733,271)">';
mtxt += '<area shape="circle" coords="738,271,3" href="javascript:selectTSpoints(23068,738,271)">';
mtxt += '<area shape="circle" coords="743,271,3" href="javascript:selectTSpoints(23069,743,271)">';
mtxt += '<area shape="circle" coords="748,271,3" href="javascript:selectTSpoints(23070,748,271)">';
mtxt += '<area shape="circle" coords="753,271,3" href="javascript:selectTSpoints(23071,753,271)">';
mtxt += '<area shape="circle" coords="758,271,3" href="javascript:selectTSpoints(23072,758,271)">';
mtxt += '<area shape="circle" coords=" 30,267,3" href="javascript:selectTSpoints(24073, 30,267)">';
mtxt += '<area shape="circle" coords=" 35,267,3" href="javascript:selectTSpoints(24074, 35,267)">';
mtxt += '<area shape="circle" coords=" 40,267,3" href="javascript:selectTSpoints(24075, 40,267)">';
mtxt += '<area shape="circle" coords=" 45,267,3" href="javascript:selectTSpoints(24076, 45,267)">';
mtxt += '<area shape="circle" coords=" 50,267,3" href="javascript:selectTSpoints(24077, 50,267)">';
mtxt += '<area shape="circle" coords=" 56,267,3" href="javascript:selectTSpoints(24078, 56,267)">';
mtxt += '<area shape="circle" coords=" 61,267,3" href="javascript:selectTSpoints(24079, 61,267)">';
mtxt += '<area shape="circle" coords=" 66,267,3" href="javascript:selectTSpoints(24080, 66,267)">';
mtxt += '<area shape="circle" coords=" 71,267,3" href="javascript:selectTSpoints(24081, 71,267)">';
mtxt += '<area shape="circle" coords=" 76,267,3" href="javascript:selectTSpoints(24082, 76,267)">';
mtxt += '<area shape="circle" coords=" 81,267,3" href="javascript:selectTSpoints(24083, 81,267)">';
mtxt += '<area shape="circle" coords=" 86,267,3" href="javascript:selectTSpoints(24084, 86,267)">';
mtxt += '<area shape="circle" coords=" 91,267,3" href="javascript:selectTSpoints(24085, 91,267)">';
mtxt += '<area shape="circle" coords=" 96,267,3" href="javascript:selectTSpoints(24086, 96,267)">';
mtxt += '<area shape="circle" coords="101,267,3" href="javascript:selectTSpoints(24087,101,267)">';
mtxt += '<area shape="circle" coords="106,267,3" href="javascript:selectTSpoints(24088,106,267)">';
mtxt += '<area shape="circle" coords="112,267,3" href="javascript:selectTSpoints(24089,112,267)">';
mtxt += '<area shape="circle" coords="117,267,3" href="javascript:selectTSpoints(24090,117,267)">';
mtxt += '<area shape="circle" coords="122,267,3" href="javascript:selectTSpoints(24091,122,267)">';
mtxt += '<area shape="circle" coords="127,267,3" href="javascript:selectTSpoints(24092,127,267)">';
mtxt += '<area shape="circle" coords="132,267,3" href="javascript:selectTSpoints(24093,132,267)">';
mtxt += '<area shape="circle" coords="137,267,3" href="javascript:selectTSpoints(24094,137,267)">';
mtxt += '<area shape="circle" coords="142,267,3" href="javascript:selectTSpoints(24095,142,267)">';
mtxt += '<area shape="circle" coords="147,267,3" href="javascript:selectTSpoints(24096,147,267)">';
mtxt += '<area shape="circle" coords="152,267,3" href="javascript:selectTSpoints(24097,152,267)">';
mtxt += '<area shape="circle" coords="157,267,3" href="javascript:selectTSpoints(24098,157,267)">';
mtxt += '<area shape="circle" coords="162,267,3" href="javascript:selectTSpoints(24099,162,267)">';
mtxt += '<area shape="circle" coords="168,267,3" href="javascript:selectTSpoints(24100,168,267)">';
mtxt += '<area shape="circle" coords="173,267,3" href="javascript:selectTSpoints(24101,173,267)">';
mtxt += '<area shape="circle" coords="178,267,3" href="javascript:selectTSpoints(24102,178,267)">';
mtxt += '<area shape="circle" coords="183,267,3" href="javascript:selectTSpoints(24103,183,267)">';
mtxt += '<area shape="circle" coords="188,267,3" href="javascript:selectTSpoints(24104,188,267)">';
mtxt += '<area shape="circle" coords="193,267,3" href="javascript:selectTSpoints(24105,193,267)">';
mtxt += '<area shape="circle" coords="198,267,3" href="javascript:selectTSpoints(24106,198,267)">';
mtxt += '<area shape="circle" coords="203,267,3" href="javascript:selectTSpoints(24107,203,267)">';
mtxt += '<area shape="circle" coords="208,267,3" href="javascript:selectTSpoints(24108,208,267)">';
mtxt += '<area shape="circle" coords="213,267,3" href="javascript:selectTSpoints(24109,213,267)">';
mtxt += '<area shape="circle" coords="218,267,3" href="javascript:selectTSpoints(24110,218,267)">';
mtxt += '<area shape="circle" coords="224,267,3" href="javascript:selectTSpoints(24111,224,267)">';
mtxt += '<area shape="circle" coords="229,267,3" href="javascript:selectTSpoints(24112,229,267)">';
mtxt += '<area shape="circle" coords="234,267,3" href="javascript:selectTSpoints(24113,234,267)">';
mtxt += '<area shape="circle" coords="239,267,3" href="javascript:selectTSpoints(24114,239,267)">';
mtxt += '<area shape="circle" coords="244,267,3" href="javascript:selectTSpoints(24115,244,267)">';
mtxt += '<area shape="circle" coords="249,267,3" href="javascript:selectTSpoints(24116,249,267)">';
mtxt += '<area shape="circle" coords="254,267,3" href="javascript:selectTSpoints(24117,254,267)">';
mtxt += '<area shape="circle" coords="259,267,3" href="javascript:selectTSpoints(24118,259,267)">';
mtxt += '<area shape="circle" coords="264,267,3" href="javascript:selectTSpoints(24119,264,267)">';
mtxt += '<area shape="circle" coords="269,267,3" href="javascript:selectTSpoints(24120,269,267)">';
mtxt += '<area shape="circle" coords="274,267,3" href="javascript:selectTSpoints(24121,274,267)">';
mtxt += '<area shape="circle" coords="280,267,3" href="javascript:selectTSpoints(24122,280,267)">';
mtxt += '<area shape="circle" coords="285,267,3" href="javascript:selectTSpoints(24123,285,267)">';
mtxt += '<area shape="circle" coords="290,267,3" href="javascript:selectTSpoints(24124,290,267)">';
mtxt += '<area shape="circle" coords="295,267,3" href="javascript:selectTSpoints(24125,295,267)">';
mtxt += '<area shape="circle" coords="300,267,3" href="javascript:selectTSpoints(24126,300,267)">';
mtxt += '<area shape="circle" coords="305,267,3" href="javascript:selectTSpoints(24127,305,267)">';
mtxt += '<area shape="circle" coords="310,267,3" href="javascript:selectTSpoints(24128,310,267)">';
mtxt += '<area shape="circle" coords="315,267,3" href="javascript:selectTSpoints(24129,315,267)">';
mtxt += '<area shape="circle" coords="320,267,3" href="javascript:selectTSpoints(24130,320,267)">';
mtxt += '<area shape="circle" coords="325,267,3" href="javascript:selectTSpoints(24131,325,267)">';
mtxt += '<area shape="circle" coords="330,267,3" href="javascript:selectTSpoints(24132,330,267)">';
mtxt += '<area shape="circle" coords="336,267,3" href="javascript:selectTSpoints(24133,336,267)">';
mtxt += '<area shape="circle" coords="341,267,3" href="javascript:selectTSpoints(24134,341,267)">';
mtxt += '<area shape="circle" coords="346,267,3" href="javascript:selectTSpoints(24135,346,267)">';
mtxt += '<area shape="circle" coords="351,267,3" href="javascript:selectTSpoints(24136,351,267)">';
mtxt += '<area shape="circle" coords="356,267,3" href="javascript:selectTSpoints(24137,356,267)">';
mtxt += '<area shape="circle" coords="361,267,3" href="javascript:selectTSpoints(24138,361,267)">';
mtxt += '<area shape="circle" coords="366,267,3" href="javascript:selectTSpoints(24139,366,267)">';
mtxt += '<area shape="circle" coords="371,267,3" href="javascript:selectTSpoints(24140,371,267)">';
mtxt += '<area shape="circle" coords="376,267,3" href="javascript:selectTSpoints(24141,376,267)">';
mtxt += '<area shape="circle" coords="381,267,3" href="javascript:selectTSpoints(24142,381,267)">';
mtxt += '<area shape="circle" coords="386,267,3" href="javascript:selectTSpoints(24143,386,267)">';
mtxt += '<area shape="circle" coords="392,267,3" href="javascript:selectTSpoints(24144,392,267)">';
mtxt += '<area shape="circle" coords="397,267,3" href="javascript:selectTSpoints(24001,397,267)">';
mtxt += '<area shape="circle" coords="402,267,3" href="javascript:selectTSpoints(24002,402,267)">';
mtxt += '<area shape="circle" coords="407,267,3" href="javascript:selectTSpoints(24003,407,267)">';
mtxt += '<area shape="circle" coords="412,267,3" href="javascript:selectTSpoints(24004,412,267)">';
mtxt += '<area shape="circle" coords="417,267,3" href="javascript:selectTSpoints(24005,417,267)">';
mtxt += '<area shape="circle" coords="422,267,3" href="javascript:selectTSpoints(24006,422,267)">';
mtxt += '<area shape="circle" coords="427,267,3" href="javascript:selectTSpoints(24007,427,267)">';
mtxt += '<area shape="circle" coords="432,267,3" href="javascript:selectTSpoints(24008,432,267)">';
mtxt += '<area shape="circle" coords="437,267,3" href="javascript:selectTSpoints(24009,437,267)">';
mtxt += '<area shape="circle" coords="442,267,3" href="javascript:selectTSpoints(24010,442,267)">';
mtxt += '<area shape="circle" coords="447,267,3" href="javascript:selectTSpoints(24011,447,267)">';
mtxt += '<area shape="circle" coords="453,267,3" href="javascript:selectTSpoints(24012,453,267)">';
mtxt += '<area shape="circle" coords="458,267,3" href="javascript:selectTSpoints(24013,458,267)">';
mtxt += '<area shape="circle" coords="463,267,3" href="javascript:selectTSpoints(24014,463,267)">';
mtxt += '<area shape="circle" coords="468,267,3" href="javascript:selectTSpoints(24015,468,267)">';
mtxt += '<area shape="circle" coords="473,267,3" href="javascript:selectTSpoints(24016,473,267)">';
mtxt += '<area shape="circle" coords="478,267,3" href="javascript:selectTSpoints(24017,478,267)">';
mtxt += '<area shape="circle" coords="483,267,3" href="javascript:selectTSpoints(24018,483,267)">';
mtxt += '<area shape="circle" coords="488,267,3" href="javascript:selectTSpoints(24019,488,267)">';
mtxt += '<area shape="circle" coords="493,267,3" href="javascript:selectTSpoints(24020,493,267)">';
mtxt += '<area shape="circle" coords="498,267,3" href="javascript:selectTSpoints(24021,498,267)">';
mtxt += '<area shape="circle" coords="503,267,3" href="javascript:selectTSpoints(24022,503,267)">';
mtxt += '<area shape="circle" coords="509,267,3" href="javascript:selectTSpoints(24023,509,267)">';
mtxt += '<area shape="circle" coords="514,267,3" href="javascript:selectTSpoints(24024,514,267)">';
mtxt += '<area shape="circle" coords="519,267,3" href="javascript:selectTSpoints(24025,519,267)">';
mtxt += '<area shape="circle" coords="524,267,3" href="javascript:selectTSpoints(24026,524,267)">';
mtxt += '<area shape="circle" coords="529,267,3" href="javascript:selectTSpoints(24027,529,267)">';
mtxt += '<area shape="circle" coords="534,267,3" href="javascript:selectTSpoints(24028,534,267)">';
mtxt += '<area shape="circle" coords="539,267,3" href="javascript:selectTSpoints(24029,539,267)">';
mtxt += '<area shape="circle" coords="544,267,3" href="javascript:selectTSpoints(24030,544,267)">';
mtxt += '<area shape="circle" coords="549,267,3" href="javascript:selectTSpoints(24031,549,267)">';
mtxt += '<area shape="circle" coords="554,267,3" href="javascript:selectTSpoints(24032,554,267)">';
mtxt += '<area shape="circle" coords="559,267,3" href="javascript:selectTSpoints(24033,559,267)">';
mtxt += '<area shape="circle" coords="565,267,3" href="javascript:selectTSpoints(24034,565,267)">';
mtxt += '<area shape="circle" coords="570,267,3" href="javascript:selectTSpoints(24035,570,267)">';
mtxt += '<area shape="circle" coords="575,267,3" href="javascript:selectTSpoints(24036,575,267)">';
mtxt += '<area shape="circle" coords="580,267,3" href="javascript:selectTSpoints(24037,580,267)">';
mtxt += '<area shape="circle" coords="585,267,3" href="javascript:selectTSpoints(24038,585,267)">';
mtxt += '<area shape="circle" coords="590,267,3" href="javascript:selectTSpoints(24039,590,267)">';
mtxt += '<area shape="circle" coords="595,267,3" href="javascript:selectTSpoints(24040,595,267)">';
mtxt += '<area shape="circle" coords="600,267,3" href="javascript:selectTSpoints(24041,600,267)">';
mtxt += '<area shape="circle" coords="605,267,3" href="javascript:selectTSpoints(24042,605,267)">';
mtxt += '<area shape="circle" coords="610,267,3" href="javascript:selectTSpoints(24043,610,267)">';
mtxt += '<area shape="circle" coords="615,267,3" href="javascript:selectTSpoints(24044,615,267)">';
mtxt += '<area shape="circle" coords="621,267,3" href="javascript:selectTSpoints(24045,621,267)">';
mtxt += '<area shape="circle" coords="626,267,3" href="javascript:selectTSpoints(24046,626,267)">';
mtxt += '<area shape="circle" coords="631,267,3" href="javascript:selectTSpoints(24047,631,267)">';
mtxt += '<area shape="circle" coords="636,267,3" href="javascript:selectTSpoints(24048,636,267)">';
mtxt += '<area shape="circle" coords="641,267,3" href="javascript:selectTSpoints(24049,641,267)">';
mtxt += '<area shape="circle" coords="646,267,3" href="javascript:selectTSpoints(24050,646,267)">';
mtxt += '<area shape="circle" coords="651,267,3" href="javascript:selectTSpoints(24051,651,267)">';
mtxt += '<area shape="circle" coords="656,267,3" href="javascript:selectTSpoints(24052,656,267)">';
mtxt += '<area shape="circle" coords="661,267,3" href="javascript:selectTSpoints(24053,661,267)">';
mtxt += '<area shape="circle" coords="666,267,3" href="javascript:selectTSpoints(24054,666,267)">';
mtxt += '<area shape="circle" coords="671,267,3" href="javascript:selectTSpoints(24055,671,267)">';
mtxt += '<area shape="circle" coords="677,267,3" href="javascript:selectTSpoints(24056,677,267)">';
mtxt += '<area shape="circle" coords="682,267,3" href="javascript:selectTSpoints(24057,682,267)">';
mtxt += '<area shape="circle" coords="687,267,3" href="javascript:selectTSpoints(24058,687,267)">';
mtxt += '<area shape="circle" coords="692,267,3" href="javascript:selectTSpoints(24059,692,267)">';
mtxt += '<area shape="circle" coords="697,267,3" href="javascript:selectTSpoints(24060,697,267)">';
mtxt += '<area shape="circle" coords="702,267,3" href="javascript:selectTSpoints(24061,702,267)">';
mtxt += '<area shape="circle" coords="707,267,3" href="javascript:selectTSpoints(24062,707,267)">';
mtxt += '<area shape="circle" coords="712,267,3" href="javascript:selectTSpoints(24063,712,267)">';
mtxt += '<area shape="circle" coords="717,267,3" href="javascript:selectTSpoints(24064,717,267)">';
mtxt += '<area shape="circle" coords="722,267,3" href="javascript:selectTSpoints(24065,722,267)">';
mtxt += '<area shape="circle" coords="727,267,3" href="javascript:selectTSpoints(24066,727,267)">';
mtxt += '<area shape="circle" coords="733,267,3" href="javascript:selectTSpoints(24067,733,267)">';
mtxt += '<area shape="circle" coords="738,267,3" href="javascript:selectTSpoints(24068,738,267)">';
mtxt += '<area shape="circle" coords="743,267,3" href="javascript:selectTSpoints(24069,743,267)">';
mtxt += '<area shape="circle" coords="748,267,3" href="javascript:selectTSpoints(24070,748,267)">';
mtxt += '<area shape="circle" coords="753,267,3" href="javascript:selectTSpoints(24071,753,267)">';
mtxt += '<area shape="circle" coords="758,267,3" href="javascript:selectTSpoints(24072,758,267)">';
mtxt += '<area shape="circle" coords=" 30,262,3" href="javascript:selectTSpoints(25073, 30,262)">';
mtxt += '<area shape="circle" coords=" 35,262,3" href="javascript:selectTSpoints(25074, 35,262)">';
mtxt += '<area shape="circle" coords=" 40,262,3" href="javascript:selectTSpoints(25075, 40,262)">';
mtxt += '<area shape="circle" coords=" 45,262,3" href="javascript:selectTSpoints(25076, 45,262)">';
mtxt += '<area shape="circle" coords=" 50,262,3" href="javascript:selectTSpoints(25077, 50,262)">';
mtxt += '<area shape="circle" coords=" 56,262,3" href="javascript:selectTSpoints(25078, 56,262)">';
mtxt += '<area shape="circle" coords=" 61,262,3" href="javascript:selectTSpoints(25079, 61,262)">';
mtxt += '<area shape="circle" coords=" 66,262,3" href="javascript:selectTSpoints(25080, 66,262)">';
mtxt += '<area shape="circle" coords=" 71,262,3" href="javascript:selectTSpoints(25081, 71,262)">';
mtxt += '<area shape="circle" coords=" 76,262,3" href="javascript:selectTSpoints(25082, 76,262)">';
mtxt += '<area shape="circle" coords=" 81,262,3" href="javascript:selectTSpoints(25083, 81,262)">';
mtxt += '<area shape="circle" coords=" 86,262,3" href="javascript:selectTSpoints(25084, 86,262)">';
mtxt += '<area shape="circle" coords=" 91,262,3" href="javascript:selectTSpoints(25085, 91,262)">';
mtxt += '<area shape="circle" coords=" 96,262,3" href="javascript:selectTSpoints(25086, 96,262)">';
mtxt += '<area shape="circle" coords="101,262,3" href="javascript:selectTSpoints(25087,101,262)">';
mtxt += '<area shape="circle" coords="106,262,3" href="javascript:selectTSpoints(25088,106,262)">';
mtxt += '<area shape="circle" coords="112,262,3" href="javascript:selectTSpoints(25089,112,262)">';
mtxt += '<area shape="circle" coords="117,262,3" href="javascript:selectTSpoints(25090,117,262)">';
mtxt += '<area shape="circle" coords="122,262,3" href="javascript:selectTSpoints(25091,122,262)">';
mtxt += '<area shape="circle" coords="127,262,3" href="javascript:selectTSpoints(25092,127,262)">';
mtxt += '<area shape="circle" coords="132,262,3" href="javascript:selectTSpoints(25093,132,262)">';
mtxt += '<area shape="circle" coords="137,262,3" href="javascript:selectTSpoints(25094,137,262)">';
mtxt += '<area shape="circle" coords="142,262,3" href="javascript:selectTSpoints(25095,142,262)">';
mtxt += '<area shape="circle" coords="147,262,3" href="javascript:selectTSpoints(25096,147,262)">';
mtxt += '<area shape="circle" coords="152,262,3" href="javascript:selectTSpoints(25097,152,262)">';
mtxt += '<area shape="circle" coords="157,262,3" href="javascript:selectTSpoints(25098,157,262)">';
mtxt += '<area shape="circle" coords="162,262,3" href="javascript:selectTSpoints(25099,162,262)">';
mtxt += '<area shape="circle" coords="168,262,3" href="javascript:selectTSpoints(25100,168,262)">';
mtxt += '<area shape="circle" coords="173,262,3" href="javascript:selectTSpoints(25101,173,262)">';
mtxt += '<area shape="circle" coords="178,262,3" href="javascript:selectTSpoints(25102,178,262)">';
mtxt += '<area shape="circle" coords="183,262,3" href="javascript:selectTSpoints(25103,183,262)">';
mtxt += '<area shape="circle" coords="188,262,3" href="javascript:selectTSpoints(25104,188,262)">';
mtxt += '<area shape="circle" coords="193,262,3" href="javascript:selectTSpoints(25105,193,262)">';
mtxt += '<area shape="circle" coords="198,262,3" href="javascript:selectTSpoints(25106,198,262)">';
mtxt += '<area shape="circle" coords="203,262,3" href="javascript:selectTSpoints(25107,203,262)">';
mtxt += '<area shape="circle" coords="208,262,3" href="javascript:selectTSpoints(25108,208,262)">';
mtxt += '<area shape="circle" coords="213,262,3" href="javascript:selectTSpoints(25109,213,262)">';
mtxt += '<area shape="circle" coords="218,262,3" href="javascript:selectTSpoints(25110,218,262)">';
mtxt += '<area shape="circle" coords="224,262,3" href="javascript:selectTSpoints(25111,224,262)">';
mtxt += '<area shape="circle" coords="229,262,3" href="javascript:selectTSpoints(25112,229,262)">';
mtxt += '<area shape="circle" coords="234,262,3" href="javascript:selectTSpoints(25113,234,262)">';
mtxt += '<area shape="circle" coords="239,262,3" href="javascript:selectTSpoints(25114,239,262)">';
mtxt += '<area shape="circle" coords="244,262,3" href="javascript:selectTSpoints(25115,244,262)">';
mtxt += '<area shape="circle" coords="249,262,3" href="javascript:selectTSpoints(25116,249,262)">';
mtxt += '<area shape="circle" coords="254,262,3" href="javascript:selectTSpoints(25117,254,262)">';
mtxt += '<area shape="circle" coords="259,262,3" href="javascript:selectTSpoints(25118,259,262)">';
mtxt += '<area shape="circle" coords="264,262,3" href="javascript:selectTSpoints(25119,264,262)">';
mtxt += '<area shape="circle" coords="269,262,3" href="javascript:selectTSpoints(25120,269,262)">';
mtxt += '<area shape="circle" coords="274,262,3" href="javascript:selectTSpoints(25121,274,262)">';
mtxt += '<area shape="circle" coords="280,262,3" href="javascript:selectTSpoints(25122,280,262)">';
mtxt += '<area shape="circle" coords="285,262,3" href="javascript:selectTSpoints(25123,285,262)">';
mtxt += '<area shape="circle" coords="290,262,3" href="javascript:selectTSpoints(25124,290,262)">';
mtxt += '<area shape="circle" coords="295,262,3" href="javascript:selectTSpoints(25125,295,262)">';
mtxt += '<area shape="circle" coords="300,262,3" href="javascript:selectTSpoints(25126,300,262)">';
mtxt += '<area shape="circle" coords="305,262,3" href="javascript:selectTSpoints(25127,305,262)">';
mtxt += '<area shape="circle" coords="310,262,3" href="javascript:selectTSpoints(25128,310,262)">';
mtxt += '<area shape="circle" coords="315,262,3" href="javascript:selectTSpoints(25129,315,262)">';
mtxt += '<area shape="circle" coords="320,262,3" href="javascript:selectTSpoints(25130,320,262)">';
mtxt += '<area shape="circle" coords="325,262,3" href="javascript:selectTSpoints(25131,325,262)">';
mtxt += '<area shape="circle" coords="330,262,3" href="javascript:selectTSpoints(25132,330,262)">';
mtxt += '<area shape="circle" coords="336,262,3" href="javascript:selectTSpoints(25133,336,262)">';
mtxt += '<area shape="circle" coords="341,262,3" href="javascript:selectTSpoints(25134,341,262)">';
mtxt += '<area shape="circle" coords="346,262,3" href="javascript:selectTSpoints(25135,346,262)">';
mtxt += '<area shape="circle" coords="351,262,3" href="javascript:selectTSpoints(25136,351,262)">';
mtxt += '<area shape="circle" coords="356,262,3" href="javascript:selectTSpoints(25137,356,262)">';
mtxt += '<area shape="circle" coords="361,262,3" href="javascript:selectTSpoints(25138,361,262)">';
mtxt += '<area shape="circle" coords="366,262,3" href="javascript:selectTSpoints(25139,366,262)">';
mtxt += '<area shape="circle" coords="371,262,3" href="javascript:selectTSpoints(25140,371,262)">';
mtxt += '<area shape="circle" coords="376,262,3" href="javascript:selectTSpoints(25141,376,262)">';
mtxt += '<area shape="circle" coords="381,262,3" href="javascript:selectTSpoints(25142,381,262)">';
mtxt += '<area shape="circle" coords="386,262,3" href="javascript:selectTSpoints(25143,386,262)">';
mtxt += '<area shape="circle" coords="392,262,3" href="javascript:selectTSpoints(25144,392,262)">';
mtxt += '<area shape="circle" coords="397,262,3" href="javascript:selectTSpoints(25001,397,262)">';
mtxt += '<area shape="circle" coords="402,262,3" href="javascript:selectTSpoints(25002,402,262)">';
mtxt += '<area shape="circle" coords="407,262,3" href="javascript:selectTSpoints(25003,407,262)">';
mtxt += '<area shape="circle" coords="412,262,3" href="javascript:selectTSpoints(25004,412,262)">';
mtxt += '<area shape="circle" coords="417,262,3" href="javascript:selectTSpoints(25005,417,262)">';
mtxt += '<area shape="circle" coords="422,262,3" href="javascript:selectTSpoints(25006,422,262)">';
mtxt += '<area shape="circle" coords="427,262,3" href="javascript:selectTSpoints(25007,427,262)">';
mtxt += '<area shape="circle" coords="432,262,3" href="javascript:selectTSpoints(25008,432,262)">';
mtxt += '<area shape="circle" coords="437,262,3" href="javascript:selectTSpoints(25009,437,262)">';
mtxt += '<area shape="circle" coords="442,262,3" href="javascript:selectTSpoints(25010,442,262)">';
mtxt += '<area shape="circle" coords="447,262,3" href="javascript:selectTSpoints(25011,447,262)">';
mtxt += '<area shape="circle" coords="453,262,3" href="javascript:selectTSpoints(25012,453,262)">';
mtxt += '<area shape="circle" coords="458,262,3" href="javascript:selectTSpoints(25013,458,262)">';
mtxt += '<area shape="circle" coords="463,262,3" href="javascript:selectTSpoints(25014,463,262)">';
mtxt += '<area shape="circle" coords="468,262,3" href="javascript:selectTSpoints(25015,468,262)">';
mtxt += '<area shape="circle" coords="473,262,3" href="javascript:selectTSpoints(25016,473,262)">';
mtxt += '<area shape="circle" coords="478,262,3" href="javascript:selectTSpoints(25017,478,262)">';
mtxt += '<area shape="circle" coords="483,262,3" href="javascript:selectTSpoints(25018,483,262)">';
mtxt += '<area shape="circle" coords="488,262,3" href="javascript:selectTSpoints(25019,488,262)">';
mtxt += '<area shape="circle" coords="493,262,3" href="javascript:selectTSpoints(25020,493,262)">';
mtxt += '<area shape="circle" coords="498,262,3" href="javascript:selectTSpoints(25021,498,262)">';
mtxt += '<area shape="circle" coords="503,262,3" href="javascript:selectTSpoints(25022,503,262)">';
mtxt += '<area shape="circle" coords="509,262,3" href="javascript:selectTSpoints(25023,509,262)">';
mtxt += '<area shape="circle" coords="514,262,3" href="javascript:selectTSpoints(25024,514,262)">';
mtxt += '<area shape="circle" coords="519,262,3" href="javascript:selectTSpoints(25025,519,262)">';
mtxt += '<area shape="circle" coords="524,262,3" href="javascript:selectTSpoints(25026,524,262)">';
mtxt += '<area shape="circle" coords="529,262,3" href="javascript:selectTSpoints(25027,529,262)">';
mtxt += '<area shape="circle" coords="534,262,3" href="javascript:selectTSpoints(25028,534,262)">';
mtxt += '<area shape="circle" coords="539,262,3" href="javascript:selectTSpoints(25029,539,262)">';
mtxt += '<area shape="circle" coords="544,262,3" href="javascript:selectTSpoints(25030,544,262)">';
mtxt += '<area shape="circle" coords="549,262,3" href="javascript:selectTSpoints(25031,549,262)">';
mtxt += '<area shape="circle" coords="554,262,3" href="javascript:selectTSpoints(25032,554,262)">';
mtxt += '<area shape="circle" coords="559,262,3" href="javascript:selectTSpoints(25033,559,262)">';
mtxt += '<area shape="circle" coords="565,262,3" href="javascript:selectTSpoints(25034,565,262)">';
mtxt += '<area shape="circle" coords="570,262,3" href="javascript:selectTSpoints(25035,570,262)">';
mtxt += '<area shape="circle" coords="575,262,3" href="javascript:selectTSpoints(25036,575,262)">';
mtxt += '<area shape="circle" coords="580,262,3" href="javascript:selectTSpoints(25037,580,262)">';
mtxt += '<area shape="circle" coords="585,262,3" href="javascript:selectTSpoints(25038,585,262)">';
mtxt += '<area shape="circle" coords="590,262,3" href="javascript:selectTSpoints(25039,590,262)">';
mtxt += '<area shape="circle" coords="595,262,3" href="javascript:selectTSpoints(25040,595,262)">';
mtxt += '<area shape="circle" coords="600,262,3" href="javascript:selectTSpoints(25041,600,262)">';
mtxt += '<area shape="circle" coords="605,262,3" href="javascript:selectTSpoints(25042,605,262)">';
mtxt += '<area shape="circle" coords="610,262,3" href="javascript:selectTSpoints(25043,610,262)">';
mtxt += '<area shape="circle" coords="615,262,3" href="javascript:selectTSpoints(25044,615,262)">';
mtxt += '<area shape="circle" coords="621,262,3" href="javascript:selectTSpoints(25045,621,262)">';
mtxt += '<area shape="circle" coords="626,262,3" href="javascript:selectTSpoints(25046,626,262)">';
mtxt += '<area shape="circle" coords="631,262,3" href="javascript:selectTSpoints(25047,631,262)">';
mtxt += '<area shape="circle" coords="636,262,3" href="javascript:selectTSpoints(25048,636,262)">';
mtxt += '<area shape="circle" coords="641,262,3" href="javascript:selectTSpoints(25049,641,262)">';
mtxt += '<area shape="circle" coords="646,262,3" href="javascript:selectTSpoints(25050,646,262)">';
mtxt += '<area shape="circle" coords="651,262,3" href="javascript:selectTSpoints(25051,651,262)">';
mtxt += '<area shape="circle" coords="656,262,3" href="javascript:selectTSpoints(25052,656,262)">';
mtxt += '<area shape="circle" coords="661,262,3" href="javascript:selectTSpoints(25053,661,262)">';
mtxt += '<area shape="circle" coords="666,262,3" href="javascript:selectTSpoints(25054,666,262)">';
mtxt += '<area shape="circle" coords="671,262,3" href="javascript:selectTSpoints(25055,671,262)">';
mtxt += '<area shape="circle" coords="677,262,3" href="javascript:selectTSpoints(25056,677,262)">';
mtxt += '<area shape="circle" coords="682,262,3" href="javascript:selectTSpoints(25057,682,262)">';
mtxt += '<area shape="circle" coords="687,262,3" href="javascript:selectTSpoints(25058,687,262)">';
mtxt += '<area shape="circle" coords="692,262,3" href="javascript:selectTSpoints(25059,692,262)">';
mtxt += '<area shape="circle" coords="697,262,3" href="javascript:selectTSpoints(25060,697,262)">';
mtxt += '<area shape="circle" coords="702,262,3" href="javascript:selectTSpoints(25061,702,262)">';
mtxt += '<area shape="circle" coords="707,262,3" href="javascript:selectTSpoints(25062,707,262)">';
mtxt += '<area shape="circle" coords="712,262,3" href="javascript:selectTSpoints(25063,712,262)">';
mtxt += '<area shape="circle" coords="717,262,3" href="javascript:selectTSpoints(25064,717,262)">';
mtxt += '<area shape="circle" coords="722,262,3" href="javascript:selectTSpoints(25065,722,262)">';
mtxt += '<area shape="circle" coords="727,262,3" href="javascript:selectTSpoints(25066,727,262)">';
mtxt += '<area shape="circle" coords="733,262,3" href="javascript:selectTSpoints(25067,733,262)">';
mtxt += '<area shape="circle" coords="738,262,3" href="javascript:selectTSpoints(25068,738,262)">';
mtxt += '<area shape="circle" coords="743,262,3" href="javascript:selectTSpoints(25069,743,262)">';
mtxt += '<area shape="circle" coords="748,262,3" href="javascript:selectTSpoints(25070,748,262)">';
mtxt += '<area shape="circle" coords="753,262,3" href="javascript:selectTSpoints(25071,753,262)">';
mtxt += '<area shape="circle" coords="758,262,3" href="javascript:selectTSpoints(25072,758,262)">';
mtxt += '<area shape="circle" coords=" 30,257,3" href="javascript:selectTSpoints(26073, 30,257)">';
mtxt += '<area shape="circle" coords=" 35,257,3" href="javascript:selectTSpoints(26074, 35,257)">';
mtxt += '<area shape="circle" coords=" 40,257,3" href="javascript:selectTSpoints(26075, 40,257)">';
mtxt += '<area shape="circle" coords=" 45,257,3" href="javascript:selectTSpoints(26076, 45,257)">';
mtxt += '<area shape="circle" coords=" 50,257,3" href="javascript:selectTSpoints(26077, 50,257)">';
mtxt += '<area shape="circle" coords=" 56,257,3" href="javascript:selectTSpoints(26078, 56,257)">';
mtxt += '<area shape="circle" coords=" 61,257,3" href="javascript:selectTSpoints(26079, 61,257)">';
mtxt += '<area shape="circle" coords=" 66,257,3" href="javascript:selectTSpoints(26080, 66,257)">';
mtxt += '<area shape="circle" coords=" 71,257,3" href="javascript:selectTSpoints(26081, 71,257)">';
mtxt += '<area shape="circle" coords=" 76,257,3" href="javascript:selectTSpoints(26082, 76,257)">';
mtxt += '<area shape="circle" coords=" 81,257,3" href="javascript:selectTSpoints(26083, 81,257)">';
mtxt += '<area shape="circle" coords=" 86,257,3" href="javascript:selectTSpoints(26084, 86,257)">';
mtxt += '<area shape="circle" coords=" 91,257,3" href="javascript:selectTSpoints(26085, 91,257)">';
mtxt += '<area shape="circle" coords=" 96,257,3" href="javascript:selectTSpoints(26086, 96,257)">';
mtxt += '<area shape="circle" coords="101,257,3" href="javascript:selectTSpoints(26087,101,257)">';
mtxt += '<area shape="circle" coords="106,257,3" href="javascript:selectTSpoints(26088,106,257)">';
mtxt += '<area shape="circle" coords="112,257,3" href="javascript:selectTSpoints(26089,112,257)">';
mtxt += '<area shape="circle" coords="117,257,3" href="javascript:selectTSpoints(26090,117,257)">';
mtxt += '<area shape="circle" coords="122,257,3" href="javascript:selectTSpoints(26091,122,257)">';
mtxt += '<area shape="circle" coords="127,257,3" href="javascript:selectTSpoints(26092,127,257)">';
mtxt += '<area shape="circle" coords="132,257,3" href="javascript:selectTSpoints(26093,132,257)">';
mtxt += '<area shape="circle" coords="137,257,3" href="javascript:selectTSpoints(26094,137,257)">';
mtxt += '<area shape="circle" coords="142,257,3" href="javascript:selectTSpoints(26095,142,257)">';
mtxt += '<area shape="circle" coords="147,257,3" href="javascript:selectTSpoints(26096,147,257)">';
mtxt += '<area shape="circle" coords="152,257,3" href="javascript:selectTSpoints(26097,152,257)">';
mtxt += '<area shape="circle" coords="157,257,3" href="javascript:selectTSpoints(26098,157,257)">';
mtxt += '<area shape="circle" coords="162,257,3" href="javascript:selectTSpoints(26099,162,257)">';
mtxt += '<area shape="circle" coords="168,257,3" href="javascript:selectTSpoints(26100,168,257)">';
mtxt += '<area shape="circle" coords="173,257,3" href="javascript:selectTSpoints(26101,173,257)">';
mtxt += '<area shape="circle" coords="178,257,3" href="javascript:selectTSpoints(26102,178,257)">';
mtxt += '<area shape="circle" coords="183,257,3" href="javascript:selectTSpoints(26103,183,257)">';
mtxt += '<area shape="circle" coords="188,257,3" href="javascript:selectTSpoints(26104,188,257)">';
mtxt += '<area shape="circle" coords="193,257,3" href="javascript:selectTSpoints(26105,193,257)">';
mtxt += '<area shape="circle" coords="198,257,3" href="javascript:selectTSpoints(26106,198,257)">';
mtxt += '<area shape="circle" coords="203,257,3" href="javascript:selectTSpoints(26107,203,257)">';
mtxt += '<area shape="circle" coords="208,257,3" href="javascript:selectTSpoints(26108,208,257)">';
mtxt += '<area shape="circle" coords="213,257,3" href="javascript:selectTSpoints(26109,213,257)">';
mtxt += '<area shape="circle" coords="218,257,3" href="javascript:selectTSpoints(26110,218,257)">';
mtxt += '<area shape="circle" coords="224,257,3" href="javascript:selectTSpoints(26111,224,257)">';
mtxt += '<area shape="circle" coords="229,257,3" href="javascript:selectTSpoints(26112,229,257)">';
mtxt += '<area shape="circle" coords="234,257,3" href="javascript:selectTSpoints(26113,234,257)">';
mtxt += '<area shape="circle" coords="239,257,3" href="javascript:selectTSpoints(26114,239,257)">';
mtxt += '<area shape="circle" coords="244,257,3" href="javascript:selectTSpoints(26115,244,257)">';
mtxt += '<area shape="circle" coords="249,257,3" href="javascript:selectTSpoints(26116,249,257)">';
mtxt += '<area shape="circle" coords="254,257,3" href="javascript:selectTSpoints(26117,254,257)">';
mtxt += '<area shape="circle" coords="259,257,3" href="javascript:selectTSpoints(26118,259,257)">';
mtxt += '<area shape="circle" coords="264,257,3" href="javascript:selectTSpoints(26119,264,257)">';
mtxt += '<area shape="circle" coords="269,257,3" href="javascript:selectTSpoints(26120,269,257)">';
mtxt += '<area shape="circle" coords="274,257,3" href="javascript:selectTSpoints(26121,274,257)">';
mtxt += '<area shape="circle" coords="280,257,3" href="javascript:selectTSpoints(26122,280,257)">';
mtxt += '<area shape="circle" coords="285,257,3" href="javascript:selectTSpoints(26123,285,257)">';
mtxt += '<area shape="circle" coords="290,257,3" href="javascript:selectTSpoints(26124,290,257)">';
mtxt += '<area shape="circle" coords="295,257,3" href="javascript:selectTSpoints(26125,295,257)">';
mtxt += '<area shape="circle" coords="300,257,3" href="javascript:selectTSpoints(26126,300,257)">';
mtxt += '<area shape="circle" coords="305,257,3" href="javascript:selectTSpoints(26127,305,257)">';
mtxt += '<area shape="circle" coords="310,257,3" href="javascript:selectTSpoints(26128,310,257)">';
mtxt += '<area shape="circle" coords="315,257,3" href="javascript:selectTSpoints(26129,315,257)">';
mtxt += '<area shape="circle" coords="320,257,3" href="javascript:selectTSpoints(26130,320,257)">';
mtxt += '<area shape="circle" coords="325,257,3" href="javascript:selectTSpoints(26131,325,257)">';
mtxt += '<area shape="circle" coords="330,257,3" href="javascript:selectTSpoints(26132,330,257)">';
mtxt += '<area shape="circle" coords="336,257,3" href="javascript:selectTSpoints(26133,336,257)">';
mtxt += '<area shape="circle" coords="341,257,3" href="javascript:selectTSpoints(26134,341,257)">';
mtxt += '<area shape="circle" coords="346,257,3" href="javascript:selectTSpoints(26135,346,257)">';
mtxt += '<area shape="circle" coords="351,257,3" href="javascript:selectTSpoints(26136,351,257)">';
mtxt += '<area shape="circle" coords="356,257,3" href="javascript:selectTSpoints(26137,356,257)">';
mtxt += '<area shape="circle" coords="361,257,3" href="javascript:selectTSpoints(26138,361,257)">';
mtxt += '<area shape="circle" coords="366,257,3" href="javascript:selectTSpoints(26139,366,257)">';
mtxt += '<area shape="circle" coords="371,257,3" href="javascript:selectTSpoints(26140,371,257)">';
mtxt += '<area shape="circle" coords="376,257,3" href="javascript:selectTSpoints(26141,376,257)">';
mtxt += '<area shape="circle" coords="381,257,3" href="javascript:selectTSpoints(26142,381,257)">';
mtxt += '<area shape="circle" coords="386,257,3" href="javascript:selectTSpoints(26143,386,257)">';
mtxt += '<area shape="circle" coords="392,257,3" href="javascript:selectTSpoints(26144,392,257)">';
mtxt += '<area shape="circle" coords="397,257,3" href="javascript:selectTSpoints(26001,397,257)">';
mtxt += '<area shape="circle" coords="402,257,3" href="javascript:selectTSpoints(26002,402,257)">';
mtxt += '<area shape="circle" coords="407,257,3" href="javascript:selectTSpoints(26003,407,257)">';
mtxt += '<area shape="circle" coords="412,257,3" href="javascript:selectTSpoints(26004,412,257)">';
mtxt += '<area shape="circle" coords="417,257,3" href="javascript:selectTSpoints(26005,417,257)">';
mtxt += '<area shape="circle" coords="422,257,3" href="javascript:selectTSpoints(26006,422,257)">';
mtxt += '<area shape="circle" coords="427,257,3" href="javascript:selectTSpoints(26007,427,257)">';
mtxt += '<area shape="circle" coords="432,257,3" href="javascript:selectTSpoints(26008,432,257)">';
mtxt += '<area shape="circle" coords="437,257,3" href="javascript:selectTSpoints(26009,437,257)">';
mtxt += '<area shape="circle" coords="442,257,3" href="javascript:selectTSpoints(26010,442,257)">';
mtxt += '<area shape="circle" coords="447,257,3" href="javascript:selectTSpoints(26011,447,257)">';
mtxt += '<area shape="circle" coords="453,257,3" href="javascript:selectTSpoints(26012,453,257)">';
mtxt += '<area shape="circle" coords="458,257,3" href="javascript:selectTSpoints(26013,458,257)">';
mtxt += '<area shape="circle" coords="463,257,3" href="javascript:selectTSpoints(26014,463,257)">';
mtxt += '<area shape="circle" coords="468,257,3" href="javascript:selectTSpoints(26015,468,257)">';
mtxt += '<area shape="circle" coords="473,257,3" href="javascript:selectTSpoints(26016,473,257)">';
mtxt += '<area shape="circle" coords="478,257,3" href="javascript:selectTSpoints(26017,478,257)">';
mtxt += '<area shape="circle" coords="483,257,3" href="javascript:selectTSpoints(26018,483,257)">';
mtxt += '<area shape="circle" coords="488,257,3" href="javascript:selectTSpoints(26019,488,257)">';
mtxt += '<area shape="circle" coords="493,257,3" href="javascript:selectTSpoints(26020,493,257)">';
mtxt += '<area shape="circle" coords="498,257,3" href="javascript:selectTSpoints(26021,498,257)">';
mtxt += '<area shape="circle" coords="503,257,3" href="javascript:selectTSpoints(26022,503,257)">';
mtxt += '<area shape="circle" coords="509,257,3" href="javascript:selectTSpoints(26023,509,257)">';
mtxt += '<area shape="circle" coords="514,257,3" href="javascript:selectTSpoints(26024,514,257)">';
mtxt += '<area shape="circle" coords="519,257,3" href="javascript:selectTSpoints(26025,519,257)">';
mtxt += '<area shape="circle" coords="524,257,3" href="javascript:selectTSpoints(26026,524,257)">';
mtxt += '<area shape="circle" coords="529,257,3" href="javascript:selectTSpoints(26027,529,257)">';
mtxt += '<area shape="circle" coords="534,257,3" href="javascript:selectTSpoints(26028,534,257)">';
mtxt += '<area shape="circle" coords="539,257,3" href="javascript:selectTSpoints(26029,539,257)">';
mtxt += '<area shape="circle" coords="544,257,3" href="javascript:selectTSpoints(26030,544,257)">';
mtxt += '<area shape="circle" coords="549,257,3" href="javascript:selectTSpoints(26031,549,257)">';
mtxt += '<area shape="circle" coords="554,257,3" href="javascript:selectTSpoints(26032,554,257)">';
mtxt += '<area shape="circle" coords="559,257,3" href="javascript:selectTSpoints(26033,559,257)">';
mtxt += '<area shape="circle" coords="565,257,3" href="javascript:selectTSpoints(26034,565,257)">';
mtxt += '<area shape="circle" coords="570,257,3" href="javascript:selectTSpoints(26035,570,257)">';
mtxt += '<area shape="circle" coords="575,257,3" href="javascript:selectTSpoints(26036,575,257)">';
mtxt += '<area shape="circle" coords="580,257,3" href="javascript:selectTSpoints(26037,580,257)">';
mtxt += '<area shape="circle" coords="585,257,3" href="javascript:selectTSpoints(26038,585,257)">';
mtxt += '<area shape="circle" coords="590,257,3" href="javascript:selectTSpoints(26039,590,257)">';
mtxt += '<area shape="circle" coords="595,257,3" href="javascript:selectTSpoints(26040,595,257)">';
mtxt += '<area shape="circle" coords="600,257,3" href="javascript:selectTSpoints(26041,600,257)">';
mtxt += '<area shape="circle" coords="605,257,3" href="javascript:selectTSpoints(26042,605,257)">';
mtxt += '<area shape="circle" coords="610,257,3" href="javascript:selectTSpoints(26043,610,257)">';
mtxt += '<area shape="circle" coords="615,257,3" href="javascript:selectTSpoints(26044,615,257)">';
mtxt += '<area shape="circle" coords="621,257,3" href="javascript:selectTSpoints(26045,621,257)">';
mtxt += '<area shape="circle" coords="626,257,3" href="javascript:selectTSpoints(26046,626,257)">';
mtxt += '<area shape="circle" coords="631,257,3" href="javascript:selectTSpoints(26047,631,257)">';
mtxt += '<area shape="circle" coords="636,257,3" href="javascript:selectTSpoints(26048,636,257)">';
mtxt += '<area shape="circle" coords="641,257,3" href="javascript:selectTSpoints(26049,641,257)">';
mtxt += '<area shape="circle" coords="646,257,3" href="javascript:selectTSpoints(26050,646,257)">';
mtxt += '<area shape="circle" coords="651,257,3" href="javascript:selectTSpoints(26051,651,257)">';
mtxt += '<area shape="circle" coords="656,257,3" href="javascript:selectTSpoints(26052,656,257)">';
mtxt += '<area shape="circle" coords="661,257,3" href="javascript:selectTSpoints(26053,661,257)">';
mtxt += '<area shape="circle" coords="666,257,3" href="javascript:selectTSpoints(26054,666,257)">';
mtxt += '<area shape="circle" coords="671,257,3" href="javascript:selectTSpoints(26055,671,257)">';
mtxt += '<area shape="circle" coords="677,257,3" href="javascript:selectTSpoints(26056,677,257)">';
mtxt += '<area shape="circle" coords="682,257,3" href="javascript:selectTSpoints(26057,682,257)">';
mtxt += '<area shape="circle" coords="687,257,3" href="javascript:selectTSpoints(26058,687,257)">';
mtxt += '<area shape="circle" coords="692,257,3" href="javascript:selectTSpoints(26059,692,257)">';
mtxt += '<area shape="circle" coords="697,257,3" href="javascript:selectTSpoints(26060,697,257)">';
mtxt += '<area shape="circle" coords="702,257,3" href="javascript:selectTSpoints(26061,702,257)">';
mtxt += '<area shape="circle" coords="707,257,3" href="javascript:selectTSpoints(26062,707,257)">';
mtxt += '<area shape="circle" coords="712,257,3" href="javascript:selectTSpoints(26063,712,257)">';
mtxt += '<area shape="circle" coords="717,257,3" href="javascript:selectTSpoints(26064,717,257)">';
mtxt += '<area shape="circle" coords="722,257,3" href="javascript:selectTSpoints(26065,722,257)">';
mtxt += '<area shape="circle" coords="727,257,3" href="javascript:selectTSpoints(26066,727,257)">';
mtxt += '<area shape="circle" coords="733,257,3" href="javascript:selectTSpoints(26067,733,257)">';
mtxt += '<area shape="circle" coords="738,257,3" href="javascript:selectTSpoints(26068,738,257)">';
mtxt += '<area shape="circle" coords="743,257,3" href="javascript:selectTSpoints(26069,743,257)">';
mtxt += '<area shape="circle" coords="748,257,3" href="javascript:selectTSpoints(26070,748,257)">';
mtxt += '<area shape="circle" coords="753,257,3" href="javascript:selectTSpoints(26071,753,257)">';
mtxt += '<area shape="circle" coords="758,257,3" href="javascript:selectTSpoints(26072,758,257)">';
mtxt += '<area shape="circle" coords=" 30,252,3" href="javascript:selectTSpoints(27073, 30,252)">';
mtxt += '<area shape="circle" coords=" 35,252,3" href="javascript:selectTSpoints(27074, 35,252)">';
mtxt += '<area shape="circle" coords=" 40,252,3" href="javascript:selectTSpoints(27075, 40,252)">';
mtxt += '<area shape="circle" coords=" 45,252,3" href="javascript:selectTSpoints(27076, 45,252)">';
mtxt += '<area shape="circle" coords=" 50,252,3" href="javascript:selectTSpoints(27077, 50,252)">';
mtxt += '<area shape="circle" coords=" 56,252,3" href="javascript:selectTSpoints(27078, 56,252)">';
mtxt += '<area shape="circle" coords=" 61,252,3" href="javascript:selectTSpoints(27079, 61,252)">';
mtxt += '<area shape="circle" coords=" 66,252,3" href="javascript:selectTSpoints(27080, 66,252)">';
mtxt += '<area shape="circle" coords=" 71,252,3" href="javascript:selectTSpoints(27081, 71,252)">';
mtxt += '<area shape="circle" coords=" 76,252,3" href="javascript:selectTSpoints(27082, 76,252)">';
mtxt += '<area shape="circle" coords=" 81,252,3" href="javascript:selectTSpoints(27083, 81,252)">';
mtxt += '<area shape="circle" coords=" 86,252,3" href="javascript:selectTSpoints(27084, 86,252)">';
mtxt += '<area shape="circle" coords=" 91,252,3" href="javascript:selectTSpoints(27085, 91,252)">';
mtxt += '<area shape="circle" coords=" 96,252,3" href="javascript:selectTSpoints(27086, 96,252)">';
mtxt += '<area shape="circle" coords="101,252,3" href="javascript:selectTSpoints(27087,101,252)">';
mtxt += '<area shape="circle" coords="106,252,3" href="javascript:selectTSpoints(27088,106,252)">';
mtxt += '<area shape="circle" coords="112,252,3" href="javascript:selectTSpoints(27089,112,252)">';
mtxt += '<area shape="circle" coords="117,252,3" href="javascript:selectTSpoints(27090,117,252)">';
mtxt += '<area shape="circle" coords="122,252,3" href="javascript:selectTSpoints(27091,122,252)">';
mtxt += '<area shape="circle" coords="127,252,3" href="javascript:selectTSpoints(27092,127,252)">';
mtxt += '<area shape="circle" coords="132,252,3" href="javascript:selectTSpoints(27093,132,252)">';
mtxt += '<area shape="circle" coords="137,252,3" href="javascript:selectTSpoints(27094,137,252)">';
mtxt += '<area shape="circle" coords="142,252,3" href="javascript:selectTSpoints(27095,142,252)">';
mtxt += '<area shape="circle" coords="147,252,3" href="javascript:selectTSpoints(27096,147,252)">';
mtxt += '<area shape="circle" coords="152,252,3" href="javascript:selectTSpoints(27097,152,252)">';
mtxt += '<area shape="circle" coords="157,252,3" href="javascript:selectTSpoints(27098,157,252)">';
mtxt += '<area shape="circle" coords="162,252,3" href="javascript:selectTSpoints(27099,162,252)">';
mtxt += '<area shape="circle" coords="168,252,3" href="javascript:selectTSpoints(27100,168,252)">';
mtxt += '<area shape="circle" coords="173,252,3" href="javascript:selectTSpoints(27101,173,252)">';
mtxt += '<area shape="circle" coords="178,252,3" href="javascript:selectTSpoints(27102,178,252)">';
mtxt += '<area shape="circle" coords="183,252,3" href="javascript:selectTSpoints(27103,183,252)">';
mtxt += '<area shape="circle" coords="188,252,3" href="javascript:selectTSpoints(27104,188,252)">';
mtxt += '<area shape="circle" coords="193,252,3" href="javascript:selectTSpoints(27105,193,252)">';
mtxt += '<area shape="circle" coords="198,252,3" href="javascript:selectTSpoints(27106,198,252)">';
mtxt += '<area shape="circle" coords="203,252,3" href="javascript:selectTSpoints(27107,203,252)">';
mtxt += '<area shape="circle" coords="208,252,3" href="javascript:selectTSpoints(27108,208,252)">';
mtxt += '<area shape="circle" coords="213,252,3" href="javascript:selectTSpoints(27109,213,252)">';
mtxt += '<area shape="circle" coords="218,252,3" href="javascript:selectTSpoints(27110,218,252)">';
mtxt += '<area shape="circle" coords="224,252,3" href="javascript:selectTSpoints(27111,224,252)">';
mtxt += '<area shape="circle" coords="229,252,3" href="javascript:selectTSpoints(27112,229,252)">';
mtxt += '<area shape="circle" coords="234,252,3" href="javascript:selectTSpoints(27113,234,252)">';
mtxt += '<area shape="circle" coords="239,252,3" href="javascript:selectTSpoints(27114,239,252)">';
mtxt += '<area shape="circle" coords="244,252,3" href="javascript:selectTSpoints(27115,244,252)">';
mtxt += '<area shape="circle" coords="249,252,3" href="javascript:selectTSpoints(27116,249,252)">';
mtxt += '<area shape="circle" coords="254,252,3" href="javascript:selectTSpoints(27117,254,252)">';
mtxt += '<area shape="circle" coords="259,252,3" href="javascript:selectTSpoints(27118,259,252)">';
mtxt += '<area shape="circle" coords="264,252,3" href="javascript:selectTSpoints(27119,264,252)">';
mtxt += '<area shape="circle" coords="269,252,3" href="javascript:selectTSpoints(27120,269,252)">';
mtxt += '<area shape="circle" coords="274,252,3" href="javascript:selectTSpoints(27121,274,252)">';
mtxt += '<area shape="circle" coords="280,252,3" href="javascript:selectTSpoints(27122,280,252)">';
mtxt += '<area shape="circle" coords="285,252,3" href="javascript:selectTSpoints(27123,285,252)">';
mtxt += '<area shape="circle" coords="290,252,3" href="javascript:selectTSpoints(27124,290,252)">';
mtxt += '<area shape="circle" coords="295,252,3" href="javascript:selectTSpoints(27125,295,252)">';
mtxt += '<area shape="circle" coords="300,252,3" href="javascript:selectTSpoints(27126,300,252)">';
mtxt += '<area shape="circle" coords="305,252,3" href="javascript:selectTSpoints(27127,305,252)">';
mtxt += '<area shape="circle" coords="310,252,3" href="javascript:selectTSpoints(27128,310,252)">';
mtxt += '<area shape="circle" coords="315,252,3" href="javascript:selectTSpoints(27129,315,252)">';
mtxt += '<area shape="circle" coords="320,252,3" href="javascript:selectTSpoints(27130,320,252)">';
mtxt += '<area shape="circle" coords="325,252,3" href="javascript:selectTSpoints(27131,325,252)">';
mtxt += '<area shape="circle" coords="330,252,3" href="javascript:selectTSpoints(27132,330,252)">';
mtxt += '<area shape="circle" coords="336,252,3" href="javascript:selectTSpoints(27133,336,252)">';
mtxt += '<area shape="circle" coords="341,252,3" href="javascript:selectTSpoints(27134,341,252)">';
mtxt += '<area shape="circle" coords="346,252,3" href="javascript:selectTSpoints(27135,346,252)">';
mtxt += '<area shape="circle" coords="351,252,3" href="javascript:selectTSpoints(27136,351,252)">';
mtxt += '<area shape="circle" coords="356,252,3" href="javascript:selectTSpoints(27137,356,252)">';
mtxt += '<area shape="circle" coords="361,252,3" href="javascript:selectTSpoints(27138,361,252)">';
mtxt += '<area shape="circle" coords="366,252,3" href="javascript:selectTSpoints(27139,366,252)">';
mtxt += '<area shape="circle" coords="371,252,3" href="javascript:selectTSpoints(27140,371,252)">';
mtxt += '<area shape="circle" coords="376,252,3" href="javascript:selectTSpoints(27141,376,252)">';
mtxt += '<area shape="circle" coords="381,252,3" href="javascript:selectTSpoints(27142,381,252)">';
mtxt += '<area shape="circle" coords="386,252,3" href="javascript:selectTSpoints(27143,386,252)">';
mtxt += '<area shape="circle" coords="392,252,3" href="javascript:selectTSpoints(27144,392,252)">';
mtxt += '<area shape="circle" coords="397,252,3" href="javascript:selectTSpoints(27001,397,252)">';
mtxt += '<area shape="circle" coords="402,252,3" href="javascript:selectTSpoints(27002,402,252)">';
mtxt += '<area shape="circle" coords="407,252,3" href="javascript:selectTSpoints(27003,407,252)">';
mtxt += '<area shape="circle" coords="412,252,3" href="javascript:selectTSpoints(27004,412,252)">';
mtxt += '<area shape="circle" coords="417,252,3" href="javascript:selectTSpoints(27005,417,252)">';
mtxt += '<area shape="circle" coords="422,252,3" href="javascript:selectTSpoints(27006,422,252)">';
mtxt += '<area shape="circle" coords="427,252,3" href="javascript:selectTSpoints(27007,427,252)">';
mtxt += '<area shape="circle" coords="432,252,3" href="javascript:selectTSpoints(27008,432,252)">';
mtxt += '<area shape="circle" coords="437,252,3" href="javascript:selectTSpoints(27009,437,252)">';
mtxt += '<area shape="circle" coords="442,252,3" href="javascript:selectTSpoints(27010,442,252)">';
mtxt += '<area shape="circle" coords="447,252,3" href="javascript:selectTSpoints(27011,447,252)">';
mtxt += '<area shape="circle" coords="453,252,3" href="javascript:selectTSpoints(27012,453,252)">';
mtxt += '<area shape="circle" coords="458,252,3" href="javascript:selectTSpoints(27013,458,252)">';
mtxt += '<area shape="circle" coords="463,252,3" href="javascript:selectTSpoints(27014,463,252)">';
mtxt += '<area shape="circle" coords="468,252,3" href="javascript:selectTSpoints(27015,468,252)">';
mtxt += '<area shape="circle" coords="473,252,3" href="javascript:selectTSpoints(27016,473,252)">';
mtxt += '<area shape="circle" coords="478,252,3" href="javascript:selectTSpoints(27017,478,252)">';
mtxt += '<area shape="circle" coords="483,252,3" href="javascript:selectTSpoints(27018,483,252)">';
mtxt += '<area shape="circle" coords="488,252,3" href="javascript:selectTSpoints(27019,488,252)">';
mtxt += '<area shape="circle" coords="493,252,3" href="javascript:selectTSpoints(27020,493,252)">';
mtxt += '<area shape="circle" coords="498,252,3" href="javascript:selectTSpoints(27021,498,252)">';
mtxt += '<area shape="circle" coords="503,252,3" href="javascript:selectTSpoints(27022,503,252)">';
mtxt += '<area shape="circle" coords="509,252,3" href="javascript:selectTSpoints(27023,509,252)">';
mtxt += '<area shape="circle" coords="514,252,3" href="javascript:selectTSpoints(27024,514,252)">';
mtxt += '<area shape="circle" coords="519,252,3" href="javascript:selectTSpoints(27025,519,252)">';
mtxt += '<area shape="circle" coords="524,252,3" href="javascript:selectTSpoints(27026,524,252)">';
mtxt += '<area shape="circle" coords="529,252,3" href="javascript:selectTSpoints(27027,529,252)">';
mtxt += '<area shape="circle" coords="534,252,3" href="javascript:selectTSpoints(27028,534,252)">';
mtxt += '<area shape="circle" coords="539,252,3" href="javascript:selectTSpoints(27029,539,252)">';
mtxt += '<area shape="circle" coords="544,252,3" href="javascript:selectTSpoints(27030,544,252)">';
mtxt += '<area shape="circle" coords="549,252,3" href="javascript:selectTSpoints(27031,549,252)">';
mtxt += '<area shape="circle" coords="554,252,3" href="javascript:selectTSpoints(27032,554,252)">';
mtxt += '<area shape="circle" coords="559,252,3" href="javascript:selectTSpoints(27033,559,252)">';
mtxt += '<area shape="circle" coords="565,252,3" href="javascript:selectTSpoints(27034,565,252)">';
mtxt += '<area shape="circle" coords="570,252,3" href="javascript:selectTSpoints(27035,570,252)">';
mtxt += '<area shape="circle" coords="575,252,3" href="javascript:selectTSpoints(27036,575,252)">';
mtxt += '<area shape="circle" coords="580,252,3" href="javascript:selectTSpoints(27037,580,252)">';
mtxt += '<area shape="circle" coords="585,252,3" href="javascript:selectTSpoints(27038,585,252)">';
mtxt += '<area shape="circle" coords="590,252,3" href="javascript:selectTSpoints(27039,590,252)">';
mtxt += '<area shape="circle" coords="595,252,3" href="javascript:selectTSpoints(27040,595,252)">';
mtxt += '<area shape="circle" coords="600,252,3" href="javascript:selectTSpoints(27041,600,252)">';
mtxt += '<area shape="circle" coords="605,252,3" href="javascript:selectTSpoints(27042,605,252)">';
mtxt += '<area shape="circle" coords="610,252,3" href="javascript:selectTSpoints(27043,610,252)">';
mtxt += '<area shape="circle" coords="615,252,3" href="javascript:selectTSpoints(27044,615,252)">';
mtxt += '<area shape="circle" coords="621,252,3" href="javascript:selectTSpoints(27045,621,252)">';
mtxt += '<area shape="circle" coords="626,252,3" href="javascript:selectTSpoints(27046,626,252)">';
mtxt += '<area shape="circle" coords="631,252,3" href="javascript:selectTSpoints(27047,631,252)">';
mtxt += '<area shape="circle" coords="636,252,3" href="javascript:selectTSpoints(27048,636,252)">';
mtxt += '<area shape="circle" coords="641,252,3" href="javascript:selectTSpoints(27049,641,252)">';
mtxt += '<area shape="circle" coords="646,252,3" href="javascript:selectTSpoints(27050,646,252)">';
mtxt += '<area shape="circle" coords="651,252,3" href="javascript:selectTSpoints(27051,651,252)">';
mtxt += '<area shape="circle" coords="656,252,3" href="javascript:selectTSpoints(27052,656,252)">';
mtxt += '<area shape="circle" coords="661,252,3" href="javascript:selectTSpoints(27053,661,252)">';
mtxt += '<area shape="circle" coords="666,252,3" href="javascript:selectTSpoints(27054,666,252)">';
mtxt += '<area shape="circle" coords="671,252,3" href="javascript:selectTSpoints(27055,671,252)">';
mtxt += '<area shape="circle" coords="677,252,3" href="javascript:selectTSpoints(27056,677,252)">';
mtxt += '<area shape="circle" coords="682,252,3" href="javascript:selectTSpoints(27057,682,252)">';
mtxt += '<area shape="circle" coords="687,252,3" href="javascript:selectTSpoints(27058,687,252)">';
mtxt += '<area shape="circle" coords="692,252,3" href="javascript:selectTSpoints(27059,692,252)">';
mtxt += '<area shape="circle" coords="697,252,3" href="javascript:selectTSpoints(27060,697,252)">';
mtxt += '<area shape="circle" coords="702,252,3" href="javascript:selectTSpoints(27061,702,252)">';
mtxt += '<area shape="circle" coords="707,252,3" href="javascript:selectTSpoints(27062,707,252)">';
mtxt += '<area shape="circle" coords="712,252,3" href="javascript:selectTSpoints(27063,712,252)">';
mtxt += '<area shape="circle" coords="717,252,3" href="javascript:selectTSpoints(27064,717,252)">';
mtxt += '<area shape="circle" coords="722,252,3" href="javascript:selectTSpoints(27065,722,252)">';
mtxt += '<area shape="circle" coords="727,252,3" href="javascript:selectTSpoints(27066,727,252)">';
mtxt += '<area shape="circle" coords="733,252,3" href="javascript:selectTSpoints(27067,733,252)">';
mtxt += '<area shape="circle" coords="738,252,3" href="javascript:selectTSpoints(27068,738,252)">';
mtxt += '<area shape="circle" coords="743,252,3" href="javascript:selectTSpoints(27069,743,252)">';
mtxt += '<area shape="circle" coords="748,252,3" href="javascript:selectTSpoints(27070,748,252)">';
mtxt += '<area shape="circle" coords="753,252,3" href="javascript:selectTSpoints(27071,753,252)">';
mtxt += '<area shape="circle" coords="758,252,3" href="javascript:selectTSpoints(27072,758,252)">';
mtxt += '<area shape="circle" coords=" 30,247,3" href="javascript:selectTSpoints(28073, 30,247)">';
mtxt += '<area shape="circle" coords=" 35,247,3" href="javascript:selectTSpoints(28074, 35,247)">';
mtxt += '<area shape="circle" coords=" 40,247,3" href="javascript:selectTSpoints(28075, 40,247)">';
mtxt += '<area shape="circle" coords=" 45,247,3" href="javascript:selectTSpoints(28076, 45,247)">';
mtxt += '<area shape="circle" coords=" 50,247,3" href="javascript:selectTSpoints(28077, 50,247)">';
mtxt += '<area shape="circle" coords=" 56,247,3" href="javascript:selectTSpoints(28078, 56,247)">';
mtxt += '<area shape="circle" coords=" 61,247,3" href="javascript:selectTSpoints(28079, 61,247)">';
mtxt += '<area shape="circle" coords=" 66,247,3" href="javascript:selectTSpoints(28080, 66,247)">';
mtxt += '<area shape="circle" coords=" 71,247,3" href="javascript:selectTSpoints(28081, 71,247)">';
mtxt += '<area shape="circle" coords=" 76,247,3" href="javascript:selectTSpoints(28082, 76,247)">';
mtxt += '<area shape="circle" coords=" 81,247,3" href="javascript:selectTSpoints(28083, 81,247)">';
mtxt += '<area shape="circle" coords=" 86,247,3" href="javascript:selectTSpoints(28084, 86,247)">';
mtxt += '<area shape="circle" coords=" 91,247,3" href="javascript:selectTSpoints(28085, 91,247)">';
mtxt += '<area shape="circle" coords=" 96,247,3" href="javascript:selectTSpoints(28086, 96,247)">';
mtxt += '<area shape="circle" coords="101,247,3" href="javascript:selectTSpoints(28087,101,247)">';
mtxt += '<area shape="circle" coords="106,247,3" href="javascript:selectTSpoints(28088,106,247)">';
mtxt += '<area shape="circle" coords="112,247,3" href="javascript:selectTSpoints(28089,112,247)">';
mtxt += '<area shape="circle" coords="117,247,3" href="javascript:selectTSpoints(28090,117,247)">';
mtxt += '<area shape="circle" coords="122,247,3" href="javascript:selectTSpoints(28091,122,247)">';
mtxt += '<area shape="circle" coords="127,247,3" href="javascript:selectTSpoints(28092,127,247)">';
mtxt += '<area shape="circle" coords="132,247,3" href="javascript:selectTSpoints(28093,132,247)">';
mtxt += '<area shape="circle" coords="137,247,3" href="javascript:selectTSpoints(28094,137,247)">';
mtxt += '<area shape="circle" coords="142,247,3" href="javascript:selectTSpoints(28095,142,247)">';
mtxt += '<area shape="circle" coords="147,247,3" href="javascript:selectTSpoints(28096,147,247)">';
mtxt += '<area shape="circle" coords="152,247,3" href="javascript:selectTSpoints(28097,152,247)">';
mtxt += '<area shape="circle" coords="157,247,3" href="javascript:selectTSpoints(28098,157,247)">';
mtxt += '<area shape="circle" coords="162,247,3" href="javascript:selectTSpoints(28099,162,247)">';
mtxt += '<area shape="circle" coords="168,247,3" href="javascript:selectTSpoints(28100,168,247)">';
mtxt += '<area shape="circle" coords="173,247,3" href="javascript:selectTSpoints(28101,173,247)">';
mtxt += '<area shape="circle" coords="178,247,3" href="javascript:selectTSpoints(28102,178,247)">';
mtxt += '<area shape="circle" coords="183,247,3" href="javascript:selectTSpoints(28103,183,247)">';
mtxt += '<area shape="circle" coords="188,247,3" href="javascript:selectTSpoints(28104,188,247)">';
mtxt += '<area shape="circle" coords="193,247,3" href="javascript:selectTSpoints(28105,193,247)">';
mtxt += '<area shape="circle" coords="198,247,3" href="javascript:selectTSpoints(28106,198,247)">';
mtxt += '<area shape="circle" coords="203,247,3" href="javascript:selectTSpoints(28107,203,247)">';
mtxt += '<area shape="circle" coords="208,247,3" href="javascript:selectTSpoints(28108,208,247)">';
mtxt += '<area shape="circle" coords="213,247,3" href="javascript:selectTSpoints(28109,213,247)">';
mtxt += '<area shape="circle" coords="218,247,3" href="javascript:selectTSpoints(28110,218,247)">';
mtxt += '<area shape="circle" coords="224,247,3" href="javascript:selectTSpoints(28111,224,247)">';
mtxt += '<area shape="circle" coords="229,247,3" href="javascript:selectTSpoints(28112,229,247)">';
mtxt += '<area shape="circle" coords="234,247,3" href="javascript:selectTSpoints(28113,234,247)">';
mtxt += '<area shape="circle" coords="239,247,3" href="javascript:selectTSpoints(28114,239,247)">';
mtxt += '<area shape="circle" coords="244,247,3" href="javascript:selectTSpoints(28115,244,247)">';
mtxt += '<area shape="circle" coords="249,247,3" href="javascript:selectTSpoints(28116,249,247)">';
mtxt += '<area shape="circle" coords="254,247,3" href="javascript:selectTSpoints(28117,254,247)">';
mtxt += '<area shape="circle" coords="259,247,3" href="javascript:selectTSpoints(28118,259,247)">';
mtxt += '<area shape="circle" coords="264,247,3" href="javascript:selectTSpoints(28119,264,247)">';
mtxt += '<area shape="circle" coords="269,247,3" href="javascript:selectTSpoints(28120,269,247)">';
mtxt += '<area shape="circle" coords="274,247,3" href="javascript:selectTSpoints(28121,274,247)">';
mtxt += '<area shape="circle" coords="280,247,3" href="javascript:selectTSpoints(28122,280,247)">';
mtxt += '<area shape="circle" coords="285,247,3" href="javascript:selectTSpoints(28123,285,247)">';
mtxt += '<area shape="circle" coords="290,247,3" href="javascript:selectTSpoints(28124,290,247)">';
mtxt += '<area shape="circle" coords="295,247,3" href="javascript:selectTSpoints(28125,295,247)">';
mtxt += '<area shape="circle" coords="300,247,3" href="javascript:selectTSpoints(28126,300,247)">';
mtxt += '<area shape="circle" coords="305,247,3" href="javascript:selectTSpoints(28127,305,247)">';
mtxt += '<area shape="circle" coords="310,247,3" href="javascript:selectTSpoints(28128,310,247)">';
mtxt += '<area shape="circle" coords="315,247,3" href="javascript:selectTSpoints(28129,315,247)">';
mtxt += '<area shape="circle" coords="320,247,3" href="javascript:selectTSpoints(28130,320,247)">';
mtxt += '<area shape="circle" coords="325,247,3" href="javascript:selectTSpoints(28131,325,247)">';
mtxt += '<area shape="circle" coords="330,247,3" href="javascript:selectTSpoints(28132,330,247)">';
mtxt += '<area shape="circle" coords="336,247,3" href="javascript:selectTSpoints(28133,336,247)">';
mtxt += '<area shape="circle" coords="341,247,3" href="javascript:selectTSpoints(28134,341,247)">';
mtxt += '<area shape="circle" coords="346,247,3" href="javascript:selectTSpoints(28135,346,247)">';
mtxt += '<area shape="circle" coords="351,247,3" href="javascript:selectTSpoints(28136,351,247)">';
mtxt += '<area shape="circle" coords="356,247,3" href="javascript:selectTSpoints(28137,356,247)">';
mtxt += '<area shape="circle" coords="361,247,3" href="javascript:selectTSpoints(28138,361,247)">';
mtxt += '<area shape="circle" coords="366,247,3" href="javascript:selectTSpoints(28139,366,247)">';
mtxt += '<area shape="circle" coords="371,247,3" href="javascript:selectTSpoints(28140,371,247)">';
mtxt += '<area shape="circle" coords="376,247,3" href="javascript:selectTSpoints(28141,376,247)">';
mtxt += '<area shape="circle" coords="381,247,3" href="javascript:selectTSpoints(28142,381,247)">';
mtxt += '<area shape="circle" coords="386,247,3" href="javascript:selectTSpoints(28143,386,247)">';
mtxt += '<area shape="circle" coords="392,247,3" href="javascript:selectTSpoints(28144,392,247)">';
mtxt += '<area shape="circle" coords="397,247,3" href="javascript:selectTSpoints(28001,397,247)">';
mtxt += '<area shape="circle" coords="402,247,3" href="javascript:selectTSpoints(28002,402,247)">';
mtxt += '<area shape="circle" coords="407,247,3" href="javascript:selectTSpoints(28003,407,247)">';
mtxt += '<area shape="circle" coords="412,247,3" href="javascript:selectTSpoints(28004,412,247)">';
mtxt += '<area shape="circle" coords="417,247,3" href="javascript:selectTSpoints(28005,417,247)">';
mtxt += '<area shape="circle" coords="422,247,3" href="javascript:selectTSpoints(28006,422,247)">';
mtxt += '<area shape="circle" coords="427,247,3" href="javascript:selectTSpoints(28007,427,247)">';
mtxt += '<area shape="circle" coords="432,247,3" href="javascript:selectTSpoints(28008,432,247)">';
mtxt += '<area shape="circle" coords="437,247,3" href="javascript:selectTSpoints(28009,437,247)">';
mtxt += '<area shape="circle" coords="442,247,3" href="javascript:selectTSpoints(28010,442,247)">';
mtxt += '<area shape="circle" coords="447,247,3" href="javascript:selectTSpoints(28011,447,247)">';
mtxt += '<area shape="circle" coords="453,247,3" href="javascript:selectTSpoints(28012,453,247)">';
mtxt += '<area shape="circle" coords="458,247,3" href="javascript:selectTSpoints(28013,458,247)">';
mtxt += '<area shape="circle" coords="463,247,3" href="javascript:selectTSpoints(28014,463,247)">';
mtxt += '<area shape="circle" coords="468,247,3" href="javascript:selectTSpoints(28015,468,247)">';
mtxt += '<area shape="circle" coords="473,247,3" href="javascript:selectTSpoints(28016,473,247)">';
mtxt += '<area shape="circle" coords="478,247,3" href="javascript:selectTSpoints(28017,478,247)">';
mtxt += '<area shape="circle" coords="483,247,3" href="javascript:selectTSpoints(28018,483,247)">';
mtxt += '<area shape="circle" coords="488,247,3" href="javascript:selectTSpoints(28019,488,247)">';
mtxt += '<area shape="circle" coords="493,247,3" href="javascript:selectTSpoints(28020,493,247)">';
mtxt += '<area shape="circle" coords="498,247,3" href="javascript:selectTSpoints(28021,498,247)">';
mtxt += '<area shape="circle" coords="503,247,3" href="javascript:selectTSpoints(28022,503,247)">';
mtxt += '<area shape="circle" coords="509,247,3" href="javascript:selectTSpoints(28023,509,247)">';
mtxt += '<area shape="circle" coords="514,247,3" href="javascript:selectTSpoints(28024,514,247)">';
mtxt += '<area shape="circle" coords="519,247,3" href="javascript:selectTSpoints(28025,519,247)">';
mtxt += '<area shape="circle" coords="524,247,3" href="javascript:selectTSpoints(28026,524,247)">';
mtxt += '<area shape="circle" coords="529,247,3" href="javascript:selectTSpoints(28027,529,247)">';
mtxt += '<area shape="circle" coords="534,247,3" href="javascript:selectTSpoints(28028,534,247)">';
mtxt += '<area shape="circle" coords="539,247,3" href="javascript:selectTSpoints(28029,539,247)">';
mtxt += '<area shape="circle" coords="544,247,3" href="javascript:selectTSpoints(28030,544,247)">';
mtxt += '<area shape="circle" coords="549,247,3" href="javascript:selectTSpoints(28031,549,247)">';
mtxt += '<area shape="circle" coords="554,247,3" href="javascript:selectTSpoints(28032,554,247)">';
mtxt += '<area shape="circle" coords="559,247,3" href="javascript:selectTSpoints(28033,559,247)">';
mtxt += '<area shape="circle" coords="565,247,3" href="javascript:selectTSpoints(28034,565,247)">';
mtxt += '<area shape="circle" coords="570,247,3" href="javascript:selectTSpoints(28035,570,247)">';
mtxt += '<area shape="circle" coords="575,247,3" href="javascript:selectTSpoints(28036,575,247)">';
mtxt += '<area shape="circle" coords="580,247,3" href="javascript:selectTSpoints(28037,580,247)">';
mtxt += '<area shape="circle" coords="585,247,3" href="javascript:selectTSpoints(28038,585,247)">';
mtxt += '<area shape="circle" coords="590,247,3" href="javascript:selectTSpoints(28039,590,247)">';
mtxt += '<area shape="circle" coords="595,247,3" href="javascript:selectTSpoints(28040,595,247)">';
mtxt += '<area shape="circle" coords="600,247,3" href="javascript:selectTSpoints(28041,600,247)">';
mtxt += '<area shape="circle" coords="605,247,3" href="javascript:selectTSpoints(28042,605,247)">';
mtxt += '<area shape="circle" coords="610,247,3" href="javascript:selectTSpoints(28043,610,247)">';
mtxt += '<area shape="circle" coords="615,247,3" href="javascript:selectTSpoints(28044,615,247)">';
mtxt += '<area shape="circle" coords="621,247,3" href="javascript:selectTSpoints(28045,621,247)">';
mtxt += '<area shape="circle" coords="626,247,3" href="javascript:selectTSpoints(28046,626,247)">';
mtxt += '<area shape="circle" coords="631,247,3" href="javascript:selectTSpoints(28047,631,247)">';
mtxt += '<area shape="circle" coords="636,247,3" href="javascript:selectTSpoints(28048,636,247)">';
mtxt += '<area shape="circle" coords="641,247,3" href="javascript:selectTSpoints(28049,641,247)">';
mtxt += '<area shape="circle" coords="646,247,3" href="javascript:selectTSpoints(28050,646,247)">';
mtxt += '<area shape="circle" coords="651,247,3" href="javascript:selectTSpoints(28051,651,247)">';
mtxt += '<area shape="circle" coords="656,247,3" href="javascript:selectTSpoints(28052,656,247)">';
mtxt += '<area shape="circle" coords="661,247,3" href="javascript:selectTSpoints(28053,661,247)">';
mtxt += '<area shape="circle" coords="666,247,3" href="javascript:selectTSpoints(28054,666,247)">';
mtxt += '<area shape="circle" coords="671,247,3" href="javascript:selectTSpoints(28055,671,247)">';
mtxt += '<area shape="circle" coords="677,247,3" href="javascript:selectTSpoints(28056,677,247)">';
mtxt += '<area shape="circle" coords="682,247,3" href="javascript:selectTSpoints(28057,682,247)">';
mtxt += '<area shape="circle" coords="687,247,3" href="javascript:selectTSpoints(28058,687,247)">';
mtxt += '<area shape="circle" coords="692,247,3" href="javascript:selectTSpoints(28059,692,247)">';
mtxt += '<area shape="circle" coords="697,247,3" href="javascript:selectTSpoints(28060,697,247)">';
mtxt += '<area shape="circle" coords="702,247,3" href="javascript:selectTSpoints(28061,702,247)">';
mtxt += '<area shape="circle" coords="707,247,3" href="javascript:selectTSpoints(28062,707,247)">';
mtxt += '<area shape="circle" coords="712,247,3" href="javascript:selectTSpoints(28063,712,247)">';
mtxt += '<area shape="circle" coords="717,247,3" href="javascript:selectTSpoints(28064,717,247)">';
mtxt += '<area shape="circle" coords="722,247,3" href="javascript:selectTSpoints(28065,722,247)">';
mtxt += '<area shape="circle" coords="727,247,3" href="javascript:selectTSpoints(28066,727,247)">';
mtxt += '<area shape="circle" coords="733,247,3" href="javascript:selectTSpoints(28067,733,247)">';
mtxt += '<area shape="circle" coords="738,247,3" href="javascript:selectTSpoints(28068,738,247)">';
mtxt += '<area shape="circle" coords="743,247,3" href="javascript:selectTSpoints(28069,743,247)">';
mtxt += '<area shape="circle" coords="748,247,3" href="javascript:selectTSpoints(28070,748,247)">';
mtxt += '<area shape="circle" coords="753,247,3" href="javascript:selectTSpoints(28071,753,247)">';
mtxt += '<area shape="circle" coords="758,247,3" href="javascript:selectTSpoints(28072,758,247)">';
mtxt += '<area shape="circle" coords=" 30,242,3" href="javascript:selectTSpoints(29073, 30,242)">';
mtxt += '<area shape="circle" coords=" 35,242,3" href="javascript:selectTSpoints(29074, 35,242)">';
mtxt += '<area shape="circle" coords=" 40,242,3" href="javascript:selectTSpoints(29075, 40,242)">';
mtxt += '<area shape="circle" coords=" 45,242,3" href="javascript:selectTSpoints(29076, 45,242)">';
mtxt += '<area shape="circle" coords=" 50,242,3" href="javascript:selectTSpoints(29077, 50,242)">';
mtxt += '<area shape="circle" coords=" 56,242,3" href="javascript:selectTSpoints(29078, 56,242)">';
mtxt += '<area shape="circle" coords=" 61,242,3" href="javascript:selectTSpoints(29079, 61,242)">';
mtxt += '<area shape="circle" coords=" 66,242,3" href="javascript:selectTSpoints(29080, 66,242)">';
mtxt += '<area shape="circle" coords=" 71,242,3" href="javascript:selectTSpoints(29081, 71,242)">';
mtxt += '<area shape="circle" coords=" 76,242,3" href="javascript:selectTSpoints(29082, 76,242)">';
mtxt += '<area shape="circle" coords=" 81,242,3" href="javascript:selectTSpoints(29083, 81,242)">';
mtxt += '<area shape="circle" coords=" 86,242,3" href="javascript:selectTSpoints(29084, 86,242)">';
mtxt += '<area shape="circle" coords=" 91,242,3" href="javascript:selectTSpoints(29085, 91,242)">';
mtxt += '<area shape="circle" coords=" 96,242,3" href="javascript:selectTSpoints(29086, 96,242)">';
mtxt += '<area shape="circle" coords="101,242,3" href="javascript:selectTSpoints(29087,101,242)">';
mtxt += '<area shape="circle" coords="106,242,3" href="javascript:selectTSpoints(29088,106,242)">';
mtxt += '<area shape="circle" coords="112,242,3" href="javascript:selectTSpoints(29089,112,242)">';
mtxt += '<area shape="circle" coords="117,242,3" href="javascript:selectTSpoints(29090,117,242)">';
mtxt += '<area shape="circle" coords="122,242,3" href="javascript:selectTSpoints(29091,122,242)">';
mtxt += '<area shape="circle" coords="127,242,3" href="javascript:selectTSpoints(29092,127,242)">';
mtxt += '<area shape="circle" coords="132,242,3" href="javascript:selectTSpoints(29093,132,242)">';
mtxt += '<area shape="circle" coords="137,242,3" href="javascript:selectTSpoints(29094,137,242)">';
mtxt += '<area shape="circle" coords="142,242,3" href="javascript:selectTSpoints(29095,142,242)">';
mtxt += '<area shape="circle" coords="147,242,3" href="javascript:selectTSpoints(29096,147,242)">';
mtxt += '<area shape="circle" coords="152,242,3" href="javascript:selectTSpoints(29097,152,242)">';
mtxt += '<area shape="circle" coords="157,242,3" href="javascript:selectTSpoints(29098,157,242)">';
mtxt += '<area shape="circle" coords="162,242,3" href="javascript:selectTSpoints(29099,162,242)">';
mtxt += '<area shape="circle" coords="168,242,3" href="javascript:selectTSpoints(29100,168,242)">';
mtxt += '<area shape="circle" coords="173,242,3" href="javascript:selectTSpoints(29101,173,242)">';
mtxt += '<area shape="circle" coords="178,242,3" href="javascript:selectTSpoints(29102,178,242)">';
mtxt += '<area shape="circle" coords="183,242,3" href="javascript:selectTSpoints(29103,183,242)">';
mtxt += '<area shape="circle" coords="188,242,3" href="javascript:selectTSpoints(29104,188,242)">';
mtxt += '<area shape="circle" coords="193,242,3" href="javascript:selectTSpoints(29105,193,242)">';
mtxt += '<area shape="circle" coords="198,242,3" href="javascript:selectTSpoints(29106,198,242)">';
mtxt += '<area shape="circle" coords="203,242,3" href="javascript:selectTSpoints(29107,203,242)">';
mtxt += '<area shape="circle" coords="208,242,3" href="javascript:selectTSpoints(29108,208,242)">';
mtxt += '<area shape="circle" coords="213,242,3" href="javascript:selectTSpoints(29109,213,242)">';
mtxt += '<area shape="circle" coords="218,242,3" href="javascript:selectTSpoints(29110,218,242)">';
mtxt += '<area shape="circle" coords="224,242,3" href="javascript:selectTSpoints(29111,224,242)">';
mtxt += '<area shape="circle" coords="229,242,3" href="javascript:selectTSpoints(29112,229,242)">';
mtxt += '<area shape="circle" coords="234,242,3" href="javascript:selectTSpoints(29113,234,242)">';
mtxt += '<area shape="circle" coords="239,242,3" href="javascript:selectTSpoints(29114,239,242)">';
mtxt += '<area shape="circle" coords="244,242,3" href="javascript:selectTSpoints(29115,244,242)">';
mtxt += '<area shape="circle" coords="249,242,3" href="javascript:selectTSpoints(29116,249,242)">';
mtxt += '<area shape="circle" coords="254,242,3" href="javascript:selectTSpoints(29117,254,242)">';
mtxt += '<area shape="circle" coords="259,242,3" href="javascript:selectTSpoints(29118,259,242)">';
mtxt += '<area shape="circle" coords="264,242,3" href="javascript:selectTSpoints(29119,264,242)">';
mtxt += '<area shape="circle" coords="269,242,3" href="javascript:selectTSpoints(29120,269,242)">';
mtxt += '<area shape="circle" coords="274,242,3" href="javascript:selectTSpoints(29121,274,242)">';
mtxt += '<area shape="circle" coords="280,242,3" href="javascript:selectTSpoints(29122,280,242)">';
mtxt += '<area shape="circle" coords="285,242,3" href="javascript:selectTSpoints(29123,285,242)">';
mtxt += '<area shape="circle" coords="290,242,3" href="javascript:selectTSpoints(29124,290,242)">';
mtxt += '<area shape="circle" coords="295,242,3" href="javascript:selectTSpoints(29125,295,242)">';
mtxt += '<area shape="circle" coords="300,242,3" href="javascript:selectTSpoints(29126,300,242)">';
mtxt += '<area shape="circle" coords="305,242,3" href="javascript:selectTSpoints(29127,305,242)">';
mtxt += '<area shape="circle" coords="310,242,3" href="javascript:selectTSpoints(29128,310,242)">';
mtxt += '<area shape="circle" coords="315,242,3" href="javascript:selectTSpoints(29129,315,242)">';
mtxt += '<area shape="circle" coords="320,242,3" href="javascript:selectTSpoints(29130,320,242)">';
mtxt += '<area shape="circle" coords="325,242,3" href="javascript:selectTSpoints(29131,325,242)">';
mtxt += '<area shape="circle" coords="330,242,3" href="javascript:selectTSpoints(29132,330,242)">';
mtxt += '<area shape="circle" coords="336,242,3" href="javascript:selectTSpoints(29133,336,242)">';
mtxt += '<area shape="circle" coords="341,242,3" href="javascript:selectTSpoints(29134,341,242)">';
mtxt += '<area shape="circle" coords="346,242,3" href="javascript:selectTSpoints(29135,346,242)">';
mtxt += '<area shape="circle" coords="351,242,3" href="javascript:selectTSpoints(29136,351,242)">';
mtxt += '<area shape="circle" coords="356,242,3" href="javascript:selectTSpoints(29137,356,242)">';
mtxt += '<area shape="circle" coords="361,242,3" href="javascript:selectTSpoints(29138,361,242)">';
mtxt += '<area shape="circle" coords="366,242,3" href="javascript:selectTSpoints(29139,366,242)">';
mtxt += '<area shape="circle" coords="371,242,3" href="javascript:selectTSpoints(29140,371,242)">';
mtxt += '<area shape="circle" coords="376,242,3" href="javascript:selectTSpoints(29141,376,242)">';
mtxt += '<area shape="circle" coords="381,242,3" href="javascript:selectTSpoints(29142,381,242)">';
mtxt += '<area shape="circle" coords="386,242,3" href="javascript:selectTSpoints(29143,386,242)">';
mtxt += '<area shape="circle" coords="392,242,3" href="javascript:selectTSpoints(29144,392,242)">';
mtxt += '<area shape="circle" coords="397,242,3" href="javascript:selectTSpoints(29001,397,242)">';
mtxt += '<area shape="circle" coords="402,242,3" href="javascript:selectTSpoints(29002,402,242)">';
mtxt += '<area shape="circle" coords="407,242,3" href="javascript:selectTSpoints(29003,407,242)">';
mtxt += '<area shape="circle" coords="412,242,3" href="javascript:selectTSpoints(29004,412,242)">';
mtxt += '<area shape="circle" coords="417,242,3" href="javascript:selectTSpoints(29005,417,242)">';
mtxt += '<area shape="circle" coords="422,242,3" href="javascript:selectTSpoints(29006,422,242)">';
mtxt += '<area shape="circle" coords="427,242,3" href="javascript:selectTSpoints(29007,427,242)">';
mtxt += '<area shape="circle" coords="432,242,3" href="javascript:selectTSpoints(29008,432,242)">';
mtxt += '<area shape="circle" coords="437,242,3" href="javascript:selectTSpoints(29009,437,242)">';
mtxt += '<area shape="circle" coords="442,242,3" href="javascript:selectTSpoints(29010,442,242)">';
mtxt += '<area shape="circle" coords="447,242,3" href="javascript:selectTSpoints(29011,447,242)">';
mtxt += '<area shape="circle" coords="453,242,3" href="javascript:selectTSpoints(29012,453,242)">';
mtxt += '<area shape="circle" coords="458,242,3" href="javascript:selectTSpoints(29013,458,242)">';
mtxt += '<area shape="circle" coords="463,242,3" href="javascript:selectTSpoints(29014,463,242)">';
mtxt += '<area shape="circle" coords="468,242,3" href="javascript:selectTSpoints(29015,468,242)">';
mtxt += '<area shape="circle" coords="473,242,3" href="javascript:selectTSpoints(29016,473,242)">';
mtxt += '<area shape="circle" coords="478,242,3" href="javascript:selectTSpoints(29017,478,242)">';
mtxt += '<area shape="circle" coords="483,242,3" href="javascript:selectTSpoints(29018,483,242)">';
mtxt += '<area shape="circle" coords="488,242,3" href="javascript:selectTSpoints(29019,488,242)">';
mtxt += '<area shape="circle" coords="493,242,3" href="javascript:selectTSpoints(29020,493,242)">';
mtxt += '<area shape="circle" coords="498,242,3" href="javascript:selectTSpoints(29021,498,242)">';
mtxt += '<area shape="circle" coords="503,242,3" href="javascript:selectTSpoints(29022,503,242)">';
mtxt += '<area shape="circle" coords="509,242,3" href="javascript:selectTSpoints(29023,509,242)">';
mtxt += '<area shape="circle" coords="514,242,3" href="javascript:selectTSpoints(29024,514,242)">';
mtxt += '<area shape="circle" coords="519,242,3" href="javascript:selectTSpoints(29025,519,242)">';
mtxt += '<area shape="circle" coords="524,242,3" href="javascript:selectTSpoints(29026,524,242)">';
mtxt += '<area shape="circle" coords="529,242,3" href="javascript:selectTSpoints(29027,529,242)">';
mtxt += '<area shape="circle" coords="534,242,3" href="javascript:selectTSpoints(29028,534,242)">';
mtxt += '<area shape="circle" coords="539,242,3" href="javascript:selectTSpoints(29029,539,242)">';
mtxt += '<area shape="circle" coords="544,242,3" href="javascript:selectTSpoints(29030,544,242)">';
mtxt += '<area shape="circle" coords="549,242,3" href="javascript:selectTSpoints(29031,549,242)">';
mtxt += '<area shape="circle" coords="554,242,3" href="javascript:selectTSpoints(29032,554,242)">';
mtxt += '<area shape="circle" coords="559,242,3" href="javascript:selectTSpoints(29033,559,242)">';
mtxt += '<area shape="circle" coords="565,242,3" href="javascript:selectTSpoints(29034,565,242)">';
mtxt += '<area shape="circle" coords="570,242,3" href="javascript:selectTSpoints(29035,570,242)">';
mtxt += '<area shape="circle" coords="575,242,3" href="javascript:selectTSpoints(29036,575,242)">';
mtxt += '<area shape="circle" coords="580,242,3" href="javascript:selectTSpoints(29037,580,242)">';
mtxt += '<area shape="circle" coords="585,242,3" href="javascript:selectTSpoints(29038,585,242)">';
mtxt += '<area shape="circle" coords="590,242,3" href="javascript:selectTSpoints(29039,590,242)">';
mtxt += '<area shape="circle" coords="595,242,3" href="javascript:selectTSpoints(29040,595,242)">';
mtxt += '<area shape="circle" coords="600,242,3" href="javascript:selectTSpoints(29041,600,242)">';
mtxt += '<area shape="circle" coords="605,242,3" href="javascript:selectTSpoints(29042,605,242)">';
mtxt += '<area shape="circle" coords="610,242,3" href="javascript:selectTSpoints(29043,610,242)">';
mtxt += '<area shape="circle" coords="615,242,3" href="javascript:selectTSpoints(29044,615,242)">';
mtxt += '<area shape="circle" coords="621,242,3" href="javascript:selectTSpoints(29045,621,242)">';
mtxt += '<area shape="circle" coords="626,242,3" href="javascript:selectTSpoints(29046,626,242)">';
mtxt += '<area shape="circle" coords="631,242,3" href="javascript:selectTSpoints(29047,631,242)">';
mtxt += '<area shape="circle" coords="636,242,3" href="javascript:selectTSpoints(29048,636,242)">';
mtxt += '<area shape="circle" coords="641,242,3" href="javascript:selectTSpoints(29049,641,242)">';
mtxt += '<area shape="circle" coords="646,242,3" href="javascript:selectTSpoints(29050,646,242)">';
mtxt += '<area shape="circle" coords="651,242,3" href="javascript:selectTSpoints(29051,651,242)">';
mtxt += '<area shape="circle" coords="656,242,3" href="javascript:selectTSpoints(29052,656,242)">';
mtxt += '<area shape="circle" coords="661,242,3" href="javascript:selectTSpoints(29053,661,242)">';
mtxt += '<area shape="circle" coords="666,242,3" href="javascript:selectTSpoints(29054,666,242)">';
mtxt += '<area shape="circle" coords="671,242,3" href="javascript:selectTSpoints(29055,671,242)">';
mtxt += '<area shape="circle" coords="677,242,3" href="javascript:selectTSpoints(29056,677,242)">';
mtxt += '<area shape="circle" coords="682,242,3" href="javascript:selectTSpoints(29057,682,242)">';
mtxt += '<area shape="circle" coords="687,242,3" href="javascript:selectTSpoints(29058,687,242)">';
mtxt += '<area shape="circle" coords="692,242,3" href="javascript:selectTSpoints(29059,692,242)">';
mtxt += '<area shape="circle" coords="697,242,3" href="javascript:selectTSpoints(29060,697,242)">';
mtxt += '<area shape="circle" coords="702,242,3" href="javascript:selectTSpoints(29061,702,242)">';
mtxt += '<area shape="circle" coords="707,242,3" href="javascript:selectTSpoints(29062,707,242)">';
mtxt += '<area shape="circle" coords="712,242,3" href="javascript:selectTSpoints(29063,712,242)">';
mtxt += '<area shape="circle" coords="717,242,3" href="javascript:selectTSpoints(29064,717,242)">';
mtxt += '<area shape="circle" coords="722,242,3" href="javascript:selectTSpoints(29065,722,242)">';
mtxt += '<area shape="circle" coords="727,242,3" href="javascript:selectTSpoints(29066,727,242)">';
mtxt += '<area shape="circle" coords="733,242,3" href="javascript:selectTSpoints(29067,733,242)">';
mtxt += '<area shape="circle" coords="738,242,3" href="javascript:selectTSpoints(29068,738,242)">';
mtxt += '<area shape="circle" coords="743,242,3" href="javascript:selectTSpoints(29069,743,242)">';
mtxt += '<area shape="circle" coords="748,242,3" href="javascript:selectTSpoints(29070,748,242)">';
mtxt += '<area shape="circle" coords="753,242,3" href="javascript:selectTSpoints(29071,753,242)">';
mtxt += '<area shape="circle" coords="758,242,3" href="javascript:selectTSpoints(29072,758,242)">';
mtxt += '<area shape="circle" coords=" 30,237,3" href="javascript:selectTSpoints(30073, 30,237)">';
mtxt += '<area shape="circle" coords=" 35,237,3" href="javascript:selectTSpoints(30074, 35,237)">';
mtxt += '<area shape="circle" coords=" 40,237,3" href="javascript:selectTSpoints(30075, 40,237)">';
mtxt += '<area shape="circle" coords=" 45,237,3" href="javascript:selectTSpoints(30076, 45,237)">';
mtxt += '<area shape="circle" coords=" 50,237,3" href="javascript:selectTSpoints(30077, 50,237)">';
mtxt += '<area shape="circle" coords=" 56,237,3" href="javascript:selectTSpoints(30078, 56,237)">';
mtxt += '<area shape="circle" coords=" 61,237,3" href="javascript:selectTSpoints(30079, 61,237)">';
mtxt += '<area shape="circle" coords=" 66,237,3" href="javascript:selectTSpoints(30080, 66,237)">';
mtxt += '<area shape="circle" coords=" 71,237,3" href="javascript:selectTSpoints(30081, 71,237)">';
mtxt += '<area shape="circle" coords=" 76,237,3" href="javascript:selectTSpoints(30082, 76,237)">';
mtxt += '<area shape="circle" coords=" 81,237,3" href="javascript:selectTSpoints(30083, 81,237)">';
mtxt += '<area shape="circle" coords=" 86,237,3" href="javascript:selectTSpoints(30084, 86,237)">';
mtxt += '<area shape="circle" coords=" 91,237,3" href="javascript:selectTSpoints(30085, 91,237)">';
mtxt += '<area shape="circle" coords=" 96,237,3" href="javascript:selectTSpoints(30086, 96,237)">';
mtxt += '<area shape="circle" coords="101,237,3" href="javascript:selectTSpoints(30087,101,237)">';
mtxt += '<area shape="circle" coords="106,237,3" href="javascript:selectTSpoints(30088,106,237)">';
mtxt += '<area shape="circle" coords="112,237,3" href="javascript:selectTSpoints(30089,112,237)">';
mtxt += '<area shape="circle" coords="117,237,3" href="javascript:selectTSpoints(30090,117,237)">';
mtxt += '<area shape="circle" coords="122,237,3" href="javascript:selectTSpoints(30091,122,237)">';
mtxt += '<area shape="circle" coords="127,237,3" href="javascript:selectTSpoints(30092,127,237)">';
mtxt += '<area shape="circle" coords="132,237,3" href="javascript:selectTSpoints(30093,132,237)">';
mtxt += '<area shape="circle" coords="137,237,3" href="javascript:selectTSpoints(30094,137,237)">';
mtxt += '<area shape="circle" coords="142,237,3" href="javascript:selectTSpoints(30095,142,237)">';
mtxt += '<area shape="circle" coords="147,237,3" href="javascript:selectTSpoints(30096,147,237)">';
mtxt += '<area shape="circle" coords="152,237,3" href="javascript:selectTSpoints(30097,152,237)">';
mtxt += '<area shape="circle" coords="157,237,3" href="javascript:selectTSpoints(30098,157,237)">';
mtxt += '<area shape="circle" coords="162,237,3" href="javascript:selectTSpoints(30099,162,237)">';
mtxt += '<area shape="circle" coords="168,237,3" href="javascript:selectTSpoints(30100,168,237)">';
mtxt += '<area shape="circle" coords="173,237,3" href="javascript:selectTSpoints(30101,173,237)">';
mtxt += '<area shape="circle" coords="178,237,3" href="javascript:selectTSpoints(30102,178,237)">';
mtxt += '<area shape="circle" coords="183,237,3" href="javascript:selectTSpoints(30103,183,237)">';
mtxt += '<area shape="circle" coords="188,237,3" href="javascript:selectTSpoints(30104,188,237)">';
mtxt += '<area shape="circle" coords="193,237,3" href="javascript:selectTSpoints(30105,193,237)">';
mtxt += '<area shape="circle" coords="198,237,3" href="javascript:selectTSpoints(30106,198,237)">';
mtxt += '<area shape="circle" coords="203,237,3" href="javascript:selectTSpoints(30107,203,237)">';
mtxt += '<area shape="circle" coords="208,237,3" href="javascript:selectTSpoints(30108,208,237)">';
mtxt += '<area shape="circle" coords="213,237,3" href="javascript:selectTSpoints(30109,213,237)">';
mtxt += '<area shape="circle" coords="218,237,3" href="javascript:selectTSpoints(30110,218,237)">';
mtxt += '<area shape="circle" coords="224,237,3" href="javascript:selectTSpoints(30111,224,237)">';
mtxt += '<area shape="circle" coords="229,237,3" href="javascript:selectTSpoints(30112,229,237)">';
mtxt += '<area shape="circle" coords="234,237,3" href="javascript:selectTSpoints(30113,234,237)">';
mtxt += '<area shape="circle" coords="239,237,3" href="javascript:selectTSpoints(30114,239,237)">';
mtxt += '<area shape="circle" coords="244,237,3" href="javascript:selectTSpoints(30115,244,237)">';
mtxt += '<area shape="circle" coords="249,237,3" href="javascript:selectTSpoints(30116,249,237)">';
mtxt += '<area shape="circle" coords="254,237,3" href="javascript:selectTSpoints(30117,254,237)">';
mtxt += '<area shape="circle" coords="259,237,3" href="javascript:selectTSpoints(30118,259,237)">';
mtxt += '<area shape="circle" coords="264,237,3" href="javascript:selectTSpoints(30119,264,237)">';
mtxt += '<area shape="circle" coords="269,237,3" href="javascript:selectTSpoints(30120,269,237)">';
mtxt += '<area shape="circle" coords="274,237,3" href="javascript:selectTSpoints(30121,274,237)">';
mtxt += '<area shape="circle" coords="280,237,3" href="javascript:selectTSpoints(30122,280,237)">';
mtxt += '<area shape="circle" coords="285,237,3" href="javascript:selectTSpoints(30123,285,237)">';
mtxt += '<area shape="circle" coords="290,237,3" href="javascript:selectTSpoints(30124,290,237)">';
mtxt += '<area shape="circle" coords="295,237,3" href="javascript:selectTSpoints(30125,295,237)">';
mtxt += '<area shape="circle" coords="300,237,3" href="javascript:selectTSpoints(30126,300,237)">';
mtxt += '<area shape="circle" coords="305,237,3" href="javascript:selectTSpoints(30127,305,237)">';
mtxt += '<area shape="circle" coords="310,237,3" href="javascript:selectTSpoints(30128,310,237)">';
mtxt += '<area shape="circle" coords="315,237,3" href="javascript:selectTSpoints(30129,315,237)">';
mtxt += '<area shape="circle" coords="320,237,3" href="javascript:selectTSpoints(30130,320,237)">';
mtxt += '<area shape="circle" coords="325,237,3" href="javascript:selectTSpoints(30131,325,237)">';
mtxt += '<area shape="circle" coords="330,237,3" href="javascript:selectTSpoints(30132,330,237)">';
mtxt += '<area shape="circle" coords="336,237,3" href="javascript:selectTSpoints(30133,336,237)">';
mtxt += '<area shape="circle" coords="341,237,3" href="javascript:selectTSpoints(30134,341,237)">';
mtxt += '<area shape="circle" coords="346,237,3" href="javascript:selectTSpoints(30135,346,237)">';
mtxt += '<area shape="circle" coords="351,237,3" href="javascript:selectTSpoints(30136,351,237)">';
mtxt += '<area shape="circle" coords="356,237,3" href="javascript:selectTSpoints(30137,356,237)">';
mtxt += '<area shape="circle" coords="361,237,3" href="javascript:selectTSpoints(30138,361,237)">';
mtxt += '<area shape="circle" coords="366,237,3" href="javascript:selectTSpoints(30139,366,237)">';
mtxt += '<area shape="circle" coords="371,237,3" href="javascript:selectTSpoints(30140,371,237)">';
mtxt += '<area shape="circle" coords="376,237,3" href="javascript:selectTSpoints(30141,376,237)">';
mtxt += '<area shape="circle" coords="381,237,3" href="javascript:selectTSpoints(30142,381,237)">';
mtxt += '<area shape="circle" coords="386,237,3" href="javascript:selectTSpoints(30143,386,237)">';
mtxt += '<area shape="circle" coords="392,237,3" href="javascript:selectTSpoints(30144,392,237)">';
mtxt += '<area shape="circle" coords="397,237,3" href="javascript:selectTSpoints(30001,397,237)">';
mtxt += '<area shape="circle" coords="402,237,3" href="javascript:selectTSpoints(30002,402,237)">';
mtxt += '<area shape="circle" coords="407,237,3" href="javascript:selectTSpoints(30003,407,237)">';
mtxt += '<area shape="circle" coords="412,237,3" href="javascript:selectTSpoints(30004,412,237)">';
mtxt += '<area shape="circle" coords="417,237,3" href="javascript:selectTSpoints(30005,417,237)">';
mtxt += '<area shape="circle" coords="422,237,3" href="javascript:selectTSpoints(30006,422,237)">';
mtxt += '<area shape="circle" coords="427,237,3" href="javascript:selectTSpoints(30007,427,237)">';
mtxt += '<area shape="circle" coords="432,237,3" href="javascript:selectTSpoints(30008,432,237)">';
mtxt += '<area shape="circle" coords="437,237,3" href="javascript:selectTSpoints(30009,437,237)">';
mtxt += '<area shape="circle" coords="442,237,3" href="javascript:selectTSpoints(30010,442,237)">';
mtxt += '<area shape="circle" coords="447,237,3" href="javascript:selectTSpoints(30011,447,237)">';
mtxt += '<area shape="circle" coords="453,237,3" href="javascript:selectTSpoints(30012,453,237)">';
mtxt += '<area shape="circle" coords="458,237,3" href="javascript:selectTSpoints(30013,458,237)">';
mtxt += '<area shape="circle" coords="463,237,3" href="javascript:selectTSpoints(30014,463,237)">';
mtxt += '<area shape="circle" coords="468,237,3" href="javascript:selectTSpoints(30015,468,237)">';
mtxt += '<area shape="circle" coords="473,237,3" href="javascript:selectTSpoints(30016,473,237)">';
mtxt += '<area shape="circle" coords="478,237,3" href="javascript:selectTSpoints(30017,478,237)">';
mtxt += '<area shape="circle" coords="483,237,3" href="javascript:selectTSpoints(30018,483,237)">';
mtxt += '<area shape="circle" coords="488,237,3" href="javascript:selectTSpoints(30019,488,237)">';
mtxt += '<area shape="circle" coords="493,237,3" href="javascript:selectTSpoints(30020,493,237)">';
mtxt += '<area shape="circle" coords="498,237,3" href="javascript:selectTSpoints(30021,498,237)">';
mtxt += '<area shape="circle" coords="503,237,3" href="javascript:selectTSpoints(30022,503,237)">';
mtxt += '<area shape="circle" coords="509,237,3" href="javascript:selectTSpoints(30023,509,237)">';
mtxt += '<area shape="circle" coords="514,237,3" href="javascript:selectTSpoints(30024,514,237)">';
mtxt += '<area shape="circle" coords="519,237,3" href="javascript:selectTSpoints(30025,519,237)">';
mtxt += '<area shape="circle" coords="524,237,3" href="javascript:selectTSpoints(30026,524,237)">';
mtxt += '<area shape="circle" coords="529,237,3" href="javascript:selectTSpoints(30027,529,237)">';
mtxt += '<area shape="circle" coords="534,237,3" href="javascript:selectTSpoints(30028,534,237)">';
mtxt += '<area shape="circle" coords="539,237,3" href="javascript:selectTSpoints(30029,539,237)">';
mtxt += '<area shape="circle" coords="544,237,3" href="javascript:selectTSpoints(30030,544,237)">';
mtxt += '<area shape="circle" coords="549,237,3" href="javascript:selectTSpoints(30031,549,237)">';
mtxt += '<area shape="circle" coords="554,237,3" href="javascript:selectTSpoints(30032,554,237)">';
mtxt += '<area shape="circle" coords="559,237,3" href="javascript:selectTSpoints(30033,559,237)">';
mtxt += '<area shape="circle" coords="565,237,3" href="javascript:selectTSpoints(30034,565,237)">';
mtxt += '<area shape="circle" coords="570,237,3" href="javascript:selectTSpoints(30035,570,237)">';
mtxt += '<area shape="circle" coords="575,237,3" href="javascript:selectTSpoints(30036,575,237)">';
mtxt += '<area shape="circle" coords="580,237,3" href="javascript:selectTSpoints(30037,580,237)">';
mtxt += '<area shape="circle" coords="585,237,3" href="javascript:selectTSpoints(30038,585,237)">';
mtxt += '<area shape="circle" coords="590,237,3" href="javascript:selectTSpoints(30039,590,237)">';
mtxt += '<area shape="circle" coords="595,237,3" href="javascript:selectTSpoints(30040,595,237)">';
mtxt += '<area shape="circle" coords="600,237,3" href="javascript:selectTSpoints(30041,600,237)">';
mtxt += '<area shape="circle" coords="605,237,3" href="javascript:selectTSpoints(30042,605,237)">';
mtxt += '<area shape="circle" coords="610,237,3" href="javascript:selectTSpoints(30043,610,237)">';
mtxt += '<area shape="circle" coords="615,237,3" href="javascript:selectTSpoints(30044,615,237)">';
mtxt += '<area shape="circle" coords="621,237,3" href="javascript:selectTSpoints(30045,621,237)">';
mtxt += '<area shape="circle" coords="626,237,3" href="javascript:selectTSpoints(30046,626,237)">';
mtxt += '<area shape="circle" coords="631,237,3" href="javascript:selectTSpoints(30047,631,237)">';
mtxt += '<area shape="circle" coords="636,237,3" href="javascript:selectTSpoints(30048,636,237)">';
mtxt += '<area shape="circle" coords="641,237,3" href="javascript:selectTSpoints(30049,641,237)">';
mtxt += '<area shape="circle" coords="646,237,3" href="javascript:selectTSpoints(30050,646,237)">';
mtxt += '<area shape="circle" coords="651,237,3" href="javascript:selectTSpoints(30051,651,237)">';
mtxt += '<area shape="circle" coords="656,237,3" href="javascript:selectTSpoints(30052,656,237)">';
mtxt += '<area shape="circle" coords="661,237,3" href="javascript:selectTSpoints(30053,661,237)">';
mtxt += '<area shape="circle" coords="666,237,3" href="javascript:selectTSpoints(30054,666,237)">';
mtxt += '<area shape="circle" coords="671,237,3" href="javascript:selectTSpoints(30055,671,237)">';
mtxt += '<area shape="circle" coords="677,237,3" href="javascript:selectTSpoints(30056,677,237)">';
mtxt += '<area shape="circle" coords="682,237,3" href="javascript:selectTSpoints(30057,682,237)">';
mtxt += '<area shape="circle" coords="687,237,3" href="javascript:selectTSpoints(30058,687,237)">';
mtxt += '<area shape="circle" coords="692,237,3" href="javascript:selectTSpoints(30059,692,237)">';
mtxt += '<area shape="circle" coords="697,237,3" href="javascript:selectTSpoints(30060,697,237)">';
mtxt += '<area shape="circle" coords="702,237,3" href="javascript:selectTSpoints(30061,702,237)">';
mtxt += '<area shape="circle" coords="707,237,3" href="javascript:selectTSpoints(30062,707,237)">';
mtxt += '<area shape="circle" coords="712,237,3" href="javascript:selectTSpoints(30063,712,237)">';
mtxt += '<area shape="circle" coords="717,237,3" href="javascript:selectTSpoints(30064,717,237)">';
mtxt += '<area shape="circle" coords="722,237,3" href="javascript:selectTSpoints(30065,722,237)">';
mtxt += '<area shape="circle" coords="727,237,3" href="javascript:selectTSpoints(30066,727,237)">';
mtxt += '<area shape="circle" coords="733,237,3" href="javascript:selectTSpoints(30067,733,237)">';
mtxt += '<area shape="circle" coords="738,237,3" href="javascript:selectTSpoints(30068,738,237)">';
mtxt += '<area shape="circle" coords="743,237,3" href="javascript:selectTSpoints(30069,743,237)">';
mtxt += '<area shape="circle" coords="748,237,3" href="javascript:selectTSpoints(30070,748,237)">';
mtxt += '<area shape="circle" coords="753,237,3" href="javascript:selectTSpoints(30071,753,237)">';
mtxt += '<area shape="circle" coords="758,237,3" href="javascript:selectTSpoints(30072,758,237)">';
mtxt += '<area shape="circle" coords=" 30,232,3" href="javascript:selectTSpoints(31073, 30,232)">';
mtxt += '<area shape="circle" coords=" 35,232,3" href="javascript:selectTSpoints(31074, 35,232)">';
mtxt += '<area shape="circle" coords=" 40,232,3" href="javascript:selectTSpoints(31075, 40,232)">';
mtxt += '<area shape="circle" coords=" 45,232,3" href="javascript:selectTSpoints(31076, 45,232)">';
mtxt += '<area shape="circle" coords=" 50,232,3" href="javascript:selectTSpoints(31077, 50,232)">';
mtxt += '<area shape="circle" coords=" 56,232,3" href="javascript:selectTSpoints(31078, 56,232)">';
mtxt += '<area shape="circle" coords=" 61,232,3" href="javascript:selectTSpoints(31079, 61,232)">';
mtxt += '<area shape="circle" coords=" 66,232,3" href="javascript:selectTSpoints(31080, 66,232)">';
mtxt += '<area shape="circle" coords=" 71,232,3" href="javascript:selectTSpoints(31081, 71,232)">';
mtxt += '<area shape="circle" coords=" 76,232,3" href="javascript:selectTSpoints(31082, 76,232)">';
mtxt += '<area shape="circle" coords=" 81,232,3" href="javascript:selectTSpoints(31083, 81,232)">';
mtxt += '<area shape="circle" coords=" 86,232,3" href="javascript:selectTSpoints(31084, 86,232)">';
mtxt += '<area shape="circle" coords=" 91,232,3" href="javascript:selectTSpoints(31085, 91,232)">';
mtxt += '<area shape="circle" coords=" 96,232,3" href="javascript:selectTSpoints(31086, 96,232)">';
mtxt += '<area shape="circle" coords="101,232,3" href="javascript:selectTSpoints(31087,101,232)">';
mtxt += '<area shape="circle" coords="106,232,3" href="javascript:selectTSpoints(31088,106,232)">';
mtxt += '<area shape="circle" coords="112,232,3" href="javascript:selectTSpoints(31089,112,232)">';
mtxt += '<area shape="circle" coords="117,232,3" href="javascript:selectTSpoints(31090,117,232)">';
mtxt += '<area shape="circle" coords="122,232,3" href="javascript:selectTSpoints(31091,122,232)">';
mtxt += '<area shape="circle" coords="127,232,3" href="javascript:selectTSpoints(31092,127,232)">';
mtxt += '<area shape="circle" coords="132,232,3" href="javascript:selectTSpoints(31093,132,232)">';
mtxt += '<area shape="circle" coords="137,232,3" href="javascript:selectTSpoints(31094,137,232)">';
mtxt += '<area shape="circle" coords="142,232,3" href="javascript:selectTSpoints(31095,142,232)">';
mtxt += '<area shape="circle" coords="147,232,3" href="javascript:selectTSpoints(31096,147,232)">';
mtxt += '<area shape="circle" coords="152,232,3" href="javascript:selectTSpoints(31097,152,232)">';
mtxt += '<area shape="circle" coords="157,232,3" href="javascript:selectTSpoints(31098,157,232)">';
mtxt += '<area shape="circle" coords="162,232,3" href="javascript:selectTSpoints(31099,162,232)">';
mtxt += '<area shape="circle" coords="168,232,3" href="javascript:selectTSpoints(31100,168,232)">';
mtxt += '<area shape="circle" coords="173,232,3" href="javascript:selectTSpoints(31101,173,232)">';
mtxt += '<area shape="circle" coords="178,232,3" href="javascript:selectTSpoints(31102,178,232)">';
mtxt += '<area shape="circle" coords="183,232,3" href="javascript:selectTSpoints(31103,183,232)">';
mtxt += '<area shape="circle" coords="188,232,3" href="javascript:selectTSpoints(31104,188,232)">';
mtxt += '<area shape="circle" coords="193,232,3" href="javascript:selectTSpoints(31105,193,232)">';
mtxt += '<area shape="circle" coords="198,232,3" href="javascript:selectTSpoints(31106,198,232)">';
mtxt += '<area shape="circle" coords="203,232,3" href="javascript:selectTSpoints(31107,203,232)">';
mtxt += '<area shape="circle" coords="208,232,3" href="javascript:selectTSpoints(31108,208,232)">';
mtxt += '<area shape="circle" coords="213,232,3" href="javascript:selectTSpoints(31109,213,232)">';
mtxt += '<area shape="circle" coords="218,232,3" href="javascript:selectTSpoints(31110,218,232)">';
mtxt += '<area shape="circle" coords="224,232,3" href="javascript:selectTSpoints(31111,224,232)">';
mtxt += '<area shape="circle" coords="229,232,3" href="javascript:selectTSpoints(31112,229,232)">';
mtxt += '<area shape="circle" coords="234,232,3" href="javascript:selectTSpoints(31113,234,232)">';
mtxt += '<area shape="circle" coords="239,232,3" href="javascript:selectTSpoints(31114,239,232)">';
mtxt += '<area shape="circle" coords="244,232,3" href="javascript:selectTSpoints(31115,244,232)">';
mtxt += '<area shape="circle" coords="249,232,3" href="javascript:selectTSpoints(31116,249,232)">';
mtxt += '<area shape="circle" coords="254,232,3" href="javascript:selectTSpoints(31117,254,232)">';
mtxt += '<area shape="circle" coords="259,232,3" href="javascript:selectTSpoints(31118,259,232)">';
mtxt += '<area shape="circle" coords="264,232,3" href="javascript:selectTSpoints(31119,264,232)">';
mtxt += '<area shape="circle" coords="269,232,3" href="javascript:selectTSpoints(31120,269,232)">';
mtxt += '<area shape="circle" coords="274,232,3" href="javascript:selectTSpoints(31121,274,232)">';
mtxt += '<area shape="circle" coords="280,232,3" href="javascript:selectTSpoints(31122,280,232)">';
mtxt += '<area shape="circle" coords="285,232,3" href="javascript:selectTSpoints(31123,285,232)">';
mtxt += '<area shape="circle" coords="290,232,3" href="javascript:selectTSpoints(31124,290,232)">';
mtxt += '<area shape="circle" coords="295,232,3" href="javascript:selectTSpoints(31125,295,232)">';
mtxt += '<area shape="circle" coords="300,232,3" href="javascript:selectTSpoints(31126,300,232)">';
mtxt += '<area shape="circle" coords="305,232,3" href="javascript:selectTSpoints(31127,305,232)">';
mtxt += '<area shape="circle" coords="310,232,3" href="javascript:selectTSpoints(31128,310,232)">';
mtxt += '<area shape="circle" coords="315,232,3" href="javascript:selectTSpoints(31129,315,232)">';
mtxt += '<area shape="circle" coords="320,232,3" href="javascript:selectTSpoints(31130,320,232)">';
mtxt += '<area shape="circle" coords="325,232,3" href="javascript:selectTSpoints(31131,325,232)">';
mtxt += '<area shape="circle" coords="330,232,3" href="javascript:selectTSpoints(31132,330,232)">';
mtxt += '<area shape="circle" coords="336,232,3" href="javascript:selectTSpoints(31133,336,232)">';
mtxt += '<area shape="circle" coords="341,232,3" href="javascript:selectTSpoints(31134,341,232)">';
mtxt += '<area shape="circle" coords="346,232,3" href="javascript:selectTSpoints(31135,346,232)">';
mtxt += '<area shape="circle" coords="351,232,3" href="javascript:selectTSpoints(31136,351,232)">';
mtxt += '<area shape="circle" coords="356,232,3" href="javascript:selectTSpoints(31137,356,232)">';
mtxt += '<area shape="circle" coords="361,232,3" href="javascript:selectTSpoints(31138,361,232)">';
mtxt += '<area shape="circle" coords="366,232,3" href="javascript:selectTSpoints(31139,366,232)">';
mtxt += '<area shape="circle" coords="371,232,3" href="javascript:selectTSpoints(31140,371,232)">';
mtxt += '<area shape="circle" coords="376,232,3" href="javascript:selectTSpoints(31141,376,232)">';
mtxt += '<area shape="circle" coords="381,232,3" href="javascript:selectTSpoints(31142,381,232)">';
mtxt += '<area shape="circle" coords="386,232,3" href="javascript:selectTSpoints(31143,386,232)">';
mtxt += '<area shape="circle" coords="392,232,3" href="javascript:selectTSpoints(31144,392,232)">';
mtxt += '<area shape="circle" coords="397,232,3" href="javascript:selectTSpoints(31001,397,232)">';
mtxt += '<area shape="circle" coords="402,232,3" href="javascript:selectTSpoints(31002,402,232)">';
mtxt += '<area shape="circle" coords="407,232,3" href="javascript:selectTSpoints(31003,407,232)">';
mtxt += '<area shape="circle" coords="412,232,3" href="javascript:selectTSpoints(31004,412,232)">';
mtxt += '<area shape="circle" coords="417,232,3" href="javascript:selectTSpoints(31005,417,232)">';
mtxt += '<area shape="circle" coords="422,232,3" href="javascript:selectTSpoints(31006,422,232)">';
mtxt += '<area shape="circle" coords="427,232,3" href="javascript:selectTSpoints(31007,427,232)">';
mtxt += '<area shape="circle" coords="432,232,3" href="javascript:selectTSpoints(31008,432,232)">';
mtxt += '<area shape="circle" coords="437,232,3" href="javascript:selectTSpoints(31009,437,232)">';
mtxt += '<area shape="circle" coords="442,232,3" href="javascript:selectTSpoints(31010,442,232)">';
mtxt += '<area shape="circle" coords="447,232,3" href="javascript:selectTSpoints(31011,447,232)">';
mtxt += '<area shape="circle" coords="453,232,3" href="javascript:selectTSpoints(31012,453,232)">';
mtxt += '<area shape="circle" coords="458,232,3" href="javascript:selectTSpoints(31013,458,232)">';
mtxt += '<area shape="circle" coords="463,232,3" href="javascript:selectTSpoints(31014,463,232)">';
mtxt += '<area shape="circle" coords="468,232,3" href="javascript:selectTSpoints(31015,468,232)">';
mtxt += '<area shape="circle" coords="473,232,3" href="javascript:selectTSpoints(31016,473,232)">';
mtxt += '<area shape="circle" coords="478,232,3" href="javascript:selectTSpoints(31017,478,232)">';
mtxt += '<area shape="circle" coords="483,232,3" href="javascript:selectTSpoints(31018,483,232)">';
mtxt += '<area shape="circle" coords="488,232,3" href="javascript:selectTSpoints(31019,488,232)">';
mtxt += '<area shape="circle" coords="493,232,3" href="javascript:selectTSpoints(31020,493,232)">';
mtxt += '<area shape="circle" coords="498,232,3" href="javascript:selectTSpoints(31021,498,232)">';
mtxt += '<area shape="circle" coords="503,232,3" href="javascript:selectTSpoints(31022,503,232)">';
mtxt += '<area shape="circle" coords="509,232,3" href="javascript:selectTSpoints(31023,509,232)">';
mtxt += '<area shape="circle" coords="514,232,3" href="javascript:selectTSpoints(31024,514,232)">';
mtxt += '<area shape="circle" coords="519,232,3" href="javascript:selectTSpoints(31025,519,232)">';
mtxt += '<area shape="circle" coords="524,232,3" href="javascript:selectTSpoints(31026,524,232)">';
mtxt += '<area shape="circle" coords="529,232,3" href="javascript:selectTSpoints(31027,529,232)">';
mtxt += '<area shape="circle" coords="534,232,3" href="javascript:selectTSpoints(31028,534,232)">';
mtxt += '<area shape="circle" coords="539,232,3" href="javascript:selectTSpoints(31029,539,232)">';
mtxt += '<area shape="circle" coords="544,232,3" href="javascript:selectTSpoints(31030,544,232)">';
mtxt += '<area shape="circle" coords="549,232,3" href="javascript:selectTSpoints(31031,549,232)">';
mtxt += '<area shape="circle" coords="554,232,3" href="javascript:selectTSpoints(31032,554,232)">';
mtxt += '<area shape="circle" coords="559,232,3" href="javascript:selectTSpoints(31033,559,232)">';
mtxt += '<area shape="circle" coords="565,232,3" href="javascript:selectTSpoints(31034,565,232)">';
mtxt += '<area shape="circle" coords="570,232,3" href="javascript:selectTSpoints(31035,570,232)">';
mtxt += '<area shape="circle" coords="575,232,3" href="javascript:selectTSpoints(31036,575,232)">';
mtxt += '<area shape="circle" coords="580,232,3" href="javascript:selectTSpoints(31037,580,232)">';
mtxt += '<area shape="circle" coords="585,232,3" href="javascript:selectTSpoints(31038,585,232)">';
mtxt += '<area shape="circle" coords="590,232,3" href="javascript:selectTSpoints(31039,590,232)">';
mtxt += '<area shape="circle" coords="595,232,3" href="javascript:selectTSpoints(31040,595,232)">';
mtxt += '<area shape="circle" coords="600,232,3" href="javascript:selectTSpoints(31041,600,232)">';
mtxt += '<area shape="circle" coords="605,232,3" href="javascript:selectTSpoints(31042,605,232)">';
mtxt += '<area shape="circle" coords="610,232,3" href="javascript:selectTSpoints(31043,610,232)">';
mtxt += '<area shape="circle" coords="615,232,3" href="javascript:selectTSpoints(31044,615,232)">';
mtxt += '<area shape="circle" coords="621,232,3" href="javascript:selectTSpoints(31045,621,232)">';
mtxt += '<area shape="circle" coords="626,232,3" href="javascript:selectTSpoints(31046,626,232)">';
mtxt += '<area shape="circle" coords="631,232,3" href="javascript:selectTSpoints(31047,631,232)">';
mtxt += '<area shape="circle" coords="636,232,3" href="javascript:selectTSpoints(31048,636,232)">';
mtxt += '<area shape="circle" coords="641,232,3" href="javascript:selectTSpoints(31049,641,232)">';
mtxt += '<area shape="circle" coords="646,232,3" href="javascript:selectTSpoints(31050,646,232)">';
mtxt += '<area shape="circle" coords="651,232,3" href="javascript:selectTSpoints(31051,651,232)">';
mtxt += '<area shape="circle" coords="656,232,3" href="javascript:selectTSpoints(31052,656,232)">';
mtxt += '<area shape="circle" coords="661,232,3" href="javascript:selectTSpoints(31053,661,232)">';
mtxt += '<area shape="circle" coords="666,232,3" href="javascript:selectTSpoints(31054,666,232)">';
mtxt += '<area shape="circle" coords="671,232,3" href="javascript:selectTSpoints(31055,671,232)">';
mtxt += '<area shape="circle" coords="677,232,3" href="javascript:selectTSpoints(31056,677,232)">';
mtxt += '<area shape="circle" coords="682,232,3" href="javascript:selectTSpoints(31057,682,232)">';
mtxt += '<area shape="circle" coords="687,232,3" href="javascript:selectTSpoints(31058,687,232)">';
mtxt += '<area shape="circle" coords="692,232,3" href="javascript:selectTSpoints(31059,692,232)">';
mtxt += '<area shape="circle" coords="697,232,3" href="javascript:selectTSpoints(31060,697,232)">';
mtxt += '<area shape="circle" coords="702,232,3" href="javascript:selectTSpoints(31061,702,232)">';
mtxt += '<area shape="circle" coords="707,232,3" href="javascript:selectTSpoints(31062,707,232)">';
mtxt += '<area shape="circle" coords="712,232,3" href="javascript:selectTSpoints(31063,712,232)">';
mtxt += '<area shape="circle" coords="717,232,3" href="javascript:selectTSpoints(31064,717,232)">';
mtxt += '<area shape="circle" coords="722,232,3" href="javascript:selectTSpoints(31065,722,232)">';
mtxt += '<area shape="circle" coords="727,232,3" href="javascript:selectTSpoints(31066,727,232)">';
mtxt += '<area shape="circle" coords="733,232,3" href="javascript:selectTSpoints(31067,733,232)">';
mtxt += '<area shape="circle" coords="738,232,3" href="javascript:selectTSpoints(31068,738,232)">';
mtxt += '<area shape="circle" coords="743,232,3" href="javascript:selectTSpoints(31069,743,232)">';
mtxt += '<area shape="circle" coords="748,232,3" href="javascript:selectTSpoints(31070,748,232)">';
mtxt += '<area shape="circle" coords="753,232,3" href="javascript:selectTSpoints(31071,753,232)">';
mtxt += '<area shape="circle" coords="758,232,3" href="javascript:selectTSpoints(31072,758,232)">';
mtxt += '<area shape="circle" coords=" 30,227,3" href="javascript:selectTSpoints(32073, 30,227)">';
mtxt += '<area shape="circle" coords=" 35,227,3" href="javascript:selectTSpoints(32074, 35,227)">';
mtxt += '<area shape="circle" coords=" 40,227,3" href="javascript:selectTSpoints(32075, 40,227)">';
mtxt += '<area shape="circle" coords=" 45,227,3" href="javascript:selectTSpoints(32076, 45,227)">';
mtxt += '<area shape="circle" coords=" 50,227,3" href="javascript:selectTSpoints(32077, 50,227)">';
mtxt += '<area shape="circle" coords=" 56,227,3" href="javascript:selectTSpoints(32078, 56,227)">';
mtxt += '<area shape="circle" coords=" 61,227,3" href="javascript:selectTSpoints(32079, 61,227)">';
mtxt += '<area shape="circle" coords=" 66,227,3" href="javascript:selectTSpoints(32080, 66,227)">';
mtxt += '<area shape="circle" coords=" 71,227,3" href="javascript:selectTSpoints(32081, 71,227)">';
mtxt += '<area shape="circle" coords=" 76,227,3" href="javascript:selectTSpoints(32082, 76,227)">';
mtxt += '<area shape="circle" coords=" 81,227,3" href="javascript:selectTSpoints(32083, 81,227)">';
mtxt += '<area shape="circle" coords=" 86,227,3" href="javascript:selectTSpoints(32084, 86,227)">';
mtxt += '<area shape="circle" coords=" 91,227,3" href="javascript:selectTSpoints(32085, 91,227)">';
mtxt += '<area shape="circle" coords=" 96,227,3" href="javascript:selectTSpoints(32086, 96,227)">';
mtxt += '<area shape="circle" coords="101,227,3" href="javascript:selectTSpoints(32087,101,227)">';
mtxt += '<area shape="circle" coords="106,227,3" href="javascript:selectTSpoints(32088,106,227)">';
mtxt += '<area shape="circle" coords="112,227,3" href="javascript:selectTSpoints(32089,112,227)">';
mtxt += '<area shape="circle" coords="117,227,3" href="javascript:selectTSpoints(32090,117,227)">';
mtxt += '<area shape="circle" coords="122,227,3" href="javascript:selectTSpoints(32091,122,227)">';
mtxt += '<area shape="circle" coords="127,227,3" href="javascript:selectTSpoints(32092,127,227)">';
mtxt += '<area shape="circle" coords="132,227,3" href="javascript:selectTSpoints(32093,132,227)">';
mtxt += '<area shape="circle" coords="137,227,3" href="javascript:selectTSpoints(32094,137,227)">';
mtxt += '<area shape="circle" coords="142,227,3" href="javascript:selectTSpoints(32095,142,227)">';
mtxt += '<area shape="circle" coords="147,227,3" href="javascript:selectTSpoints(32096,147,227)">';
mtxt += '<area shape="circle" coords="152,227,3" href="javascript:selectTSpoints(32097,152,227)">';
mtxt += '<area shape="circle" coords="157,227,3" href="javascript:selectTSpoints(32098,157,227)">';
mtxt += '<area shape="circle" coords="162,227,3" href="javascript:selectTSpoints(32099,162,227)">';
mtxt += '<area shape="circle" coords="168,227,3" href="javascript:selectTSpoints(32100,168,227)">';
mtxt += '<area shape="circle" coords="173,227,3" href="javascript:selectTSpoints(32101,173,227)">';
mtxt += '<area shape="circle" coords="178,227,3" href="javascript:selectTSpoints(32102,178,227)">';
mtxt += '<area shape="circle" coords="183,227,3" href="javascript:selectTSpoints(32103,183,227)">';
mtxt += '<area shape="circle" coords="188,227,3" href="javascript:selectTSpoints(32104,188,227)">';
mtxt += '<area shape="circle" coords="193,227,3" href="javascript:selectTSpoints(32105,193,227)">';
mtxt += '<area shape="circle" coords="198,227,3" href="javascript:selectTSpoints(32106,198,227)">';
mtxt += '<area shape="circle" coords="203,227,3" href="javascript:selectTSpoints(32107,203,227)">';
mtxt += '<area shape="circle" coords="208,227,3" href="javascript:selectTSpoints(32108,208,227)">';
mtxt += '<area shape="circle" coords="213,227,3" href="javascript:selectTSpoints(32109,213,227)">';
mtxt += '<area shape="circle" coords="218,227,3" href="javascript:selectTSpoints(32110,218,227)">';
mtxt += '<area shape="circle" coords="224,227,3" href="javascript:selectTSpoints(32111,224,227)">';
mtxt += '<area shape="circle" coords="229,227,3" href="javascript:selectTSpoints(32112,229,227)">';
mtxt += '<area shape="circle" coords="234,227,3" href="javascript:selectTSpoints(32113,234,227)">';
mtxt += '<area shape="circle" coords="239,227,3" href="javascript:selectTSpoints(32114,239,227)">';
mtxt += '<area shape="circle" coords="244,227,3" href="javascript:selectTSpoints(32115,244,227)">';
mtxt += '<area shape="circle" coords="249,227,3" href="javascript:selectTSpoints(32116,249,227)">';
mtxt += '<area shape="circle" coords="254,227,3" href="javascript:selectTSpoints(32117,254,227)">';
mtxt += '<area shape="circle" coords="259,227,3" href="javascript:selectTSpoints(32118,259,227)">';
mtxt += '<area shape="circle" coords="264,227,3" href="javascript:selectTSpoints(32119,264,227)">';
mtxt += '<area shape="circle" coords="269,227,3" href="javascript:selectTSpoints(32120,269,227)">';
mtxt += '<area shape="circle" coords="274,227,3" href="javascript:selectTSpoints(32121,274,227)">';
mtxt += '<area shape="circle" coords="280,227,3" href="javascript:selectTSpoints(32122,280,227)">';
mtxt += '<area shape="circle" coords="285,227,3" href="javascript:selectTSpoints(32123,285,227)">';
mtxt += '<area shape="circle" coords="290,227,3" href="javascript:selectTSpoints(32124,290,227)">';
mtxt += '<area shape="circle" coords="295,227,3" href="javascript:selectTSpoints(32125,295,227)">';
mtxt += '<area shape="circle" coords="300,227,3" href="javascript:selectTSpoints(32126,300,227)">';
mtxt += '<area shape="circle" coords="305,227,3" href="javascript:selectTSpoints(32127,305,227)">';
mtxt += '<area shape="circle" coords="310,227,3" href="javascript:selectTSpoints(32128,310,227)">';
mtxt += '<area shape="circle" coords="315,227,3" href="javascript:selectTSpoints(32129,315,227)">';
mtxt += '<area shape="circle" coords="320,227,3" href="javascript:selectTSpoints(32130,320,227)">';
mtxt += '<area shape="circle" coords="325,227,3" href="javascript:selectTSpoints(32131,325,227)">';
mtxt += '<area shape="circle" coords="330,227,3" href="javascript:selectTSpoints(32132,330,227)">';
mtxt += '<area shape="circle" coords="336,227,3" href="javascript:selectTSpoints(32133,336,227)">';
mtxt += '<area shape="circle" coords="341,227,3" href="javascript:selectTSpoints(32134,341,227)">';
mtxt += '<area shape="circle" coords="346,227,3" href="javascript:selectTSpoints(32135,346,227)">';
mtxt += '<area shape="circle" coords="351,227,3" href="javascript:selectTSpoints(32136,351,227)">';
mtxt += '<area shape="circle" coords="356,227,3" href="javascript:selectTSpoints(32137,356,227)">';
mtxt += '<area shape="circle" coords="361,227,3" href="javascript:selectTSpoints(32138,361,227)">';
mtxt += '<area shape="circle" coords="366,227,3" href="javascript:selectTSpoints(32139,366,227)">';
mtxt += '<area shape="circle" coords="371,227,3" href="javascript:selectTSpoints(32140,371,227)">';
mtxt += '<area shape="circle" coords="376,227,3" href="javascript:selectTSpoints(32141,376,227)">';
mtxt += '<area shape="circle" coords="381,227,3" href="javascript:selectTSpoints(32142,381,227)">';
mtxt += '<area shape="circle" coords="386,227,3" href="javascript:selectTSpoints(32143,386,227)">';
mtxt += '<area shape="circle" coords="392,227,3" href="javascript:selectTSpoints(32144,392,227)">';
mtxt += '<area shape="circle" coords="397,227,3" href="javascript:selectTSpoints(32001,397,227)">';
mtxt += '<area shape="circle" coords="402,227,3" href="javascript:selectTSpoints(32002,402,227)">';
mtxt += '<area shape="circle" coords="407,227,3" href="javascript:selectTSpoints(32003,407,227)">';
mtxt += '<area shape="circle" coords="412,227,3" href="javascript:selectTSpoints(32004,412,227)">';
mtxt += '<area shape="circle" coords="417,227,3" href="javascript:selectTSpoints(32005,417,227)">';
mtxt += '<area shape="circle" coords="422,227,3" href="javascript:selectTSpoints(32006,422,227)">';
mtxt += '<area shape="circle" coords="427,227,3" href="javascript:selectTSpoints(32007,427,227)">';
mtxt += '<area shape="circle" coords="432,227,3" href="javascript:selectTSpoints(32008,432,227)">';
mtxt += '<area shape="circle" coords="437,227,3" href="javascript:selectTSpoints(32009,437,227)">';
mtxt += '<area shape="circle" coords="442,227,3" href="javascript:selectTSpoints(32010,442,227)">';
mtxt += '<area shape="circle" coords="447,227,3" href="javascript:selectTSpoints(32011,447,227)">';
mtxt += '<area shape="circle" coords="453,227,3" href="javascript:selectTSpoints(32012,453,227)">';
mtxt += '<area shape="circle" coords="458,227,3" href="javascript:selectTSpoints(32013,458,227)">';
mtxt += '<area shape="circle" coords="463,227,3" href="javascript:selectTSpoints(32014,463,227)">';
mtxt += '<area shape="circle" coords="468,227,3" href="javascript:selectTSpoints(32015,468,227)">';
mtxt += '<area shape="circle" coords="473,227,3" href="javascript:selectTSpoints(32016,473,227)">';
mtxt += '<area shape="circle" coords="478,227,3" href="javascript:selectTSpoints(32017,478,227)">';
mtxt += '<area shape="circle" coords="483,227,3" href="javascript:selectTSpoints(32018,483,227)">';
mtxt += '<area shape="circle" coords="488,227,3" href="javascript:selectTSpoints(32019,488,227)">';
mtxt += '<area shape="circle" coords="493,227,3" href="javascript:selectTSpoints(32020,493,227)">';
mtxt += '<area shape="circle" coords="498,227,3" href="javascript:selectTSpoints(32021,498,227)">';
mtxt += '<area shape="circle" coords="503,227,3" href="javascript:selectTSpoints(32022,503,227)">';
mtxt += '<area shape="circle" coords="509,227,3" href="javascript:selectTSpoints(32023,509,227)">';
mtxt += '<area shape="circle" coords="514,227,3" href="javascript:selectTSpoints(32024,514,227)">';
mtxt += '<area shape="circle" coords="519,227,3" href="javascript:selectTSpoints(32025,519,227)">';
mtxt += '<area shape="circle" coords="524,227,3" href="javascript:selectTSpoints(32026,524,227)">';
mtxt += '<area shape="circle" coords="529,227,3" href="javascript:selectTSpoints(32027,529,227)">';
mtxt += '<area shape="circle" coords="534,227,3" href="javascript:selectTSpoints(32028,534,227)">';
mtxt += '<area shape="circle" coords="539,227,3" href="javascript:selectTSpoints(32029,539,227)">';
mtxt += '<area shape="circle" coords="544,227,3" href="javascript:selectTSpoints(32030,544,227)">';
mtxt += '<area shape="circle" coords="549,227,3" href="javascript:selectTSpoints(32031,549,227)">';
mtxt += '<area shape="circle" coords="554,227,3" href="javascript:selectTSpoints(32032,554,227)">';
mtxt += '<area shape="circle" coords="559,227,3" href="javascript:selectTSpoints(32033,559,227)">';
mtxt += '<area shape="circle" coords="565,227,3" href="javascript:selectTSpoints(32034,565,227)">';
mtxt += '<area shape="circle" coords="570,227,3" href="javascript:selectTSpoints(32035,570,227)">';
mtxt += '<area shape="circle" coords="575,227,3" href="javascript:selectTSpoints(32036,575,227)">';
mtxt += '<area shape="circle" coords="580,227,3" href="javascript:selectTSpoints(32037,580,227)">';
mtxt += '<area shape="circle" coords="585,227,3" href="javascript:selectTSpoints(32038,585,227)">';
mtxt += '<area shape="circle" coords="590,227,3" href="javascript:selectTSpoints(32039,590,227)">';
mtxt += '<area shape="circle" coords="595,227,3" href="javascript:selectTSpoints(32040,595,227)">';
mtxt += '<area shape="circle" coords="600,227,3" href="javascript:selectTSpoints(32041,600,227)">';
mtxt += '<area shape="circle" coords="605,227,3" href="javascript:selectTSpoints(32042,605,227)">';
mtxt += '<area shape="circle" coords="610,227,3" href="javascript:selectTSpoints(32043,610,227)">';
mtxt += '<area shape="circle" coords="615,227,3" href="javascript:selectTSpoints(32044,615,227)">';
mtxt += '<area shape="circle" coords="621,227,3" href="javascript:selectTSpoints(32045,621,227)">';
mtxt += '<area shape="circle" coords="626,227,3" href="javascript:selectTSpoints(32046,626,227)">';
mtxt += '<area shape="circle" coords="631,227,3" href="javascript:selectTSpoints(32047,631,227)">';
mtxt += '<area shape="circle" coords="636,227,3" href="javascript:selectTSpoints(32048,636,227)">';
mtxt += '<area shape="circle" coords="641,227,3" href="javascript:selectTSpoints(32049,641,227)">';
mtxt += '<area shape="circle" coords="646,227,3" href="javascript:selectTSpoints(32050,646,227)">';
mtxt += '<area shape="circle" coords="651,227,3" href="javascript:selectTSpoints(32051,651,227)">';
mtxt += '<area shape="circle" coords="656,227,3" href="javascript:selectTSpoints(32052,656,227)">';
mtxt += '<area shape="circle" coords="661,227,3" href="javascript:selectTSpoints(32053,661,227)">';
mtxt += '<area shape="circle" coords="666,227,3" href="javascript:selectTSpoints(32054,666,227)">';
mtxt += '<area shape="circle" coords="671,227,3" href="javascript:selectTSpoints(32055,671,227)">';
mtxt += '<area shape="circle" coords="677,227,3" href="javascript:selectTSpoints(32056,677,227)">';
mtxt += '<area shape="circle" coords="682,227,3" href="javascript:selectTSpoints(32057,682,227)">';
mtxt += '<area shape="circle" coords="687,227,3" href="javascript:selectTSpoints(32058,687,227)">';
mtxt += '<area shape="circle" coords="692,227,3" href="javascript:selectTSpoints(32059,692,227)">';
mtxt += '<area shape="circle" coords="697,227,3" href="javascript:selectTSpoints(32060,697,227)">';
mtxt += '<area shape="circle" coords="702,227,3" href="javascript:selectTSpoints(32061,702,227)">';
mtxt += '<area shape="circle" coords="707,227,3" href="javascript:selectTSpoints(32062,707,227)">';
mtxt += '<area shape="circle" coords="712,227,3" href="javascript:selectTSpoints(32063,712,227)">';
mtxt += '<area shape="circle" coords="717,227,3" href="javascript:selectTSpoints(32064,717,227)">';
mtxt += '<area shape="circle" coords="722,227,3" href="javascript:selectTSpoints(32065,722,227)">';
mtxt += '<area shape="circle" coords="727,227,3" href="javascript:selectTSpoints(32066,727,227)">';
mtxt += '<area shape="circle" coords="733,227,3" href="javascript:selectTSpoints(32067,733,227)">';
mtxt += '<area shape="circle" coords="738,227,3" href="javascript:selectTSpoints(32068,738,227)">';
mtxt += '<area shape="circle" coords="743,227,3" href="javascript:selectTSpoints(32069,743,227)">';
mtxt += '<area shape="circle" coords="748,227,3" href="javascript:selectTSpoints(32070,748,227)">';
mtxt += '<area shape="circle" coords="753,227,3" href="javascript:selectTSpoints(32071,753,227)">';
mtxt += '<area shape="circle" coords="758,227,3" href="javascript:selectTSpoints(32072,758,227)">';
mtxt += '<area shape="circle" coords=" 30,222,3" href="javascript:selectTSpoints(33073, 30,222)">';
mtxt += '<area shape="circle" coords=" 35,222,3" href="javascript:selectTSpoints(33074, 35,222)">';
mtxt += '<area shape="circle" coords=" 40,222,3" href="javascript:selectTSpoints(33075, 40,222)">';
mtxt += '<area shape="circle" coords=" 45,222,3" href="javascript:selectTSpoints(33076, 45,222)">';
mtxt += '<area shape="circle" coords=" 50,222,3" href="javascript:selectTSpoints(33077, 50,222)">';
mtxt += '<area shape="circle" coords=" 56,222,3" href="javascript:selectTSpoints(33078, 56,222)">';
mtxt += '<area shape="circle" coords=" 61,222,3" href="javascript:selectTSpoints(33079, 61,222)">';
mtxt += '<area shape="circle" coords=" 66,222,3" href="javascript:selectTSpoints(33080, 66,222)">';
mtxt += '<area shape="circle" coords=" 71,222,3" href="javascript:selectTSpoints(33081, 71,222)">';
mtxt += '<area shape="circle" coords=" 76,222,3" href="javascript:selectTSpoints(33082, 76,222)">';
mtxt += '<area shape="circle" coords=" 81,222,3" href="javascript:selectTSpoints(33083, 81,222)">';
mtxt += '<area shape="circle" coords=" 86,222,3" href="javascript:selectTSpoints(33084, 86,222)">';
mtxt += '<area shape="circle" coords=" 91,222,3" href="javascript:selectTSpoints(33085, 91,222)">';
mtxt += '<area shape="circle" coords=" 96,222,3" href="javascript:selectTSpoints(33086, 96,222)">';
mtxt += '<area shape="circle" coords="101,222,3" href="javascript:selectTSpoints(33087,101,222)">';
mtxt += '<area shape="circle" coords="106,222,3" href="javascript:selectTSpoints(33088,106,222)">';
mtxt += '<area shape="circle" coords="112,222,3" href="javascript:selectTSpoints(33089,112,222)">';
mtxt += '<area shape="circle" coords="117,222,3" href="javascript:selectTSpoints(33090,117,222)">';
mtxt += '<area shape="circle" coords="122,222,3" href="javascript:selectTSpoints(33091,122,222)">';
mtxt += '<area shape="circle" coords="127,222,3" href="javascript:selectTSpoints(33092,127,222)">';
mtxt += '<area shape="circle" coords="132,222,3" href="javascript:selectTSpoints(33093,132,222)">';
mtxt += '<area shape="circle" coords="137,222,3" href="javascript:selectTSpoints(33094,137,222)">';
mtxt += '<area shape="circle" coords="142,222,3" href="javascript:selectTSpoints(33095,142,222)">';
mtxt += '<area shape="circle" coords="147,222,3" href="javascript:selectTSpoints(33096,147,222)">';
mtxt += '<area shape="circle" coords="152,222,3" href="javascript:selectTSpoints(33097,152,222)">';
mtxt += '<area shape="circle" coords="157,222,3" href="javascript:selectTSpoints(33098,157,222)">';
mtxt += '<area shape="circle" coords="162,222,3" href="javascript:selectTSpoints(33099,162,222)">';
mtxt += '<area shape="circle" coords="168,222,3" href="javascript:selectTSpoints(33100,168,222)">';
mtxt += '<area shape="circle" coords="173,222,3" href="javascript:selectTSpoints(33101,173,222)">';
mtxt += '<area shape="circle" coords="178,222,3" href="javascript:selectTSpoints(33102,178,222)">';
mtxt += '<area shape="circle" coords="183,222,3" href="javascript:selectTSpoints(33103,183,222)">';
mtxt += '<area shape="circle" coords="188,222,3" href="javascript:selectTSpoints(33104,188,222)">';
mtxt += '<area shape="circle" coords="193,222,3" href="javascript:selectTSpoints(33105,193,222)">';
mtxt += '<area shape="circle" coords="198,222,3" href="javascript:selectTSpoints(33106,198,222)">';
mtxt += '<area shape="circle" coords="203,222,3" href="javascript:selectTSpoints(33107,203,222)">';
mtxt += '<area shape="circle" coords="208,222,3" href="javascript:selectTSpoints(33108,208,222)">';
mtxt += '<area shape="circle" coords="213,222,3" href="javascript:selectTSpoints(33109,213,222)">';
mtxt += '<area shape="circle" coords="218,222,3" href="javascript:selectTSpoints(33110,218,222)">';
mtxt += '<area shape="circle" coords="224,222,3" href="javascript:selectTSpoints(33111,224,222)">';
mtxt += '<area shape="circle" coords="229,222,3" href="javascript:selectTSpoints(33112,229,222)">';
mtxt += '<area shape="circle" coords="234,222,3" href="javascript:selectTSpoints(33113,234,222)">';
mtxt += '<area shape="circle" coords="239,222,3" href="javascript:selectTSpoints(33114,239,222)">';
mtxt += '<area shape="circle" coords="244,222,3" href="javascript:selectTSpoints(33115,244,222)">';
mtxt += '<area shape="circle" coords="249,222,3" href="javascript:selectTSpoints(33116,249,222)">';
mtxt += '<area shape="circle" coords="254,222,3" href="javascript:selectTSpoints(33117,254,222)">';
mtxt += '<area shape="circle" coords="259,222,3" href="javascript:selectTSpoints(33118,259,222)">';
mtxt += '<area shape="circle" coords="264,222,3" href="javascript:selectTSpoints(33119,264,222)">';
mtxt += '<area shape="circle" coords="269,222,3" href="javascript:selectTSpoints(33120,269,222)">';
mtxt += '<area shape="circle" coords="274,222,3" href="javascript:selectTSpoints(33121,274,222)">';
mtxt += '<area shape="circle" coords="280,222,3" href="javascript:selectTSpoints(33122,280,222)">';
mtxt += '<area shape="circle" coords="285,222,3" href="javascript:selectTSpoints(33123,285,222)">';
mtxt += '<area shape="circle" coords="290,222,3" href="javascript:selectTSpoints(33124,290,222)">';
mtxt += '<area shape="circle" coords="295,222,3" href="javascript:selectTSpoints(33125,295,222)">';
mtxt += '<area shape="circle" coords="300,222,3" href="javascript:selectTSpoints(33126,300,222)">';
mtxt += '<area shape="circle" coords="305,222,3" href="javascript:selectTSpoints(33127,305,222)">';
mtxt += '<area shape="circle" coords="310,222,3" href="javascript:selectTSpoints(33128,310,222)">';
mtxt += '<area shape="circle" coords="315,222,3" href="javascript:selectTSpoints(33129,315,222)">';
mtxt += '<area shape="circle" coords="320,222,3" href="javascript:selectTSpoints(33130,320,222)">';
mtxt += '<area shape="circle" coords="325,222,3" href="javascript:selectTSpoints(33131,325,222)">';
mtxt += '<area shape="circle" coords="330,222,3" href="javascript:selectTSpoints(33132,330,222)">';
mtxt += '<area shape="circle" coords="336,222,3" href="javascript:selectTSpoints(33133,336,222)">';
mtxt += '<area shape="circle" coords="341,222,3" href="javascript:selectTSpoints(33134,341,222)">';
mtxt += '<area shape="circle" coords="346,222,3" href="javascript:selectTSpoints(33135,346,222)">';
mtxt += '<area shape="circle" coords="351,222,3" href="javascript:selectTSpoints(33136,351,222)">';
mtxt += '<area shape="circle" coords="356,222,3" href="javascript:selectTSpoints(33137,356,222)">';
mtxt += '<area shape="circle" coords="361,222,3" href="javascript:selectTSpoints(33138,361,222)">';
mtxt += '<area shape="circle" coords="366,222,3" href="javascript:selectTSpoints(33139,366,222)">';
mtxt += '<area shape="circle" coords="371,222,3" href="javascript:selectTSpoints(33140,371,222)">';
mtxt += '<area shape="circle" coords="376,222,3" href="javascript:selectTSpoints(33141,376,222)">';
mtxt += '<area shape="circle" coords="381,222,3" href="javascript:selectTSpoints(33142,381,222)">';
mtxt += '<area shape="circle" coords="386,222,3" href="javascript:selectTSpoints(33143,386,222)">';
mtxt += '<area shape="circle" coords="392,222,3" href="javascript:selectTSpoints(33144,392,222)">';
mtxt += '<area shape="circle" coords="397,222,3" href="javascript:selectTSpoints(33001,397,222)">';
mtxt += '<area shape="circle" coords="402,222,3" href="javascript:selectTSpoints(33002,402,222)">';
mtxt += '<area shape="circle" coords="407,222,3" href="javascript:selectTSpoints(33003,407,222)">';
mtxt += '<area shape="circle" coords="412,222,3" href="javascript:selectTSpoints(33004,412,222)">';
mtxt += '<area shape="circle" coords="417,222,3" href="javascript:selectTSpoints(33005,417,222)">';
mtxt += '<area shape="circle" coords="422,222,3" href="javascript:selectTSpoints(33006,422,222)">';
mtxt += '<area shape="circle" coords="427,222,3" href="javascript:selectTSpoints(33007,427,222)">';
mtxt += '<area shape="circle" coords="432,222,3" href="javascript:selectTSpoints(33008,432,222)">';
mtxt += '<area shape="circle" coords="437,222,3" href="javascript:selectTSpoints(33009,437,222)">';
mtxt += '<area shape="circle" coords="442,222,3" href="javascript:selectTSpoints(33010,442,222)">';
mtxt += '<area shape="circle" coords="447,222,3" href="javascript:selectTSpoints(33011,447,222)">';
mtxt += '<area shape="circle" coords="453,222,3" href="javascript:selectTSpoints(33012,453,222)">';
mtxt += '<area shape="circle" coords="458,222,3" href="javascript:selectTSpoints(33013,458,222)">';
mtxt += '<area shape="circle" coords="463,222,3" href="javascript:selectTSpoints(33014,463,222)">';
mtxt += '<area shape="circle" coords="468,222,3" href="javascript:selectTSpoints(33015,468,222)">';
mtxt += '<area shape="circle" coords="473,222,3" href="javascript:selectTSpoints(33016,473,222)">';
mtxt += '<area shape="circle" coords="478,222,3" href="javascript:selectTSpoints(33017,478,222)">';
mtxt += '<area shape="circle" coords="483,222,3" href="javascript:selectTSpoints(33018,483,222)">';
mtxt += '<area shape="circle" coords="488,222,3" href="javascript:selectTSpoints(33019,488,222)">';
mtxt += '<area shape="circle" coords="493,222,3" href="javascript:selectTSpoints(33020,493,222)">';
mtxt += '<area shape="circle" coords="498,222,3" href="javascript:selectTSpoints(33021,498,222)">';
mtxt += '<area shape="circle" coords="503,222,3" href="javascript:selectTSpoints(33022,503,222)">';
mtxt += '<area shape="circle" coords="509,222,3" href="javascript:selectTSpoints(33023,509,222)">';
mtxt += '<area shape="circle" coords="514,222,3" href="javascript:selectTSpoints(33024,514,222)">';
mtxt += '<area shape="circle" coords="519,222,3" href="javascript:selectTSpoints(33025,519,222)">';
mtxt += '<area shape="circle" coords="524,222,3" href="javascript:selectTSpoints(33026,524,222)">';
mtxt += '<area shape="circle" coords="529,222,3" href="javascript:selectTSpoints(33027,529,222)">';
mtxt += '<area shape="circle" coords="534,222,3" href="javascript:selectTSpoints(33028,534,222)">';
mtxt += '<area shape="circle" coords="539,222,3" href="javascript:selectTSpoints(33029,539,222)">';
mtxt += '<area shape="circle" coords="544,222,3" href="javascript:selectTSpoints(33030,544,222)">';
mtxt += '<area shape="circle" coords="549,222,3" href="javascript:selectTSpoints(33031,549,222)">';
mtxt += '<area shape="circle" coords="554,222,3" href="javascript:selectTSpoints(33032,554,222)">';
mtxt += '<area shape="circle" coords="559,222,3" href="javascript:selectTSpoints(33033,559,222)">';
mtxt += '<area shape="circle" coords="565,222,3" href="javascript:selectTSpoints(33034,565,222)">';
mtxt += '<area shape="circle" coords="570,222,3" href="javascript:selectTSpoints(33035,570,222)">';
mtxt += '<area shape="circle" coords="575,222,3" href="javascript:selectTSpoints(33036,575,222)">';
mtxt += '<area shape="circle" coords="580,222,3" href="javascript:selectTSpoints(33037,580,222)">';
mtxt += '<area shape="circle" coords="585,222,3" href="javascript:selectTSpoints(33038,585,222)">';
mtxt += '<area shape="circle" coords="590,222,3" href="javascript:selectTSpoints(33039,590,222)">';
mtxt += '<area shape="circle" coords="595,222,3" href="javascript:selectTSpoints(33040,595,222)">';
mtxt += '<area shape="circle" coords="600,222,3" href="javascript:selectTSpoints(33041,600,222)">';
mtxt += '<area shape="circle" coords="605,222,3" href="javascript:selectTSpoints(33042,605,222)">';
mtxt += '<area shape="circle" coords="610,222,3" href="javascript:selectTSpoints(33043,610,222)">';
mtxt += '<area shape="circle" coords="615,222,3" href="javascript:selectTSpoints(33044,615,222)">';
mtxt += '<area shape="circle" coords="621,222,3" href="javascript:selectTSpoints(33045,621,222)">';
mtxt += '<area shape="circle" coords="626,222,3" href="javascript:selectTSpoints(33046,626,222)">';
mtxt += '<area shape="circle" coords="631,222,3" href="javascript:selectTSpoints(33047,631,222)">';
mtxt += '<area shape="circle" coords="636,222,3" href="javascript:selectTSpoints(33048,636,222)">';
mtxt += '<area shape="circle" coords="641,222,3" href="javascript:selectTSpoints(33049,641,222)">';
mtxt += '<area shape="circle" coords="646,222,3" href="javascript:selectTSpoints(33050,646,222)">';
mtxt += '<area shape="circle" coords="651,222,3" href="javascript:selectTSpoints(33051,651,222)">';
mtxt += '<area shape="circle" coords="656,222,3" href="javascript:selectTSpoints(33052,656,222)">';
mtxt += '<area shape="circle" coords="661,222,3" href="javascript:selectTSpoints(33053,661,222)">';
mtxt += '<area shape="circle" coords="666,222,3" href="javascript:selectTSpoints(33054,666,222)">';
mtxt += '<area shape="circle" coords="671,222,3" href="javascript:selectTSpoints(33055,671,222)">';
mtxt += '<area shape="circle" coords="677,222,3" href="javascript:selectTSpoints(33056,677,222)">';
mtxt += '<area shape="circle" coords="682,222,3" href="javascript:selectTSpoints(33057,682,222)">';
mtxt += '<area shape="circle" coords="687,222,3" href="javascript:selectTSpoints(33058,687,222)">';
mtxt += '<area shape="circle" coords="692,222,3" href="javascript:selectTSpoints(33059,692,222)">';
mtxt += '<area shape="circle" coords="697,222,3" href="javascript:selectTSpoints(33060,697,222)">';
mtxt += '<area shape="circle" coords="702,222,3" href="javascript:selectTSpoints(33061,702,222)">';
mtxt += '<area shape="circle" coords="707,222,3" href="javascript:selectTSpoints(33062,707,222)">';
mtxt += '<area shape="circle" coords="712,222,3" href="javascript:selectTSpoints(33063,712,222)">';
mtxt += '<area shape="circle" coords="717,222,3" href="javascript:selectTSpoints(33064,717,222)">';
mtxt += '<area shape="circle" coords="722,222,3" href="javascript:selectTSpoints(33065,722,222)">';
mtxt += '<area shape="circle" coords="727,222,3" href="javascript:selectTSpoints(33066,727,222)">';
mtxt += '<area shape="circle" coords="733,222,3" href="javascript:selectTSpoints(33067,733,222)">';
mtxt += '<area shape="circle" coords="738,222,3" href="javascript:selectTSpoints(33068,738,222)">';
mtxt += '<area shape="circle" coords="743,222,3" href="javascript:selectTSpoints(33069,743,222)">';
mtxt += '<area shape="circle" coords="748,222,3" href="javascript:selectTSpoints(33070,748,222)">';
mtxt += '<area shape="circle" coords="753,222,3" href="javascript:selectTSpoints(33071,753,222)">';
mtxt += '<area shape="circle" coords="758,222,3" href="javascript:selectTSpoints(33072,758,222)">';
mtxt += '<area shape="circle" coords=" 30,217,3" href="javascript:selectTSpoints(34073, 30,217)">';
mtxt += '<area shape="circle" coords=" 35,217,3" href="javascript:selectTSpoints(34074, 35,217)">';
mtxt += '<area shape="circle" coords=" 40,217,3" href="javascript:selectTSpoints(34075, 40,217)">';
mtxt += '<area shape="circle" coords=" 45,217,3" href="javascript:selectTSpoints(34076, 45,217)">';
mtxt += '<area shape="circle" coords=" 50,217,3" href="javascript:selectTSpoints(34077, 50,217)">';
mtxt += '<area shape="circle" coords=" 56,217,3" href="javascript:selectTSpoints(34078, 56,217)">';
mtxt += '<area shape="circle" coords=" 61,217,3" href="javascript:selectTSpoints(34079, 61,217)">';
mtxt += '<area shape="circle" coords=" 66,217,3" href="javascript:selectTSpoints(34080, 66,217)">';
mtxt += '<area shape="circle" coords=" 71,217,3" href="javascript:selectTSpoints(34081, 71,217)">';
mtxt += '<area shape="circle" coords=" 76,217,3" href="javascript:selectTSpoints(34082, 76,217)">';
mtxt += '<area shape="circle" coords=" 81,217,3" href="javascript:selectTSpoints(34083, 81,217)">';
mtxt += '<area shape="circle" coords=" 86,217,3" href="javascript:selectTSpoints(34084, 86,217)">';
mtxt += '<area shape="circle" coords=" 91,217,3" href="javascript:selectTSpoints(34085, 91,217)">';
mtxt += '<area shape="circle" coords=" 96,217,3" href="javascript:selectTSpoints(34086, 96,217)">';
mtxt += '<area shape="circle" coords="101,217,3" href="javascript:selectTSpoints(34087,101,217)">';
mtxt += '<area shape="circle" coords="106,217,3" href="javascript:selectTSpoints(34088,106,217)">';
mtxt += '<area shape="circle" coords="112,217,3" href="javascript:selectTSpoints(34089,112,217)">';
mtxt += '<area shape="circle" coords="117,217,3" href="javascript:selectTSpoints(34090,117,217)">';
mtxt += '<area shape="circle" coords="122,217,3" href="javascript:selectTSpoints(34091,122,217)">';
mtxt += '<area shape="circle" coords="127,217,3" href="javascript:selectTSpoints(34092,127,217)">';
mtxt += '<area shape="circle" coords="132,217,3" href="javascript:selectTSpoints(34093,132,217)">';
mtxt += '<area shape="circle" coords="137,217,3" href="javascript:selectTSpoints(34094,137,217)">';
mtxt += '<area shape="circle" coords="142,217,3" href="javascript:selectTSpoints(34095,142,217)">';
mtxt += '<area shape="circle" coords="147,217,3" href="javascript:selectTSpoints(34096,147,217)">';
mtxt += '<area shape="circle" coords="152,217,3" href="javascript:selectTSpoints(34097,152,217)">';
mtxt += '<area shape="circle" coords="157,217,3" href="javascript:selectTSpoints(34098,157,217)">';
mtxt += '<area shape="circle" coords="162,217,3" href="javascript:selectTSpoints(34099,162,217)">';
mtxt += '<area shape="circle" coords="168,217,3" href="javascript:selectTSpoints(34100,168,217)">';
mtxt += '<area shape="circle" coords="173,217,3" href="javascript:selectTSpoints(34101,173,217)">';
mtxt += '<area shape="circle" coords="178,217,3" href="javascript:selectTSpoints(34102,178,217)">';
mtxt += '<area shape="circle" coords="183,217,3" href="javascript:selectTSpoints(34103,183,217)">';
mtxt += '<area shape="circle" coords="188,217,3" href="javascript:selectTSpoints(34104,188,217)">';
mtxt += '<area shape="circle" coords="193,217,3" href="javascript:selectTSpoints(34105,193,217)">';
mtxt += '<area shape="circle" coords="198,217,3" href="javascript:selectTSpoints(34106,198,217)">';
mtxt += '<area shape="circle" coords="203,217,3" href="javascript:selectTSpoints(34107,203,217)">';
mtxt += '<area shape="circle" coords="208,217,3" href="javascript:selectTSpoints(34108,208,217)">';
mtxt += '<area shape="circle" coords="213,217,3" href="javascript:selectTSpoints(34109,213,217)">';
mtxt += '<area shape="circle" coords="218,217,3" href="javascript:selectTSpoints(34110,218,217)">';
mtxt += '<area shape="circle" coords="224,217,3" href="javascript:selectTSpoints(34111,224,217)">';
mtxt += '<area shape="circle" coords="229,217,3" href="javascript:selectTSpoints(34112,229,217)">';
mtxt += '<area shape="circle" coords="234,217,3" href="javascript:selectTSpoints(34113,234,217)">';
mtxt += '<area shape="circle" coords="239,217,3" href="javascript:selectTSpoints(34114,239,217)">';
mtxt += '<area shape="circle" coords="244,217,3" href="javascript:selectTSpoints(34115,244,217)">';
mtxt += '<area shape="circle" coords="249,217,3" href="javascript:selectTSpoints(34116,249,217)">';
mtxt += '<area shape="circle" coords="254,217,3" href="javascript:selectTSpoints(34117,254,217)">';
mtxt += '<area shape="circle" coords="259,217,3" href="javascript:selectTSpoints(34118,259,217)">';
mtxt += '<area shape="circle" coords="264,217,3" href="javascript:selectTSpoints(34119,264,217)">';
mtxt += '<area shape="circle" coords="269,217,3" href="javascript:selectTSpoints(34120,269,217)">';
mtxt += '<area shape="circle" coords="274,217,3" href="javascript:selectTSpoints(34121,274,217)">';
mtxt += '<area shape="circle" coords="280,217,3" href="javascript:selectTSpoints(34122,280,217)">';
mtxt += '<area shape="circle" coords="285,217,3" href="javascript:selectTSpoints(34123,285,217)">';
mtxt += '<area shape="circle" coords="290,217,3" href="javascript:selectTSpoints(34124,290,217)">';
mtxt += '<area shape="circle" coords="295,217,3" href="javascript:selectTSpoints(34125,295,217)">';
mtxt += '<area shape="circle" coords="300,217,3" href="javascript:selectTSpoints(34126,300,217)">';
mtxt += '<area shape="circle" coords="305,217,3" href="javascript:selectTSpoints(34127,305,217)">';
mtxt += '<area shape="circle" coords="310,217,3" href="javascript:selectTSpoints(34128,310,217)">';
mtxt += '<area shape="circle" coords="315,217,3" href="javascript:selectTSpoints(34129,315,217)">';
mtxt += '<area shape="circle" coords="320,217,3" href="javascript:selectTSpoints(34130,320,217)">';
mtxt += '<area shape="circle" coords="325,217,3" href="javascript:selectTSpoints(34131,325,217)">';
mtxt += '<area shape="circle" coords="330,217,3" href="javascript:selectTSpoints(34132,330,217)">';
mtxt += '<area shape="circle" coords="336,217,3" href="javascript:selectTSpoints(34133,336,217)">';
mtxt += '<area shape="circle" coords="341,217,3" href="javascript:selectTSpoints(34134,341,217)">';
mtxt += '<area shape="circle" coords="346,217,3" href="javascript:selectTSpoints(34135,346,217)">';
mtxt += '<area shape="circle" coords="351,217,3" href="javascript:selectTSpoints(34136,351,217)">';
mtxt += '<area shape="circle" coords="356,217,3" href="javascript:selectTSpoints(34137,356,217)">';
mtxt += '<area shape="circle" coords="361,217,3" href="javascript:selectTSpoints(34138,361,217)">';
mtxt += '<area shape="circle" coords="366,217,3" href="javascript:selectTSpoints(34139,366,217)">';
mtxt += '<area shape="circle" coords="371,217,3" href="javascript:selectTSpoints(34140,371,217)">';
mtxt += '<area shape="circle" coords="376,217,3" href="javascript:selectTSpoints(34141,376,217)">';
mtxt += '<area shape="circle" coords="381,217,3" href="javascript:selectTSpoints(34142,381,217)">';
mtxt += '<area shape="circle" coords="386,217,3" href="javascript:selectTSpoints(34143,386,217)">';
mtxt += '<area shape="circle" coords="392,217,3" href="javascript:selectTSpoints(34144,392,217)">';
mtxt += '<area shape="circle" coords="397,217,3" href="javascript:selectTSpoints(34001,397,217)">';
mtxt += '<area shape="circle" coords="402,217,3" href="javascript:selectTSpoints(34002,402,217)">';
mtxt += '<area shape="circle" coords="407,217,3" href="javascript:selectTSpoints(34003,407,217)">';
mtxt += '<area shape="circle" coords="412,217,3" href="javascript:selectTSpoints(34004,412,217)">';
mtxt += '<area shape="circle" coords="417,217,3" href="javascript:selectTSpoints(34005,417,217)">';
mtxt += '<area shape="circle" coords="422,217,3" href="javascript:selectTSpoints(34006,422,217)">';
mtxt += '<area shape="circle" coords="427,217,3" href="javascript:selectTSpoints(34007,427,217)">';
mtxt += '<area shape="circle" coords="432,217,3" href="javascript:selectTSpoints(34008,432,217)">';
mtxt += '<area shape="circle" coords="437,217,3" href="javascript:selectTSpoints(34009,437,217)">';
mtxt += '<area shape="circle" coords="442,217,3" href="javascript:selectTSpoints(34010,442,217)">';
mtxt += '<area shape="circle" coords="447,217,3" href="javascript:selectTSpoints(34011,447,217)">';
mtxt += '<area shape="circle" coords="453,217,3" href="javascript:selectTSpoints(34012,453,217)">';
mtxt += '<area shape="circle" coords="458,217,3" href="javascript:selectTSpoints(34013,458,217)">';
mtxt += '<area shape="circle" coords="463,217,3" href="javascript:selectTSpoints(34014,463,217)">';
mtxt += '<area shape="circle" coords="468,217,3" href="javascript:selectTSpoints(34015,468,217)">';
mtxt += '<area shape="circle" coords="473,217,3" href="javascript:selectTSpoints(34016,473,217)">';
mtxt += '<area shape="circle" coords="478,217,3" href="javascript:selectTSpoints(34017,478,217)">';
mtxt += '<area shape="circle" coords="483,217,3" href="javascript:selectTSpoints(34018,483,217)">';
mtxt += '<area shape="circle" coords="488,217,3" href="javascript:selectTSpoints(34019,488,217)">';
mtxt += '<area shape="circle" coords="493,217,3" href="javascript:selectTSpoints(34020,493,217)">';
mtxt += '<area shape="circle" coords="498,217,3" href="javascript:selectTSpoints(34021,498,217)">';
mtxt += '<area shape="circle" coords="503,217,3" href="javascript:selectTSpoints(34022,503,217)">';
mtxt += '<area shape="circle" coords="509,217,3" href="javascript:selectTSpoints(34023,509,217)">';
mtxt += '<area shape="circle" coords="514,217,3" href="javascript:selectTSpoints(34024,514,217)">';
mtxt += '<area shape="circle" coords="519,217,3" href="javascript:selectTSpoints(34025,519,217)">';
mtxt += '<area shape="circle" coords="524,217,3" href="javascript:selectTSpoints(34026,524,217)">';
mtxt += '<area shape="circle" coords="529,217,3" href="javascript:selectTSpoints(34027,529,217)">';
mtxt += '<area shape="circle" coords="534,217,3" href="javascript:selectTSpoints(34028,534,217)">';
mtxt += '<area shape="circle" coords="539,217,3" href="javascript:selectTSpoints(34029,539,217)">';
mtxt += '<area shape="circle" coords="544,217,3" href="javascript:selectTSpoints(34030,544,217)">';
mtxt += '<area shape="circle" coords="549,217,3" href="javascript:selectTSpoints(34031,549,217)">';
mtxt += '<area shape="circle" coords="554,217,3" href="javascript:selectTSpoints(34032,554,217)">';
mtxt += '<area shape="circle" coords="559,217,3" href="javascript:selectTSpoints(34033,559,217)">';
mtxt += '<area shape="circle" coords="565,217,3" href="javascript:selectTSpoints(34034,565,217)">';
mtxt += '<area shape="circle" coords="570,217,3" href="javascript:selectTSpoints(34035,570,217)">';
mtxt += '<area shape="circle" coords="575,217,3" href="javascript:selectTSpoints(34036,575,217)">';
mtxt += '<area shape="circle" coords="580,217,3" href="javascript:selectTSpoints(34037,580,217)">';
mtxt += '<area shape="circle" coords="585,217,3" href="javascript:selectTSpoints(34038,585,217)">';
mtxt += '<area shape="circle" coords="590,217,3" href="javascript:selectTSpoints(34039,590,217)">';
mtxt += '<area shape="circle" coords="595,217,3" href="javascript:selectTSpoints(34040,595,217)">';
mtxt += '<area shape="circle" coords="600,217,3" href="javascript:selectTSpoints(34041,600,217)">';
mtxt += '<area shape="circle" coords="605,217,3" href="javascript:selectTSpoints(34042,605,217)">';
mtxt += '<area shape="circle" coords="610,217,3" href="javascript:selectTSpoints(34043,610,217)">';
mtxt += '<area shape="circle" coords="615,217,3" href="javascript:selectTSpoints(34044,615,217)">';
mtxt += '<area shape="circle" coords="621,217,3" href="javascript:selectTSpoints(34045,621,217)">';
mtxt += '<area shape="circle" coords="626,217,3" href="javascript:selectTSpoints(34046,626,217)">';
mtxt += '<area shape="circle" coords="631,217,3" href="javascript:selectTSpoints(34047,631,217)">';
mtxt += '<area shape="circle" coords="636,217,3" href="javascript:selectTSpoints(34048,636,217)">';
mtxt += '<area shape="circle" coords="641,217,3" href="javascript:selectTSpoints(34049,641,217)">';
mtxt += '<area shape="circle" coords="646,217,3" href="javascript:selectTSpoints(34050,646,217)">';
mtxt += '<area shape="circle" coords="651,217,3" href="javascript:selectTSpoints(34051,651,217)">';
mtxt += '<area shape="circle" coords="656,217,3" href="javascript:selectTSpoints(34052,656,217)">';
mtxt += '<area shape="circle" coords="661,217,3" href="javascript:selectTSpoints(34053,661,217)">';
mtxt += '<area shape="circle" coords="666,217,3" href="javascript:selectTSpoints(34054,666,217)">';
mtxt += '<area shape="circle" coords="671,217,3" href="javascript:selectTSpoints(34055,671,217)">';
mtxt += '<area shape="circle" coords="677,217,3" href="javascript:selectTSpoints(34056,677,217)">';
mtxt += '<area shape="circle" coords="682,217,3" href="javascript:selectTSpoints(34057,682,217)">';
mtxt += '<area shape="circle" coords="687,217,3" href="javascript:selectTSpoints(34058,687,217)">';
mtxt += '<area shape="circle" coords="692,217,3" href="javascript:selectTSpoints(34059,692,217)">';
mtxt += '<area shape="circle" coords="697,217,3" href="javascript:selectTSpoints(34060,697,217)">';
mtxt += '<area shape="circle" coords="702,217,3" href="javascript:selectTSpoints(34061,702,217)">';
mtxt += '<area shape="circle" coords="707,217,3" href="javascript:selectTSpoints(34062,707,217)">';
mtxt += '<area shape="circle" coords="712,217,3" href="javascript:selectTSpoints(34063,712,217)">';
mtxt += '<area shape="circle" coords="717,217,3" href="javascript:selectTSpoints(34064,717,217)">';
mtxt += '<area shape="circle" coords="722,217,3" href="javascript:selectTSpoints(34065,722,217)">';
mtxt += '<area shape="circle" coords="727,217,3" href="javascript:selectTSpoints(34066,727,217)">';
mtxt += '<area shape="circle" coords="733,217,3" href="javascript:selectTSpoints(34067,733,217)">';
mtxt += '<area shape="circle" coords="738,217,3" href="javascript:selectTSpoints(34068,738,217)">';
mtxt += '<area shape="circle" coords="743,217,3" href="javascript:selectTSpoints(34069,743,217)">';
mtxt += '<area shape="circle" coords="748,217,3" href="javascript:selectTSpoints(34070,748,217)">';
mtxt += '<area shape="circle" coords="753,217,3" href="javascript:selectTSpoints(34071,753,217)">';
mtxt += '<area shape="circle" coords="758,217,3" href="javascript:selectTSpoints(34072,758,217)">';
mtxt += '<area shape="circle" coords=" 30,212,3" href="javascript:selectTSpoints(35073, 30,212)">';
mtxt += '<area shape="circle" coords=" 35,212,3" href="javascript:selectTSpoints(35074, 35,212)">';
mtxt += '<area shape="circle" coords=" 40,212,3" href="javascript:selectTSpoints(35075, 40,212)">';
mtxt += '<area shape="circle" coords=" 45,212,3" href="javascript:selectTSpoints(35076, 45,212)">';
mtxt += '<area shape="circle" coords=" 50,212,3" href="javascript:selectTSpoints(35077, 50,212)">';
mtxt += '<area shape="circle" coords=" 56,212,3" href="javascript:selectTSpoints(35078, 56,212)">';
mtxt += '<area shape="circle" coords=" 61,212,3" href="javascript:selectTSpoints(35079, 61,212)">';
mtxt += '<area shape="circle" coords=" 66,212,3" href="javascript:selectTSpoints(35080, 66,212)">';
mtxt += '<area shape="circle" coords=" 71,212,3" href="javascript:selectTSpoints(35081, 71,212)">';
mtxt += '<area shape="circle" coords=" 76,212,3" href="javascript:selectTSpoints(35082, 76,212)">';
mtxt += '<area shape="circle" coords=" 81,212,3" href="javascript:selectTSpoints(35083, 81,212)">';
mtxt += '<area shape="circle" coords=" 86,212,3" href="javascript:selectTSpoints(35084, 86,212)">';
mtxt += '<area shape="circle" coords=" 91,212,3" href="javascript:selectTSpoints(35085, 91,212)">';
mtxt += '<area shape="circle" coords=" 96,212,3" href="javascript:selectTSpoints(35086, 96,212)">';
mtxt += '<area shape="circle" coords="101,212,3" href="javascript:selectTSpoints(35087,101,212)">';
mtxt += '<area shape="circle" coords="106,212,3" href="javascript:selectTSpoints(35088,106,212)">';
mtxt += '<area shape="circle" coords="112,212,3" href="javascript:selectTSpoints(35089,112,212)">';
mtxt += '<area shape="circle" coords="117,212,3" href="javascript:selectTSpoints(35090,117,212)">';
mtxt += '<area shape="circle" coords="122,212,3" href="javascript:selectTSpoints(35091,122,212)">';
mtxt += '<area shape="circle" coords="127,212,3" href="javascript:selectTSpoints(35092,127,212)">';
mtxt += '<area shape="circle" coords="132,212,3" href="javascript:selectTSpoints(35093,132,212)">';
mtxt += '<area shape="circle" coords="137,212,3" href="javascript:selectTSpoints(35094,137,212)">';
mtxt += '<area shape="circle" coords="142,212,3" href="javascript:selectTSpoints(35095,142,212)">';
mtxt += '<area shape="circle" coords="147,212,3" href="javascript:selectTSpoints(35096,147,212)">';
mtxt += '<area shape="circle" coords="152,212,3" href="javascript:selectTSpoints(35097,152,212)">';
mtxt += '<area shape="circle" coords="157,212,3" href="javascript:selectTSpoints(35098,157,212)">';
mtxt += '<area shape="circle" coords="162,212,3" href="javascript:selectTSpoints(35099,162,212)">';
mtxt += '<area shape="circle" coords="168,212,3" href="javascript:selectTSpoints(35100,168,212)">';
mtxt += '<area shape="circle" coords="173,212,3" href="javascript:selectTSpoints(35101,173,212)">';
mtxt += '<area shape="circle" coords="178,212,3" href="javascript:selectTSpoints(35102,178,212)">';
mtxt += '<area shape="circle" coords="183,212,3" href="javascript:selectTSpoints(35103,183,212)">';
mtxt += '<area shape="circle" coords="188,212,3" href="javascript:selectTSpoints(35104,188,212)">';
mtxt += '<area shape="circle" coords="193,212,3" href="javascript:selectTSpoints(35105,193,212)">';
mtxt += '<area shape="circle" coords="198,212,3" href="javascript:selectTSpoints(35106,198,212)">';
mtxt += '<area shape="circle" coords="203,212,3" href="javascript:selectTSpoints(35107,203,212)">';
mtxt += '<area shape="circle" coords="208,212,3" href="javascript:selectTSpoints(35108,208,212)">';
mtxt += '<area shape="circle" coords="213,212,3" href="javascript:selectTSpoints(35109,213,212)">';
mtxt += '<area shape="circle" coords="218,212,3" href="javascript:selectTSpoints(35110,218,212)">';
mtxt += '<area shape="circle" coords="224,212,3" href="javascript:selectTSpoints(35111,224,212)">';
mtxt += '<area shape="circle" coords="229,212,3" href="javascript:selectTSpoints(35112,229,212)">';
mtxt += '<area shape="circle" coords="234,212,3" href="javascript:selectTSpoints(35113,234,212)">';
mtxt += '<area shape="circle" coords="239,212,3" href="javascript:selectTSpoints(35114,239,212)">';
mtxt += '<area shape="circle" coords="244,212,3" href="javascript:selectTSpoints(35115,244,212)">';
mtxt += '<area shape="circle" coords="249,212,3" href="javascript:selectTSpoints(35116,249,212)">';
mtxt += '<area shape="circle" coords="254,212,3" href="javascript:selectTSpoints(35117,254,212)">';
mtxt += '<area shape="circle" coords="259,212,3" href="javascript:selectTSpoints(35118,259,212)">';
mtxt += '<area shape="circle" coords="264,212,3" href="javascript:selectTSpoints(35119,264,212)">';
mtxt += '<area shape="circle" coords="269,212,3" href="javascript:selectTSpoints(35120,269,212)">';
mtxt += '<area shape="circle" coords="274,212,3" href="javascript:selectTSpoints(35121,274,212)">';
mtxt += '<area shape="circle" coords="280,212,3" href="javascript:selectTSpoints(35122,280,212)">';
mtxt += '<area shape="circle" coords="285,212,3" href="javascript:selectTSpoints(35123,285,212)">';
mtxt += '<area shape="circle" coords="290,212,3" href="javascript:selectTSpoints(35124,290,212)">';
mtxt += '<area shape="circle" coords="295,212,3" href="javascript:selectTSpoints(35125,295,212)">';
mtxt += '<area shape="circle" coords="300,212,3" href="javascript:selectTSpoints(35126,300,212)">';
mtxt += '<area shape="circle" coords="305,212,3" href="javascript:selectTSpoints(35127,305,212)">';
mtxt += '<area shape="circle" coords="310,212,3" href="javascript:selectTSpoints(35128,310,212)">';
mtxt += '<area shape="circle" coords="315,212,3" href="javascript:selectTSpoints(35129,315,212)">';
mtxt += '<area shape="circle" coords="320,212,3" href="javascript:selectTSpoints(35130,320,212)">';
mtxt += '<area shape="circle" coords="325,212,3" href="javascript:selectTSpoints(35131,325,212)">';
mtxt += '<area shape="circle" coords="330,212,3" href="javascript:selectTSpoints(35132,330,212)">';
mtxt += '<area shape="circle" coords="336,212,3" href="javascript:selectTSpoints(35133,336,212)">';
mtxt += '<area shape="circle" coords="341,212,3" href="javascript:selectTSpoints(35134,341,212)">';
mtxt += '<area shape="circle" coords="346,212,3" href="javascript:selectTSpoints(35135,346,212)">';
mtxt += '<area shape="circle" coords="351,212,3" href="javascript:selectTSpoints(35136,351,212)">';
mtxt += '<area shape="circle" coords="356,212,3" href="javascript:selectTSpoints(35137,356,212)">';
mtxt += '<area shape="circle" coords="361,212,3" href="javascript:selectTSpoints(35138,361,212)">';
mtxt += '<area shape="circle" coords="366,212,3" href="javascript:selectTSpoints(35139,366,212)">';
mtxt += '<area shape="circle" coords="371,212,3" href="javascript:selectTSpoints(35140,371,212)">';
mtxt += '<area shape="circle" coords="376,212,3" href="javascript:selectTSpoints(35141,376,212)">';
mtxt += '<area shape="circle" coords="381,212,3" href="javascript:selectTSpoints(35142,381,212)">';
mtxt += '<area shape="circle" coords="386,212,3" href="javascript:selectTSpoints(35143,386,212)">';
mtxt += '<area shape="circle" coords="392,212,3" href="javascript:selectTSpoints(35144,392,212)">';
mtxt += '<area shape="circle" coords="397,212,3" href="javascript:selectTSpoints(35001,397,212)">';
mtxt += '<area shape="circle" coords="402,212,3" href="javascript:selectTSpoints(35002,402,212)">';
mtxt += '<area shape="circle" coords="407,212,3" href="javascript:selectTSpoints(35003,407,212)">';
mtxt += '<area shape="circle" coords="412,212,3" href="javascript:selectTSpoints(35004,412,212)">';
mtxt += '<area shape="circle" coords="417,212,3" href="javascript:selectTSpoints(35005,417,212)">';
mtxt += '<area shape="circle" coords="422,212,3" href="javascript:selectTSpoints(35006,422,212)">';
mtxt += '<area shape="circle" coords="427,212,3" href="javascript:selectTSpoints(35007,427,212)">';
mtxt += '<area shape="circle" coords="432,212,3" href="javascript:selectTSpoints(35008,432,212)">';
mtxt += '<area shape="circle" coords="437,212,3" href="javascript:selectTSpoints(35009,437,212)">';
mtxt += '<area shape="circle" coords="442,212,3" href="javascript:selectTSpoints(35010,442,212)">';
mtxt += '<area shape="circle" coords="447,212,3" href="javascript:selectTSpoints(35011,447,212)">';
mtxt += '<area shape="circle" coords="453,212,3" href="javascript:selectTSpoints(35012,453,212)">';
mtxt += '<area shape="circle" coords="458,212,3" href="javascript:selectTSpoints(35013,458,212)">';
mtxt += '<area shape="circle" coords="463,212,3" href="javascript:selectTSpoints(35014,463,212)">';
mtxt += '<area shape="circle" coords="468,212,3" href="javascript:selectTSpoints(35015,468,212)">';
mtxt += '<area shape="circle" coords="473,212,3" href="javascript:selectTSpoints(35016,473,212)">';
mtxt += '<area shape="circle" coords="478,212,3" href="javascript:selectTSpoints(35017,478,212)">';
mtxt += '<area shape="circle" coords="483,212,3" href="javascript:selectTSpoints(35018,483,212)">';
mtxt += '<area shape="circle" coords="488,212,3" href="javascript:selectTSpoints(35019,488,212)">';
mtxt += '<area shape="circle" coords="493,212,3" href="javascript:selectTSpoints(35020,493,212)">';
mtxt += '<area shape="circle" coords="498,212,3" href="javascript:selectTSpoints(35021,498,212)">';
mtxt += '<area shape="circle" coords="503,212,3" href="javascript:selectTSpoints(35022,503,212)">';
mtxt += '<area shape="circle" coords="509,212,3" href="javascript:selectTSpoints(35023,509,212)">';
mtxt += '<area shape="circle" coords="514,212,3" href="javascript:selectTSpoints(35024,514,212)">';
mtxt += '<area shape="circle" coords="519,212,3" href="javascript:selectTSpoints(35025,519,212)">';
mtxt += '<area shape="circle" coords="524,212,3" href="javascript:selectTSpoints(35026,524,212)">';
mtxt += '<area shape="circle" coords="529,212,3" href="javascript:selectTSpoints(35027,529,212)">';
mtxt += '<area shape="circle" coords="534,212,3" href="javascript:selectTSpoints(35028,534,212)">';
mtxt += '<area shape="circle" coords="539,212,3" href="javascript:selectTSpoints(35029,539,212)">';
mtxt += '<area shape="circle" coords="544,212,3" href="javascript:selectTSpoints(35030,544,212)">';
mtxt += '<area shape="circle" coords="549,212,3" href="javascript:selectTSpoints(35031,549,212)">';
mtxt += '<area shape="circle" coords="554,212,3" href="javascript:selectTSpoints(35032,554,212)">';
mtxt += '<area shape="circle" coords="559,212,3" href="javascript:selectTSpoints(35033,559,212)">';
mtxt += '<area shape="circle" coords="565,212,3" href="javascript:selectTSpoints(35034,565,212)">';
mtxt += '<area shape="circle" coords="570,212,3" href="javascript:selectTSpoints(35035,570,212)">';
mtxt += '<area shape="circle" coords="575,212,3" href="javascript:selectTSpoints(35036,575,212)">';
mtxt += '<area shape="circle" coords="580,212,3" href="javascript:selectTSpoints(35037,580,212)">';
mtxt += '<area shape="circle" coords="585,212,3" href="javascript:selectTSpoints(35038,585,212)">';
mtxt += '<area shape="circle" coords="590,212,3" href="javascript:selectTSpoints(35039,590,212)">';
mtxt += '<area shape="circle" coords="595,212,3" href="javascript:selectTSpoints(35040,595,212)">';
mtxt += '<area shape="circle" coords="600,212,3" href="javascript:selectTSpoints(35041,600,212)">';
mtxt += '<area shape="circle" coords="605,212,3" href="javascript:selectTSpoints(35042,605,212)">';
mtxt += '<area shape="circle" coords="610,212,3" href="javascript:selectTSpoints(35043,610,212)">';
mtxt += '<area shape="circle" coords="615,212,3" href="javascript:selectTSpoints(35044,615,212)">';
mtxt += '<area shape="circle" coords="621,212,3" href="javascript:selectTSpoints(35045,621,212)">';
mtxt += '<area shape="circle" coords="626,212,3" href="javascript:selectTSpoints(35046,626,212)">';
mtxt += '<area shape="circle" coords="631,212,3" href="javascript:selectTSpoints(35047,631,212)">';
mtxt += '<area shape="circle" coords="636,212,3" href="javascript:selectTSpoints(35048,636,212)">';
mtxt += '<area shape="circle" coords="641,212,3" href="javascript:selectTSpoints(35049,641,212)">';
mtxt += '<area shape="circle" coords="646,212,3" href="javascript:selectTSpoints(35050,646,212)">';
mtxt += '<area shape="circle" coords="651,212,3" href="javascript:selectTSpoints(35051,651,212)">';
mtxt += '<area shape="circle" coords="656,212,3" href="javascript:selectTSpoints(35052,656,212)">';
mtxt += '<area shape="circle" coords="661,212,3" href="javascript:selectTSpoints(35053,661,212)">';
mtxt += '<area shape="circle" coords="666,212,3" href="javascript:selectTSpoints(35054,666,212)">';
mtxt += '<area shape="circle" coords="671,212,3" href="javascript:selectTSpoints(35055,671,212)">';
mtxt += '<area shape="circle" coords="677,212,3" href="javascript:selectTSpoints(35056,677,212)">';
mtxt += '<area shape="circle" coords="682,212,3" href="javascript:selectTSpoints(35057,682,212)">';
mtxt += '<area shape="circle" coords="687,212,3" href="javascript:selectTSpoints(35058,687,212)">';
mtxt += '<area shape="circle" coords="692,212,3" href="javascript:selectTSpoints(35059,692,212)">';
mtxt += '<area shape="circle" coords="697,212,3" href="javascript:selectTSpoints(35060,697,212)">';
mtxt += '<area shape="circle" coords="702,212,3" href="javascript:selectTSpoints(35061,702,212)">';
mtxt += '<area shape="circle" coords="707,212,3" href="javascript:selectTSpoints(35062,707,212)">';
mtxt += '<area shape="circle" coords="712,212,3" href="javascript:selectTSpoints(35063,712,212)">';
mtxt += '<area shape="circle" coords="717,212,3" href="javascript:selectTSpoints(35064,717,212)">';
mtxt += '<area shape="circle" coords="722,212,3" href="javascript:selectTSpoints(35065,722,212)">';
mtxt += '<area shape="circle" coords="727,212,3" href="javascript:selectTSpoints(35066,727,212)">';
mtxt += '<area shape="circle" coords="733,212,3" href="javascript:selectTSpoints(35067,733,212)">';
mtxt += '<area shape="circle" coords="738,212,3" href="javascript:selectTSpoints(35068,738,212)">';
mtxt += '<area shape="circle" coords="743,212,3" href="javascript:selectTSpoints(35069,743,212)">';
mtxt += '<area shape="circle" coords="748,212,3" href="javascript:selectTSpoints(35070,748,212)">';
mtxt += '<area shape="circle" coords="753,212,3" href="javascript:selectTSpoints(35071,753,212)">';
mtxt += '<area shape="circle" coords="758,212,3" href="javascript:selectTSpoints(35072,758,212)">';
mtxt += '<area shape="circle" coords=" 30,207,3" href="javascript:selectTSpoints(36073, 30,207)">';
mtxt += '<area shape="circle" coords=" 35,207,3" href="javascript:selectTSpoints(36074, 35,207)">';
mtxt += '<area shape="circle" coords=" 40,207,3" href="javascript:selectTSpoints(36075, 40,207)">';
mtxt += '<area shape="circle" coords=" 45,207,3" href="javascript:selectTSpoints(36076, 45,207)">';
mtxt += '<area shape="circle" coords=" 50,207,3" href="javascript:selectTSpoints(36077, 50,207)">';
mtxt += '<area shape="circle" coords=" 56,207,3" href="javascript:selectTSpoints(36078, 56,207)">';
mtxt += '<area shape="circle" coords=" 61,207,3" href="javascript:selectTSpoints(36079, 61,207)">';
mtxt += '<area shape="circle" coords=" 66,207,3" href="javascript:selectTSpoints(36080, 66,207)">';
mtxt += '<area shape="circle" coords=" 71,207,3" href="javascript:selectTSpoints(36081, 71,207)">';
mtxt += '<area shape="circle" coords=" 76,207,3" href="javascript:selectTSpoints(36082, 76,207)">';
mtxt += '<area shape="circle" coords=" 81,207,3" href="javascript:selectTSpoints(36083, 81,207)">';
mtxt += '<area shape="circle" coords=" 86,207,3" href="javascript:selectTSpoints(36084, 86,207)">';
mtxt += '<area shape="circle" coords=" 91,207,3" href="javascript:selectTSpoints(36085, 91,207)">';
mtxt += '<area shape="circle" coords=" 96,207,3" href="javascript:selectTSpoints(36086, 96,207)">';
mtxt += '<area shape="circle" coords="101,207,3" href="javascript:selectTSpoints(36087,101,207)">';
mtxt += '<area shape="circle" coords="106,207,3" href="javascript:selectTSpoints(36088,106,207)">';
mtxt += '<area shape="circle" coords="112,207,3" href="javascript:selectTSpoints(36089,112,207)">';
mtxt += '<area shape="circle" coords="117,207,3" href="javascript:selectTSpoints(36090,117,207)">';
mtxt += '<area shape="circle" coords="122,207,3" href="javascript:selectTSpoints(36091,122,207)">';
mtxt += '<area shape="circle" coords="127,207,3" href="javascript:selectTSpoints(36092,127,207)">';
mtxt += '<area shape="circle" coords="132,207,3" href="javascript:selectTSpoints(36093,132,207)">';
mtxt += '<area shape="circle" coords="137,207,3" href="javascript:selectTSpoints(36094,137,207)">';
mtxt += '<area shape="circle" coords="142,207,3" href="javascript:selectTSpoints(36095,142,207)">';
mtxt += '<area shape="circle" coords="147,207,3" href="javascript:selectTSpoints(36096,147,207)">';
mtxt += '<area shape="circle" coords="152,207,3" href="javascript:selectTSpoints(36097,152,207)">';
mtxt += '<area shape="circle" coords="157,207,3" href="javascript:selectTSpoints(36098,157,207)">';
mtxt += '<area shape="circle" coords="162,207,3" href="javascript:selectTSpoints(36099,162,207)">';
mtxt += '<area shape="circle" coords="168,207,3" href="javascript:selectTSpoints(36100,168,207)">';
mtxt += '<area shape="circle" coords="173,207,3" href="javascript:selectTSpoints(36101,173,207)">';
mtxt += '<area shape="circle" coords="178,207,3" href="javascript:selectTSpoints(36102,178,207)">';
mtxt += '<area shape="circle" coords="183,207,3" href="javascript:selectTSpoints(36103,183,207)">';
mtxt += '<area shape="circle" coords="188,207,3" href="javascript:selectTSpoints(36104,188,207)">';
mtxt += '<area shape="circle" coords="193,207,3" href="javascript:selectTSpoints(36105,193,207)">';
mtxt += '<area shape="circle" coords="198,207,3" href="javascript:selectTSpoints(36106,198,207)">';
mtxt += '<area shape="circle" coords="203,207,3" href="javascript:selectTSpoints(36107,203,207)">';
mtxt += '<area shape="circle" coords="208,207,3" href="javascript:selectTSpoints(36108,208,207)">';
mtxt += '<area shape="circle" coords="213,207,3" href="javascript:selectTSpoints(36109,213,207)">';
mtxt += '<area shape="circle" coords="218,207,3" href="javascript:selectTSpoints(36110,218,207)">';
mtxt += '<area shape="circle" coords="224,207,3" href="javascript:selectTSpoints(36111,224,207)">';
mtxt += '<area shape="circle" coords="229,207,3" href="javascript:selectTSpoints(36112,229,207)">';
mtxt += '<area shape="circle" coords="234,207,3" href="javascript:selectTSpoints(36113,234,207)">';
mtxt += '<area shape="circle" coords="239,207,3" href="javascript:selectTSpoints(36114,239,207)">';
mtxt += '<area shape="circle" coords="244,207,3" href="javascript:selectTSpoints(36115,244,207)">';
mtxt += '<area shape="circle" coords="249,207,3" href="javascript:selectTSpoints(36116,249,207)">';
mtxt += '<area shape="circle" coords="254,207,3" href="javascript:selectTSpoints(36117,254,207)">';
mtxt += '<area shape="circle" coords="259,207,3" href="javascript:selectTSpoints(36118,259,207)">';
mtxt += '<area shape="circle" coords="264,207,3" href="javascript:selectTSpoints(36119,264,207)">';
mtxt += '<area shape="circle" coords="269,207,3" href="javascript:selectTSpoints(36120,269,207)">';
mtxt += '<area shape="circle" coords="274,207,3" href="javascript:selectTSpoints(36121,274,207)">';
mtxt += '<area shape="circle" coords="280,207,3" href="javascript:selectTSpoints(36122,280,207)">';
mtxt += '<area shape="circle" coords="285,207,3" href="javascript:selectTSpoints(36123,285,207)">';
mtxt += '<area shape="circle" coords="290,207,3" href="javascript:selectTSpoints(36124,290,207)">';
mtxt += '<area shape="circle" coords="295,207,3" href="javascript:selectTSpoints(36125,295,207)">';
mtxt += '<area shape="circle" coords="300,207,3" href="javascript:selectTSpoints(36126,300,207)">';
mtxt += '<area shape="circle" coords="305,207,3" href="javascript:selectTSpoints(36127,305,207)">';
mtxt += '<area shape="circle" coords="310,207,3" href="javascript:selectTSpoints(36128,310,207)">';
mtxt += '<area shape="circle" coords="315,207,3" href="javascript:selectTSpoints(36129,315,207)">';
mtxt += '<area shape="circle" coords="320,207,3" href="javascript:selectTSpoints(36130,320,207)">';
mtxt += '<area shape="circle" coords="325,207,3" href="javascript:selectTSpoints(36131,325,207)">';
mtxt += '<area shape="circle" coords="330,207,3" href="javascript:selectTSpoints(36132,330,207)">';
mtxt += '<area shape="circle" coords="336,207,3" href="javascript:selectTSpoints(36133,336,207)">';
mtxt += '<area shape="circle" coords="341,207,3" href="javascript:selectTSpoints(36134,341,207)">';
mtxt += '<area shape="circle" coords="346,207,3" href="javascript:selectTSpoints(36135,346,207)">';
mtxt += '<area shape="circle" coords="351,207,3" href="javascript:selectTSpoints(36136,351,207)">';
mtxt += '<area shape="circle" coords="356,207,3" href="javascript:selectTSpoints(36137,356,207)">';
mtxt += '<area shape="circle" coords="361,207,3" href="javascript:selectTSpoints(36138,361,207)">';
mtxt += '<area shape="circle" coords="366,207,3" href="javascript:selectTSpoints(36139,366,207)">';
mtxt += '<area shape="circle" coords="371,207,3" href="javascript:selectTSpoints(36140,371,207)">';
mtxt += '<area shape="circle" coords="376,207,3" href="javascript:selectTSpoints(36141,376,207)">';
mtxt += '<area shape="circle" coords="381,207,3" href="javascript:selectTSpoints(36142,381,207)">';
mtxt += '<area shape="circle" coords="386,207,3" href="javascript:selectTSpoints(36143,386,207)">';
mtxt += '<area shape="circle" coords="392,207,3" href="javascript:selectTSpoints(36144,392,207)">';
mtxt += '<area shape="circle" coords="397,207,3" href="javascript:selectTSpoints(36001,397,207)">';
mtxt += '<area shape="circle" coords="402,207,3" href="javascript:selectTSpoints(36002,402,207)">';
mtxt += '<area shape="circle" coords="407,207,3" href="javascript:selectTSpoints(36003,407,207)">';
mtxt += '<area shape="circle" coords="412,207,3" href="javascript:selectTSpoints(36004,412,207)">';
mtxt += '<area shape="circle" coords="417,207,3" href="javascript:selectTSpoints(36005,417,207)">';
mtxt += '<area shape="circle" coords="422,207,3" href="javascript:selectTSpoints(36006,422,207)">';
mtxt += '<area shape="circle" coords="427,207,3" href="javascript:selectTSpoints(36007,427,207)">';
mtxt += '<area shape="circle" coords="432,207,3" href="javascript:selectTSpoints(36008,432,207)">';
mtxt += '<area shape="circle" coords="437,207,3" href="javascript:selectTSpoints(36009,437,207)">';
mtxt += '<area shape="circle" coords="442,207,3" href="javascript:selectTSpoints(36010,442,207)">';
mtxt += '<area shape="circle" coords="447,207,3" href="javascript:selectTSpoints(36011,447,207)">';
mtxt += '<area shape="circle" coords="453,207,3" href="javascript:selectTSpoints(36012,453,207)">';
mtxt += '<area shape="circle" coords="458,207,3" href="javascript:selectTSpoints(36013,458,207)">';
mtxt += '<area shape="circle" coords="463,207,3" href="javascript:selectTSpoints(36014,463,207)">';
mtxt += '<area shape="circle" coords="468,207,3" href="javascript:selectTSpoints(36015,468,207)">';
mtxt += '<area shape="circle" coords="473,207,3" href="javascript:selectTSpoints(36016,473,207)">';
mtxt += '<area shape="circle" coords="478,207,3" href="javascript:selectTSpoints(36017,478,207)">';
mtxt += '<area shape="circle" coords="483,207,3" href="javascript:selectTSpoints(36018,483,207)">';
mtxt += '<area shape="circle" coords="488,207,3" href="javascript:selectTSpoints(36019,488,207)">';
mtxt += '<area shape="circle" coords="493,207,3" href="javascript:selectTSpoints(36020,493,207)">';
mtxt += '<area shape="circle" coords="498,207,3" href="javascript:selectTSpoints(36021,498,207)">';
mtxt += '<area shape="circle" coords="503,207,3" href="javascript:selectTSpoints(36022,503,207)">';
mtxt += '<area shape="circle" coords="509,207,3" href="javascript:selectTSpoints(36023,509,207)">';
mtxt += '<area shape="circle" coords="514,207,3" href="javascript:selectTSpoints(36024,514,207)">';
mtxt += '<area shape="circle" coords="519,207,3" href="javascript:selectTSpoints(36025,519,207)">';
mtxt += '<area shape="circle" coords="524,207,3" href="javascript:selectTSpoints(36026,524,207)">';
mtxt += '<area shape="circle" coords="529,207,3" href="javascript:selectTSpoints(36027,529,207)">';
mtxt += '<area shape="circle" coords="534,207,3" href="javascript:selectTSpoints(36028,534,207)">';
mtxt += '<area shape="circle" coords="539,207,3" href="javascript:selectTSpoints(36029,539,207)">';
mtxt += '<area shape="circle" coords="544,207,3" href="javascript:selectTSpoints(36030,544,207)">';
mtxt += '<area shape="circle" coords="549,207,3" href="javascript:selectTSpoints(36031,549,207)">';
mtxt += '<area shape="circle" coords="554,207,3" href="javascript:selectTSpoints(36032,554,207)">';
mtxt += '<area shape="circle" coords="559,207,3" href="javascript:selectTSpoints(36033,559,207)">';
mtxt += '<area shape="circle" coords="565,207,3" href="javascript:selectTSpoints(36034,565,207)">';
mtxt += '<area shape="circle" coords="570,207,3" href="javascript:selectTSpoints(36035,570,207)">';
mtxt += '<area shape="circle" coords="575,207,3" href="javascript:selectTSpoints(36036,575,207)">';
mtxt += '<area shape="circle" coords="580,207,3" href="javascript:selectTSpoints(36037,580,207)">';
mtxt += '<area shape="circle" coords="585,207,3" href="javascript:selectTSpoints(36038,585,207)">';
mtxt += '<area shape="circle" coords="590,207,3" href="javascript:selectTSpoints(36039,590,207)">';
mtxt += '<area shape="circle" coords="595,207,3" href="javascript:selectTSpoints(36040,595,207)">';
mtxt += '<area shape="circle" coords="600,207,3" href="javascript:selectTSpoints(36041,600,207)">';
mtxt += '<area shape="circle" coords="605,207,3" href="javascript:selectTSpoints(36042,605,207)">';
mtxt += '<area shape="circle" coords="610,207,3" href="javascript:selectTSpoints(36043,610,207)">';
mtxt += '<area shape="circle" coords="615,207,3" href="javascript:selectTSpoints(36044,615,207)">';
mtxt += '<area shape="circle" coords="621,207,3" href="javascript:selectTSpoints(36045,621,207)">';
mtxt += '<area shape="circle" coords="626,207,3" href="javascript:selectTSpoints(36046,626,207)">';
mtxt += '<area shape="circle" coords="631,207,3" href="javascript:selectTSpoints(36047,631,207)">';
mtxt += '<area shape="circle" coords="636,207,3" href="javascript:selectTSpoints(36048,636,207)">';
mtxt += '<area shape="circle" coords="641,207,3" href="javascript:selectTSpoints(36049,641,207)">';
mtxt += '<area shape="circle" coords="646,207,3" href="javascript:selectTSpoints(36050,646,207)">';
mtxt += '<area shape="circle" coords="651,207,3" href="javascript:selectTSpoints(36051,651,207)">';
mtxt += '<area shape="circle" coords="656,207,3" href="javascript:selectTSpoints(36052,656,207)">';
mtxt += '<area shape="circle" coords="661,207,3" href="javascript:selectTSpoints(36053,661,207)">';
mtxt += '<area shape="circle" coords="666,207,3" href="javascript:selectTSpoints(36054,666,207)">';
mtxt += '<area shape="circle" coords="671,207,3" href="javascript:selectTSpoints(36055,671,207)">';
mtxt += '<area shape="circle" coords="677,207,3" href="javascript:selectTSpoints(36056,677,207)">';
mtxt += '<area shape="circle" coords="682,207,3" href="javascript:selectTSpoints(36057,682,207)">';
mtxt += '<area shape="circle" coords="687,207,3" href="javascript:selectTSpoints(36058,687,207)">';
mtxt += '<area shape="circle" coords="692,207,3" href="javascript:selectTSpoints(36059,692,207)">';
mtxt += '<area shape="circle" coords="697,207,3" href="javascript:selectTSpoints(36060,697,207)">';
mtxt += '<area shape="circle" coords="702,207,3" href="javascript:selectTSpoints(36061,702,207)">';
mtxt += '<area shape="circle" coords="707,207,3" href="javascript:selectTSpoints(36062,707,207)">';
mtxt += '<area shape="circle" coords="712,207,3" href="javascript:selectTSpoints(36063,712,207)">';
mtxt += '<area shape="circle" coords="717,207,3" href="javascript:selectTSpoints(36064,717,207)">';
mtxt += '<area shape="circle" coords="722,207,3" href="javascript:selectTSpoints(36065,722,207)">';
mtxt += '<area shape="circle" coords="727,207,3" href="javascript:selectTSpoints(36066,727,207)">';
mtxt += '<area shape="circle" coords="733,207,3" href="javascript:selectTSpoints(36067,733,207)">';
mtxt += '<area shape="circle" coords="738,207,3" href="javascript:selectTSpoints(36068,738,207)">';
mtxt += '<area shape="circle" coords="743,207,3" href="javascript:selectTSpoints(36069,743,207)">';
mtxt += '<area shape="circle" coords="748,207,3" href="javascript:selectTSpoints(36070,748,207)">';
mtxt += '<area shape="circle" coords="753,207,3" href="javascript:selectTSpoints(36071,753,207)">';
mtxt += '<area shape="circle" coords="758,207,3" href="javascript:selectTSpoints(36072,758,207)">';
mtxt += '<area shape="circle" coords=" 30,202,3" href="javascript:selectTSpoints(37073, 30,202)">';
mtxt += '<area shape="circle" coords=" 35,202,3" href="javascript:selectTSpoints(37074, 35,202)">';
mtxt += '<area shape="circle" coords=" 40,202,3" href="javascript:selectTSpoints(37075, 40,202)">';
mtxt += '<area shape="circle" coords=" 45,202,3" href="javascript:selectTSpoints(37076, 45,202)">';
mtxt += '<area shape="circle" coords=" 50,202,3" href="javascript:selectTSpoints(37077, 50,202)">';
mtxt += '<area shape="circle" coords=" 56,202,3" href="javascript:selectTSpoints(37078, 56,202)">';
mtxt += '<area shape="circle" coords=" 61,202,3" href="javascript:selectTSpoints(37079, 61,202)">';
mtxt += '<area shape="circle" coords=" 66,202,3" href="javascript:selectTSpoints(37080, 66,202)">';
mtxt += '<area shape="circle" coords=" 71,202,3" href="javascript:selectTSpoints(37081, 71,202)">';
mtxt += '<area shape="circle" coords=" 76,202,3" href="javascript:selectTSpoints(37082, 76,202)">';
mtxt += '<area shape="circle" coords=" 81,202,3" href="javascript:selectTSpoints(37083, 81,202)">';
mtxt += '<area shape="circle" coords=" 86,202,3" href="javascript:selectTSpoints(37084, 86,202)">';
mtxt += '<area shape="circle" coords=" 91,202,3" href="javascript:selectTSpoints(37085, 91,202)">';
mtxt += '<area shape="circle" coords=" 96,202,3" href="javascript:selectTSpoints(37086, 96,202)">';
mtxt += '<area shape="circle" coords="101,202,3" href="javascript:selectTSpoints(37087,101,202)">';
mtxt += '<area shape="circle" coords="106,202,3" href="javascript:selectTSpoints(37088,106,202)">';
mtxt += '<area shape="circle" coords="112,202,3" href="javascript:selectTSpoints(37089,112,202)">';
mtxt += '<area shape="circle" coords="117,202,3" href="javascript:selectTSpoints(37090,117,202)">';
mtxt += '<area shape="circle" coords="122,202,3" href="javascript:selectTSpoints(37091,122,202)">';
mtxt += '<area shape="circle" coords="127,202,3" href="javascript:selectTSpoints(37092,127,202)">';
mtxt += '<area shape="circle" coords="132,202,3" href="javascript:selectTSpoints(37093,132,202)">';
mtxt += '<area shape="circle" coords="137,202,3" href="javascript:selectTSpoints(37094,137,202)">';
mtxt += '<area shape="circle" coords="142,202,3" href="javascript:selectTSpoints(37095,142,202)">';
mtxt += '<area shape="circle" coords="147,202,3" href="javascript:selectTSpoints(37096,147,202)">';
mtxt += '<area shape="circle" coords="152,202,3" href="javascript:selectTSpoints(37097,152,202)">';
mtxt += '<area shape="circle" coords="157,202,3" href="javascript:selectTSpoints(37098,157,202)">';
mtxt += '<area shape="circle" coords="162,202,3" href="javascript:selectTSpoints(37099,162,202)">';
mtxt += '<area shape="circle" coords="168,202,3" href="javascript:selectTSpoints(37100,168,202)">';
mtxt += '<area shape="circle" coords="173,202,3" href="javascript:selectTSpoints(37101,173,202)">';
mtxt += '<area shape="circle" coords="178,202,3" href="javascript:selectTSpoints(37102,178,202)">';
mtxt += '<area shape="circle" coords="183,202,3" href="javascript:selectTSpoints(37103,183,202)">';
mtxt += '<area shape="circle" coords="188,202,3" href="javascript:selectTSpoints(37104,188,202)">';
mtxt += '<area shape="circle" coords="193,202,3" href="javascript:selectTSpoints(37105,193,202)">';
mtxt += '<area shape="circle" coords="198,202,3" href="javascript:selectTSpoints(37106,198,202)">';
mtxt += '<area shape="circle" coords="203,202,3" href="javascript:selectTSpoints(37107,203,202)">';
mtxt += '<area shape="circle" coords="208,202,3" href="javascript:selectTSpoints(37108,208,202)">';
mtxt += '<area shape="circle" coords="213,202,3" href="javascript:selectTSpoints(37109,213,202)">';
mtxt += '<area shape="circle" coords="218,202,3" href="javascript:selectTSpoints(37110,218,202)">';
mtxt += '<area shape="circle" coords="224,202,3" href="javascript:selectTSpoints(37111,224,202)">';
mtxt += '<area shape="circle" coords="229,202,3" href="javascript:selectTSpoints(37112,229,202)">';
mtxt += '<area shape="circle" coords="234,202,3" href="javascript:selectTSpoints(37113,234,202)">';
mtxt += '<area shape="circle" coords="239,202,3" href="javascript:selectTSpoints(37114,239,202)">';
mtxt += '<area shape="circle" coords="244,202,3" href="javascript:selectTSpoints(37115,244,202)">';
mtxt += '<area shape="circle" coords="249,202,3" href="javascript:selectTSpoints(37116,249,202)">';
mtxt += '<area shape="circle" coords="254,202,3" href="javascript:selectTSpoints(37117,254,202)">';
mtxt += '<area shape="circle" coords="259,202,3" href="javascript:selectTSpoints(37118,259,202)">';
mtxt += '<area shape="circle" coords="264,202,3" href="javascript:selectTSpoints(37119,264,202)">';
mtxt += '<area shape="circle" coords="269,202,3" href="javascript:selectTSpoints(37120,269,202)">';
mtxt += '<area shape="circle" coords="274,202,3" href="javascript:selectTSpoints(37121,274,202)">';
mtxt += '<area shape="circle" coords="280,202,3" href="javascript:selectTSpoints(37122,280,202)">';
mtxt += '<area shape="circle" coords="285,202,3" href="javascript:selectTSpoints(37123,285,202)">';
mtxt += '<area shape="circle" coords="290,202,3" href="javascript:selectTSpoints(37124,290,202)">';
mtxt += '<area shape="circle" coords="295,202,3" href="javascript:selectTSpoints(37125,295,202)">';
mtxt += '<area shape="circle" coords="300,202,3" href="javascript:selectTSpoints(37126,300,202)">';
mtxt += '<area shape="circle" coords="305,202,3" href="javascript:selectTSpoints(37127,305,202)">';
mtxt += '<area shape="circle" coords="310,202,3" href="javascript:selectTSpoints(37128,310,202)">';
mtxt += '<area shape="circle" coords="315,202,3" href="javascript:selectTSpoints(37129,315,202)">';
mtxt += '<area shape="circle" coords="320,202,3" href="javascript:selectTSpoints(37130,320,202)">';
mtxt += '<area shape="circle" coords="325,202,3" href="javascript:selectTSpoints(37131,325,202)">';
mtxt += '<area shape="circle" coords="330,202,3" href="javascript:selectTSpoints(37132,330,202)">';
mtxt += '<area shape="circle" coords="336,202,3" href="javascript:selectTSpoints(37133,336,202)">';
mtxt += '<area shape="circle" coords="341,202,3" href="javascript:selectTSpoints(37134,341,202)">';
mtxt += '<area shape="circle" coords="346,202,3" href="javascript:selectTSpoints(37135,346,202)">';
mtxt += '<area shape="circle" coords="351,202,3" href="javascript:selectTSpoints(37136,351,202)">';
mtxt += '<area shape="circle" coords="356,202,3" href="javascript:selectTSpoints(37137,356,202)">';
mtxt += '<area shape="circle" coords="361,202,3" href="javascript:selectTSpoints(37138,361,202)">';
mtxt += '<area shape="circle" coords="366,202,3" href="javascript:selectTSpoints(37139,366,202)">';
mtxt += '<area shape="circle" coords="371,202,3" href="javascript:selectTSpoints(37140,371,202)">';
mtxt += '<area shape="circle" coords="376,202,3" href="javascript:selectTSpoints(37141,376,202)">';
mtxt += '<area shape="circle" coords="381,202,3" href="javascript:selectTSpoints(37142,381,202)">';
mtxt += '<area shape="circle" coords="386,202,3" href="javascript:selectTSpoints(37143,386,202)">';
mtxt += '<area shape="circle" coords="392,202,3" href="javascript:selectTSpoints(37144,392,202)">';
mtxt += '<area shape="circle" coords="397,202,3" href="javascript:selectTSpoints(37001,397,202)">';
mtxt += '<area shape="circle" coords="402,202,3" href="javascript:selectTSpoints(37002,402,202)">';
mtxt += '<area shape="circle" coords="407,202,3" href="javascript:selectTSpoints(37003,407,202)">';
mtxt += '<area shape="circle" coords="412,202,3" href="javascript:selectTSpoints(37004,412,202)">';
mtxt += '<area shape="circle" coords="417,202,3" href="javascript:selectTSpoints(37005,417,202)">';
mtxt += '<area shape="circle" coords="422,202,3" href="javascript:selectTSpoints(37006,422,202)">';
mtxt += '<area shape="circle" coords="427,202,3" href="javascript:selectTSpoints(37007,427,202)">';
mtxt += '<area shape="circle" coords="432,202,3" href="javascript:selectTSpoints(37008,432,202)">';
mtxt += '<area shape="circle" coords="437,202,3" href="javascript:selectTSpoints(37009,437,202)">';
mtxt += '<area shape="circle" coords="442,202,3" href="javascript:selectTSpoints(37010,442,202)">';
mtxt += '<area shape="circle" coords="447,202,3" href="javascript:selectTSpoints(37011,447,202)">';
mtxt += '<area shape="circle" coords="453,202,3" href="javascript:selectTSpoints(37012,453,202)">';
mtxt += '<area shape="circle" coords="458,202,3" href="javascript:selectTSpoints(37013,458,202)">';
mtxt += '<area shape="circle" coords="463,202,3" href="javascript:selectTSpoints(37014,463,202)">';
mtxt += '<area shape="circle" coords="468,202,3" href="javascript:selectTSpoints(37015,468,202)">';
mtxt += '<area shape="circle" coords="473,202,3" href="javascript:selectTSpoints(37016,473,202)">';
mtxt += '<area shape="circle" coords="478,202,3" href="javascript:selectTSpoints(37017,478,202)">';
mtxt += '<area shape="circle" coords="483,202,3" href="javascript:selectTSpoints(37018,483,202)">';
mtxt += '<area shape="circle" coords="488,202,3" href="javascript:selectTSpoints(37019,488,202)">';
mtxt += '<area shape="circle" coords="493,202,3" href="javascript:selectTSpoints(37020,493,202)">';
mtxt += '<area shape="circle" coords="498,202,3" href="javascript:selectTSpoints(37021,498,202)">';
mtxt += '<area shape="circle" coords="503,202,3" href="javascript:selectTSpoints(37022,503,202)">';
mtxt += '<area shape="circle" coords="509,202,3" href="javascript:selectTSpoints(37023,509,202)">';
mtxt += '<area shape="circle" coords="514,202,3" href="javascript:selectTSpoints(37024,514,202)">';
mtxt += '<area shape="circle" coords="519,202,3" href="javascript:selectTSpoints(37025,519,202)">';
mtxt += '<area shape="circle" coords="524,202,3" href="javascript:selectTSpoints(37026,524,202)">';
mtxt += '<area shape="circle" coords="529,202,3" href="javascript:selectTSpoints(37027,529,202)">';
mtxt += '<area shape="circle" coords="534,202,3" href="javascript:selectTSpoints(37028,534,202)">';
mtxt += '<area shape="circle" coords="539,202,3" href="javascript:selectTSpoints(37029,539,202)">';
mtxt += '<area shape="circle" coords="544,202,3" href="javascript:selectTSpoints(37030,544,202)">';
mtxt += '<area shape="circle" coords="549,202,3" href="javascript:selectTSpoints(37031,549,202)">';
mtxt += '<area shape="circle" coords="554,202,3" href="javascript:selectTSpoints(37032,554,202)">';
mtxt += '<area shape="circle" coords="559,202,3" href="javascript:selectTSpoints(37033,559,202)">';
mtxt += '<area shape="circle" coords="565,202,3" href="javascript:selectTSpoints(37034,565,202)">';
mtxt += '<area shape="circle" coords="570,202,3" href="javascript:selectTSpoints(37035,570,202)">';
mtxt += '<area shape="circle" coords="575,202,3" href="javascript:selectTSpoints(37036,575,202)">';
mtxt += '<area shape="circle" coords="580,202,3" href="javascript:selectTSpoints(37037,580,202)">';
mtxt += '<area shape="circle" coords="585,202,3" href="javascript:selectTSpoints(37038,585,202)">';
mtxt += '<area shape="circle" coords="590,202,3" href="javascript:selectTSpoints(37039,590,202)">';
mtxt += '<area shape="circle" coords="595,202,3" href="javascript:selectTSpoints(37040,595,202)">';
mtxt += '<area shape="circle" coords="600,202,3" href="javascript:selectTSpoints(37041,600,202)">';
mtxt += '<area shape="circle" coords="605,202,3" href="javascript:selectTSpoints(37042,605,202)">';
mtxt += '<area shape="circle" coords="610,202,3" href="javascript:selectTSpoints(37043,610,202)">';
mtxt += '<area shape="circle" coords="615,202,3" href="javascript:selectTSpoints(37044,615,202)">';
mtxt += '<area shape="circle" coords="621,202,3" href="javascript:selectTSpoints(37045,621,202)">';
mtxt += '<area shape="circle" coords="626,202,3" href="javascript:selectTSpoints(37046,626,202)">';
mtxt += '<area shape="circle" coords="631,202,3" href="javascript:selectTSpoints(37047,631,202)">';
mtxt += '<area shape="circle" coords="636,202,3" href="javascript:selectTSpoints(37048,636,202)">';
mtxt += '<area shape="circle" coords="641,202,3" href="javascript:selectTSpoints(37049,641,202)">';
mtxt += '<area shape="circle" coords="646,202,3" href="javascript:selectTSpoints(37050,646,202)">';
mtxt += '<area shape="circle" coords="651,202,3" href="javascript:selectTSpoints(37051,651,202)">';
mtxt += '<area shape="circle" coords="656,202,3" href="javascript:selectTSpoints(37052,656,202)">';
mtxt += '<area shape="circle" coords="661,202,3" href="javascript:selectTSpoints(37053,661,202)">';
mtxt += '<area shape="circle" coords="666,202,3" href="javascript:selectTSpoints(37054,666,202)">';
mtxt += '<area shape="circle" coords="671,202,3" href="javascript:selectTSpoints(37055,671,202)">';
mtxt += '<area shape="circle" coords="677,202,3" href="javascript:selectTSpoints(37056,677,202)">';
mtxt += '<area shape="circle" coords="682,202,3" href="javascript:selectTSpoints(37057,682,202)">';
mtxt += '<area shape="circle" coords="687,202,3" href="javascript:selectTSpoints(37058,687,202)">';
mtxt += '<area shape="circle" coords="692,202,3" href="javascript:selectTSpoints(37059,692,202)">';
mtxt += '<area shape="circle" coords="697,202,3" href="javascript:selectTSpoints(37060,697,202)">';
mtxt += '<area shape="circle" coords="702,202,3" href="javascript:selectTSpoints(37061,702,202)">';
mtxt += '<area shape="circle" coords="707,202,3" href="javascript:selectTSpoints(37062,707,202)">';
mtxt += '<area shape="circle" coords="712,202,3" href="javascript:selectTSpoints(37063,712,202)">';
mtxt += '<area shape="circle" coords="717,202,3" href="javascript:selectTSpoints(37064,717,202)">';
mtxt += '<area shape="circle" coords="722,202,3" href="javascript:selectTSpoints(37065,722,202)">';
mtxt += '<area shape="circle" coords="727,202,3" href="javascript:selectTSpoints(37066,727,202)">';
mtxt += '<area shape="circle" coords="733,202,3" href="javascript:selectTSpoints(37067,733,202)">';
mtxt += '<area shape="circle" coords="738,202,3" href="javascript:selectTSpoints(37068,738,202)">';
mtxt += '<area shape="circle" coords="743,202,3" href="javascript:selectTSpoints(37069,743,202)">';
mtxt += '<area shape="circle" coords="748,202,3" href="javascript:selectTSpoints(37070,748,202)">';
mtxt += '<area shape="circle" coords="753,202,3" href="javascript:selectTSpoints(37071,753,202)">';
mtxt += '<area shape="circle" coords="758,202,3" href="javascript:selectTSpoints(37072,758,202)">';
mtxt += '<area shape="circle" coords=" 30,198,3" href="javascript:selectTSpoints(38073, 30,198)">';
mtxt += '<area shape="circle" coords=" 35,198,3" href="javascript:selectTSpoints(38074, 35,198)">';
mtxt += '<area shape="circle" coords=" 40,198,3" href="javascript:selectTSpoints(38075, 40,198)">';
mtxt += '<area shape="circle" coords=" 45,198,3" href="javascript:selectTSpoints(38076, 45,198)">';
mtxt += '<area shape="circle" coords=" 50,198,3" href="javascript:selectTSpoints(38077, 50,198)">';
mtxt += '<area shape="circle" coords=" 56,198,3" href="javascript:selectTSpoints(38078, 56,198)">';
mtxt += '<area shape="circle" coords=" 61,198,3" href="javascript:selectTSpoints(38079, 61,198)">';
mtxt += '<area shape="circle" coords=" 66,198,3" href="javascript:selectTSpoints(38080, 66,198)">';
mtxt += '<area shape="circle" coords=" 71,198,3" href="javascript:selectTSpoints(38081, 71,198)">';
mtxt += '<area shape="circle" coords=" 76,198,3" href="javascript:selectTSpoints(38082, 76,198)">';
mtxt += '<area shape="circle" coords=" 81,198,3" href="javascript:selectTSpoints(38083, 81,198)">';
mtxt += '<area shape="circle" coords=" 86,198,3" href="javascript:selectTSpoints(38084, 86,198)">';
mtxt += '<area shape="circle" coords=" 91,198,3" href="javascript:selectTSpoints(38085, 91,198)">';
mtxt += '<area shape="circle" coords=" 96,198,3" href="javascript:selectTSpoints(38086, 96,198)">';
mtxt += '<area shape="circle" coords="101,198,3" href="javascript:selectTSpoints(38087,101,198)">';
mtxt += '<area shape="circle" coords="106,198,3" href="javascript:selectTSpoints(38088,106,198)">';
mtxt += '<area shape="circle" coords="112,198,3" href="javascript:selectTSpoints(38089,112,198)">';
mtxt += '<area shape="circle" coords="117,198,3" href="javascript:selectTSpoints(38090,117,198)">';
mtxt += '<area shape="circle" coords="122,198,3" href="javascript:selectTSpoints(38091,122,198)">';
mtxt += '<area shape="circle" coords="127,198,3" href="javascript:selectTSpoints(38092,127,198)">';
mtxt += '<area shape="circle" coords="132,198,3" href="javascript:selectTSpoints(38093,132,198)">';
mtxt += '<area shape="circle" coords="137,198,3" href="javascript:selectTSpoints(38094,137,198)">';
mtxt += '<area shape="circle" coords="142,198,3" href="javascript:selectTSpoints(38095,142,198)">';
mtxt += '<area shape="circle" coords="147,198,3" href="javascript:selectTSpoints(38096,147,198)">';
mtxt += '<area shape="circle" coords="152,198,3" href="javascript:selectTSpoints(38097,152,198)">';
mtxt += '<area shape="circle" coords="157,198,3" href="javascript:selectTSpoints(38098,157,198)">';
mtxt += '<area shape="circle" coords="162,198,3" href="javascript:selectTSpoints(38099,162,198)">';
mtxt += '<area shape="circle" coords="168,198,3" href="javascript:selectTSpoints(38100,168,198)">';
mtxt += '<area shape="circle" coords="173,198,3" href="javascript:selectTSpoints(38101,173,198)">';
mtxt += '<area shape="circle" coords="178,198,3" href="javascript:selectTSpoints(38102,178,198)">';
mtxt += '<area shape="circle" coords="183,198,3" href="javascript:selectTSpoints(38103,183,198)">';
mtxt += '<area shape="circle" coords="188,198,3" href="javascript:selectTSpoints(38104,188,198)">';
mtxt += '<area shape="circle" coords="193,198,3" href="javascript:selectTSpoints(38105,193,198)">';
mtxt += '<area shape="circle" coords="198,198,3" href="javascript:selectTSpoints(38106,198,198)">';
mtxt += '<area shape="circle" coords="203,198,3" href="javascript:selectTSpoints(38107,203,198)">';
mtxt += '<area shape="circle" coords="208,198,3" href="javascript:selectTSpoints(38108,208,198)">';
mtxt += '<area shape="circle" coords="213,198,3" href="javascript:selectTSpoints(38109,213,198)">';
mtxt += '<area shape="circle" coords="218,198,3" href="javascript:selectTSpoints(38110,218,198)">';
mtxt += '<area shape="circle" coords="224,198,3" href="javascript:selectTSpoints(38111,224,198)">';
mtxt += '<area shape="circle" coords="229,198,3" href="javascript:selectTSpoints(38112,229,198)">';
mtxt += '<area shape="circle" coords="234,198,3" href="javascript:selectTSpoints(38113,234,198)">';
mtxt += '<area shape="circle" coords="239,198,3" href="javascript:selectTSpoints(38114,239,198)">';
mtxt += '<area shape="circle" coords="244,198,3" href="javascript:selectTSpoints(38115,244,198)">';
mtxt += '<area shape="circle" coords="249,198,3" href="javascript:selectTSpoints(38116,249,198)">';
mtxt += '<area shape="circle" coords="254,198,3" href="javascript:selectTSpoints(38117,254,198)">';
mtxt += '<area shape="circle" coords="259,198,3" href="javascript:selectTSpoints(38118,259,198)">';
mtxt += '<area shape="circle" coords="264,198,3" href="javascript:selectTSpoints(38119,264,198)">';
mtxt += '<area shape="circle" coords="269,198,3" href="javascript:selectTSpoints(38120,269,198)">';
mtxt += '<area shape="circle" coords="274,198,3" href="javascript:selectTSpoints(38121,274,198)">';
mtxt += '<area shape="circle" coords="280,198,3" href="javascript:selectTSpoints(38122,280,198)">';
mtxt += '<area shape="circle" coords="285,198,3" href="javascript:selectTSpoints(38123,285,198)">';
mtxt += '<area shape="circle" coords="290,198,3" href="javascript:selectTSpoints(38124,290,198)">';
mtxt += '<area shape="circle" coords="295,198,3" href="javascript:selectTSpoints(38125,295,198)">';
mtxt += '<area shape="circle" coords="300,198,3" href="javascript:selectTSpoints(38126,300,198)">';
mtxt += '<area shape="circle" coords="305,198,3" href="javascript:selectTSpoints(38127,305,198)">';
mtxt += '<area shape="circle" coords="310,198,3" href="javascript:selectTSpoints(38128,310,198)">';
mtxt += '<area shape="circle" coords="315,198,3" href="javascript:selectTSpoints(38129,315,198)">';
mtxt += '<area shape="circle" coords="320,198,3" href="javascript:selectTSpoints(38130,320,198)">';
mtxt += '<area shape="circle" coords="325,198,3" href="javascript:selectTSpoints(38131,325,198)">';
mtxt += '<area shape="circle" coords="330,198,3" href="javascript:selectTSpoints(38132,330,198)">';
mtxt += '<area shape="circle" coords="336,198,3" href="javascript:selectTSpoints(38133,336,198)">';
mtxt += '<area shape="circle" coords="341,198,3" href="javascript:selectTSpoints(38134,341,198)">';
mtxt += '<area shape="circle" coords="346,198,3" href="javascript:selectTSpoints(38135,346,198)">';
mtxt += '<area shape="circle" coords="351,198,3" href="javascript:selectTSpoints(38136,351,198)">';
mtxt += '<area shape="circle" coords="356,198,3" href="javascript:selectTSpoints(38137,356,198)">';
mtxt += '<area shape="circle" coords="361,198,3" href="javascript:selectTSpoints(38138,361,198)">';
mtxt += '<area shape="circle" coords="366,198,3" href="javascript:selectTSpoints(38139,366,198)">';
mtxt += '<area shape="circle" coords="371,198,3" href="javascript:selectTSpoints(38140,371,198)">';
mtxt += '<area shape="circle" coords="376,198,3" href="javascript:selectTSpoints(38141,376,198)">';
mtxt += '<area shape="circle" coords="381,198,3" href="javascript:selectTSpoints(38142,381,198)">';
mtxt += '<area shape="circle" coords="386,198,3" href="javascript:selectTSpoints(38143,386,198)">';
mtxt += '<area shape="circle" coords="392,198,3" href="javascript:selectTSpoints(38144,392,198)">';
mtxt += '<area shape="circle" coords="397,198,3" href="javascript:selectTSpoints(38001,397,198)">';
mtxt += '<area shape="circle" coords="402,198,3" href="javascript:selectTSpoints(38002,402,198)">';
mtxt += '<area shape="circle" coords="407,198,3" href="javascript:selectTSpoints(38003,407,198)">';
mtxt += '<area shape="circle" coords="412,198,3" href="javascript:selectTSpoints(38004,412,198)">';
mtxt += '<area shape="circle" coords="417,198,3" href="javascript:selectTSpoints(38005,417,198)">';
mtxt += '<area shape="circle" coords="422,198,3" href="javascript:selectTSpoints(38006,422,198)">';
mtxt += '<area shape="circle" coords="427,198,3" href="javascript:selectTSpoints(38007,427,198)">';
mtxt += '<area shape="circle" coords="432,198,3" href="javascript:selectTSpoints(38008,432,198)">';
mtxt += '<area shape="circle" coords="437,198,3" href="javascript:selectTSpoints(38009,437,198)">';
mtxt += '<area shape="circle" coords="442,198,3" href="javascript:selectTSpoints(38010,442,198)">';
mtxt += '<area shape="circle" coords="447,198,3" href="javascript:selectTSpoints(38011,447,198)">';
mtxt += '<area shape="circle" coords="453,198,3" href="javascript:selectTSpoints(38012,453,198)">';
mtxt += '<area shape="circle" coords="458,198,3" href="javascript:selectTSpoints(38013,458,198)">';
mtxt += '<area shape="circle" coords="463,198,3" href="javascript:selectTSpoints(38014,463,198)">';
mtxt += '<area shape="circle" coords="468,198,3" href="javascript:selectTSpoints(38015,468,198)">';
mtxt += '<area shape="circle" coords="473,198,3" href="javascript:selectTSpoints(38016,473,198)">';
mtxt += '<area shape="circle" coords="478,198,3" href="javascript:selectTSpoints(38017,478,198)">';
mtxt += '<area shape="circle" coords="483,198,3" href="javascript:selectTSpoints(38018,483,198)">';
mtxt += '<area shape="circle" coords="488,198,3" href="javascript:selectTSpoints(38019,488,198)">';
mtxt += '<area shape="circle" coords="493,198,3" href="javascript:selectTSpoints(38020,493,198)">';
mtxt += '<area shape="circle" coords="498,198,3" href="javascript:selectTSpoints(38021,498,198)">';
mtxt += '<area shape="circle" coords="503,198,3" href="javascript:selectTSpoints(38022,503,198)">';
mtxt += '<area shape="circle" coords="509,198,3" href="javascript:selectTSpoints(38023,509,198)">';
mtxt += '<area shape="circle" coords="514,198,3" href="javascript:selectTSpoints(38024,514,198)">';
mtxt += '<area shape="circle" coords="519,198,3" href="javascript:selectTSpoints(38025,519,198)">';
mtxt += '<area shape="circle" coords="524,198,3" href="javascript:selectTSpoints(38026,524,198)">';
mtxt += '<area shape="circle" coords="529,198,3" href="javascript:selectTSpoints(38027,529,198)">';
mtxt += '<area shape="circle" coords="534,198,3" href="javascript:selectTSpoints(38028,534,198)">';
mtxt += '<area shape="circle" coords="539,198,3" href="javascript:selectTSpoints(38029,539,198)">';
mtxt += '<area shape="circle" coords="544,198,3" href="javascript:selectTSpoints(38030,544,198)">';
mtxt += '<area shape="circle" coords="549,198,3" href="javascript:selectTSpoints(38031,549,198)">';
mtxt += '<area shape="circle" coords="554,198,3" href="javascript:selectTSpoints(38032,554,198)">';
mtxt += '<area shape="circle" coords="559,198,3" href="javascript:selectTSpoints(38033,559,198)">';
mtxt += '<area shape="circle" coords="565,198,3" href="javascript:selectTSpoints(38034,565,198)">';
mtxt += '<area shape="circle" coords="570,198,3" href="javascript:selectTSpoints(38035,570,198)">';
mtxt += '<area shape="circle" coords="575,198,3" href="javascript:selectTSpoints(38036,575,198)">';
mtxt += '<area shape="circle" coords="580,198,3" href="javascript:selectTSpoints(38037,580,198)">';
mtxt += '<area shape="circle" coords="585,198,3" href="javascript:selectTSpoints(38038,585,198)">';
mtxt += '<area shape="circle" coords="590,198,3" href="javascript:selectTSpoints(38039,590,198)">';
mtxt += '<area shape="circle" coords="595,198,3" href="javascript:selectTSpoints(38040,595,198)">';
mtxt += '<area shape="circle" coords="600,198,3" href="javascript:selectTSpoints(38041,600,198)">';
mtxt += '<area shape="circle" coords="605,198,3" href="javascript:selectTSpoints(38042,605,198)">';
mtxt += '<area shape="circle" coords="610,198,3" href="javascript:selectTSpoints(38043,610,198)">';
mtxt += '<area shape="circle" coords="615,198,3" href="javascript:selectTSpoints(38044,615,198)">';
mtxt += '<area shape="circle" coords="621,198,3" href="javascript:selectTSpoints(38045,621,198)">';
mtxt += '<area shape="circle" coords="626,198,3" href="javascript:selectTSpoints(38046,626,198)">';
mtxt += '<area shape="circle" coords="631,198,3" href="javascript:selectTSpoints(38047,631,198)">';
mtxt += '<area shape="circle" coords="636,198,3" href="javascript:selectTSpoints(38048,636,198)">';
mtxt += '<area shape="circle" coords="641,198,3" href="javascript:selectTSpoints(38049,641,198)">';
mtxt += '<area shape="circle" coords="646,198,3" href="javascript:selectTSpoints(38050,646,198)">';
mtxt += '<area shape="circle" coords="651,198,3" href="javascript:selectTSpoints(38051,651,198)">';
mtxt += '<area shape="circle" coords="656,198,3" href="javascript:selectTSpoints(38052,656,198)">';
mtxt += '<area shape="circle" coords="661,198,3" href="javascript:selectTSpoints(38053,661,198)">';
mtxt += '<area shape="circle" coords="666,198,3" href="javascript:selectTSpoints(38054,666,198)">';
mtxt += '<area shape="circle" coords="671,198,3" href="javascript:selectTSpoints(38055,671,198)">';
mtxt += '<area shape="circle" coords="677,198,3" href="javascript:selectTSpoints(38056,677,198)">';
mtxt += '<area shape="circle" coords="682,198,3" href="javascript:selectTSpoints(38057,682,198)">';
mtxt += '<area shape="circle" coords="687,198,3" href="javascript:selectTSpoints(38058,687,198)">';
mtxt += '<area shape="circle" coords="692,198,3" href="javascript:selectTSpoints(38059,692,198)">';
mtxt += '<area shape="circle" coords="697,198,3" href="javascript:selectTSpoints(38060,697,198)">';
mtxt += '<area shape="circle" coords="702,198,3" href="javascript:selectTSpoints(38061,702,198)">';
mtxt += '<area shape="circle" coords="707,198,3" href="javascript:selectTSpoints(38062,707,198)">';
mtxt += '<area shape="circle" coords="712,198,3" href="javascript:selectTSpoints(38063,712,198)">';
mtxt += '<area shape="circle" coords="717,198,3" href="javascript:selectTSpoints(38064,717,198)">';
mtxt += '<area shape="circle" coords="722,198,3" href="javascript:selectTSpoints(38065,722,198)">';
mtxt += '<area shape="circle" coords="727,198,3" href="javascript:selectTSpoints(38066,727,198)">';
mtxt += '<area shape="circle" coords="733,198,3" href="javascript:selectTSpoints(38067,733,198)">';
mtxt += '<area shape="circle" coords="738,198,3" href="javascript:selectTSpoints(38068,738,198)">';
mtxt += '<area shape="circle" coords="743,198,3" href="javascript:selectTSpoints(38069,743,198)">';
mtxt += '<area shape="circle" coords="748,198,3" href="javascript:selectTSpoints(38070,748,198)">';
mtxt += '<area shape="circle" coords="753,198,3" href="javascript:selectTSpoints(38071,753,198)">';
mtxt += '<area shape="circle" coords="758,198,3" href="javascript:selectTSpoints(38072,758,198)">';
mtxt += '<area shape="circle" coords=" 30,193,3" href="javascript:selectTSpoints(39073, 30,193)">';
mtxt += '<area shape="circle" coords=" 35,193,3" href="javascript:selectTSpoints(39074, 35,193)">';
mtxt += '<area shape="circle" coords=" 40,193,3" href="javascript:selectTSpoints(39075, 40,193)">';
mtxt += '<area shape="circle" coords=" 45,193,3" href="javascript:selectTSpoints(39076, 45,193)">';
mtxt += '<area shape="circle" coords=" 50,193,3" href="javascript:selectTSpoints(39077, 50,193)">';
mtxt += '<area shape="circle" coords=" 56,193,3" href="javascript:selectTSpoints(39078, 56,193)">';
mtxt += '<area shape="circle" coords=" 61,193,3" href="javascript:selectTSpoints(39079, 61,193)">';
mtxt += '<area shape="circle" coords=" 66,193,3" href="javascript:selectTSpoints(39080, 66,193)">';
mtxt += '<area shape="circle" coords=" 71,193,3" href="javascript:selectTSpoints(39081, 71,193)">';
mtxt += '<area shape="circle" coords=" 76,193,3" href="javascript:selectTSpoints(39082, 76,193)">';
mtxt += '<area shape="circle" coords=" 81,193,3" href="javascript:selectTSpoints(39083, 81,193)">';
mtxt += '<area shape="circle" coords=" 86,193,3" href="javascript:selectTSpoints(39084, 86,193)">';
mtxt += '<area shape="circle" coords=" 91,193,3" href="javascript:selectTSpoints(39085, 91,193)">';
mtxt += '<area shape="circle" coords=" 96,193,3" href="javascript:selectTSpoints(39086, 96,193)">';
mtxt += '<area shape="circle" coords="101,193,3" href="javascript:selectTSpoints(39087,101,193)">';
mtxt += '<area shape="circle" coords="106,193,3" href="javascript:selectTSpoints(39088,106,193)">';
mtxt += '<area shape="circle" coords="112,193,3" href="javascript:selectTSpoints(39089,112,193)">';
mtxt += '<area shape="circle" coords="117,193,3" href="javascript:selectTSpoints(39090,117,193)">';
mtxt += '<area shape="circle" coords="122,193,3" href="javascript:selectTSpoints(39091,122,193)">';
mtxt += '<area shape="circle" coords="127,193,3" href="javascript:selectTSpoints(39092,127,193)">';
mtxt += '<area shape="circle" coords="132,193,3" href="javascript:selectTSpoints(39093,132,193)">';
mtxt += '<area shape="circle" coords="137,193,3" href="javascript:selectTSpoints(39094,137,193)">';
mtxt += '<area shape="circle" coords="142,193,3" href="javascript:selectTSpoints(39095,142,193)">';
mtxt += '<area shape="circle" coords="147,193,3" href="javascript:selectTSpoints(39096,147,193)">';
mtxt += '<area shape="circle" coords="152,193,3" href="javascript:selectTSpoints(39097,152,193)">';
mtxt += '<area shape="circle" coords="157,193,3" href="javascript:selectTSpoints(39098,157,193)">';
mtxt += '<area shape="circle" coords="162,193,3" href="javascript:selectTSpoints(39099,162,193)">';
mtxt += '<area shape="circle" coords="168,193,3" href="javascript:selectTSpoints(39100,168,193)">';
mtxt += '<area shape="circle" coords="173,193,3" href="javascript:selectTSpoints(39101,173,193)">';
mtxt += '<area shape="circle" coords="178,193,3" href="javascript:selectTSpoints(39102,178,193)">';
mtxt += '<area shape="circle" coords="183,193,3" href="javascript:selectTSpoints(39103,183,193)">';
mtxt += '<area shape="circle" coords="188,193,3" href="javascript:selectTSpoints(39104,188,193)">';
mtxt += '<area shape="circle" coords="193,193,3" href="javascript:selectTSpoints(39105,193,193)">';
mtxt += '<area shape="circle" coords="198,193,3" href="javascript:selectTSpoints(39106,198,193)">';
mtxt += '<area shape="circle" coords="203,193,3" href="javascript:selectTSpoints(39107,203,193)">';
mtxt += '<area shape="circle" coords="208,193,3" href="javascript:selectTSpoints(39108,208,193)">';
mtxt += '<area shape="circle" coords="213,193,3" href="javascript:selectTSpoints(39109,213,193)">';
mtxt += '<area shape="circle" coords="218,193,3" href="javascript:selectTSpoints(39110,218,193)">';
mtxt += '<area shape="circle" coords="224,193,3" href="javascript:selectTSpoints(39111,224,193)">';
mtxt += '<area shape="circle" coords="229,193,3" href="javascript:selectTSpoints(39112,229,193)">';
mtxt += '<area shape="circle" coords="234,193,3" href="javascript:selectTSpoints(39113,234,193)">';
mtxt += '<area shape="circle" coords="239,193,3" href="javascript:selectTSpoints(39114,239,193)">';
mtxt += '<area shape="circle" coords="244,193,3" href="javascript:selectTSpoints(39115,244,193)">';
mtxt += '<area shape="circle" coords="249,193,3" href="javascript:selectTSpoints(39116,249,193)">';
mtxt += '<area shape="circle" coords="254,193,3" href="javascript:selectTSpoints(39117,254,193)">';
mtxt += '<area shape="circle" coords="259,193,3" href="javascript:selectTSpoints(39118,259,193)">';
mtxt += '<area shape="circle" coords="264,193,3" href="javascript:selectTSpoints(39119,264,193)">';
mtxt += '<area shape="circle" coords="269,193,3" href="javascript:selectTSpoints(39120,269,193)">';
mtxt += '<area shape="circle" coords="274,193,3" href="javascript:selectTSpoints(39121,274,193)">';
mtxt += '<area shape="circle" coords="280,193,3" href="javascript:selectTSpoints(39122,280,193)">';
mtxt += '<area shape="circle" coords="285,193,3" href="javascript:selectTSpoints(39123,285,193)">';
mtxt += '<area shape="circle" coords="290,193,3" href="javascript:selectTSpoints(39124,290,193)">';
mtxt += '<area shape="circle" coords="295,193,3" href="javascript:selectTSpoints(39125,295,193)">';
mtxt += '<area shape="circle" coords="300,193,3" href="javascript:selectTSpoints(39126,300,193)">';
mtxt += '<area shape="circle" coords="305,193,3" href="javascript:selectTSpoints(39127,305,193)">';
mtxt += '<area shape="circle" coords="310,193,3" href="javascript:selectTSpoints(39128,310,193)">';
mtxt += '<area shape="circle" coords="315,193,3" href="javascript:selectTSpoints(39129,315,193)">';
mtxt += '<area shape="circle" coords="320,193,3" href="javascript:selectTSpoints(39130,320,193)">';
mtxt += '<area shape="circle" coords="325,193,3" href="javascript:selectTSpoints(39131,325,193)">';
mtxt += '<area shape="circle" coords="330,193,3" href="javascript:selectTSpoints(39132,330,193)">';
mtxt += '<area shape="circle" coords="336,193,3" href="javascript:selectTSpoints(39133,336,193)">';
mtxt += '<area shape="circle" coords="341,193,3" href="javascript:selectTSpoints(39134,341,193)">';
mtxt += '<area shape="circle" coords="346,193,3" href="javascript:selectTSpoints(39135,346,193)">';
mtxt += '<area shape="circle" coords="351,193,3" href="javascript:selectTSpoints(39136,351,193)">';
mtxt += '<area shape="circle" coords="356,193,3" href="javascript:selectTSpoints(39137,356,193)">';
mtxt += '<area shape="circle" coords="361,193,3" href="javascript:selectTSpoints(39138,361,193)">';
mtxt += '<area shape="circle" coords="366,193,3" href="javascript:selectTSpoints(39139,366,193)">';
mtxt += '<area shape="circle" coords="371,193,3" href="javascript:selectTSpoints(39140,371,193)">';
mtxt += '<area shape="circle" coords="376,193,3" href="javascript:selectTSpoints(39141,376,193)">';
mtxt += '<area shape="circle" coords="381,193,3" href="javascript:selectTSpoints(39142,381,193)">';
mtxt += '<area shape="circle" coords="386,193,3" href="javascript:selectTSpoints(39143,386,193)">';
mtxt += '<area shape="circle" coords="392,193,3" href="javascript:selectTSpoints(39144,392,193)">';
mtxt += '<area shape="circle" coords="397,193,3" href="javascript:selectTSpoints(39001,397,193)">';
mtxt += '<area shape="circle" coords="402,193,3" href="javascript:selectTSpoints(39002,402,193)">';
mtxt += '<area shape="circle" coords="407,193,3" href="javascript:selectTSpoints(39003,407,193)">';
mtxt += '<area shape="circle" coords="412,193,3" href="javascript:selectTSpoints(39004,412,193)">';
mtxt += '<area shape="circle" coords="417,193,3" href="javascript:selectTSpoints(39005,417,193)">';
mtxt += '<area shape="circle" coords="422,193,3" href="javascript:selectTSpoints(39006,422,193)">';
mtxt += '<area shape="circle" coords="427,193,3" href="javascript:selectTSpoints(39007,427,193)">';
mtxt += '<area shape="circle" coords="432,193,3" href="javascript:selectTSpoints(39008,432,193)">';
mtxt += '<area shape="circle" coords="437,193,3" href="javascript:selectTSpoints(39009,437,193)">';
mtxt += '<area shape="circle" coords="442,193,3" href="javascript:selectTSpoints(39010,442,193)">';
mtxt += '<area shape="circle" coords="447,193,3" href="javascript:selectTSpoints(39011,447,193)">';
mtxt += '<area shape="circle" coords="453,193,3" href="javascript:selectTSpoints(39012,453,193)">';
mtxt += '<area shape="circle" coords="458,193,3" href="javascript:selectTSpoints(39013,458,193)">';
mtxt += '<area shape="circle" coords="463,193,3" href="javascript:selectTSpoints(39014,463,193)">';
mtxt += '<area shape="circle" coords="468,193,3" href="javascript:selectTSpoints(39015,468,193)">';
mtxt += '<area shape="circle" coords="473,193,3" href="javascript:selectTSpoints(39016,473,193)">';
mtxt += '<area shape="circle" coords="478,193,3" href="javascript:selectTSpoints(39017,478,193)">';
mtxt += '<area shape="circle" coords="483,193,3" href="javascript:selectTSpoints(39018,483,193)">';
mtxt += '<area shape="circle" coords="488,193,3" href="javascript:selectTSpoints(39019,488,193)">';
mtxt += '<area shape="circle" coords="493,193,3" href="javascript:selectTSpoints(39020,493,193)">';
mtxt += '<area shape="circle" coords="498,193,3" href="javascript:selectTSpoints(39021,498,193)">';
mtxt += '<area shape="circle" coords="503,193,3" href="javascript:selectTSpoints(39022,503,193)">';
mtxt += '<area shape="circle" coords="509,193,3" href="javascript:selectTSpoints(39023,509,193)">';
mtxt += '<area shape="circle" coords="514,193,3" href="javascript:selectTSpoints(39024,514,193)">';
mtxt += '<area shape="circle" coords="519,193,3" href="javascript:selectTSpoints(39025,519,193)">';
mtxt += '<area shape="circle" coords="524,193,3" href="javascript:selectTSpoints(39026,524,193)">';
mtxt += '<area shape="circle" coords="529,193,3" href="javascript:selectTSpoints(39027,529,193)">';
mtxt += '<area shape="circle" coords="534,193,3" href="javascript:selectTSpoints(39028,534,193)">';
mtxt += '<area shape="circle" coords="539,193,3" href="javascript:selectTSpoints(39029,539,193)">';
mtxt += '<area shape="circle" coords="544,193,3" href="javascript:selectTSpoints(39030,544,193)">';
mtxt += '<area shape="circle" coords="549,193,3" href="javascript:selectTSpoints(39031,549,193)">';
mtxt += '<area shape="circle" coords="554,193,3" href="javascript:selectTSpoints(39032,554,193)">';
mtxt += '<area shape="circle" coords="559,193,3" href="javascript:selectTSpoints(39033,559,193)">';
mtxt += '<area shape="circle" coords="565,193,3" href="javascript:selectTSpoints(39034,565,193)">';
mtxt += '<area shape="circle" coords="570,193,3" href="javascript:selectTSpoints(39035,570,193)">';
mtxt += '<area shape="circle" coords="575,193,3" href="javascript:selectTSpoints(39036,575,193)">';
mtxt += '<area shape="circle" coords="580,193,3" href="javascript:selectTSpoints(39037,580,193)">';
mtxt += '<area shape="circle" coords="585,193,3" href="javascript:selectTSpoints(39038,585,193)">';
mtxt += '<area shape="circle" coords="590,193,3" href="javascript:selectTSpoints(39039,590,193)">';
mtxt += '<area shape="circle" coords="595,193,3" href="javascript:selectTSpoints(39040,595,193)">';
mtxt += '<area shape="circle" coords="600,193,3" href="javascript:selectTSpoints(39041,600,193)">';
mtxt += '<area shape="circle" coords="605,193,3" href="javascript:selectTSpoints(39042,605,193)">';
mtxt += '<area shape="circle" coords="610,193,3" href="javascript:selectTSpoints(39043,610,193)">';
mtxt += '<area shape="circle" coords="615,193,3" href="javascript:selectTSpoints(39044,615,193)">';
mtxt += '<area shape="circle" coords="621,193,3" href="javascript:selectTSpoints(39045,621,193)">';
mtxt += '<area shape="circle" coords="626,193,3" href="javascript:selectTSpoints(39046,626,193)">';
mtxt += '<area shape="circle" coords="631,193,3" href="javascript:selectTSpoints(39047,631,193)">';
mtxt += '<area shape="circle" coords="636,193,3" href="javascript:selectTSpoints(39048,636,193)">';
mtxt += '<area shape="circle" coords="641,193,3" href="javascript:selectTSpoints(39049,641,193)">';
mtxt += '<area shape="circle" coords="646,193,3" href="javascript:selectTSpoints(39050,646,193)">';
mtxt += '<area shape="circle" coords="651,193,3" href="javascript:selectTSpoints(39051,651,193)">';
mtxt += '<area shape="circle" coords="656,193,3" href="javascript:selectTSpoints(39052,656,193)">';
mtxt += '<area shape="circle" coords="661,193,3" href="javascript:selectTSpoints(39053,661,193)">';
mtxt += '<area shape="circle" coords="666,193,3" href="javascript:selectTSpoints(39054,666,193)">';
mtxt += '<area shape="circle" coords="671,193,3" href="javascript:selectTSpoints(39055,671,193)">';
mtxt += '<area shape="circle" coords="677,193,3" href="javascript:selectTSpoints(39056,677,193)">';
mtxt += '<area shape="circle" coords="682,193,3" href="javascript:selectTSpoints(39057,682,193)">';
mtxt += '<area shape="circle" coords="687,193,3" href="javascript:selectTSpoints(39058,687,193)">';
mtxt += '<area shape="circle" coords="692,193,3" href="javascript:selectTSpoints(39059,692,193)">';
mtxt += '<area shape="circle" coords="697,193,3" href="javascript:selectTSpoints(39060,697,193)">';
mtxt += '<area shape="circle" coords="702,193,3" href="javascript:selectTSpoints(39061,702,193)">';
mtxt += '<area shape="circle" coords="707,193,3" href="javascript:selectTSpoints(39062,707,193)">';
mtxt += '<area shape="circle" coords="712,193,3" href="javascript:selectTSpoints(39063,712,193)">';
mtxt += '<area shape="circle" coords="717,193,3" href="javascript:selectTSpoints(39064,717,193)">';
mtxt += '<area shape="circle" coords="722,193,3" href="javascript:selectTSpoints(39065,722,193)">';
mtxt += '<area shape="circle" coords="727,193,3" href="javascript:selectTSpoints(39066,727,193)">';
mtxt += '<area shape="circle" coords="733,193,3" href="javascript:selectTSpoints(39067,733,193)">';
mtxt += '<area shape="circle" coords="738,193,3" href="javascript:selectTSpoints(39068,738,193)">';
mtxt += '<area shape="circle" coords="743,193,3" href="javascript:selectTSpoints(39069,743,193)">';
mtxt += '<area shape="circle" coords="748,193,3" href="javascript:selectTSpoints(39070,748,193)">';
mtxt += '<area shape="circle" coords="753,193,3" href="javascript:selectTSpoints(39071,753,193)">';
mtxt += '<area shape="circle" coords="758,193,3" href="javascript:selectTSpoints(39072,758,193)">';
mtxt += '<area shape="circle" coords=" 30,188,3" href="javascript:selectTSpoints(40073, 30,188)">';
mtxt += '<area shape="circle" coords=" 35,188,3" href="javascript:selectTSpoints(40074, 35,188)">';
mtxt += '<area shape="circle" coords=" 40,188,3" href="javascript:selectTSpoints(40075, 40,188)">';
mtxt += '<area shape="circle" coords=" 45,188,3" href="javascript:selectTSpoints(40076, 45,188)">';
mtxt += '<area shape="circle" coords=" 50,188,3" href="javascript:selectTSpoints(40077, 50,188)">';
mtxt += '<area shape="circle" coords=" 56,188,3" href="javascript:selectTSpoints(40078, 56,188)">';
mtxt += '<area shape="circle" coords=" 61,188,3" href="javascript:selectTSpoints(40079, 61,188)">';
mtxt += '<area shape="circle" coords=" 66,188,3" href="javascript:selectTSpoints(40080, 66,188)">';
mtxt += '<area shape="circle" coords=" 71,188,3" href="javascript:selectTSpoints(40081, 71,188)">';
mtxt += '<area shape="circle" coords=" 76,188,3" href="javascript:selectTSpoints(40082, 76,188)">';
mtxt += '<area shape="circle" coords=" 81,188,3" href="javascript:selectTSpoints(40083, 81,188)">';
mtxt += '<area shape="circle" coords=" 86,188,3" href="javascript:selectTSpoints(40084, 86,188)">';
mtxt += '<area shape="circle" coords=" 91,188,3" href="javascript:selectTSpoints(40085, 91,188)">';
mtxt += '<area shape="circle" coords=" 96,188,3" href="javascript:selectTSpoints(40086, 96,188)">';
mtxt += '<area shape="circle" coords="101,188,3" href="javascript:selectTSpoints(40087,101,188)">';
mtxt += '<area shape="circle" coords="106,188,3" href="javascript:selectTSpoints(40088,106,188)">';
mtxt += '<area shape="circle" coords="112,188,3" href="javascript:selectTSpoints(40089,112,188)">';
mtxt += '<area shape="circle" coords="117,188,3" href="javascript:selectTSpoints(40090,117,188)">';
mtxt += '<area shape="circle" coords="122,188,3" href="javascript:selectTSpoints(40091,122,188)">';
mtxt += '<area shape="circle" coords="127,188,3" href="javascript:selectTSpoints(40092,127,188)">';
mtxt += '<area shape="circle" coords="132,188,3" href="javascript:selectTSpoints(40093,132,188)">';
mtxt += '<area shape="circle" coords="137,188,3" href="javascript:selectTSpoints(40094,137,188)">';
mtxt += '<area shape="circle" coords="142,188,3" href="javascript:selectTSpoints(40095,142,188)">';
mtxt += '<area shape="circle" coords="147,188,3" href="javascript:selectTSpoints(40096,147,188)">';
mtxt += '<area shape="circle" coords="152,188,3" href="javascript:selectTSpoints(40097,152,188)">';
mtxt += '<area shape="circle" coords="157,188,3" href="javascript:selectTSpoints(40098,157,188)">';
mtxt += '<area shape="circle" coords="162,188,3" href="javascript:selectTSpoints(40099,162,188)">';
mtxt += '<area shape="circle" coords="168,188,3" href="javascript:selectTSpoints(40100,168,188)">';
mtxt += '<area shape="circle" coords="173,188,3" href="javascript:selectTSpoints(40101,173,188)">';
mtxt += '<area shape="circle" coords="178,188,3" href="javascript:selectTSpoints(40102,178,188)">';
mtxt += '<area shape="circle" coords="183,188,3" href="javascript:selectTSpoints(40103,183,188)">';
mtxt += '<area shape="circle" coords="188,188,3" href="javascript:selectTSpoints(40104,188,188)">';
mtxt += '<area shape="circle" coords="193,188,3" href="javascript:selectTSpoints(40105,193,188)">';
mtxt += '<area shape="circle" coords="198,188,3" href="javascript:selectTSpoints(40106,198,188)">';
mtxt += '<area shape="circle" coords="203,188,3" href="javascript:selectTSpoints(40107,203,188)">';
mtxt += '<area shape="circle" coords="208,188,3" href="javascript:selectTSpoints(40108,208,188)">';
mtxt += '<area shape="circle" coords="213,188,3" href="javascript:selectTSpoints(40109,213,188)">';
mtxt += '<area shape="circle" coords="218,188,3" href="javascript:selectTSpoints(40110,218,188)">';
mtxt += '<area shape="circle" coords="224,188,3" href="javascript:selectTSpoints(40111,224,188)">';
mtxt += '<area shape="circle" coords="229,188,3" href="javascript:selectTSpoints(40112,229,188)">';
mtxt += '<area shape="circle" coords="234,188,3" href="javascript:selectTSpoints(40113,234,188)">';
mtxt += '<area shape="circle" coords="239,188,3" href="javascript:selectTSpoints(40114,239,188)">';
mtxt += '<area shape="circle" coords="244,188,3" href="javascript:selectTSpoints(40115,244,188)">';
mtxt += '<area shape="circle" coords="249,188,3" href="javascript:selectTSpoints(40116,249,188)">';
mtxt += '<area shape="circle" coords="254,188,3" href="javascript:selectTSpoints(40117,254,188)">';
mtxt += '<area shape="circle" coords="259,188,3" href="javascript:selectTSpoints(40118,259,188)">';
mtxt += '<area shape="circle" coords="264,188,3" href="javascript:selectTSpoints(40119,264,188)">';
mtxt += '<area shape="circle" coords="269,188,3" href="javascript:selectTSpoints(40120,269,188)">';
mtxt += '<area shape="circle" coords="274,188,3" href="javascript:selectTSpoints(40121,274,188)">';
mtxt += '<area shape="circle" coords="280,188,3" href="javascript:selectTSpoints(40122,280,188)">';
mtxt += '<area shape="circle" coords="285,188,3" href="javascript:selectTSpoints(40123,285,188)">';
mtxt += '<area shape="circle" coords="290,188,3" href="javascript:selectTSpoints(40124,290,188)">';
mtxt += '<area shape="circle" coords="295,188,3" href="javascript:selectTSpoints(40125,295,188)">';
mtxt += '<area shape="circle" coords="300,188,3" href="javascript:selectTSpoints(40126,300,188)">';
mtxt += '<area shape="circle" coords="305,188,3" href="javascript:selectTSpoints(40127,305,188)">';
mtxt += '<area shape="circle" coords="310,188,3" href="javascript:selectTSpoints(40128,310,188)">';
mtxt += '<area shape="circle" coords="315,188,3" href="javascript:selectTSpoints(40129,315,188)">';
mtxt += '<area shape="circle" coords="320,188,3" href="javascript:selectTSpoints(40130,320,188)">';
mtxt += '<area shape="circle" coords="325,188,3" href="javascript:selectTSpoints(40131,325,188)">';
mtxt += '<area shape="circle" coords="330,188,3" href="javascript:selectTSpoints(40132,330,188)">';
mtxt += '<area shape="circle" coords="336,188,3" href="javascript:selectTSpoints(40133,336,188)">';
mtxt += '<area shape="circle" coords="341,188,3" href="javascript:selectTSpoints(40134,341,188)">';
mtxt += '<area shape="circle" coords="346,188,3" href="javascript:selectTSpoints(40135,346,188)">';
mtxt += '<area shape="circle" coords="351,188,3" href="javascript:selectTSpoints(40136,351,188)">';
mtxt += '<area shape="circle" coords="356,188,3" href="javascript:selectTSpoints(40137,356,188)">';
mtxt += '<area shape="circle" coords="361,188,3" href="javascript:selectTSpoints(40138,361,188)">';
mtxt += '<area shape="circle" coords="366,188,3" href="javascript:selectTSpoints(40139,366,188)">';
mtxt += '<area shape="circle" coords="371,188,3" href="javascript:selectTSpoints(40140,371,188)">';
mtxt += '<area shape="circle" coords="376,188,3" href="javascript:selectTSpoints(40141,376,188)">';
mtxt += '<area shape="circle" coords="381,188,3" href="javascript:selectTSpoints(40142,381,188)">';
mtxt += '<area shape="circle" coords="386,188,3" href="javascript:selectTSpoints(40143,386,188)">';
mtxt += '<area shape="circle" coords="392,188,3" href="javascript:selectTSpoints(40144,392,188)">';
mtxt += '<area shape="circle" coords="397,188,3" href="javascript:selectTSpoints(40001,397,188)">';
mtxt += '<area shape="circle" coords="402,188,3" href="javascript:selectTSpoints(40002,402,188)">';
mtxt += '<area shape="circle" coords="407,188,3" href="javascript:selectTSpoints(40003,407,188)">';
mtxt += '<area shape="circle" coords="412,188,3" href="javascript:selectTSpoints(40004,412,188)">';
mtxt += '<area shape="circle" coords="417,188,3" href="javascript:selectTSpoints(40005,417,188)">';
mtxt += '<area shape="circle" coords="422,188,3" href="javascript:selectTSpoints(40006,422,188)">';
mtxt += '<area shape="circle" coords="427,188,3" href="javascript:selectTSpoints(40007,427,188)">';
mtxt += '<area shape="circle" coords="432,188,3" href="javascript:selectTSpoints(40008,432,188)">';
mtxt += '<area shape="circle" coords="437,188,3" href="javascript:selectTSpoints(40009,437,188)">';
mtxt += '<area shape="circle" coords="442,188,3" href="javascript:selectTSpoints(40010,442,188)">';
mtxt += '<area shape="circle" coords="447,188,3" href="javascript:selectTSpoints(40011,447,188)">';
mtxt += '<area shape="circle" coords="453,188,3" href="javascript:selectTSpoints(40012,453,188)">';
mtxt += '<area shape="circle" coords="458,188,3" href="javascript:selectTSpoints(40013,458,188)">';
mtxt += '<area shape="circle" coords="463,188,3" href="javascript:selectTSpoints(40014,463,188)">';
mtxt += '<area shape="circle" coords="468,188,3" href="javascript:selectTSpoints(40015,468,188)">';
mtxt += '<area shape="circle" coords="473,188,3" href="javascript:selectTSpoints(40016,473,188)">';
mtxt += '<area shape="circle" coords="478,188,3" href="javascript:selectTSpoints(40017,478,188)">';
mtxt += '<area shape="circle" coords="483,188,3" href="javascript:selectTSpoints(40018,483,188)">';
mtxt += '<area shape="circle" coords="488,188,3" href="javascript:selectTSpoints(40019,488,188)">';
mtxt += '<area shape="circle" coords="493,188,3" href="javascript:selectTSpoints(40020,493,188)">';
mtxt += '<area shape="circle" coords="498,188,3" href="javascript:selectTSpoints(40021,498,188)">';
mtxt += '<area shape="circle" coords="503,188,3" href="javascript:selectTSpoints(40022,503,188)">';
mtxt += '<area shape="circle" coords="509,188,3" href="javascript:selectTSpoints(40023,509,188)">';
mtxt += '<area shape="circle" coords="514,188,3" href="javascript:selectTSpoints(40024,514,188)">';
mtxt += '<area shape="circle" coords="519,188,3" href="javascript:selectTSpoints(40025,519,188)">';
mtxt += '<area shape="circle" coords="524,188,3" href="javascript:selectTSpoints(40026,524,188)">';
mtxt += '<area shape="circle" coords="529,188,3" href="javascript:selectTSpoints(40027,529,188)">';
mtxt += '<area shape="circle" coords="534,188,3" href="javascript:selectTSpoints(40028,534,188)">';
mtxt += '<area shape="circle" coords="539,188,3" href="javascript:selectTSpoints(40029,539,188)">';
mtxt += '<area shape="circle" coords="544,188,3" href="javascript:selectTSpoints(40030,544,188)">';
mtxt += '<area shape="circle" coords="549,188,3" href="javascript:selectTSpoints(40031,549,188)">';
mtxt += '<area shape="circle" coords="554,188,3" href="javascript:selectTSpoints(40032,554,188)">';
mtxt += '<area shape="circle" coords="559,188,3" href="javascript:selectTSpoints(40033,559,188)">';
mtxt += '<area shape="circle" coords="565,188,3" href="javascript:selectTSpoints(40034,565,188)">';
mtxt += '<area shape="circle" coords="570,188,3" href="javascript:selectTSpoints(40035,570,188)">';
mtxt += '<area shape="circle" coords="575,188,3" href="javascript:selectTSpoints(40036,575,188)">';
mtxt += '<area shape="circle" coords="580,188,3" href="javascript:selectTSpoints(40037,580,188)">';
mtxt += '<area shape="circle" coords="585,188,3" href="javascript:selectTSpoints(40038,585,188)">';
mtxt += '<area shape="circle" coords="590,188,3" href="javascript:selectTSpoints(40039,590,188)">';
mtxt += '<area shape="circle" coords="595,188,3" href="javascript:selectTSpoints(40040,595,188)">';
mtxt += '<area shape="circle" coords="600,188,3" href="javascript:selectTSpoints(40041,600,188)">';
mtxt += '<area shape="circle" coords="605,188,3" href="javascript:selectTSpoints(40042,605,188)">';
mtxt += '<area shape="circle" coords="610,188,3" href="javascript:selectTSpoints(40043,610,188)">';
mtxt += '<area shape="circle" coords="615,188,3" href="javascript:selectTSpoints(40044,615,188)">';
mtxt += '<area shape="circle" coords="621,188,3" href="javascript:selectTSpoints(40045,621,188)">';
mtxt += '<area shape="circle" coords="626,188,3" href="javascript:selectTSpoints(40046,626,188)">';
mtxt += '<area shape="circle" coords="631,188,3" href="javascript:selectTSpoints(40047,631,188)">';
mtxt += '<area shape="circle" coords="636,188,3" href="javascript:selectTSpoints(40048,636,188)">';
mtxt += '<area shape="circle" coords="641,188,3" href="javascript:selectTSpoints(40049,641,188)">';
mtxt += '<area shape="circle" coords="646,188,3" href="javascript:selectTSpoints(40050,646,188)">';
mtxt += '<area shape="circle" coords="651,188,3" href="javascript:selectTSpoints(40051,651,188)">';
mtxt += '<area shape="circle" coords="656,188,3" href="javascript:selectTSpoints(40052,656,188)">';
mtxt += '<area shape="circle" coords="661,188,3" href="javascript:selectTSpoints(40053,661,188)">';
mtxt += '<area shape="circle" coords="666,188,3" href="javascript:selectTSpoints(40054,666,188)">';
mtxt += '<area shape="circle" coords="671,188,3" href="javascript:selectTSpoints(40055,671,188)">';
mtxt += '<area shape="circle" coords="677,188,3" href="javascript:selectTSpoints(40056,677,188)">';
mtxt += '<area shape="circle" coords="682,188,3" href="javascript:selectTSpoints(40057,682,188)">';
mtxt += '<area shape="circle" coords="687,188,3" href="javascript:selectTSpoints(40058,687,188)">';
mtxt += '<area shape="circle" coords="692,188,3" href="javascript:selectTSpoints(40059,692,188)">';
mtxt += '<area shape="circle" coords="697,188,3" href="javascript:selectTSpoints(40060,697,188)">';
mtxt += '<area shape="circle" coords="702,188,3" href="javascript:selectTSpoints(40061,702,188)">';
mtxt += '<area shape="circle" coords="707,188,3" href="javascript:selectTSpoints(40062,707,188)">';
mtxt += '<area shape="circle" coords="712,188,3" href="javascript:selectTSpoints(40063,712,188)">';
mtxt += '<area shape="circle" coords="717,188,3" href="javascript:selectTSpoints(40064,717,188)">';
mtxt += '<area shape="circle" coords="722,188,3" href="javascript:selectTSpoints(40065,722,188)">';
mtxt += '<area shape="circle" coords="727,188,3" href="javascript:selectTSpoints(40066,727,188)">';
mtxt += '<area shape="circle" coords="733,188,3" href="javascript:selectTSpoints(40067,733,188)">';
mtxt += '<area shape="circle" coords="738,188,3" href="javascript:selectTSpoints(40068,738,188)">';
mtxt += '<area shape="circle" coords="743,188,3" href="javascript:selectTSpoints(40069,743,188)">';
mtxt += '<area shape="circle" coords="748,188,3" href="javascript:selectTSpoints(40070,748,188)">';
mtxt += '<area shape="circle" coords="753,188,3" href="javascript:selectTSpoints(40071,753,188)">';
mtxt += '<area shape="circle" coords="758,188,3" href="javascript:selectTSpoints(40072,758,188)">';
mtxt += '<area shape="circle" coords=" 30,183,3" href="javascript:selectTSpoints(41073, 30,183)">';
mtxt += '<area shape="circle" coords=" 35,183,3" href="javascript:selectTSpoints(41074, 35,183)">';
mtxt += '<area shape="circle" coords=" 40,183,3" href="javascript:selectTSpoints(41075, 40,183)">';
mtxt += '<area shape="circle" coords=" 45,183,3" href="javascript:selectTSpoints(41076, 45,183)">';
mtxt += '<area shape="circle" coords=" 50,183,3" href="javascript:selectTSpoints(41077, 50,183)">';
mtxt += '<area shape="circle" coords=" 56,183,3" href="javascript:selectTSpoints(41078, 56,183)">';
mtxt += '<area shape="circle" coords=" 61,183,3" href="javascript:selectTSpoints(41079, 61,183)">';
mtxt += '<area shape="circle" coords=" 66,183,3" href="javascript:selectTSpoints(41080, 66,183)">';
mtxt += '<area shape="circle" coords=" 71,183,3" href="javascript:selectTSpoints(41081, 71,183)">';
mtxt += '<area shape="circle" coords=" 76,183,3" href="javascript:selectTSpoints(41082, 76,183)">';
mtxt += '<area shape="circle" coords=" 81,183,3" href="javascript:selectTSpoints(41083, 81,183)">';
mtxt += '<area shape="circle" coords=" 86,183,3" href="javascript:selectTSpoints(41084, 86,183)">';
mtxt += '<area shape="circle" coords=" 91,183,3" href="javascript:selectTSpoints(41085, 91,183)">';
mtxt += '<area shape="circle" coords=" 96,183,3" href="javascript:selectTSpoints(41086, 96,183)">';
mtxt += '<area shape="circle" coords="101,183,3" href="javascript:selectTSpoints(41087,101,183)">';
mtxt += '<area shape="circle" coords="106,183,3" href="javascript:selectTSpoints(41088,106,183)">';
mtxt += '<area shape="circle" coords="112,183,3" href="javascript:selectTSpoints(41089,112,183)">';
mtxt += '<area shape="circle" coords="117,183,3" href="javascript:selectTSpoints(41090,117,183)">';
mtxt += '<area shape="circle" coords="122,183,3" href="javascript:selectTSpoints(41091,122,183)">';
mtxt += '<area shape="circle" coords="127,183,3" href="javascript:selectTSpoints(41092,127,183)">';
mtxt += '<area shape="circle" coords="132,183,3" href="javascript:selectTSpoints(41093,132,183)">';
mtxt += '<area shape="circle" coords="137,183,3" href="javascript:selectTSpoints(41094,137,183)">';
mtxt += '<area shape="circle" coords="142,183,3" href="javascript:selectTSpoints(41095,142,183)">';
mtxt += '<area shape="circle" coords="147,183,3" href="javascript:selectTSpoints(41096,147,183)">';
mtxt += '<area shape="circle" coords="152,183,3" href="javascript:selectTSpoints(41097,152,183)">';
mtxt += '<area shape="circle" coords="157,183,3" href="javascript:selectTSpoints(41098,157,183)">';
mtxt += '<area shape="circle" coords="162,183,3" href="javascript:selectTSpoints(41099,162,183)">';
mtxt += '<area shape="circle" coords="168,183,3" href="javascript:selectTSpoints(41100,168,183)">';
mtxt += '<area shape="circle" coords="173,183,3" href="javascript:selectTSpoints(41101,173,183)">';
mtxt += '<area shape="circle" coords="178,183,3" href="javascript:selectTSpoints(41102,178,183)">';
mtxt += '<area shape="circle" coords="183,183,3" href="javascript:selectTSpoints(41103,183,183)">';
mtxt += '<area shape="circle" coords="188,183,3" href="javascript:selectTSpoints(41104,188,183)">';
mtxt += '<area shape="circle" coords="193,183,3" href="javascript:selectTSpoints(41105,193,183)">';
mtxt += '<area shape="circle" coords="198,183,3" href="javascript:selectTSpoints(41106,198,183)">';
mtxt += '<area shape="circle" coords="203,183,3" href="javascript:selectTSpoints(41107,203,183)">';
mtxt += '<area shape="circle" coords="208,183,3" href="javascript:selectTSpoints(41108,208,183)">';
mtxt += '<area shape="circle" coords="213,183,3" href="javascript:selectTSpoints(41109,213,183)">';
mtxt += '<area shape="circle" coords="218,183,3" href="javascript:selectTSpoints(41110,218,183)">';
mtxt += '<area shape="circle" coords="224,183,3" href="javascript:selectTSpoints(41111,224,183)">';
mtxt += '<area shape="circle" coords="229,183,3" href="javascript:selectTSpoints(41112,229,183)">';
mtxt += '<area shape="circle" coords="234,183,3" href="javascript:selectTSpoints(41113,234,183)">';
mtxt += '<area shape="circle" coords="239,183,3" href="javascript:selectTSpoints(41114,239,183)">';
mtxt += '<area shape="circle" coords="244,183,3" href="javascript:selectTSpoints(41115,244,183)">';
mtxt += '<area shape="circle" coords="249,183,3" href="javascript:selectTSpoints(41116,249,183)">';
mtxt += '<area shape="circle" coords="254,183,3" href="javascript:selectTSpoints(41117,254,183)">';
mtxt += '<area shape="circle" coords="259,183,3" href="javascript:selectTSpoints(41118,259,183)">';
mtxt += '<area shape="circle" coords="264,183,3" href="javascript:selectTSpoints(41119,264,183)">';
mtxt += '<area shape="circle" coords="269,183,3" href="javascript:selectTSpoints(41120,269,183)">';
mtxt += '<area shape="circle" coords="274,183,3" href="javascript:selectTSpoints(41121,274,183)">';
mtxt += '<area shape="circle" coords="280,183,3" href="javascript:selectTSpoints(41122,280,183)">';
mtxt += '<area shape="circle" coords="285,183,3" href="javascript:selectTSpoints(41123,285,183)">';
mtxt += '<area shape="circle" coords="290,183,3" href="javascript:selectTSpoints(41124,290,183)">';
mtxt += '<area shape="circle" coords="295,183,3" href="javascript:selectTSpoints(41125,295,183)">';
mtxt += '<area shape="circle" coords="300,183,3" href="javascript:selectTSpoints(41126,300,183)">';
mtxt += '<area shape="circle" coords="305,183,3" href="javascript:selectTSpoints(41127,305,183)">';
mtxt += '<area shape="circle" coords="310,183,3" href="javascript:selectTSpoints(41128,310,183)">';
mtxt += '<area shape="circle" coords="315,183,3" href="javascript:selectTSpoints(41129,315,183)">';
mtxt += '<area shape="circle" coords="320,183,3" href="javascript:selectTSpoints(41130,320,183)">';
mtxt += '<area shape="circle" coords="325,183,3" href="javascript:selectTSpoints(41131,325,183)">';
mtxt += '<area shape="circle" coords="330,183,3" href="javascript:selectTSpoints(41132,330,183)">';
mtxt += '<area shape="circle" coords="336,183,3" href="javascript:selectTSpoints(41133,336,183)">';
mtxt += '<area shape="circle" coords="341,183,3" href="javascript:selectTSpoints(41134,341,183)">';
mtxt += '<area shape="circle" coords="346,183,3" href="javascript:selectTSpoints(41135,346,183)">';
mtxt += '<area shape="circle" coords="351,183,3" href="javascript:selectTSpoints(41136,351,183)">';
mtxt += '<area shape="circle" coords="356,183,3" href="javascript:selectTSpoints(41137,356,183)">';
mtxt += '<area shape="circle" coords="361,183,3" href="javascript:selectTSpoints(41138,361,183)">';
mtxt += '<area shape="circle" coords="366,183,3" href="javascript:selectTSpoints(41139,366,183)">';
mtxt += '<area shape="circle" coords="371,183,3" href="javascript:selectTSpoints(41140,371,183)">';
mtxt += '<area shape="circle" coords="376,183,3" href="javascript:selectTSpoints(41141,376,183)">';
mtxt += '<area shape="circle" coords="381,183,3" href="javascript:selectTSpoints(41142,381,183)">';
mtxt += '<area shape="circle" coords="386,183,3" href="javascript:selectTSpoints(41143,386,183)">';
mtxt += '<area shape="circle" coords="392,183,3" href="javascript:selectTSpoints(41144,392,183)">';
mtxt += '<area shape="circle" coords="397,183,3" href="javascript:selectTSpoints(41001,397,183)">';
mtxt += '<area shape="circle" coords="402,183,3" href="javascript:selectTSpoints(41002,402,183)">';
mtxt += '<area shape="circle" coords="407,183,3" href="javascript:selectTSpoints(41003,407,183)">';
mtxt += '<area shape="circle" coords="412,183,3" href="javascript:selectTSpoints(41004,412,183)">';
mtxt += '<area shape="circle" coords="417,183,3" href="javascript:selectTSpoints(41005,417,183)">';
mtxt += '<area shape="circle" coords="422,183,3" href="javascript:selectTSpoints(41006,422,183)">';
mtxt += '<area shape="circle" coords="427,183,3" href="javascript:selectTSpoints(41007,427,183)">';
mtxt += '<area shape="circle" coords="432,183,3" href="javascript:selectTSpoints(41008,432,183)">';
mtxt += '<area shape="circle" coords="437,183,3" href="javascript:selectTSpoints(41009,437,183)">';
mtxt += '<area shape="circle" coords="442,183,3" href="javascript:selectTSpoints(41010,442,183)">';
mtxt += '<area shape="circle" coords="447,183,3" href="javascript:selectTSpoints(41011,447,183)">';
mtxt += '<area shape="circle" coords="453,183,3" href="javascript:selectTSpoints(41012,453,183)">';
mtxt += '<area shape="circle" coords="458,183,3" href="javascript:selectTSpoints(41013,458,183)">';
mtxt += '<area shape="circle" coords="463,183,3" href="javascript:selectTSpoints(41014,463,183)">';
mtxt += '<area shape="circle" coords="468,183,3" href="javascript:selectTSpoints(41015,468,183)">';
mtxt += '<area shape="circle" coords="473,183,3" href="javascript:selectTSpoints(41016,473,183)">';
mtxt += '<area shape="circle" coords="478,183,3" href="javascript:selectTSpoints(41017,478,183)">';
mtxt += '<area shape="circle" coords="483,183,3" href="javascript:selectTSpoints(41018,483,183)">';
mtxt += '<area shape="circle" coords="488,183,3" href="javascript:selectTSpoints(41019,488,183)">';
mtxt += '<area shape="circle" coords="493,183,3" href="javascript:selectTSpoints(41020,493,183)">';
mtxt += '<area shape="circle" coords="498,183,3" href="javascript:selectTSpoints(41021,498,183)">';
mtxt += '<area shape="circle" coords="503,183,3" href="javascript:selectTSpoints(41022,503,183)">';
mtxt += '<area shape="circle" coords="509,183,3" href="javascript:selectTSpoints(41023,509,183)">';
mtxt += '<area shape="circle" coords="514,183,3" href="javascript:selectTSpoints(41024,514,183)">';
mtxt += '<area shape="circle" coords="519,183,3" href="javascript:selectTSpoints(41025,519,183)">';
mtxt += '<area shape="circle" coords="524,183,3" href="javascript:selectTSpoints(41026,524,183)">';
mtxt += '<area shape="circle" coords="529,183,3" href="javascript:selectTSpoints(41027,529,183)">';
mtxt += '<area shape="circle" coords="534,183,3" href="javascript:selectTSpoints(41028,534,183)">';
mtxt += '<area shape="circle" coords="539,183,3" href="javascript:selectTSpoints(41029,539,183)">';
mtxt += '<area shape="circle" coords="544,183,3" href="javascript:selectTSpoints(41030,544,183)">';
mtxt += '<area shape="circle" coords="549,183,3" href="javascript:selectTSpoints(41031,549,183)">';
mtxt += '<area shape="circle" coords="554,183,3" href="javascript:selectTSpoints(41032,554,183)">';
mtxt += '<area shape="circle" coords="559,183,3" href="javascript:selectTSpoints(41033,559,183)">';
mtxt += '<area shape="circle" coords="565,183,3" href="javascript:selectTSpoints(41034,565,183)">';
mtxt += '<area shape="circle" coords="570,183,3" href="javascript:selectTSpoints(41035,570,183)">';
mtxt += '<area shape="circle" coords="575,183,3" href="javascript:selectTSpoints(41036,575,183)">';
mtxt += '<area shape="circle" coords="580,183,3" href="javascript:selectTSpoints(41037,580,183)">';
mtxt += '<area shape="circle" coords="585,183,3" href="javascript:selectTSpoints(41038,585,183)">';
mtxt += '<area shape="circle" coords="590,183,3" href="javascript:selectTSpoints(41039,590,183)">';
mtxt += '<area shape="circle" coords="595,183,3" href="javascript:selectTSpoints(41040,595,183)">';
mtxt += '<area shape="circle" coords="600,183,3" href="javascript:selectTSpoints(41041,600,183)">';
mtxt += '<area shape="circle" coords="605,183,3" href="javascript:selectTSpoints(41042,605,183)">';
mtxt += '<area shape="circle" coords="610,183,3" href="javascript:selectTSpoints(41043,610,183)">';
mtxt += '<area shape="circle" coords="615,183,3" href="javascript:selectTSpoints(41044,615,183)">';
mtxt += '<area shape="circle" coords="621,183,3" href="javascript:selectTSpoints(41045,621,183)">';
mtxt += '<area shape="circle" coords="626,183,3" href="javascript:selectTSpoints(41046,626,183)">';
mtxt += '<area shape="circle" coords="631,183,3" href="javascript:selectTSpoints(41047,631,183)">';
mtxt += '<area shape="circle" coords="636,183,3" href="javascript:selectTSpoints(41048,636,183)">';
mtxt += '<area shape="circle" coords="641,183,3" href="javascript:selectTSpoints(41049,641,183)">';
mtxt += '<area shape="circle" coords="646,183,3" href="javascript:selectTSpoints(41050,646,183)">';
mtxt += '<area shape="circle" coords="651,183,3" href="javascript:selectTSpoints(41051,651,183)">';
mtxt += '<area shape="circle" coords="656,183,3" href="javascript:selectTSpoints(41052,656,183)">';
mtxt += '<area shape="circle" coords="661,183,3" href="javascript:selectTSpoints(41053,661,183)">';
mtxt += '<area shape="circle" coords="666,183,3" href="javascript:selectTSpoints(41054,666,183)">';
mtxt += '<area shape="circle" coords="671,183,3" href="javascript:selectTSpoints(41055,671,183)">';
mtxt += '<area shape="circle" coords="677,183,3" href="javascript:selectTSpoints(41056,677,183)">';
mtxt += '<area shape="circle" coords="682,183,3" href="javascript:selectTSpoints(41057,682,183)">';
mtxt += '<area shape="circle" coords="687,183,3" href="javascript:selectTSpoints(41058,687,183)">';
mtxt += '<area shape="circle" coords="692,183,3" href="javascript:selectTSpoints(41059,692,183)">';
mtxt += '<area shape="circle" coords="697,183,3" href="javascript:selectTSpoints(41060,697,183)">';
mtxt += '<area shape="circle" coords="702,183,3" href="javascript:selectTSpoints(41061,702,183)">';
mtxt += '<area shape="circle" coords="707,183,3" href="javascript:selectTSpoints(41062,707,183)">';
mtxt += '<area shape="circle" coords="712,183,3" href="javascript:selectTSpoints(41063,712,183)">';
mtxt += '<area shape="circle" coords="717,183,3" href="javascript:selectTSpoints(41064,717,183)">';
mtxt += '<area shape="circle" coords="722,183,3" href="javascript:selectTSpoints(41065,722,183)">';
mtxt += '<area shape="circle" coords="727,183,3" href="javascript:selectTSpoints(41066,727,183)">';
mtxt += '<area shape="circle" coords="733,183,3" href="javascript:selectTSpoints(41067,733,183)">';
mtxt += '<area shape="circle" coords="738,183,3" href="javascript:selectTSpoints(41068,738,183)">';
mtxt += '<area shape="circle" coords="743,183,3" href="javascript:selectTSpoints(41069,743,183)">';
mtxt += '<area shape="circle" coords="748,183,3" href="javascript:selectTSpoints(41070,748,183)">';
mtxt += '<area shape="circle" coords="753,183,3" href="javascript:selectTSpoints(41071,753,183)">';
mtxt += '<area shape="circle" coords="758,183,3" href="javascript:selectTSpoints(41072,758,183)">';
mtxt += '<area shape="circle" coords=" 30,178,3" href="javascript:selectTSpoints(42073, 30,178)">';
mtxt += '<area shape="circle" coords=" 35,178,3" href="javascript:selectTSpoints(42074, 35,178)">';
mtxt += '<area shape="circle" coords=" 40,178,3" href="javascript:selectTSpoints(42075, 40,178)">';
mtxt += '<area shape="circle" coords=" 45,178,3" href="javascript:selectTSpoints(42076, 45,178)">';
mtxt += '<area shape="circle" coords=" 50,178,3" href="javascript:selectTSpoints(42077, 50,178)">';
mtxt += '<area shape="circle" coords=" 56,178,3" href="javascript:selectTSpoints(42078, 56,178)">';
mtxt += '<area shape="circle" coords=" 61,178,3" href="javascript:selectTSpoints(42079, 61,178)">';
mtxt += '<area shape="circle" coords=" 66,178,3" href="javascript:selectTSpoints(42080, 66,178)">';
mtxt += '<area shape="circle" coords=" 71,178,3" href="javascript:selectTSpoints(42081, 71,178)">';
mtxt += '<area shape="circle" coords=" 76,178,3" href="javascript:selectTSpoints(42082, 76,178)">';
mtxt += '<area shape="circle" coords=" 81,178,3" href="javascript:selectTSpoints(42083, 81,178)">';
mtxt += '<area shape="circle" coords=" 86,178,3" href="javascript:selectTSpoints(42084, 86,178)">';
mtxt += '<area shape="circle" coords=" 91,178,3" href="javascript:selectTSpoints(42085, 91,178)">';
mtxt += '<area shape="circle" coords=" 96,178,3" href="javascript:selectTSpoints(42086, 96,178)">';
mtxt += '<area shape="circle" coords="101,178,3" href="javascript:selectTSpoints(42087,101,178)">';
mtxt += '<area shape="circle" coords="106,178,3" href="javascript:selectTSpoints(42088,106,178)">';
mtxt += '<area shape="circle" coords="112,178,3" href="javascript:selectTSpoints(42089,112,178)">';
mtxt += '<area shape="circle" coords="117,178,3" href="javascript:selectTSpoints(42090,117,178)">';
mtxt += '<area shape="circle" coords="122,178,3" href="javascript:selectTSpoints(42091,122,178)">';
mtxt += '<area shape="circle" coords="127,178,3" href="javascript:selectTSpoints(42092,127,178)">';
mtxt += '<area shape="circle" coords="132,178,3" href="javascript:selectTSpoints(42093,132,178)">';
mtxt += '<area shape="circle" coords="137,178,3" href="javascript:selectTSpoints(42094,137,178)">';
mtxt += '<area shape="circle" coords="142,178,3" href="javascript:selectTSpoints(42095,142,178)">';
mtxt += '<area shape="circle" coords="147,178,3" href="javascript:selectTSpoints(42096,147,178)">';
mtxt += '<area shape="circle" coords="152,178,3" href="javascript:selectTSpoints(42097,152,178)">';
mtxt += '<area shape="circle" coords="157,178,3" href="javascript:selectTSpoints(42098,157,178)">';
mtxt += '<area shape="circle" coords="162,178,3" href="javascript:selectTSpoints(42099,162,178)">';
mtxt += '<area shape="circle" coords="168,178,3" href="javascript:selectTSpoints(42100,168,178)">';
mtxt += '<area shape="circle" coords="173,178,3" href="javascript:selectTSpoints(42101,173,178)">';
mtxt += '<area shape="circle" coords="178,178,3" href="javascript:selectTSpoints(42102,178,178)">';
mtxt += '<area shape="circle" coords="183,178,3" href="javascript:selectTSpoints(42103,183,178)">';
mtxt += '<area shape="circle" coords="188,178,3" href="javascript:selectTSpoints(42104,188,178)">';
mtxt += '<area shape="circle" coords="193,178,3" href="javascript:selectTSpoints(42105,193,178)">';
mtxt += '<area shape="circle" coords="198,178,3" href="javascript:selectTSpoints(42106,198,178)">';
mtxt += '<area shape="circle" coords="203,178,3" href="javascript:selectTSpoints(42107,203,178)">';
mtxt += '<area shape="circle" coords="208,178,3" href="javascript:selectTSpoints(42108,208,178)">';
mtxt += '<area shape="circle" coords="213,178,3" href="javascript:selectTSpoints(42109,213,178)">';
mtxt += '<area shape="circle" coords="218,178,3" href="javascript:selectTSpoints(42110,218,178)">';
mtxt += '<area shape="circle" coords="224,178,3" href="javascript:selectTSpoints(42111,224,178)">';
mtxt += '<area shape="circle" coords="229,178,3" href="javascript:selectTSpoints(42112,229,178)">';
mtxt += '<area shape="circle" coords="234,178,3" href="javascript:selectTSpoints(42113,234,178)">';
mtxt += '<area shape="circle" coords="239,178,3" href="javascript:selectTSpoints(42114,239,178)">';
mtxt += '<area shape="circle" coords="244,178,3" href="javascript:selectTSpoints(42115,244,178)">';
mtxt += '<area shape="circle" coords="249,178,3" href="javascript:selectTSpoints(42116,249,178)">';
mtxt += '<area shape="circle" coords="254,178,3" href="javascript:selectTSpoints(42117,254,178)">';
mtxt += '<area shape="circle" coords="259,178,3" href="javascript:selectTSpoints(42118,259,178)">';
mtxt += '<area shape="circle" coords="264,178,3" href="javascript:selectTSpoints(42119,264,178)">';
mtxt += '<area shape="circle" coords="269,178,3" href="javascript:selectTSpoints(42120,269,178)">';
mtxt += '<area shape="circle" coords="274,178,3" href="javascript:selectTSpoints(42121,274,178)">';
mtxt += '<area shape="circle" coords="280,178,3" href="javascript:selectTSpoints(42122,280,178)">';
mtxt += '<area shape="circle" coords="285,178,3" href="javascript:selectTSpoints(42123,285,178)">';
mtxt += '<area shape="circle" coords="290,178,3" href="javascript:selectTSpoints(42124,290,178)">';
mtxt += '<area shape="circle" coords="295,178,3" href="javascript:selectTSpoints(42125,295,178)">';
mtxt += '<area shape="circle" coords="300,178,3" href="javascript:selectTSpoints(42126,300,178)">';
mtxt += '<area shape="circle" coords="305,178,3" href="javascript:selectTSpoints(42127,305,178)">';
mtxt += '<area shape="circle" coords="310,178,3" href="javascript:selectTSpoints(42128,310,178)">';
mtxt += '<area shape="circle" coords="315,178,3" href="javascript:selectTSpoints(42129,315,178)">';
mtxt += '<area shape="circle" coords="320,178,3" href="javascript:selectTSpoints(42130,320,178)">';
mtxt += '<area shape="circle" coords="325,178,3" href="javascript:selectTSpoints(42131,325,178)">';
mtxt += '<area shape="circle" coords="330,178,3" href="javascript:selectTSpoints(42132,330,178)">';
mtxt += '<area shape="circle" coords="336,178,3" href="javascript:selectTSpoints(42133,336,178)">';
mtxt += '<area shape="circle" coords="341,178,3" href="javascript:selectTSpoints(42134,341,178)">';
mtxt += '<area shape="circle" coords="346,178,3" href="javascript:selectTSpoints(42135,346,178)">';
mtxt += '<area shape="circle" coords="351,178,3" href="javascript:selectTSpoints(42136,351,178)">';
mtxt += '<area shape="circle" coords="356,178,3" href="javascript:selectTSpoints(42137,356,178)">';
mtxt += '<area shape="circle" coords="361,178,3" href="javascript:selectTSpoints(42138,361,178)">';
mtxt += '<area shape="circle" coords="366,178,3" href="javascript:selectTSpoints(42139,366,178)">';
mtxt += '<area shape="circle" coords="371,178,3" href="javascript:selectTSpoints(42140,371,178)">';
mtxt += '<area shape="circle" coords="376,178,3" href="javascript:selectTSpoints(42141,376,178)">';
mtxt += '<area shape="circle" coords="381,178,3" href="javascript:selectTSpoints(42142,381,178)">';
mtxt += '<area shape="circle" coords="386,178,3" href="javascript:selectTSpoints(42143,386,178)">';
mtxt += '<area shape="circle" coords="392,178,3" href="javascript:selectTSpoints(42144,392,178)">';
mtxt += '<area shape="circle" coords="397,178,3" href="javascript:selectTSpoints(42001,397,178)">';
mtxt += '<area shape="circle" coords="402,178,3" href="javascript:selectTSpoints(42002,402,178)">';
mtxt += '<area shape="circle" coords="407,178,3" href="javascript:selectTSpoints(42003,407,178)">';
mtxt += '<area shape="circle" coords="412,178,3" href="javascript:selectTSpoints(42004,412,178)">';
mtxt += '<area shape="circle" coords="417,178,3" href="javascript:selectTSpoints(42005,417,178)">';
mtxt += '<area shape="circle" coords="422,178,3" href="javascript:selectTSpoints(42006,422,178)">';
mtxt += '<area shape="circle" coords="427,178,3" href="javascript:selectTSpoints(42007,427,178)">';
mtxt += '<area shape="circle" coords="432,178,3" href="javascript:selectTSpoints(42008,432,178)">';
mtxt += '<area shape="circle" coords="437,178,3" href="javascript:selectTSpoints(42009,437,178)">';
mtxt += '<area shape="circle" coords="442,178,3" href="javascript:selectTSpoints(42010,442,178)">';
mtxt += '<area shape="circle" coords="447,178,3" href="javascript:selectTSpoints(42011,447,178)">';
mtxt += '<area shape="circle" coords="453,178,3" href="javascript:selectTSpoints(42012,453,178)">';
mtxt += '<area shape="circle" coords="458,178,3" href="javascript:selectTSpoints(42013,458,178)">';
mtxt += '<area shape="circle" coords="463,178,3" href="javascript:selectTSpoints(42014,463,178)">';
mtxt += '<area shape="circle" coords="468,178,3" href="javascript:selectTSpoints(42015,468,178)">';
mtxt += '<area shape="circle" coords="473,178,3" href="javascript:selectTSpoints(42016,473,178)">';
mtxt += '<area shape="circle" coords="478,178,3" href="javascript:selectTSpoints(42017,478,178)">';
mtxt += '<area shape="circle" coords="483,178,3" href="javascript:selectTSpoints(42018,483,178)">';
mtxt += '<area shape="circle" coords="488,178,3" href="javascript:selectTSpoints(42019,488,178)">';
mtxt += '<area shape="circle" coords="493,178,3" href="javascript:selectTSpoints(42020,493,178)">';
mtxt += '<area shape="circle" coords="498,178,3" href="javascript:selectTSpoints(42021,498,178)">';
mtxt += '<area shape="circle" coords="503,178,3" href="javascript:selectTSpoints(42022,503,178)">';
mtxt += '<area shape="circle" coords="509,178,3" href="javascript:selectTSpoints(42023,509,178)">';
mtxt += '<area shape="circle" coords="514,178,3" href="javascript:selectTSpoints(42024,514,178)">';
mtxt += '<area shape="circle" coords="519,178,3" href="javascript:selectTSpoints(42025,519,178)">';
mtxt += '<area shape="circle" coords="524,178,3" href="javascript:selectTSpoints(42026,524,178)">';
mtxt += '<area shape="circle" coords="529,178,3" href="javascript:selectTSpoints(42027,529,178)">';
mtxt += '<area shape="circle" coords="534,178,3" href="javascript:selectTSpoints(42028,534,178)">';
mtxt += '<area shape="circle" coords="539,178,3" href="javascript:selectTSpoints(42029,539,178)">';
mtxt += '<area shape="circle" coords="544,178,3" href="javascript:selectTSpoints(42030,544,178)">';
mtxt += '<area shape="circle" coords="549,178,3" href="javascript:selectTSpoints(42031,549,178)">';
mtxt += '<area shape="circle" coords="554,178,3" href="javascript:selectTSpoints(42032,554,178)">';
mtxt += '<area shape="circle" coords="559,178,3" href="javascript:selectTSpoints(42033,559,178)">';
mtxt += '<area shape="circle" coords="565,178,3" href="javascript:selectTSpoints(42034,565,178)">';
mtxt += '<area shape="circle" coords="570,178,3" href="javascript:selectTSpoints(42035,570,178)">';
mtxt += '<area shape="circle" coords="575,178,3" href="javascript:selectTSpoints(42036,575,178)">';
mtxt += '<area shape="circle" coords="580,178,3" href="javascript:selectTSpoints(42037,580,178)">';
mtxt += '<area shape="circle" coords="585,178,3" href="javascript:selectTSpoints(42038,585,178)">';
mtxt += '<area shape="circle" coords="590,178,3" href="javascript:selectTSpoints(42039,590,178)">';
mtxt += '<area shape="circle" coords="595,178,3" href="javascript:selectTSpoints(42040,595,178)">';
mtxt += '<area shape="circle" coords="600,178,3" href="javascript:selectTSpoints(42041,600,178)">';
mtxt += '<area shape="circle" coords="605,178,3" href="javascript:selectTSpoints(42042,605,178)">';
mtxt += '<area shape="circle" coords="610,178,3" href="javascript:selectTSpoints(42043,610,178)">';
mtxt += '<area shape="circle" coords="615,178,3" href="javascript:selectTSpoints(42044,615,178)">';
mtxt += '<area shape="circle" coords="621,178,3" href="javascript:selectTSpoints(42045,621,178)">';
mtxt += '<area shape="circle" coords="626,178,3" href="javascript:selectTSpoints(42046,626,178)">';
mtxt += '<area shape="circle" coords="631,178,3" href="javascript:selectTSpoints(42047,631,178)">';
mtxt += '<area shape="circle" coords="636,178,3" href="javascript:selectTSpoints(42048,636,178)">';
mtxt += '<area shape="circle" coords="641,178,3" href="javascript:selectTSpoints(42049,641,178)">';
mtxt += '<area shape="circle" coords="646,178,3" href="javascript:selectTSpoints(42050,646,178)">';
mtxt += '<area shape="circle" coords="651,178,3" href="javascript:selectTSpoints(42051,651,178)">';
mtxt += '<area shape="circle" coords="656,178,3" href="javascript:selectTSpoints(42052,656,178)">';
mtxt += '<area shape="circle" coords="661,178,3" href="javascript:selectTSpoints(42053,661,178)">';
mtxt += '<area shape="circle" coords="666,178,3" href="javascript:selectTSpoints(42054,666,178)">';
mtxt += '<area shape="circle" coords="671,178,3" href="javascript:selectTSpoints(42055,671,178)">';
mtxt += '<area shape="circle" coords="677,178,3" href="javascript:selectTSpoints(42056,677,178)">';
mtxt += '<area shape="circle" coords="682,178,3" href="javascript:selectTSpoints(42057,682,178)">';
mtxt += '<area shape="circle" coords="687,178,3" href="javascript:selectTSpoints(42058,687,178)">';
mtxt += '<area shape="circle" coords="692,178,3" href="javascript:selectTSpoints(42059,692,178)">';
mtxt += '<area shape="circle" coords="697,178,3" href="javascript:selectTSpoints(42060,697,178)">';
mtxt += '<area shape="circle" coords="702,178,3" href="javascript:selectTSpoints(42061,702,178)">';
mtxt += '<area shape="circle" coords="707,178,3" href="javascript:selectTSpoints(42062,707,178)">';
mtxt += '<area shape="circle" coords="712,178,3" href="javascript:selectTSpoints(42063,712,178)">';
mtxt += '<area shape="circle" coords="717,178,3" href="javascript:selectTSpoints(42064,717,178)">';
mtxt += '<area shape="circle" coords="722,178,3" href="javascript:selectTSpoints(42065,722,178)">';
mtxt += '<area shape="circle" coords="727,178,3" href="javascript:selectTSpoints(42066,727,178)">';
mtxt += '<area shape="circle" coords="733,178,3" href="javascript:selectTSpoints(42067,733,178)">';
mtxt += '<area shape="circle" coords="738,178,3" href="javascript:selectTSpoints(42068,738,178)">';
mtxt += '<area shape="circle" coords="743,178,3" href="javascript:selectTSpoints(42069,743,178)">';
mtxt += '<area shape="circle" coords="748,178,3" href="javascript:selectTSpoints(42070,748,178)">';
mtxt += '<area shape="circle" coords="753,178,3" href="javascript:selectTSpoints(42071,753,178)">';
mtxt += '<area shape="circle" coords="758,178,3" href="javascript:selectTSpoints(42072,758,178)">';
mtxt += '<area shape="circle" coords=" 30,173,3" href="javascript:selectTSpoints(43073, 30,173)">';
mtxt += '<area shape="circle" coords=" 35,173,3" href="javascript:selectTSpoints(43074, 35,173)">';
mtxt += '<area shape="circle" coords=" 40,173,3" href="javascript:selectTSpoints(43075, 40,173)">';
mtxt += '<area shape="circle" coords=" 45,173,3" href="javascript:selectTSpoints(43076, 45,173)">';
mtxt += '<area shape="circle" coords=" 50,173,3" href="javascript:selectTSpoints(43077, 50,173)">';
mtxt += '<area shape="circle" coords=" 56,173,3" href="javascript:selectTSpoints(43078, 56,173)">';
mtxt += '<area shape="circle" coords=" 61,173,3" href="javascript:selectTSpoints(43079, 61,173)">';
mtxt += '<area shape="circle" coords=" 66,173,3" href="javascript:selectTSpoints(43080, 66,173)">';
mtxt += '<area shape="circle" coords=" 71,173,3" href="javascript:selectTSpoints(43081, 71,173)">';
mtxt += '<area shape="circle" coords=" 76,173,3" href="javascript:selectTSpoints(43082, 76,173)">';
mtxt += '<area shape="circle" coords=" 81,173,3" href="javascript:selectTSpoints(43083, 81,173)">';
mtxt += '<area shape="circle" coords=" 86,173,3" href="javascript:selectTSpoints(43084, 86,173)">';
mtxt += '<area shape="circle" coords=" 91,173,3" href="javascript:selectTSpoints(43085, 91,173)">';
mtxt += '<area shape="circle" coords=" 96,173,3" href="javascript:selectTSpoints(43086, 96,173)">';
mtxt += '<area shape="circle" coords="101,173,3" href="javascript:selectTSpoints(43087,101,173)">';
mtxt += '<area shape="circle" coords="106,173,3" href="javascript:selectTSpoints(43088,106,173)">';
mtxt += '<area shape="circle" coords="112,173,3" href="javascript:selectTSpoints(43089,112,173)">';
mtxt += '<area shape="circle" coords="117,173,3" href="javascript:selectTSpoints(43090,117,173)">';
mtxt += '<area shape="circle" coords="122,173,3" href="javascript:selectTSpoints(43091,122,173)">';
mtxt += '<area shape="circle" coords="127,173,3" href="javascript:selectTSpoints(43092,127,173)">';
mtxt += '<area shape="circle" coords="132,173,3" href="javascript:selectTSpoints(43093,132,173)">';
mtxt += '<area shape="circle" coords="137,173,3" href="javascript:selectTSpoints(43094,137,173)">';
mtxt += '<area shape="circle" coords="142,173,3" href="javascript:selectTSpoints(43095,142,173)">';
mtxt += '<area shape="circle" coords="147,173,3" href="javascript:selectTSpoints(43096,147,173)">';
mtxt += '<area shape="circle" coords="152,173,3" href="javascript:selectTSpoints(43097,152,173)">';
mtxt += '<area shape="circle" coords="157,173,3" href="javascript:selectTSpoints(43098,157,173)">';
mtxt += '<area shape="circle" coords="162,173,3" href="javascript:selectTSpoints(43099,162,173)">';
mtxt += '<area shape="circle" coords="168,173,3" href="javascript:selectTSpoints(43100,168,173)">';
mtxt += '<area shape="circle" coords="173,173,3" href="javascript:selectTSpoints(43101,173,173)">';
mtxt += '<area shape="circle" coords="178,173,3" href="javascript:selectTSpoints(43102,178,173)">';
mtxt += '<area shape="circle" coords="183,173,3" href="javascript:selectTSpoints(43103,183,173)">';
mtxt += '<area shape="circle" coords="188,173,3" href="javascript:selectTSpoints(43104,188,173)">';
mtxt += '<area shape="circle" coords="193,173,3" href="javascript:selectTSpoints(43105,193,173)">';
mtxt += '<area shape="circle" coords="198,173,3" href="javascript:selectTSpoints(43106,198,173)">';
mtxt += '<area shape="circle" coords="203,173,3" href="javascript:selectTSpoints(43107,203,173)">';
mtxt += '<area shape="circle" coords="208,173,3" href="javascript:selectTSpoints(43108,208,173)">';
mtxt += '<area shape="circle" coords="213,173,3" href="javascript:selectTSpoints(43109,213,173)">';
mtxt += '<area shape="circle" coords="218,173,3" href="javascript:selectTSpoints(43110,218,173)">';
mtxt += '<area shape="circle" coords="224,173,3" href="javascript:selectTSpoints(43111,224,173)">';
mtxt += '<area shape="circle" coords="229,173,3" href="javascript:selectTSpoints(43112,229,173)">';
mtxt += '<area shape="circle" coords="234,173,3" href="javascript:selectTSpoints(43113,234,173)">';
mtxt += '<area shape="circle" coords="239,173,3" href="javascript:selectTSpoints(43114,239,173)">';
mtxt += '<area shape="circle" coords="244,173,3" href="javascript:selectTSpoints(43115,244,173)">';
mtxt += '<area shape="circle" coords="249,173,3" href="javascript:selectTSpoints(43116,249,173)">';
mtxt += '<area shape="circle" coords="254,173,3" href="javascript:selectTSpoints(43117,254,173)">';
mtxt += '<area shape="circle" coords="259,173,3" href="javascript:selectTSpoints(43118,259,173)">';
mtxt += '<area shape="circle" coords="264,173,3" href="javascript:selectTSpoints(43119,264,173)">';
mtxt += '<area shape="circle" coords="269,173,3" href="javascript:selectTSpoints(43120,269,173)">';
mtxt += '<area shape="circle" coords="274,173,3" href="javascript:selectTSpoints(43121,274,173)">';
mtxt += '<area shape="circle" coords="280,173,3" href="javascript:selectTSpoints(43122,280,173)">';
mtxt += '<area shape="circle" coords="285,173,3" href="javascript:selectTSpoints(43123,285,173)">';
mtxt += '<area shape="circle" coords="290,173,3" href="javascript:selectTSpoints(43124,290,173)">';
mtxt += '<area shape="circle" coords="295,173,3" href="javascript:selectTSpoints(43125,295,173)">';
mtxt += '<area shape="circle" coords="300,173,3" href="javascript:selectTSpoints(43126,300,173)">';
mtxt += '<area shape="circle" coords="305,173,3" href="javascript:selectTSpoints(43127,305,173)">';
mtxt += '<area shape="circle" coords="310,173,3" href="javascript:selectTSpoints(43128,310,173)">';
mtxt += '<area shape="circle" coords="315,173,3" href="javascript:selectTSpoints(43129,315,173)">';
mtxt += '<area shape="circle" coords="320,173,3" href="javascript:selectTSpoints(43130,320,173)">';
mtxt += '<area shape="circle" coords="325,173,3" href="javascript:selectTSpoints(43131,325,173)">';
mtxt += '<area shape="circle" coords="330,173,3" href="javascript:selectTSpoints(43132,330,173)">';
mtxt += '<area shape="circle" coords="336,173,3" href="javascript:selectTSpoints(43133,336,173)">';
mtxt += '<area shape="circle" coords="341,173,3" href="javascript:selectTSpoints(43134,341,173)">';
mtxt += '<area shape="circle" coords="346,173,3" href="javascript:selectTSpoints(43135,346,173)">';
mtxt += '<area shape="circle" coords="351,173,3" href="javascript:selectTSpoints(43136,351,173)">';
mtxt += '<area shape="circle" coords="356,173,3" href="javascript:selectTSpoints(43137,356,173)">';
mtxt += '<area shape="circle" coords="361,173,3" href="javascript:selectTSpoints(43138,361,173)">';
mtxt += '<area shape="circle" coords="366,173,3" href="javascript:selectTSpoints(43139,366,173)">';
mtxt += '<area shape="circle" coords="371,173,3" href="javascript:selectTSpoints(43140,371,173)">';
mtxt += '<area shape="circle" coords="376,173,3" href="javascript:selectTSpoints(43141,376,173)">';
mtxt += '<area shape="circle" coords="381,173,3" href="javascript:selectTSpoints(43142,381,173)">';
mtxt += '<area shape="circle" coords="386,173,3" href="javascript:selectTSpoints(43143,386,173)">';
mtxt += '<area shape="circle" coords="392,173,3" href="javascript:selectTSpoints(43144,392,173)">';
mtxt += '<area shape="circle" coords="397,173,3" href="javascript:selectTSpoints(43001,397,173)">';
mtxt += '<area shape="circle" coords="402,173,3" href="javascript:selectTSpoints(43002,402,173)">';
mtxt += '<area shape="circle" coords="407,173,3" href="javascript:selectTSpoints(43003,407,173)">';
mtxt += '<area shape="circle" coords="412,173,3" href="javascript:selectTSpoints(43004,412,173)">';
mtxt += '<area shape="circle" coords="417,173,3" href="javascript:selectTSpoints(43005,417,173)">';
mtxt += '<area shape="circle" coords="422,173,3" href="javascript:selectTSpoints(43006,422,173)">';
mtxt += '<area shape="circle" coords="427,173,3" href="javascript:selectTSpoints(43007,427,173)">';
mtxt += '<area shape="circle" coords="432,173,3" href="javascript:selectTSpoints(43008,432,173)">';
mtxt += '<area shape="circle" coords="437,173,3" href="javascript:selectTSpoints(43009,437,173)">';
mtxt += '<area shape="circle" coords="442,173,3" href="javascript:selectTSpoints(43010,442,173)">';
mtxt += '<area shape="circle" coords="447,173,3" href="javascript:selectTSpoints(43011,447,173)">';
mtxt += '<area shape="circle" coords="453,173,3" href="javascript:selectTSpoints(43012,453,173)">';
mtxt += '<area shape="circle" coords="458,173,3" href="javascript:selectTSpoints(43013,458,173)">';
mtxt += '<area shape="circle" coords="463,173,3" href="javascript:selectTSpoints(43014,463,173)">';
mtxt += '<area shape="circle" coords="468,173,3" href="javascript:selectTSpoints(43015,468,173)">';
mtxt += '<area shape="circle" coords="473,173,3" href="javascript:selectTSpoints(43016,473,173)">';
mtxt += '<area shape="circle" coords="478,173,3" href="javascript:selectTSpoints(43017,478,173)">';
mtxt += '<area shape="circle" coords="483,173,3" href="javascript:selectTSpoints(43018,483,173)">';
mtxt += '<area shape="circle" coords="488,173,3" href="javascript:selectTSpoints(43019,488,173)">';
mtxt += '<area shape="circle" coords="493,173,3" href="javascript:selectTSpoints(43020,493,173)">';
mtxt += '<area shape="circle" coords="498,173,3" href="javascript:selectTSpoints(43021,498,173)">';
mtxt += '<area shape="circle" coords="503,173,3" href="javascript:selectTSpoints(43022,503,173)">';
mtxt += '<area shape="circle" coords="509,173,3" href="javascript:selectTSpoints(43023,509,173)">';
mtxt += '<area shape="circle" coords="514,173,3" href="javascript:selectTSpoints(43024,514,173)">';
mtxt += '<area shape="circle" coords="519,173,3" href="javascript:selectTSpoints(43025,519,173)">';
mtxt += '<area shape="circle" coords="524,173,3" href="javascript:selectTSpoints(43026,524,173)">';
mtxt += '<area shape="circle" coords="529,173,3" href="javascript:selectTSpoints(43027,529,173)">';
mtxt += '<area shape="circle" coords="534,173,3" href="javascript:selectTSpoints(43028,534,173)">';
mtxt += '<area shape="circle" coords="539,173,3" href="javascript:selectTSpoints(43029,539,173)">';
mtxt += '<area shape="circle" coords="544,173,3" href="javascript:selectTSpoints(43030,544,173)">';
mtxt += '<area shape="circle" coords="549,173,3" href="javascript:selectTSpoints(43031,549,173)">';
mtxt += '<area shape="circle" coords="554,173,3" href="javascript:selectTSpoints(43032,554,173)">';
mtxt += '<area shape="circle" coords="559,173,3" href="javascript:selectTSpoints(43033,559,173)">';
mtxt += '<area shape="circle" coords="565,173,3" href="javascript:selectTSpoints(43034,565,173)">';
mtxt += '<area shape="circle" coords="570,173,3" href="javascript:selectTSpoints(43035,570,173)">';
mtxt += '<area shape="circle" coords="575,173,3" href="javascript:selectTSpoints(43036,575,173)">';
mtxt += '<area shape="circle" coords="580,173,3" href="javascript:selectTSpoints(43037,580,173)">';
mtxt += '<area shape="circle" coords="585,173,3" href="javascript:selectTSpoints(43038,585,173)">';
mtxt += '<area shape="circle" coords="590,173,3" href="javascript:selectTSpoints(43039,590,173)">';
mtxt += '<area shape="circle" coords="595,173,3" href="javascript:selectTSpoints(43040,595,173)">';
mtxt += '<area shape="circle" coords="600,173,3" href="javascript:selectTSpoints(43041,600,173)">';
mtxt += '<area shape="circle" coords="605,173,3" href="javascript:selectTSpoints(43042,605,173)">';
mtxt += '<area shape="circle" coords="610,173,3" href="javascript:selectTSpoints(43043,610,173)">';
mtxt += '<area shape="circle" coords="615,173,3" href="javascript:selectTSpoints(43044,615,173)">';
mtxt += '<area shape="circle" coords="621,173,3" href="javascript:selectTSpoints(43045,621,173)">';
mtxt += '<area shape="circle" coords="626,173,3" href="javascript:selectTSpoints(43046,626,173)">';
mtxt += '<area shape="circle" coords="631,173,3" href="javascript:selectTSpoints(43047,631,173)">';
mtxt += '<area shape="circle" coords="636,173,3" href="javascript:selectTSpoints(43048,636,173)">';
mtxt += '<area shape="circle" coords="641,173,3" href="javascript:selectTSpoints(43049,641,173)">';
mtxt += '<area shape="circle" coords="646,173,3" href="javascript:selectTSpoints(43050,646,173)">';
mtxt += '<area shape="circle" coords="651,173,3" href="javascript:selectTSpoints(43051,651,173)">';
mtxt += '<area shape="circle" coords="656,173,3" href="javascript:selectTSpoints(43052,656,173)">';
mtxt += '<area shape="circle" coords="661,173,3" href="javascript:selectTSpoints(43053,661,173)">';
mtxt += '<area shape="circle" coords="666,173,3" href="javascript:selectTSpoints(43054,666,173)">';
mtxt += '<area shape="circle" coords="671,173,3" href="javascript:selectTSpoints(43055,671,173)">';
mtxt += '<area shape="circle" coords="677,173,3" href="javascript:selectTSpoints(43056,677,173)">';
mtxt += '<area shape="circle" coords="682,173,3" href="javascript:selectTSpoints(43057,682,173)">';
mtxt += '<area shape="circle" coords="687,173,3" href="javascript:selectTSpoints(43058,687,173)">';
mtxt += '<area shape="circle" coords="692,173,3" href="javascript:selectTSpoints(43059,692,173)">';
mtxt += '<area shape="circle" coords="697,173,3" href="javascript:selectTSpoints(43060,697,173)">';
mtxt += '<area shape="circle" coords="702,173,3" href="javascript:selectTSpoints(43061,702,173)">';
mtxt += '<area shape="circle" coords="707,173,3" href="javascript:selectTSpoints(43062,707,173)">';
mtxt += '<area shape="circle" coords="712,173,3" href="javascript:selectTSpoints(43063,712,173)">';
mtxt += '<area shape="circle" coords="717,173,3" href="javascript:selectTSpoints(43064,717,173)">';
mtxt += '<area shape="circle" coords="722,173,3" href="javascript:selectTSpoints(43065,722,173)">';
mtxt += '<area shape="circle" coords="727,173,3" href="javascript:selectTSpoints(43066,727,173)">';
mtxt += '<area shape="circle" coords="733,173,3" href="javascript:selectTSpoints(43067,733,173)">';
mtxt += '<area shape="circle" coords="738,173,3" href="javascript:selectTSpoints(43068,738,173)">';
mtxt += '<area shape="circle" coords="743,173,3" href="javascript:selectTSpoints(43069,743,173)">';
mtxt += '<area shape="circle" coords="748,173,3" href="javascript:selectTSpoints(43070,748,173)">';
mtxt += '<area shape="circle" coords="753,173,3" href="javascript:selectTSpoints(43071,753,173)">';
mtxt += '<area shape="circle" coords="758,173,3" href="javascript:selectTSpoints(43072,758,173)">';
mtxt += '<area shape="circle" coords=" 30,168,3" href="javascript:selectTSpoints(44073, 30,168)">';
mtxt += '<area shape="circle" coords=" 35,168,3" href="javascript:selectTSpoints(44074, 35,168)">';
mtxt += '<area shape="circle" coords=" 40,168,3" href="javascript:selectTSpoints(44075, 40,168)">';
mtxt += '<area shape="circle" coords=" 45,168,3" href="javascript:selectTSpoints(44076, 45,168)">';
mtxt += '<area shape="circle" coords=" 50,168,3" href="javascript:selectTSpoints(44077, 50,168)">';
mtxt += '<area shape="circle" coords=" 56,168,3" href="javascript:selectTSpoints(44078, 56,168)">';
mtxt += '<area shape="circle" coords=" 61,168,3" href="javascript:selectTSpoints(44079, 61,168)">';
mtxt += '<area shape="circle" coords=" 66,168,3" href="javascript:selectTSpoints(44080, 66,168)">';
mtxt += '<area shape="circle" coords=" 71,168,3" href="javascript:selectTSpoints(44081, 71,168)">';
mtxt += '<area shape="circle" coords=" 76,168,3" href="javascript:selectTSpoints(44082, 76,168)">';
mtxt += '<area shape="circle" coords=" 81,168,3" href="javascript:selectTSpoints(44083, 81,168)">';
mtxt += '<area shape="circle" coords=" 86,168,3" href="javascript:selectTSpoints(44084, 86,168)">';
mtxt += '<area shape="circle" coords=" 91,168,3" href="javascript:selectTSpoints(44085, 91,168)">';
mtxt += '<area shape="circle" coords=" 96,168,3" href="javascript:selectTSpoints(44086, 96,168)">';
mtxt += '<area shape="circle" coords="101,168,3" href="javascript:selectTSpoints(44087,101,168)">';
mtxt += '<area shape="circle" coords="106,168,3" href="javascript:selectTSpoints(44088,106,168)">';
mtxt += '<area shape="circle" coords="112,168,3" href="javascript:selectTSpoints(44089,112,168)">';
mtxt += '<area shape="circle" coords="117,168,3" href="javascript:selectTSpoints(44090,117,168)">';
mtxt += '<area shape="circle" coords="122,168,3" href="javascript:selectTSpoints(44091,122,168)">';
mtxt += '<area shape="circle" coords="127,168,3" href="javascript:selectTSpoints(44092,127,168)">';
mtxt += '<area shape="circle" coords="132,168,3" href="javascript:selectTSpoints(44093,132,168)">';
mtxt += '<area shape="circle" coords="137,168,3" href="javascript:selectTSpoints(44094,137,168)">';
mtxt += '<area shape="circle" coords="142,168,3" href="javascript:selectTSpoints(44095,142,168)">';
mtxt += '<area shape="circle" coords="147,168,3" href="javascript:selectTSpoints(44096,147,168)">';
mtxt += '<area shape="circle" coords="152,168,3" href="javascript:selectTSpoints(44097,152,168)">';
mtxt += '<area shape="circle" coords="157,168,3" href="javascript:selectTSpoints(44098,157,168)">';
mtxt += '<area shape="circle" coords="162,168,3" href="javascript:selectTSpoints(44099,162,168)">';
mtxt += '<area shape="circle" coords="168,168,3" href="javascript:selectTSpoints(44100,168,168)">';
mtxt += '<area shape="circle" coords="173,168,3" href="javascript:selectTSpoints(44101,173,168)">';
mtxt += '<area shape="circle" coords="178,168,3" href="javascript:selectTSpoints(44102,178,168)">';
mtxt += '<area shape="circle" coords="183,168,3" href="javascript:selectTSpoints(44103,183,168)">';
mtxt += '<area shape="circle" coords="188,168,3" href="javascript:selectTSpoints(44104,188,168)">';
mtxt += '<area shape="circle" coords="193,168,3" href="javascript:selectTSpoints(44105,193,168)">';
mtxt += '<area shape="circle" coords="198,168,3" href="javascript:selectTSpoints(44106,198,168)">';
mtxt += '<area shape="circle" coords="203,168,3" href="javascript:selectTSpoints(44107,203,168)">';
mtxt += '<area shape="circle" coords="208,168,3" href="javascript:selectTSpoints(44108,208,168)">';
mtxt += '<area shape="circle" coords="213,168,3" href="javascript:selectTSpoints(44109,213,168)">';
mtxt += '<area shape="circle" coords="218,168,3" href="javascript:selectTSpoints(44110,218,168)">';
mtxt += '<area shape="circle" coords="224,168,3" href="javascript:selectTSpoints(44111,224,168)">';
mtxt += '<area shape="circle" coords="229,168,3" href="javascript:selectTSpoints(44112,229,168)">';
mtxt += '<area shape="circle" coords="234,168,3" href="javascript:selectTSpoints(44113,234,168)">';
mtxt += '<area shape="circle" coords="239,168,3" href="javascript:selectTSpoints(44114,239,168)">';
mtxt += '<area shape="circle" coords="244,168,3" href="javascript:selectTSpoints(44115,244,168)">';
mtxt += '<area shape="circle" coords="249,168,3" href="javascript:selectTSpoints(44116,249,168)">';
mtxt += '<area shape="circle" coords="254,168,3" href="javascript:selectTSpoints(44117,254,168)">';
mtxt += '<area shape="circle" coords="259,168,3" href="javascript:selectTSpoints(44118,259,168)">';
mtxt += '<area shape="circle" coords="264,168,3" href="javascript:selectTSpoints(44119,264,168)">';
mtxt += '<area shape="circle" coords="269,168,3" href="javascript:selectTSpoints(44120,269,168)">';
mtxt += '<area shape="circle" coords="274,168,3" href="javascript:selectTSpoints(44121,274,168)">';
mtxt += '<area shape="circle" coords="280,168,3" href="javascript:selectTSpoints(44122,280,168)">';
mtxt += '<area shape="circle" coords="285,168,3" href="javascript:selectTSpoints(44123,285,168)">';
mtxt += '<area shape="circle" coords="290,168,3" href="javascript:selectTSpoints(44124,290,168)">';
mtxt += '<area shape="circle" coords="295,168,3" href="javascript:selectTSpoints(44125,295,168)">';
mtxt += '<area shape="circle" coords="300,168,3" href="javascript:selectTSpoints(44126,300,168)">';
mtxt += '<area shape="circle" coords="305,168,3" href="javascript:selectTSpoints(44127,305,168)">';
mtxt += '<area shape="circle" coords="310,168,3" href="javascript:selectTSpoints(44128,310,168)">';
mtxt += '<area shape="circle" coords="315,168,3" href="javascript:selectTSpoints(44129,315,168)">';
mtxt += '<area shape="circle" coords="320,168,3" href="javascript:selectTSpoints(44130,320,168)">';
mtxt += '<area shape="circle" coords="325,168,3" href="javascript:selectTSpoints(44131,325,168)">';
mtxt += '<area shape="circle" coords="330,168,3" href="javascript:selectTSpoints(44132,330,168)">';
mtxt += '<area shape="circle" coords="336,168,3" href="javascript:selectTSpoints(44133,336,168)">';
mtxt += '<area shape="circle" coords="341,168,3" href="javascript:selectTSpoints(44134,341,168)">';
mtxt += '<area shape="circle" coords="346,168,3" href="javascript:selectTSpoints(44135,346,168)">';
mtxt += '<area shape="circle" coords="351,168,3" href="javascript:selectTSpoints(44136,351,168)">';
mtxt += '<area shape="circle" coords="356,168,3" href="javascript:selectTSpoints(44137,356,168)">';
mtxt += '<area shape="circle" coords="361,168,3" href="javascript:selectTSpoints(44138,361,168)">';
mtxt += '<area shape="circle" coords="366,168,3" href="javascript:selectTSpoints(44139,366,168)">';
mtxt += '<area shape="circle" coords="371,168,3" href="javascript:selectTSpoints(44140,371,168)">';
mtxt += '<area shape="circle" coords="376,168,3" href="javascript:selectTSpoints(44141,376,168)">';
mtxt += '<area shape="circle" coords="381,168,3" href="javascript:selectTSpoints(44142,381,168)">';
mtxt += '<area shape="circle" coords="386,168,3" href="javascript:selectTSpoints(44143,386,168)">';
mtxt += '<area shape="circle" coords="392,168,3" href="javascript:selectTSpoints(44144,392,168)">';
mtxt += '<area shape="circle" coords="397,168,3" href="javascript:selectTSpoints(44001,397,168)">';
mtxt += '<area shape="circle" coords="402,168,3" href="javascript:selectTSpoints(44002,402,168)">';
mtxt += '<area shape="circle" coords="407,168,3" href="javascript:selectTSpoints(44003,407,168)">';
mtxt += '<area shape="circle" coords="412,168,3" href="javascript:selectTSpoints(44004,412,168)">';
mtxt += '<area shape="circle" coords="417,168,3" href="javascript:selectTSpoints(44005,417,168)">';
mtxt += '<area shape="circle" coords="422,168,3" href="javascript:selectTSpoints(44006,422,168)">';
mtxt += '<area shape="circle" coords="427,168,3" href="javascript:selectTSpoints(44007,427,168)">';
mtxt += '<area shape="circle" coords="432,168,3" href="javascript:selectTSpoints(44008,432,168)">';
mtxt += '<area shape="circle" coords="437,168,3" href="javascript:selectTSpoints(44009,437,168)">';
mtxt += '<area shape="circle" coords="442,168,3" href="javascript:selectTSpoints(44010,442,168)">';
mtxt += '<area shape="circle" coords="447,168,3" href="javascript:selectTSpoints(44011,447,168)">';
mtxt += '<area shape="circle" coords="453,168,3" href="javascript:selectTSpoints(44012,453,168)">';
mtxt += '<area shape="circle" coords="458,168,3" href="javascript:selectTSpoints(44013,458,168)">';
mtxt += '<area shape="circle" coords="463,168,3" href="javascript:selectTSpoints(44014,463,168)">';
mtxt += '<area shape="circle" coords="468,168,3" href="javascript:selectTSpoints(44015,468,168)">';
mtxt += '<area shape="circle" coords="473,168,3" href="javascript:selectTSpoints(44016,473,168)">';
mtxt += '<area shape="circle" coords="478,168,3" href="javascript:selectTSpoints(44017,478,168)">';
mtxt += '<area shape="circle" coords="483,168,3" href="javascript:selectTSpoints(44018,483,168)">';
mtxt += '<area shape="circle" coords="488,168,3" href="javascript:selectTSpoints(44019,488,168)">';
mtxt += '<area shape="circle" coords="493,168,3" href="javascript:selectTSpoints(44020,493,168)">';
mtxt += '<area shape="circle" coords="498,168,3" href="javascript:selectTSpoints(44021,498,168)">';
mtxt += '<area shape="circle" coords="503,168,3" href="javascript:selectTSpoints(44022,503,168)">';
mtxt += '<area shape="circle" coords="509,168,3" href="javascript:selectTSpoints(44023,509,168)">';
mtxt += '<area shape="circle" coords="514,168,3" href="javascript:selectTSpoints(44024,514,168)">';
mtxt += '<area shape="circle" coords="519,168,3" href="javascript:selectTSpoints(44025,519,168)">';
mtxt += '<area shape="circle" coords="524,168,3" href="javascript:selectTSpoints(44026,524,168)">';
mtxt += '<area shape="circle" coords="529,168,3" href="javascript:selectTSpoints(44027,529,168)">';
mtxt += '<area shape="circle" coords="534,168,3" href="javascript:selectTSpoints(44028,534,168)">';
mtxt += '<area shape="circle" coords="539,168,3" href="javascript:selectTSpoints(44029,539,168)">';
mtxt += '<area shape="circle" coords="544,168,3" href="javascript:selectTSpoints(44030,544,168)">';
mtxt += '<area shape="circle" coords="549,168,3" href="javascript:selectTSpoints(44031,549,168)">';
mtxt += '<area shape="circle" coords="554,168,3" href="javascript:selectTSpoints(44032,554,168)">';
mtxt += '<area shape="circle" coords="559,168,3" href="javascript:selectTSpoints(44033,559,168)">';
mtxt += '<area shape="circle" coords="565,168,3" href="javascript:selectTSpoints(44034,565,168)">';
mtxt += '<area shape="circle" coords="570,168,3" href="javascript:selectTSpoints(44035,570,168)">';
mtxt += '<area shape="circle" coords="575,168,3" href="javascript:selectTSpoints(44036,575,168)">';
mtxt += '<area shape="circle" coords="580,168,3" href="javascript:selectTSpoints(44037,580,168)">';
mtxt += '<area shape="circle" coords="585,168,3" href="javascript:selectTSpoints(44038,585,168)">';
mtxt += '<area shape="circle" coords="590,168,3" href="javascript:selectTSpoints(44039,590,168)">';
mtxt += '<area shape="circle" coords="595,168,3" href="javascript:selectTSpoints(44040,595,168)">';
mtxt += '<area shape="circle" coords="600,168,3" href="javascript:selectTSpoints(44041,600,168)">';
mtxt += '<area shape="circle" coords="605,168,3" href="javascript:selectTSpoints(44042,605,168)">';
mtxt += '<area shape="circle" coords="610,168,3" href="javascript:selectTSpoints(44043,610,168)">';
mtxt += '<area shape="circle" coords="615,168,3" href="javascript:selectTSpoints(44044,615,168)">';
mtxt += '<area shape="circle" coords="621,168,3" href="javascript:selectTSpoints(44045,621,168)">';
mtxt += '<area shape="circle" coords="626,168,3" href="javascript:selectTSpoints(44046,626,168)">';
mtxt += '<area shape="circle" coords="631,168,3" href="javascript:selectTSpoints(44047,631,168)">';
mtxt += '<area shape="circle" coords="636,168,3" href="javascript:selectTSpoints(44048,636,168)">';
mtxt += '<area shape="circle" coords="641,168,3" href="javascript:selectTSpoints(44049,641,168)">';
mtxt += '<area shape="circle" coords="646,168,3" href="javascript:selectTSpoints(44050,646,168)">';
mtxt += '<area shape="circle" coords="651,168,3" href="javascript:selectTSpoints(44051,651,168)">';
mtxt += '<area shape="circle" coords="656,168,3" href="javascript:selectTSpoints(44052,656,168)">';
mtxt += '<area shape="circle" coords="661,168,3" href="javascript:selectTSpoints(44053,661,168)">';
mtxt += '<area shape="circle" coords="666,168,3" href="javascript:selectTSpoints(44054,666,168)">';
mtxt += '<area shape="circle" coords="671,168,3" href="javascript:selectTSpoints(44055,671,168)">';
mtxt += '<area shape="circle" coords="677,168,3" href="javascript:selectTSpoints(44056,677,168)">';
mtxt += '<area shape="circle" coords="682,168,3" href="javascript:selectTSpoints(44057,682,168)">';
mtxt += '<area shape="circle" coords="687,168,3" href="javascript:selectTSpoints(44058,687,168)">';
mtxt += '<area shape="circle" coords="692,168,3" href="javascript:selectTSpoints(44059,692,168)">';
mtxt += '<area shape="circle" coords="697,168,3" href="javascript:selectTSpoints(44060,697,168)">';
mtxt += '<area shape="circle" coords="702,168,3" href="javascript:selectTSpoints(44061,702,168)">';
mtxt += '<area shape="circle" coords="707,168,3" href="javascript:selectTSpoints(44062,707,168)">';
mtxt += '<area shape="circle" coords="712,168,3" href="javascript:selectTSpoints(44063,712,168)">';
mtxt += '<area shape="circle" coords="717,168,3" href="javascript:selectTSpoints(44064,717,168)">';
mtxt += '<area shape="circle" coords="722,168,3" href="javascript:selectTSpoints(44065,722,168)">';
mtxt += '<area shape="circle" coords="727,168,3" href="javascript:selectTSpoints(44066,727,168)">';
mtxt += '<area shape="circle" coords="733,168,3" href="javascript:selectTSpoints(44067,733,168)">';
mtxt += '<area shape="circle" coords="738,168,3" href="javascript:selectTSpoints(44068,738,168)">';
mtxt += '<area shape="circle" coords="743,168,3" href="javascript:selectTSpoints(44069,743,168)">';
mtxt += '<area shape="circle" coords="748,168,3" href="javascript:selectTSpoints(44070,748,168)">';
mtxt += '<area shape="circle" coords="753,168,3" href="javascript:selectTSpoints(44071,753,168)">';
mtxt += '<area shape="circle" coords="758,168,3" href="javascript:selectTSpoints(44072,758,168)">';
mtxt += '<area shape="circle" coords=" 30,163,3" href="javascript:selectTSpoints(45073, 30,163)">';
mtxt += '<area shape="circle" coords=" 35,163,3" href="javascript:selectTSpoints(45074, 35,163)">';
mtxt += '<area shape="circle" coords=" 40,163,3" href="javascript:selectTSpoints(45075, 40,163)">';
mtxt += '<area shape="circle" coords=" 45,163,3" href="javascript:selectTSpoints(45076, 45,163)">';
mtxt += '<area shape="circle" coords=" 50,163,3" href="javascript:selectTSpoints(45077, 50,163)">';
mtxt += '<area shape="circle" coords=" 56,163,3" href="javascript:selectTSpoints(45078, 56,163)">';
mtxt += '<area shape="circle" coords=" 61,163,3" href="javascript:selectTSpoints(45079, 61,163)">';
mtxt += '<area shape="circle" coords=" 66,163,3" href="javascript:selectTSpoints(45080, 66,163)">';
mtxt += '<area shape="circle" coords=" 71,163,3" href="javascript:selectTSpoints(45081, 71,163)">';
mtxt += '<area shape="circle" coords=" 76,163,3" href="javascript:selectTSpoints(45082, 76,163)">';
mtxt += '<area shape="circle" coords=" 81,163,3" href="javascript:selectTSpoints(45083, 81,163)">';
mtxt += '<area shape="circle" coords=" 86,163,3" href="javascript:selectTSpoints(45084, 86,163)">';
mtxt += '<area shape="circle" coords=" 91,163,3" href="javascript:selectTSpoints(45085, 91,163)">';
mtxt += '<area shape="circle" coords=" 96,163,3" href="javascript:selectTSpoints(45086, 96,163)">';
mtxt += '<area shape="circle" coords="101,163,3" href="javascript:selectTSpoints(45087,101,163)">';
mtxt += '<area shape="circle" coords="106,163,3" href="javascript:selectTSpoints(45088,106,163)">';
mtxt += '<area shape="circle" coords="112,163,3" href="javascript:selectTSpoints(45089,112,163)">';
mtxt += '<area shape="circle" coords="117,163,3" href="javascript:selectTSpoints(45090,117,163)">';
mtxt += '<area shape="circle" coords="122,163,3" href="javascript:selectTSpoints(45091,122,163)">';
mtxt += '<area shape="circle" coords="127,163,3" href="javascript:selectTSpoints(45092,127,163)">';
mtxt += '<area shape="circle" coords="132,163,3" href="javascript:selectTSpoints(45093,132,163)">';
mtxt += '<area shape="circle" coords="137,163,3" href="javascript:selectTSpoints(45094,137,163)">';
mtxt += '<area shape="circle" coords="142,163,3" href="javascript:selectTSpoints(45095,142,163)">';
mtxt += '<area shape="circle" coords="147,163,3" href="javascript:selectTSpoints(45096,147,163)">';
mtxt += '<area shape="circle" coords="152,163,3" href="javascript:selectTSpoints(45097,152,163)">';
mtxt += '<area shape="circle" coords="157,163,3" href="javascript:selectTSpoints(45098,157,163)">';
mtxt += '<area shape="circle" coords="162,163,3" href="javascript:selectTSpoints(45099,162,163)">';
mtxt += '<area shape="circle" coords="168,163,3" href="javascript:selectTSpoints(45100,168,163)">';
mtxt += '<area shape="circle" coords="173,163,3" href="javascript:selectTSpoints(45101,173,163)">';
mtxt += '<area shape="circle" coords="178,163,3" href="javascript:selectTSpoints(45102,178,163)">';
mtxt += '<area shape="circle" coords="183,163,3" href="javascript:selectTSpoints(45103,183,163)">';
mtxt += '<area shape="circle" coords="188,163,3" href="javascript:selectTSpoints(45104,188,163)">';
mtxt += '<area shape="circle" coords="193,163,3" href="javascript:selectTSpoints(45105,193,163)">';
mtxt += '<area shape="circle" coords="198,163,3" href="javascript:selectTSpoints(45106,198,163)">';
mtxt += '<area shape="circle" coords="203,163,3" href="javascript:selectTSpoints(45107,203,163)">';
mtxt += '<area shape="circle" coords="208,163,3" href="javascript:selectTSpoints(45108,208,163)">';
mtxt += '<area shape="circle" coords="213,163,3" href="javascript:selectTSpoints(45109,213,163)">';
mtxt += '<area shape="circle" coords="218,163,3" href="javascript:selectTSpoints(45110,218,163)">';
mtxt += '<area shape="circle" coords="224,163,3" href="javascript:selectTSpoints(45111,224,163)">';
mtxt += '<area shape="circle" coords="229,163,3" href="javascript:selectTSpoints(45112,229,163)">';
mtxt += '<area shape="circle" coords="234,163,3" href="javascript:selectTSpoints(45113,234,163)">';
mtxt += '<area shape="circle" coords="239,163,3" href="javascript:selectTSpoints(45114,239,163)">';
mtxt += '<area shape="circle" coords="244,163,3" href="javascript:selectTSpoints(45115,244,163)">';
mtxt += '<area shape="circle" coords="249,163,3" href="javascript:selectTSpoints(45116,249,163)">';
mtxt += '<area shape="circle" coords="254,163,3" href="javascript:selectTSpoints(45117,254,163)">';
mtxt += '<area shape="circle" coords="259,163,3" href="javascript:selectTSpoints(45118,259,163)">';
mtxt += '<area shape="circle" coords="264,163,3" href="javascript:selectTSpoints(45119,264,163)">';
mtxt += '<area shape="circle" coords="269,163,3" href="javascript:selectTSpoints(45120,269,163)">';
mtxt += '<area shape="circle" coords="274,163,3" href="javascript:selectTSpoints(45121,274,163)">';
mtxt += '<area shape="circle" coords="280,163,3" href="javascript:selectTSpoints(45122,280,163)">';
mtxt += '<area shape="circle" coords="285,163,3" href="javascript:selectTSpoints(45123,285,163)">';
mtxt += '<area shape="circle" coords="290,163,3" href="javascript:selectTSpoints(45124,290,163)">';
mtxt += '<area shape="circle" coords="295,163,3" href="javascript:selectTSpoints(45125,295,163)">';
mtxt += '<area shape="circle" coords="300,163,3" href="javascript:selectTSpoints(45126,300,163)">';
mtxt += '<area shape="circle" coords="305,163,3" href="javascript:selectTSpoints(45127,305,163)">';
mtxt += '<area shape="circle" coords="310,163,3" href="javascript:selectTSpoints(45128,310,163)">';
mtxt += '<area shape="circle" coords="315,163,3" href="javascript:selectTSpoints(45129,315,163)">';
mtxt += '<area shape="circle" coords="320,163,3" href="javascript:selectTSpoints(45130,320,163)">';
mtxt += '<area shape="circle" coords="325,163,3" href="javascript:selectTSpoints(45131,325,163)">';
mtxt += '<area shape="circle" coords="330,163,3" href="javascript:selectTSpoints(45132,330,163)">';
mtxt += '<area shape="circle" coords="336,163,3" href="javascript:selectTSpoints(45133,336,163)">';
mtxt += '<area shape="circle" coords="341,163,3" href="javascript:selectTSpoints(45134,341,163)">';
mtxt += '<area shape="circle" coords="346,163,3" href="javascript:selectTSpoints(45135,346,163)">';
mtxt += '<area shape="circle" coords="351,163,3" href="javascript:selectTSpoints(45136,351,163)">';
mtxt += '<area shape="circle" coords="356,163,3" href="javascript:selectTSpoints(45137,356,163)">';
mtxt += '<area shape="circle" coords="361,163,3" href="javascript:selectTSpoints(45138,361,163)">';
mtxt += '<area shape="circle" coords="366,163,3" href="javascript:selectTSpoints(45139,366,163)">';
mtxt += '<area shape="circle" coords="371,163,3" href="javascript:selectTSpoints(45140,371,163)">';
mtxt += '<area shape="circle" coords="376,163,3" href="javascript:selectTSpoints(45141,376,163)">';
mtxt += '<area shape="circle" coords="381,163,3" href="javascript:selectTSpoints(45142,381,163)">';
mtxt += '<area shape="circle" coords="386,163,3" href="javascript:selectTSpoints(45143,386,163)">';
mtxt += '<area shape="circle" coords="392,163,3" href="javascript:selectTSpoints(45144,392,163)">';
mtxt += '<area shape="circle" coords="397,163,3" href="javascript:selectTSpoints(45001,397,163)">';
mtxt += '<area shape="circle" coords="402,163,3" href="javascript:selectTSpoints(45002,402,163)">';
mtxt += '<area shape="circle" coords="407,163,3" href="javascript:selectTSpoints(45003,407,163)">';
mtxt += '<area shape="circle" coords="412,163,3" href="javascript:selectTSpoints(45004,412,163)">';
mtxt += '<area shape="circle" coords="417,163,3" href="javascript:selectTSpoints(45005,417,163)">';
mtxt += '<area shape="circle" coords="422,163,3" href="javascript:selectTSpoints(45006,422,163)">';
mtxt += '<area shape="circle" coords="427,163,3" href="javascript:selectTSpoints(45007,427,163)">';
mtxt += '<area shape="circle" coords="432,163,3" href="javascript:selectTSpoints(45008,432,163)">';
mtxt += '<area shape="circle" coords="437,163,3" href="javascript:selectTSpoints(45009,437,163)">';
mtxt += '<area shape="circle" coords="442,163,3" href="javascript:selectTSpoints(45010,442,163)">';
mtxt += '<area shape="circle" coords="447,163,3" href="javascript:selectTSpoints(45011,447,163)">';
mtxt += '<area shape="circle" coords="453,163,3" href="javascript:selectTSpoints(45012,453,163)">';
mtxt += '<area shape="circle" coords="458,163,3" href="javascript:selectTSpoints(45013,458,163)">';
mtxt += '<area shape="circle" coords="463,163,3" href="javascript:selectTSpoints(45014,463,163)">';
mtxt += '<area shape="circle" coords="468,163,3" href="javascript:selectTSpoints(45015,468,163)">';
mtxt += '<area shape="circle" coords="473,163,3" href="javascript:selectTSpoints(45016,473,163)">';
mtxt += '<area shape="circle" coords="478,163,3" href="javascript:selectTSpoints(45017,478,163)">';
mtxt += '<area shape="circle" coords="483,163,3" href="javascript:selectTSpoints(45018,483,163)">';
mtxt += '<area shape="circle" coords="488,163,3" href="javascript:selectTSpoints(45019,488,163)">';
mtxt += '<area shape="circle" coords="493,163,3" href="javascript:selectTSpoints(45020,493,163)">';
mtxt += '<area shape="circle" coords="498,163,3" href="javascript:selectTSpoints(45021,498,163)">';
mtxt += '<area shape="circle" coords="503,163,3" href="javascript:selectTSpoints(45022,503,163)">';
mtxt += '<area shape="circle" coords="509,163,3" href="javascript:selectTSpoints(45023,509,163)">';
mtxt += '<area shape="circle" coords="514,163,3" href="javascript:selectTSpoints(45024,514,163)">';
mtxt += '<area shape="circle" coords="519,163,3" href="javascript:selectTSpoints(45025,519,163)">';
mtxt += '<area shape="circle" coords="524,163,3" href="javascript:selectTSpoints(45026,524,163)">';
mtxt += '<area shape="circle" coords="529,163,3" href="javascript:selectTSpoints(45027,529,163)">';
mtxt += '<area shape="circle" coords="534,163,3" href="javascript:selectTSpoints(45028,534,163)">';
mtxt += '<area shape="circle" coords="539,163,3" href="javascript:selectTSpoints(45029,539,163)">';
mtxt += '<area shape="circle" coords="544,163,3" href="javascript:selectTSpoints(45030,544,163)">';
mtxt += '<area shape="circle" coords="549,163,3" href="javascript:selectTSpoints(45031,549,163)">';
mtxt += '<area shape="circle" coords="554,163,3" href="javascript:selectTSpoints(45032,554,163)">';
mtxt += '<area shape="circle" coords="559,163,3" href="javascript:selectTSpoints(45033,559,163)">';
mtxt += '<area shape="circle" coords="565,163,3" href="javascript:selectTSpoints(45034,565,163)">';
mtxt += '<area shape="circle" coords="570,163,3" href="javascript:selectTSpoints(45035,570,163)">';
mtxt += '<area shape="circle" coords="575,163,3" href="javascript:selectTSpoints(45036,575,163)">';
mtxt += '<area shape="circle" coords="580,163,3" href="javascript:selectTSpoints(45037,580,163)">';
mtxt += '<area shape="circle" coords="585,163,3" href="javascript:selectTSpoints(45038,585,163)">';
mtxt += '<area shape="circle" coords="590,163,3" href="javascript:selectTSpoints(45039,590,163)">';
mtxt += '<area shape="circle" coords="595,163,3" href="javascript:selectTSpoints(45040,595,163)">';
mtxt += '<area shape="circle" coords="600,163,3" href="javascript:selectTSpoints(45041,600,163)">';
mtxt += '<area shape="circle" coords="605,163,3" href="javascript:selectTSpoints(45042,605,163)">';
mtxt += '<area shape="circle" coords="610,163,3" href="javascript:selectTSpoints(45043,610,163)">';
mtxt += '<area shape="circle" coords="615,163,3" href="javascript:selectTSpoints(45044,615,163)">';
mtxt += '<area shape="circle" coords="621,163,3" href="javascript:selectTSpoints(45045,621,163)">';
mtxt += '<area shape="circle" coords="626,163,3" href="javascript:selectTSpoints(45046,626,163)">';
mtxt += '<area shape="circle" coords="631,163,3" href="javascript:selectTSpoints(45047,631,163)">';
mtxt += '<area shape="circle" coords="636,163,3" href="javascript:selectTSpoints(45048,636,163)">';
mtxt += '<area shape="circle" coords="641,163,3" href="javascript:selectTSpoints(45049,641,163)">';
mtxt += '<area shape="circle" coords="646,163,3" href="javascript:selectTSpoints(45050,646,163)">';
mtxt += '<area shape="circle" coords="651,163,3" href="javascript:selectTSpoints(45051,651,163)">';
mtxt += '<area shape="circle" coords="656,163,3" href="javascript:selectTSpoints(45052,656,163)">';
mtxt += '<area shape="circle" coords="661,163,3" href="javascript:selectTSpoints(45053,661,163)">';
mtxt += '<area shape="circle" coords="666,163,3" href="javascript:selectTSpoints(45054,666,163)">';
mtxt += '<area shape="circle" coords="671,163,3" href="javascript:selectTSpoints(45055,671,163)">';
mtxt += '<area shape="circle" coords="677,163,3" href="javascript:selectTSpoints(45056,677,163)">';
mtxt += '<area shape="circle" coords="682,163,3" href="javascript:selectTSpoints(45057,682,163)">';
mtxt += '<area shape="circle" coords="687,163,3" href="javascript:selectTSpoints(45058,687,163)">';
mtxt += '<area shape="circle" coords="692,163,3" href="javascript:selectTSpoints(45059,692,163)">';
mtxt += '<area shape="circle" coords="697,163,3" href="javascript:selectTSpoints(45060,697,163)">';
mtxt += '<area shape="circle" coords="702,163,3" href="javascript:selectTSpoints(45061,702,163)">';
mtxt += '<area shape="circle" coords="707,163,3" href="javascript:selectTSpoints(45062,707,163)">';
mtxt += '<area shape="circle" coords="712,163,3" href="javascript:selectTSpoints(45063,712,163)">';
mtxt += '<area shape="circle" coords="717,163,3" href="javascript:selectTSpoints(45064,717,163)">';
mtxt += '<area shape="circle" coords="722,163,3" href="javascript:selectTSpoints(45065,722,163)">';
mtxt += '<area shape="circle" coords="727,163,3" href="javascript:selectTSpoints(45066,727,163)">';
mtxt += '<area shape="circle" coords="733,163,3" href="javascript:selectTSpoints(45067,733,163)">';
mtxt += '<area shape="circle" coords="738,163,3" href="javascript:selectTSpoints(45068,738,163)">';
mtxt += '<area shape="circle" coords="743,163,3" href="javascript:selectTSpoints(45069,743,163)">';
mtxt += '<area shape="circle" coords="748,163,3" href="javascript:selectTSpoints(45070,748,163)">';
mtxt += '<area shape="circle" coords="753,163,3" href="javascript:selectTSpoints(45071,753,163)">';
mtxt += '<area shape="circle" coords="758,163,3" href="javascript:selectTSpoints(45072,758,163)">';
mtxt += '<area shape="circle" coords=" 30,158,3" href="javascript:selectTSpoints(46073, 30,158)">';
mtxt += '<area shape="circle" coords=" 35,158,3" href="javascript:selectTSpoints(46074, 35,158)">';
mtxt += '<area shape="circle" coords=" 40,158,3" href="javascript:selectTSpoints(46075, 40,158)">';
mtxt += '<area shape="circle" coords=" 45,158,3" href="javascript:selectTSpoints(46076, 45,158)">';
mtxt += '<area shape="circle" coords=" 50,158,3" href="javascript:selectTSpoints(46077, 50,158)">';
mtxt += '<area shape="circle" coords=" 56,158,3" href="javascript:selectTSpoints(46078, 56,158)">';
mtxt += '<area shape="circle" coords=" 61,158,3" href="javascript:selectTSpoints(46079, 61,158)">';
mtxt += '<area shape="circle" coords=" 66,158,3" href="javascript:selectTSpoints(46080, 66,158)">';
mtxt += '<area shape="circle" coords=" 71,158,3" href="javascript:selectTSpoints(46081, 71,158)">';
mtxt += '<area shape="circle" coords=" 76,158,3" href="javascript:selectTSpoints(46082, 76,158)">';
mtxt += '<area shape="circle" coords=" 81,158,3" href="javascript:selectTSpoints(46083, 81,158)">';
mtxt += '<area shape="circle" coords=" 86,158,3" href="javascript:selectTSpoints(46084, 86,158)">';
mtxt += '<area shape="circle" coords=" 91,158,3" href="javascript:selectTSpoints(46085, 91,158)">';
mtxt += '<area shape="circle" coords=" 96,158,3" href="javascript:selectTSpoints(46086, 96,158)">';
mtxt += '<area shape="circle" coords="101,158,3" href="javascript:selectTSpoints(46087,101,158)">';
mtxt += '<area shape="circle" coords="106,158,3" href="javascript:selectTSpoints(46088,106,158)">';
mtxt += '<area shape="circle" coords="112,158,3" href="javascript:selectTSpoints(46089,112,158)">';
mtxt += '<area shape="circle" coords="117,158,3" href="javascript:selectTSpoints(46090,117,158)">';
mtxt += '<area shape="circle" coords="122,158,3" href="javascript:selectTSpoints(46091,122,158)">';
mtxt += '<area shape="circle" coords="127,158,3" href="javascript:selectTSpoints(46092,127,158)">';
mtxt += '<area shape="circle" coords="132,158,3" href="javascript:selectTSpoints(46093,132,158)">';
mtxt += '<area shape="circle" coords="137,158,3" href="javascript:selectTSpoints(46094,137,158)">';
mtxt += '<area shape="circle" coords="142,158,3" href="javascript:selectTSpoints(46095,142,158)">';
mtxt += '<area shape="circle" coords="147,158,3" href="javascript:selectTSpoints(46096,147,158)">';
mtxt += '<area shape="circle" coords="152,158,3" href="javascript:selectTSpoints(46097,152,158)">';
mtxt += '<area shape="circle" coords="157,158,3" href="javascript:selectTSpoints(46098,157,158)">';
mtxt += '<area shape="circle" coords="162,158,3" href="javascript:selectTSpoints(46099,162,158)">';
mtxt += '<area shape="circle" coords="168,158,3" href="javascript:selectTSpoints(46100,168,158)">';
mtxt += '<area shape="circle" coords="173,158,3" href="javascript:selectTSpoints(46101,173,158)">';
mtxt += '<area shape="circle" coords="178,158,3" href="javascript:selectTSpoints(46102,178,158)">';
mtxt += '<area shape="circle" coords="183,158,3" href="javascript:selectTSpoints(46103,183,158)">';
mtxt += '<area shape="circle" coords="188,158,3" href="javascript:selectTSpoints(46104,188,158)">';
mtxt += '<area shape="circle" coords="193,158,3" href="javascript:selectTSpoints(46105,193,158)">';
mtxt += '<area shape="circle" coords="198,158,3" href="javascript:selectTSpoints(46106,198,158)">';
mtxt += '<area shape="circle" coords="203,158,3" href="javascript:selectTSpoints(46107,203,158)">';
mtxt += '<area shape="circle" coords="208,158,3" href="javascript:selectTSpoints(46108,208,158)">';
mtxt += '<area shape="circle" coords="213,158,3" href="javascript:selectTSpoints(46109,213,158)">';
mtxt += '<area shape="circle" coords="218,158,3" href="javascript:selectTSpoints(46110,218,158)">';
mtxt += '<area shape="circle" coords="224,158,3" href="javascript:selectTSpoints(46111,224,158)">';
mtxt += '<area shape="circle" coords="229,158,3" href="javascript:selectTSpoints(46112,229,158)">';
mtxt += '<area shape="circle" coords="234,158,3" href="javascript:selectTSpoints(46113,234,158)">';
mtxt += '<area shape="circle" coords="239,158,3" href="javascript:selectTSpoints(46114,239,158)">';
mtxt += '<area shape="circle" coords="244,158,3" href="javascript:selectTSpoints(46115,244,158)">';
mtxt += '<area shape="circle" coords="249,158,3" href="javascript:selectTSpoints(46116,249,158)">';
mtxt += '<area shape="circle" coords="254,158,3" href="javascript:selectTSpoints(46117,254,158)">';
mtxt += '<area shape="circle" coords="259,158,3" href="javascript:selectTSpoints(46118,259,158)">';
mtxt += '<area shape="circle" coords="264,158,3" href="javascript:selectTSpoints(46119,264,158)">';
mtxt += '<area shape="circle" coords="269,158,3" href="javascript:selectTSpoints(46120,269,158)">';
mtxt += '<area shape="circle" coords="274,158,3" href="javascript:selectTSpoints(46121,274,158)">';
mtxt += '<area shape="circle" coords="280,158,3" href="javascript:selectTSpoints(46122,280,158)">';
mtxt += '<area shape="circle" coords="285,158,3" href="javascript:selectTSpoints(46123,285,158)">';
mtxt += '<area shape="circle" coords="290,158,3" href="javascript:selectTSpoints(46124,290,158)">';
mtxt += '<area shape="circle" coords="295,158,3" href="javascript:selectTSpoints(46125,295,158)">';
mtxt += '<area shape="circle" coords="300,158,3" href="javascript:selectTSpoints(46126,300,158)">';
mtxt += '<area shape="circle" coords="305,158,3" href="javascript:selectTSpoints(46127,305,158)">';
mtxt += '<area shape="circle" coords="310,158,3" href="javascript:selectTSpoints(46128,310,158)">';
mtxt += '<area shape="circle" coords="315,158,3" href="javascript:selectTSpoints(46129,315,158)">';
mtxt += '<area shape="circle" coords="320,158,3" href="javascript:selectTSpoints(46130,320,158)">';
mtxt += '<area shape="circle" coords="325,158,3" href="javascript:selectTSpoints(46131,325,158)">';
mtxt += '<area shape="circle" coords="330,158,3" href="javascript:selectTSpoints(46132,330,158)">';
mtxt += '<area shape="circle" coords="336,158,3" href="javascript:selectTSpoints(46133,336,158)">';
mtxt += '<area shape="circle" coords="341,158,3" href="javascript:selectTSpoints(46134,341,158)">';
mtxt += '<area shape="circle" coords="346,158,3" href="javascript:selectTSpoints(46135,346,158)">';
mtxt += '<area shape="circle" coords="351,158,3" href="javascript:selectTSpoints(46136,351,158)">';
mtxt += '<area shape="circle" coords="356,158,3" href="javascript:selectTSpoints(46137,356,158)">';
mtxt += '<area shape="circle" coords="361,158,3" href="javascript:selectTSpoints(46138,361,158)">';
mtxt += '<area shape="circle" coords="366,158,3" href="javascript:selectTSpoints(46139,366,158)">';
mtxt += '<area shape="circle" coords="371,158,3" href="javascript:selectTSpoints(46140,371,158)">';
mtxt += '<area shape="circle" coords="376,158,3" href="javascript:selectTSpoints(46141,376,158)">';
mtxt += '<area shape="circle" coords="381,158,3" href="javascript:selectTSpoints(46142,381,158)">';
mtxt += '<area shape="circle" coords="386,158,3" href="javascript:selectTSpoints(46143,386,158)">';
mtxt += '<area shape="circle" coords="392,158,3" href="javascript:selectTSpoints(46144,392,158)">';
mtxt += '<area shape="circle" coords="397,158,3" href="javascript:selectTSpoints(46001,397,158)">';
mtxt += '<area shape="circle" coords="402,158,3" href="javascript:selectTSpoints(46002,402,158)">';
mtxt += '<area shape="circle" coords="407,158,3" href="javascript:selectTSpoints(46003,407,158)">';
mtxt += '<area shape="circle" coords="412,158,3" href="javascript:selectTSpoints(46004,412,158)">';
mtxt += '<area shape="circle" coords="417,158,3" href="javascript:selectTSpoints(46005,417,158)">';
mtxt += '<area shape="circle" coords="422,158,3" href="javascript:selectTSpoints(46006,422,158)">';
mtxt += '<area shape="circle" coords="427,158,3" href="javascript:selectTSpoints(46007,427,158)">';
mtxt += '<area shape="circle" coords="432,158,3" href="javascript:selectTSpoints(46008,432,158)">';
mtxt += '<area shape="circle" coords="437,158,3" href="javascript:selectTSpoints(46009,437,158)">';
mtxt += '<area shape="circle" coords="442,158,3" href="javascript:selectTSpoints(46010,442,158)">';
mtxt += '<area shape="circle" coords="447,158,3" href="javascript:selectTSpoints(46011,447,158)">';
mtxt += '<area shape="circle" coords="453,158,3" href="javascript:selectTSpoints(46012,453,158)">';
mtxt += '<area shape="circle" coords="458,158,3" href="javascript:selectTSpoints(46013,458,158)">';
mtxt += '<area shape="circle" coords="463,158,3" href="javascript:selectTSpoints(46014,463,158)">';
mtxt += '<area shape="circle" coords="468,158,3" href="javascript:selectTSpoints(46015,468,158)">';
mtxt += '<area shape="circle" coords="473,158,3" href="javascript:selectTSpoints(46016,473,158)">';
mtxt += '<area shape="circle" coords="478,158,3" href="javascript:selectTSpoints(46017,478,158)">';
mtxt += '<area shape="circle" coords="483,158,3" href="javascript:selectTSpoints(46018,483,158)">';
mtxt += '<area shape="circle" coords="488,158,3" href="javascript:selectTSpoints(46019,488,158)">';
mtxt += '<area shape="circle" coords="493,158,3" href="javascript:selectTSpoints(46020,493,158)">';
mtxt += '<area shape="circle" coords="498,158,3" href="javascript:selectTSpoints(46021,498,158)">';
mtxt += '<area shape="circle" coords="503,158,3" href="javascript:selectTSpoints(46022,503,158)">';
mtxt += '<area shape="circle" coords="509,158,3" href="javascript:selectTSpoints(46023,509,158)">';
mtxt += '<area shape="circle" coords="514,158,3" href="javascript:selectTSpoints(46024,514,158)">';
mtxt += '<area shape="circle" coords="519,158,3" href="javascript:selectTSpoints(46025,519,158)">';
mtxt += '<area shape="circle" coords="524,158,3" href="javascript:selectTSpoints(46026,524,158)">';
mtxt += '<area shape="circle" coords="529,158,3" href="javascript:selectTSpoints(46027,529,158)">';
mtxt += '<area shape="circle" coords="534,158,3" href="javascript:selectTSpoints(46028,534,158)">';
mtxt += '<area shape="circle" coords="539,158,3" href="javascript:selectTSpoints(46029,539,158)">';
mtxt += '<area shape="circle" coords="544,158,3" href="javascript:selectTSpoints(46030,544,158)">';
mtxt += '<area shape="circle" coords="549,158,3" href="javascript:selectTSpoints(46031,549,158)">';
mtxt += '<area shape="circle" coords="554,158,3" href="javascript:selectTSpoints(46032,554,158)">';
mtxt += '<area shape="circle" coords="559,158,3" href="javascript:selectTSpoints(46033,559,158)">';
mtxt += '<area shape="circle" coords="565,158,3" href="javascript:selectTSpoints(46034,565,158)">';
mtxt += '<area shape="circle" coords="570,158,3" href="javascript:selectTSpoints(46035,570,158)">';
mtxt += '<area shape="circle" coords="575,158,3" href="javascript:selectTSpoints(46036,575,158)">';
mtxt += '<area shape="circle" coords="580,158,3" href="javascript:selectTSpoints(46037,580,158)">';
mtxt += '<area shape="circle" coords="585,158,3" href="javascript:selectTSpoints(46038,585,158)">';
mtxt += '<area shape="circle" coords="590,158,3" href="javascript:selectTSpoints(46039,590,158)">';
mtxt += '<area shape="circle" coords="595,158,3" href="javascript:selectTSpoints(46040,595,158)">';
mtxt += '<area shape="circle" coords="600,158,3" href="javascript:selectTSpoints(46041,600,158)">';
mtxt += '<area shape="circle" coords="605,158,3" href="javascript:selectTSpoints(46042,605,158)">';
mtxt += '<area shape="circle" coords="610,158,3" href="javascript:selectTSpoints(46043,610,158)">';
mtxt += '<area shape="circle" coords="615,158,3" href="javascript:selectTSpoints(46044,615,158)">';
mtxt += '<area shape="circle" coords="621,158,3" href="javascript:selectTSpoints(46045,621,158)">';
mtxt += '<area shape="circle" coords="626,158,3" href="javascript:selectTSpoints(46046,626,158)">';
mtxt += '<area shape="circle" coords="631,158,3" href="javascript:selectTSpoints(46047,631,158)">';
mtxt += '<area shape="circle" coords="636,158,3" href="javascript:selectTSpoints(46048,636,158)">';
mtxt += '<area shape="circle" coords="641,158,3" href="javascript:selectTSpoints(46049,641,158)">';
mtxt += '<area shape="circle" coords="646,158,3" href="javascript:selectTSpoints(46050,646,158)">';
mtxt += '<area shape="circle" coords="651,158,3" href="javascript:selectTSpoints(46051,651,158)">';
mtxt += '<area shape="circle" coords="656,158,3" href="javascript:selectTSpoints(46052,656,158)">';
mtxt += '<area shape="circle" coords="661,158,3" href="javascript:selectTSpoints(46053,661,158)">';
mtxt += '<area shape="circle" coords="666,158,3" href="javascript:selectTSpoints(46054,666,158)">';
mtxt += '<area shape="circle" coords="671,158,3" href="javascript:selectTSpoints(46055,671,158)">';
mtxt += '<area shape="circle" coords="677,158,3" href="javascript:selectTSpoints(46056,677,158)">';
mtxt += '<area shape="circle" coords="682,158,3" href="javascript:selectTSpoints(46057,682,158)">';
mtxt += '<area shape="circle" coords="687,158,3" href="javascript:selectTSpoints(46058,687,158)">';
mtxt += '<area shape="circle" coords="692,158,3" href="javascript:selectTSpoints(46059,692,158)">';
mtxt += '<area shape="circle" coords="697,158,3" href="javascript:selectTSpoints(46060,697,158)">';
mtxt += '<area shape="circle" coords="702,158,3" href="javascript:selectTSpoints(46061,702,158)">';
mtxt += '<area shape="circle" coords="707,158,3" href="javascript:selectTSpoints(46062,707,158)">';
mtxt += '<area shape="circle" coords="712,158,3" href="javascript:selectTSpoints(46063,712,158)">';
mtxt += '<area shape="circle" coords="717,158,3" href="javascript:selectTSpoints(46064,717,158)">';
mtxt += '<area shape="circle" coords="722,158,3" href="javascript:selectTSpoints(46065,722,158)">';
mtxt += '<area shape="circle" coords="727,158,3" href="javascript:selectTSpoints(46066,727,158)">';
mtxt += '<area shape="circle" coords="733,158,3" href="javascript:selectTSpoints(46067,733,158)">';
mtxt += '<area shape="circle" coords="738,158,3" href="javascript:selectTSpoints(46068,738,158)">';
mtxt += '<area shape="circle" coords="743,158,3" href="javascript:selectTSpoints(46069,743,158)">';
mtxt += '<area shape="circle" coords="748,158,3" href="javascript:selectTSpoints(46070,748,158)">';
mtxt += '<area shape="circle" coords="753,158,3" href="javascript:selectTSpoints(46071,753,158)">';
mtxt += '<area shape="circle" coords="758,158,3" href="javascript:selectTSpoints(46072,758,158)">';
mtxt += '<area shape="circle" coords=" 30,153,3" href="javascript:selectTSpoints(47073, 30,153)">';
mtxt += '<area shape="circle" coords=" 35,153,3" href="javascript:selectTSpoints(47074, 35,153)">';
mtxt += '<area shape="circle" coords=" 40,153,3" href="javascript:selectTSpoints(47075, 40,153)">';
mtxt += '<area shape="circle" coords=" 45,153,3" href="javascript:selectTSpoints(47076, 45,153)">';
mtxt += '<area shape="circle" coords=" 50,153,3" href="javascript:selectTSpoints(47077, 50,153)">';
mtxt += '<area shape="circle" coords=" 56,153,3" href="javascript:selectTSpoints(47078, 56,153)">';
mtxt += '<area shape="circle" coords=" 61,153,3" href="javascript:selectTSpoints(47079, 61,153)">';
mtxt += '<area shape="circle" coords=" 66,153,3" href="javascript:selectTSpoints(47080, 66,153)">';
mtxt += '<area shape="circle" coords=" 71,153,3" href="javascript:selectTSpoints(47081, 71,153)">';
mtxt += '<area shape="circle" coords=" 76,153,3" href="javascript:selectTSpoints(47082, 76,153)">';
mtxt += '<area shape="circle" coords=" 81,153,3" href="javascript:selectTSpoints(47083, 81,153)">';
mtxt += '<area shape="circle" coords=" 86,153,3" href="javascript:selectTSpoints(47084, 86,153)">';
mtxt += '<area shape="circle" coords=" 91,153,3" href="javascript:selectTSpoints(47085, 91,153)">';
mtxt += '<area shape="circle" coords=" 96,153,3" href="javascript:selectTSpoints(47086, 96,153)">';
mtxt += '<area shape="circle" coords="101,153,3" href="javascript:selectTSpoints(47087,101,153)">';
mtxt += '<area shape="circle" coords="106,153,3" href="javascript:selectTSpoints(47088,106,153)">';
mtxt += '<area shape="circle" coords="112,153,3" href="javascript:selectTSpoints(47089,112,153)">';
mtxt += '<area shape="circle" coords="117,153,3" href="javascript:selectTSpoints(47090,117,153)">';
mtxt += '<area shape="circle" coords="122,153,3" href="javascript:selectTSpoints(47091,122,153)">';
mtxt += '<area shape="circle" coords="127,153,3" href="javascript:selectTSpoints(47092,127,153)">';
mtxt += '<area shape="circle" coords="132,153,3" href="javascript:selectTSpoints(47093,132,153)">';
mtxt += '<area shape="circle" coords="137,153,3" href="javascript:selectTSpoints(47094,137,153)">';
mtxt += '<area shape="circle" coords="142,153,3" href="javascript:selectTSpoints(47095,142,153)">';
mtxt += '<area shape="circle" coords="147,153,3" href="javascript:selectTSpoints(47096,147,153)">';
mtxt += '<area shape="circle" coords="152,153,3" href="javascript:selectTSpoints(47097,152,153)">';
mtxt += '<area shape="circle" coords="157,153,3" href="javascript:selectTSpoints(47098,157,153)">';
mtxt += '<area shape="circle" coords="162,153,3" href="javascript:selectTSpoints(47099,162,153)">';
mtxt += '<area shape="circle" coords="168,153,3" href="javascript:selectTSpoints(47100,168,153)">';
mtxt += '<area shape="circle" coords="173,153,3" href="javascript:selectTSpoints(47101,173,153)">';
mtxt += '<area shape="circle" coords="178,153,3" href="javascript:selectTSpoints(47102,178,153)">';
mtxt += '<area shape="circle" coords="183,153,3" href="javascript:selectTSpoints(47103,183,153)">';
mtxt += '<area shape="circle" coords="188,153,3" href="javascript:selectTSpoints(47104,188,153)">';
mtxt += '<area shape="circle" coords="193,153,3" href="javascript:selectTSpoints(47105,193,153)">';
mtxt += '<area shape="circle" coords="198,153,3" href="javascript:selectTSpoints(47106,198,153)">';
mtxt += '<area shape="circle" coords="203,153,3" href="javascript:selectTSpoints(47107,203,153)">';
mtxt += '<area shape="circle" coords="208,153,3" href="javascript:selectTSpoints(47108,208,153)">';
mtxt += '<area shape="circle" coords="213,153,3" href="javascript:selectTSpoints(47109,213,153)">';
mtxt += '<area shape="circle" coords="218,153,3" href="javascript:selectTSpoints(47110,218,153)">';
mtxt += '<area shape="circle" coords="224,153,3" href="javascript:selectTSpoints(47111,224,153)">';
mtxt += '<area shape="circle" coords="229,153,3" href="javascript:selectTSpoints(47112,229,153)">';
mtxt += '<area shape="circle" coords="234,153,3" href="javascript:selectTSpoints(47113,234,153)">';
mtxt += '<area shape="circle" coords="239,153,3" href="javascript:selectTSpoints(47114,239,153)">';
mtxt += '<area shape="circle" coords="244,153,3" href="javascript:selectTSpoints(47115,244,153)">';
mtxt += '<area shape="circle" coords="249,153,3" href="javascript:selectTSpoints(47116,249,153)">';
mtxt += '<area shape="circle" coords="254,153,3" href="javascript:selectTSpoints(47117,254,153)">';
mtxt += '<area shape="circle" coords="259,153,3" href="javascript:selectTSpoints(47118,259,153)">';
mtxt += '<area shape="circle" coords="264,153,3" href="javascript:selectTSpoints(47119,264,153)">';
mtxt += '<area shape="circle" coords="269,153,3" href="javascript:selectTSpoints(47120,269,153)">';
mtxt += '<area shape="circle" coords="274,153,3" href="javascript:selectTSpoints(47121,274,153)">';
mtxt += '<area shape="circle" coords="280,153,3" href="javascript:selectTSpoints(47122,280,153)">';
mtxt += '<area shape="circle" coords="285,153,3" href="javascript:selectTSpoints(47123,285,153)">';
mtxt += '<area shape="circle" coords="290,153,3" href="javascript:selectTSpoints(47124,290,153)">';
mtxt += '<area shape="circle" coords="295,153,3" href="javascript:selectTSpoints(47125,295,153)">';
mtxt += '<area shape="circle" coords="300,153,3" href="javascript:selectTSpoints(47126,300,153)">';
mtxt += '<area shape="circle" coords="305,153,3" href="javascript:selectTSpoints(47127,305,153)">';
mtxt += '<area shape="circle" coords="310,153,3" href="javascript:selectTSpoints(47128,310,153)">';
mtxt += '<area shape="circle" coords="315,153,3" href="javascript:selectTSpoints(47129,315,153)">';
mtxt += '<area shape="circle" coords="320,153,3" href="javascript:selectTSpoints(47130,320,153)">';
mtxt += '<area shape="circle" coords="325,153,3" href="javascript:selectTSpoints(47131,325,153)">';
mtxt += '<area shape="circle" coords="330,153,3" href="javascript:selectTSpoints(47132,330,153)">';
mtxt += '<area shape="circle" coords="336,153,3" href="javascript:selectTSpoints(47133,336,153)">';
mtxt += '<area shape="circle" coords="341,153,3" href="javascript:selectTSpoints(47134,341,153)">';
mtxt += '<area shape="circle" coords="346,153,3" href="javascript:selectTSpoints(47135,346,153)">';
mtxt += '<area shape="circle" coords="351,153,3" href="javascript:selectTSpoints(47136,351,153)">';
mtxt += '<area shape="circle" coords="356,153,3" href="javascript:selectTSpoints(47137,356,153)">';
mtxt += '<area shape="circle" coords="361,153,3" href="javascript:selectTSpoints(47138,361,153)">';
mtxt += '<area shape="circle" coords="366,153,3" href="javascript:selectTSpoints(47139,366,153)">';
mtxt += '<area shape="circle" coords="371,153,3" href="javascript:selectTSpoints(47140,371,153)">';
mtxt += '<area shape="circle" coords="376,153,3" href="javascript:selectTSpoints(47141,376,153)">';
mtxt += '<area shape="circle" coords="381,153,3" href="javascript:selectTSpoints(47142,381,153)">';
mtxt += '<area shape="circle" coords="386,153,3" href="javascript:selectTSpoints(47143,386,153)">';
mtxt += '<area shape="circle" coords="392,153,3" href="javascript:selectTSpoints(47144,392,153)">';
mtxt += '<area shape="circle" coords="397,153,3" href="javascript:selectTSpoints(47001,397,153)">';
mtxt += '<area shape="circle" coords="402,153,3" href="javascript:selectTSpoints(47002,402,153)">';
mtxt += '<area shape="circle" coords="407,153,3" href="javascript:selectTSpoints(47003,407,153)">';
mtxt += '<area shape="circle" coords="412,153,3" href="javascript:selectTSpoints(47004,412,153)">';
mtxt += '<area shape="circle" coords="417,153,3" href="javascript:selectTSpoints(47005,417,153)">';
mtxt += '<area shape="circle" coords="422,153,3" href="javascript:selectTSpoints(47006,422,153)">';
mtxt += '<area shape="circle" coords="427,153,3" href="javascript:selectTSpoints(47007,427,153)">';
mtxt += '<area shape="circle" coords="432,153,3" href="javascript:selectTSpoints(47008,432,153)">';
mtxt += '<area shape="circle" coords="437,153,3" href="javascript:selectTSpoints(47009,437,153)">';
mtxt += '<area shape="circle" coords="442,153,3" href="javascript:selectTSpoints(47010,442,153)">';
mtxt += '<area shape="circle" coords="447,153,3" href="javascript:selectTSpoints(47011,447,153)">';
mtxt += '<area shape="circle" coords="453,153,3" href="javascript:selectTSpoints(47012,453,153)">';
mtxt += '<area shape="circle" coords="458,153,3" href="javascript:selectTSpoints(47013,458,153)">';
mtxt += '<area shape="circle" coords="463,153,3" href="javascript:selectTSpoints(47014,463,153)">';
mtxt += '<area shape="circle" coords="468,153,3" href="javascript:selectTSpoints(47015,468,153)">';
mtxt += '<area shape="circle" coords="473,153,3" href="javascript:selectTSpoints(47016,473,153)">';
mtxt += '<area shape="circle" coords="478,153,3" href="javascript:selectTSpoints(47017,478,153)">';
mtxt += '<area shape="circle" coords="483,153,3" href="javascript:selectTSpoints(47018,483,153)">';
mtxt += '<area shape="circle" coords="488,153,3" href="javascript:selectTSpoints(47019,488,153)">';
mtxt += '<area shape="circle" coords="493,153,3" href="javascript:selectTSpoints(47020,493,153)">';
mtxt += '<area shape="circle" coords="498,153,3" href="javascript:selectTSpoints(47021,498,153)">';
mtxt += '<area shape="circle" coords="503,153,3" href="javascript:selectTSpoints(47022,503,153)">';
mtxt += '<area shape="circle" coords="509,153,3" href="javascript:selectTSpoints(47023,509,153)">';
mtxt += '<area shape="circle" coords="514,153,3" href="javascript:selectTSpoints(47024,514,153)">';
mtxt += '<area shape="circle" coords="519,153,3" href="javascript:selectTSpoints(47025,519,153)">';
mtxt += '<area shape="circle" coords="524,153,3" href="javascript:selectTSpoints(47026,524,153)">';
mtxt += '<area shape="circle" coords="529,153,3" href="javascript:selectTSpoints(47027,529,153)">';
mtxt += '<area shape="circle" coords="534,153,3" href="javascript:selectTSpoints(47028,534,153)">';
mtxt += '<area shape="circle" coords="539,153,3" href="javascript:selectTSpoints(47029,539,153)">';
mtxt += '<area shape="circle" coords="544,153,3" href="javascript:selectTSpoints(47030,544,153)">';
mtxt += '<area shape="circle" coords="549,153,3" href="javascript:selectTSpoints(47031,549,153)">';
mtxt += '<area shape="circle" coords="554,153,3" href="javascript:selectTSpoints(47032,554,153)">';
mtxt += '<area shape="circle" coords="559,153,3" href="javascript:selectTSpoints(47033,559,153)">';
mtxt += '<area shape="circle" coords="565,153,3" href="javascript:selectTSpoints(47034,565,153)">';
mtxt += '<area shape="circle" coords="570,153,3" href="javascript:selectTSpoints(47035,570,153)">';
mtxt += '<area shape="circle" coords="575,153,3" href="javascript:selectTSpoints(47036,575,153)">';
mtxt += '<area shape="circle" coords="580,153,3" href="javascript:selectTSpoints(47037,580,153)">';
mtxt += '<area shape="circle" coords="585,153,3" href="javascript:selectTSpoints(47038,585,153)">';
mtxt += '<area shape="circle" coords="590,153,3" href="javascript:selectTSpoints(47039,590,153)">';
mtxt += '<area shape="circle" coords="595,153,3" href="javascript:selectTSpoints(47040,595,153)">';
mtxt += '<area shape="circle" coords="600,153,3" href="javascript:selectTSpoints(47041,600,153)">';
mtxt += '<area shape="circle" coords="605,153,3" href="javascript:selectTSpoints(47042,605,153)">';
mtxt += '<area shape="circle" coords="610,153,3" href="javascript:selectTSpoints(47043,610,153)">';
mtxt += '<area shape="circle" coords="615,153,3" href="javascript:selectTSpoints(47044,615,153)">';
mtxt += '<area shape="circle" coords="621,153,3" href="javascript:selectTSpoints(47045,621,153)">';
mtxt += '<area shape="circle" coords="626,153,3" href="javascript:selectTSpoints(47046,626,153)">';
mtxt += '<area shape="circle" coords="631,153,3" href="javascript:selectTSpoints(47047,631,153)">';
mtxt += '<area shape="circle" coords="636,153,3" href="javascript:selectTSpoints(47048,636,153)">';
mtxt += '<area shape="circle" coords="641,153,3" href="javascript:selectTSpoints(47049,641,153)">';
mtxt += '<area shape="circle" coords="646,153,3" href="javascript:selectTSpoints(47050,646,153)">';
mtxt += '<area shape="circle" coords="651,153,3" href="javascript:selectTSpoints(47051,651,153)">';
mtxt += '<area shape="circle" coords="656,153,3" href="javascript:selectTSpoints(47052,656,153)">';
mtxt += '<area shape="circle" coords="661,153,3" href="javascript:selectTSpoints(47053,661,153)">';
mtxt += '<area shape="circle" coords="666,153,3" href="javascript:selectTSpoints(47054,666,153)">';
mtxt += '<area shape="circle" coords="671,153,3" href="javascript:selectTSpoints(47055,671,153)">';
mtxt += '<area shape="circle" coords="677,153,3" href="javascript:selectTSpoints(47056,677,153)">';
mtxt += '<area shape="circle" coords="682,153,3" href="javascript:selectTSpoints(47057,682,153)">';
mtxt += '<area shape="circle" coords="687,153,3" href="javascript:selectTSpoints(47058,687,153)">';
mtxt += '<area shape="circle" coords="692,153,3" href="javascript:selectTSpoints(47059,692,153)">';
mtxt += '<area shape="circle" coords="697,153,3" href="javascript:selectTSpoints(47060,697,153)">';
mtxt += '<area shape="circle" coords="702,153,3" href="javascript:selectTSpoints(47061,702,153)">';
mtxt += '<area shape="circle" coords="707,153,3" href="javascript:selectTSpoints(47062,707,153)">';
mtxt += '<area shape="circle" coords="712,153,3" href="javascript:selectTSpoints(47063,712,153)">';
mtxt += '<area shape="circle" coords="717,153,3" href="javascript:selectTSpoints(47064,717,153)">';
mtxt += '<area shape="circle" coords="722,153,3" href="javascript:selectTSpoints(47065,722,153)">';
mtxt += '<area shape="circle" coords="727,153,3" href="javascript:selectTSpoints(47066,727,153)">';
mtxt += '<area shape="circle" coords="733,153,3" href="javascript:selectTSpoints(47067,733,153)">';
mtxt += '<area shape="circle" coords="738,153,3" href="javascript:selectTSpoints(47068,738,153)">';
mtxt += '<area shape="circle" coords="743,153,3" href="javascript:selectTSpoints(47069,743,153)">';
mtxt += '<area shape="circle" coords="748,153,3" href="javascript:selectTSpoints(47070,748,153)">';
mtxt += '<area shape="circle" coords="753,153,3" href="javascript:selectTSpoints(47071,753,153)">';
mtxt += '<area shape="circle" coords="758,153,3" href="javascript:selectTSpoints(47072,758,153)">';
mtxt += '<area shape="circle" coords=" 30,148,3" href="javascript:selectTSpoints(48073, 30,148)">';
mtxt += '<area shape="circle" coords=" 35,148,3" href="javascript:selectTSpoints(48074, 35,148)">';
mtxt += '<area shape="circle" coords=" 40,148,3" href="javascript:selectTSpoints(48075, 40,148)">';
mtxt += '<area shape="circle" coords=" 45,148,3" href="javascript:selectTSpoints(48076, 45,148)">';
mtxt += '<area shape="circle" coords=" 50,148,3" href="javascript:selectTSpoints(48077, 50,148)">';
mtxt += '<area shape="circle" coords=" 56,148,3" href="javascript:selectTSpoints(48078, 56,148)">';
mtxt += '<area shape="circle" coords=" 61,148,3" href="javascript:selectTSpoints(48079, 61,148)">';
mtxt += '<area shape="circle" coords=" 66,148,3" href="javascript:selectTSpoints(48080, 66,148)">';
mtxt += '<area shape="circle" coords=" 71,148,3" href="javascript:selectTSpoints(48081, 71,148)">';
mtxt += '<area shape="circle" coords=" 76,148,3" href="javascript:selectTSpoints(48082, 76,148)">';
mtxt += '<area shape="circle" coords=" 81,148,3" href="javascript:selectTSpoints(48083, 81,148)">';
mtxt += '<area shape="circle" coords=" 86,148,3" href="javascript:selectTSpoints(48084, 86,148)">';
mtxt += '<area shape="circle" coords=" 91,148,3" href="javascript:selectTSpoints(48085, 91,148)">';
mtxt += '<area shape="circle" coords=" 96,148,3" href="javascript:selectTSpoints(48086, 96,148)">';
mtxt += '<area shape="circle" coords="101,148,3" href="javascript:selectTSpoints(48087,101,148)">';
mtxt += '<area shape="circle" coords="106,148,3" href="javascript:selectTSpoints(48088,106,148)">';
mtxt += '<area shape="circle" coords="112,148,3" href="javascript:selectTSpoints(48089,112,148)">';
mtxt += '<area shape="circle" coords="117,148,3" href="javascript:selectTSpoints(48090,117,148)">';
mtxt += '<area shape="circle" coords="122,148,3" href="javascript:selectTSpoints(48091,122,148)">';
mtxt += '<area shape="circle" coords="127,148,3" href="javascript:selectTSpoints(48092,127,148)">';
mtxt += '<area shape="circle" coords="132,148,3" href="javascript:selectTSpoints(48093,132,148)">';
mtxt += '<area shape="circle" coords="137,148,3" href="javascript:selectTSpoints(48094,137,148)">';
mtxt += '<area shape="circle" coords="142,148,3" href="javascript:selectTSpoints(48095,142,148)">';
mtxt += '<area shape="circle" coords="147,148,3" href="javascript:selectTSpoints(48096,147,148)">';
mtxt += '<area shape="circle" coords="152,148,3" href="javascript:selectTSpoints(48097,152,148)">';
mtxt += '<area shape="circle" coords="157,148,3" href="javascript:selectTSpoints(48098,157,148)">';
mtxt += '<area shape="circle" coords="162,148,3" href="javascript:selectTSpoints(48099,162,148)">';
mtxt += '<area shape="circle" coords="168,148,3" href="javascript:selectTSpoints(48100,168,148)">';
mtxt += '<area shape="circle" coords="173,148,3" href="javascript:selectTSpoints(48101,173,148)">';
mtxt += '<area shape="circle" coords="178,148,3" href="javascript:selectTSpoints(48102,178,148)">';
mtxt += '<area shape="circle" coords="183,148,3" href="javascript:selectTSpoints(48103,183,148)">';
mtxt += '<area shape="circle" coords="188,148,3" href="javascript:selectTSpoints(48104,188,148)">';
mtxt += '<area shape="circle" coords="193,148,3" href="javascript:selectTSpoints(48105,193,148)">';
mtxt += '<area shape="circle" coords="198,148,3" href="javascript:selectTSpoints(48106,198,148)">';
mtxt += '<area shape="circle" coords="203,148,3" href="javascript:selectTSpoints(48107,203,148)">';
mtxt += '<area shape="circle" coords="208,148,3" href="javascript:selectTSpoints(48108,208,148)">';
mtxt += '<area shape="circle" coords="213,148,3" href="javascript:selectTSpoints(48109,213,148)">';
mtxt += '<area shape="circle" coords="218,148,3" href="javascript:selectTSpoints(48110,218,148)">';
mtxt += '<area shape="circle" coords="224,148,3" href="javascript:selectTSpoints(48111,224,148)">';
mtxt += '<area shape="circle" coords="229,148,3" href="javascript:selectTSpoints(48112,229,148)">';
mtxt += '<area shape="circle" coords="234,148,3" href="javascript:selectTSpoints(48113,234,148)">';
mtxt += '<area shape="circle" coords="239,148,3" href="javascript:selectTSpoints(48114,239,148)">';
mtxt += '<area shape="circle" coords="244,148,3" href="javascript:selectTSpoints(48115,244,148)">';
mtxt += '<area shape="circle" coords="249,148,3" href="javascript:selectTSpoints(48116,249,148)">';
mtxt += '<area shape="circle" coords="254,148,3" href="javascript:selectTSpoints(48117,254,148)">';
mtxt += '<area shape="circle" coords="259,148,3" href="javascript:selectTSpoints(48118,259,148)">';
mtxt += '<area shape="circle" coords="264,148,3" href="javascript:selectTSpoints(48119,264,148)">';
mtxt += '<area shape="circle" coords="269,148,3" href="javascript:selectTSpoints(48120,269,148)">';
mtxt += '<area shape="circle" coords="274,148,3" href="javascript:selectTSpoints(48121,274,148)">';
mtxt += '<area shape="circle" coords="280,148,3" href="javascript:selectTSpoints(48122,280,148)">';
mtxt += '<area shape="circle" coords="285,148,3" href="javascript:selectTSpoints(48123,285,148)">';
mtxt += '<area shape="circle" coords="290,148,3" href="javascript:selectTSpoints(48124,290,148)">';
mtxt += '<area shape="circle" coords="295,148,3" href="javascript:selectTSpoints(48125,295,148)">';
mtxt += '<area shape="circle" coords="300,148,3" href="javascript:selectTSpoints(48126,300,148)">';
mtxt += '<area shape="circle" coords="305,148,3" href="javascript:selectTSpoints(48127,305,148)">';
mtxt += '<area shape="circle" coords="310,148,3" href="javascript:selectTSpoints(48128,310,148)">';
mtxt += '<area shape="circle" coords="315,148,3" href="javascript:selectTSpoints(48129,315,148)">';
mtxt += '<area shape="circle" coords="320,148,3" href="javascript:selectTSpoints(48130,320,148)">';
mtxt += '<area shape="circle" coords="325,148,3" href="javascript:selectTSpoints(48131,325,148)">';
mtxt += '<area shape="circle" coords="330,148,3" href="javascript:selectTSpoints(48132,330,148)">';
mtxt += '<area shape="circle" coords="336,148,3" href="javascript:selectTSpoints(48133,336,148)">';
mtxt += '<area shape="circle" coords="341,148,3" href="javascript:selectTSpoints(48134,341,148)">';
mtxt += '<area shape="circle" coords="346,148,3" href="javascript:selectTSpoints(48135,346,148)">';
mtxt += '<area shape="circle" coords="351,148,3" href="javascript:selectTSpoints(48136,351,148)">';
mtxt += '<area shape="circle" coords="356,148,3" href="javascript:selectTSpoints(48137,356,148)">';
mtxt += '<area shape="circle" coords="361,148,3" href="javascript:selectTSpoints(48138,361,148)">';
mtxt += '<area shape="circle" coords="366,148,3" href="javascript:selectTSpoints(48139,366,148)">';
mtxt += '<area shape="circle" coords="371,148,3" href="javascript:selectTSpoints(48140,371,148)">';
mtxt += '<area shape="circle" coords="376,148,3" href="javascript:selectTSpoints(48141,376,148)">';
mtxt += '<area shape="circle" coords="381,148,3" href="javascript:selectTSpoints(48142,381,148)">';
mtxt += '<area shape="circle" coords="386,148,3" href="javascript:selectTSpoints(48143,386,148)">';
mtxt += '<area shape="circle" coords="392,148,3" href="javascript:selectTSpoints(48144,392,148)">';
mtxt += '<area shape="circle" coords="397,148,3" href="javascript:selectTSpoints(48001,397,148)">';
mtxt += '<area shape="circle" coords="402,148,3" href="javascript:selectTSpoints(48002,402,148)">';
mtxt += '<area shape="circle" coords="407,148,3" href="javascript:selectTSpoints(48003,407,148)">';
mtxt += '<area shape="circle" coords="412,148,3" href="javascript:selectTSpoints(48004,412,148)">';
mtxt += '<area shape="circle" coords="417,148,3" href="javascript:selectTSpoints(48005,417,148)">';
mtxt += '<area shape="circle" coords="422,148,3" href="javascript:selectTSpoints(48006,422,148)">';
mtxt += '<area shape="circle" coords="427,148,3" href="javascript:selectTSpoints(48007,427,148)">';
mtxt += '<area shape="circle" coords="432,148,3" href="javascript:selectTSpoints(48008,432,148)">';
mtxt += '<area shape="circle" coords="437,148,3" href="javascript:selectTSpoints(48009,437,148)">';
mtxt += '<area shape="circle" coords="442,148,3" href="javascript:selectTSpoints(48010,442,148)">';
mtxt += '<area shape="circle" coords="447,148,3" href="javascript:selectTSpoints(48011,447,148)">';
mtxt += '<area shape="circle" coords="453,148,3" href="javascript:selectTSpoints(48012,453,148)">';
mtxt += '<area shape="circle" coords="458,148,3" href="javascript:selectTSpoints(48013,458,148)">';
mtxt += '<area shape="circle" coords="463,148,3" href="javascript:selectTSpoints(48014,463,148)">';
mtxt += '<area shape="circle" coords="468,148,3" href="javascript:selectTSpoints(48015,468,148)">';
mtxt += '<area shape="circle" coords="473,148,3" href="javascript:selectTSpoints(48016,473,148)">';
mtxt += '<area shape="circle" coords="478,148,3" href="javascript:selectTSpoints(48017,478,148)">';
mtxt += '<area shape="circle" coords="483,148,3" href="javascript:selectTSpoints(48018,483,148)">';
mtxt += '<area shape="circle" coords="488,148,3" href="javascript:selectTSpoints(48019,488,148)">';
mtxt += '<area shape="circle" coords="493,148,3" href="javascript:selectTSpoints(48020,493,148)">';
mtxt += '<area shape="circle" coords="498,148,3" href="javascript:selectTSpoints(48021,498,148)">';
mtxt += '<area shape="circle" coords="503,148,3" href="javascript:selectTSpoints(48022,503,148)">';
mtxt += '<area shape="circle" coords="509,148,3" href="javascript:selectTSpoints(48023,509,148)">';
mtxt += '<area shape="circle" coords="514,148,3" href="javascript:selectTSpoints(48024,514,148)">';
mtxt += '<area shape="circle" coords="519,148,3" href="javascript:selectTSpoints(48025,519,148)">';
mtxt += '<area shape="circle" coords="524,148,3" href="javascript:selectTSpoints(48026,524,148)">';
mtxt += '<area shape="circle" coords="529,148,3" href="javascript:selectTSpoints(48027,529,148)">';
mtxt += '<area shape="circle" coords="534,148,3" href="javascript:selectTSpoints(48028,534,148)">';
mtxt += '<area shape="circle" coords="539,148,3" href="javascript:selectTSpoints(48029,539,148)">';
mtxt += '<area shape="circle" coords="544,148,3" href="javascript:selectTSpoints(48030,544,148)">';
mtxt += '<area shape="circle" coords="549,148,3" href="javascript:selectTSpoints(48031,549,148)">';
mtxt += '<area shape="circle" coords="554,148,3" href="javascript:selectTSpoints(48032,554,148)">';
mtxt += '<area shape="circle" coords="559,148,3" href="javascript:selectTSpoints(48033,559,148)">';
mtxt += '<area shape="circle" coords="565,148,3" href="javascript:selectTSpoints(48034,565,148)">';
mtxt += '<area shape="circle" coords="570,148,3" href="javascript:selectTSpoints(48035,570,148)">';
mtxt += '<area shape="circle" coords="575,148,3" href="javascript:selectTSpoints(48036,575,148)">';
mtxt += '<area shape="circle" coords="580,148,3" href="javascript:selectTSpoints(48037,580,148)">';
mtxt += '<area shape="circle" coords="585,148,3" href="javascript:selectTSpoints(48038,585,148)">';
mtxt += '<area shape="circle" coords="590,148,3" href="javascript:selectTSpoints(48039,590,148)">';
mtxt += '<area shape="circle" coords="595,148,3" href="javascript:selectTSpoints(48040,595,148)">';
mtxt += '<area shape="circle" coords="600,148,3" href="javascript:selectTSpoints(48041,600,148)">';
mtxt += '<area shape="circle" coords="605,148,3" href="javascript:selectTSpoints(48042,605,148)">';
mtxt += '<area shape="circle" coords="610,148,3" href="javascript:selectTSpoints(48043,610,148)">';
mtxt += '<area shape="circle" coords="615,148,3" href="javascript:selectTSpoints(48044,615,148)">';
mtxt += '<area shape="circle" coords="621,148,3" href="javascript:selectTSpoints(48045,621,148)">';
mtxt += '<area shape="circle" coords="626,148,3" href="javascript:selectTSpoints(48046,626,148)">';
mtxt += '<area shape="circle" coords="631,148,3" href="javascript:selectTSpoints(48047,631,148)">';
mtxt += '<area shape="circle" coords="636,148,3" href="javascript:selectTSpoints(48048,636,148)">';
mtxt += '<area shape="circle" coords="641,148,3" href="javascript:selectTSpoints(48049,641,148)">';
mtxt += '<area shape="circle" coords="646,148,3" href="javascript:selectTSpoints(48050,646,148)">';
mtxt += '<area shape="circle" coords="651,148,3" href="javascript:selectTSpoints(48051,651,148)">';
mtxt += '<area shape="circle" coords="656,148,3" href="javascript:selectTSpoints(48052,656,148)">';
mtxt += '<area shape="circle" coords="661,148,3" href="javascript:selectTSpoints(48053,661,148)">';
mtxt += '<area shape="circle" coords="666,148,3" href="javascript:selectTSpoints(48054,666,148)">';
mtxt += '<area shape="circle" coords="671,148,3" href="javascript:selectTSpoints(48055,671,148)">';
mtxt += '<area shape="circle" coords="677,148,3" href="javascript:selectTSpoints(48056,677,148)">';
mtxt += '<area shape="circle" coords="682,148,3" href="javascript:selectTSpoints(48057,682,148)">';
mtxt += '<area shape="circle" coords="687,148,3" href="javascript:selectTSpoints(48058,687,148)">';
mtxt += '<area shape="circle" coords="692,148,3" href="javascript:selectTSpoints(48059,692,148)">';
mtxt += '<area shape="circle" coords="697,148,3" href="javascript:selectTSpoints(48060,697,148)">';
mtxt += '<area shape="circle" coords="702,148,3" href="javascript:selectTSpoints(48061,702,148)">';
mtxt += '<area shape="circle" coords="707,148,3" href="javascript:selectTSpoints(48062,707,148)">';
mtxt += '<area shape="circle" coords="712,148,3" href="javascript:selectTSpoints(48063,712,148)">';
mtxt += '<area shape="circle" coords="717,148,3" href="javascript:selectTSpoints(48064,717,148)">';
mtxt += '<area shape="circle" coords="722,148,3" href="javascript:selectTSpoints(48065,722,148)">';
mtxt += '<area shape="circle" coords="727,148,3" href="javascript:selectTSpoints(48066,727,148)">';
mtxt += '<area shape="circle" coords="733,148,3" href="javascript:selectTSpoints(48067,733,148)">';
mtxt += '<area shape="circle" coords="738,148,3" href="javascript:selectTSpoints(48068,738,148)">';
mtxt += '<area shape="circle" coords="743,148,3" href="javascript:selectTSpoints(48069,743,148)">';
mtxt += '<area shape="circle" coords="748,148,3" href="javascript:selectTSpoints(48070,748,148)">';
mtxt += '<area shape="circle" coords="753,148,3" href="javascript:selectTSpoints(48071,753,148)">';
mtxt += '<area shape="circle" coords="758,148,3" href="javascript:selectTSpoints(48072,758,148)">';
mtxt += '<area shape="circle" coords=" 30,143,3" href="javascript:selectTSpoints(49073, 30,143)">';
mtxt += '<area shape="circle" coords=" 35,143,3" href="javascript:selectTSpoints(49074, 35,143)">';
mtxt += '<area shape="circle" coords=" 40,143,3" href="javascript:selectTSpoints(49075, 40,143)">';
mtxt += '<area shape="circle" coords=" 45,143,3" href="javascript:selectTSpoints(49076, 45,143)">';
mtxt += '<area shape="circle" coords=" 50,143,3" href="javascript:selectTSpoints(49077, 50,143)">';
mtxt += '<area shape="circle" coords=" 56,143,3" href="javascript:selectTSpoints(49078, 56,143)">';
mtxt += '<area shape="circle" coords=" 61,143,3" href="javascript:selectTSpoints(49079, 61,143)">';
mtxt += '<area shape="circle" coords=" 66,143,3" href="javascript:selectTSpoints(49080, 66,143)">';
mtxt += '<area shape="circle" coords=" 71,143,3" href="javascript:selectTSpoints(49081, 71,143)">';
mtxt += '<area shape="circle" coords=" 76,143,3" href="javascript:selectTSpoints(49082, 76,143)">';
mtxt += '<area shape="circle" coords=" 81,143,3" href="javascript:selectTSpoints(49083, 81,143)">';
mtxt += '<area shape="circle" coords=" 86,143,3" href="javascript:selectTSpoints(49084, 86,143)">';
mtxt += '<area shape="circle" coords=" 91,143,3" href="javascript:selectTSpoints(49085, 91,143)">';
mtxt += '<area shape="circle" coords=" 96,143,3" href="javascript:selectTSpoints(49086, 96,143)">';
mtxt += '<area shape="circle" coords="101,143,3" href="javascript:selectTSpoints(49087,101,143)">';
mtxt += '<area shape="circle" coords="106,143,3" href="javascript:selectTSpoints(49088,106,143)">';
mtxt += '<area shape="circle" coords="112,143,3" href="javascript:selectTSpoints(49089,112,143)">';
mtxt += '<area shape="circle" coords="117,143,3" href="javascript:selectTSpoints(49090,117,143)">';
mtxt += '<area shape="circle" coords="122,143,3" href="javascript:selectTSpoints(49091,122,143)">';
mtxt += '<area shape="circle" coords="127,143,3" href="javascript:selectTSpoints(49092,127,143)">';
mtxt += '<area shape="circle" coords="132,143,3" href="javascript:selectTSpoints(49093,132,143)">';
mtxt += '<area shape="circle" coords="137,143,3" href="javascript:selectTSpoints(49094,137,143)">';
mtxt += '<area shape="circle" coords="142,143,3" href="javascript:selectTSpoints(49095,142,143)">';
mtxt += '<area shape="circle" coords="147,143,3" href="javascript:selectTSpoints(49096,147,143)">';
mtxt += '<area shape="circle" coords="152,143,3" href="javascript:selectTSpoints(49097,152,143)">';
mtxt += '<area shape="circle" coords="157,143,3" href="javascript:selectTSpoints(49098,157,143)">';
mtxt += '<area shape="circle" coords="162,143,3" href="javascript:selectTSpoints(49099,162,143)">';
mtxt += '<area shape="circle" coords="168,143,3" href="javascript:selectTSpoints(49100,168,143)">';
mtxt += '<area shape="circle" coords="173,143,3" href="javascript:selectTSpoints(49101,173,143)">';
mtxt += '<area shape="circle" coords="178,143,3" href="javascript:selectTSpoints(49102,178,143)">';
mtxt += '<area shape="circle" coords="183,143,3" href="javascript:selectTSpoints(49103,183,143)">';
mtxt += '<area shape="circle" coords="188,143,3" href="javascript:selectTSpoints(49104,188,143)">';
mtxt += '<area shape="circle" coords="193,143,3" href="javascript:selectTSpoints(49105,193,143)">';
mtxt += '<area shape="circle" coords="198,143,3" href="javascript:selectTSpoints(49106,198,143)">';
mtxt += '<area shape="circle" coords="203,143,3" href="javascript:selectTSpoints(49107,203,143)">';
mtxt += '<area shape="circle" coords="208,143,3" href="javascript:selectTSpoints(49108,208,143)">';
mtxt += '<area shape="circle" coords="213,143,3" href="javascript:selectTSpoints(49109,213,143)">';
mtxt += '<area shape="circle" coords="218,143,3" href="javascript:selectTSpoints(49110,218,143)">';
mtxt += '<area shape="circle" coords="224,143,3" href="javascript:selectTSpoints(49111,224,143)">';
mtxt += '<area shape="circle" coords="229,143,3" href="javascript:selectTSpoints(49112,229,143)">';
mtxt += '<area shape="circle" coords="234,143,3" href="javascript:selectTSpoints(49113,234,143)">';
mtxt += '<area shape="circle" coords="239,143,3" href="javascript:selectTSpoints(49114,239,143)">';
mtxt += '<area shape="circle" coords="244,143,3" href="javascript:selectTSpoints(49115,244,143)">';
mtxt += '<area shape="circle" coords="249,143,3" href="javascript:selectTSpoints(49116,249,143)">';
mtxt += '<area shape="circle" coords="254,143,3" href="javascript:selectTSpoints(49117,254,143)">';
mtxt += '<area shape="circle" coords="259,143,3" href="javascript:selectTSpoints(49118,259,143)">';
mtxt += '<area shape="circle" coords="264,143,3" href="javascript:selectTSpoints(49119,264,143)">';
mtxt += '<area shape="circle" coords="269,143,3" href="javascript:selectTSpoints(49120,269,143)">';
mtxt += '<area shape="circle" coords="274,143,3" href="javascript:selectTSpoints(49121,274,143)">';
mtxt += '<area shape="circle" coords="280,143,3" href="javascript:selectTSpoints(49122,280,143)">';
mtxt += '<area shape="circle" coords="285,143,3" href="javascript:selectTSpoints(49123,285,143)">';
mtxt += '<area shape="circle" coords="290,143,3" href="javascript:selectTSpoints(49124,290,143)">';
mtxt += '<area shape="circle" coords="295,143,3" href="javascript:selectTSpoints(49125,295,143)">';
mtxt += '<area shape="circle" coords="300,143,3" href="javascript:selectTSpoints(49126,300,143)">';
mtxt += '<area shape="circle" coords="305,143,3" href="javascript:selectTSpoints(49127,305,143)">';
mtxt += '<area shape="circle" coords="310,143,3" href="javascript:selectTSpoints(49128,310,143)">';
mtxt += '<area shape="circle" coords="315,143,3" href="javascript:selectTSpoints(49129,315,143)">';
mtxt += '<area shape="circle" coords="320,143,3" href="javascript:selectTSpoints(49130,320,143)">';
mtxt += '<area shape="circle" coords="325,143,3" href="javascript:selectTSpoints(49131,325,143)">';
mtxt += '<area shape="circle" coords="330,143,3" href="javascript:selectTSpoints(49132,330,143)">';
mtxt += '<area shape="circle" coords="336,143,3" href="javascript:selectTSpoints(49133,336,143)">';
mtxt += '<area shape="circle" coords="341,143,3" href="javascript:selectTSpoints(49134,341,143)">';
mtxt += '<area shape="circle" coords="346,143,3" href="javascript:selectTSpoints(49135,346,143)">';
mtxt += '<area shape="circle" coords="351,143,3" href="javascript:selectTSpoints(49136,351,143)">';
mtxt += '<area shape="circle" coords="356,143,3" href="javascript:selectTSpoints(49137,356,143)">';
mtxt += '<area shape="circle" coords="361,143,3" href="javascript:selectTSpoints(49138,361,143)">';
mtxt += '<area shape="circle" coords="366,143,3" href="javascript:selectTSpoints(49139,366,143)">';
mtxt += '<area shape="circle" coords="371,143,3" href="javascript:selectTSpoints(49140,371,143)">';
mtxt += '<area shape="circle" coords="376,143,3" href="javascript:selectTSpoints(49141,376,143)">';
mtxt += '<area shape="circle" coords="381,143,3" href="javascript:selectTSpoints(49142,381,143)">';
mtxt += '<area shape="circle" coords="386,143,3" href="javascript:selectTSpoints(49143,386,143)">';
mtxt += '<area shape="circle" coords="392,143,3" href="javascript:selectTSpoints(49144,392,143)">';
mtxt += '<area shape="circle" coords="397,143,3" href="javascript:selectTSpoints(49001,397,143)">';
mtxt += '<area shape="circle" coords="402,143,3" href="javascript:selectTSpoints(49002,402,143)">';
mtxt += '<area shape="circle" coords="407,143,3" href="javascript:selectTSpoints(49003,407,143)">';
mtxt += '<area shape="circle" coords="412,143,3" href="javascript:selectTSpoints(49004,412,143)">';
mtxt += '<area shape="circle" coords="417,143,3" href="javascript:selectTSpoints(49005,417,143)">';
mtxt += '<area shape="circle" coords="422,143,3" href="javascript:selectTSpoints(49006,422,143)">';
mtxt += '<area shape="circle" coords="427,143,3" href="javascript:selectTSpoints(49007,427,143)">';
mtxt += '<area shape="circle" coords="432,143,3" href="javascript:selectTSpoints(49008,432,143)">';
mtxt += '<area shape="circle" coords="437,143,3" href="javascript:selectTSpoints(49009,437,143)">';
mtxt += '<area shape="circle" coords="442,143,3" href="javascript:selectTSpoints(49010,442,143)">';
mtxt += '<area shape="circle" coords="447,143,3" href="javascript:selectTSpoints(49011,447,143)">';
mtxt += '<area shape="circle" coords="453,143,3" href="javascript:selectTSpoints(49012,453,143)">';
mtxt += '<area shape="circle" coords="458,143,3" href="javascript:selectTSpoints(49013,458,143)">';
mtxt += '<area shape="circle" coords="463,143,3" href="javascript:selectTSpoints(49014,463,143)">';
mtxt += '<area shape="circle" coords="468,143,3" href="javascript:selectTSpoints(49015,468,143)">';
mtxt += '<area shape="circle" coords="473,143,3" href="javascript:selectTSpoints(49016,473,143)">';
mtxt += '<area shape="circle" coords="478,143,3" href="javascript:selectTSpoints(49017,478,143)">';
mtxt += '<area shape="circle" coords="483,143,3" href="javascript:selectTSpoints(49018,483,143)">';
mtxt += '<area shape="circle" coords="488,143,3" href="javascript:selectTSpoints(49019,488,143)">';
mtxt += '<area shape="circle" coords="493,143,3" href="javascript:selectTSpoints(49020,493,143)">';
mtxt += '<area shape="circle" coords="498,143,3" href="javascript:selectTSpoints(49021,498,143)">';
mtxt += '<area shape="circle" coords="503,143,3" href="javascript:selectTSpoints(49022,503,143)">';
mtxt += '<area shape="circle" coords="509,143,3" href="javascript:selectTSpoints(49023,509,143)">';
mtxt += '<area shape="circle" coords="514,143,3" href="javascript:selectTSpoints(49024,514,143)">';
mtxt += '<area shape="circle" coords="519,143,3" href="javascript:selectTSpoints(49025,519,143)">';
mtxt += '<area shape="circle" coords="524,143,3" href="javascript:selectTSpoints(49026,524,143)">';
mtxt += '<area shape="circle" coords="529,143,3" href="javascript:selectTSpoints(49027,529,143)">';
mtxt += '<area shape="circle" coords="534,143,3" href="javascript:selectTSpoints(49028,534,143)">';
mtxt += '<area shape="circle" coords="539,143,3" href="javascript:selectTSpoints(49029,539,143)">';
mtxt += '<area shape="circle" coords="544,143,3" href="javascript:selectTSpoints(49030,544,143)">';
mtxt += '<area shape="circle" coords="549,143,3" href="javascript:selectTSpoints(49031,549,143)">';
mtxt += '<area shape="circle" coords="554,143,3" href="javascript:selectTSpoints(49032,554,143)">';
mtxt += '<area shape="circle" coords="559,143,3" href="javascript:selectTSpoints(49033,559,143)">';
mtxt += '<area shape="circle" coords="565,143,3" href="javascript:selectTSpoints(49034,565,143)">';
mtxt += '<area shape="circle" coords="570,143,3" href="javascript:selectTSpoints(49035,570,143)">';
mtxt += '<area shape="circle" coords="575,143,3" href="javascript:selectTSpoints(49036,575,143)">';
mtxt += '<area shape="circle" coords="580,143,3" href="javascript:selectTSpoints(49037,580,143)">';
mtxt += '<area shape="circle" coords="585,143,3" href="javascript:selectTSpoints(49038,585,143)">';
mtxt += '<area shape="circle" coords="590,143,3" href="javascript:selectTSpoints(49039,590,143)">';
mtxt += '<area shape="circle" coords="595,143,3" href="javascript:selectTSpoints(49040,595,143)">';
mtxt += '<area shape="circle" coords="600,143,3" href="javascript:selectTSpoints(49041,600,143)">';
mtxt += '<area shape="circle" coords="605,143,3" href="javascript:selectTSpoints(49042,605,143)">';
mtxt += '<area shape="circle" coords="610,143,3" href="javascript:selectTSpoints(49043,610,143)">';
mtxt += '<area shape="circle" coords="615,143,3" href="javascript:selectTSpoints(49044,615,143)">';
mtxt += '<area shape="circle" coords="621,143,3" href="javascript:selectTSpoints(49045,621,143)">';
mtxt += '<area shape="circle" coords="626,143,3" href="javascript:selectTSpoints(49046,626,143)">';
mtxt += '<area shape="circle" coords="631,143,3" href="javascript:selectTSpoints(49047,631,143)">';
mtxt += '<area shape="circle" coords="636,143,3" href="javascript:selectTSpoints(49048,636,143)">';
mtxt += '<area shape="circle" coords="641,143,3" href="javascript:selectTSpoints(49049,641,143)">';
mtxt += '<area shape="circle" coords="646,143,3" href="javascript:selectTSpoints(49050,646,143)">';
mtxt += '<area shape="circle" coords="651,143,3" href="javascript:selectTSpoints(49051,651,143)">';
mtxt += '<area shape="circle" coords="656,143,3" href="javascript:selectTSpoints(49052,656,143)">';
mtxt += '<area shape="circle" coords="661,143,3" href="javascript:selectTSpoints(49053,661,143)">';
mtxt += '<area shape="circle" coords="666,143,3" href="javascript:selectTSpoints(49054,666,143)">';
mtxt += '<area shape="circle" coords="671,143,3" href="javascript:selectTSpoints(49055,671,143)">';
mtxt += '<area shape="circle" coords="677,143,3" href="javascript:selectTSpoints(49056,677,143)">';
mtxt += '<area shape="circle" coords="682,143,3" href="javascript:selectTSpoints(49057,682,143)">';
mtxt += '<area shape="circle" coords="687,143,3" href="javascript:selectTSpoints(49058,687,143)">';
mtxt += '<area shape="circle" coords="692,143,3" href="javascript:selectTSpoints(49059,692,143)">';
mtxt += '<area shape="circle" coords="697,143,3" href="javascript:selectTSpoints(49060,697,143)">';
mtxt += '<area shape="circle" coords="702,143,3" href="javascript:selectTSpoints(49061,702,143)">';
mtxt += '<area shape="circle" coords="707,143,3" href="javascript:selectTSpoints(49062,707,143)">';
mtxt += '<area shape="circle" coords="712,143,3" href="javascript:selectTSpoints(49063,712,143)">';
mtxt += '<area shape="circle" coords="717,143,3" href="javascript:selectTSpoints(49064,717,143)">';
mtxt += '<area shape="circle" coords="722,143,3" href="javascript:selectTSpoints(49065,722,143)">';
mtxt += '<area shape="circle" coords="727,143,3" href="javascript:selectTSpoints(49066,727,143)">';
mtxt += '<area shape="circle" coords="733,143,3" href="javascript:selectTSpoints(49067,733,143)">';
mtxt += '<area shape="circle" coords="738,143,3" href="javascript:selectTSpoints(49068,738,143)">';
mtxt += '<area shape="circle" coords="743,143,3" href="javascript:selectTSpoints(49069,743,143)">';
mtxt += '<area shape="circle" coords="748,143,3" href="javascript:selectTSpoints(49070,748,143)">';
mtxt += '<area shape="circle" coords="753,143,3" href="javascript:selectTSpoints(49071,753,143)">';
mtxt += '<area shape="circle" coords="758,143,3" href="javascript:selectTSpoints(49072,758,143)">';
mtxt += '<area shape="circle" coords=" 30,138,3" href="javascript:selectTSpoints(50073, 30,138)">';
mtxt += '<area shape="circle" coords=" 35,138,3" href="javascript:selectTSpoints(50074, 35,138)">';
mtxt += '<area shape="circle" coords=" 40,138,3" href="javascript:selectTSpoints(50075, 40,138)">';
mtxt += '<area shape="circle" coords=" 45,138,3" href="javascript:selectTSpoints(50076, 45,138)">';
mtxt += '<area shape="circle" coords=" 50,138,3" href="javascript:selectTSpoints(50077, 50,138)">';
mtxt += '<area shape="circle" coords=" 56,138,3" href="javascript:selectTSpoints(50078, 56,138)">';
mtxt += '<area shape="circle" coords=" 61,138,3" href="javascript:selectTSpoints(50079, 61,138)">';
mtxt += '<area shape="circle" coords=" 66,138,3" href="javascript:selectTSpoints(50080, 66,138)">';
mtxt += '<area shape="circle" coords=" 71,138,3" href="javascript:selectTSpoints(50081, 71,138)">';
mtxt += '<area shape="circle" coords=" 76,138,3" href="javascript:selectTSpoints(50082, 76,138)">';
mtxt += '<area shape="circle" coords=" 81,138,3" href="javascript:selectTSpoints(50083, 81,138)">';
mtxt += '<area shape="circle" coords=" 86,138,3" href="javascript:selectTSpoints(50084, 86,138)">';
mtxt += '<area shape="circle" coords=" 91,138,3" href="javascript:selectTSpoints(50085, 91,138)">';
mtxt += '<area shape="circle" coords=" 96,138,3" href="javascript:selectTSpoints(50086, 96,138)">';
mtxt += '<area shape="circle" coords="101,138,3" href="javascript:selectTSpoints(50087,101,138)">';
mtxt += '<area shape="circle" coords="106,138,3" href="javascript:selectTSpoints(50088,106,138)">';
mtxt += '<area shape="circle" coords="112,138,3" href="javascript:selectTSpoints(50089,112,138)">';
mtxt += '<area shape="circle" coords="117,138,3" href="javascript:selectTSpoints(50090,117,138)">';
mtxt += '<area shape="circle" coords="122,138,3" href="javascript:selectTSpoints(50091,122,138)">';
mtxt += '<area shape="circle" coords="127,138,3" href="javascript:selectTSpoints(50092,127,138)">';
mtxt += '<area shape="circle" coords="132,138,3" href="javascript:selectTSpoints(50093,132,138)">';
mtxt += '<area shape="circle" coords="137,138,3" href="javascript:selectTSpoints(50094,137,138)">';
mtxt += '<area shape="circle" coords="142,138,3" href="javascript:selectTSpoints(50095,142,138)">';
mtxt += '<area shape="circle" coords="147,138,3" href="javascript:selectTSpoints(50096,147,138)">';
mtxt += '<area shape="circle" coords="152,138,3" href="javascript:selectTSpoints(50097,152,138)">';
mtxt += '<area shape="circle" coords="157,138,3" href="javascript:selectTSpoints(50098,157,138)">';
mtxt += '<area shape="circle" coords="162,138,3" href="javascript:selectTSpoints(50099,162,138)">';
mtxt += '<area shape="circle" coords="168,138,3" href="javascript:selectTSpoints(50100,168,138)">';
mtxt += '<area shape="circle" coords="173,138,3" href="javascript:selectTSpoints(50101,173,138)">';
mtxt += '<area shape="circle" coords="178,138,3" href="javascript:selectTSpoints(50102,178,138)">';
mtxt += '<area shape="circle" coords="183,138,3" href="javascript:selectTSpoints(50103,183,138)">';
mtxt += '<area shape="circle" coords="188,138,3" href="javascript:selectTSpoints(50104,188,138)">';
mtxt += '<area shape="circle" coords="193,138,3" href="javascript:selectTSpoints(50105,193,138)">';
mtxt += '<area shape="circle" coords="198,138,3" href="javascript:selectTSpoints(50106,198,138)">';
mtxt += '<area shape="circle" coords="203,138,3" href="javascript:selectTSpoints(50107,203,138)">';
mtxt += '<area shape="circle" coords="208,138,3" href="javascript:selectTSpoints(50108,208,138)">';
mtxt += '<area shape="circle" coords="213,138,3" href="javascript:selectTSpoints(50109,213,138)">';
mtxt += '<area shape="circle" coords="218,138,3" href="javascript:selectTSpoints(50110,218,138)">';
mtxt += '<area shape="circle" coords="224,138,3" href="javascript:selectTSpoints(50111,224,138)">';
mtxt += '<area shape="circle" coords="229,138,3" href="javascript:selectTSpoints(50112,229,138)">';
mtxt += '<area shape="circle" coords="234,138,3" href="javascript:selectTSpoints(50113,234,138)">';
mtxt += '<area shape="circle" coords="239,138,3" href="javascript:selectTSpoints(50114,239,138)">';
mtxt += '<area shape="circle" coords="244,138,3" href="javascript:selectTSpoints(50115,244,138)">';
mtxt += '<area shape="circle" coords="249,138,3" href="javascript:selectTSpoints(50116,249,138)">';
mtxt += '<area shape="circle" coords="254,138,3" href="javascript:selectTSpoints(50117,254,138)">';
mtxt += '<area shape="circle" coords="259,138,3" href="javascript:selectTSpoints(50118,259,138)">';
mtxt += '<area shape="circle" coords="264,138,3" href="javascript:selectTSpoints(50119,264,138)">';
mtxt += '<area shape="circle" coords="269,138,3" href="javascript:selectTSpoints(50120,269,138)">';
mtxt += '<area shape="circle" coords="274,138,3" href="javascript:selectTSpoints(50121,274,138)">';
mtxt += '<area shape="circle" coords="280,138,3" href="javascript:selectTSpoints(50122,280,138)">';
mtxt += '<area shape="circle" coords="285,138,3" href="javascript:selectTSpoints(50123,285,138)">';
mtxt += '<area shape="circle" coords="290,138,3" href="javascript:selectTSpoints(50124,290,138)">';
mtxt += '<area shape="circle" coords="295,138,3" href="javascript:selectTSpoints(50125,295,138)">';
mtxt += '<area shape="circle" coords="300,138,3" href="javascript:selectTSpoints(50126,300,138)">';
mtxt += '<area shape="circle" coords="305,138,3" href="javascript:selectTSpoints(50127,305,138)">';
mtxt += '<area shape="circle" coords="310,138,3" href="javascript:selectTSpoints(50128,310,138)">';
mtxt += '<area shape="circle" coords="315,138,3" href="javascript:selectTSpoints(50129,315,138)">';
mtxt += '<area shape="circle" coords="320,138,3" href="javascript:selectTSpoints(50130,320,138)">';
mtxt += '<area shape="circle" coords="325,138,3" href="javascript:selectTSpoints(50131,325,138)">';
mtxt += '<area shape="circle" coords="330,138,3" href="javascript:selectTSpoints(50132,330,138)">';
mtxt += '<area shape="circle" coords="336,138,3" href="javascript:selectTSpoints(50133,336,138)">';
mtxt += '<area shape="circle" coords="341,138,3" href="javascript:selectTSpoints(50134,341,138)">';
mtxt += '<area shape="circle" coords="346,138,3" href="javascript:selectTSpoints(50135,346,138)">';
mtxt += '<area shape="circle" coords="351,138,3" href="javascript:selectTSpoints(50136,351,138)">';
mtxt += '<area shape="circle" coords="356,138,3" href="javascript:selectTSpoints(50137,356,138)">';
mtxt += '<area shape="circle" coords="361,138,3" href="javascript:selectTSpoints(50138,361,138)">';
mtxt += '<area shape="circle" coords="366,138,3" href="javascript:selectTSpoints(50139,366,138)">';
mtxt += '<area shape="circle" coords="371,138,3" href="javascript:selectTSpoints(50140,371,138)">';
mtxt += '<area shape="circle" coords="376,138,3" href="javascript:selectTSpoints(50141,376,138)">';
mtxt += '<area shape="circle" coords="381,138,3" href="javascript:selectTSpoints(50142,381,138)">';
mtxt += '<area shape="circle" coords="386,138,3" href="javascript:selectTSpoints(50143,386,138)">';
mtxt += '<area shape="circle" coords="392,138,3" href="javascript:selectTSpoints(50144,392,138)">';
mtxt += '<area shape="circle" coords="397,138,3" href="javascript:selectTSpoints(50001,397,138)">';
mtxt += '<area shape="circle" coords="402,138,3" href="javascript:selectTSpoints(50002,402,138)">';
mtxt += '<area shape="circle" coords="407,138,3" href="javascript:selectTSpoints(50003,407,138)">';
mtxt += '<area shape="circle" coords="412,138,3" href="javascript:selectTSpoints(50004,412,138)">';
mtxt += '<area shape="circle" coords="417,138,3" href="javascript:selectTSpoints(50005,417,138)">';
mtxt += '<area shape="circle" coords="422,138,3" href="javascript:selectTSpoints(50006,422,138)">';
mtxt += '<area shape="circle" coords="427,138,3" href="javascript:selectTSpoints(50007,427,138)">';
mtxt += '<area shape="circle" coords="432,138,3" href="javascript:selectTSpoints(50008,432,138)">';
mtxt += '<area shape="circle" coords="437,138,3" href="javascript:selectTSpoints(50009,437,138)">';
mtxt += '<area shape="circle" coords="442,138,3" href="javascript:selectTSpoints(50010,442,138)">';
mtxt += '<area shape="circle" coords="447,138,3" href="javascript:selectTSpoints(50011,447,138)">';
mtxt += '<area shape="circle" coords="453,138,3" href="javascript:selectTSpoints(50012,453,138)">';
mtxt += '<area shape="circle" coords="458,138,3" href="javascript:selectTSpoints(50013,458,138)">';
mtxt += '<area shape="circle" coords="463,138,3" href="javascript:selectTSpoints(50014,463,138)">';
mtxt += '<area shape="circle" coords="468,138,3" href="javascript:selectTSpoints(50015,468,138)">';
mtxt += '<area shape="circle" coords="473,138,3" href="javascript:selectTSpoints(50016,473,138)">';
mtxt += '<area shape="circle" coords="478,138,3" href="javascript:selectTSpoints(50017,478,138)">';
mtxt += '<area shape="circle" coords="483,138,3" href="javascript:selectTSpoints(50018,483,138)">';
mtxt += '<area shape="circle" coords="488,138,3" href="javascript:selectTSpoints(50019,488,138)">';
mtxt += '<area shape="circle" coords="493,138,3" href="javascript:selectTSpoints(50020,493,138)">';
mtxt += '<area shape="circle" coords="498,138,3" href="javascript:selectTSpoints(50021,498,138)">';
mtxt += '<area shape="circle" coords="503,138,3" href="javascript:selectTSpoints(50022,503,138)">';
mtxt += '<area shape="circle" coords="509,138,3" href="javascript:selectTSpoints(50023,509,138)">';
mtxt += '<area shape="circle" coords="514,138,3" href="javascript:selectTSpoints(50024,514,138)">';
mtxt += '<area shape="circle" coords="519,138,3" href="javascript:selectTSpoints(50025,519,138)">';
mtxt += '<area shape="circle" coords="524,138,3" href="javascript:selectTSpoints(50026,524,138)">';
mtxt += '<area shape="circle" coords="529,138,3" href="javascript:selectTSpoints(50027,529,138)">';
mtxt += '<area shape="circle" coords="534,138,3" href="javascript:selectTSpoints(50028,534,138)">';
mtxt += '<area shape="circle" coords="539,138,3" href="javascript:selectTSpoints(50029,539,138)">';
mtxt += '<area shape="circle" coords="544,138,3" href="javascript:selectTSpoints(50030,544,138)">';
mtxt += '<area shape="circle" coords="549,138,3" href="javascript:selectTSpoints(50031,549,138)">';
mtxt += '<area shape="circle" coords="554,138,3" href="javascript:selectTSpoints(50032,554,138)">';
mtxt += '<area shape="circle" coords="559,138,3" href="javascript:selectTSpoints(50033,559,138)">';
mtxt += '<area shape="circle" coords="565,138,3" href="javascript:selectTSpoints(50034,565,138)">';
mtxt += '<area shape="circle" coords="570,138,3" href="javascript:selectTSpoints(50035,570,138)">';
mtxt += '<area shape="circle" coords="575,138,3" href="javascript:selectTSpoints(50036,575,138)">';
mtxt += '<area shape="circle" coords="580,138,3" href="javascript:selectTSpoints(50037,580,138)">';
mtxt += '<area shape="circle" coords="585,138,3" href="javascript:selectTSpoints(50038,585,138)">';
mtxt += '<area shape="circle" coords="590,138,3" href="javascript:selectTSpoints(50039,590,138)">';
mtxt += '<area shape="circle" coords="595,138,3" href="javascript:selectTSpoints(50040,595,138)">';
mtxt += '<area shape="circle" coords="600,138,3" href="javascript:selectTSpoints(50041,600,138)">';
mtxt += '<area shape="circle" coords="605,138,3" href="javascript:selectTSpoints(50042,605,138)">';
mtxt += '<area shape="circle" coords="610,138,3" href="javascript:selectTSpoints(50043,610,138)">';
mtxt += '<area shape="circle" coords="615,138,3" href="javascript:selectTSpoints(50044,615,138)">';
mtxt += '<area shape="circle" coords="621,138,3" href="javascript:selectTSpoints(50045,621,138)">';
mtxt += '<area shape="circle" coords="626,138,3" href="javascript:selectTSpoints(50046,626,138)">';
mtxt += '<area shape="circle" coords="631,138,3" href="javascript:selectTSpoints(50047,631,138)">';
mtxt += '<area shape="circle" coords="636,138,3" href="javascript:selectTSpoints(50048,636,138)">';
mtxt += '<area shape="circle" coords="641,138,3" href="javascript:selectTSpoints(50049,641,138)">';
mtxt += '<area shape="circle" coords="646,138,3" href="javascript:selectTSpoints(50050,646,138)">';
mtxt += '<area shape="circle" coords="651,138,3" href="javascript:selectTSpoints(50051,651,138)">';
mtxt += '<area shape="circle" coords="656,138,3" href="javascript:selectTSpoints(50052,656,138)">';
mtxt += '<area shape="circle" coords="661,138,3" href="javascript:selectTSpoints(50053,661,138)">';
mtxt += '<area shape="circle" coords="666,138,3" href="javascript:selectTSpoints(50054,666,138)">';
mtxt += '<area shape="circle" coords="671,138,3" href="javascript:selectTSpoints(50055,671,138)">';
mtxt += '<area shape="circle" coords="677,138,3" href="javascript:selectTSpoints(50056,677,138)">';
mtxt += '<area shape="circle" coords="682,138,3" href="javascript:selectTSpoints(50057,682,138)">';
mtxt += '<area shape="circle" coords="687,138,3" href="javascript:selectTSpoints(50058,687,138)">';
mtxt += '<area shape="circle" coords="692,138,3" href="javascript:selectTSpoints(50059,692,138)">';
mtxt += '<area shape="circle" coords="697,138,3" href="javascript:selectTSpoints(50060,697,138)">';
mtxt += '<area shape="circle" coords="702,138,3" href="javascript:selectTSpoints(50061,702,138)">';
mtxt += '<area shape="circle" coords="707,138,3" href="javascript:selectTSpoints(50062,707,138)">';
mtxt += '<area shape="circle" coords="712,138,3" href="javascript:selectTSpoints(50063,712,138)">';
mtxt += '<area shape="circle" coords="717,138,3" href="javascript:selectTSpoints(50064,717,138)">';
mtxt += '<area shape="circle" coords="722,138,3" href="javascript:selectTSpoints(50065,722,138)">';
mtxt += '<area shape="circle" coords="727,138,3" href="javascript:selectTSpoints(50066,727,138)">';
mtxt += '<area shape="circle" coords="733,138,3" href="javascript:selectTSpoints(50067,733,138)">';
mtxt += '<area shape="circle" coords="738,138,3" href="javascript:selectTSpoints(50068,738,138)">';
mtxt += '<area shape="circle" coords="743,138,3" href="javascript:selectTSpoints(50069,743,138)">';
mtxt += '<area shape="circle" coords="748,138,3" href="javascript:selectTSpoints(50070,748,138)">';
mtxt += '<area shape="circle" coords="753,138,3" href="javascript:selectTSpoints(50071,753,138)">';
mtxt += '<area shape="circle" coords="758,138,3" href="javascript:selectTSpoints(50072,758,138)">';
mtxt += '<area shape="circle" coords=" 30,133,3" href="javascript:selectTSpoints(51073, 30,133)">';
mtxt += '<area shape="circle" coords=" 35,133,3" href="javascript:selectTSpoints(51074, 35,133)">';
mtxt += '<area shape="circle" coords=" 40,133,3" href="javascript:selectTSpoints(51075, 40,133)">';
mtxt += '<area shape="circle" coords=" 45,133,3" href="javascript:selectTSpoints(51076, 45,133)">';
mtxt += '<area shape="circle" coords=" 50,133,3" href="javascript:selectTSpoints(51077, 50,133)">';
mtxt += '<area shape="circle" coords=" 56,133,3" href="javascript:selectTSpoints(51078, 56,133)">';
mtxt += '<area shape="circle" coords=" 61,133,3" href="javascript:selectTSpoints(51079, 61,133)">';
mtxt += '<area shape="circle" coords=" 66,133,3" href="javascript:selectTSpoints(51080, 66,133)">';
mtxt += '<area shape="circle" coords=" 71,133,3" href="javascript:selectTSpoints(51081, 71,133)">';
mtxt += '<area shape="circle" coords=" 76,133,3" href="javascript:selectTSpoints(51082, 76,133)">';
mtxt += '<area shape="circle" coords=" 81,133,3" href="javascript:selectTSpoints(51083, 81,133)">';
mtxt += '<area shape="circle" coords=" 86,133,3" href="javascript:selectTSpoints(51084, 86,133)">';
mtxt += '<area shape="circle" coords=" 91,133,3" href="javascript:selectTSpoints(51085, 91,133)">';
mtxt += '<area shape="circle" coords=" 96,133,3" href="javascript:selectTSpoints(51086, 96,133)">';
mtxt += '<area shape="circle" coords="101,133,3" href="javascript:selectTSpoints(51087,101,133)">';
mtxt += '<area shape="circle" coords="106,133,3" href="javascript:selectTSpoints(51088,106,133)">';
mtxt += '<area shape="circle" coords="112,133,3" href="javascript:selectTSpoints(51089,112,133)">';
mtxt += '<area shape="circle" coords="117,133,3" href="javascript:selectTSpoints(51090,117,133)">';
mtxt += '<area shape="circle" coords="122,133,3" href="javascript:selectTSpoints(51091,122,133)">';
mtxt += '<area shape="circle" coords="127,133,3" href="javascript:selectTSpoints(51092,127,133)">';
mtxt += '<area shape="circle" coords="132,133,3" href="javascript:selectTSpoints(51093,132,133)">';
mtxt += '<area shape="circle" coords="137,133,3" href="javascript:selectTSpoints(51094,137,133)">';
mtxt += '<area shape="circle" coords="142,133,3" href="javascript:selectTSpoints(51095,142,133)">';
mtxt += '<area shape="circle" coords="147,133,3" href="javascript:selectTSpoints(51096,147,133)">';
mtxt += '<area shape="circle" coords="152,133,3" href="javascript:selectTSpoints(51097,152,133)">';
mtxt += '<area shape="circle" coords="157,133,3" href="javascript:selectTSpoints(51098,157,133)">';
mtxt += '<area shape="circle" coords="162,133,3" href="javascript:selectTSpoints(51099,162,133)">';
mtxt += '<area shape="circle" coords="168,133,3" href="javascript:selectTSpoints(51100,168,133)">';
mtxt += '<area shape="circle" coords="173,133,3" href="javascript:selectTSpoints(51101,173,133)">';
mtxt += '<area shape="circle" coords="178,133,3" href="javascript:selectTSpoints(51102,178,133)">';
mtxt += '<area shape="circle" coords="183,133,3" href="javascript:selectTSpoints(51103,183,133)">';
mtxt += '<area shape="circle" coords="188,133,3" href="javascript:selectTSpoints(51104,188,133)">';
mtxt += '<area shape="circle" coords="193,133,3" href="javascript:selectTSpoints(51105,193,133)">';
mtxt += '<area shape="circle" coords="198,133,3" href="javascript:selectTSpoints(51106,198,133)">';
mtxt += '<area shape="circle" coords="203,133,3" href="javascript:selectTSpoints(51107,203,133)">';
mtxt += '<area shape="circle" coords="208,133,3" href="javascript:selectTSpoints(51108,208,133)">';
mtxt += '<area shape="circle" coords="213,133,3" href="javascript:selectTSpoints(51109,213,133)">';
mtxt += '<area shape="circle" coords="218,133,3" href="javascript:selectTSpoints(51110,218,133)">';
mtxt += '<area shape="circle" coords="224,133,3" href="javascript:selectTSpoints(51111,224,133)">';
mtxt += '<area shape="circle" coords="229,133,3" href="javascript:selectTSpoints(51112,229,133)">';
mtxt += '<area shape="circle" coords="234,133,3" href="javascript:selectTSpoints(51113,234,133)">';
mtxt += '<area shape="circle" coords="239,133,3" href="javascript:selectTSpoints(51114,239,133)">';
mtxt += '<area shape="circle" coords="244,133,3" href="javascript:selectTSpoints(51115,244,133)">';
mtxt += '<area shape="circle" coords="249,133,3" href="javascript:selectTSpoints(51116,249,133)">';
mtxt += '<area shape="circle" coords="254,133,3" href="javascript:selectTSpoints(51117,254,133)">';
mtxt += '<area shape="circle" coords="259,133,3" href="javascript:selectTSpoints(51118,259,133)">';
mtxt += '<area shape="circle" coords="264,133,3" href="javascript:selectTSpoints(51119,264,133)">';
mtxt += '<area shape="circle" coords="269,133,3" href="javascript:selectTSpoints(51120,269,133)">';
mtxt += '<area shape="circle" coords="274,133,3" href="javascript:selectTSpoints(51121,274,133)">';
mtxt += '<area shape="circle" coords="280,133,3" href="javascript:selectTSpoints(51122,280,133)">';
mtxt += '<area shape="circle" coords="285,133,3" href="javascript:selectTSpoints(51123,285,133)">';
mtxt += '<area shape="circle" coords="290,133,3" href="javascript:selectTSpoints(51124,290,133)">';
mtxt += '<area shape="circle" coords="295,133,3" href="javascript:selectTSpoints(51125,295,133)">';
mtxt += '<area shape="circle" coords="300,133,3" href="javascript:selectTSpoints(51126,300,133)">';
mtxt += '<area shape="circle" coords="305,133,3" href="javascript:selectTSpoints(51127,305,133)">';
mtxt += '<area shape="circle" coords="310,133,3" href="javascript:selectTSpoints(51128,310,133)">';
mtxt += '<area shape="circle" coords="315,133,3" href="javascript:selectTSpoints(51129,315,133)">';
mtxt += '<area shape="circle" coords="320,133,3" href="javascript:selectTSpoints(51130,320,133)">';
mtxt += '<area shape="circle" coords="325,133,3" href="javascript:selectTSpoints(51131,325,133)">';
mtxt += '<area shape="circle" coords="330,133,3" href="javascript:selectTSpoints(51132,330,133)">';
mtxt += '<area shape="circle" coords="336,133,3" href="javascript:selectTSpoints(51133,336,133)">';
mtxt += '<area shape="circle" coords="341,133,3" href="javascript:selectTSpoints(51134,341,133)">';
mtxt += '<area shape="circle" coords="346,133,3" href="javascript:selectTSpoints(51135,346,133)">';
mtxt += '<area shape="circle" coords="351,133,3" href="javascript:selectTSpoints(51136,351,133)">';
mtxt += '<area shape="circle" coords="356,133,3" href="javascript:selectTSpoints(51137,356,133)">';
mtxt += '<area shape="circle" coords="361,133,3" href="javascript:selectTSpoints(51138,361,133)">';
mtxt += '<area shape="circle" coords="366,133,3" href="javascript:selectTSpoints(51139,366,133)">';
mtxt += '<area shape="circle" coords="371,133,3" href="javascript:selectTSpoints(51140,371,133)">';
mtxt += '<area shape="circle" coords="376,133,3" href="javascript:selectTSpoints(51141,376,133)">';
mtxt += '<area shape="circle" coords="381,133,3" href="javascript:selectTSpoints(51142,381,133)">';
mtxt += '<area shape="circle" coords="386,133,3" href="javascript:selectTSpoints(51143,386,133)">';
mtxt += '<area shape="circle" coords="392,133,3" href="javascript:selectTSpoints(51144,392,133)">';
mtxt += '<area shape="circle" coords="397,133,3" href="javascript:selectTSpoints(51001,397,133)">';
mtxt += '<area shape="circle" coords="402,133,3" href="javascript:selectTSpoints(51002,402,133)">';
mtxt += '<area shape="circle" coords="407,133,3" href="javascript:selectTSpoints(51003,407,133)">';
mtxt += '<area shape="circle" coords="412,133,3" href="javascript:selectTSpoints(51004,412,133)">';
mtxt += '<area shape="circle" coords="417,133,3" href="javascript:selectTSpoints(51005,417,133)">';
mtxt += '<area shape="circle" coords="422,133,3" href="javascript:selectTSpoints(51006,422,133)">';
mtxt += '<area shape="circle" coords="427,133,3" href="javascript:selectTSpoints(51007,427,133)">';
mtxt += '<area shape="circle" coords="432,133,3" href="javascript:selectTSpoints(51008,432,133)">';
mtxt += '<area shape="circle" coords="437,133,3" href="javascript:selectTSpoints(51009,437,133)">';
mtxt += '<area shape="circle" coords="442,133,3" href="javascript:selectTSpoints(51010,442,133)">';
mtxt += '<area shape="circle" coords="447,133,3" href="javascript:selectTSpoints(51011,447,133)">';
mtxt += '<area shape="circle" coords="453,133,3" href="javascript:selectTSpoints(51012,453,133)">';
mtxt += '<area shape="circle" coords="458,133,3" href="javascript:selectTSpoints(51013,458,133)">';
mtxt += '<area shape="circle" coords="463,133,3" href="javascript:selectTSpoints(51014,463,133)">';
mtxt += '<area shape="circle" coords="468,133,3" href="javascript:selectTSpoints(51015,468,133)">';
mtxt += '<area shape="circle" coords="473,133,3" href="javascript:selectTSpoints(51016,473,133)">';
mtxt += '<area shape="circle" coords="478,133,3" href="javascript:selectTSpoints(51017,478,133)">';
mtxt += '<area shape="circle" coords="483,133,3" href="javascript:selectTSpoints(51018,483,133)">';
mtxt += '<area shape="circle" coords="488,133,3" href="javascript:selectTSpoints(51019,488,133)">';
mtxt += '<area shape="circle" coords="493,133,3" href="javascript:selectTSpoints(51020,493,133)">';
mtxt += '<area shape="circle" coords="498,133,3" href="javascript:selectTSpoints(51021,498,133)">';
mtxt += '<area shape="circle" coords="503,133,3" href="javascript:selectTSpoints(51022,503,133)">';
mtxt += '<area shape="circle" coords="509,133,3" href="javascript:selectTSpoints(51023,509,133)">';
mtxt += '<area shape="circle" coords="514,133,3" href="javascript:selectTSpoints(51024,514,133)">';
mtxt += '<area shape="circle" coords="519,133,3" href="javascript:selectTSpoints(51025,519,133)">';
mtxt += '<area shape="circle" coords="524,133,3" href="javascript:selectTSpoints(51026,524,133)">';
mtxt += '<area shape="circle" coords="529,133,3" href="javascript:selectTSpoints(51027,529,133)">';
mtxt += '<area shape="circle" coords="534,133,3" href="javascript:selectTSpoints(51028,534,133)">';
mtxt += '<area shape="circle" coords="539,133,3" href="javascript:selectTSpoints(51029,539,133)">';
mtxt += '<area shape="circle" coords="544,133,3" href="javascript:selectTSpoints(51030,544,133)">';
mtxt += '<area shape="circle" coords="549,133,3" href="javascript:selectTSpoints(51031,549,133)">';
mtxt += '<area shape="circle" coords="554,133,3" href="javascript:selectTSpoints(51032,554,133)">';
mtxt += '<area shape="circle" coords="559,133,3" href="javascript:selectTSpoints(51033,559,133)">';
mtxt += '<area shape="circle" coords="565,133,3" href="javascript:selectTSpoints(51034,565,133)">';
mtxt += '<area shape="circle" coords="570,133,3" href="javascript:selectTSpoints(51035,570,133)">';
mtxt += '<area shape="circle" coords="575,133,3" href="javascript:selectTSpoints(51036,575,133)">';
mtxt += '<area shape="circle" coords="580,133,3" href="javascript:selectTSpoints(51037,580,133)">';
mtxt += '<area shape="circle" coords="585,133,3" href="javascript:selectTSpoints(51038,585,133)">';
mtxt += '<area shape="circle" coords="590,133,3" href="javascript:selectTSpoints(51039,590,133)">';
mtxt += '<area shape="circle" coords="595,133,3" href="javascript:selectTSpoints(51040,595,133)">';
mtxt += '<area shape="circle" coords="600,133,3" href="javascript:selectTSpoints(51041,600,133)">';
mtxt += '<area shape="circle" coords="605,133,3" href="javascript:selectTSpoints(51042,605,133)">';
mtxt += '<area shape="circle" coords="610,133,3" href="javascript:selectTSpoints(51043,610,133)">';
mtxt += '<area shape="circle" coords="615,133,3" href="javascript:selectTSpoints(51044,615,133)">';
mtxt += '<area shape="circle" coords="621,133,3" href="javascript:selectTSpoints(51045,621,133)">';
mtxt += '<area shape="circle" coords="626,133,3" href="javascript:selectTSpoints(51046,626,133)">';
mtxt += '<area shape="circle" coords="631,133,3" href="javascript:selectTSpoints(51047,631,133)">';
mtxt += '<area shape="circle" coords="636,133,3" href="javascript:selectTSpoints(51048,636,133)">';
mtxt += '<area shape="circle" coords="641,133,3" href="javascript:selectTSpoints(51049,641,133)">';
mtxt += '<area shape="circle" coords="646,133,3" href="javascript:selectTSpoints(51050,646,133)">';
mtxt += '<area shape="circle" coords="651,133,3" href="javascript:selectTSpoints(51051,651,133)">';
mtxt += '<area shape="circle" coords="656,133,3" href="javascript:selectTSpoints(51052,656,133)">';
mtxt += '<area shape="circle" coords="661,133,3" href="javascript:selectTSpoints(51053,661,133)">';
mtxt += '<area shape="circle" coords="666,133,3" href="javascript:selectTSpoints(51054,666,133)">';
mtxt += '<area shape="circle" coords="671,133,3" href="javascript:selectTSpoints(51055,671,133)">';
mtxt += '<area shape="circle" coords="677,133,3" href="javascript:selectTSpoints(51056,677,133)">';
mtxt += '<area shape="circle" coords="682,133,3" href="javascript:selectTSpoints(51057,682,133)">';
mtxt += '<area shape="circle" coords="687,133,3" href="javascript:selectTSpoints(51058,687,133)">';
mtxt += '<area shape="circle" coords="692,133,3" href="javascript:selectTSpoints(51059,692,133)">';
mtxt += '<area shape="circle" coords="697,133,3" href="javascript:selectTSpoints(51060,697,133)">';
mtxt += '<area shape="circle" coords="702,133,3" href="javascript:selectTSpoints(51061,702,133)">';
mtxt += '<area shape="circle" coords="707,133,3" href="javascript:selectTSpoints(51062,707,133)">';
mtxt += '<area shape="circle" coords="712,133,3" href="javascript:selectTSpoints(51063,712,133)">';
mtxt += '<area shape="circle" coords="717,133,3" href="javascript:selectTSpoints(51064,717,133)">';
mtxt += '<area shape="circle" coords="722,133,3" href="javascript:selectTSpoints(51065,722,133)">';
mtxt += '<area shape="circle" coords="727,133,3" href="javascript:selectTSpoints(51066,727,133)">';
mtxt += '<area shape="circle" coords="733,133,3" href="javascript:selectTSpoints(51067,733,133)">';
mtxt += '<area shape="circle" coords="738,133,3" href="javascript:selectTSpoints(51068,738,133)">';
mtxt += '<area shape="circle" coords="743,133,3" href="javascript:selectTSpoints(51069,743,133)">';
mtxt += '<area shape="circle" coords="748,133,3" href="javascript:selectTSpoints(51070,748,133)">';
mtxt += '<area shape="circle" coords="753,133,3" href="javascript:selectTSpoints(51071,753,133)">';
mtxt += '<area shape="circle" coords="758,133,3" href="javascript:selectTSpoints(51072,758,133)">';
mtxt += '<area shape="circle" coords=" 30,128,3" href="javascript:selectTSpoints(52073, 30,128)">';
mtxt += '<area shape="circle" coords=" 35,128,3" href="javascript:selectTSpoints(52074, 35,128)">';
mtxt += '<area shape="circle" coords=" 40,128,3" href="javascript:selectTSpoints(52075, 40,128)">';
mtxt += '<area shape="circle" coords=" 45,128,3" href="javascript:selectTSpoints(52076, 45,128)">';
mtxt += '<area shape="circle" coords=" 50,128,3" href="javascript:selectTSpoints(52077, 50,128)">';
mtxt += '<area shape="circle" coords=" 56,128,3" href="javascript:selectTSpoints(52078, 56,128)">';
mtxt += '<area shape="circle" coords=" 61,128,3" href="javascript:selectTSpoints(52079, 61,128)">';
mtxt += '<area shape="circle" coords=" 66,128,3" href="javascript:selectTSpoints(52080, 66,128)">';
mtxt += '<area shape="circle" coords=" 71,128,3" href="javascript:selectTSpoints(52081, 71,128)">';
mtxt += '<area shape="circle" coords=" 76,128,3" href="javascript:selectTSpoints(52082, 76,128)">';
mtxt += '<area shape="circle" coords=" 81,128,3" href="javascript:selectTSpoints(52083, 81,128)">';
mtxt += '<area shape="circle" coords=" 86,128,3" href="javascript:selectTSpoints(52084, 86,128)">';
mtxt += '<area shape="circle" coords=" 91,128,3" href="javascript:selectTSpoints(52085, 91,128)">';
mtxt += '<area shape="circle" coords=" 96,128,3" href="javascript:selectTSpoints(52086, 96,128)">';
mtxt += '<area shape="circle" coords="101,128,3" href="javascript:selectTSpoints(52087,101,128)">';
mtxt += '<area shape="circle" coords="106,128,3" href="javascript:selectTSpoints(52088,106,128)">';
mtxt += '<area shape="circle" coords="112,128,3" href="javascript:selectTSpoints(52089,112,128)">';
mtxt += '<area shape="circle" coords="117,128,3" href="javascript:selectTSpoints(52090,117,128)">';
mtxt += '<area shape="circle" coords="122,128,3" href="javascript:selectTSpoints(52091,122,128)">';
mtxt += '<area shape="circle" coords="127,128,3" href="javascript:selectTSpoints(52092,127,128)">';
mtxt += '<area shape="circle" coords="132,128,3" href="javascript:selectTSpoints(52093,132,128)">';
mtxt += '<area shape="circle" coords="137,128,3" href="javascript:selectTSpoints(52094,137,128)">';
mtxt += '<area shape="circle" coords="142,128,3" href="javascript:selectTSpoints(52095,142,128)">';
mtxt += '<area shape="circle" coords="147,128,3" href="javascript:selectTSpoints(52096,147,128)">';
mtxt += '<area shape="circle" coords="152,128,3" href="javascript:selectTSpoints(52097,152,128)">';
mtxt += '<area shape="circle" coords="157,128,3" href="javascript:selectTSpoints(52098,157,128)">';
mtxt += '<area shape="circle" coords="162,128,3" href="javascript:selectTSpoints(52099,162,128)">';
mtxt += '<area shape="circle" coords="168,128,3" href="javascript:selectTSpoints(52100,168,128)">';
mtxt += '<area shape="circle" coords="173,128,3" href="javascript:selectTSpoints(52101,173,128)">';
mtxt += '<area shape="circle" coords="178,128,3" href="javascript:selectTSpoints(52102,178,128)">';
mtxt += '<area shape="circle" coords="183,128,3" href="javascript:selectTSpoints(52103,183,128)">';
mtxt += '<area shape="circle" coords="188,128,3" href="javascript:selectTSpoints(52104,188,128)">';
mtxt += '<area shape="circle" coords="193,128,3" href="javascript:selectTSpoints(52105,193,128)">';
mtxt += '<area shape="circle" coords="198,128,3" href="javascript:selectTSpoints(52106,198,128)">';
mtxt += '<area shape="circle" coords="203,128,3" href="javascript:selectTSpoints(52107,203,128)">';
mtxt += '<area shape="circle" coords="208,128,3" href="javascript:selectTSpoints(52108,208,128)">';
mtxt += '<area shape="circle" coords="213,128,3" href="javascript:selectTSpoints(52109,213,128)">';
mtxt += '<area shape="circle" coords="218,128,3" href="javascript:selectTSpoints(52110,218,128)">';
mtxt += '<area shape="circle" coords="224,128,3" href="javascript:selectTSpoints(52111,224,128)">';
mtxt += '<area shape="circle" coords="229,128,3" href="javascript:selectTSpoints(52112,229,128)">';
mtxt += '<area shape="circle" coords="234,128,3" href="javascript:selectTSpoints(52113,234,128)">';
mtxt += '<area shape="circle" coords="239,128,3" href="javascript:selectTSpoints(52114,239,128)">';
mtxt += '<area shape="circle" coords="244,128,3" href="javascript:selectTSpoints(52115,244,128)">';
mtxt += '<area shape="circle" coords="249,128,3" href="javascript:selectTSpoints(52116,249,128)">';
mtxt += '<area shape="circle" coords="254,128,3" href="javascript:selectTSpoints(52117,254,128)">';
mtxt += '<area shape="circle" coords="259,128,3" href="javascript:selectTSpoints(52118,259,128)">';
mtxt += '<area shape="circle" coords="264,128,3" href="javascript:selectTSpoints(52119,264,128)">';
mtxt += '<area shape="circle" coords="269,128,3" href="javascript:selectTSpoints(52120,269,128)">';
mtxt += '<area shape="circle" coords="274,128,3" href="javascript:selectTSpoints(52121,274,128)">';
mtxt += '<area shape="circle" coords="280,128,3" href="javascript:selectTSpoints(52122,280,128)">';
mtxt += '<area shape="circle" coords="285,128,3" href="javascript:selectTSpoints(52123,285,128)">';
mtxt += '<area shape="circle" coords="290,128,3" href="javascript:selectTSpoints(52124,290,128)">';
mtxt += '<area shape="circle" coords="295,128,3" href="javascript:selectTSpoints(52125,295,128)">';
mtxt += '<area shape="circle" coords="300,128,3" href="javascript:selectTSpoints(52126,300,128)">';
mtxt += '<area shape="circle" coords="305,128,3" href="javascript:selectTSpoints(52127,305,128)">';
mtxt += '<area shape="circle" coords="310,128,3" href="javascript:selectTSpoints(52128,310,128)">';
mtxt += '<area shape="circle" coords="315,128,3" href="javascript:selectTSpoints(52129,315,128)">';
mtxt += '<area shape="circle" coords="320,128,3" href="javascript:selectTSpoints(52130,320,128)">';
mtxt += '<area shape="circle" coords="325,128,3" href="javascript:selectTSpoints(52131,325,128)">';
mtxt += '<area shape="circle" coords="330,128,3" href="javascript:selectTSpoints(52132,330,128)">';
mtxt += '<area shape="circle" coords="336,128,3" href="javascript:selectTSpoints(52133,336,128)">';
mtxt += '<area shape="circle" coords="341,128,3" href="javascript:selectTSpoints(52134,341,128)">';
mtxt += '<area shape="circle" coords="346,128,3" href="javascript:selectTSpoints(52135,346,128)">';
mtxt += '<area shape="circle" coords="351,128,3" href="javascript:selectTSpoints(52136,351,128)">';
mtxt += '<area shape="circle" coords="356,128,3" href="javascript:selectTSpoints(52137,356,128)">';
mtxt += '<area shape="circle" coords="361,128,3" href="javascript:selectTSpoints(52138,361,128)">';
mtxt += '<area shape="circle" coords="366,128,3" href="javascript:selectTSpoints(52139,366,128)">';
mtxt += '<area shape="circle" coords="371,128,3" href="javascript:selectTSpoints(52140,371,128)">';
mtxt += '<area shape="circle" coords="376,128,3" href="javascript:selectTSpoints(52141,376,128)">';
mtxt += '<area shape="circle" coords="381,128,3" href="javascript:selectTSpoints(52142,381,128)">';
mtxt += '<area shape="circle" coords="386,128,3" href="javascript:selectTSpoints(52143,386,128)">';
mtxt += '<area shape="circle" coords="392,128,3" href="javascript:selectTSpoints(52144,392,128)">';
mtxt += '<area shape="circle" coords="397,128,3" href="javascript:selectTSpoints(52001,397,128)">';
mtxt += '<area shape="circle" coords="402,128,3" href="javascript:selectTSpoints(52002,402,128)">';
mtxt += '<area shape="circle" coords="407,128,3" href="javascript:selectTSpoints(52003,407,128)">';
mtxt += '<area shape="circle" coords="412,128,3" href="javascript:selectTSpoints(52004,412,128)">';
mtxt += '<area shape="circle" coords="417,128,3" href="javascript:selectTSpoints(52005,417,128)">';
mtxt += '<area shape="circle" coords="422,128,3" href="javascript:selectTSpoints(52006,422,128)">';
mtxt += '<area shape="circle" coords="427,128,3" href="javascript:selectTSpoints(52007,427,128)">';
mtxt += '<area shape="circle" coords="432,128,3" href="javascript:selectTSpoints(52008,432,128)">';
mtxt += '<area shape="circle" coords="437,128,3" href="javascript:selectTSpoints(52009,437,128)">';
mtxt += '<area shape="circle" coords="442,128,3" href="javascript:selectTSpoints(52010,442,128)">';
mtxt += '<area shape="circle" coords="447,128,3" href="javascript:selectTSpoints(52011,447,128)">';
mtxt += '<area shape="circle" coords="453,128,3" href="javascript:selectTSpoints(52012,453,128)">';
mtxt += '<area shape="circle" coords="458,128,3" href="javascript:selectTSpoints(52013,458,128)">';
mtxt += '<area shape="circle" coords="463,128,3" href="javascript:selectTSpoints(52014,463,128)">';
mtxt += '<area shape="circle" coords="468,128,3" href="javascript:selectTSpoints(52015,468,128)">';
mtxt += '<area shape="circle" coords="473,128,3" href="javascript:selectTSpoints(52016,473,128)">';
mtxt += '<area shape="circle" coords="478,128,3" href="javascript:selectTSpoints(52017,478,128)">';
mtxt += '<area shape="circle" coords="483,128,3" href="javascript:selectTSpoints(52018,483,128)">';
mtxt += '<area shape="circle" coords="488,128,3" href="javascript:selectTSpoints(52019,488,128)">';
mtxt += '<area shape="circle" coords="493,128,3" href="javascript:selectTSpoints(52020,493,128)">';
mtxt += '<area shape="circle" coords="498,128,3" href="javascript:selectTSpoints(52021,498,128)">';
mtxt += '<area shape="circle" coords="503,128,3" href="javascript:selectTSpoints(52022,503,128)">';
mtxt += '<area shape="circle" coords="509,128,3" href="javascript:selectTSpoints(52023,509,128)">';
mtxt += '<area shape="circle" coords="514,128,3" href="javascript:selectTSpoints(52024,514,128)">';
mtxt += '<area shape="circle" coords="519,128,3" href="javascript:selectTSpoints(52025,519,128)">';
mtxt += '<area shape="circle" coords="524,128,3" href="javascript:selectTSpoints(52026,524,128)">';
mtxt += '<area shape="circle" coords="529,128,3" href="javascript:selectTSpoints(52027,529,128)">';
mtxt += '<area shape="circle" coords="534,128,3" href="javascript:selectTSpoints(52028,534,128)">';
mtxt += '<area shape="circle" coords="539,128,3" href="javascript:selectTSpoints(52029,539,128)">';
mtxt += '<area shape="circle" coords="544,128,3" href="javascript:selectTSpoints(52030,544,128)">';
mtxt += '<area shape="circle" coords="549,128,3" href="javascript:selectTSpoints(52031,549,128)">';
mtxt += '<area shape="circle" coords="554,128,3" href="javascript:selectTSpoints(52032,554,128)">';
mtxt += '<area shape="circle" coords="559,128,3" href="javascript:selectTSpoints(52033,559,128)">';
mtxt += '<area shape="circle" coords="565,128,3" href="javascript:selectTSpoints(52034,565,128)">';
mtxt += '<area shape="circle" coords="570,128,3" href="javascript:selectTSpoints(52035,570,128)">';
mtxt += '<area shape="circle" coords="575,128,3" href="javascript:selectTSpoints(52036,575,128)">';
mtxt += '<area shape="circle" coords="580,128,3" href="javascript:selectTSpoints(52037,580,128)">';
mtxt += '<area shape="circle" coords="585,128,3" href="javascript:selectTSpoints(52038,585,128)">';
mtxt += '<area shape="circle" coords="590,128,3" href="javascript:selectTSpoints(52039,590,128)">';
mtxt += '<area shape="circle" coords="595,128,3" href="javascript:selectTSpoints(52040,595,128)">';
mtxt += '<area shape="circle" coords="600,128,3" href="javascript:selectTSpoints(52041,600,128)">';
mtxt += '<area shape="circle" coords="605,128,3" href="javascript:selectTSpoints(52042,605,128)">';
mtxt += '<area shape="circle" coords="610,128,3" href="javascript:selectTSpoints(52043,610,128)">';
mtxt += '<area shape="circle" coords="615,128,3" href="javascript:selectTSpoints(52044,615,128)">';
mtxt += '<area shape="circle" coords="621,128,3" href="javascript:selectTSpoints(52045,621,128)">';
mtxt += '<area shape="circle" coords="626,128,3" href="javascript:selectTSpoints(52046,626,128)">';
mtxt += '<area shape="circle" coords="631,128,3" href="javascript:selectTSpoints(52047,631,128)">';
mtxt += '<area shape="circle" coords="636,128,3" href="javascript:selectTSpoints(52048,636,128)">';
mtxt += '<area shape="circle" coords="641,128,3" href="javascript:selectTSpoints(52049,641,128)">';
mtxt += '<area shape="circle" coords="646,128,3" href="javascript:selectTSpoints(52050,646,128)">';
mtxt += '<area shape="circle" coords="651,128,3" href="javascript:selectTSpoints(52051,651,128)">';
mtxt += '<area shape="circle" coords="656,128,3" href="javascript:selectTSpoints(52052,656,128)">';
mtxt += '<area shape="circle" coords="661,128,3" href="javascript:selectTSpoints(52053,661,128)">';
mtxt += '<area shape="circle" coords="666,128,3" href="javascript:selectTSpoints(52054,666,128)">';
mtxt += '<area shape="circle" coords="671,128,3" href="javascript:selectTSpoints(52055,671,128)">';
mtxt += '<area shape="circle" coords="677,128,3" href="javascript:selectTSpoints(52056,677,128)">';
mtxt += '<area shape="circle" coords="682,128,3" href="javascript:selectTSpoints(52057,682,128)">';
mtxt += '<area shape="circle" coords="687,128,3" href="javascript:selectTSpoints(52058,687,128)">';
mtxt += '<area shape="circle" coords="692,128,3" href="javascript:selectTSpoints(52059,692,128)">';
mtxt += '<area shape="circle" coords="697,128,3" href="javascript:selectTSpoints(52060,697,128)">';
mtxt += '<area shape="circle" coords="702,128,3" href="javascript:selectTSpoints(52061,702,128)">';
mtxt += '<area shape="circle" coords="707,128,3" href="javascript:selectTSpoints(52062,707,128)">';
mtxt += '<area shape="circle" coords="712,128,3" href="javascript:selectTSpoints(52063,712,128)">';
mtxt += '<area shape="circle" coords="717,128,3" href="javascript:selectTSpoints(52064,717,128)">';
mtxt += '<area shape="circle" coords="722,128,3" href="javascript:selectTSpoints(52065,722,128)">';
mtxt += '<area shape="circle" coords="727,128,3" href="javascript:selectTSpoints(52066,727,128)">';
mtxt += '<area shape="circle" coords="733,128,3" href="javascript:selectTSpoints(52067,733,128)">';
mtxt += '<area shape="circle" coords="738,128,3" href="javascript:selectTSpoints(52068,738,128)">';
mtxt += '<area shape="circle" coords="743,128,3" href="javascript:selectTSpoints(52069,743,128)">';
mtxt += '<area shape="circle" coords="748,128,3" href="javascript:selectTSpoints(52070,748,128)">';
mtxt += '<area shape="circle" coords="753,128,3" href="javascript:selectTSpoints(52071,753,128)">';
mtxt += '<area shape="circle" coords="758,128,3" href="javascript:selectTSpoints(52072,758,128)">';
mtxt += '<area shape="circle" coords=" 30,124,3" href="javascript:selectTSpoints(53073, 30,124)">';
mtxt += '<area shape="circle" coords=" 35,124,3" href="javascript:selectTSpoints(53074, 35,124)">';
mtxt += '<area shape="circle" coords=" 40,124,3" href="javascript:selectTSpoints(53075, 40,124)">';
mtxt += '<area shape="circle" coords=" 45,124,3" href="javascript:selectTSpoints(53076, 45,124)">';
mtxt += '<area shape="circle" coords=" 50,124,3" href="javascript:selectTSpoints(53077, 50,124)">';
mtxt += '<area shape="circle" coords=" 56,124,3" href="javascript:selectTSpoints(53078, 56,124)">';
mtxt += '<area shape="circle" coords=" 61,124,3" href="javascript:selectTSpoints(53079, 61,124)">';
mtxt += '<area shape="circle" coords=" 66,124,3" href="javascript:selectTSpoints(53080, 66,124)">';
mtxt += '<area shape="circle" coords=" 71,124,3" href="javascript:selectTSpoints(53081, 71,124)">';
mtxt += '<area shape="circle" coords=" 76,124,3" href="javascript:selectTSpoints(53082, 76,124)">';
mtxt += '<area shape="circle" coords=" 81,124,3" href="javascript:selectTSpoints(53083, 81,124)">';
mtxt += '<area shape="circle" coords=" 86,124,3" href="javascript:selectTSpoints(53084, 86,124)">';
mtxt += '<area shape="circle" coords=" 91,124,3" href="javascript:selectTSpoints(53085, 91,124)">';
mtxt += '<area shape="circle" coords=" 96,124,3" href="javascript:selectTSpoints(53086, 96,124)">';
mtxt += '<area shape="circle" coords="101,124,3" href="javascript:selectTSpoints(53087,101,124)">';
mtxt += '<area shape="circle" coords="106,124,3" href="javascript:selectTSpoints(53088,106,124)">';
mtxt += '<area shape="circle" coords="112,124,3" href="javascript:selectTSpoints(53089,112,124)">';
mtxt += '<area shape="circle" coords="117,124,3" href="javascript:selectTSpoints(53090,117,124)">';
mtxt += '<area shape="circle" coords="122,124,3" href="javascript:selectTSpoints(53091,122,124)">';
mtxt += '<area shape="circle" coords="127,124,3" href="javascript:selectTSpoints(53092,127,124)">';
mtxt += '<area shape="circle" coords="132,124,3" href="javascript:selectTSpoints(53093,132,124)">';
mtxt += '<area shape="circle" coords="137,124,3" href="javascript:selectTSpoints(53094,137,124)">';
mtxt += '<area shape="circle" coords="142,124,3" href="javascript:selectTSpoints(53095,142,124)">';
mtxt += '<area shape="circle" coords="147,124,3" href="javascript:selectTSpoints(53096,147,124)">';
mtxt += '<area shape="circle" coords="152,124,3" href="javascript:selectTSpoints(53097,152,124)">';
mtxt += '<area shape="circle" coords="157,124,3" href="javascript:selectTSpoints(53098,157,124)">';
mtxt += '<area shape="circle" coords="162,124,3" href="javascript:selectTSpoints(53099,162,124)">';
mtxt += '<area shape="circle" coords="168,124,3" href="javascript:selectTSpoints(53100,168,124)">';
mtxt += '<area shape="circle" coords="173,124,3" href="javascript:selectTSpoints(53101,173,124)">';
mtxt += '<area shape="circle" coords="178,124,3" href="javascript:selectTSpoints(53102,178,124)">';
mtxt += '<area shape="circle" coords="183,124,3" href="javascript:selectTSpoints(53103,183,124)">';
mtxt += '<area shape="circle" coords="188,124,3" href="javascript:selectTSpoints(53104,188,124)">';
mtxt += '<area shape="circle" coords="193,124,3" href="javascript:selectTSpoints(53105,193,124)">';
mtxt += '<area shape="circle" coords="198,124,3" href="javascript:selectTSpoints(53106,198,124)">';
mtxt += '<area shape="circle" coords="203,124,3" href="javascript:selectTSpoints(53107,203,124)">';
mtxt += '<area shape="circle" coords="208,124,3" href="javascript:selectTSpoints(53108,208,124)">';
mtxt += '<area shape="circle" coords="213,124,3" href="javascript:selectTSpoints(53109,213,124)">';
mtxt += '<area shape="circle" coords="218,124,3" href="javascript:selectTSpoints(53110,218,124)">';
mtxt += '<area shape="circle" coords="224,124,3" href="javascript:selectTSpoints(53111,224,124)">';
mtxt += '<area shape="circle" coords="229,124,3" href="javascript:selectTSpoints(53112,229,124)">';
mtxt += '<area shape="circle" coords="234,124,3" href="javascript:selectTSpoints(53113,234,124)">';
mtxt += '<area shape="circle" coords="239,124,3" href="javascript:selectTSpoints(53114,239,124)">';
mtxt += '<area shape="circle" coords="244,124,3" href="javascript:selectTSpoints(53115,244,124)">';
mtxt += '<area shape="circle" coords="249,124,3" href="javascript:selectTSpoints(53116,249,124)">';
mtxt += '<area shape="circle" coords="254,124,3" href="javascript:selectTSpoints(53117,254,124)">';
mtxt += '<area shape="circle" coords="259,124,3" href="javascript:selectTSpoints(53118,259,124)">';
mtxt += '<area shape="circle" coords="264,124,3" href="javascript:selectTSpoints(53119,264,124)">';
mtxt += '<area shape="circle" coords="269,124,3" href="javascript:selectTSpoints(53120,269,124)">';
mtxt += '<area shape="circle" coords="274,124,3" href="javascript:selectTSpoints(53121,274,124)">';
mtxt += '<area shape="circle" coords="280,124,3" href="javascript:selectTSpoints(53122,280,124)">';
mtxt += '<area shape="circle" coords="285,124,3" href="javascript:selectTSpoints(53123,285,124)">';
mtxt += '<area shape="circle" coords="290,124,3" href="javascript:selectTSpoints(53124,290,124)">';
mtxt += '<area shape="circle" coords="295,124,3" href="javascript:selectTSpoints(53125,295,124)">';
mtxt += '<area shape="circle" coords="300,124,3" href="javascript:selectTSpoints(53126,300,124)">';
mtxt += '<area shape="circle" coords="305,124,3" href="javascript:selectTSpoints(53127,305,124)">';
mtxt += '<area shape="circle" coords="310,124,3" href="javascript:selectTSpoints(53128,310,124)">';
mtxt += '<area shape="circle" coords="315,124,3" href="javascript:selectTSpoints(53129,315,124)">';
mtxt += '<area shape="circle" coords="320,124,3" href="javascript:selectTSpoints(53130,320,124)">';
mtxt += '<area shape="circle" coords="325,124,3" href="javascript:selectTSpoints(53131,325,124)">';
mtxt += '<area shape="circle" coords="330,124,3" href="javascript:selectTSpoints(53132,330,124)">';
mtxt += '<area shape="circle" coords="336,124,3" href="javascript:selectTSpoints(53133,336,124)">';
mtxt += '<area shape="circle" coords="341,124,3" href="javascript:selectTSpoints(53134,341,124)">';
mtxt += '<area shape="circle" coords="346,124,3" href="javascript:selectTSpoints(53135,346,124)">';
mtxt += '<area shape="circle" coords="351,124,3" href="javascript:selectTSpoints(53136,351,124)">';
mtxt += '<area shape="circle" coords="356,124,3" href="javascript:selectTSpoints(53137,356,124)">';
mtxt += '<area shape="circle" coords="361,124,3" href="javascript:selectTSpoints(53138,361,124)">';
mtxt += '<area shape="circle" coords="366,124,3" href="javascript:selectTSpoints(53139,366,124)">';
mtxt += '<area shape="circle" coords="371,124,3" href="javascript:selectTSpoints(53140,371,124)">';
mtxt += '<area shape="circle" coords="376,124,3" href="javascript:selectTSpoints(53141,376,124)">';
mtxt += '<area shape="circle" coords="381,124,3" href="javascript:selectTSpoints(53142,381,124)">';
mtxt += '<area shape="circle" coords="386,124,3" href="javascript:selectTSpoints(53143,386,124)">';
mtxt += '<area shape="circle" coords="392,124,3" href="javascript:selectTSpoints(53144,392,124)">';
mtxt += '<area shape="circle" coords="397,124,3" href="javascript:selectTSpoints(53001,397,124)">';
mtxt += '<area shape="circle" coords="402,124,3" href="javascript:selectTSpoints(53002,402,124)">';
mtxt += '<area shape="circle" coords="407,124,3" href="javascript:selectTSpoints(53003,407,124)">';
mtxt += '<area shape="circle" coords="412,124,3" href="javascript:selectTSpoints(53004,412,124)">';
mtxt += '<area shape="circle" coords="417,124,3" href="javascript:selectTSpoints(53005,417,124)">';
mtxt += '<area shape="circle" coords="422,124,3" href="javascript:selectTSpoints(53006,422,124)">';
mtxt += '<area shape="circle" coords="427,124,3" href="javascript:selectTSpoints(53007,427,124)">';
mtxt += '<area shape="circle" coords="432,124,3" href="javascript:selectTSpoints(53008,432,124)">';
mtxt += '<area shape="circle" coords="437,124,3" href="javascript:selectTSpoints(53009,437,124)">';
mtxt += '<area shape="circle" coords="442,124,3" href="javascript:selectTSpoints(53010,442,124)">';
mtxt += '<area shape="circle" coords="447,124,3" href="javascript:selectTSpoints(53011,447,124)">';
mtxt += '<area shape="circle" coords="453,124,3" href="javascript:selectTSpoints(53012,453,124)">';
mtxt += '<area shape="circle" coords="458,124,3" href="javascript:selectTSpoints(53013,458,124)">';
mtxt += '<area shape="circle" coords="463,124,3" href="javascript:selectTSpoints(53014,463,124)">';
mtxt += '<area shape="circle" coords="468,124,3" href="javascript:selectTSpoints(53015,468,124)">';
mtxt += '<area shape="circle" coords="473,124,3" href="javascript:selectTSpoints(53016,473,124)">';
mtxt += '<area shape="circle" coords="478,124,3" href="javascript:selectTSpoints(53017,478,124)">';
mtxt += '<area shape="circle" coords="483,124,3" href="javascript:selectTSpoints(53018,483,124)">';
mtxt += '<area shape="circle" coords="488,124,3" href="javascript:selectTSpoints(53019,488,124)">';
mtxt += '<area shape="circle" coords="493,124,3" href="javascript:selectTSpoints(53020,493,124)">';
mtxt += '<area shape="circle" coords="498,124,3" href="javascript:selectTSpoints(53021,498,124)">';
mtxt += '<area shape="circle" coords="503,124,3" href="javascript:selectTSpoints(53022,503,124)">';
mtxt += '<area shape="circle" coords="509,124,3" href="javascript:selectTSpoints(53023,509,124)">';
mtxt += '<area shape="circle" coords="514,124,3" href="javascript:selectTSpoints(53024,514,124)">';
mtxt += '<area shape="circle" coords="519,124,3" href="javascript:selectTSpoints(53025,519,124)">';
mtxt += '<area shape="circle" coords="524,124,3" href="javascript:selectTSpoints(53026,524,124)">';
mtxt += '<area shape="circle" coords="529,124,3" href="javascript:selectTSpoints(53027,529,124)">';
mtxt += '<area shape="circle" coords="534,124,3" href="javascript:selectTSpoints(53028,534,124)">';
mtxt += '<area shape="circle" coords="539,124,3" href="javascript:selectTSpoints(53029,539,124)">';
mtxt += '<area shape="circle" coords="544,124,3" href="javascript:selectTSpoints(53030,544,124)">';
mtxt += '<area shape="circle" coords="549,124,3" href="javascript:selectTSpoints(53031,549,124)">';
mtxt += '<area shape="circle" coords="554,124,3" href="javascript:selectTSpoints(53032,554,124)">';
mtxt += '<area shape="circle" coords="559,124,3" href="javascript:selectTSpoints(53033,559,124)">';
mtxt += '<area shape="circle" coords="565,124,3" href="javascript:selectTSpoints(53034,565,124)">';
mtxt += '<area shape="circle" coords="570,124,3" href="javascript:selectTSpoints(53035,570,124)">';
mtxt += '<area shape="circle" coords="575,124,3" href="javascript:selectTSpoints(53036,575,124)">';
mtxt += '<area shape="circle" coords="580,124,3" href="javascript:selectTSpoints(53037,580,124)">';
mtxt += '<area shape="circle" coords="585,124,3" href="javascript:selectTSpoints(53038,585,124)">';
mtxt += '<area shape="circle" coords="590,124,3" href="javascript:selectTSpoints(53039,590,124)">';
mtxt += '<area shape="circle" coords="595,124,3" href="javascript:selectTSpoints(53040,595,124)">';
mtxt += '<area shape="circle" coords="600,124,3" href="javascript:selectTSpoints(53041,600,124)">';
mtxt += '<area shape="circle" coords="605,124,3" href="javascript:selectTSpoints(53042,605,124)">';
mtxt += '<area shape="circle" coords="610,124,3" href="javascript:selectTSpoints(53043,610,124)">';
mtxt += '<area shape="circle" coords="615,124,3" href="javascript:selectTSpoints(53044,615,124)">';
mtxt += '<area shape="circle" coords="621,124,3" href="javascript:selectTSpoints(53045,621,124)">';
mtxt += '<area shape="circle" coords="626,124,3" href="javascript:selectTSpoints(53046,626,124)">';
mtxt += '<area shape="circle" coords="631,124,3" href="javascript:selectTSpoints(53047,631,124)">';
mtxt += '<area shape="circle" coords="636,124,3" href="javascript:selectTSpoints(53048,636,124)">';
mtxt += '<area shape="circle" coords="641,124,3" href="javascript:selectTSpoints(53049,641,124)">';
mtxt += '<area shape="circle" coords="646,124,3" href="javascript:selectTSpoints(53050,646,124)">';
mtxt += '<area shape="circle" coords="651,124,3" href="javascript:selectTSpoints(53051,651,124)">';
mtxt += '<area shape="circle" coords="656,124,3" href="javascript:selectTSpoints(53052,656,124)">';
mtxt += '<area shape="circle" coords="661,124,3" href="javascript:selectTSpoints(53053,661,124)">';
mtxt += '<area shape="circle" coords="666,124,3" href="javascript:selectTSpoints(53054,666,124)">';
mtxt += '<area shape="circle" coords="671,124,3" href="javascript:selectTSpoints(53055,671,124)">';
mtxt += '<area shape="circle" coords="677,124,3" href="javascript:selectTSpoints(53056,677,124)">';
mtxt += '<area shape="circle" coords="682,124,3" href="javascript:selectTSpoints(53057,682,124)">';
mtxt += '<area shape="circle" coords="687,124,3" href="javascript:selectTSpoints(53058,687,124)">';
mtxt += '<area shape="circle" coords="692,124,3" href="javascript:selectTSpoints(53059,692,124)">';
mtxt += '<area shape="circle" coords="697,124,3" href="javascript:selectTSpoints(53060,697,124)">';
mtxt += '<area shape="circle" coords="702,124,3" href="javascript:selectTSpoints(53061,702,124)">';
mtxt += '<area shape="circle" coords="707,124,3" href="javascript:selectTSpoints(53062,707,124)">';
mtxt += '<area shape="circle" coords="712,124,3" href="javascript:selectTSpoints(53063,712,124)">';
mtxt += '<area shape="circle" coords="717,124,3" href="javascript:selectTSpoints(53064,717,124)">';
mtxt += '<area shape="circle" coords="722,124,3" href="javascript:selectTSpoints(53065,722,124)">';
mtxt += '<area shape="circle" coords="727,124,3" href="javascript:selectTSpoints(53066,727,124)">';
mtxt += '<area shape="circle" coords="733,124,3" href="javascript:selectTSpoints(53067,733,124)">';
mtxt += '<area shape="circle" coords="738,124,3" href="javascript:selectTSpoints(53068,738,124)">';
mtxt += '<area shape="circle" coords="743,124,3" href="javascript:selectTSpoints(53069,743,124)">';
mtxt += '<area shape="circle" coords="748,124,3" href="javascript:selectTSpoints(53070,748,124)">';
mtxt += '<area shape="circle" coords="753,124,3" href="javascript:selectTSpoints(53071,753,124)">';
mtxt += '<area shape="circle" coords="758,124,3" href="javascript:selectTSpoints(53072,758,124)">';
mtxt += '<area shape="circle" coords=" 30,119,3" href="javascript:selectTSpoints(54073, 30,119)">';
mtxt += '<area shape="circle" coords=" 35,119,3" href="javascript:selectTSpoints(54074, 35,119)">';
mtxt += '<area shape="circle" coords=" 40,119,3" href="javascript:selectTSpoints(54075, 40,119)">';
mtxt += '<area shape="circle" coords=" 45,119,3" href="javascript:selectTSpoints(54076, 45,119)">';
mtxt += '<area shape="circle" coords=" 50,119,3" href="javascript:selectTSpoints(54077, 50,119)">';
mtxt += '<area shape="circle" coords=" 56,119,3" href="javascript:selectTSpoints(54078, 56,119)">';
mtxt += '<area shape="circle" coords=" 61,119,3" href="javascript:selectTSpoints(54079, 61,119)">';
mtxt += '<area shape="circle" coords=" 66,119,3" href="javascript:selectTSpoints(54080, 66,119)">';
mtxt += '<area shape="circle" coords=" 71,119,3" href="javascript:selectTSpoints(54081, 71,119)">';
mtxt += '<area shape="circle" coords=" 76,119,3" href="javascript:selectTSpoints(54082, 76,119)">';
mtxt += '<area shape="circle" coords=" 81,119,3" href="javascript:selectTSpoints(54083, 81,119)">';
mtxt += '<area shape="circle" coords=" 86,119,3" href="javascript:selectTSpoints(54084, 86,119)">';
mtxt += '<area shape="circle" coords=" 91,119,3" href="javascript:selectTSpoints(54085, 91,119)">';
mtxt += '<area shape="circle" coords=" 96,119,3" href="javascript:selectTSpoints(54086, 96,119)">';
mtxt += '<area shape="circle" coords="101,119,3" href="javascript:selectTSpoints(54087,101,119)">';
mtxt += '<area shape="circle" coords="106,119,3" href="javascript:selectTSpoints(54088,106,119)">';
mtxt += '<area shape="circle" coords="112,119,3" href="javascript:selectTSpoints(54089,112,119)">';
mtxt += '<area shape="circle" coords="117,119,3" href="javascript:selectTSpoints(54090,117,119)">';
mtxt += '<area shape="circle" coords="122,119,3" href="javascript:selectTSpoints(54091,122,119)">';
mtxt += '<area shape="circle" coords="127,119,3" href="javascript:selectTSpoints(54092,127,119)">';
mtxt += '<area shape="circle" coords="132,119,3" href="javascript:selectTSpoints(54093,132,119)">';
mtxt += '<area shape="circle" coords="137,119,3" href="javascript:selectTSpoints(54094,137,119)">';
mtxt += '<area shape="circle" coords="142,119,3" href="javascript:selectTSpoints(54095,142,119)">';
mtxt += '<area shape="circle" coords="147,119,3" href="javascript:selectTSpoints(54096,147,119)">';
mtxt += '<area shape="circle" coords="152,119,3" href="javascript:selectTSpoints(54097,152,119)">';
mtxt += '<area shape="circle" coords="157,119,3" href="javascript:selectTSpoints(54098,157,119)">';
mtxt += '<area shape="circle" coords="162,119,3" href="javascript:selectTSpoints(54099,162,119)">';
mtxt += '<area shape="circle" coords="168,119,3" href="javascript:selectTSpoints(54100,168,119)">';
mtxt += '<area shape="circle" coords="173,119,3" href="javascript:selectTSpoints(54101,173,119)">';
mtxt += '<area shape="circle" coords="178,119,3" href="javascript:selectTSpoints(54102,178,119)">';
mtxt += '<area shape="circle" coords="183,119,3" href="javascript:selectTSpoints(54103,183,119)">';
mtxt += '<area shape="circle" coords="188,119,3" href="javascript:selectTSpoints(54104,188,119)">';
mtxt += '<area shape="circle" coords="193,119,3" href="javascript:selectTSpoints(54105,193,119)">';
mtxt += '<area shape="circle" coords="198,119,3" href="javascript:selectTSpoints(54106,198,119)">';
mtxt += '<area shape="circle" coords="203,119,3" href="javascript:selectTSpoints(54107,203,119)">';
mtxt += '<area shape="circle" coords="208,119,3" href="javascript:selectTSpoints(54108,208,119)">';
mtxt += '<area shape="circle" coords="213,119,3" href="javascript:selectTSpoints(54109,213,119)">';
mtxt += '<area shape="circle" coords="218,119,3" href="javascript:selectTSpoints(54110,218,119)">';
mtxt += '<area shape="circle" coords="224,119,3" href="javascript:selectTSpoints(54111,224,119)">';
mtxt += '<area shape="circle" coords="229,119,3" href="javascript:selectTSpoints(54112,229,119)">';
mtxt += '<area shape="circle" coords="234,119,3" href="javascript:selectTSpoints(54113,234,119)">';
mtxt += '<area shape="circle" coords="239,119,3" href="javascript:selectTSpoints(54114,239,119)">';
mtxt += '<area shape="circle" coords="244,119,3" href="javascript:selectTSpoints(54115,244,119)">';
mtxt += '<area shape="circle" coords="249,119,3" href="javascript:selectTSpoints(54116,249,119)">';
mtxt += '<area shape="circle" coords="254,119,3" href="javascript:selectTSpoints(54117,254,119)">';
mtxt += '<area shape="circle" coords="259,119,3" href="javascript:selectTSpoints(54118,259,119)">';
mtxt += '<area shape="circle" coords="264,119,3" href="javascript:selectTSpoints(54119,264,119)">';
mtxt += '<area shape="circle" coords="269,119,3" href="javascript:selectTSpoints(54120,269,119)">';
mtxt += '<area shape="circle" coords="274,119,3" href="javascript:selectTSpoints(54121,274,119)">';
mtxt += '<area shape="circle" coords="280,119,3" href="javascript:selectTSpoints(54122,280,119)">';
mtxt += '<area shape="circle" coords="285,119,3" href="javascript:selectTSpoints(54123,285,119)">';
mtxt += '<area shape="circle" coords="290,119,3" href="javascript:selectTSpoints(54124,290,119)">';
mtxt += '<area shape="circle" coords="295,119,3" href="javascript:selectTSpoints(54125,295,119)">';
mtxt += '<area shape="circle" coords="300,119,3" href="javascript:selectTSpoints(54126,300,119)">';
mtxt += '<area shape="circle" coords="305,119,3" href="javascript:selectTSpoints(54127,305,119)">';
mtxt += '<area shape="circle" coords="310,119,3" href="javascript:selectTSpoints(54128,310,119)">';
mtxt += '<area shape="circle" coords="315,119,3" href="javascript:selectTSpoints(54129,315,119)">';
mtxt += '<area shape="circle" coords="320,119,3" href="javascript:selectTSpoints(54130,320,119)">';
mtxt += '<area shape="circle" coords="325,119,3" href="javascript:selectTSpoints(54131,325,119)">';
mtxt += '<area shape="circle" coords="330,119,3" href="javascript:selectTSpoints(54132,330,119)">';
mtxt += '<area shape="circle" coords="336,119,3" href="javascript:selectTSpoints(54133,336,119)">';
mtxt += '<area shape="circle" coords="341,119,3" href="javascript:selectTSpoints(54134,341,119)">';
mtxt += '<area shape="circle" coords="346,119,3" href="javascript:selectTSpoints(54135,346,119)">';
mtxt += '<area shape="circle" coords="351,119,3" href="javascript:selectTSpoints(54136,351,119)">';
mtxt += '<area shape="circle" coords="356,119,3" href="javascript:selectTSpoints(54137,356,119)">';
mtxt += '<area shape="circle" coords="361,119,3" href="javascript:selectTSpoints(54138,361,119)">';
mtxt += '<area shape="circle" coords="366,119,3" href="javascript:selectTSpoints(54139,366,119)">';
mtxt += '<area shape="circle" coords="371,119,3" href="javascript:selectTSpoints(54140,371,119)">';
mtxt += '<area shape="circle" coords="376,119,3" href="javascript:selectTSpoints(54141,376,119)">';
mtxt += '<area shape="circle" coords="381,119,3" href="javascript:selectTSpoints(54142,381,119)">';
mtxt += '<area shape="circle" coords="386,119,3" href="javascript:selectTSpoints(54143,386,119)">';
mtxt += '<area shape="circle" coords="392,119,3" href="javascript:selectTSpoints(54144,392,119)">';
mtxt += '<area shape="circle" coords="397,119,3" href="javascript:selectTSpoints(54001,397,119)">';
mtxt += '<area shape="circle" coords="402,119,3" href="javascript:selectTSpoints(54002,402,119)">';
mtxt += '<area shape="circle" coords="407,119,3" href="javascript:selectTSpoints(54003,407,119)">';
mtxt += '<area shape="circle" coords="412,119,3" href="javascript:selectTSpoints(54004,412,119)">';
mtxt += '<area shape="circle" coords="417,119,3" href="javascript:selectTSpoints(54005,417,119)">';
mtxt += '<area shape="circle" coords="422,119,3" href="javascript:selectTSpoints(54006,422,119)">';
mtxt += '<area shape="circle" coords="427,119,3" href="javascript:selectTSpoints(54007,427,119)">';
mtxt += '<area shape="circle" coords="432,119,3" href="javascript:selectTSpoints(54008,432,119)">';
mtxt += '<area shape="circle" coords="437,119,3" href="javascript:selectTSpoints(54009,437,119)">';
mtxt += '<area shape="circle" coords="442,119,3" href="javascript:selectTSpoints(54010,442,119)">';
mtxt += '<area shape="circle" coords="447,119,3" href="javascript:selectTSpoints(54011,447,119)">';
mtxt += '<area shape="circle" coords="453,119,3" href="javascript:selectTSpoints(54012,453,119)">';
mtxt += '<area shape="circle" coords="458,119,3" href="javascript:selectTSpoints(54013,458,119)">';
mtxt += '<area shape="circle" coords="463,119,3" href="javascript:selectTSpoints(54014,463,119)">';
mtxt += '<area shape="circle" coords="468,119,3" href="javascript:selectTSpoints(54015,468,119)">';
mtxt += '<area shape="circle" coords="473,119,3" href="javascript:selectTSpoints(54016,473,119)">';
mtxt += '<area shape="circle" coords="478,119,3" href="javascript:selectTSpoints(54017,478,119)">';
mtxt += '<area shape="circle" coords="483,119,3" href="javascript:selectTSpoints(54018,483,119)">';
mtxt += '<area shape="circle" coords="488,119,3" href="javascript:selectTSpoints(54019,488,119)">';
mtxt += '<area shape="circle" coords="493,119,3" href="javascript:selectTSpoints(54020,493,119)">';
mtxt += '<area shape="circle" coords="498,119,3" href="javascript:selectTSpoints(54021,498,119)">';
mtxt += '<area shape="circle" coords="503,119,3" href="javascript:selectTSpoints(54022,503,119)">';
mtxt += '<area shape="circle" coords="509,119,3" href="javascript:selectTSpoints(54023,509,119)">';
mtxt += '<area shape="circle" coords="514,119,3" href="javascript:selectTSpoints(54024,514,119)">';
mtxt += '<area shape="circle" coords="519,119,3" href="javascript:selectTSpoints(54025,519,119)">';
mtxt += '<area shape="circle" coords="524,119,3" href="javascript:selectTSpoints(54026,524,119)">';
mtxt += '<area shape="circle" coords="529,119,3" href="javascript:selectTSpoints(54027,529,119)">';
mtxt += '<area shape="circle" coords="534,119,3" href="javascript:selectTSpoints(54028,534,119)">';
mtxt += '<area shape="circle" coords="539,119,3" href="javascript:selectTSpoints(54029,539,119)">';
mtxt += '<area shape="circle" coords="544,119,3" href="javascript:selectTSpoints(54030,544,119)">';
mtxt += '<area shape="circle" coords="549,119,3" href="javascript:selectTSpoints(54031,549,119)">';
mtxt += '<area shape="circle" coords="554,119,3" href="javascript:selectTSpoints(54032,554,119)">';
mtxt += '<area shape="circle" coords="559,119,3" href="javascript:selectTSpoints(54033,559,119)">';
mtxt += '<area shape="circle" coords="565,119,3" href="javascript:selectTSpoints(54034,565,119)">';
mtxt += '<area shape="circle" coords="570,119,3" href="javascript:selectTSpoints(54035,570,119)">';
mtxt += '<area shape="circle" coords="575,119,3" href="javascript:selectTSpoints(54036,575,119)">';
mtxt += '<area shape="circle" coords="580,119,3" href="javascript:selectTSpoints(54037,580,119)">';
mtxt += '<area shape="circle" coords="585,119,3" href="javascript:selectTSpoints(54038,585,119)">';
mtxt += '<area shape="circle" coords="590,119,3" href="javascript:selectTSpoints(54039,590,119)">';
mtxt += '<area shape="circle" coords="595,119,3" href="javascript:selectTSpoints(54040,595,119)">';
mtxt += '<area shape="circle" coords="600,119,3" href="javascript:selectTSpoints(54041,600,119)">';
mtxt += '<area shape="circle" coords="605,119,3" href="javascript:selectTSpoints(54042,605,119)">';
mtxt += '<area shape="circle" coords="610,119,3" href="javascript:selectTSpoints(54043,610,119)">';
mtxt += '<area shape="circle" coords="615,119,3" href="javascript:selectTSpoints(54044,615,119)">';
mtxt += '<area shape="circle" coords="621,119,3" href="javascript:selectTSpoints(54045,621,119)">';
mtxt += '<area shape="circle" coords="626,119,3" href="javascript:selectTSpoints(54046,626,119)">';
mtxt += '<area shape="circle" coords="631,119,3" href="javascript:selectTSpoints(54047,631,119)">';
mtxt += '<area shape="circle" coords="636,119,3" href="javascript:selectTSpoints(54048,636,119)">';
mtxt += '<area shape="circle" coords="641,119,3" href="javascript:selectTSpoints(54049,641,119)">';
mtxt += '<area shape="circle" coords="646,119,3" href="javascript:selectTSpoints(54050,646,119)">';
mtxt += '<area shape="circle" coords="651,119,3" href="javascript:selectTSpoints(54051,651,119)">';
mtxt += '<area shape="circle" coords="656,119,3" href="javascript:selectTSpoints(54052,656,119)">';
mtxt += '<area shape="circle" coords="661,119,3" href="javascript:selectTSpoints(54053,661,119)">';
mtxt += '<area shape="circle" coords="666,119,3" href="javascript:selectTSpoints(54054,666,119)">';
mtxt += '<area shape="circle" coords="671,119,3" href="javascript:selectTSpoints(54055,671,119)">';
mtxt += '<area shape="circle" coords="677,119,3" href="javascript:selectTSpoints(54056,677,119)">';
mtxt += '<area shape="circle" coords="682,119,3" href="javascript:selectTSpoints(54057,682,119)">';
mtxt += '<area shape="circle" coords="687,119,3" href="javascript:selectTSpoints(54058,687,119)">';
mtxt += '<area shape="circle" coords="692,119,3" href="javascript:selectTSpoints(54059,692,119)">';
mtxt += '<area shape="circle" coords="697,119,3" href="javascript:selectTSpoints(54060,697,119)">';
mtxt += '<area shape="circle" coords="702,119,3" href="javascript:selectTSpoints(54061,702,119)">';
mtxt += '<area shape="circle" coords="707,119,3" href="javascript:selectTSpoints(54062,707,119)">';
mtxt += '<area shape="circle" coords="712,119,3" href="javascript:selectTSpoints(54063,712,119)">';
mtxt += '<area shape="circle" coords="717,119,3" href="javascript:selectTSpoints(54064,717,119)">';
mtxt += '<area shape="circle" coords="722,119,3" href="javascript:selectTSpoints(54065,722,119)">';
mtxt += '<area shape="circle" coords="727,119,3" href="javascript:selectTSpoints(54066,727,119)">';
mtxt += '<area shape="circle" coords="733,119,3" href="javascript:selectTSpoints(54067,733,119)">';
mtxt += '<area shape="circle" coords="738,119,3" href="javascript:selectTSpoints(54068,738,119)">';
mtxt += '<area shape="circle" coords="743,119,3" href="javascript:selectTSpoints(54069,743,119)">';
mtxt += '<area shape="circle" coords="748,119,3" href="javascript:selectTSpoints(54070,748,119)">';
mtxt += '<area shape="circle" coords="753,119,3" href="javascript:selectTSpoints(54071,753,119)">';
mtxt += '<area shape="circle" coords="758,119,3" href="javascript:selectTSpoints(54072,758,119)">';
mtxt += '<area shape="circle" coords=" 30,114,3" href="javascript:selectTSpoints(55073, 30,114)">';
mtxt += '<area shape="circle" coords=" 35,114,3" href="javascript:selectTSpoints(55074, 35,114)">';
mtxt += '<area shape="circle" coords=" 40,114,3" href="javascript:selectTSpoints(55075, 40,114)">';
mtxt += '<area shape="circle" coords=" 45,114,3" href="javascript:selectTSpoints(55076, 45,114)">';
mtxt += '<area shape="circle" coords=" 50,114,3" href="javascript:selectTSpoints(55077, 50,114)">';
mtxt += '<area shape="circle" coords=" 56,114,3" href="javascript:selectTSpoints(55078, 56,114)">';
mtxt += '<area shape="circle" coords=" 61,114,3" href="javascript:selectTSpoints(55079, 61,114)">';
mtxt += '<area shape="circle" coords=" 66,114,3" href="javascript:selectTSpoints(55080, 66,114)">';
mtxt += '<area shape="circle" coords=" 71,114,3" href="javascript:selectTSpoints(55081, 71,114)">';
mtxt += '<area shape="circle" coords=" 76,114,3" href="javascript:selectTSpoints(55082, 76,114)">';
mtxt += '<area shape="circle" coords=" 81,114,3" href="javascript:selectTSpoints(55083, 81,114)">';
mtxt += '<area shape="circle" coords=" 86,114,3" href="javascript:selectTSpoints(55084, 86,114)">';
mtxt += '<area shape="circle" coords=" 91,114,3" href="javascript:selectTSpoints(55085, 91,114)">';
mtxt += '<area shape="circle" coords=" 96,114,3" href="javascript:selectTSpoints(55086, 96,114)">';
mtxt += '<area shape="circle" coords="101,114,3" href="javascript:selectTSpoints(55087,101,114)">';
mtxt += '<area shape="circle" coords="106,114,3" href="javascript:selectTSpoints(55088,106,114)">';
mtxt += '<area shape="circle" coords="112,114,3" href="javascript:selectTSpoints(55089,112,114)">';
mtxt += '<area shape="circle" coords="117,114,3" href="javascript:selectTSpoints(55090,117,114)">';
mtxt += '<area shape="circle" coords="122,114,3" href="javascript:selectTSpoints(55091,122,114)">';
mtxt += '<area shape="circle" coords="127,114,3" href="javascript:selectTSpoints(55092,127,114)">';
mtxt += '<area shape="circle" coords="132,114,3" href="javascript:selectTSpoints(55093,132,114)">';
mtxt += '<area shape="circle" coords="137,114,3" href="javascript:selectTSpoints(55094,137,114)">';
mtxt += '<area shape="circle" coords="142,114,3" href="javascript:selectTSpoints(55095,142,114)">';
mtxt += '<area shape="circle" coords="147,114,3" href="javascript:selectTSpoints(55096,147,114)">';
mtxt += '<area shape="circle" coords="152,114,3" href="javascript:selectTSpoints(55097,152,114)">';
mtxt += '<area shape="circle" coords="157,114,3" href="javascript:selectTSpoints(55098,157,114)">';
mtxt += '<area shape="circle" coords="162,114,3" href="javascript:selectTSpoints(55099,162,114)">';
mtxt += '<area shape="circle" coords="168,114,3" href="javascript:selectTSpoints(55100,168,114)">';
mtxt += '<area shape="circle" coords="173,114,3" href="javascript:selectTSpoints(55101,173,114)">';
mtxt += '<area shape="circle" coords="178,114,3" href="javascript:selectTSpoints(55102,178,114)">';
mtxt += '<area shape="circle" coords="183,114,3" href="javascript:selectTSpoints(55103,183,114)">';
mtxt += '<area shape="circle" coords="188,114,3" href="javascript:selectTSpoints(55104,188,114)">';
mtxt += '<area shape="circle" coords="193,114,3" href="javascript:selectTSpoints(55105,193,114)">';
mtxt += '<area shape="circle" coords="198,114,3" href="javascript:selectTSpoints(55106,198,114)">';
mtxt += '<area shape="circle" coords="203,114,3" href="javascript:selectTSpoints(55107,203,114)">';
mtxt += '<area shape="circle" coords="208,114,3" href="javascript:selectTSpoints(55108,208,114)">';
mtxt += '<area shape="circle" coords="213,114,3" href="javascript:selectTSpoints(55109,213,114)">';
mtxt += '<area shape="circle" coords="218,114,3" href="javascript:selectTSpoints(55110,218,114)">';
mtxt += '<area shape="circle" coords="224,114,3" href="javascript:selectTSpoints(55111,224,114)">';
mtxt += '<area shape="circle" coords="229,114,3" href="javascript:selectTSpoints(55112,229,114)">';
mtxt += '<area shape="circle" coords="234,114,3" href="javascript:selectTSpoints(55113,234,114)">';
mtxt += '<area shape="circle" coords="239,114,3" href="javascript:selectTSpoints(55114,239,114)">';
mtxt += '<area shape="circle" coords="244,114,3" href="javascript:selectTSpoints(55115,244,114)">';
mtxt += '<area shape="circle" coords="249,114,3" href="javascript:selectTSpoints(55116,249,114)">';
mtxt += '<area shape="circle" coords="254,114,3" href="javascript:selectTSpoints(55117,254,114)">';
mtxt += '<area shape="circle" coords="259,114,3" href="javascript:selectTSpoints(55118,259,114)">';
mtxt += '<area shape="circle" coords="264,114,3" href="javascript:selectTSpoints(55119,264,114)">';
mtxt += '<area shape="circle" coords="269,114,3" href="javascript:selectTSpoints(55120,269,114)">';
mtxt += '<area shape="circle" coords="274,114,3" href="javascript:selectTSpoints(55121,274,114)">';
mtxt += '<area shape="circle" coords="280,114,3" href="javascript:selectTSpoints(55122,280,114)">';
mtxt += '<area shape="circle" coords="285,114,3" href="javascript:selectTSpoints(55123,285,114)">';
mtxt += '<area shape="circle" coords="290,114,3" href="javascript:selectTSpoints(55124,290,114)">';
mtxt += '<area shape="circle" coords="295,114,3" href="javascript:selectTSpoints(55125,295,114)">';
mtxt += '<area shape="circle" coords="300,114,3" href="javascript:selectTSpoints(55126,300,114)">';
mtxt += '<area shape="circle" coords="305,114,3" href="javascript:selectTSpoints(55127,305,114)">';
mtxt += '<area shape="circle" coords="310,114,3" href="javascript:selectTSpoints(55128,310,114)">';
mtxt += '<area shape="circle" coords="315,114,3" href="javascript:selectTSpoints(55129,315,114)">';
mtxt += '<area shape="circle" coords="320,114,3" href="javascript:selectTSpoints(55130,320,114)">';
mtxt += '<area shape="circle" coords="325,114,3" href="javascript:selectTSpoints(55131,325,114)">';
mtxt += '<area shape="circle" coords="330,114,3" href="javascript:selectTSpoints(55132,330,114)">';
mtxt += '<area shape="circle" coords="336,114,3" href="javascript:selectTSpoints(55133,336,114)">';
mtxt += '<area shape="circle" coords="341,114,3" href="javascript:selectTSpoints(55134,341,114)">';
mtxt += '<area shape="circle" coords="346,114,3" href="javascript:selectTSpoints(55135,346,114)">';
mtxt += '<area shape="circle" coords="351,114,3" href="javascript:selectTSpoints(55136,351,114)">';
mtxt += '<area shape="circle" coords="356,114,3" href="javascript:selectTSpoints(55137,356,114)">';
mtxt += '<area shape="circle" coords="361,114,3" href="javascript:selectTSpoints(55138,361,114)">';
mtxt += '<area shape="circle" coords="366,114,3" href="javascript:selectTSpoints(55139,366,114)">';
mtxt += '<area shape="circle" coords="371,114,3" href="javascript:selectTSpoints(55140,371,114)">';
mtxt += '<area shape="circle" coords="376,114,3" href="javascript:selectTSpoints(55141,376,114)">';
mtxt += '<area shape="circle" coords="381,114,3" href="javascript:selectTSpoints(55142,381,114)">';
mtxt += '<area shape="circle" coords="386,114,3" href="javascript:selectTSpoints(55143,386,114)">';
mtxt += '<area shape="circle" coords="392,114,3" href="javascript:selectTSpoints(55144,392,114)">';
mtxt += '<area shape="circle" coords="397,114,3" href="javascript:selectTSpoints(55001,397,114)">';
mtxt += '<area shape="circle" coords="402,114,3" href="javascript:selectTSpoints(55002,402,114)">';
mtxt += '<area shape="circle" coords="407,114,3" href="javascript:selectTSpoints(55003,407,114)">';
mtxt += '<area shape="circle" coords="412,114,3" href="javascript:selectTSpoints(55004,412,114)">';
mtxt += '<area shape="circle" coords="417,114,3" href="javascript:selectTSpoints(55005,417,114)">';
mtxt += '<area shape="circle" coords="422,114,3" href="javascript:selectTSpoints(55006,422,114)">';
mtxt += '<area shape="circle" coords="427,114,3" href="javascript:selectTSpoints(55007,427,114)">';
mtxt += '<area shape="circle" coords="432,114,3" href="javascript:selectTSpoints(55008,432,114)">';
mtxt += '<area shape="circle" coords="437,114,3" href="javascript:selectTSpoints(55009,437,114)">';
mtxt += '<area shape="circle" coords="442,114,3" href="javascript:selectTSpoints(55010,442,114)">';
mtxt += '<area shape="circle" coords="447,114,3" href="javascript:selectTSpoints(55011,447,114)">';
mtxt += '<area shape="circle" coords="453,114,3" href="javascript:selectTSpoints(55012,453,114)">';
mtxt += '<area shape="circle" coords="458,114,3" href="javascript:selectTSpoints(55013,458,114)">';
mtxt += '<area shape="circle" coords="463,114,3" href="javascript:selectTSpoints(55014,463,114)">';
mtxt += '<area shape="circle" coords="468,114,3" href="javascript:selectTSpoints(55015,468,114)">';
mtxt += '<area shape="circle" coords="473,114,3" href="javascript:selectTSpoints(55016,473,114)">';
mtxt += '<area shape="circle" coords="478,114,3" href="javascript:selectTSpoints(55017,478,114)">';
mtxt += '<area shape="circle" coords="483,114,3" href="javascript:selectTSpoints(55018,483,114)">';
mtxt += '<area shape="circle" coords="488,114,3" href="javascript:selectTSpoints(55019,488,114)">';
mtxt += '<area shape="circle" coords="493,114,3" href="javascript:selectTSpoints(55020,493,114)">';
mtxt += '<area shape="circle" coords="498,114,3" href="javascript:selectTSpoints(55021,498,114)">';
mtxt += '<area shape="circle" coords="503,114,3" href="javascript:selectTSpoints(55022,503,114)">';
mtxt += '<area shape="circle" coords="509,114,3" href="javascript:selectTSpoints(55023,509,114)">';
mtxt += '<area shape="circle" coords="514,114,3" href="javascript:selectTSpoints(55024,514,114)">';
mtxt += '<area shape="circle" coords="519,114,3" href="javascript:selectTSpoints(55025,519,114)">';
mtxt += '<area shape="circle" coords="524,114,3" href="javascript:selectTSpoints(55026,524,114)">';
mtxt += '<area shape="circle" coords="529,114,3" href="javascript:selectTSpoints(55027,529,114)">';
mtxt += '<area shape="circle" coords="534,114,3" href="javascript:selectTSpoints(55028,534,114)">';
mtxt += '<area shape="circle" coords="539,114,3" href="javascript:selectTSpoints(55029,539,114)">';
mtxt += '<area shape="circle" coords="544,114,3" href="javascript:selectTSpoints(55030,544,114)">';
mtxt += '<area shape="circle" coords="549,114,3" href="javascript:selectTSpoints(55031,549,114)">';
mtxt += '<area shape="circle" coords="554,114,3" href="javascript:selectTSpoints(55032,554,114)">';
mtxt += '<area shape="circle" coords="559,114,3" href="javascript:selectTSpoints(55033,559,114)">';
mtxt += '<area shape="circle" coords="565,114,3" href="javascript:selectTSpoints(55034,565,114)">';
mtxt += '<area shape="circle" coords="570,114,3" href="javascript:selectTSpoints(55035,570,114)">';
mtxt += '<area shape="circle" coords="575,114,3" href="javascript:selectTSpoints(55036,575,114)">';
mtxt += '<area shape="circle" coords="580,114,3" href="javascript:selectTSpoints(55037,580,114)">';
mtxt += '<area shape="circle" coords="585,114,3" href="javascript:selectTSpoints(55038,585,114)">';
mtxt += '<area shape="circle" coords="590,114,3" href="javascript:selectTSpoints(55039,590,114)">';
mtxt += '<area shape="circle" coords="595,114,3" href="javascript:selectTSpoints(55040,595,114)">';
mtxt += '<area shape="circle" coords="600,114,3" href="javascript:selectTSpoints(55041,600,114)">';
mtxt += '<area shape="circle" coords="605,114,3" href="javascript:selectTSpoints(55042,605,114)">';
mtxt += '<area shape="circle" coords="610,114,3" href="javascript:selectTSpoints(55043,610,114)">';
mtxt += '<area shape="circle" coords="615,114,3" href="javascript:selectTSpoints(55044,615,114)">';
mtxt += '<area shape="circle" coords="621,114,3" href="javascript:selectTSpoints(55045,621,114)">';
mtxt += '<area shape="circle" coords="626,114,3" href="javascript:selectTSpoints(55046,626,114)">';
mtxt += '<area shape="circle" coords="631,114,3" href="javascript:selectTSpoints(55047,631,114)">';
mtxt += '<area shape="circle" coords="636,114,3" href="javascript:selectTSpoints(55048,636,114)">';
mtxt += '<area shape="circle" coords="641,114,3" href="javascript:selectTSpoints(55049,641,114)">';
mtxt += '<area shape="circle" coords="646,114,3" href="javascript:selectTSpoints(55050,646,114)">';
mtxt += '<area shape="circle" coords="651,114,3" href="javascript:selectTSpoints(55051,651,114)">';
mtxt += '<area shape="circle" coords="656,114,3" href="javascript:selectTSpoints(55052,656,114)">';
mtxt += '<area shape="circle" coords="661,114,3" href="javascript:selectTSpoints(55053,661,114)">';
mtxt += '<area shape="circle" coords="666,114,3" href="javascript:selectTSpoints(55054,666,114)">';
mtxt += '<area shape="circle" coords="671,114,3" href="javascript:selectTSpoints(55055,671,114)">';
mtxt += '<area shape="circle" coords="677,114,3" href="javascript:selectTSpoints(55056,677,114)">';
mtxt += '<area shape="circle" coords="682,114,3" href="javascript:selectTSpoints(55057,682,114)">';
mtxt += '<area shape="circle" coords="687,114,3" href="javascript:selectTSpoints(55058,687,114)">';
mtxt += '<area shape="circle" coords="692,114,3" href="javascript:selectTSpoints(55059,692,114)">';
mtxt += '<area shape="circle" coords="697,114,3" href="javascript:selectTSpoints(55060,697,114)">';
mtxt += '<area shape="circle" coords="702,114,3" href="javascript:selectTSpoints(55061,702,114)">';
mtxt += '<area shape="circle" coords="707,114,3" href="javascript:selectTSpoints(55062,707,114)">';
mtxt += '<area shape="circle" coords="712,114,3" href="javascript:selectTSpoints(55063,712,114)">';
mtxt += '<area shape="circle" coords="717,114,3" href="javascript:selectTSpoints(55064,717,114)">';
mtxt += '<area shape="circle" coords="722,114,3" href="javascript:selectTSpoints(55065,722,114)">';
mtxt += '<area shape="circle" coords="727,114,3" href="javascript:selectTSpoints(55066,727,114)">';
mtxt += '<area shape="circle" coords="733,114,3" href="javascript:selectTSpoints(55067,733,114)">';
mtxt += '<area shape="circle" coords="738,114,3" href="javascript:selectTSpoints(55068,738,114)">';
mtxt += '<area shape="circle" coords="743,114,3" href="javascript:selectTSpoints(55069,743,114)">';
mtxt += '<area shape="circle" coords="748,114,3" href="javascript:selectTSpoints(55070,748,114)">';
mtxt += '<area shape="circle" coords="753,114,3" href="javascript:selectTSpoints(55071,753,114)">';
mtxt += '<area shape="circle" coords="758,114,3" href="javascript:selectTSpoints(55072,758,114)">';
mtxt += '<area shape="circle" coords=" 30,109,3" href="javascript:selectTSpoints(56073, 30,109)">';
mtxt += '<area shape="circle" coords=" 35,109,3" href="javascript:selectTSpoints(56074, 35,109)">';
mtxt += '<area shape="circle" coords=" 40,109,3" href="javascript:selectTSpoints(56075, 40,109)">';
mtxt += '<area shape="circle" coords=" 45,109,3" href="javascript:selectTSpoints(56076, 45,109)">';
mtxt += '<area shape="circle" coords=" 50,109,3" href="javascript:selectTSpoints(56077, 50,109)">';
mtxt += '<area shape="circle" coords=" 56,109,3" href="javascript:selectTSpoints(56078, 56,109)">';
mtxt += '<area shape="circle" coords=" 61,109,3" href="javascript:selectTSpoints(56079, 61,109)">';
mtxt += '<area shape="circle" coords=" 66,109,3" href="javascript:selectTSpoints(56080, 66,109)">';
mtxt += '<area shape="circle" coords=" 71,109,3" href="javascript:selectTSpoints(56081, 71,109)">';
mtxt += '<area shape="circle" coords=" 76,109,3" href="javascript:selectTSpoints(56082, 76,109)">';
mtxt += '<area shape="circle" coords=" 81,109,3" href="javascript:selectTSpoints(56083, 81,109)">';
mtxt += '<area shape="circle" coords=" 86,109,3" href="javascript:selectTSpoints(56084, 86,109)">';
mtxt += '<area shape="circle" coords=" 91,109,3" href="javascript:selectTSpoints(56085, 91,109)">';
mtxt += '<area shape="circle" coords=" 96,109,3" href="javascript:selectTSpoints(56086, 96,109)">';
mtxt += '<area shape="circle" coords="101,109,3" href="javascript:selectTSpoints(56087,101,109)">';
mtxt += '<area shape="circle" coords="106,109,3" href="javascript:selectTSpoints(56088,106,109)">';
mtxt += '<area shape="circle" coords="112,109,3" href="javascript:selectTSpoints(56089,112,109)">';
mtxt += '<area shape="circle" coords="117,109,3" href="javascript:selectTSpoints(56090,117,109)">';
mtxt += '<area shape="circle" coords="122,109,3" href="javascript:selectTSpoints(56091,122,109)">';
mtxt += '<area shape="circle" coords="127,109,3" href="javascript:selectTSpoints(56092,127,109)">';
mtxt += '<area shape="circle" coords="132,109,3" href="javascript:selectTSpoints(56093,132,109)">';
mtxt += '<area shape="circle" coords="137,109,3" href="javascript:selectTSpoints(56094,137,109)">';
mtxt += '<area shape="circle" coords="142,109,3" href="javascript:selectTSpoints(56095,142,109)">';
mtxt += '<area shape="circle" coords="147,109,3" href="javascript:selectTSpoints(56096,147,109)">';
mtxt += '<area shape="circle" coords="152,109,3" href="javascript:selectTSpoints(56097,152,109)">';
mtxt += '<area shape="circle" coords="157,109,3" href="javascript:selectTSpoints(56098,157,109)">';
mtxt += '<area shape="circle" coords="162,109,3" href="javascript:selectTSpoints(56099,162,109)">';
mtxt += '<area shape="circle" coords="168,109,3" href="javascript:selectTSpoints(56100,168,109)">';
mtxt += '<area shape="circle" coords="173,109,3" href="javascript:selectTSpoints(56101,173,109)">';
mtxt += '<area shape="circle" coords="178,109,3" href="javascript:selectTSpoints(56102,178,109)">';
mtxt += '<area shape="circle" coords="183,109,3" href="javascript:selectTSpoints(56103,183,109)">';
mtxt += '<area shape="circle" coords="188,109,3" href="javascript:selectTSpoints(56104,188,109)">';
mtxt += '<area shape="circle" coords="193,109,3" href="javascript:selectTSpoints(56105,193,109)">';
mtxt += '<area shape="circle" coords="198,109,3" href="javascript:selectTSpoints(56106,198,109)">';
mtxt += '<area shape="circle" coords="203,109,3" href="javascript:selectTSpoints(56107,203,109)">';
mtxt += '<area shape="circle" coords="208,109,3" href="javascript:selectTSpoints(56108,208,109)">';
mtxt += '<area shape="circle" coords="213,109,3" href="javascript:selectTSpoints(56109,213,109)">';
mtxt += '<area shape="circle" coords="218,109,3" href="javascript:selectTSpoints(56110,218,109)">';
mtxt += '<area shape="circle" coords="224,109,3" href="javascript:selectTSpoints(56111,224,109)">';
mtxt += '<area shape="circle" coords="229,109,3" href="javascript:selectTSpoints(56112,229,109)">';
mtxt += '<area shape="circle" coords="234,109,3" href="javascript:selectTSpoints(56113,234,109)">';
mtxt += '<area shape="circle" coords="239,109,3" href="javascript:selectTSpoints(56114,239,109)">';
mtxt += '<area shape="circle" coords="244,109,3" href="javascript:selectTSpoints(56115,244,109)">';
mtxt += '<area shape="circle" coords="249,109,3" href="javascript:selectTSpoints(56116,249,109)">';
mtxt += '<area shape="circle" coords="254,109,3" href="javascript:selectTSpoints(56117,254,109)">';
mtxt += '<area shape="circle" coords="259,109,3" href="javascript:selectTSpoints(56118,259,109)">';
mtxt += '<area shape="circle" coords="264,109,3" href="javascript:selectTSpoints(56119,264,109)">';
mtxt += '<area shape="circle" coords="269,109,3" href="javascript:selectTSpoints(56120,269,109)">';
mtxt += '<area shape="circle" coords="274,109,3" href="javascript:selectTSpoints(56121,274,109)">';
mtxt += '<area shape="circle" coords="280,109,3" href="javascript:selectTSpoints(56122,280,109)">';
mtxt += '<area shape="circle" coords="285,109,3" href="javascript:selectTSpoints(56123,285,109)">';
mtxt += '<area shape="circle" coords="290,109,3" href="javascript:selectTSpoints(56124,290,109)">';
mtxt += '<area shape="circle" coords="295,109,3" href="javascript:selectTSpoints(56125,295,109)">';
mtxt += '<area shape="circle" coords="300,109,3" href="javascript:selectTSpoints(56126,300,109)">';
mtxt += '<area shape="circle" coords="305,109,3" href="javascript:selectTSpoints(56127,305,109)">';
mtxt += '<area shape="circle" coords="310,109,3" href="javascript:selectTSpoints(56128,310,109)">';
mtxt += '<area shape="circle" coords="315,109,3" href="javascript:selectTSpoints(56129,315,109)">';
mtxt += '<area shape="circle" coords="320,109,3" href="javascript:selectTSpoints(56130,320,109)">';
mtxt += '<area shape="circle" coords="325,109,3" href="javascript:selectTSpoints(56131,325,109)">';
mtxt += '<area shape="circle" coords="330,109,3" href="javascript:selectTSpoints(56132,330,109)">';
mtxt += '<area shape="circle" coords="336,109,3" href="javascript:selectTSpoints(56133,336,109)">';
mtxt += '<area shape="circle" coords="341,109,3" href="javascript:selectTSpoints(56134,341,109)">';
mtxt += '<area shape="circle" coords="346,109,3" href="javascript:selectTSpoints(56135,346,109)">';
mtxt += '<area shape="circle" coords="351,109,3" href="javascript:selectTSpoints(56136,351,109)">';
mtxt += '<area shape="circle" coords="356,109,3" href="javascript:selectTSpoints(56137,356,109)">';
mtxt += '<area shape="circle" coords="361,109,3" href="javascript:selectTSpoints(56138,361,109)">';
mtxt += '<area shape="circle" coords="366,109,3" href="javascript:selectTSpoints(56139,366,109)">';
mtxt += '<area shape="circle" coords="371,109,3" href="javascript:selectTSpoints(56140,371,109)">';
mtxt += '<area shape="circle" coords="376,109,3" href="javascript:selectTSpoints(56141,376,109)">';
mtxt += '<area shape="circle" coords="381,109,3" href="javascript:selectTSpoints(56142,381,109)">';
mtxt += '<area shape="circle" coords="386,109,3" href="javascript:selectTSpoints(56143,386,109)">';
mtxt += '<area shape="circle" coords="392,109,3" href="javascript:selectTSpoints(56144,392,109)">';
mtxt += '<area shape="circle" coords="397,109,3" href="javascript:selectTSpoints(56001,397,109)">';
mtxt += '<area shape="circle" coords="402,109,3" href="javascript:selectTSpoints(56002,402,109)">';
mtxt += '<area shape="circle" coords="407,109,3" href="javascript:selectTSpoints(56003,407,109)">';
mtxt += '<area shape="circle" coords="412,109,3" href="javascript:selectTSpoints(56004,412,109)">';
mtxt += '<area shape="circle" coords="417,109,3" href="javascript:selectTSpoints(56005,417,109)">';
mtxt += '<area shape="circle" coords="422,109,3" href="javascript:selectTSpoints(56006,422,109)">';
mtxt += '<area shape="circle" coords="427,109,3" href="javascript:selectTSpoints(56007,427,109)">';
mtxt += '<area shape="circle" coords="432,109,3" href="javascript:selectTSpoints(56008,432,109)">';
mtxt += '<area shape="circle" coords="437,109,3" href="javascript:selectTSpoints(56009,437,109)">';
mtxt += '<area shape="circle" coords="442,109,3" href="javascript:selectTSpoints(56010,442,109)">';
mtxt += '<area shape="circle" coords="447,109,3" href="javascript:selectTSpoints(56011,447,109)">';
mtxt += '<area shape="circle" coords="453,109,3" href="javascript:selectTSpoints(56012,453,109)">';
mtxt += '<area shape="circle" coords="458,109,3" href="javascript:selectTSpoints(56013,458,109)">';
mtxt += '<area shape="circle" coords="463,109,3" href="javascript:selectTSpoints(56014,463,109)">';
mtxt += '<area shape="circle" coords="468,109,3" href="javascript:selectTSpoints(56015,468,109)">';
mtxt += '<area shape="circle" coords="473,109,3" href="javascript:selectTSpoints(56016,473,109)">';
mtxt += '<area shape="circle" coords="478,109,3" href="javascript:selectTSpoints(56017,478,109)">';
mtxt += '<area shape="circle" coords="483,109,3" href="javascript:selectTSpoints(56018,483,109)">';
mtxt += '<area shape="circle" coords="488,109,3" href="javascript:selectTSpoints(56019,488,109)">';
mtxt += '<area shape="circle" coords="493,109,3" href="javascript:selectTSpoints(56020,493,109)">';
mtxt += '<area shape="circle" coords="498,109,3" href="javascript:selectTSpoints(56021,498,109)">';
mtxt += '<area shape="circle" coords="503,109,3" href="javascript:selectTSpoints(56022,503,109)">';
mtxt += '<area shape="circle" coords="509,109,3" href="javascript:selectTSpoints(56023,509,109)">';
mtxt += '<area shape="circle" coords="514,109,3" href="javascript:selectTSpoints(56024,514,109)">';
mtxt += '<area shape="circle" coords="519,109,3" href="javascript:selectTSpoints(56025,519,109)">';
mtxt += '<area shape="circle" coords="524,109,3" href="javascript:selectTSpoints(56026,524,109)">';
mtxt += '<area shape="circle" coords="529,109,3" href="javascript:selectTSpoints(56027,529,109)">';
mtxt += '<area shape="circle" coords="534,109,3" href="javascript:selectTSpoints(56028,534,109)">';
mtxt += '<area shape="circle" coords="539,109,3" href="javascript:selectTSpoints(56029,539,109)">';
mtxt += '<area shape="circle" coords="544,109,3" href="javascript:selectTSpoints(56030,544,109)">';
mtxt += '<area shape="circle" coords="549,109,3" href="javascript:selectTSpoints(56031,549,109)">';
mtxt += '<area shape="circle" coords="554,109,3" href="javascript:selectTSpoints(56032,554,109)">';
mtxt += '<area shape="circle" coords="559,109,3" href="javascript:selectTSpoints(56033,559,109)">';
mtxt += '<area shape="circle" coords="565,109,3" href="javascript:selectTSpoints(56034,565,109)">';
mtxt += '<area shape="circle" coords="570,109,3" href="javascript:selectTSpoints(56035,570,109)">';
mtxt += '<area shape="circle" coords="575,109,3" href="javascript:selectTSpoints(56036,575,109)">';
mtxt += '<area shape="circle" coords="580,109,3" href="javascript:selectTSpoints(56037,580,109)">';
mtxt += '<area shape="circle" coords="585,109,3" href="javascript:selectTSpoints(56038,585,109)">';
mtxt += '<area shape="circle" coords="590,109,3" href="javascript:selectTSpoints(56039,590,109)">';
mtxt += '<area shape="circle" coords="595,109,3" href="javascript:selectTSpoints(56040,595,109)">';
mtxt += '<area shape="circle" coords="600,109,3" href="javascript:selectTSpoints(56041,600,109)">';
mtxt += '<area shape="circle" coords="605,109,3" href="javascript:selectTSpoints(56042,605,109)">';
mtxt += '<area shape="circle" coords="610,109,3" href="javascript:selectTSpoints(56043,610,109)">';
mtxt += '<area shape="circle" coords="615,109,3" href="javascript:selectTSpoints(56044,615,109)">';
mtxt += '<area shape="circle" coords="621,109,3" href="javascript:selectTSpoints(56045,621,109)">';
mtxt += '<area shape="circle" coords="626,109,3" href="javascript:selectTSpoints(56046,626,109)">';
mtxt += '<area shape="circle" coords="631,109,3" href="javascript:selectTSpoints(56047,631,109)">';
mtxt += '<area shape="circle" coords="636,109,3" href="javascript:selectTSpoints(56048,636,109)">';
mtxt += '<area shape="circle" coords="641,109,3" href="javascript:selectTSpoints(56049,641,109)">';
mtxt += '<area shape="circle" coords="646,109,3" href="javascript:selectTSpoints(56050,646,109)">';
mtxt += '<area shape="circle" coords="651,109,3" href="javascript:selectTSpoints(56051,651,109)">';
mtxt += '<area shape="circle" coords="656,109,3" href="javascript:selectTSpoints(56052,656,109)">';
mtxt += '<area shape="circle" coords="661,109,3" href="javascript:selectTSpoints(56053,661,109)">';
mtxt += '<area shape="circle" coords="666,109,3" href="javascript:selectTSpoints(56054,666,109)">';
mtxt += '<area shape="circle" coords="671,109,3" href="javascript:selectTSpoints(56055,671,109)">';
mtxt += '<area shape="circle" coords="677,109,3" href="javascript:selectTSpoints(56056,677,109)">';
mtxt += '<area shape="circle" coords="682,109,3" href="javascript:selectTSpoints(56057,682,109)">';
mtxt += '<area shape="circle" coords="687,109,3" href="javascript:selectTSpoints(56058,687,109)">';
mtxt += '<area shape="circle" coords="692,109,3" href="javascript:selectTSpoints(56059,692,109)">';
mtxt += '<area shape="circle" coords="697,109,3" href="javascript:selectTSpoints(56060,697,109)">';
mtxt += '<area shape="circle" coords="702,109,3" href="javascript:selectTSpoints(56061,702,109)">';
mtxt += '<area shape="circle" coords="707,109,3" href="javascript:selectTSpoints(56062,707,109)">';
mtxt += '<area shape="circle" coords="712,109,3" href="javascript:selectTSpoints(56063,712,109)">';
mtxt += '<area shape="circle" coords="717,109,3" href="javascript:selectTSpoints(56064,717,109)">';
mtxt += '<area shape="circle" coords="722,109,3" href="javascript:selectTSpoints(56065,722,109)">';
mtxt += '<area shape="circle" coords="727,109,3" href="javascript:selectTSpoints(56066,727,109)">';
mtxt += '<area shape="circle" coords="733,109,3" href="javascript:selectTSpoints(56067,733,109)">';
mtxt += '<area shape="circle" coords="738,109,3" href="javascript:selectTSpoints(56068,738,109)">';
mtxt += '<area shape="circle" coords="743,109,3" href="javascript:selectTSpoints(56069,743,109)">';
mtxt += '<area shape="circle" coords="748,109,3" href="javascript:selectTSpoints(56070,748,109)">';
mtxt += '<area shape="circle" coords="753,109,3" href="javascript:selectTSpoints(56071,753,109)">';
mtxt += '<area shape="circle" coords="758,109,3" href="javascript:selectTSpoints(56072,758,109)">';
mtxt += '<area shape="circle" coords=" 30,104,3" href="javascript:selectTSpoints(57073, 30,104)">';
mtxt += '<area shape="circle" coords=" 35,104,3" href="javascript:selectTSpoints(57074, 35,104)">';
mtxt += '<area shape="circle" coords=" 40,104,3" href="javascript:selectTSpoints(57075, 40,104)">';
mtxt += '<area shape="circle" coords=" 45,104,3" href="javascript:selectTSpoints(57076, 45,104)">';
mtxt += '<area shape="circle" coords=" 50,104,3" href="javascript:selectTSpoints(57077, 50,104)">';
mtxt += '<area shape="circle" coords=" 56,104,3" href="javascript:selectTSpoints(57078, 56,104)">';
mtxt += '<area shape="circle" coords=" 61,104,3" href="javascript:selectTSpoints(57079, 61,104)">';
mtxt += '<area shape="circle" coords=" 66,104,3" href="javascript:selectTSpoints(57080, 66,104)">';
mtxt += '<area shape="circle" coords=" 71,104,3" href="javascript:selectTSpoints(57081, 71,104)">';
mtxt += '<area shape="circle" coords=" 76,104,3" href="javascript:selectTSpoints(57082, 76,104)">';
mtxt += '<area shape="circle" coords=" 81,104,3" href="javascript:selectTSpoints(57083, 81,104)">';
mtxt += '<area shape="circle" coords=" 86,104,3" href="javascript:selectTSpoints(57084, 86,104)">';
mtxt += '<area shape="circle" coords=" 91,104,3" href="javascript:selectTSpoints(57085, 91,104)">';
mtxt += '<area shape="circle" coords=" 96,104,3" href="javascript:selectTSpoints(57086, 96,104)">';
mtxt += '<area shape="circle" coords="101,104,3" href="javascript:selectTSpoints(57087,101,104)">';
mtxt += '<area shape="circle" coords="106,104,3" href="javascript:selectTSpoints(57088,106,104)">';
mtxt += '<area shape="circle" coords="112,104,3" href="javascript:selectTSpoints(57089,112,104)">';
mtxt += '<area shape="circle" coords="117,104,3" href="javascript:selectTSpoints(57090,117,104)">';
mtxt += '<area shape="circle" coords="122,104,3" href="javascript:selectTSpoints(57091,122,104)">';
mtxt += '<area shape="circle" coords="127,104,3" href="javascript:selectTSpoints(57092,127,104)">';
mtxt += '<area shape="circle" coords="132,104,3" href="javascript:selectTSpoints(57093,132,104)">';
mtxt += '<area shape="circle" coords="137,104,3" href="javascript:selectTSpoints(57094,137,104)">';
mtxt += '<area shape="circle" coords="142,104,3" href="javascript:selectTSpoints(57095,142,104)">';
mtxt += '<area shape="circle" coords="147,104,3" href="javascript:selectTSpoints(57096,147,104)">';
mtxt += '<area shape="circle" coords="152,104,3" href="javascript:selectTSpoints(57097,152,104)">';
mtxt += '<area shape="circle" coords="157,104,3" href="javascript:selectTSpoints(57098,157,104)">';
mtxt += '<area shape="circle" coords="162,104,3" href="javascript:selectTSpoints(57099,162,104)">';
mtxt += '<area shape="circle" coords="168,104,3" href="javascript:selectTSpoints(57100,168,104)">';
mtxt += '<area shape="circle" coords="173,104,3" href="javascript:selectTSpoints(57101,173,104)">';
mtxt += '<area shape="circle" coords="178,104,3" href="javascript:selectTSpoints(57102,178,104)">';
mtxt += '<area shape="circle" coords="183,104,3" href="javascript:selectTSpoints(57103,183,104)">';
mtxt += '<area shape="circle" coords="188,104,3" href="javascript:selectTSpoints(57104,188,104)">';
mtxt += '<area shape="circle" coords="193,104,3" href="javascript:selectTSpoints(57105,193,104)">';
mtxt += '<area shape="circle" coords="198,104,3" href="javascript:selectTSpoints(57106,198,104)">';
mtxt += '<area shape="circle" coords="203,104,3" href="javascript:selectTSpoints(57107,203,104)">';
mtxt += '<area shape="circle" coords="208,104,3" href="javascript:selectTSpoints(57108,208,104)">';
mtxt += '<area shape="circle" coords="213,104,3" href="javascript:selectTSpoints(57109,213,104)">';
mtxt += '<area shape="circle" coords="218,104,3" href="javascript:selectTSpoints(57110,218,104)">';
mtxt += '<area shape="circle" coords="224,104,3" href="javascript:selectTSpoints(57111,224,104)">';
mtxt += '<area shape="circle" coords="229,104,3" href="javascript:selectTSpoints(57112,229,104)">';
mtxt += '<area shape="circle" coords="234,104,3" href="javascript:selectTSpoints(57113,234,104)">';
mtxt += '<area shape="circle" coords="239,104,3" href="javascript:selectTSpoints(57114,239,104)">';
mtxt += '<area shape="circle" coords="244,104,3" href="javascript:selectTSpoints(57115,244,104)">';
mtxt += '<area shape="circle" coords="249,104,3" href="javascript:selectTSpoints(57116,249,104)">';
mtxt += '<area shape="circle" coords="254,104,3" href="javascript:selectTSpoints(57117,254,104)">';
mtxt += '<area shape="circle" coords="259,104,3" href="javascript:selectTSpoints(57118,259,104)">';
mtxt += '<area shape="circle" coords="264,104,3" href="javascript:selectTSpoints(57119,264,104)">';
mtxt += '<area shape="circle" coords="269,104,3" href="javascript:selectTSpoints(57120,269,104)">';
mtxt += '<area shape="circle" coords="274,104,3" href="javascript:selectTSpoints(57121,274,104)">';
mtxt += '<area shape="circle" coords="280,104,3" href="javascript:selectTSpoints(57122,280,104)">';
mtxt += '<area shape="circle" coords="285,104,3" href="javascript:selectTSpoints(57123,285,104)">';
mtxt += '<area shape="circle" coords="290,104,3" href="javascript:selectTSpoints(57124,290,104)">';
mtxt += '<area shape="circle" coords="295,104,3" href="javascript:selectTSpoints(57125,295,104)">';
mtxt += '<area shape="circle" coords="300,104,3" href="javascript:selectTSpoints(57126,300,104)">';
mtxt += '<area shape="circle" coords="305,104,3" href="javascript:selectTSpoints(57127,305,104)">';
mtxt += '<area shape="circle" coords="310,104,3" href="javascript:selectTSpoints(57128,310,104)">';
mtxt += '<area shape="circle" coords="315,104,3" href="javascript:selectTSpoints(57129,315,104)">';
mtxt += '<area shape="circle" coords="320,104,3" href="javascript:selectTSpoints(57130,320,104)">';
mtxt += '<area shape="circle" coords="325,104,3" href="javascript:selectTSpoints(57131,325,104)">';
mtxt += '<area shape="circle" coords="330,104,3" href="javascript:selectTSpoints(57132,330,104)">';
mtxt += '<area shape="circle" coords="336,104,3" href="javascript:selectTSpoints(57133,336,104)">';
mtxt += '<area shape="circle" coords="341,104,3" href="javascript:selectTSpoints(57134,341,104)">';
mtxt += '<area shape="circle" coords="346,104,3" href="javascript:selectTSpoints(57135,346,104)">';
mtxt += '<area shape="circle" coords="351,104,3" href="javascript:selectTSpoints(57136,351,104)">';
mtxt += '<area shape="circle" coords="356,104,3" href="javascript:selectTSpoints(57137,356,104)">';
mtxt += '<area shape="circle" coords="361,104,3" href="javascript:selectTSpoints(57138,361,104)">';
mtxt += '<area shape="circle" coords="366,104,3" href="javascript:selectTSpoints(57139,366,104)">';
mtxt += '<area shape="circle" coords="371,104,3" href="javascript:selectTSpoints(57140,371,104)">';
mtxt += '<area shape="circle" coords="376,104,3" href="javascript:selectTSpoints(57141,376,104)">';
mtxt += '<area shape="circle" coords="381,104,3" href="javascript:selectTSpoints(57142,381,104)">';
mtxt += '<area shape="circle" coords="386,104,3" href="javascript:selectTSpoints(57143,386,104)">';
mtxt += '<area shape="circle" coords="392,104,3" href="javascript:selectTSpoints(57144,392,104)">';
mtxt += '<area shape="circle" coords="397,104,3" href="javascript:selectTSpoints(57001,397,104)">';
mtxt += '<area shape="circle" coords="402,104,3" href="javascript:selectTSpoints(57002,402,104)">';
mtxt += '<area shape="circle" coords="407,104,3" href="javascript:selectTSpoints(57003,407,104)">';
mtxt += '<area shape="circle" coords="412,104,3" href="javascript:selectTSpoints(57004,412,104)">';
mtxt += '<area shape="circle" coords="417,104,3" href="javascript:selectTSpoints(57005,417,104)">';
mtxt += '<area shape="circle" coords="422,104,3" href="javascript:selectTSpoints(57006,422,104)">';
mtxt += '<area shape="circle" coords="427,104,3" href="javascript:selectTSpoints(57007,427,104)">';
mtxt += '<area shape="circle" coords="432,104,3" href="javascript:selectTSpoints(57008,432,104)">';
mtxt += '<area shape="circle" coords="437,104,3" href="javascript:selectTSpoints(57009,437,104)">';
mtxt += '<area shape="circle" coords="442,104,3" href="javascript:selectTSpoints(57010,442,104)">';
mtxt += '<area shape="circle" coords="447,104,3" href="javascript:selectTSpoints(57011,447,104)">';
mtxt += '<area shape="circle" coords="453,104,3" href="javascript:selectTSpoints(57012,453,104)">';
mtxt += '<area shape="circle" coords="458,104,3" href="javascript:selectTSpoints(57013,458,104)">';
mtxt += '<area shape="circle" coords="463,104,3" href="javascript:selectTSpoints(57014,463,104)">';
mtxt += '<area shape="circle" coords="468,104,3" href="javascript:selectTSpoints(57015,468,104)">';
mtxt += '<area shape="circle" coords="473,104,3" href="javascript:selectTSpoints(57016,473,104)">';
mtxt += '<area shape="circle" coords="478,104,3" href="javascript:selectTSpoints(57017,478,104)">';
mtxt += '<area shape="circle" coords="483,104,3" href="javascript:selectTSpoints(57018,483,104)">';
mtxt += '<area shape="circle" coords="488,104,3" href="javascript:selectTSpoints(57019,488,104)">';
mtxt += '<area shape="circle" coords="493,104,3" href="javascript:selectTSpoints(57020,493,104)">';
mtxt += '<area shape="circle" coords="498,104,3" href="javascript:selectTSpoints(57021,498,104)">';
mtxt += '<area shape="circle" coords="503,104,3" href="javascript:selectTSpoints(57022,503,104)">';
mtxt += '<area shape="circle" coords="509,104,3" href="javascript:selectTSpoints(57023,509,104)">';
mtxt += '<area shape="circle" coords="514,104,3" href="javascript:selectTSpoints(57024,514,104)">';
mtxt += '<area shape="circle" coords="519,104,3" href="javascript:selectTSpoints(57025,519,104)">';
mtxt += '<area shape="circle" coords="524,104,3" href="javascript:selectTSpoints(57026,524,104)">';
mtxt += '<area shape="circle" coords="529,104,3" href="javascript:selectTSpoints(57027,529,104)">';
mtxt += '<area shape="circle" coords="534,104,3" href="javascript:selectTSpoints(57028,534,104)">';
mtxt += '<area shape="circle" coords="539,104,3" href="javascript:selectTSpoints(57029,539,104)">';
mtxt += '<area shape="circle" coords="544,104,3" href="javascript:selectTSpoints(57030,544,104)">';
mtxt += '<area shape="circle" coords="549,104,3" href="javascript:selectTSpoints(57031,549,104)">';
mtxt += '<area shape="circle" coords="554,104,3" href="javascript:selectTSpoints(57032,554,104)">';
mtxt += '<area shape="circle" coords="559,104,3" href="javascript:selectTSpoints(57033,559,104)">';
mtxt += '<area shape="circle" coords="565,104,3" href="javascript:selectTSpoints(57034,565,104)">';
mtxt += '<area shape="circle" coords="570,104,3" href="javascript:selectTSpoints(57035,570,104)">';
mtxt += '<area shape="circle" coords="575,104,3" href="javascript:selectTSpoints(57036,575,104)">';
mtxt += '<area shape="circle" coords="580,104,3" href="javascript:selectTSpoints(57037,580,104)">';
mtxt += '<area shape="circle" coords="585,104,3" href="javascript:selectTSpoints(57038,585,104)">';
mtxt += '<area shape="circle" coords="590,104,3" href="javascript:selectTSpoints(57039,590,104)">';
mtxt += '<area shape="circle" coords="595,104,3" href="javascript:selectTSpoints(57040,595,104)">';
mtxt += '<area shape="circle" coords="600,104,3" href="javascript:selectTSpoints(57041,600,104)">';
mtxt += '<area shape="circle" coords="605,104,3" href="javascript:selectTSpoints(57042,605,104)">';
mtxt += '<area shape="circle" coords="610,104,3" href="javascript:selectTSpoints(57043,610,104)">';
mtxt += '<area shape="circle" coords="615,104,3" href="javascript:selectTSpoints(57044,615,104)">';
mtxt += '<area shape="circle" coords="621,104,3" href="javascript:selectTSpoints(57045,621,104)">';
mtxt += '<area shape="circle" coords="626,104,3" href="javascript:selectTSpoints(57046,626,104)">';
mtxt += '<area shape="circle" coords="631,104,3" href="javascript:selectTSpoints(57047,631,104)">';
mtxt += '<area shape="circle" coords="636,104,3" href="javascript:selectTSpoints(57048,636,104)">';
mtxt += '<area shape="circle" coords="641,104,3" href="javascript:selectTSpoints(57049,641,104)">';
mtxt += '<area shape="circle" coords="646,104,3" href="javascript:selectTSpoints(57050,646,104)">';
mtxt += '<area shape="circle" coords="651,104,3" href="javascript:selectTSpoints(57051,651,104)">';
mtxt += '<area shape="circle" coords="656,104,3" href="javascript:selectTSpoints(57052,656,104)">';
mtxt += '<area shape="circle" coords="661,104,3" href="javascript:selectTSpoints(57053,661,104)">';
mtxt += '<area shape="circle" coords="666,104,3" href="javascript:selectTSpoints(57054,666,104)">';
mtxt += '<area shape="circle" coords="671,104,3" href="javascript:selectTSpoints(57055,671,104)">';
mtxt += '<area shape="circle" coords="677,104,3" href="javascript:selectTSpoints(57056,677,104)">';
mtxt += '<area shape="circle" coords="682,104,3" href="javascript:selectTSpoints(57057,682,104)">';
mtxt += '<area shape="circle" coords="687,104,3" href="javascript:selectTSpoints(57058,687,104)">';
mtxt += '<area shape="circle" coords="692,104,3" href="javascript:selectTSpoints(57059,692,104)">';
mtxt += '<area shape="circle" coords="697,104,3" href="javascript:selectTSpoints(57060,697,104)">';
mtxt += '<area shape="circle" coords="702,104,3" href="javascript:selectTSpoints(57061,702,104)">';
mtxt += '<area shape="circle" coords="707,104,3" href="javascript:selectTSpoints(57062,707,104)">';
mtxt += '<area shape="circle" coords="712,104,3" href="javascript:selectTSpoints(57063,712,104)">';
mtxt += '<area shape="circle" coords="717,104,3" href="javascript:selectTSpoints(57064,717,104)">';
mtxt += '<area shape="circle" coords="722,104,3" href="javascript:selectTSpoints(57065,722,104)">';
mtxt += '<area shape="circle" coords="727,104,3" href="javascript:selectTSpoints(57066,727,104)">';
mtxt += '<area shape="circle" coords="733,104,3" href="javascript:selectTSpoints(57067,733,104)">';
mtxt += '<area shape="circle" coords="738,104,3" href="javascript:selectTSpoints(57068,738,104)">';
mtxt += '<area shape="circle" coords="743,104,3" href="javascript:selectTSpoints(57069,743,104)">';
mtxt += '<area shape="circle" coords="748,104,3" href="javascript:selectTSpoints(57070,748,104)">';
mtxt += '<area shape="circle" coords="753,104,3" href="javascript:selectTSpoints(57071,753,104)">';
mtxt += '<area shape="circle" coords="758,104,3" href="javascript:selectTSpoints(57072,758,104)">';
mtxt += '<area shape="circle" coords=" 30, 99,3" href="javascript:selectTSpoints(58073, 30, 99)">';
mtxt += '<area shape="circle" coords=" 35, 99,3" href="javascript:selectTSpoints(58074, 35, 99)">';
mtxt += '<area shape="circle" coords=" 40, 99,3" href="javascript:selectTSpoints(58075, 40, 99)">';
mtxt += '<area shape="circle" coords=" 45, 99,3" href="javascript:selectTSpoints(58076, 45, 99)">';
mtxt += '<area shape="circle" coords=" 50, 99,3" href="javascript:selectTSpoints(58077, 50, 99)">';
mtxt += '<area shape="circle" coords=" 56, 99,3" href="javascript:selectTSpoints(58078, 56, 99)">';
mtxt += '<area shape="circle" coords=" 61, 99,3" href="javascript:selectTSpoints(58079, 61, 99)">';
mtxt += '<area shape="circle" coords=" 66, 99,3" href="javascript:selectTSpoints(58080, 66, 99)">';
mtxt += '<area shape="circle" coords=" 71, 99,3" href="javascript:selectTSpoints(58081, 71, 99)">';
mtxt += '<area shape="circle" coords=" 76, 99,3" href="javascript:selectTSpoints(58082, 76, 99)">';
mtxt += '<area shape="circle" coords=" 81, 99,3" href="javascript:selectTSpoints(58083, 81, 99)">';
mtxt += '<area shape="circle" coords=" 86, 99,3" href="javascript:selectTSpoints(58084, 86, 99)">';
mtxt += '<area shape="circle" coords=" 91, 99,3" href="javascript:selectTSpoints(58085, 91, 99)">';
mtxt += '<area shape="circle" coords=" 96, 99,3" href="javascript:selectTSpoints(58086, 96, 99)">';
mtxt += '<area shape="circle" coords="101, 99,3" href="javascript:selectTSpoints(58087,101, 99)">';
mtxt += '<area shape="circle" coords="106, 99,3" href="javascript:selectTSpoints(58088,106, 99)">';
mtxt += '<area shape="circle" coords="112, 99,3" href="javascript:selectTSpoints(58089,112, 99)">';
mtxt += '<area shape="circle" coords="117, 99,3" href="javascript:selectTSpoints(58090,117, 99)">';
mtxt += '<area shape="circle" coords="122, 99,3" href="javascript:selectTSpoints(58091,122, 99)">';
mtxt += '<area shape="circle" coords="127, 99,3" href="javascript:selectTSpoints(58092,127, 99)">';
mtxt += '<area shape="circle" coords="132, 99,3" href="javascript:selectTSpoints(58093,132, 99)">';
mtxt += '<area shape="circle" coords="137, 99,3" href="javascript:selectTSpoints(58094,137, 99)">';
mtxt += '<area shape="circle" coords="142, 99,3" href="javascript:selectTSpoints(58095,142, 99)">';
mtxt += '<area shape="circle" coords="147, 99,3" href="javascript:selectTSpoints(58096,147, 99)">';
mtxt += '<area shape="circle" coords="152, 99,3" href="javascript:selectTSpoints(58097,152, 99)">';
mtxt += '<area shape="circle" coords="157, 99,3" href="javascript:selectTSpoints(58098,157, 99)">';
mtxt += '<area shape="circle" coords="162, 99,3" href="javascript:selectTSpoints(58099,162, 99)">';
mtxt += '<area shape="circle" coords="168, 99,3" href="javascript:selectTSpoints(58100,168, 99)">';
mtxt += '<area shape="circle" coords="173, 99,3" href="javascript:selectTSpoints(58101,173, 99)">';
mtxt += '<area shape="circle" coords="178, 99,3" href="javascript:selectTSpoints(58102,178, 99)">';
mtxt += '<area shape="circle" coords="183, 99,3" href="javascript:selectTSpoints(58103,183, 99)">';
mtxt += '<area shape="circle" coords="188, 99,3" href="javascript:selectTSpoints(58104,188, 99)">';
mtxt += '<area shape="circle" coords="193, 99,3" href="javascript:selectTSpoints(58105,193, 99)">';
mtxt += '<area shape="circle" coords="198, 99,3" href="javascript:selectTSpoints(58106,198, 99)">';
mtxt += '<area shape="circle" coords="203, 99,3" href="javascript:selectTSpoints(58107,203, 99)">';
mtxt += '<area shape="circle" coords="208, 99,3" href="javascript:selectTSpoints(58108,208, 99)">';
mtxt += '<area shape="circle" coords="213, 99,3" href="javascript:selectTSpoints(58109,213, 99)">';
mtxt += '<area shape="circle" coords="218, 99,3" href="javascript:selectTSpoints(58110,218, 99)">';
mtxt += '<area shape="circle" coords="224, 99,3" href="javascript:selectTSpoints(58111,224, 99)">';
mtxt += '<area shape="circle" coords="229, 99,3" href="javascript:selectTSpoints(58112,229, 99)">';
mtxt += '<area shape="circle" coords="234, 99,3" href="javascript:selectTSpoints(58113,234, 99)">';
mtxt += '<area shape="circle" coords="239, 99,3" href="javascript:selectTSpoints(58114,239, 99)">';
mtxt += '<area shape="circle" coords="244, 99,3" href="javascript:selectTSpoints(58115,244, 99)">';
mtxt += '<area shape="circle" coords="249, 99,3" href="javascript:selectTSpoints(58116,249, 99)">';
mtxt += '<area shape="circle" coords="254, 99,3" href="javascript:selectTSpoints(58117,254, 99)">';
mtxt += '<area shape="circle" coords="259, 99,3" href="javascript:selectTSpoints(58118,259, 99)">';
mtxt += '<area shape="circle" coords="264, 99,3" href="javascript:selectTSpoints(58119,264, 99)">';
mtxt += '<area shape="circle" coords="269, 99,3" href="javascript:selectTSpoints(58120,269, 99)">';
mtxt += '<area shape="circle" coords="274, 99,3" href="javascript:selectTSpoints(58121,274, 99)">';
mtxt += '<area shape="circle" coords="280, 99,3" href="javascript:selectTSpoints(58122,280, 99)">';
mtxt += '<area shape="circle" coords="285, 99,3" href="javascript:selectTSpoints(58123,285, 99)">';
mtxt += '<area shape="circle" coords="290, 99,3" href="javascript:selectTSpoints(58124,290, 99)">';
mtxt += '<area shape="circle" coords="295, 99,3" href="javascript:selectTSpoints(58125,295, 99)">';
mtxt += '<area shape="circle" coords="300, 99,3" href="javascript:selectTSpoints(58126,300, 99)">';
mtxt += '<area shape="circle" coords="305, 99,3" href="javascript:selectTSpoints(58127,305, 99)">';
mtxt += '<area shape="circle" coords="310, 99,3" href="javascript:selectTSpoints(58128,310, 99)">';
mtxt += '<area shape="circle" coords="315, 99,3" href="javascript:selectTSpoints(58129,315, 99)">';
mtxt += '<area shape="circle" coords="320, 99,3" href="javascript:selectTSpoints(58130,320, 99)">';
mtxt += '<area shape="circle" coords="325, 99,3" href="javascript:selectTSpoints(58131,325, 99)">';
mtxt += '<area shape="circle" coords="330, 99,3" href="javascript:selectTSpoints(58132,330, 99)">';
mtxt += '<area shape="circle" coords="336, 99,3" href="javascript:selectTSpoints(58133,336, 99)">';
mtxt += '<area shape="circle" coords="341, 99,3" href="javascript:selectTSpoints(58134,341, 99)">';
mtxt += '<area shape="circle" coords="346, 99,3" href="javascript:selectTSpoints(58135,346, 99)">';
mtxt += '<area shape="circle" coords="351, 99,3" href="javascript:selectTSpoints(58136,351, 99)">';
mtxt += '<area shape="circle" coords="356, 99,3" href="javascript:selectTSpoints(58137,356, 99)">';
mtxt += '<area shape="circle" coords="361, 99,3" href="javascript:selectTSpoints(58138,361, 99)">';
mtxt += '<area shape="circle" coords="366, 99,3" href="javascript:selectTSpoints(58139,366, 99)">';
mtxt += '<area shape="circle" coords="371, 99,3" href="javascript:selectTSpoints(58140,371, 99)">';
mtxt += '<area shape="circle" coords="376, 99,3" href="javascript:selectTSpoints(58141,376, 99)">';
mtxt += '<area shape="circle" coords="381, 99,3" href="javascript:selectTSpoints(58142,381, 99)">';
mtxt += '<area shape="circle" coords="386, 99,3" href="javascript:selectTSpoints(58143,386, 99)">';
mtxt += '<area shape="circle" coords="392, 99,3" href="javascript:selectTSpoints(58144,392, 99)">';
mtxt += '<area shape="circle" coords="397, 99,3" href="javascript:selectTSpoints(58001,397, 99)">';
mtxt += '<area shape="circle" coords="402, 99,3" href="javascript:selectTSpoints(58002,402, 99)">';
mtxt += '<area shape="circle" coords="407, 99,3" href="javascript:selectTSpoints(58003,407, 99)">';
mtxt += '<area shape="circle" coords="412, 99,3" href="javascript:selectTSpoints(58004,412, 99)">';
mtxt += '<area shape="circle" coords="417, 99,3" href="javascript:selectTSpoints(58005,417, 99)">';
mtxt += '<area shape="circle" coords="422, 99,3" href="javascript:selectTSpoints(58006,422, 99)">';
mtxt += '<area shape="circle" coords="427, 99,3" href="javascript:selectTSpoints(58007,427, 99)">';
mtxt += '<area shape="circle" coords="432, 99,3" href="javascript:selectTSpoints(58008,432, 99)">';
mtxt += '<area shape="circle" coords="437, 99,3" href="javascript:selectTSpoints(58009,437, 99)">';
mtxt += '<area shape="circle" coords="442, 99,3" href="javascript:selectTSpoints(58010,442, 99)">';
mtxt += '<area shape="circle" coords="447, 99,3" href="javascript:selectTSpoints(58011,447, 99)">';
mtxt += '<area shape="circle" coords="453, 99,3" href="javascript:selectTSpoints(58012,453, 99)">';
mtxt += '<area shape="circle" coords="458, 99,3" href="javascript:selectTSpoints(58013,458, 99)">';
mtxt += '<area shape="circle" coords="463, 99,3" href="javascript:selectTSpoints(58014,463, 99)">';
mtxt += '<area shape="circle" coords="468, 99,3" href="javascript:selectTSpoints(58015,468, 99)">';
mtxt += '<area shape="circle" coords="473, 99,3" href="javascript:selectTSpoints(58016,473, 99)">';
mtxt += '<area shape="circle" coords="478, 99,3" href="javascript:selectTSpoints(58017,478, 99)">';
mtxt += '<area shape="circle" coords="483, 99,3" href="javascript:selectTSpoints(58018,483, 99)">';
mtxt += '<area shape="circle" coords="488, 99,3" href="javascript:selectTSpoints(58019,488, 99)">';
mtxt += '<area shape="circle" coords="493, 99,3" href="javascript:selectTSpoints(58020,493, 99)">';
mtxt += '<area shape="circle" coords="498, 99,3" href="javascript:selectTSpoints(58021,498, 99)">';
mtxt += '<area shape="circle" coords="503, 99,3" href="javascript:selectTSpoints(58022,503, 99)">';
mtxt += '<area shape="circle" coords="509, 99,3" href="javascript:selectTSpoints(58023,509, 99)">';
mtxt += '<area shape="circle" coords="514, 99,3" href="javascript:selectTSpoints(58024,514, 99)">';
mtxt += '<area shape="circle" coords="519, 99,3" href="javascript:selectTSpoints(58025,519, 99)">';
mtxt += '<area shape="circle" coords="524, 99,3" href="javascript:selectTSpoints(58026,524, 99)">';
mtxt += '<area shape="circle" coords="529, 99,3" href="javascript:selectTSpoints(58027,529, 99)">';
mtxt += '<area shape="circle" coords="534, 99,3" href="javascript:selectTSpoints(58028,534, 99)">';
mtxt += '<area shape="circle" coords="539, 99,3" href="javascript:selectTSpoints(58029,539, 99)">';
mtxt += '<area shape="circle" coords="544, 99,3" href="javascript:selectTSpoints(58030,544, 99)">';
mtxt += '<area shape="circle" coords="549, 99,3" href="javascript:selectTSpoints(58031,549, 99)">';
mtxt += '<area shape="circle" coords="554, 99,3" href="javascript:selectTSpoints(58032,554, 99)">';
mtxt += '<area shape="circle" coords="559, 99,3" href="javascript:selectTSpoints(58033,559, 99)">';
mtxt += '<area shape="circle" coords="565, 99,3" href="javascript:selectTSpoints(58034,565, 99)">';
mtxt += '<area shape="circle" coords="570, 99,3" href="javascript:selectTSpoints(58035,570, 99)">';
mtxt += '<area shape="circle" coords="575, 99,3" href="javascript:selectTSpoints(58036,575, 99)">';
mtxt += '<area shape="circle" coords="580, 99,3" href="javascript:selectTSpoints(58037,580, 99)">';
mtxt += '<area shape="circle" coords="585, 99,3" href="javascript:selectTSpoints(58038,585, 99)">';
mtxt += '<area shape="circle" coords="590, 99,3" href="javascript:selectTSpoints(58039,590, 99)">';
mtxt += '<area shape="circle" coords="595, 99,3" href="javascript:selectTSpoints(58040,595, 99)">';
mtxt += '<area shape="circle" coords="600, 99,3" href="javascript:selectTSpoints(58041,600, 99)">';
mtxt += '<area shape="circle" coords="605, 99,3" href="javascript:selectTSpoints(58042,605, 99)">';
mtxt += '<area shape="circle" coords="610, 99,3" href="javascript:selectTSpoints(58043,610, 99)">';
mtxt += '<area shape="circle" coords="615, 99,3" href="javascript:selectTSpoints(58044,615, 99)">';
mtxt += '<area shape="circle" coords="621, 99,3" href="javascript:selectTSpoints(58045,621, 99)">';
mtxt += '<area shape="circle" coords="626, 99,3" href="javascript:selectTSpoints(58046,626, 99)">';
mtxt += '<area shape="circle" coords="631, 99,3" href="javascript:selectTSpoints(58047,631, 99)">';
mtxt += '<area shape="circle" coords="636, 99,3" href="javascript:selectTSpoints(58048,636, 99)">';
mtxt += '<area shape="circle" coords="641, 99,3" href="javascript:selectTSpoints(58049,641, 99)">';
mtxt += '<area shape="circle" coords="646, 99,3" href="javascript:selectTSpoints(58050,646, 99)">';
mtxt += '<area shape="circle" coords="651, 99,3" href="javascript:selectTSpoints(58051,651, 99)">';
mtxt += '<area shape="circle" coords="656, 99,3" href="javascript:selectTSpoints(58052,656, 99)">';
mtxt += '<area shape="circle" coords="661, 99,3" href="javascript:selectTSpoints(58053,661, 99)">';
mtxt += '<area shape="circle" coords="666, 99,3" href="javascript:selectTSpoints(58054,666, 99)">';
mtxt += '<area shape="circle" coords="671, 99,3" href="javascript:selectTSpoints(58055,671, 99)">';
mtxt += '<area shape="circle" coords="677, 99,3" href="javascript:selectTSpoints(58056,677, 99)">';
mtxt += '<area shape="circle" coords="682, 99,3" href="javascript:selectTSpoints(58057,682, 99)">';
mtxt += '<area shape="circle" coords="687, 99,3" href="javascript:selectTSpoints(58058,687, 99)">';
mtxt += '<area shape="circle" coords="692, 99,3" href="javascript:selectTSpoints(58059,692, 99)">';
mtxt += '<area shape="circle" coords="697, 99,3" href="javascript:selectTSpoints(58060,697, 99)">';
mtxt += '<area shape="circle" coords="702, 99,3" href="javascript:selectTSpoints(58061,702, 99)">';
mtxt += '<area shape="circle" coords="707, 99,3" href="javascript:selectTSpoints(58062,707, 99)">';
mtxt += '<area shape="circle" coords="712, 99,3" href="javascript:selectTSpoints(58063,712, 99)">';
mtxt += '<area shape="circle" coords="717, 99,3" href="javascript:selectTSpoints(58064,717, 99)">';
mtxt += '<area shape="circle" coords="722, 99,3" href="javascript:selectTSpoints(58065,722, 99)">';
mtxt += '<area shape="circle" coords="727, 99,3" href="javascript:selectTSpoints(58066,727, 99)">';
mtxt += '<area shape="circle" coords="733, 99,3" href="javascript:selectTSpoints(58067,733, 99)">';
mtxt += '<area shape="circle" coords="738, 99,3" href="javascript:selectTSpoints(58068,738, 99)">';
mtxt += '<area shape="circle" coords="743, 99,3" href="javascript:selectTSpoints(58069,743, 99)">';
mtxt += '<area shape="circle" coords="748, 99,3" href="javascript:selectTSpoints(58070,748, 99)">';
mtxt += '<area shape="circle" coords="753, 99,3" href="javascript:selectTSpoints(58071,753, 99)">';
mtxt += '<area shape="circle" coords="758, 99,3" href="javascript:selectTSpoints(58072,758, 99)">';
mtxt += '<area shape="circle" coords=" 30, 94,3" href="javascript:selectTSpoints(59073, 30, 94)">';
mtxt += '<area shape="circle" coords=" 35, 94,3" href="javascript:selectTSpoints(59074, 35, 94)">';
mtxt += '<area shape="circle" coords=" 40, 94,3" href="javascript:selectTSpoints(59075, 40, 94)">';
mtxt += '<area shape="circle" coords=" 45, 94,3" href="javascript:selectTSpoints(59076, 45, 94)">';
mtxt += '<area shape="circle" coords=" 50, 94,3" href="javascript:selectTSpoints(59077, 50, 94)">';
mtxt += '<area shape="circle" coords=" 56, 94,3" href="javascript:selectTSpoints(59078, 56, 94)">';
mtxt += '<area shape="circle" coords=" 61, 94,3" href="javascript:selectTSpoints(59079, 61, 94)">';
mtxt += '<area shape="circle" coords=" 66, 94,3" href="javascript:selectTSpoints(59080, 66, 94)">';
mtxt += '<area shape="circle" coords=" 71, 94,3" href="javascript:selectTSpoints(59081, 71, 94)">';
mtxt += '<area shape="circle" coords=" 76, 94,3" href="javascript:selectTSpoints(59082, 76, 94)">';
mtxt += '<area shape="circle" coords=" 81, 94,3" href="javascript:selectTSpoints(59083, 81, 94)">';
mtxt += '<area shape="circle" coords=" 86, 94,3" href="javascript:selectTSpoints(59084, 86, 94)">';
mtxt += '<area shape="circle" coords=" 91, 94,3" href="javascript:selectTSpoints(59085, 91, 94)">';
mtxt += '<area shape="circle" coords=" 96, 94,3" href="javascript:selectTSpoints(59086, 96, 94)">';
mtxt += '<area shape="circle" coords="101, 94,3" href="javascript:selectTSpoints(59087,101, 94)">';
mtxt += '<area shape="circle" coords="106, 94,3" href="javascript:selectTSpoints(59088,106, 94)">';
mtxt += '<area shape="circle" coords="112, 94,3" href="javascript:selectTSpoints(59089,112, 94)">';
mtxt += '<area shape="circle" coords="117, 94,3" href="javascript:selectTSpoints(59090,117, 94)">';
mtxt += '<area shape="circle" coords="122, 94,3" href="javascript:selectTSpoints(59091,122, 94)">';
mtxt += '<area shape="circle" coords="127, 94,3" href="javascript:selectTSpoints(59092,127, 94)">';
mtxt += '<area shape="circle" coords="132, 94,3" href="javascript:selectTSpoints(59093,132, 94)">';
mtxt += '<area shape="circle" coords="137, 94,3" href="javascript:selectTSpoints(59094,137, 94)">';
mtxt += '<area shape="circle" coords="142, 94,3" href="javascript:selectTSpoints(59095,142, 94)">';
mtxt += '<area shape="circle" coords="147, 94,3" href="javascript:selectTSpoints(59096,147, 94)">';
mtxt += '<area shape="circle" coords="152, 94,3" href="javascript:selectTSpoints(59097,152, 94)">';
mtxt += '<area shape="circle" coords="157, 94,3" href="javascript:selectTSpoints(59098,157, 94)">';
mtxt += '<area shape="circle" coords="162, 94,3" href="javascript:selectTSpoints(59099,162, 94)">';
mtxt += '<area shape="circle" coords="168, 94,3" href="javascript:selectTSpoints(59100,168, 94)">';
mtxt += '<area shape="circle" coords="173, 94,3" href="javascript:selectTSpoints(59101,173, 94)">';
mtxt += '<area shape="circle" coords="178, 94,3" href="javascript:selectTSpoints(59102,178, 94)">';
mtxt += '<area shape="circle" coords="183, 94,3" href="javascript:selectTSpoints(59103,183, 94)">';
mtxt += '<area shape="circle" coords="188, 94,3" href="javascript:selectTSpoints(59104,188, 94)">';
mtxt += '<area shape="circle" coords="193, 94,3" href="javascript:selectTSpoints(59105,193, 94)">';
mtxt += '<area shape="circle" coords="198, 94,3" href="javascript:selectTSpoints(59106,198, 94)">';
mtxt += '<area shape="circle" coords="203, 94,3" href="javascript:selectTSpoints(59107,203, 94)">';
mtxt += '<area shape="circle" coords="208, 94,3" href="javascript:selectTSpoints(59108,208, 94)">';
mtxt += '<area shape="circle" coords="213, 94,3" href="javascript:selectTSpoints(59109,213, 94)">';
mtxt += '<area shape="circle" coords="218, 94,3" href="javascript:selectTSpoints(59110,218, 94)">';
mtxt += '<area shape="circle" coords="224, 94,3" href="javascript:selectTSpoints(59111,224, 94)">';
mtxt += '<area shape="circle" coords="229, 94,3" href="javascript:selectTSpoints(59112,229, 94)">';
mtxt += '<area shape="circle" coords="234, 94,3" href="javascript:selectTSpoints(59113,234, 94)">';
mtxt += '<area shape="circle" coords="239, 94,3" href="javascript:selectTSpoints(59114,239, 94)">';
mtxt += '<area shape="circle" coords="244, 94,3" href="javascript:selectTSpoints(59115,244, 94)">';
mtxt += '<area shape="circle" coords="249, 94,3" href="javascript:selectTSpoints(59116,249, 94)">';
mtxt += '<area shape="circle" coords="254, 94,3" href="javascript:selectTSpoints(59117,254, 94)">';
mtxt += '<area shape="circle" coords="259, 94,3" href="javascript:selectTSpoints(59118,259, 94)">';
mtxt += '<area shape="circle" coords="264, 94,3" href="javascript:selectTSpoints(59119,264, 94)">';
mtxt += '<area shape="circle" coords="269, 94,3" href="javascript:selectTSpoints(59120,269, 94)">';
mtxt += '<area shape="circle" coords="274, 94,3" href="javascript:selectTSpoints(59121,274, 94)">';
mtxt += '<area shape="circle" coords="280, 94,3" href="javascript:selectTSpoints(59122,280, 94)">';
mtxt += '<area shape="circle" coords="285, 94,3" href="javascript:selectTSpoints(59123,285, 94)">';
mtxt += '<area shape="circle" coords="290, 94,3" href="javascript:selectTSpoints(59124,290, 94)">';
mtxt += '<area shape="circle" coords="295, 94,3" href="javascript:selectTSpoints(59125,295, 94)">';
mtxt += '<area shape="circle" coords="300, 94,3" href="javascript:selectTSpoints(59126,300, 94)">';
mtxt += '<area shape="circle" coords="305, 94,3" href="javascript:selectTSpoints(59127,305, 94)">';
mtxt += '<area shape="circle" coords="310, 94,3" href="javascript:selectTSpoints(59128,310, 94)">';
mtxt += '<area shape="circle" coords="315, 94,3" href="javascript:selectTSpoints(59129,315, 94)">';
mtxt += '<area shape="circle" coords="320, 94,3" href="javascript:selectTSpoints(59130,320, 94)">';
mtxt += '<area shape="circle" coords="325, 94,3" href="javascript:selectTSpoints(59131,325, 94)">';
mtxt += '<area shape="circle" coords="330, 94,3" href="javascript:selectTSpoints(59132,330, 94)">';
mtxt += '<area shape="circle" coords="336, 94,3" href="javascript:selectTSpoints(59133,336, 94)">';
mtxt += '<area shape="circle" coords="341, 94,3" href="javascript:selectTSpoints(59134,341, 94)">';
mtxt += '<area shape="circle" coords="346, 94,3" href="javascript:selectTSpoints(59135,346, 94)">';
mtxt += '<area shape="circle" coords="351, 94,3" href="javascript:selectTSpoints(59136,351, 94)">';
mtxt += '<area shape="circle" coords="356, 94,3" href="javascript:selectTSpoints(59137,356, 94)">';
mtxt += '<area shape="circle" coords="361, 94,3" href="javascript:selectTSpoints(59138,361, 94)">';
mtxt += '<area shape="circle" coords="366, 94,3" href="javascript:selectTSpoints(59139,366, 94)">';
mtxt += '<area shape="circle" coords="371, 94,3" href="javascript:selectTSpoints(59140,371, 94)">';
mtxt += '<area shape="circle" coords="376, 94,3" href="javascript:selectTSpoints(59141,376, 94)">';
mtxt += '<area shape="circle" coords="381, 94,3" href="javascript:selectTSpoints(59142,381, 94)">';
mtxt += '<area shape="circle" coords="386, 94,3" href="javascript:selectTSpoints(59143,386, 94)">';
mtxt += '<area shape="circle" coords="392, 94,3" href="javascript:selectTSpoints(59144,392, 94)">';
mtxt += '<area shape="circle" coords="397, 94,3" href="javascript:selectTSpoints(59001,397, 94)">';
mtxt += '<area shape="circle" coords="402, 94,3" href="javascript:selectTSpoints(59002,402, 94)">';
mtxt += '<area shape="circle" coords="407, 94,3" href="javascript:selectTSpoints(59003,407, 94)">';
mtxt += '<area shape="circle" coords="412, 94,3" href="javascript:selectTSpoints(59004,412, 94)">';
mtxt += '<area shape="circle" coords="417, 94,3" href="javascript:selectTSpoints(59005,417, 94)">';
mtxt += '<area shape="circle" coords="422, 94,3" href="javascript:selectTSpoints(59006,422, 94)">';
mtxt += '<area shape="circle" coords="427, 94,3" href="javascript:selectTSpoints(59007,427, 94)">';
mtxt += '<area shape="circle" coords="432, 94,3" href="javascript:selectTSpoints(59008,432, 94)">';
mtxt += '<area shape="circle" coords="437, 94,3" href="javascript:selectTSpoints(59009,437, 94)">';
mtxt += '<area shape="circle" coords="442, 94,3" href="javascript:selectTSpoints(59010,442, 94)">';
mtxt += '<area shape="circle" coords="447, 94,3" href="javascript:selectTSpoints(59011,447, 94)">';
mtxt += '<area shape="circle" coords="453, 94,3" href="javascript:selectTSpoints(59012,453, 94)">';
mtxt += '<area shape="circle" coords="458, 94,3" href="javascript:selectTSpoints(59013,458, 94)">';
mtxt += '<area shape="circle" coords="463, 94,3" href="javascript:selectTSpoints(59014,463, 94)">';
mtxt += '<area shape="circle" coords="468, 94,3" href="javascript:selectTSpoints(59015,468, 94)">';
mtxt += '<area shape="circle" coords="473, 94,3" href="javascript:selectTSpoints(59016,473, 94)">';
mtxt += '<area shape="circle" coords="478, 94,3" href="javascript:selectTSpoints(59017,478, 94)">';
mtxt += '<area shape="circle" coords="483, 94,3" href="javascript:selectTSpoints(59018,483, 94)">';
mtxt += '<area shape="circle" coords="488, 94,3" href="javascript:selectTSpoints(59019,488, 94)">';
mtxt += '<area shape="circle" coords="493, 94,3" href="javascript:selectTSpoints(59020,493, 94)">';
mtxt += '<area shape="circle" coords="498, 94,3" href="javascript:selectTSpoints(59021,498, 94)">';
mtxt += '<area shape="circle" coords="503, 94,3" href="javascript:selectTSpoints(59022,503, 94)">';
mtxt += '<area shape="circle" coords="509, 94,3" href="javascript:selectTSpoints(59023,509, 94)">';
mtxt += '<area shape="circle" coords="514, 94,3" href="javascript:selectTSpoints(59024,514, 94)">';
mtxt += '<area shape="circle" coords="519, 94,3" href="javascript:selectTSpoints(59025,519, 94)">';
mtxt += '<area shape="circle" coords="524, 94,3" href="javascript:selectTSpoints(59026,524, 94)">';
mtxt += '<area shape="circle" coords="529, 94,3" href="javascript:selectTSpoints(59027,529, 94)">';
mtxt += '<area shape="circle" coords="534, 94,3" href="javascript:selectTSpoints(59028,534, 94)">';
mtxt += '<area shape="circle" coords="539, 94,3" href="javascript:selectTSpoints(59029,539, 94)">';
mtxt += '<area shape="circle" coords="544, 94,3" href="javascript:selectTSpoints(59030,544, 94)">';
mtxt += '<area shape="circle" coords="549, 94,3" href="javascript:selectTSpoints(59031,549, 94)">';
mtxt += '<area shape="circle" coords="554, 94,3" href="javascript:selectTSpoints(59032,554, 94)">';
mtxt += '<area shape="circle" coords="559, 94,3" href="javascript:selectTSpoints(59033,559, 94)">';
mtxt += '<area shape="circle" coords="565, 94,3" href="javascript:selectTSpoints(59034,565, 94)">';
mtxt += '<area shape="circle" coords="570, 94,3" href="javascript:selectTSpoints(59035,570, 94)">';
mtxt += '<area shape="circle" coords="575, 94,3" href="javascript:selectTSpoints(59036,575, 94)">';
mtxt += '<area shape="circle" coords="580, 94,3" href="javascript:selectTSpoints(59037,580, 94)">';
mtxt += '<area shape="circle" coords="585, 94,3" href="javascript:selectTSpoints(59038,585, 94)">';
mtxt += '<area shape="circle" coords="590, 94,3" href="javascript:selectTSpoints(59039,590, 94)">';
mtxt += '<area shape="circle" coords="595, 94,3" href="javascript:selectTSpoints(59040,595, 94)">';
mtxt += '<area shape="circle" coords="600, 94,3" href="javascript:selectTSpoints(59041,600, 94)">';
mtxt += '<area shape="circle" coords="605, 94,3" href="javascript:selectTSpoints(59042,605, 94)">';
mtxt += '<area shape="circle" coords="610, 94,3" href="javascript:selectTSpoints(59043,610, 94)">';
mtxt += '<area shape="circle" coords="615, 94,3" href="javascript:selectTSpoints(59044,615, 94)">';
mtxt += '<area shape="circle" coords="621, 94,3" href="javascript:selectTSpoints(59045,621, 94)">';
mtxt += '<area shape="circle" coords="626, 94,3" href="javascript:selectTSpoints(59046,626, 94)">';
mtxt += '<area shape="circle" coords="631, 94,3" href="javascript:selectTSpoints(59047,631, 94)">';
mtxt += '<area shape="circle" coords="636, 94,3" href="javascript:selectTSpoints(59048,636, 94)">';
mtxt += '<area shape="circle" coords="641, 94,3" href="javascript:selectTSpoints(59049,641, 94)">';
mtxt += '<area shape="circle" coords="646, 94,3" href="javascript:selectTSpoints(59050,646, 94)">';
mtxt += '<area shape="circle" coords="651, 94,3" href="javascript:selectTSpoints(59051,651, 94)">';
mtxt += '<area shape="circle" coords="656, 94,3" href="javascript:selectTSpoints(59052,656, 94)">';
mtxt += '<area shape="circle" coords="661, 94,3" href="javascript:selectTSpoints(59053,661, 94)">';
mtxt += '<area shape="circle" coords="666, 94,3" href="javascript:selectTSpoints(59054,666, 94)">';
mtxt += '<area shape="circle" coords="671, 94,3" href="javascript:selectTSpoints(59055,671, 94)">';
mtxt += '<area shape="circle" coords="677, 94,3" href="javascript:selectTSpoints(59056,677, 94)">';
mtxt += '<area shape="circle" coords="682, 94,3" href="javascript:selectTSpoints(59057,682, 94)">';
mtxt += '<area shape="circle" coords="687, 94,3" href="javascript:selectTSpoints(59058,687, 94)">';
mtxt += '<area shape="circle" coords="692, 94,3" href="javascript:selectTSpoints(59059,692, 94)">';
mtxt += '<area shape="circle" coords="697, 94,3" href="javascript:selectTSpoints(59060,697, 94)">';
mtxt += '<area shape="circle" coords="702, 94,3" href="javascript:selectTSpoints(59061,702, 94)">';
mtxt += '<area shape="circle" coords="707, 94,3" href="javascript:selectTSpoints(59062,707, 94)">';
mtxt += '<area shape="circle" coords="712, 94,3" href="javascript:selectTSpoints(59063,712, 94)">';
mtxt += '<area shape="circle" coords="717, 94,3" href="javascript:selectTSpoints(59064,717, 94)">';
mtxt += '<area shape="circle" coords="722, 94,3" href="javascript:selectTSpoints(59065,722, 94)">';
mtxt += '<area shape="circle" coords="727, 94,3" href="javascript:selectTSpoints(59066,727, 94)">';
mtxt += '<area shape="circle" coords="733, 94,3" href="javascript:selectTSpoints(59067,733, 94)">';
mtxt += '<area shape="circle" coords="738, 94,3" href="javascript:selectTSpoints(59068,738, 94)">';
mtxt += '<area shape="circle" coords="743, 94,3" href="javascript:selectTSpoints(59069,743, 94)">';
mtxt += '<area shape="circle" coords="748, 94,3" href="javascript:selectTSpoints(59070,748, 94)">';
mtxt += '<area shape="circle" coords="753, 94,3" href="javascript:selectTSpoints(59071,753, 94)">';
mtxt += '<area shape="circle" coords="758, 94,3" href="javascript:selectTSpoints(59072,758, 94)">';
mtxt += '<area shape="circle" coords=" 30, 89,3" href="javascript:selectTSpoints(60073, 30, 89)">';
mtxt += '<area shape="circle" coords=" 35, 89,3" href="javascript:selectTSpoints(60074, 35, 89)">';
mtxt += '<area shape="circle" coords=" 40, 89,3" href="javascript:selectTSpoints(60075, 40, 89)">';
mtxt += '<area shape="circle" coords=" 45, 89,3" href="javascript:selectTSpoints(60076, 45, 89)">';
mtxt += '<area shape="circle" coords=" 50, 89,3" href="javascript:selectTSpoints(60077, 50, 89)">';
mtxt += '<area shape="circle" coords=" 56, 89,3" href="javascript:selectTSpoints(60078, 56, 89)">';
mtxt += '<area shape="circle" coords=" 61, 89,3" href="javascript:selectTSpoints(60079, 61, 89)">';
mtxt += '<area shape="circle" coords=" 66, 89,3" href="javascript:selectTSpoints(60080, 66, 89)">';
mtxt += '<area shape="circle" coords=" 71, 89,3" href="javascript:selectTSpoints(60081, 71, 89)">';
mtxt += '<area shape="circle" coords=" 76, 89,3" href="javascript:selectTSpoints(60082, 76, 89)">';
mtxt += '<area shape="circle" coords=" 81, 89,3" href="javascript:selectTSpoints(60083, 81, 89)">';
mtxt += '<area shape="circle" coords=" 86, 89,3" href="javascript:selectTSpoints(60084, 86, 89)">';
mtxt += '<area shape="circle" coords=" 91, 89,3" href="javascript:selectTSpoints(60085, 91, 89)">';
mtxt += '<area shape="circle" coords=" 96, 89,3" href="javascript:selectTSpoints(60086, 96, 89)">';
mtxt += '<area shape="circle" coords="101, 89,3" href="javascript:selectTSpoints(60087,101, 89)">';
mtxt += '<area shape="circle" coords="106, 89,3" href="javascript:selectTSpoints(60088,106, 89)">';
mtxt += '<area shape="circle" coords="112, 89,3" href="javascript:selectTSpoints(60089,112, 89)">';
mtxt += '<area shape="circle" coords="117, 89,3" href="javascript:selectTSpoints(60090,117, 89)">';
mtxt += '<area shape="circle" coords="122, 89,3" href="javascript:selectTSpoints(60091,122, 89)">';
mtxt += '<area shape="circle" coords="127, 89,3" href="javascript:selectTSpoints(60092,127, 89)">';
mtxt += '<area shape="circle" coords="132, 89,3" href="javascript:selectTSpoints(60093,132, 89)">';
mtxt += '<area shape="circle" coords="137, 89,3" href="javascript:selectTSpoints(60094,137, 89)">';
mtxt += '<area shape="circle" coords="142, 89,3" href="javascript:selectTSpoints(60095,142, 89)">';
mtxt += '<area shape="circle" coords="147, 89,3" href="javascript:selectTSpoints(60096,147, 89)">';
mtxt += '<area shape="circle" coords="152, 89,3" href="javascript:selectTSpoints(60097,152, 89)">';
mtxt += '<area shape="circle" coords="157, 89,3" href="javascript:selectTSpoints(60098,157, 89)">';
mtxt += '<area shape="circle" coords="162, 89,3" href="javascript:selectTSpoints(60099,162, 89)">';
mtxt += '<area shape="circle" coords="168, 89,3" href="javascript:selectTSpoints(60100,168, 89)">';
mtxt += '<area shape="circle" coords="173, 89,3" href="javascript:selectTSpoints(60101,173, 89)">';
mtxt += '<area shape="circle" coords="178, 89,3" href="javascript:selectTSpoints(60102,178, 89)">';
mtxt += '<area shape="circle" coords="183, 89,3" href="javascript:selectTSpoints(60103,183, 89)">';
mtxt += '<area shape="circle" coords="188, 89,3" href="javascript:selectTSpoints(60104,188, 89)">';
mtxt += '<area shape="circle" coords="193, 89,3" href="javascript:selectTSpoints(60105,193, 89)">';
mtxt += '<area shape="circle" coords="198, 89,3" href="javascript:selectTSpoints(60106,198, 89)">';
mtxt += '<area shape="circle" coords="203, 89,3" href="javascript:selectTSpoints(60107,203, 89)">';
mtxt += '<area shape="circle" coords="208, 89,3" href="javascript:selectTSpoints(60108,208, 89)">';
mtxt += '<area shape="circle" coords="213, 89,3" href="javascript:selectTSpoints(60109,213, 89)">';
mtxt += '<area shape="circle" coords="218, 89,3" href="javascript:selectTSpoints(60110,218, 89)">';
mtxt += '<area shape="circle" coords="224, 89,3" href="javascript:selectTSpoints(60111,224, 89)">';
mtxt += '<area shape="circle" coords="229, 89,3" href="javascript:selectTSpoints(60112,229, 89)">';
mtxt += '<area shape="circle" coords="234, 89,3" href="javascript:selectTSpoints(60113,234, 89)">';
mtxt += '<area shape="circle" coords="239, 89,3" href="javascript:selectTSpoints(60114,239, 89)">';
mtxt += '<area shape="circle" coords="244, 89,3" href="javascript:selectTSpoints(60115,244, 89)">';
mtxt += '<area shape="circle" coords="249, 89,3" href="javascript:selectTSpoints(60116,249, 89)">';
mtxt += '<area shape="circle" coords="254, 89,3" href="javascript:selectTSpoints(60117,254, 89)">';
mtxt += '<area shape="circle" coords="259, 89,3" href="javascript:selectTSpoints(60118,259, 89)">';
mtxt += '<area shape="circle" coords="264, 89,3" href="javascript:selectTSpoints(60119,264, 89)">';
mtxt += '<area shape="circle" coords="269, 89,3" href="javascript:selectTSpoints(60120,269, 89)">';
mtxt += '<area shape="circle" coords="274, 89,3" href="javascript:selectTSpoints(60121,274, 89)">';
mtxt += '<area shape="circle" coords="280, 89,3" href="javascript:selectTSpoints(60122,280, 89)">';
mtxt += '<area shape="circle" coords="285, 89,3" href="javascript:selectTSpoints(60123,285, 89)">';
mtxt += '<area shape="circle" coords="290, 89,3" href="javascript:selectTSpoints(60124,290, 89)">';
mtxt += '<area shape="circle" coords="295, 89,3" href="javascript:selectTSpoints(60125,295, 89)">';
mtxt += '<area shape="circle" coords="300, 89,3" href="javascript:selectTSpoints(60126,300, 89)">';
mtxt += '<area shape="circle" coords="305, 89,3" href="javascript:selectTSpoints(60127,305, 89)">';
mtxt += '<area shape="circle" coords="310, 89,3" href="javascript:selectTSpoints(60128,310, 89)">';
mtxt += '<area shape="circle" coords="315, 89,3" href="javascript:selectTSpoints(60129,315, 89)">';
mtxt += '<area shape="circle" coords="320, 89,3" href="javascript:selectTSpoints(60130,320, 89)">';
mtxt += '<area shape="circle" coords="325, 89,3" href="javascript:selectTSpoints(60131,325, 89)">';
mtxt += '<area shape="circle" coords="330, 89,3" href="javascript:selectTSpoints(60132,330, 89)">';
mtxt += '<area shape="circle" coords="336, 89,3" href="javascript:selectTSpoints(60133,336, 89)">';
mtxt += '<area shape="circle" coords="341, 89,3" href="javascript:selectTSpoints(60134,341, 89)">';
mtxt += '<area shape="circle" coords="346, 89,3" href="javascript:selectTSpoints(60135,346, 89)">';
mtxt += '<area shape="circle" coords="351, 89,3" href="javascript:selectTSpoints(60136,351, 89)">';
mtxt += '<area shape="circle" coords="356, 89,3" href="javascript:selectTSpoints(60137,356, 89)">';
mtxt += '<area shape="circle" coords="361, 89,3" href="javascript:selectTSpoints(60138,361, 89)">';
mtxt += '<area shape="circle" coords="366, 89,3" href="javascript:selectTSpoints(60139,366, 89)">';
mtxt += '<area shape="circle" coords="371, 89,3" href="javascript:selectTSpoints(60140,371, 89)">';
mtxt += '<area shape="circle" coords="376, 89,3" href="javascript:selectTSpoints(60141,376, 89)">';
mtxt += '<area shape="circle" coords="381, 89,3" href="javascript:selectTSpoints(60142,381, 89)">';
mtxt += '<area shape="circle" coords="386, 89,3" href="javascript:selectTSpoints(60143,386, 89)">';
mtxt += '<area shape="circle" coords="392, 89,3" href="javascript:selectTSpoints(60144,392, 89)">';
mtxt += '<area shape="circle" coords="397, 89,3" href="javascript:selectTSpoints(60001,397, 89)">';
mtxt += '<area shape="circle" coords="402, 89,3" href="javascript:selectTSpoints(60002,402, 89)">';
mtxt += '<area shape="circle" coords="407, 89,3" href="javascript:selectTSpoints(60003,407, 89)">';
mtxt += '<area shape="circle" coords="412, 89,3" href="javascript:selectTSpoints(60004,412, 89)">';
mtxt += '<area shape="circle" coords="417, 89,3" href="javascript:selectTSpoints(60005,417, 89)">';
mtxt += '<area shape="circle" coords="422, 89,3" href="javascript:selectTSpoints(60006,422, 89)">';
mtxt += '<area shape="circle" coords="427, 89,3" href="javascript:selectTSpoints(60007,427, 89)">';
mtxt += '<area shape="circle" coords="432, 89,3" href="javascript:selectTSpoints(60008,432, 89)">';
mtxt += '<area shape="circle" coords="437, 89,3" href="javascript:selectTSpoints(60009,437, 89)">';
mtxt += '<area shape="circle" coords="442, 89,3" href="javascript:selectTSpoints(60010,442, 89)">';
mtxt += '<area shape="circle" coords="447, 89,3" href="javascript:selectTSpoints(60011,447, 89)">';
mtxt += '<area shape="circle" coords="453, 89,3" href="javascript:selectTSpoints(60012,453, 89)">';
mtxt += '<area shape="circle" coords="458, 89,3" href="javascript:selectTSpoints(60013,458, 89)">';
mtxt += '<area shape="circle" coords="463, 89,3" href="javascript:selectTSpoints(60014,463, 89)">';
mtxt += '<area shape="circle" coords="468, 89,3" href="javascript:selectTSpoints(60015,468, 89)">';
mtxt += '<area shape="circle" coords="473, 89,3" href="javascript:selectTSpoints(60016,473, 89)">';
mtxt += '<area shape="circle" coords="478, 89,3" href="javascript:selectTSpoints(60017,478, 89)">';
mtxt += '<area shape="circle" coords="483, 89,3" href="javascript:selectTSpoints(60018,483, 89)">';
mtxt += '<area shape="circle" coords="488, 89,3" href="javascript:selectTSpoints(60019,488, 89)">';
mtxt += '<area shape="circle" coords="493, 89,3" href="javascript:selectTSpoints(60020,493, 89)">';
mtxt += '<area shape="circle" coords="498, 89,3" href="javascript:selectTSpoints(60021,498, 89)">';
mtxt += '<area shape="circle" coords="503, 89,3" href="javascript:selectTSpoints(60022,503, 89)">';
mtxt += '<area shape="circle" coords="509, 89,3" href="javascript:selectTSpoints(60023,509, 89)">';
mtxt += '<area shape="circle" coords="514, 89,3" href="javascript:selectTSpoints(60024,514, 89)">';
mtxt += '<area shape="circle" coords="519, 89,3" href="javascript:selectTSpoints(60025,519, 89)">';
mtxt += '<area shape="circle" coords="524, 89,3" href="javascript:selectTSpoints(60026,524, 89)">';
mtxt += '<area shape="circle" coords="529, 89,3" href="javascript:selectTSpoints(60027,529, 89)">';
mtxt += '<area shape="circle" coords="534, 89,3" href="javascript:selectTSpoints(60028,534, 89)">';
mtxt += '<area shape="circle" coords="539, 89,3" href="javascript:selectTSpoints(60029,539, 89)">';
mtxt += '<area shape="circle" coords="544, 89,3" href="javascript:selectTSpoints(60030,544, 89)">';
mtxt += '<area shape="circle" coords="549, 89,3" href="javascript:selectTSpoints(60031,549, 89)">';
mtxt += '<area shape="circle" coords="554, 89,3" href="javascript:selectTSpoints(60032,554, 89)">';
mtxt += '<area shape="circle" coords="559, 89,3" href="javascript:selectTSpoints(60033,559, 89)">';
mtxt += '<area shape="circle" coords="565, 89,3" href="javascript:selectTSpoints(60034,565, 89)">';
mtxt += '<area shape="circle" coords="570, 89,3" href="javascript:selectTSpoints(60035,570, 89)">';
mtxt += '<area shape="circle" coords="575, 89,3" href="javascript:selectTSpoints(60036,575, 89)">';
mtxt += '<area shape="circle" coords="580, 89,3" href="javascript:selectTSpoints(60037,580, 89)">';
mtxt += '<area shape="circle" coords="585, 89,3" href="javascript:selectTSpoints(60038,585, 89)">';
mtxt += '<area shape="circle" coords="590, 89,3" href="javascript:selectTSpoints(60039,590, 89)">';
mtxt += '<area shape="circle" coords="595, 89,3" href="javascript:selectTSpoints(60040,595, 89)">';
mtxt += '<area shape="circle" coords="600, 89,3" href="javascript:selectTSpoints(60041,600, 89)">';
mtxt += '<area shape="circle" coords="605, 89,3" href="javascript:selectTSpoints(60042,605, 89)">';
mtxt += '<area shape="circle" coords="610, 89,3" href="javascript:selectTSpoints(60043,610, 89)">';
mtxt += '<area shape="circle" coords="615, 89,3" href="javascript:selectTSpoints(60044,615, 89)">';
mtxt += '<area shape="circle" coords="621, 89,3" href="javascript:selectTSpoints(60045,621, 89)">';
mtxt += '<area shape="circle" coords="626, 89,3" href="javascript:selectTSpoints(60046,626, 89)">';
mtxt += '<area shape="circle" coords="631, 89,3" href="javascript:selectTSpoints(60047,631, 89)">';
mtxt += '<area shape="circle" coords="636, 89,3" href="javascript:selectTSpoints(60048,636, 89)">';
mtxt += '<area shape="circle" coords="641, 89,3" href="javascript:selectTSpoints(60049,641, 89)">';
mtxt += '<area shape="circle" coords="646, 89,3" href="javascript:selectTSpoints(60050,646, 89)">';
mtxt += '<area shape="circle" coords="651, 89,3" href="javascript:selectTSpoints(60051,651, 89)">';
mtxt += '<area shape="circle" coords="656, 89,3" href="javascript:selectTSpoints(60052,656, 89)">';
mtxt += '<area shape="circle" coords="661, 89,3" href="javascript:selectTSpoints(60053,661, 89)">';
mtxt += '<area shape="circle" coords="666, 89,3" href="javascript:selectTSpoints(60054,666, 89)">';
mtxt += '<area shape="circle" coords="671, 89,3" href="javascript:selectTSpoints(60055,671, 89)">';
mtxt += '<area shape="circle" coords="677, 89,3" href="javascript:selectTSpoints(60056,677, 89)">';
mtxt += '<area shape="circle" coords="682, 89,3" href="javascript:selectTSpoints(60057,682, 89)">';
mtxt += '<area shape="circle" coords="687, 89,3" href="javascript:selectTSpoints(60058,687, 89)">';
mtxt += '<area shape="circle" coords="692, 89,3" href="javascript:selectTSpoints(60059,692, 89)">';
mtxt += '<area shape="circle" coords="697, 89,3" href="javascript:selectTSpoints(60060,697, 89)">';
mtxt += '<area shape="circle" coords="702, 89,3" href="javascript:selectTSpoints(60061,702, 89)">';
mtxt += '<area shape="circle" coords="707, 89,3" href="javascript:selectTSpoints(60062,707, 89)">';
mtxt += '<area shape="circle" coords="712, 89,3" href="javascript:selectTSpoints(60063,712, 89)">';
mtxt += '<area shape="circle" coords="717, 89,3" href="javascript:selectTSpoints(60064,717, 89)">';
mtxt += '<area shape="circle" coords="722, 89,3" href="javascript:selectTSpoints(60065,722, 89)">';
mtxt += '<area shape="circle" coords="727, 89,3" href="javascript:selectTSpoints(60066,727, 89)">';
mtxt += '<area shape="circle" coords="733, 89,3" href="javascript:selectTSpoints(60067,733, 89)">';
mtxt += '<area shape="circle" coords="738, 89,3" href="javascript:selectTSpoints(60068,738, 89)">';
mtxt += '<area shape="circle" coords="743, 89,3" href="javascript:selectTSpoints(60069,743, 89)">';
mtxt += '<area shape="circle" coords="748, 89,3" href="javascript:selectTSpoints(60070,748, 89)">';
mtxt += '<area shape="circle" coords="753, 89,3" href="javascript:selectTSpoints(60071,753, 89)">';
mtxt += '<area shape="circle" coords="758, 89,3" href="javascript:selectTSpoints(60072,758, 89)">';
mtxt += '<area shape="circle" coords=" 30, 84,3" href="javascript:selectTSpoints(61073, 30, 84)">';
mtxt += '<area shape="circle" coords=" 35, 84,3" href="javascript:selectTSpoints(61074, 35, 84)">';
mtxt += '<area shape="circle" coords=" 40, 84,3" href="javascript:selectTSpoints(61075, 40, 84)">';
mtxt += '<area shape="circle" coords=" 45, 84,3" href="javascript:selectTSpoints(61076, 45, 84)">';
mtxt += '<area shape="circle" coords=" 50, 84,3" href="javascript:selectTSpoints(61077, 50, 84)">';
mtxt += '<area shape="circle" coords=" 56, 84,3" href="javascript:selectTSpoints(61078, 56, 84)">';
mtxt += '<area shape="circle" coords=" 61, 84,3" href="javascript:selectTSpoints(61079, 61, 84)">';
mtxt += '<area shape="circle" coords=" 66, 84,3" href="javascript:selectTSpoints(61080, 66, 84)">';
mtxt += '<area shape="circle" coords=" 71, 84,3" href="javascript:selectTSpoints(61081, 71, 84)">';
mtxt += '<area shape="circle" coords=" 76, 84,3" href="javascript:selectTSpoints(61082, 76, 84)">';
mtxt += '<area shape="circle" coords=" 81, 84,3" href="javascript:selectTSpoints(61083, 81, 84)">';
mtxt += '<area shape="circle" coords=" 86, 84,3" href="javascript:selectTSpoints(61084, 86, 84)">';
mtxt += '<area shape="circle" coords=" 91, 84,3" href="javascript:selectTSpoints(61085, 91, 84)">';
mtxt += '<area shape="circle" coords=" 96, 84,3" href="javascript:selectTSpoints(61086, 96, 84)">';
mtxt += '<area shape="circle" coords="101, 84,3" href="javascript:selectTSpoints(61087,101, 84)">';
mtxt += '<area shape="circle" coords="106, 84,3" href="javascript:selectTSpoints(61088,106, 84)">';
mtxt += '<area shape="circle" coords="112, 84,3" href="javascript:selectTSpoints(61089,112, 84)">';
mtxt += '<area shape="circle" coords="117, 84,3" href="javascript:selectTSpoints(61090,117, 84)">';
mtxt += '<area shape="circle" coords="122, 84,3" href="javascript:selectTSpoints(61091,122, 84)">';
mtxt += '<area shape="circle" coords="127, 84,3" href="javascript:selectTSpoints(61092,127, 84)">';
mtxt += '<area shape="circle" coords="132, 84,3" href="javascript:selectTSpoints(61093,132, 84)">';
mtxt += '<area shape="circle" coords="137, 84,3" href="javascript:selectTSpoints(61094,137, 84)">';
mtxt += '<area shape="circle" coords="142, 84,3" href="javascript:selectTSpoints(61095,142, 84)">';
mtxt += '<area shape="circle" coords="147, 84,3" href="javascript:selectTSpoints(61096,147, 84)">';
mtxt += '<area shape="circle" coords="152, 84,3" href="javascript:selectTSpoints(61097,152, 84)">';
mtxt += '<area shape="circle" coords="157, 84,3" href="javascript:selectTSpoints(61098,157, 84)">';
mtxt += '<area shape="circle" coords="162, 84,3" href="javascript:selectTSpoints(61099,162, 84)">';
mtxt += '<area shape="circle" coords="168, 84,3" href="javascript:selectTSpoints(61100,168, 84)">';
mtxt += '<area shape="circle" coords="173, 84,3" href="javascript:selectTSpoints(61101,173, 84)">';
mtxt += '<area shape="circle" coords="178, 84,3" href="javascript:selectTSpoints(61102,178, 84)">';
mtxt += '<area shape="circle" coords="183, 84,3" href="javascript:selectTSpoints(61103,183, 84)">';
mtxt += '<area shape="circle" coords="188, 84,3" href="javascript:selectTSpoints(61104,188, 84)">';
mtxt += '<area shape="circle" coords="193, 84,3" href="javascript:selectTSpoints(61105,193, 84)">';
mtxt += '<area shape="circle" coords="198, 84,3" href="javascript:selectTSpoints(61106,198, 84)">';
mtxt += '<area shape="circle" coords="203, 84,3" href="javascript:selectTSpoints(61107,203, 84)">';
mtxt += '<area shape="circle" coords="208, 84,3" href="javascript:selectTSpoints(61108,208, 84)">';
mtxt += '<area shape="circle" coords="213, 84,3" href="javascript:selectTSpoints(61109,213, 84)">';
mtxt += '<area shape="circle" coords="218, 84,3" href="javascript:selectTSpoints(61110,218, 84)">';
mtxt += '<area shape="circle" coords="224, 84,3" href="javascript:selectTSpoints(61111,224, 84)">';
mtxt += '<area shape="circle" coords="229, 84,3" href="javascript:selectTSpoints(61112,229, 84)">';
mtxt += '<area shape="circle" coords="234, 84,3" href="javascript:selectTSpoints(61113,234, 84)">';
mtxt += '<area shape="circle" coords="239, 84,3" href="javascript:selectTSpoints(61114,239, 84)">';
mtxt += '<area shape="circle" coords="244, 84,3" href="javascript:selectTSpoints(61115,244, 84)">';
mtxt += '<area shape="circle" coords="249, 84,3" href="javascript:selectTSpoints(61116,249, 84)">';
mtxt += '<area shape="circle" coords="254, 84,3" href="javascript:selectTSpoints(61117,254, 84)">';
mtxt += '<area shape="circle" coords="259, 84,3" href="javascript:selectTSpoints(61118,259, 84)">';
mtxt += '<area shape="circle" coords="264, 84,3" href="javascript:selectTSpoints(61119,264, 84)">';
mtxt += '<area shape="circle" coords="269, 84,3" href="javascript:selectTSpoints(61120,269, 84)">';
mtxt += '<area shape="circle" coords="274, 84,3" href="javascript:selectTSpoints(61121,274, 84)">';
mtxt += '<area shape="circle" coords="280, 84,3" href="javascript:selectTSpoints(61122,280, 84)">';
mtxt += '<area shape="circle" coords="285, 84,3" href="javascript:selectTSpoints(61123,285, 84)">';
mtxt += '<area shape="circle" coords="290, 84,3" href="javascript:selectTSpoints(61124,290, 84)">';
mtxt += '<area shape="circle" coords="295, 84,3" href="javascript:selectTSpoints(61125,295, 84)">';
mtxt += '<area shape="circle" coords="300, 84,3" href="javascript:selectTSpoints(61126,300, 84)">';
mtxt += '<area shape="circle" coords="305, 84,3" href="javascript:selectTSpoints(61127,305, 84)">';
mtxt += '<area shape="circle" coords="310, 84,3" href="javascript:selectTSpoints(61128,310, 84)">';
mtxt += '<area shape="circle" coords="315, 84,3" href="javascript:selectTSpoints(61129,315, 84)">';
mtxt += '<area shape="circle" coords="320, 84,3" href="javascript:selectTSpoints(61130,320, 84)">';
mtxt += '<area shape="circle" coords="325, 84,3" href="javascript:selectTSpoints(61131,325, 84)">';
mtxt += '<area shape="circle" coords="330, 84,3" href="javascript:selectTSpoints(61132,330, 84)">';
mtxt += '<area shape="circle" coords="336, 84,3" href="javascript:selectTSpoints(61133,336, 84)">';
mtxt += '<area shape="circle" coords="341, 84,3" href="javascript:selectTSpoints(61134,341, 84)">';
mtxt += '<area shape="circle" coords="346, 84,3" href="javascript:selectTSpoints(61135,346, 84)">';
mtxt += '<area shape="circle" coords="351, 84,3" href="javascript:selectTSpoints(61136,351, 84)">';
mtxt += '<area shape="circle" coords="356, 84,3" href="javascript:selectTSpoints(61137,356, 84)">';
mtxt += '<area shape="circle" coords="361, 84,3" href="javascript:selectTSpoints(61138,361, 84)">';
mtxt += '<area shape="circle" coords="366, 84,3" href="javascript:selectTSpoints(61139,366, 84)">';
mtxt += '<area shape="circle" coords="371, 84,3" href="javascript:selectTSpoints(61140,371, 84)">';
mtxt += '<area shape="circle" coords="376, 84,3" href="javascript:selectTSpoints(61141,376, 84)">';
mtxt += '<area shape="circle" coords="381, 84,3" href="javascript:selectTSpoints(61142,381, 84)">';
mtxt += '<area shape="circle" coords="386, 84,3" href="javascript:selectTSpoints(61143,386, 84)">';
mtxt += '<area shape="circle" coords="392, 84,3" href="javascript:selectTSpoints(61144,392, 84)">';
mtxt += '<area shape="circle" coords="397, 84,3" href="javascript:selectTSpoints(61001,397, 84)">';
mtxt += '<area shape="circle" coords="402, 84,3" href="javascript:selectTSpoints(61002,402, 84)">';
mtxt += '<area shape="circle" coords="407, 84,3" href="javascript:selectTSpoints(61003,407, 84)">';
mtxt += '<area shape="circle" coords="412, 84,3" href="javascript:selectTSpoints(61004,412, 84)">';
mtxt += '<area shape="circle" coords="417, 84,3" href="javascript:selectTSpoints(61005,417, 84)">';
mtxt += '<area shape="circle" coords="422, 84,3" href="javascript:selectTSpoints(61006,422, 84)">';
mtxt += '<area shape="circle" coords="427, 84,3" href="javascript:selectTSpoints(61007,427, 84)">';
mtxt += '<area shape="circle" coords="432, 84,3" href="javascript:selectTSpoints(61008,432, 84)">';
mtxt += '<area shape="circle" coords="437, 84,3" href="javascript:selectTSpoints(61009,437, 84)">';
mtxt += '<area shape="circle" coords="442, 84,3" href="javascript:selectTSpoints(61010,442, 84)">';
mtxt += '<area shape="circle" coords="447, 84,3" href="javascript:selectTSpoints(61011,447, 84)">';
mtxt += '<area shape="circle" coords="453, 84,3" href="javascript:selectTSpoints(61012,453, 84)">';
mtxt += '<area shape="circle" coords="458, 84,3" href="javascript:selectTSpoints(61013,458, 84)">';
mtxt += '<area shape="circle" coords="463, 84,3" href="javascript:selectTSpoints(61014,463, 84)">';
mtxt += '<area shape="circle" coords="468, 84,3" href="javascript:selectTSpoints(61015,468, 84)">';
mtxt += '<area shape="circle" coords="473, 84,3" href="javascript:selectTSpoints(61016,473, 84)">';
mtxt += '<area shape="circle" coords="478, 84,3" href="javascript:selectTSpoints(61017,478, 84)">';
mtxt += '<area shape="circle" coords="483, 84,3" href="javascript:selectTSpoints(61018,483, 84)">';
mtxt += '<area shape="circle" coords="488, 84,3" href="javascript:selectTSpoints(61019,488, 84)">';
mtxt += '<area shape="circle" coords="493, 84,3" href="javascript:selectTSpoints(61020,493, 84)">';
mtxt += '<area shape="circle" coords="498, 84,3" href="javascript:selectTSpoints(61021,498, 84)">';
mtxt += '<area shape="circle" coords="503, 84,3" href="javascript:selectTSpoints(61022,503, 84)">';
mtxt += '<area shape="circle" coords="509, 84,3" href="javascript:selectTSpoints(61023,509, 84)">';
mtxt += '<area shape="circle" coords="514, 84,3" href="javascript:selectTSpoints(61024,514, 84)">';
mtxt += '<area shape="circle" coords="519, 84,3" href="javascript:selectTSpoints(61025,519, 84)">';
mtxt += '<area shape="circle" coords="524, 84,3" href="javascript:selectTSpoints(61026,524, 84)">';
mtxt += '<area shape="circle" coords="529, 84,3" href="javascript:selectTSpoints(61027,529, 84)">';
mtxt += '<area shape="circle" coords="534, 84,3" href="javascript:selectTSpoints(61028,534, 84)">';
mtxt += '<area shape="circle" coords="539, 84,3" href="javascript:selectTSpoints(61029,539, 84)">';
mtxt += '<area shape="circle" coords="544, 84,3" href="javascript:selectTSpoints(61030,544, 84)">';
mtxt += '<area shape="circle" coords="549, 84,3" href="javascript:selectTSpoints(61031,549, 84)">';
mtxt += '<area shape="circle" coords="554, 84,3" href="javascript:selectTSpoints(61032,554, 84)">';
mtxt += '<area shape="circle" coords="559, 84,3" href="javascript:selectTSpoints(61033,559, 84)">';
mtxt += '<area shape="circle" coords="565, 84,3" href="javascript:selectTSpoints(61034,565, 84)">';
mtxt += '<area shape="circle" coords="570, 84,3" href="javascript:selectTSpoints(61035,570, 84)">';
mtxt += '<area shape="circle" coords="575, 84,3" href="javascript:selectTSpoints(61036,575, 84)">';
mtxt += '<area shape="circle" coords="580, 84,3" href="javascript:selectTSpoints(61037,580, 84)">';
mtxt += '<area shape="circle" coords="585, 84,3" href="javascript:selectTSpoints(61038,585, 84)">';
mtxt += '<area shape="circle" coords="590, 84,3" href="javascript:selectTSpoints(61039,590, 84)">';
mtxt += '<area shape="circle" coords="595, 84,3" href="javascript:selectTSpoints(61040,595, 84)">';
mtxt += '<area shape="circle" coords="600, 84,3" href="javascript:selectTSpoints(61041,600, 84)">';
mtxt += '<area shape="circle" coords="605, 84,3" href="javascript:selectTSpoints(61042,605, 84)">';
mtxt += '<area shape="circle" coords="610, 84,3" href="javascript:selectTSpoints(61043,610, 84)">';
mtxt += '<area shape="circle" coords="615, 84,3" href="javascript:selectTSpoints(61044,615, 84)">';
mtxt += '<area shape="circle" coords="621, 84,3" href="javascript:selectTSpoints(61045,621, 84)">';
mtxt += '<area shape="circle" coords="626, 84,3" href="javascript:selectTSpoints(61046,626, 84)">';
mtxt += '<area shape="circle" coords="631, 84,3" href="javascript:selectTSpoints(61047,631, 84)">';
mtxt += '<area shape="circle" coords="636, 84,3" href="javascript:selectTSpoints(61048,636, 84)">';
mtxt += '<area shape="circle" coords="641, 84,3" href="javascript:selectTSpoints(61049,641, 84)">';
mtxt += '<area shape="circle" coords="646, 84,3" href="javascript:selectTSpoints(61050,646, 84)">';
mtxt += '<area shape="circle" coords="651, 84,3" href="javascript:selectTSpoints(61051,651, 84)">';
mtxt += '<area shape="circle" coords="656, 84,3" href="javascript:selectTSpoints(61052,656, 84)">';
mtxt += '<area shape="circle" coords="661, 84,3" href="javascript:selectTSpoints(61053,661, 84)">';
mtxt += '<area shape="circle" coords="666, 84,3" href="javascript:selectTSpoints(61054,666, 84)">';
mtxt += '<area shape="circle" coords="671, 84,3" href="javascript:selectTSpoints(61055,671, 84)">';
mtxt += '<area shape="circle" coords="677, 84,3" href="javascript:selectTSpoints(61056,677, 84)">';
mtxt += '<area shape="circle" coords="682, 84,3" href="javascript:selectTSpoints(61057,682, 84)">';
mtxt += '<area shape="circle" coords="687, 84,3" href="javascript:selectTSpoints(61058,687, 84)">';
mtxt += '<area shape="circle" coords="692, 84,3" href="javascript:selectTSpoints(61059,692, 84)">';
mtxt += '<area shape="circle" coords="697, 84,3" href="javascript:selectTSpoints(61060,697, 84)">';
mtxt += '<area shape="circle" coords="702, 84,3" href="javascript:selectTSpoints(61061,702, 84)">';
mtxt += '<area shape="circle" coords="707, 84,3" href="javascript:selectTSpoints(61062,707, 84)">';
mtxt += '<area shape="circle" coords="712, 84,3" href="javascript:selectTSpoints(61063,712, 84)">';
mtxt += '<area shape="circle" coords="717, 84,3" href="javascript:selectTSpoints(61064,717, 84)">';
mtxt += '<area shape="circle" coords="722, 84,3" href="javascript:selectTSpoints(61065,722, 84)">';
mtxt += '<area shape="circle" coords="727, 84,3" href="javascript:selectTSpoints(61066,727, 84)">';
mtxt += '<area shape="circle" coords="733, 84,3" href="javascript:selectTSpoints(61067,733, 84)">';
mtxt += '<area shape="circle" coords="738, 84,3" href="javascript:selectTSpoints(61068,738, 84)">';
mtxt += '<area shape="circle" coords="743, 84,3" href="javascript:selectTSpoints(61069,743, 84)">';
mtxt += '<area shape="circle" coords="748, 84,3" href="javascript:selectTSpoints(61070,748, 84)">';
mtxt += '<area shape="circle" coords="753, 84,3" href="javascript:selectTSpoints(61071,753, 84)">';
mtxt += '<area shape="circle" coords="758, 84,3" href="javascript:selectTSpoints(61072,758, 84)">';
mtxt += '<area shape="circle" coords=" 30, 79,3" href="javascript:selectTSpoints(62073, 30, 79)">';
mtxt += '<area shape="circle" coords=" 35, 79,3" href="javascript:selectTSpoints(62074, 35, 79)">';
mtxt += '<area shape="circle" coords=" 40, 79,3" href="javascript:selectTSpoints(62075, 40, 79)">';
mtxt += '<area shape="circle" coords=" 45, 79,3" href="javascript:selectTSpoints(62076, 45, 79)">';
mtxt += '<area shape="circle" coords=" 50, 79,3" href="javascript:selectTSpoints(62077, 50, 79)">';
mtxt += '<area shape="circle" coords=" 56, 79,3" href="javascript:selectTSpoints(62078, 56, 79)">';
mtxt += '<area shape="circle" coords=" 61, 79,3" href="javascript:selectTSpoints(62079, 61, 79)">';
mtxt += '<area shape="circle" coords=" 66, 79,3" href="javascript:selectTSpoints(62080, 66, 79)">';
mtxt += '<area shape="circle" coords=" 71, 79,3" href="javascript:selectTSpoints(62081, 71, 79)">';
mtxt += '<area shape="circle" coords=" 76, 79,3" href="javascript:selectTSpoints(62082, 76, 79)">';
mtxt += '<area shape="circle" coords=" 81, 79,3" href="javascript:selectTSpoints(62083, 81, 79)">';
mtxt += '<area shape="circle" coords=" 86, 79,3" href="javascript:selectTSpoints(62084, 86, 79)">';
mtxt += '<area shape="circle" coords=" 91, 79,3" href="javascript:selectTSpoints(62085, 91, 79)">';
mtxt += '<area shape="circle" coords=" 96, 79,3" href="javascript:selectTSpoints(62086, 96, 79)">';
mtxt += '<area shape="circle" coords="101, 79,3" href="javascript:selectTSpoints(62087,101, 79)">';
mtxt += '<area shape="circle" coords="106, 79,3" href="javascript:selectTSpoints(62088,106, 79)">';
mtxt += '<area shape="circle" coords="112, 79,3" href="javascript:selectTSpoints(62089,112, 79)">';
mtxt += '<area shape="circle" coords="117, 79,3" href="javascript:selectTSpoints(62090,117, 79)">';
mtxt += '<area shape="circle" coords="122, 79,3" href="javascript:selectTSpoints(62091,122, 79)">';
mtxt += '<area shape="circle" coords="127, 79,3" href="javascript:selectTSpoints(62092,127, 79)">';
mtxt += '<area shape="circle" coords="132, 79,3" href="javascript:selectTSpoints(62093,132, 79)">';
mtxt += '<area shape="circle" coords="137, 79,3" href="javascript:selectTSpoints(62094,137, 79)">';
mtxt += '<area shape="circle" coords="142, 79,3" href="javascript:selectTSpoints(62095,142, 79)">';
mtxt += '<area shape="circle" coords="147, 79,3" href="javascript:selectTSpoints(62096,147, 79)">';
mtxt += '<area shape="circle" coords="152, 79,3" href="javascript:selectTSpoints(62097,152, 79)">';
mtxt += '<area shape="circle" coords="157, 79,3" href="javascript:selectTSpoints(62098,157, 79)">';
mtxt += '<area shape="circle" coords="162, 79,3" href="javascript:selectTSpoints(62099,162, 79)">';
mtxt += '<area shape="circle" coords="168, 79,3" href="javascript:selectTSpoints(62100,168, 79)">';
mtxt += '<area shape="circle" coords="173, 79,3" href="javascript:selectTSpoints(62101,173, 79)">';
mtxt += '<area shape="circle" coords="178, 79,3" href="javascript:selectTSpoints(62102,178, 79)">';
mtxt += '<area shape="circle" coords="183, 79,3" href="javascript:selectTSpoints(62103,183, 79)">';
mtxt += '<area shape="circle" coords="188, 79,3" href="javascript:selectTSpoints(62104,188, 79)">';
mtxt += '<area shape="circle" coords="193, 79,3" href="javascript:selectTSpoints(62105,193, 79)">';
mtxt += '<area shape="circle" coords="198, 79,3" href="javascript:selectTSpoints(62106,198, 79)">';
mtxt += '<area shape="circle" coords="203, 79,3" href="javascript:selectTSpoints(62107,203, 79)">';
mtxt += '<area shape="circle" coords="208, 79,3" href="javascript:selectTSpoints(62108,208, 79)">';
mtxt += '<area shape="circle" coords="213, 79,3" href="javascript:selectTSpoints(62109,213, 79)">';
mtxt += '<area shape="circle" coords="218, 79,3" href="javascript:selectTSpoints(62110,218, 79)">';
mtxt += '<area shape="circle" coords="224, 79,3" href="javascript:selectTSpoints(62111,224, 79)">';
mtxt += '<area shape="circle" coords="229, 79,3" href="javascript:selectTSpoints(62112,229, 79)">';
mtxt += '<area shape="circle" coords="234, 79,3" href="javascript:selectTSpoints(62113,234, 79)">';
mtxt += '<area shape="circle" coords="239, 79,3" href="javascript:selectTSpoints(62114,239, 79)">';
mtxt += '<area shape="circle" coords="244, 79,3" href="javascript:selectTSpoints(62115,244, 79)">';
mtxt += '<area shape="circle" coords="249, 79,3" href="javascript:selectTSpoints(62116,249, 79)">';
mtxt += '<area shape="circle" coords="254, 79,3" href="javascript:selectTSpoints(62117,254, 79)">';
mtxt += '<area shape="circle" coords="259, 79,3" href="javascript:selectTSpoints(62118,259, 79)">';
mtxt += '<area shape="circle" coords="264, 79,3" href="javascript:selectTSpoints(62119,264, 79)">';
mtxt += '<area shape="circle" coords="269, 79,3" href="javascript:selectTSpoints(62120,269, 79)">';
mtxt += '<area shape="circle" coords="274, 79,3" href="javascript:selectTSpoints(62121,274, 79)">';
mtxt += '<area shape="circle" coords="280, 79,3" href="javascript:selectTSpoints(62122,280, 79)">';
mtxt += '<area shape="circle" coords="285, 79,3" href="javascript:selectTSpoints(62123,285, 79)">';
mtxt += '<area shape="circle" coords="290, 79,3" href="javascript:selectTSpoints(62124,290, 79)">';
mtxt += '<area shape="circle" coords="295, 79,3" href="javascript:selectTSpoints(62125,295, 79)">';
mtxt += '<area shape="circle" coords="300, 79,3" href="javascript:selectTSpoints(62126,300, 79)">';
mtxt += '<area shape="circle" coords="305, 79,3" href="javascript:selectTSpoints(62127,305, 79)">';
mtxt += '<area shape="circle" coords="310, 79,3" href="javascript:selectTSpoints(62128,310, 79)">';
mtxt += '<area shape="circle" coords="315, 79,3" href="javascript:selectTSpoints(62129,315, 79)">';
mtxt += '<area shape="circle" coords="320, 79,3" href="javascript:selectTSpoints(62130,320, 79)">';
mtxt += '<area shape="circle" coords="325, 79,3" href="javascript:selectTSpoints(62131,325, 79)">';
mtxt += '<area shape="circle" coords="330, 79,3" href="javascript:selectTSpoints(62132,330, 79)">';
mtxt += '<area shape="circle" coords="336, 79,3" href="javascript:selectTSpoints(62133,336, 79)">';
mtxt += '<area shape="circle" coords="341, 79,3" href="javascript:selectTSpoints(62134,341, 79)">';
mtxt += '<area shape="circle" coords="346, 79,3" href="javascript:selectTSpoints(62135,346, 79)">';
mtxt += '<area shape="circle" coords="351, 79,3" href="javascript:selectTSpoints(62136,351, 79)">';
mtxt += '<area shape="circle" coords="356, 79,3" href="javascript:selectTSpoints(62137,356, 79)">';
mtxt += '<area shape="circle" coords="361, 79,3" href="javascript:selectTSpoints(62138,361, 79)">';
mtxt += '<area shape="circle" coords="366, 79,3" href="javascript:selectTSpoints(62139,366, 79)">';
mtxt += '<area shape="circle" coords="371, 79,3" href="javascript:selectTSpoints(62140,371, 79)">';
mtxt += '<area shape="circle" coords="376, 79,3" href="javascript:selectTSpoints(62141,376, 79)">';
mtxt += '<area shape="circle" coords="381, 79,3" href="javascript:selectTSpoints(62142,381, 79)">';
mtxt += '<area shape="circle" coords="386, 79,3" href="javascript:selectTSpoints(62143,386, 79)">';
mtxt += '<area shape="circle" coords="392, 79,3" href="javascript:selectTSpoints(62144,392, 79)">';
mtxt += '<area shape="circle" coords="397, 79,3" href="javascript:selectTSpoints(62001,397, 79)">';
mtxt += '<area shape="circle" coords="402, 79,3" href="javascript:selectTSpoints(62002,402, 79)">';
mtxt += '<area shape="circle" coords="407, 79,3" href="javascript:selectTSpoints(62003,407, 79)">';
mtxt += '<area shape="circle" coords="412, 79,3" href="javascript:selectTSpoints(62004,412, 79)">';
mtxt += '<area shape="circle" coords="417, 79,3" href="javascript:selectTSpoints(62005,417, 79)">';
mtxt += '<area shape="circle" coords="422, 79,3" href="javascript:selectTSpoints(62006,422, 79)">';
mtxt += '<area shape="circle" coords="427, 79,3" href="javascript:selectTSpoints(62007,427, 79)">';
mtxt += '<area shape="circle" coords="432, 79,3" href="javascript:selectTSpoints(62008,432, 79)">';
mtxt += '<area shape="circle" coords="437, 79,3" href="javascript:selectTSpoints(62009,437, 79)">';
mtxt += '<area shape="circle" coords="442, 79,3" href="javascript:selectTSpoints(62010,442, 79)">';
mtxt += '<area shape="circle" coords="447, 79,3" href="javascript:selectTSpoints(62011,447, 79)">';
mtxt += '<area shape="circle" coords="453, 79,3" href="javascript:selectTSpoints(62012,453, 79)">';
mtxt += '<area shape="circle" coords="458, 79,3" href="javascript:selectTSpoints(62013,458, 79)">';
mtxt += '<area shape="circle" coords="463, 79,3" href="javascript:selectTSpoints(62014,463, 79)">';
mtxt += '<area shape="circle" coords="468, 79,3" href="javascript:selectTSpoints(62015,468, 79)">';
mtxt += '<area shape="circle" coords="473, 79,3" href="javascript:selectTSpoints(62016,473, 79)">';
mtxt += '<area shape="circle" coords="478, 79,3" href="javascript:selectTSpoints(62017,478, 79)">';
mtxt += '<area shape="circle" coords="483, 79,3" href="javascript:selectTSpoints(62018,483, 79)">';
mtxt += '<area shape="circle" coords="488, 79,3" href="javascript:selectTSpoints(62019,488, 79)">';
mtxt += '<area shape="circle" coords="493, 79,3" href="javascript:selectTSpoints(62020,493, 79)">';
mtxt += '<area shape="circle" coords="498, 79,3" href="javascript:selectTSpoints(62021,498, 79)">';
mtxt += '<area shape="circle" coords="503, 79,3" href="javascript:selectTSpoints(62022,503, 79)">';
mtxt += '<area shape="circle" coords="509, 79,3" href="javascript:selectTSpoints(62023,509, 79)">';
mtxt += '<area shape="circle" coords="514, 79,3" href="javascript:selectTSpoints(62024,514, 79)">';
mtxt += '<area shape="circle" coords="519, 79,3" href="javascript:selectTSpoints(62025,519, 79)">';
mtxt += '<area shape="circle" coords="524, 79,3" href="javascript:selectTSpoints(62026,524, 79)">';
mtxt += '<area shape="circle" coords="529, 79,3" href="javascript:selectTSpoints(62027,529, 79)">';
mtxt += '<area shape="circle" coords="534, 79,3" href="javascript:selectTSpoints(62028,534, 79)">';
mtxt += '<area shape="circle" coords="539, 79,3" href="javascript:selectTSpoints(62029,539, 79)">';
mtxt += '<area shape="circle" coords="544, 79,3" href="javascript:selectTSpoints(62030,544, 79)">';
mtxt += '<area shape="circle" coords="549, 79,3" href="javascript:selectTSpoints(62031,549, 79)">';
mtxt += '<area shape="circle" coords="554, 79,3" href="javascript:selectTSpoints(62032,554, 79)">';
mtxt += '<area shape="circle" coords="559, 79,3" href="javascript:selectTSpoints(62033,559, 79)">';
mtxt += '<area shape="circle" coords="565, 79,3" href="javascript:selectTSpoints(62034,565, 79)">';
mtxt += '<area shape="circle" coords="570, 79,3" href="javascript:selectTSpoints(62035,570, 79)">';
mtxt += '<area shape="circle" coords="575, 79,3" href="javascript:selectTSpoints(62036,575, 79)">';
mtxt += '<area shape="circle" coords="580, 79,3" href="javascript:selectTSpoints(62037,580, 79)">';
mtxt += '<area shape="circle" coords="585, 79,3" href="javascript:selectTSpoints(62038,585, 79)">';
mtxt += '<area shape="circle" coords="590, 79,3" href="javascript:selectTSpoints(62039,590, 79)">';
mtxt += '<area shape="circle" coords="595, 79,3" href="javascript:selectTSpoints(62040,595, 79)">';
mtxt += '<area shape="circle" coords="600, 79,3" href="javascript:selectTSpoints(62041,600, 79)">';
mtxt += '<area shape="circle" coords="605, 79,3" href="javascript:selectTSpoints(62042,605, 79)">';
mtxt += '<area shape="circle" coords="610, 79,3" href="javascript:selectTSpoints(62043,610, 79)">';
mtxt += '<area shape="circle" coords="615, 79,3" href="javascript:selectTSpoints(62044,615, 79)">';
mtxt += '<area shape="circle" coords="621, 79,3" href="javascript:selectTSpoints(62045,621, 79)">';
mtxt += '<area shape="circle" coords="626, 79,3" href="javascript:selectTSpoints(62046,626, 79)">';
mtxt += '<area shape="circle" coords="631, 79,3" href="javascript:selectTSpoints(62047,631, 79)">';
mtxt += '<area shape="circle" coords="636, 79,3" href="javascript:selectTSpoints(62048,636, 79)">';
mtxt += '<area shape="circle" coords="641, 79,3" href="javascript:selectTSpoints(62049,641, 79)">';
mtxt += '<area shape="circle" coords="646, 79,3" href="javascript:selectTSpoints(62050,646, 79)">';
mtxt += '<area shape="circle" coords="651, 79,3" href="javascript:selectTSpoints(62051,651, 79)">';
mtxt += '<area shape="circle" coords="656, 79,3" href="javascript:selectTSpoints(62052,656, 79)">';
mtxt += '<area shape="circle" coords="661, 79,3" href="javascript:selectTSpoints(62053,661, 79)">';
mtxt += '<area shape="circle" coords="666, 79,3" href="javascript:selectTSpoints(62054,666, 79)">';
mtxt += '<area shape="circle" coords="671, 79,3" href="javascript:selectTSpoints(62055,671, 79)">';
mtxt += '<area shape="circle" coords="677, 79,3" href="javascript:selectTSpoints(62056,677, 79)">';
mtxt += '<area shape="circle" coords="682, 79,3" href="javascript:selectTSpoints(62057,682, 79)">';
mtxt += '<area shape="circle" coords="687, 79,3" href="javascript:selectTSpoints(62058,687, 79)">';
mtxt += '<area shape="circle" coords="692, 79,3" href="javascript:selectTSpoints(62059,692, 79)">';
mtxt += '<area shape="circle" coords="697, 79,3" href="javascript:selectTSpoints(62060,697, 79)">';
mtxt += '<area shape="circle" coords="702, 79,3" href="javascript:selectTSpoints(62061,702, 79)">';
mtxt += '<area shape="circle" coords="707, 79,3" href="javascript:selectTSpoints(62062,707, 79)">';
mtxt += '<area shape="circle" coords="712, 79,3" href="javascript:selectTSpoints(62063,712, 79)">';
mtxt += '<area shape="circle" coords="717, 79,3" href="javascript:selectTSpoints(62064,717, 79)">';
mtxt += '<area shape="circle" coords="722, 79,3" href="javascript:selectTSpoints(62065,722, 79)">';
mtxt += '<area shape="circle" coords="727, 79,3" href="javascript:selectTSpoints(62066,727, 79)">';
mtxt += '<area shape="circle" coords="733, 79,3" href="javascript:selectTSpoints(62067,733, 79)">';
mtxt += '<area shape="circle" coords="738, 79,3" href="javascript:selectTSpoints(62068,738, 79)">';
mtxt += '<area shape="circle" coords="743, 79,3" href="javascript:selectTSpoints(62069,743, 79)">';
mtxt += '<area shape="circle" coords="748, 79,3" href="javascript:selectTSpoints(62070,748, 79)">';
mtxt += '<area shape="circle" coords="753, 79,3" href="javascript:selectTSpoints(62071,753, 79)">';
mtxt += '<area shape="circle" coords="758, 79,3" href="javascript:selectTSpoints(62072,758, 79)">';
mtxt += '<area shape="circle" coords=" 30, 74,3" href="javascript:selectTSpoints(63073, 30, 74)">';
mtxt += '<area shape="circle" coords=" 35, 74,3" href="javascript:selectTSpoints(63074, 35, 74)">';
mtxt += '<area shape="circle" coords=" 40, 74,3" href="javascript:selectTSpoints(63075, 40, 74)">';
mtxt += '<area shape="circle" coords=" 45, 74,3" href="javascript:selectTSpoints(63076, 45, 74)">';
mtxt += '<area shape="circle" coords=" 50, 74,3" href="javascript:selectTSpoints(63077, 50, 74)">';
mtxt += '<area shape="circle" coords=" 56, 74,3" href="javascript:selectTSpoints(63078, 56, 74)">';
mtxt += '<area shape="circle" coords=" 61, 74,3" href="javascript:selectTSpoints(63079, 61, 74)">';
mtxt += '<area shape="circle" coords=" 66, 74,3" href="javascript:selectTSpoints(63080, 66, 74)">';
mtxt += '<area shape="circle" coords=" 71, 74,3" href="javascript:selectTSpoints(63081, 71, 74)">';
mtxt += '<area shape="circle" coords=" 76, 74,3" href="javascript:selectTSpoints(63082, 76, 74)">';
mtxt += '<area shape="circle" coords=" 81, 74,3" href="javascript:selectTSpoints(63083, 81, 74)">';
mtxt += '<area shape="circle" coords=" 86, 74,3" href="javascript:selectTSpoints(63084, 86, 74)">';
mtxt += '<area shape="circle" coords=" 91, 74,3" href="javascript:selectTSpoints(63085, 91, 74)">';
mtxt += '<area shape="circle" coords=" 96, 74,3" href="javascript:selectTSpoints(63086, 96, 74)">';
mtxt += '<area shape="circle" coords="101, 74,3" href="javascript:selectTSpoints(63087,101, 74)">';
mtxt += '<area shape="circle" coords="106, 74,3" href="javascript:selectTSpoints(63088,106, 74)">';
mtxt += '<area shape="circle" coords="112, 74,3" href="javascript:selectTSpoints(63089,112, 74)">';
mtxt += '<area shape="circle" coords="117, 74,3" href="javascript:selectTSpoints(63090,117, 74)">';
mtxt += '<area shape="circle" coords="122, 74,3" href="javascript:selectTSpoints(63091,122, 74)">';
mtxt += '<area shape="circle" coords="127, 74,3" href="javascript:selectTSpoints(63092,127, 74)">';
mtxt += '<area shape="circle" coords="132, 74,3" href="javascript:selectTSpoints(63093,132, 74)">';
mtxt += '<area shape="circle" coords="137, 74,3" href="javascript:selectTSpoints(63094,137, 74)">';
mtxt += '<area shape="circle" coords="142, 74,3" href="javascript:selectTSpoints(63095,142, 74)">';
mtxt += '<area shape="circle" coords="147, 74,3" href="javascript:selectTSpoints(63096,147, 74)">';
mtxt += '<area shape="circle" coords="152, 74,3" href="javascript:selectTSpoints(63097,152, 74)">';
mtxt += '<area shape="circle" coords="157, 74,3" href="javascript:selectTSpoints(63098,157, 74)">';
mtxt += '<area shape="circle" coords="162, 74,3" href="javascript:selectTSpoints(63099,162, 74)">';
mtxt += '<area shape="circle" coords="168, 74,3" href="javascript:selectTSpoints(63100,168, 74)">';
mtxt += '<area shape="circle" coords="173, 74,3" href="javascript:selectTSpoints(63101,173, 74)">';
mtxt += '<area shape="circle" coords="178, 74,3" href="javascript:selectTSpoints(63102,178, 74)">';
mtxt += '<area shape="circle" coords="183, 74,3" href="javascript:selectTSpoints(63103,183, 74)">';
mtxt += '<area shape="circle" coords="188, 74,3" href="javascript:selectTSpoints(63104,188, 74)">';
mtxt += '<area shape="circle" coords="193, 74,3" href="javascript:selectTSpoints(63105,193, 74)">';
mtxt += '<area shape="circle" coords="198, 74,3" href="javascript:selectTSpoints(63106,198, 74)">';
mtxt += '<area shape="circle" coords="203, 74,3" href="javascript:selectTSpoints(63107,203, 74)">';
mtxt += '<area shape="circle" coords="208, 74,3" href="javascript:selectTSpoints(63108,208, 74)">';
mtxt += '<area shape="circle" coords="213, 74,3" href="javascript:selectTSpoints(63109,213, 74)">';
mtxt += '<area shape="circle" coords="218, 74,3" href="javascript:selectTSpoints(63110,218, 74)">';
mtxt += '<area shape="circle" coords="224, 74,3" href="javascript:selectTSpoints(63111,224, 74)">';
mtxt += '<area shape="circle" coords="229, 74,3" href="javascript:selectTSpoints(63112,229, 74)">';
mtxt += '<area shape="circle" coords="234, 74,3" href="javascript:selectTSpoints(63113,234, 74)">';
mtxt += '<area shape="circle" coords="239, 74,3" href="javascript:selectTSpoints(63114,239, 74)">';
mtxt += '<area shape="circle" coords="244, 74,3" href="javascript:selectTSpoints(63115,244, 74)">';
mtxt += '<area shape="circle" coords="249, 74,3" href="javascript:selectTSpoints(63116,249, 74)">';
mtxt += '<area shape="circle" coords="254, 74,3" href="javascript:selectTSpoints(63117,254, 74)">';
mtxt += '<area shape="circle" coords="259, 74,3" href="javascript:selectTSpoints(63118,259, 74)">';
mtxt += '<area shape="circle" coords="264, 74,3" href="javascript:selectTSpoints(63119,264, 74)">';
mtxt += '<area shape="circle" coords="269, 74,3" href="javascript:selectTSpoints(63120,269, 74)">';
mtxt += '<area shape="circle" coords="274, 74,3" href="javascript:selectTSpoints(63121,274, 74)">';
mtxt += '<area shape="circle" coords="280, 74,3" href="javascript:selectTSpoints(63122,280, 74)">';
mtxt += '<area shape="circle" coords="285, 74,3" href="javascript:selectTSpoints(63123,285, 74)">';
mtxt += '<area shape="circle" coords="290, 74,3" href="javascript:selectTSpoints(63124,290, 74)">';
mtxt += '<area shape="circle" coords="295, 74,3" href="javascript:selectTSpoints(63125,295, 74)">';
mtxt += '<area shape="circle" coords="300, 74,3" href="javascript:selectTSpoints(63126,300, 74)">';
mtxt += '<area shape="circle" coords="305, 74,3" href="javascript:selectTSpoints(63127,305, 74)">';
mtxt += '<area shape="circle" coords="310, 74,3" href="javascript:selectTSpoints(63128,310, 74)">';
mtxt += '<area shape="circle" coords="315, 74,3" href="javascript:selectTSpoints(63129,315, 74)">';
mtxt += '<area shape="circle" coords="320, 74,3" href="javascript:selectTSpoints(63130,320, 74)">';
mtxt += '<area shape="circle" coords="325, 74,3" href="javascript:selectTSpoints(63131,325, 74)">';
mtxt += '<area shape="circle" coords="330, 74,3" href="javascript:selectTSpoints(63132,330, 74)">';
mtxt += '<area shape="circle" coords="336, 74,3" href="javascript:selectTSpoints(63133,336, 74)">';
mtxt += '<area shape="circle" coords="341, 74,3" href="javascript:selectTSpoints(63134,341, 74)">';
mtxt += '<area shape="circle" coords="346, 74,3" href="javascript:selectTSpoints(63135,346, 74)">';
mtxt += '<area shape="circle" coords="351, 74,3" href="javascript:selectTSpoints(63136,351, 74)">';
mtxt += '<area shape="circle" coords="356, 74,3" href="javascript:selectTSpoints(63137,356, 74)">';
mtxt += '<area shape="circle" coords="361, 74,3" href="javascript:selectTSpoints(63138,361, 74)">';
mtxt += '<area shape="circle" coords="366, 74,3" href="javascript:selectTSpoints(63139,366, 74)">';
mtxt += '<area shape="circle" coords="371, 74,3" href="javascript:selectTSpoints(63140,371, 74)">';
mtxt += '<area shape="circle" coords="376, 74,3" href="javascript:selectTSpoints(63141,376, 74)">';
mtxt += '<area shape="circle" coords="381, 74,3" href="javascript:selectTSpoints(63142,381, 74)">';
mtxt += '<area shape="circle" coords="386, 74,3" href="javascript:selectTSpoints(63143,386, 74)">';
mtxt += '<area shape="circle" coords="392, 74,3" href="javascript:selectTSpoints(63144,392, 74)">';
mtxt += '<area shape="circle" coords="397, 74,3" href="javascript:selectTSpoints(63001,397, 74)">';
mtxt += '<area shape="circle" coords="402, 74,3" href="javascript:selectTSpoints(63002,402, 74)">';
mtxt += '<area shape="circle" coords="407, 74,3" href="javascript:selectTSpoints(63003,407, 74)">';
mtxt += '<area shape="circle" coords="412, 74,3" href="javascript:selectTSpoints(63004,412, 74)">';
mtxt += '<area shape="circle" coords="417, 74,3" href="javascript:selectTSpoints(63005,417, 74)">';
mtxt += '<area shape="circle" coords="422, 74,3" href="javascript:selectTSpoints(63006,422, 74)">';
mtxt += '<area shape="circle" coords="427, 74,3" href="javascript:selectTSpoints(63007,427, 74)">';
mtxt += '<area shape="circle" coords="432, 74,3" href="javascript:selectTSpoints(63008,432, 74)">';
mtxt += '<area shape="circle" coords="437, 74,3" href="javascript:selectTSpoints(63009,437, 74)">';
mtxt += '<area shape="circle" coords="442, 74,3" href="javascript:selectTSpoints(63010,442, 74)">';
mtxt += '<area shape="circle" coords="447, 74,3" href="javascript:selectTSpoints(63011,447, 74)">';
mtxt += '<area shape="circle" coords="453, 74,3" href="javascript:selectTSpoints(63012,453, 74)">';
mtxt += '<area shape="circle" coords="458, 74,3" href="javascript:selectTSpoints(63013,458, 74)">';
mtxt += '<area shape="circle" coords="463, 74,3" href="javascript:selectTSpoints(63014,463, 74)">';
mtxt += '<area shape="circle" coords="468, 74,3" href="javascript:selectTSpoints(63015,468, 74)">';
mtxt += '<area shape="circle" coords="473, 74,3" href="javascript:selectTSpoints(63016,473, 74)">';
mtxt += '<area shape="circle" coords="478, 74,3" href="javascript:selectTSpoints(63017,478, 74)">';
mtxt += '<area shape="circle" coords="483, 74,3" href="javascript:selectTSpoints(63018,483, 74)">';
mtxt += '<area shape="circle" coords="488, 74,3" href="javascript:selectTSpoints(63019,488, 74)">';
mtxt += '<area shape="circle" coords="493, 74,3" href="javascript:selectTSpoints(63020,493, 74)">';
mtxt += '<area shape="circle" coords="498, 74,3" href="javascript:selectTSpoints(63021,498, 74)">';
mtxt += '<area shape="circle" coords="503, 74,3" href="javascript:selectTSpoints(63022,503, 74)">';
mtxt += '<area shape="circle" coords="509, 74,3" href="javascript:selectTSpoints(63023,509, 74)">';
mtxt += '<area shape="circle" coords="514, 74,3" href="javascript:selectTSpoints(63024,514, 74)">';
mtxt += '<area shape="circle" coords="519, 74,3" href="javascript:selectTSpoints(63025,519, 74)">';
mtxt += '<area shape="circle" coords="524, 74,3" href="javascript:selectTSpoints(63026,524, 74)">';
mtxt += '<area shape="circle" coords="529, 74,3" href="javascript:selectTSpoints(63027,529, 74)">';
mtxt += '<area shape="circle" coords="534, 74,3" href="javascript:selectTSpoints(63028,534, 74)">';
mtxt += '<area shape="circle" coords="539, 74,3" href="javascript:selectTSpoints(63029,539, 74)">';
mtxt += '<area shape="circle" coords="544, 74,3" href="javascript:selectTSpoints(63030,544, 74)">';
mtxt += '<area shape="circle" coords="549, 74,3" href="javascript:selectTSpoints(63031,549, 74)">';
mtxt += '<area shape="circle" coords="554, 74,3" href="javascript:selectTSpoints(63032,554, 74)">';
mtxt += '<area shape="circle" coords="559, 74,3" href="javascript:selectTSpoints(63033,559, 74)">';
mtxt += '<area shape="circle" coords="565, 74,3" href="javascript:selectTSpoints(63034,565, 74)">';
mtxt += '<area shape="circle" coords="570, 74,3" href="javascript:selectTSpoints(63035,570, 74)">';
mtxt += '<area shape="circle" coords="575, 74,3" href="javascript:selectTSpoints(63036,575, 74)">';
mtxt += '<area shape="circle" coords="580, 74,3" href="javascript:selectTSpoints(63037,580, 74)">';
mtxt += '<area shape="circle" coords="585, 74,3" href="javascript:selectTSpoints(63038,585, 74)">';
mtxt += '<area shape="circle" coords="590, 74,3" href="javascript:selectTSpoints(63039,590, 74)">';
mtxt += '<area shape="circle" coords="595, 74,3" href="javascript:selectTSpoints(63040,595, 74)">';
mtxt += '<area shape="circle" coords="600, 74,3" href="javascript:selectTSpoints(63041,600, 74)">';
mtxt += '<area shape="circle" coords="605, 74,3" href="javascript:selectTSpoints(63042,605, 74)">';
mtxt += '<area shape="circle" coords="610, 74,3" href="javascript:selectTSpoints(63043,610, 74)">';
mtxt += '<area shape="circle" coords="615, 74,3" href="javascript:selectTSpoints(63044,615, 74)">';
mtxt += '<area shape="circle" coords="621, 74,3" href="javascript:selectTSpoints(63045,621, 74)">';
mtxt += '<area shape="circle" coords="626, 74,3" href="javascript:selectTSpoints(63046,626, 74)">';
mtxt += '<area shape="circle" coords="631, 74,3" href="javascript:selectTSpoints(63047,631, 74)">';
mtxt += '<area shape="circle" coords="636, 74,3" href="javascript:selectTSpoints(63048,636, 74)">';
mtxt += '<area shape="circle" coords="641, 74,3" href="javascript:selectTSpoints(63049,641, 74)">';
mtxt += '<area shape="circle" coords="646, 74,3" href="javascript:selectTSpoints(63050,646, 74)">';
mtxt += '<area shape="circle" coords="651, 74,3" href="javascript:selectTSpoints(63051,651, 74)">';
mtxt += '<area shape="circle" coords="656, 74,3" href="javascript:selectTSpoints(63052,656, 74)">';
mtxt += '<area shape="circle" coords="661, 74,3" href="javascript:selectTSpoints(63053,661, 74)">';
mtxt += '<area shape="circle" coords="666, 74,3" href="javascript:selectTSpoints(63054,666, 74)">';
mtxt += '<area shape="circle" coords="671, 74,3" href="javascript:selectTSpoints(63055,671, 74)">';
mtxt += '<area shape="circle" coords="677, 74,3" href="javascript:selectTSpoints(63056,677, 74)">';
mtxt += '<area shape="circle" coords="682, 74,3" href="javascript:selectTSpoints(63057,682, 74)">';
mtxt += '<area shape="circle" coords="687, 74,3" href="javascript:selectTSpoints(63058,687, 74)">';
mtxt += '<area shape="circle" coords="692, 74,3" href="javascript:selectTSpoints(63059,692, 74)">';
mtxt += '<area shape="circle" coords="697, 74,3" href="javascript:selectTSpoints(63060,697, 74)">';
mtxt += '<area shape="circle" coords="702, 74,3" href="javascript:selectTSpoints(63061,702, 74)">';
mtxt += '<area shape="circle" coords="707, 74,3" href="javascript:selectTSpoints(63062,707, 74)">';
mtxt += '<area shape="circle" coords="712, 74,3" href="javascript:selectTSpoints(63063,712, 74)">';
mtxt += '<area shape="circle" coords="717, 74,3" href="javascript:selectTSpoints(63064,717, 74)">';
mtxt += '<area shape="circle" coords="722, 74,3" href="javascript:selectTSpoints(63065,722, 74)">';
mtxt += '<area shape="circle" coords="727, 74,3" href="javascript:selectTSpoints(63066,727, 74)">';
mtxt += '<area shape="circle" coords="733, 74,3" href="javascript:selectTSpoints(63067,733, 74)">';
mtxt += '<area shape="circle" coords="738, 74,3" href="javascript:selectTSpoints(63068,738, 74)">';
mtxt += '<area shape="circle" coords="743, 74,3" href="javascript:selectTSpoints(63069,743, 74)">';
mtxt += '<area shape="circle" coords="748, 74,3" href="javascript:selectTSpoints(63070,748, 74)">';
mtxt += '<area shape="circle" coords="753, 74,3" href="javascript:selectTSpoints(63071,753, 74)">';
mtxt += '<area shape="circle" coords="758, 74,3" href="javascript:selectTSpoints(63072,758, 74)">';
mtxt += '<area shape="circle" coords=" 30, 69,3" href="javascript:selectTSpoints(64073, 30, 69)">';
mtxt += '<area shape="circle" coords=" 35, 69,3" href="javascript:selectTSpoints(64074, 35, 69)">';
mtxt += '<area shape="circle" coords=" 40, 69,3" href="javascript:selectTSpoints(64075, 40, 69)">';
mtxt += '<area shape="circle" coords=" 45, 69,3" href="javascript:selectTSpoints(64076, 45, 69)">';
mtxt += '<area shape="circle" coords=" 50, 69,3" href="javascript:selectTSpoints(64077, 50, 69)">';
mtxt += '<area shape="circle" coords=" 56, 69,3" href="javascript:selectTSpoints(64078, 56, 69)">';
mtxt += '<area shape="circle" coords=" 61, 69,3" href="javascript:selectTSpoints(64079, 61, 69)">';
mtxt += '<area shape="circle" coords=" 66, 69,3" href="javascript:selectTSpoints(64080, 66, 69)">';
mtxt += '<area shape="circle" coords=" 71, 69,3" href="javascript:selectTSpoints(64081, 71, 69)">';
mtxt += '<area shape="circle" coords=" 76, 69,3" href="javascript:selectTSpoints(64082, 76, 69)">';
mtxt += '<area shape="circle" coords=" 81, 69,3" href="javascript:selectTSpoints(64083, 81, 69)">';
mtxt += '<area shape="circle" coords=" 86, 69,3" href="javascript:selectTSpoints(64084, 86, 69)">';
mtxt += '<area shape="circle" coords=" 91, 69,3" href="javascript:selectTSpoints(64085, 91, 69)">';
mtxt += '<area shape="circle" coords=" 96, 69,3" href="javascript:selectTSpoints(64086, 96, 69)">';
mtxt += '<area shape="circle" coords="101, 69,3" href="javascript:selectTSpoints(64087,101, 69)">';
mtxt += '<area shape="circle" coords="106, 69,3" href="javascript:selectTSpoints(64088,106, 69)">';
mtxt += '<area shape="circle" coords="112, 69,3" href="javascript:selectTSpoints(64089,112, 69)">';
mtxt += '<area shape="circle" coords="117, 69,3" href="javascript:selectTSpoints(64090,117, 69)">';
mtxt += '<area shape="circle" coords="122, 69,3" href="javascript:selectTSpoints(64091,122, 69)">';
mtxt += '<area shape="circle" coords="127, 69,3" href="javascript:selectTSpoints(64092,127, 69)">';
mtxt += '<area shape="circle" coords="132, 69,3" href="javascript:selectTSpoints(64093,132, 69)">';
mtxt += '<area shape="circle" coords="137, 69,3" href="javascript:selectTSpoints(64094,137, 69)">';
mtxt += '<area shape="circle" coords="142, 69,3" href="javascript:selectTSpoints(64095,142, 69)">';
mtxt += '<area shape="circle" coords="147, 69,3" href="javascript:selectTSpoints(64096,147, 69)">';
mtxt += '<area shape="circle" coords="152, 69,3" href="javascript:selectTSpoints(64097,152, 69)">';
mtxt += '<area shape="circle" coords="157, 69,3" href="javascript:selectTSpoints(64098,157, 69)">';
mtxt += '<area shape="circle" coords="162, 69,3" href="javascript:selectTSpoints(64099,162, 69)">';
mtxt += '<area shape="circle" coords="168, 69,3" href="javascript:selectTSpoints(64100,168, 69)">';
mtxt += '<area shape="circle" coords="173, 69,3" href="javascript:selectTSpoints(64101,173, 69)">';
mtxt += '<area shape="circle" coords="178, 69,3" href="javascript:selectTSpoints(64102,178, 69)">';
mtxt += '<area shape="circle" coords="183, 69,3" href="javascript:selectTSpoints(64103,183, 69)">';
mtxt += '<area shape="circle" coords="188, 69,3" href="javascript:selectTSpoints(64104,188, 69)">';
mtxt += '<area shape="circle" coords="193, 69,3" href="javascript:selectTSpoints(64105,193, 69)">';
mtxt += '<area shape="circle" coords="198, 69,3" href="javascript:selectTSpoints(64106,198, 69)">';
mtxt += '<area shape="circle" coords="203, 69,3" href="javascript:selectTSpoints(64107,203, 69)">';
mtxt += '<area shape="circle" coords="208, 69,3" href="javascript:selectTSpoints(64108,208, 69)">';
mtxt += '<area shape="circle" coords="213, 69,3" href="javascript:selectTSpoints(64109,213, 69)">';
mtxt += '<area shape="circle" coords="218, 69,3" href="javascript:selectTSpoints(64110,218, 69)">';
mtxt += '<area shape="circle" coords="224, 69,3" href="javascript:selectTSpoints(64111,224, 69)">';
mtxt += '<area shape="circle" coords="229, 69,3" href="javascript:selectTSpoints(64112,229, 69)">';
mtxt += '<area shape="circle" coords="234, 69,3" href="javascript:selectTSpoints(64113,234, 69)">';
mtxt += '<area shape="circle" coords="239, 69,3" href="javascript:selectTSpoints(64114,239, 69)">';
mtxt += '<area shape="circle" coords="244, 69,3" href="javascript:selectTSpoints(64115,244, 69)">';
mtxt += '<area shape="circle" coords="249, 69,3" href="javascript:selectTSpoints(64116,249, 69)">';
mtxt += '<area shape="circle" coords="254, 69,3" href="javascript:selectTSpoints(64117,254, 69)">';
mtxt += '<area shape="circle" coords="259, 69,3" href="javascript:selectTSpoints(64118,259, 69)">';
mtxt += '<area shape="circle" coords="264, 69,3" href="javascript:selectTSpoints(64119,264, 69)">';
mtxt += '<area shape="circle" coords="269, 69,3" href="javascript:selectTSpoints(64120,269, 69)">';
mtxt += '<area shape="circle" coords="274, 69,3" href="javascript:selectTSpoints(64121,274, 69)">';
mtxt += '<area shape="circle" coords="280, 69,3" href="javascript:selectTSpoints(64122,280, 69)">';
mtxt += '<area shape="circle" coords="285, 69,3" href="javascript:selectTSpoints(64123,285, 69)">';
mtxt += '<area shape="circle" coords="290, 69,3" href="javascript:selectTSpoints(64124,290, 69)">';
mtxt += '<area shape="circle" coords="295, 69,3" href="javascript:selectTSpoints(64125,295, 69)">';
mtxt += '<area shape="circle" coords="300, 69,3" href="javascript:selectTSpoints(64126,300, 69)">';
mtxt += '<area shape="circle" coords="305, 69,3" href="javascript:selectTSpoints(64127,305, 69)">';
mtxt += '<area shape="circle" coords="310, 69,3" href="javascript:selectTSpoints(64128,310, 69)">';
mtxt += '<area shape="circle" coords="315, 69,3" href="javascript:selectTSpoints(64129,315, 69)">';
mtxt += '<area shape="circle" coords="320, 69,3" href="javascript:selectTSpoints(64130,320, 69)">';
mtxt += '<area shape="circle" coords="325, 69,3" href="javascript:selectTSpoints(64131,325, 69)">';
mtxt += '<area shape="circle" coords="330, 69,3" href="javascript:selectTSpoints(64132,330, 69)">';
mtxt += '<area shape="circle" coords="336, 69,3" href="javascript:selectTSpoints(64133,336, 69)">';
mtxt += '<area shape="circle" coords="341, 69,3" href="javascript:selectTSpoints(64134,341, 69)">';
mtxt += '<area shape="circle" coords="346, 69,3" href="javascript:selectTSpoints(64135,346, 69)">';
mtxt += '<area shape="circle" coords="351, 69,3" href="javascript:selectTSpoints(64136,351, 69)">';
mtxt += '<area shape="circle" coords="356, 69,3" href="javascript:selectTSpoints(64137,356, 69)">';
mtxt += '<area shape="circle" coords="361, 69,3" href="javascript:selectTSpoints(64138,361, 69)">';
mtxt += '<area shape="circle" coords="366, 69,3" href="javascript:selectTSpoints(64139,366, 69)">';
mtxt += '<area shape="circle" coords="371, 69,3" href="javascript:selectTSpoints(64140,371, 69)">';
mtxt += '<area shape="circle" coords="376, 69,3" href="javascript:selectTSpoints(64141,376, 69)">';
mtxt += '<area shape="circle" coords="381, 69,3" href="javascript:selectTSpoints(64142,381, 69)">';
mtxt += '<area shape="circle" coords="386, 69,3" href="javascript:selectTSpoints(64143,386, 69)">';
mtxt += '<area shape="circle" coords="392, 69,3" href="javascript:selectTSpoints(64144,392, 69)">';
mtxt += '<area shape="circle" coords="397, 69,3" href="javascript:selectTSpoints(64001,397, 69)">';
mtxt += '<area shape="circle" coords="402, 69,3" href="javascript:selectTSpoints(64002,402, 69)">';
mtxt += '<area shape="circle" coords="407, 69,3" href="javascript:selectTSpoints(64003,407, 69)">';
mtxt += '<area shape="circle" coords="412, 69,3" href="javascript:selectTSpoints(64004,412, 69)">';
mtxt += '<area shape="circle" coords="417, 69,3" href="javascript:selectTSpoints(64005,417, 69)">';
mtxt += '<area shape="circle" coords="422, 69,3" href="javascript:selectTSpoints(64006,422, 69)">';
mtxt += '<area shape="circle" coords="427, 69,3" href="javascript:selectTSpoints(64007,427, 69)">';
mtxt += '<area shape="circle" coords="432, 69,3" href="javascript:selectTSpoints(64008,432, 69)">';
mtxt += '<area shape="circle" coords="437, 69,3" href="javascript:selectTSpoints(64009,437, 69)">';
mtxt += '<area shape="circle" coords="442, 69,3" href="javascript:selectTSpoints(64010,442, 69)">';
mtxt += '<area shape="circle" coords="447, 69,3" href="javascript:selectTSpoints(64011,447, 69)">';
mtxt += '<area shape="circle" coords="453, 69,3" href="javascript:selectTSpoints(64012,453, 69)">';
mtxt += '<area shape="circle" coords="458, 69,3" href="javascript:selectTSpoints(64013,458, 69)">';
mtxt += '<area shape="circle" coords="463, 69,3" href="javascript:selectTSpoints(64014,463, 69)">';
mtxt += '<area shape="circle" coords="468, 69,3" href="javascript:selectTSpoints(64015,468, 69)">';
mtxt += '<area shape="circle" coords="473, 69,3" href="javascript:selectTSpoints(64016,473, 69)">';
mtxt += '<area shape="circle" coords="478, 69,3" href="javascript:selectTSpoints(64017,478, 69)">';
mtxt += '<area shape="circle" coords="483, 69,3" href="javascript:selectTSpoints(64018,483, 69)">';
mtxt += '<area shape="circle" coords="488, 69,3" href="javascript:selectTSpoints(64019,488, 69)">';
mtxt += '<area shape="circle" coords="493, 69,3" href="javascript:selectTSpoints(64020,493, 69)">';
mtxt += '<area shape="circle" coords="498, 69,3" href="javascript:selectTSpoints(64021,498, 69)">';
mtxt += '<area shape="circle" coords="503, 69,3" href="javascript:selectTSpoints(64022,503, 69)">';
mtxt += '<area shape="circle" coords="509, 69,3" href="javascript:selectTSpoints(64023,509, 69)">';
mtxt += '<area shape="circle" coords="514, 69,3" href="javascript:selectTSpoints(64024,514, 69)">';
mtxt += '<area shape="circle" coords="519, 69,3" href="javascript:selectTSpoints(64025,519, 69)">';
mtxt += '<area shape="circle" coords="524, 69,3" href="javascript:selectTSpoints(64026,524, 69)">';
mtxt += '<area shape="circle" coords="529, 69,3" href="javascript:selectTSpoints(64027,529, 69)">';
mtxt += '<area shape="circle" coords="534, 69,3" href="javascript:selectTSpoints(64028,534, 69)">';
mtxt += '<area shape="circle" coords="539, 69,3" href="javascript:selectTSpoints(64029,539, 69)">';
mtxt += '<area shape="circle" coords="544, 69,3" href="javascript:selectTSpoints(64030,544, 69)">';
mtxt += '<area shape="circle" coords="549, 69,3" href="javascript:selectTSpoints(64031,549, 69)">';
mtxt += '<area shape="circle" coords="554, 69,3" href="javascript:selectTSpoints(64032,554, 69)">';
mtxt += '<area shape="circle" coords="559, 69,3" href="javascript:selectTSpoints(64033,559, 69)">';
mtxt += '<area shape="circle" coords="565, 69,3" href="javascript:selectTSpoints(64034,565, 69)">';
mtxt += '<area shape="circle" coords="570, 69,3" href="javascript:selectTSpoints(64035,570, 69)">';
mtxt += '<area shape="circle" coords="575, 69,3" href="javascript:selectTSpoints(64036,575, 69)">';
mtxt += '<area shape="circle" coords="580, 69,3" href="javascript:selectTSpoints(64037,580, 69)">';
mtxt += '<area shape="circle" coords="585, 69,3" href="javascript:selectTSpoints(64038,585, 69)">';
mtxt += '<area shape="circle" coords="590, 69,3" href="javascript:selectTSpoints(64039,590, 69)">';
mtxt += '<area shape="circle" coords="595, 69,3" href="javascript:selectTSpoints(64040,595, 69)">';
mtxt += '<area shape="circle" coords="600, 69,3" href="javascript:selectTSpoints(64041,600, 69)">';
mtxt += '<area shape="circle" coords="605, 69,3" href="javascript:selectTSpoints(64042,605, 69)">';
mtxt += '<area shape="circle" coords="610, 69,3" href="javascript:selectTSpoints(64043,610, 69)">';
mtxt += '<area shape="circle" coords="615, 69,3" href="javascript:selectTSpoints(64044,615, 69)">';
mtxt += '<area shape="circle" coords="621, 69,3" href="javascript:selectTSpoints(64045,621, 69)">';
mtxt += '<area shape="circle" coords="626, 69,3" href="javascript:selectTSpoints(64046,626, 69)">';
mtxt += '<area shape="circle" coords="631, 69,3" href="javascript:selectTSpoints(64047,631, 69)">';
mtxt += '<area shape="circle" coords="636, 69,3" href="javascript:selectTSpoints(64048,636, 69)">';
mtxt += '<area shape="circle" coords="641, 69,3" href="javascript:selectTSpoints(64049,641, 69)">';
mtxt += '<area shape="circle" coords="646, 69,3" href="javascript:selectTSpoints(64050,646, 69)">';
mtxt += '<area shape="circle" coords="651, 69,3" href="javascript:selectTSpoints(64051,651, 69)">';
mtxt += '<area shape="circle" coords="656, 69,3" href="javascript:selectTSpoints(64052,656, 69)">';
mtxt += '<area shape="circle" coords="661, 69,3" href="javascript:selectTSpoints(64053,661, 69)">';
mtxt += '<area shape="circle" coords="666, 69,3" href="javascript:selectTSpoints(64054,666, 69)">';
mtxt += '<area shape="circle" coords="671, 69,3" href="javascript:selectTSpoints(64055,671, 69)">';
mtxt += '<area shape="circle" coords="677, 69,3" href="javascript:selectTSpoints(64056,677, 69)">';
mtxt += '<area shape="circle" coords="682, 69,3" href="javascript:selectTSpoints(64057,682, 69)">';
mtxt += '<area shape="circle" coords="687, 69,3" href="javascript:selectTSpoints(64058,687, 69)">';
mtxt += '<area shape="circle" coords="692, 69,3" href="javascript:selectTSpoints(64059,692, 69)">';
mtxt += '<area shape="circle" coords="697, 69,3" href="javascript:selectTSpoints(64060,697, 69)">';
mtxt += '<area shape="circle" coords="702, 69,3" href="javascript:selectTSpoints(64061,702, 69)">';
mtxt += '<area shape="circle" coords="707, 69,3" href="javascript:selectTSpoints(64062,707, 69)">';
mtxt += '<area shape="circle" coords="712, 69,3" href="javascript:selectTSpoints(64063,712, 69)">';
mtxt += '<area shape="circle" coords="717, 69,3" href="javascript:selectTSpoints(64064,717, 69)">';
mtxt += '<area shape="circle" coords="722, 69,3" href="javascript:selectTSpoints(64065,722, 69)">';
mtxt += '<area shape="circle" coords="727, 69,3" href="javascript:selectTSpoints(64066,727, 69)">';
mtxt += '<area shape="circle" coords="733, 69,3" href="javascript:selectTSpoints(64067,733, 69)">';
mtxt += '<area shape="circle" coords="738, 69,3" href="javascript:selectTSpoints(64068,738, 69)">';
mtxt += '<area shape="circle" coords="743, 69,3" href="javascript:selectTSpoints(64069,743, 69)">';
mtxt += '<area shape="circle" coords="748, 69,3" href="javascript:selectTSpoints(64070,748, 69)">';
mtxt += '<area shape="circle" coords="753, 69,3" href="javascript:selectTSpoints(64071,753, 69)">';
mtxt += '<area shape="circle" coords="758, 69,3" href="javascript:selectTSpoints(64072,758, 69)">';
mtxt += '<area shape="circle" coords=" 30, 64,3" href="javascript:selectTSpoints(65073, 30, 64)">';
mtxt += '<area shape="circle" coords=" 35, 64,3" href="javascript:selectTSpoints(65074, 35, 64)">';
mtxt += '<area shape="circle" coords=" 40, 64,3" href="javascript:selectTSpoints(65075, 40, 64)">';
mtxt += '<area shape="circle" coords=" 45, 64,3" href="javascript:selectTSpoints(65076, 45, 64)">';
mtxt += '<area shape="circle" coords=" 50, 64,3" href="javascript:selectTSpoints(65077, 50, 64)">';
mtxt += '<area shape="circle" coords=" 56, 64,3" href="javascript:selectTSpoints(65078, 56, 64)">';
mtxt += '<area shape="circle" coords=" 61, 64,3" href="javascript:selectTSpoints(65079, 61, 64)">';
mtxt += '<area shape="circle" coords=" 66, 64,3" href="javascript:selectTSpoints(65080, 66, 64)">';
mtxt += '<area shape="circle" coords=" 71, 64,3" href="javascript:selectTSpoints(65081, 71, 64)">';
mtxt += '<area shape="circle" coords=" 76, 64,3" href="javascript:selectTSpoints(65082, 76, 64)">';
mtxt += '<area shape="circle" coords=" 81, 64,3" href="javascript:selectTSpoints(65083, 81, 64)">';
mtxt += '<area shape="circle" coords=" 86, 64,3" href="javascript:selectTSpoints(65084, 86, 64)">';
mtxt += '<area shape="circle" coords=" 91, 64,3" href="javascript:selectTSpoints(65085, 91, 64)">';
mtxt += '<area shape="circle" coords=" 96, 64,3" href="javascript:selectTSpoints(65086, 96, 64)">';
mtxt += '<area shape="circle" coords="101, 64,3" href="javascript:selectTSpoints(65087,101, 64)">';
mtxt += '<area shape="circle" coords="106, 64,3" href="javascript:selectTSpoints(65088,106, 64)">';
mtxt += '<area shape="circle" coords="112, 64,3" href="javascript:selectTSpoints(65089,112, 64)">';
mtxt += '<area shape="circle" coords="117, 64,3" href="javascript:selectTSpoints(65090,117, 64)">';
mtxt += '<area shape="circle" coords="122, 64,3" href="javascript:selectTSpoints(65091,122, 64)">';
mtxt += '<area shape="circle" coords="127, 64,3" href="javascript:selectTSpoints(65092,127, 64)">';
mtxt += '<area shape="circle" coords="132, 64,3" href="javascript:selectTSpoints(65093,132, 64)">';
mtxt += '<area shape="circle" coords="137, 64,3" href="javascript:selectTSpoints(65094,137, 64)">';
mtxt += '<area shape="circle" coords="142, 64,3" href="javascript:selectTSpoints(65095,142, 64)">';
mtxt += '<area shape="circle" coords="147, 64,3" href="javascript:selectTSpoints(65096,147, 64)">';
mtxt += '<area shape="circle" coords="152, 64,3" href="javascript:selectTSpoints(65097,152, 64)">';
mtxt += '<area shape="circle" coords="157, 64,3" href="javascript:selectTSpoints(65098,157, 64)">';
mtxt += '<area shape="circle" coords="162, 64,3" href="javascript:selectTSpoints(65099,162, 64)">';
mtxt += '<area shape="circle" coords="168, 64,3" href="javascript:selectTSpoints(65100,168, 64)">';
mtxt += '<area shape="circle" coords="173, 64,3" href="javascript:selectTSpoints(65101,173, 64)">';
mtxt += '<area shape="circle" coords="178, 64,3" href="javascript:selectTSpoints(65102,178, 64)">';
mtxt += '<area shape="circle" coords="183, 64,3" href="javascript:selectTSpoints(65103,183, 64)">';
mtxt += '<area shape="circle" coords="188, 64,3" href="javascript:selectTSpoints(65104,188, 64)">';
mtxt += '<area shape="circle" coords="193, 64,3" href="javascript:selectTSpoints(65105,193, 64)">';
mtxt += '<area shape="circle" coords="198, 64,3" href="javascript:selectTSpoints(65106,198, 64)">';
mtxt += '<area shape="circle" coords="203, 64,3" href="javascript:selectTSpoints(65107,203, 64)">';
mtxt += '<area shape="circle" coords="208, 64,3" href="javascript:selectTSpoints(65108,208, 64)">';
mtxt += '<area shape="circle" coords="213, 64,3" href="javascript:selectTSpoints(65109,213, 64)">';
mtxt += '<area shape="circle" coords="218, 64,3" href="javascript:selectTSpoints(65110,218, 64)">';
mtxt += '<area shape="circle" coords="224, 64,3" href="javascript:selectTSpoints(65111,224, 64)">';
mtxt += '<area shape="circle" coords="229, 64,3" href="javascript:selectTSpoints(65112,229, 64)">';
mtxt += '<area shape="circle" coords="234, 64,3" href="javascript:selectTSpoints(65113,234, 64)">';
mtxt += '<area shape="circle" coords="239, 64,3" href="javascript:selectTSpoints(65114,239, 64)">';
mtxt += '<area shape="circle" coords="244, 64,3" href="javascript:selectTSpoints(65115,244, 64)">';
mtxt += '<area shape="circle" coords="249, 64,3" href="javascript:selectTSpoints(65116,249, 64)">';
mtxt += '<area shape="circle" coords="254, 64,3" href="javascript:selectTSpoints(65117,254, 64)">';
mtxt += '<area shape="circle" coords="259, 64,3" href="javascript:selectTSpoints(65118,259, 64)">';
mtxt += '<area shape="circle" coords="264, 64,3" href="javascript:selectTSpoints(65119,264, 64)">';
mtxt += '<area shape="circle" coords="269, 64,3" href="javascript:selectTSpoints(65120,269, 64)">';
mtxt += '<area shape="circle" coords="274, 64,3" href="javascript:selectTSpoints(65121,274, 64)">';
mtxt += '<area shape="circle" coords="280, 64,3" href="javascript:selectTSpoints(65122,280, 64)">';
mtxt += '<area shape="circle" coords="285, 64,3" href="javascript:selectTSpoints(65123,285, 64)">';
mtxt += '<area shape="circle" coords="290, 64,3" href="javascript:selectTSpoints(65124,290, 64)">';
mtxt += '<area shape="circle" coords="295, 64,3" href="javascript:selectTSpoints(65125,295, 64)">';
mtxt += '<area shape="circle" coords="300, 64,3" href="javascript:selectTSpoints(65126,300, 64)">';
mtxt += '<area shape="circle" coords="305, 64,3" href="javascript:selectTSpoints(65127,305, 64)">';
mtxt += '<area shape="circle" coords="310, 64,3" href="javascript:selectTSpoints(65128,310, 64)">';
mtxt += '<area shape="circle" coords="315, 64,3" href="javascript:selectTSpoints(65129,315, 64)">';
mtxt += '<area shape="circle" coords="320, 64,3" href="javascript:selectTSpoints(65130,320, 64)">';
mtxt += '<area shape="circle" coords="325, 64,3" href="javascript:selectTSpoints(65131,325, 64)">';
mtxt += '<area shape="circle" coords="330, 64,3" href="javascript:selectTSpoints(65132,330, 64)">';
mtxt += '<area shape="circle" coords="336, 64,3" href="javascript:selectTSpoints(65133,336, 64)">';
mtxt += '<area shape="circle" coords="341, 64,3" href="javascript:selectTSpoints(65134,341, 64)">';
mtxt += '<area shape="circle" coords="346, 64,3" href="javascript:selectTSpoints(65135,346, 64)">';
mtxt += '<area shape="circle" coords="351, 64,3" href="javascript:selectTSpoints(65136,351, 64)">';
mtxt += '<area shape="circle" coords="356, 64,3" href="javascript:selectTSpoints(65137,356, 64)">';
mtxt += '<area shape="circle" coords="361, 64,3" href="javascript:selectTSpoints(65138,361, 64)">';
mtxt += '<area shape="circle" coords="366, 64,3" href="javascript:selectTSpoints(65139,366, 64)">';
mtxt += '<area shape="circle" coords="371, 64,3" href="javascript:selectTSpoints(65140,371, 64)">';
mtxt += '<area shape="circle" coords="376, 64,3" href="javascript:selectTSpoints(65141,376, 64)">';
mtxt += '<area shape="circle" coords="381, 64,3" href="javascript:selectTSpoints(65142,381, 64)">';
mtxt += '<area shape="circle" coords="386, 64,3" href="javascript:selectTSpoints(65143,386, 64)">';
mtxt += '<area shape="circle" coords="392, 64,3" href="javascript:selectTSpoints(65144,392, 64)">';
mtxt += '<area shape="circle" coords="397, 64,3" href="javascript:selectTSpoints(65001,397, 64)">';
mtxt += '<area shape="circle" coords="402, 64,3" href="javascript:selectTSpoints(65002,402, 64)">';
mtxt += '<area shape="circle" coords="407, 64,3" href="javascript:selectTSpoints(65003,407, 64)">';
mtxt += '<area shape="circle" coords="412, 64,3" href="javascript:selectTSpoints(65004,412, 64)">';
mtxt += '<area shape="circle" coords="417, 64,3" href="javascript:selectTSpoints(65005,417, 64)">';
mtxt += '<area shape="circle" coords="422, 64,3" href="javascript:selectTSpoints(65006,422, 64)">';
mtxt += '<area shape="circle" coords="427, 64,3" href="javascript:selectTSpoints(65007,427, 64)">';
mtxt += '<area shape="circle" coords="432, 64,3" href="javascript:selectTSpoints(65008,432, 64)">';
mtxt += '<area shape="circle" coords="437, 64,3" href="javascript:selectTSpoints(65009,437, 64)">';
mtxt += '<area shape="circle" coords="442, 64,3" href="javascript:selectTSpoints(65010,442, 64)">';
mtxt += '<area shape="circle" coords="447, 64,3" href="javascript:selectTSpoints(65011,447, 64)">';
mtxt += '<area shape="circle" coords="453, 64,3" href="javascript:selectTSpoints(65012,453, 64)">';
mtxt += '<area shape="circle" coords="458, 64,3" href="javascript:selectTSpoints(65013,458, 64)">';
mtxt += '<area shape="circle" coords="463, 64,3" href="javascript:selectTSpoints(65014,463, 64)">';
mtxt += '<area shape="circle" coords="468, 64,3" href="javascript:selectTSpoints(65015,468, 64)">';
mtxt += '<area shape="circle" coords="473, 64,3" href="javascript:selectTSpoints(65016,473, 64)">';
mtxt += '<area shape="circle" coords="478, 64,3" href="javascript:selectTSpoints(65017,478, 64)">';
mtxt += '<area shape="circle" coords="483, 64,3" href="javascript:selectTSpoints(65018,483, 64)">';
mtxt += '<area shape="circle" coords="488, 64,3" href="javascript:selectTSpoints(65019,488, 64)">';
mtxt += '<area shape="circle" coords="493, 64,3" href="javascript:selectTSpoints(65020,493, 64)">';
mtxt += '<area shape="circle" coords="498, 64,3" href="javascript:selectTSpoints(65021,498, 64)">';
mtxt += '<area shape="circle" coords="503, 64,3" href="javascript:selectTSpoints(65022,503, 64)">';
mtxt += '<area shape="circle" coords="509, 64,3" href="javascript:selectTSpoints(65023,509, 64)">';
mtxt += '<area shape="circle" coords="514, 64,3" href="javascript:selectTSpoints(65024,514, 64)">';
mtxt += '<area shape="circle" coords="519, 64,3" href="javascript:selectTSpoints(65025,519, 64)">';
mtxt += '<area shape="circle" coords="524, 64,3" href="javascript:selectTSpoints(65026,524, 64)">';
mtxt += '<area shape="circle" coords="529, 64,3" href="javascript:selectTSpoints(65027,529, 64)">';
mtxt += '<area shape="circle" coords="534, 64,3" href="javascript:selectTSpoints(65028,534, 64)">';
mtxt += '<area shape="circle" coords="539, 64,3" href="javascript:selectTSpoints(65029,539, 64)">';
mtxt += '<area shape="circle" coords="544, 64,3" href="javascript:selectTSpoints(65030,544, 64)">';
mtxt += '<area shape="circle" coords="549, 64,3" href="javascript:selectTSpoints(65031,549, 64)">';
mtxt += '<area shape="circle" coords="554, 64,3" href="javascript:selectTSpoints(65032,554, 64)">';
mtxt += '<area shape="circle" coords="559, 64,3" href="javascript:selectTSpoints(65033,559, 64)">';
mtxt += '<area shape="circle" coords="565, 64,3" href="javascript:selectTSpoints(65034,565, 64)">';
mtxt += '<area shape="circle" coords="570, 64,3" href="javascript:selectTSpoints(65035,570, 64)">';
mtxt += '<area shape="circle" coords="575, 64,3" href="javascript:selectTSpoints(65036,575, 64)">';
mtxt += '<area shape="circle" coords="580, 64,3" href="javascript:selectTSpoints(65037,580, 64)">';
mtxt += '<area shape="circle" coords="585, 64,3" href="javascript:selectTSpoints(65038,585, 64)">';
mtxt += '<area shape="circle" coords="590, 64,3" href="javascript:selectTSpoints(65039,590, 64)">';
mtxt += '<area shape="circle" coords="595, 64,3" href="javascript:selectTSpoints(65040,595, 64)">';
mtxt += '<area shape="circle" coords="600, 64,3" href="javascript:selectTSpoints(65041,600, 64)">';
mtxt += '<area shape="circle" coords="605, 64,3" href="javascript:selectTSpoints(65042,605, 64)">';
mtxt += '<area shape="circle" coords="610, 64,3" href="javascript:selectTSpoints(65043,610, 64)">';
mtxt += '<area shape="circle" coords="615, 64,3" href="javascript:selectTSpoints(65044,615, 64)">';
mtxt += '<area shape="circle" coords="621, 64,3" href="javascript:selectTSpoints(65045,621, 64)">';
mtxt += '<area shape="circle" coords="626, 64,3" href="javascript:selectTSpoints(65046,626, 64)">';
mtxt += '<area shape="circle" coords="631, 64,3" href="javascript:selectTSpoints(65047,631, 64)">';
mtxt += '<area shape="circle" coords="636, 64,3" href="javascript:selectTSpoints(65048,636, 64)">';
mtxt += '<area shape="circle" coords="641, 64,3" href="javascript:selectTSpoints(65049,641, 64)">';
mtxt += '<area shape="circle" coords="646, 64,3" href="javascript:selectTSpoints(65050,646, 64)">';
mtxt += '<area shape="circle" coords="651, 64,3" href="javascript:selectTSpoints(65051,651, 64)">';
mtxt += '<area shape="circle" coords="656, 64,3" href="javascript:selectTSpoints(65052,656, 64)">';
mtxt += '<area shape="circle" coords="661, 64,3" href="javascript:selectTSpoints(65053,661, 64)">';
mtxt += '<area shape="circle" coords="666, 64,3" href="javascript:selectTSpoints(65054,666, 64)">';
mtxt += '<area shape="circle" coords="671, 64,3" href="javascript:selectTSpoints(65055,671, 64)">';
mtxt += '<area shape="circle" coords="677, 64,3" href="javascript:selectTSpoints(65056,677, 64)">';
mtxt += '<area shape="circle" coords="682, 64,3" href="javascript:selectTSpoints(65057,682, 64)">';
mtxt += '<area shape="circle" coords="687, 64,3" href="javascript:selectTSpoints(65058,687, 64)">';
mtxt += '<area shape="circle" coords="692, 64,3" href="javascript:selectTSpoints(65059,692, 64)">';
mtxt += '<area shape="circle" coords="697, 64,3" href="javascript:selectTSpoints(65060,697, 64)">';
mtxt += '<area shape="circle" coords="702, 64,3" href="javascript:selectTSpoints(65061,702, 64)">';
mtxt += '<area shape="circle" coords="707, 64,3" href="javascript:selectTSpoints(65062,707, 64)">';
mtxt += '<area shape="circle" coords="712, 64,3" href="javascript:selectTSpoints(65063,712, 64)">';
mtxt += '<area shape="circle" coords="717, 64,3" href="javascript:selectTSpoints(65064,717, 64)">';
mtxt += '<area shape="circle" coords="722, 64,3" href="javascript:selectTSpoints(65065,722, 64)">';
mtxt += '<area shape="circle" coords="727, 64,3" href="javascript:selectTSpoints(65066,727, 64)">';
mtxt += '<area shape="circle" coords="733, 64,3" href="javascript:selectTSpoints(65067,733, 64)">';
mtxt += '<area shape="circle" coords="738, 64,3" href="javascript:selectTSpoints(65068,738, 64)">';
mtxt += '<area shape="circle" coords="743, 64,3" href="javascript:selectTSpoints(65069,743, 64)">';
mtxt += '<area shape="circle" coords="748, 64,3" href="javascript:selectTSpoints(65070,748, 64)">';
mtxt += '<area shape="circle" coords="753, 64,3" href="javascript:selectTSpoints(65071,753, 64)">';
mtxt += '<area shape="circle" coords="758, 64,3" href="javascript:selectTSpoints(65072,758, 64)">';
mtxt += '<area shape="circle" coords=" 30, 59,3" href="javascript:selectTSpoints(66073, 30, 59)">';
mtxt += '<area shape="circle" coords=" 35, 59,3" href="javascript:selectTSpoints(66074, 35, 59)">';
mtxt += '<area shape="circle" coords=" 40, 59,3" href="javascript:selectTSpoints(66075, 40, 59)">';
mtxt += '<area shape="circle" coords=" 45, 59,3" href="javascript:selectTSpoints(66076, 45, 59)">';
mtxt += '<area shape="circle" coords=" 50, 59,3" href="javascript:selectTSpoints(66077, 50, 59)">';
mtxt += '<area shape="circle" coords=" 56, 59,3" href="javascript:selectTSpoints(66078, 56, 59)">';
mtxt += '<area shape="circle" coords=" 61, 59,3" href="javascript:selectTSpoints(66079, 61, 59)">';
mtxt += '<area shape="circle" coords=" 66, 59,3" href="javascript:selectTSpoints(66080, 66, 59)">';
mtxt += '<area shape="circle" coords=" 71, 59,3" href="javascript:selectTSpoints(66081, 71, 59)">';
mtxt += '<area shape="circle" coords=" 76, 59,3" href="javascript:selectTSpoints(66082, 76, 59)">';
mtxt += '<area shape="circle" coords=" 81, 59,3" href="javascript:selectTSpoints(66083, 81, 59)">';
mtxt += '<area shape="circle" coords=" 86, 59,3" href="javascript:selectTSpoints(66084, 86, 59)">';
mtxt += '<area shape="circle" coords=" 91, 59,3" href="javascript:selectTSpoints(66085, 91, 59)">';
mtxt += '<area shape="circle" coords=" 96, 59,3" href="javascript:selectTSpoints(66086, 96, 59)">';
mtxt += '<area shape="circle" coords="101, 59,3" href="javascript:selectTSpoints(66087,101, 59)">';
mtxt += '<area shape="circle" coords="106, 59,3" href="javascript:selectTSpoints(66088,106, 59)">';
mtxt += '<area shape="circle" coords="112, 59,3" href="javascript:selectTSpoints(66089,112, 59)">';
mtxt += '<area shape="circle" coords="117, 59,3" href="javascript:selectTSpoints(66090,117, 59)">';
mtxt += '<area shape="circle" coords="122, 59,3" href="javascript:selectTSpoints(66091,122, 59)">';
mtxt += '<area shape="circle" coords="127, 59,3" href="javascript:selectTSpoints(66092,127, 59)">';
mtxt += '<area shape="circle" coords="132, 59,3" href="javascript:selectTSpoints(66093,132, 59)">';
mtxt += '<area shape="circle" coords="137, 59,3" href="javascript:selectTSpoints(66094,137, 59)">';
mtxt += '<area shape="circle" coords="142, 59,3" href="javascript:selectTSpoints(66095,142, 59)">';
mtxt += '<area shape="circle" coords="147, 59,3" href="javascript:selectTSpoints(66096,147, 59)">';
mtxt += '<area shape="circle" coords="152, 59,3" href="javascript:selectTSpoints(66097,152, 59)">';
mtxt += '<area shape="circle" coords="157, 59,3" href="javascript:selectTSpoints(66098,157, 59)">';
mtxt += '<area shape="circle" coords="162, 59,3" href="javascript:selectTSpoints(66099,162, 59)">';
mtxt += '<area shape="circle" coords="168, 59,3" href="javascript:selectTSpoints(66100,168, 59)">';
mtxt += '<area shape="circle" coords="173, 59,3" href="javascript:selectTSpoints(66101,173, 59)">';
mtxt += '<area shape="circle" coords="178, 59,3" href="javascript:selectTSpoints(66102,178, 59)">';
mtxt += '<area shape="circle" coords="183, 59,3" href="javascript:selectTSpoints(66103,183, 59)">';
mtxt += '<area shape="circle" coords="188, 59,3" href="javascript:selectTSpoints(66104,188, 59)">';
mtxt += '<area shape="circle" coords="193, 59,3" href="javascript:selectTSpoints(66105,193, 59)">';
mtxt += '<area shape="circle" coords="198, 59,3" href="javascript:selectTSpoints(66106,198, 59)">';
mtxt += '<area shape="circle" coords="203, 59,3" href="javascript:selectTSpoints(66107,203, 59)">';
mtxt += '<area shape="circle" coords="208, 59,3" href="javascript:selectTSpoints(66108,208, 59)">';
mtxt += '<area shape="circle" coords="213, 59,3" href="javascript:selectTSpoints(66109,213, 59)">';
mtxt += '<area shape="circle" coords="218, 59,3" href="javascript:selectTSpoints(66110,218, 59)">';
mtxt += '<area shape="circle" coords="224, 59,3" href="javascript:selectTSpoints(66111,224, 59)">';
mtxt += '<area shape="circle" coords="229, 59,3" href="javascript:selectTSpoints(66112,229, 59)">';
mtxt += '<area shape="circle" coords="234, 59,3" href="javascript:selectTSpoints(66113,234, 59)">';
mtxt += '<area shape="circle" coords="239, 59,3" href="javascript:selectTSpoints(66114,239, 59)">';
mtxt += '<area shape="circle" coords="244, 59,3" href="javascript:selectTSpoints(66115,244, 59)">';
mtxt += '<area shape="circle" coords="249, 59,3" href="javascript:selectTSpoints(66116,249, 59)">';
mtxt += '<area shape="circle" coords="254, 59,3" href="javascript:selectTSpoints(66117,254, 59)">';
mtxt += '<area shape="circle" coords="259, 59,3" href="javascript:selectTSpoints(66118,259, 59)">';
mtxt += '<area shape="circle" coords="264, 59,3" href="javascript:selectTSpoints(66119,264, 59)">';
mtxt += '<area shape="circle" coords="269, 59,3" href="javascript:selectTSpoints(66120,269, 59)">';
mtxt += '<area shape="circle" coords="274, 59,3" href="javascript:selectTSpoints(66121,274, 59)">';
mtxt += '<area shape="circle" coords="280, 59,3" href="javascript:selectTSpoints(66122,280, 59)">';
mtxt += '<area shape="circle" coords="285, 59,3" href="javascript:selectTSpoints(66123,285, 59)">';
mtxt += '<area shape="circle" coords="290, 59,3" href="javascript:selectTSpoints(66124,290, 59)">';
mtxt += '<area shape="circle" coords="295, 59,3" href="javascript:selectTSpoints(66125,295, 59)">';
mtxt += '<area shape="circle" coords="300, 59,3" href="javascript:selectTSpoints(66126,300, 59)">';
mtxt += '<area shape="circle" coords="305, 59,3" href="javascript:selectTSpoints(66127,305, 59)">';
mtxt += '<area shape="circle" coords="310, 59,3" href="javascript:selectTSpoints(66128,310, 59)">';
mtxt += '<area shape="circle" coords="315, 59,3" href="javascript:selectTSpoints(66129,315, 59)">';
mtxt += '<area shape="circle" coords="320, 59,3" href="javascript:selectTSpoints(66130,320, 59)">';
mtxt += '<area shape="circle" coords="325, 59,3" href="javascript:selectTSpoints(66131,325, 59)">';
mtxt += '<area shape="circle" coords="330, 59,3" href="javascript:selectTSpoints(66132,330, 59)">';
mtxt += '<area shape="circle" coords="336, 59,3" href="javascript:selectTSpoints(66133,336, 59)">';
mtxt += '<area shape="circle" coords="341, 59,3" href="javascript:selectTSpoints(66134,341, 59)">';
mtxt += '<area shape="circle" coords="346, 59,3" href="javascript:selectTSpoints(66135,346, 59)">';
mtxt += '<area shape="circle" coords="351, 59,3" href="javascript:selectTSpoints(66136,351, 59)">';
mtxt += '<area shape="circle" coords="356, 59,3" href="javascript:selectTSpoints(66137,356, 59)">';
mtxt += '<area shape="circle" coords="361, 59,3" href="javascript:selectTSpoints(66138,361, 59)">';
mtxt += '<area shape="circle" coords="366, 59,3" href="javascript:selectTSpoints(66139,366, 59)">';
mtxt += '<area shape="circle" coords="371, 59,3" href="javascript:selectTSpoints(66140,371, 59)">';
mtxt += '<area shape="circle" coords="376, 59,3" href="javascript:selectTSpoints(66141,376, 59)">';
mtxt += '<area shape="circle" coords="381, 59,3" href="javascript:selectTSpoints(66142,381, 59)">';
mtxt += '<area shape="circle" coords="386, 59,3" href="javascript:selectTSpoints(66143,386, 59)">';
mtxt += '<area shape="circle" coords="392, 59,3" href="javascript:selectTSpoints(66144,392, 59)">';
mtxt += '<area shape="circle" coords="397, 59,3" href="javascript:selectTSpoints(66001,397, 59)">';
mtxt += '<area shape="circle" coords="402, 59,3" href="javascript:selectTSpoints(66002,402, 59)">';
mtxt += '<area shape="circle" coords="407, 59,3" href="javascript:selectTSpoints(66003,407, 59)">';
mtxt += '<area shape="circle" coords="412, 59,3" href="javascript:selectTSpoints(66004,412, 59)">';
mtxt += '<area shape="circle" coords="417, 59,3" href="javascript:selectTSpoints(66005,417, 59)">';
mtxt += '<area shape="circle" coords="422, 59,3" href="javascript:selectTSpoints(66006,422, 59)">';
mtxt += '<area shape="circle" coords="427, 59,3" href="javascript:selectTSpoints(66007,427, 59)">';
mtxt += '<area shape="circle" coords="432, 59,3" href="javascript:selectTSpoints(66008,432, 59)">';
mtxt += '<area shape="circle" coords="437, 59,3" href="javascript:selectTSpoints(66009,437, 59)">';
mtxt += '<area shape="circle" coords="442, 59,3" href="javascript:selectTSpoints(66010,442, 59)">';
mtxt += '<area shape="circle" coords="447, 59,3" href="javascript:selectTSpoints(66011,447, 59)">';
mtxt += '<area shape="circle" coords="453, 59,3" href="javascript:selectTSpoints(66012,453, 59)">';
mtxt += '<area shape="circle" coords="458, 59,3" href="javascript:selectTSpoints(66013,458, 59)">';
mtxt += '<area shape="circle" coords="463, 59,3" href="javascript:selectTSpoints(66014,463, 59)">';
mtxt += '<area shape="circle" coords="468, 59,3" href="javascript:selectTSpoints(66015,468, 59)">';
mtxt += '<area shape="circle" coords="473, 59,3" href="javascript:selectTSpoints(66016,473, 59)">';
mtxt += '<area shape="circle" coords="478, 59,3" href="javascript:selectTSpoints(66017,478, 59)">';
mtxt += '<area shape="circle" coords="483, 59,3" href="javascript:selectTSpoints(66018,483, 59)">';
mtxt += '<area shape="circle" coords="488, 59,3" href="javascript:selectTSpoints(66019,488, 59)">';
mtxt += '<area shape="circle" coords="493, 59,3" href="javascript:selectTSpoints(66020,493, 59)">';
mtxt += '<area shape="circle" coords="498, 59,3" href="javascript:selectTSpoints(66021,498, 59)">';
mtxt += '<area shape="circle" coords="503, 59,3" href="javascript:selectTSpoints(66022,503, 59)">';
mtxt += '<area shape="circle" coords="509, 59,3" href="javascript:selectTSpoints(66023,509, 59)">';
mtxt += '<area shape="circle" coords="514, 59,3" href="javascript:selectTSpoints(66024,514, 59)">';
mtxt += '<area shape="circle" coords="519, 59,3" href="javascript:selectTSpoints(66025,519, 59)">';
mtxt += '<area shape="circle" coords="524, 59,3" href="javascript:selectTSpoints(66026,524, 59)">';
mtxt += '<area shape="circle" coords="529, 59,3" href="javascript:selectTSpoints(66027,529, 59)">';
mtxt += '<area shape="circle" coords="534, 59,3" href="javascript:selectTSpoints(66028,534, 59)">';
mtxt += '<area shape="circle" coords="539, 59,3" href="javascript:selectTSpoints(66029,539, 59)">';
mtxt += '<area shape="circle" coords="544, 59,3" href="javascript:selectTSpoints(66030,544, 59)">';
mtxt += '<area shape="circle" coords="549, 59,3" href="javascript:selectTSpoints(66031,549, 59)">';
mtxt += '<area shape="circle" coords="554, 59,3" href="javascript:selectTSpoints(66032,554, 59)">';
mtxt += '<area shape="circle" coords="559, 59,3" href="javascript:selectTSpoints(66033,559, 59)">';
mtxt += '<area shape="circle" coords="565, 59,3" href="javascript:selectTSpoints(66034,565, 59)">';
mtxt += '<area shape="circle" coords="570, 59,3" href="javascript:selectTSpoints(66035,570, 59)">';
mtxt += '<area shape="circle" coords="575, 59,3" href="javascript:selectTSpoints(66036,575, 59)">';
mtxt += '<area shape="circle" coords="580, 59,3" href="javascript:selectTSpoints(66037,580, 59)">';
mtxt += '<area shape="circle" coords="585, 59,3" href="javascript:selectTSpoints(66038,585, 59)">';
mtxt += '<area shape="circle" coords="590, 59,3" href="javascript:selectTSpoints(66039,590, 59)">';
mtxt += '<area shape="circle" coords="595, 59,3" href="javascript:selectTSpoints(66040,595, 59)">';
mtxt += '<area shape="circle" coords="600, 59,3" href="javascript:selectTSpoints(66041,600, 59)">';
mtxt += '<area shape="circle" coords="605, 59,3" href="javascript:selectTSpoints(66042,605, 59)">';
mtxt += '<area shape="circle" coords="610, 59,3" href="javascript:selectTSpoints(66043,610, 59)">';
mtxt += '<area shape="circle" coords="615, 59,3" href="javascript:selectTSpoints(66044,615, 59)">';
mtxt += '<area shape="circle" coords="621, 59,3" href="javascript:selectTSpoints(66045,621, 59)">';
mtxt += '<area shape="circle" coords="626, 59,3" href="javascript:selectTSpoints(66046,626, 59)">';
mtxt += '<area shape="circle" coords="631, 59,3" href="javascript:selectTSpoints(66047,631, 59)">';
mtxt += '<area shape="circle" coords="636, 59,3" href="javascript:selectTSpoints(66048,636, 59)">';
mtxt += '<area shape="circle" coords="641, 59,3" href="javascript:selectTSpoints(66049,641, 59)">';
mtxt += '<area shape="circle" coords="646, 59,3" href="javascript:selectTSpoints(66050,646, 59)">';
mtxt += '<area shape="circle" coords="651, 59,3" href="javascript:selectTSpoints(66051,651, 59)">';
mtxt += '<area shape="circle" coords="656, 59,3" href="javascript:selectTSpoints(66052,656, 59)">';
mtxt += '<area shape="circle" coords="661, 59,3" href="javascript:selectTSpoints(66053,661, 59)">';
mtxt += '<area shape="circle" coords="666, 59,3" href="javascript:selectTSpoints(66054,666, 59)">';
mtxt += '<area shape="circle" coords="671, 59,3" href="javascript:selectTSpoints(66055,671, 59)">';
mtxt += '<area shape="circle" coords="677, 59,3" href="javascript:selectTSpoints(66056,677, 59)">';
mtxt += '<area shape="circle" coords="682, 59,3" href="javascript:selectTSpoints(66057,682, 59)">';
mtxt += '<area shape="circle" coords="687, 59,3" href="javascript:selectTSpoints(66058,687, 59)">';
mtxt += '<area shape="circle" coords="692, 59,3" href="javascript:selectTSpoints(66059,692, 59)">';
mtxt += '<area shape="circle" coords="697, 59,3" href="javascript:selectTSpoints(66060,697, 59)">';
mtxt += '<area shape="circle" coords="702, 59,3" href="javascript:selectTSpoints(66061,702, 59)">';
mtxt += '<area shape="circle" coords="707, 59,3" href="javascript:selectTSpoints(66062,707, 59)">';
mtxt += '<area shape="circle" coords="712, 59,3" href="javascript:selectTSpoints(66063,712, 59)">';
mtxt += '<area shape="circle" coords="717, 59,3" href="javascript:selectTSpoints(66064,717, 59)">';
mtxt += '<area shape="circle" coords="722, 59,3" href="javascript:selectTSpoints(66065,722, 59)">';
mtxt += '<area shape="circle" coords="727, 59,3" href="javascript:selectTSpoints(66066,727, 59)">';
mtxt += '<area shape="circle" coords="733, 59,3" href="javascript:selectTSpoints(66067,733, 59)">';
mtxt += '<area shape="circle" coords="738, 59,3" href="javascript:selectTSpoints(66068,738, 59)">';
mtxt += '<area shape="circle" coords="743, 59,3" href="javascript:selectTSpoints(66069,743, 59)">';
mtxt += '<area shape="circle" coords="748, 59,3" href="javascript:selectTSpoints(66070,748, 59)">';
mtxt += '<area shape="circle" coords="753, 59,3" href="javascript:selectTSpoints(66071,753, 59)">';
mtxt += '<area shape="circle" coords="758, 59,3" href="javascript:selectTSpoints(66072,758, 59)">';
mtxt += '<area shape="circle" coords=" 30, 55,3" href="javascript:selectTSpoints(67073, 30, 55)">';
mtxt += '<area shape="circle" coords=" 35, 55,3" href="javascript:selectTSpoints(67074, 35, 55)">';
mtxt += '<area shape="circle" coords=" 40, 55,3" href="javascript:selectTSpoints(67075, 40, 55)">';
mtxt += '<area shape="circle" coords=" 45, 55,3" href="javascript:selectTSpoints(67076, 45, 55)">';
mtxt += '<area shape="circle" coords=" 50, 55,3" href="javascript:selectTSpoints(67077, 50, 55)">';
mtxt += '<area shape="circle" coords=" 56, 55,3" href="javascript:selectTSpoints(67078, 56, 55)">';
mtxt += '<area shape="circle" coords=" 61, 55,3" href="javascript:selectTSpoints(67079, 61, 55)">';
mtxt += '<area shape="circle" coords=" 66, 55,3" href="javascript:selectTSpoints(67080, 66, 55)">';
mtxt += '<area shape="circle" coords=" 71, 55,3" href="javascript:selectTSpoints(67081, 71, 55)">';
mtxt += '<area shape="circle" coords=" 76, 55,3" href="javascript:selectTSpoints(67082, 76, 55)">';
mtxt += '<area shape="circle" coords=" 81, 55,3" href="javascript:selectTSpoints(67083, 81, 55)">';
mtxt += '<area shape="circle" coords=" 86, 55,3" href="javascript:selectTSpoints(67084, 86, 55)">';
mtxt += '<area shape="circle" coords=" 91, 55,3" href="javascript:selectTSpoints(67085, 91, 55)">';
mtxt += '<area shape="circle" coords=" 96, 55,3" href="javascript:selectTSpoints(67086, 96, 55)">';
mtxt += '<area shape="circle" coords="101, 55,3" href="javascript:selectTSpoints(67087,101, 55)">';
mtxt += '<area shape="circle" coords="106, 55,3" href="javascript:selectTSpoints(67088,106, 55)">';
mtxt += '<area shape="circle" coords="112, 55,3" href="javascript:selectTSpoints(67089,112, 55)">';
mtxt += '<area shape="circle" coords="117, 55,3" href="javascript:selectTSpoints(67090,117, 55)">';
mtxt += '<area shape="circle" coords="122, 55,3" href="javascript:selectTSpoints(67091,122, 55)">';
mtxt += '<area shape="circle" coords="127, 55,3" href="javascript:selectTSpoints(67092,127, 55)">';
mtxt += '<area shape="circle" coords="132, 55,3" href="javascript:selectTSpoints(67093,132, 55)">';
mtxt += '<area shape="circle" coords="137, 55,3" href="javascript:selectTSpoints(67094,137, 55)">';
mtxt += '<area shape="circle" coords="142, 55,3" href="javascript:selectTSpoints(67095,142, 55)">';
mtxt += '<area shape="circle" coords="147, 55,3" href="javascript:selectTSpoints(67096,147, 55)">';
mtxt += '<area shape="circle" coords="152, 55,3" href="javascript:selectTSpoints(67097,152, 55)">';
mtxt += '<area shape="circle" coords="157, 55,3" href="javascript:selectTSpoints(67098,157, 55)">';
mtxt += '<area shape="circle" coords="162, 55,3" href="javascript:selectTSpoints(67099,162, 55)">';
mtxt += '<area shape="circle" coords="168, 55,3" href="javascript:selectTSpoints(67100,168, 55)">';
mtxt += '<area shape="circle" coords="173, 55,3" href="javascript:selectTSpoints(67101,173, 55)">';
mtxt += '<area shape="circle" coords="178, 55,3" href="javascript:selectTSpoints(67102,178, 55)">';
mtxt += '<area shape="circle" coords="183, 55,3" href="javascript:selectTSpoints(67103,183, 55)">';
mtxt += '<area shape="circle" coords="188, 55,3" href="javascript:selectTSpoints(67104,188, 55)">';
mtxt += '<area shape="circle" coords="193, 55,3" href="javascript:selectTSpoints(67105,193, 55)">';
mtxt += '<area shape="circle" coords="198, 55,3" href="javascript:selectTSpoints(67106,198, 55)">';
mtxt += '<area shape="circle" coords="203, 55,3" href="javascript:selectTSpoints(67107,203, 55)">';
mtxt += '<area shape="circle" coords="208, 55,3" href="javascript:selectTSpoints(67108,208, 55)">';
mtxt += '<area shape="circle" coords="213, 55,3" href="javascript:selectTSpoints(67109,213, 55)">';
mtxt += '<area shape="circle" coords="218, 55,3" href="javascript:selectTSpoints(67110,218, 55)">';
mtxt += '<area shape="circle" coords="224, 55,3" href="javascript:selectTSpoints(67111,224, 55)">';
mtxt += '<area shape="circle" coords="229, 55,3" href="javascript:selectTSpoints(67112,229, 55)">';
mtxt += '<area shape="circle" coords="234, 55,3" href="javascript:selectTSpoints(67113,234, 55)">';
mtxt += '<area shape="circle" coords="239, 55,3" href="javascript:selectTSpoints(67114,239, 55)">';
mtxt += '<area shape="circle" coords="244, 55,3" href="javascript:selectTSpoints(67115,244, 55)">';
mtxt += '<area shape="circle" coords="249, 55,3" href="javascript:selectTSpoints(67116,249, 55)">';
mtxt += '<area shape="circle" coords="254, 55,3" href="javascript:selectTSpoints(67117,254, 55)">';
mtxt += '<area shape="circle" coords="259, 55,3" href="javascript:selectTSpoints(67118,259, 55)">';
mtxt += '<area shape="circle" coords="264, 55,3" href="javascript:selectTSpoints(67119,264, 55)">';
mtxt += '<area shape="circle" coords="269, 55,3" href="javascript:selectTSpoints(67120,269, 55)">';
mtxt += '<area shape="circle" coords="274, 55,3" href="javascript:selectTSpoints(67121,274, 55)">';
mtxt += '<area shape="circle" coords="280, 55,3" href="javascript:selectTSpoints(67122,280, 55)">';
mtxt += '<area shape="circle" coords="285, 55,3" href="javascript:selectTSpoints(67123,285, 55)">';
mtxt += '<area shape="circle" coords="290, 55,3" href="javascript:selectTSpoints(67124,290, 55)">';
mtxt += '<area shape="circle" coords="295, 55,3" href="javascript:selectTSpoints(67125,295, 55)">';
mtxt += '<area shape="circle" coords="300, 55,3" href="javascript:selectTSpoints(67126,300, 55)">';
mtxt += '<area shape="circle" coords="305, 55,3" href="javascript:selectTSpoints(67127,305, 55)">';
mtxt += '<area shape="circle" coords="310, 55,3" href="javascript:selectTSpoints(67128,310, 55)">';
mtxt += '<area shape="circle" coords="315, 55,3" href="javascript:selectTSpoints(67129,315, 55)">';
mtxt += '<area shape="circle" coords="320, 55,3" href="javascript:selectTSpoints(67130,320, 55)">';
mtxt += '<area shape="circle" coords="325, 55,3" href="javascript:selectTSpoints(67131,325, 55)">';
mtxt += '<area shape="circle" coords="330, 55,3" href="javascript:selectTSpoints(67132,330, 55)">';
mtxt += '<area shape="circle" coords="336, 55,3" href="javascript:selectTSpoints(67133,336, 55)">';
mtxt += '<area shape="circle" coords="341, 55,3" href="javascript:selectTSpoints(67134,341, 55)">';
mtxt += '<area shape="circle" coords="346, 55,3" href="javascript:selectTSpoints(67135,346, 55)">';
mtxt += '<area shape="circle" coords="351, 55,3" href="javascript:selectTSpoints(67136,351, 55)">';
mtxt += '<area shape="circle" coords="356, 55,3" href="javascript:selectTSpoints(67137,356, 55)">';
mtxt += '<area shape="circle" coords="361, 55,3" href="javascript:selectTSpoints(67138,361, 55)">';
mtxt += '<area shape="circle" coords="366, 55,3" href="javascript:selectTSpoints(67139,366, 55)">';
mtxt += '<area shape="circle" coords="371, 55,3" href="javascript:selectTSpoints(67140,371, 55)">';
mtxt += '<area shape="circle" coords="376, 55,3" href="javascript:selectTSpoints(67141,376, 55)">';
mtxt += '<area shape="circle" coords="381, 55,3" href="javascript:selectTSpoints(67142,381, 55)">';
mtxt += '<area shape="circle" coords="386, 55,3" href="javascript:selectTSpoints(67143,386, 55)">';
mtxt += '<area shape="circle" coords="392, 55,3" href="javascript:selectTSpoints(67144,392, 55)">';
mtxt += '<area shape="circle" coords="397, 55,3" href="javascript:selectTSpoints(67001,397, 55)">';
mtxt += '<area shape="circle" coords="402, 55,3" href="javascript:selectTSpoints(67002,402, 55)">';
mtxt += '<area shape="circle" coords="407, 55,3" href="javascript:selectTSpoints(67003,407, 55)">';
mtxt += '<area shape="circle" coords="412, 55,3" href="javascript:selectTSpoints(67004,412, 55)">';
mtxt += '<area shape="circle" coords="417, 55,3" href="javascript:selectTSpoints(67005,417, 55)">';
mtxt += '<area shape="circle" coords="422, 55,3" href="javascript:selectTSpoints(67006,422, 55)">';
mtxt += '<area shape="circle" coords="427, 55,3" href="javascript:selectTSpoints(67007,427, 55)">';
mtxt += '<area shape="circle" coords="432, 55,3" href="javascript:selectTSpoints(67008,432, 55)">';
mtxt += '<area shape="circle" coords="437, 55,3" href="javascript:selectTSpoints(67009,437, 55)">';
mtxt += '<area shape="circle" coords="442, 55,3" href="javascript:selectTSpoints(67010,442, 55)">';
mtxt += '<area shape="circle" coords="447, 55,3" href="javascript:selectTSpoints(67011,447, 55)">';
mtxt += '<area shape="circle" coords="453, 55,3" href="javascript:selectTSpoints(67012,453, 55)">';
mtxt += '<area shape="circle" coords="458, 55,3" href="javascript:selectTSpoints(67013,458, 55)">';
mtxt += '<area shape="circle" coords="463, 55,3" href="javascript:selectTSpoints(67014,463, 55)">';
mtxt += '<area shape="circle" coords="468, 55,3" href="javascript:selectTSpoints(67015,468, 55)">';
mtxt += '<area shape="circle" coords="473, 55,3" href="javascript:selectTSpoints(67016,473, 55)">';
mtxt += '<area shape="circle" coords="478, 55,3" href="javascript:selectTSpoints(67017,478, 55)">';
mtxt += '<area shape="circle" coords="483, 55,3" href="javascript:selectTSpoints(67018,483, 55)">';
mtxt += '<area shape="circle" coords="488, 55,3" href="javascript:selectTSpoints(67019,488, 55)">';
mtxt += '<area shape="circle" coords="493, 55,3" href="javascript:selectTSpoints(67020,493, 55)">';
mtxt += '<area shape="circle" coords="498, 55,3" href="javascript:selectTSpoints(67021,498, 55)">';
mtxt += '<area shape="circle" coords="503, 55,3" href="javascript:selectTSpoints(67022,503, 55)">';
mtxt += '<area shape="circle" coords="509, 55,3" href="javascript:selectTSpoints(67023,509, 55)">';
mtxt += '<area shape="circle" coords="514, 55,3" href="javascript:selectTSpoints(67024,514, 55)">';
mtxt += '<area shape="circle" coords="519, 55,3" href="javascript:selectTSpoints(67025,519, 55)">';
mtxt += '<area shape="circle" coords="524, 55,3" href="javascript:selectTSpoints(67026,524, 55)">';
mtxt += '<area shape="circle" coords="529, 55,3" href="javascript:selectTSpoints(67027,529, 55)">';
mtxt += '<area shape="circle" coords="534, 55,3" href="javascript:selectTSpoints(67028,534, 55)">';
mtxt += '<area shape="circle" coords="539, 55,3" href="javascript:selectTSpoints(67029,539, 55)">';
mtxt += '<area shape="circle" coords="544, 55,3" href="javascript:selectTSpoints(67030,544, 55)">';
mtxt += '<area shape="circle" coords="549, 55,3" href="javascript:selectTSpoints(67031,549, 55)">';
mtxt += '<area shape="circle" coords="554, 55,3" href="javascript:selectTSpoints(67032,554, 55)">';
mtxt += '<area shape="circle" coords="559, 55,3" href="javascript:selectTSpoints(67033,559, 55)">';
mtxt += '<area shape="circle" coords="565, 55,3" href="javascript:selectTSpoints(67034,565, 55)">';
mtxt += '<area shape="circle" coords="570, 55,3" href="javascript:selectTSpoints(67035,570, 55)">';
mtxt += '<area shape="circle" coords="575, 55,3" href="javascript:selectTSpoints(67036,575, 55)">';
mtxt += '<area shape="circle" coords="580, 55,3" href="javascript:selectTSpoints(67037,580, 55)">';
mtxt += '<area shape="circle" coords="585, 55,3" href="javascript:selectTSpoints(67038,585, 55)">';
mtxt += '<area shape="circle" coords="590, 55,3" href="javascript:selectTSpoints(67039,590, 55)">';
mtxt += '<area shape="circle" coords="595, 55,3" href="javascript:selectTSpoints(67040,595, 55)">';
mtxt += '<area shape="circle" coords="600, 55,3" href="javascript:selectTSpoints(67041,600, 55)">';
mtxt += '<area shape="circle" coords="605, 55,3" href="javascript:selectTSpoints(67042,605, 55)">';
mtxt += '<area shape="circle" coords="610, 55,3" href="javascript:selectTSpoints(67043,610, 55)">';
mtxt += '<area shape="circle" coords="615, 55,3" href="javascript:selectTSpoints(67044,615, 55)">';
mtxt += '<area shape="circle" coords="621, 55,3" href="javascript:selectTSpoints(67045,621, 55)">';
mtxt += '<area shape="circle" coords="626, 55,3" href="javascript:selectTSpoints(67046,626, 55)">';
mtxt += '<area shape="circle" coords="631, 55,3" href="javascript:selectTSpoints(67047,631, 55)">';
mtxt += '<area shape="circle" coords="636, 55,3" href="javascript:selectTSpoints(67048,636, 55)">';
mtxt += '<area shape="circle" coords="641, 55,3" href="javascript:selectTSpoints(67049,641, 55)">';
mtxt += '<area shape="circle" coords="646, 55,3" href="javascript:selectTSpoints(67050,646, 55)">';
mtxt += '<area shape="circle" coords="651, 55,3" href="javascript:selectTSpoints(67051,651, 55)">';
mtxt += '<area shape="circle" coords="656, 55,3" href="javascript:selectTSpoints(67052,656, 55)">';
mtxt += '<area shape="circle" coords="661, 55,3" href="javascript:selectTSpoints(67053,661, 55)">';
mtxt += '<area shape="circle" coords="666, 55,3" href="javascript:selectTSpoints(67054,666, 55)">';
mtxt += '<area shape="circle" coords="671, 55,3" href="javascript:selectTSpoints(67055,671, 55)">';
mtxt += '<area shape="circle" coords="677, 55,3" href="javascript:selectTSpoints(67056,677, 55)">';
mtxt += '<area shape="circle" coords="682, 55,3" href="javascript:selectTSpoints(67057,682, 55)">';
mtxt += '<area shape="circle" coords="687, 55,3" href="javascript:selectTSpoints(67058,687, 55)">';
mtxt += '<area shape="circle" coords="692, 55,3" href="javascript:selectTSpoints(67059,692, 55)">';
mtxt += '<area shape="circle" coords="697, 55,3" href="javascript:selectTSpoints(67060,697, 55)">';
mtxt += '<area shape="circle" coords="702, 55,3" href="javascript:selectTSpoints(67061,702, 55)">';
mtxt += '<area shape="circle" coords="707, 55,3" href="javascript:selectTSpoints(67062,707, 55)">';
mtxt += '<area shape="circle" coords="712, 55,3" href="javascript:selectTSpoints(67063,712, 55)">';
mtxt += '<area shape="circle" coords="717, 55,3" href="javascript:selectTSpoints(67064,717, 55)">';
mtxt += '<area shape="circle" coords="722, 55,3" href="javascript:selectTSpoints(67065,722, 55)">';
mtxt += '<area shape="circle" coords="727, 55,3" href="javascript:selectTSpoints(67066,727, 55)">';
mtxt += '<area shape="circle" coords="733, 55,3" href="javascript:selectTSpoints(67067,733, 55)">';
mtxt += '<area shape="circle" coords="738, 55,3" href="javascript:selectTSpoints(67068,738, 55)">';
mtxt += '<area shape="circle" coords="743, 55,3" href="javascript:selectTSpoints(67069,743, 55)">';
mtxt += '<area shape="circle" coords="748, 55,3" href="javascript:selectTSpoints(67070,748, 55)">';
mtxt += '<area shape="circle" coords="753, 55,3" href="javascript:selectTSpoints(67071,753, 55)">';
mtxt += '<area shape="circle" coords="758, 55,3" href="javascript:selectTSpoints(67072,758, 55)">';
mtxt += '<area shape="circle" coords=" 30, 50,3" href="javascript:selectTSpoints(68073, 30, 50)">';
mtxt += '<area shape="circle" coords=" 35, 50,3" href="javascript:selectTSpoints(68074, 35, 50)">';
mtxt += '<area shape="circle" coords=" 40, 50,3" href="javascript:selectTSpoints(68075, 40, 50)">';
mtxt += '<area shape="circle" coords=" 45, 50,3" href="javascript:selectTSpoints(68076, 45, 50)">';
mtxt += '<area shape="circle" coords=" 50, 50,3" href="javascript:selectTSpoints(68077, 50, 50)">';
mtxt += '<area shape="circle" coords=" 56, 50,3" href="javascript:selectTSpoints(68078, 56, 50)">';
mtxt += '<area shape="circle" coords=" 61, 50,3" href="javascript:selectTSpoints(68079, 61, 50)">';
mtxt += '<area shape="circle" coords=" 66, 50,3" href="javascript:selectTSpoints(68080, 66, 50)">';
mtxt += '<area shape="circle" coords=" 71, 50,3" href="javascript:selectTSpoints(68081, 71, 50)">';
mtxt += '<area shape="circle" coords=" 76, 50,3" href="javascript:selectTSpoints(68082, 76, 50)">';
mtxt += '<area shape="circle" coords=" 81, 50,3" href="javascript:selectTSpoints(68083, 81, 50)">';
mtxt += '<area shape="circle" coords=" 86, 50,3" href="javascript:selectTSpoints(68084, 86, 50)">';
mtxt += '<area shape="circle" coords=" 91, 50,3" href="javascript:selectTSpoints(68085, 91, 50)">';
mtxt += '<area shape="circle" coords=" 96, 50,3" href="javascript:selectTSpoints(68086, 96, 50)">';
mtxt += '<area shape="circle" coords="101, 50,3" href="javascript:selectTSpoints(68087,101, 50)">';
mtxt += '<area shape="circle" coords="106, 50,3" href="javascript:selectTSpoints(68088,106, 50)">';
mtxt += '<area shape="circle" coords="112, 50,3" href="javascript:selectTSpoints(68089,112, 50)">';
mtxt += '<area shape="circle" coords="117, 50,3" href="javascript:selectTSpoints(68090,117, 50)">';
mtxt += '<area shape="circle" coords="122, 50,3" href="javascript:selectTSpoints(68091,122, 50)">';
mtxt += '<area shape="circle" coords="127, 50,3" href="javascript:selectTSpoints(68092,127, 50)">';
mtxt += '<area shape="circle" coords="132, 50,3" href="javascript:selectTSpoints(68093,132, 50)">';
mtxt += '<area shape="circle" coords="137, 50,3" href="javascript:selectTSpoints(68094,137, 50)">';
mtxt += '<area shape="circle" coords="142, 50,3" href="javascript:selectTSpoints(68095,142, 50)">';
mtxt += '<area shape="circle" coords="147, 50,3" href="javascript:selectTSpoints(68096,147, 50)">';
mtxt += '<area shape="circle" coords="152, 50,3" href="javascript:selectTSpoints(68097,152, 50)">';
mtxt += '<area shape="circle" coords="157, 50,3" href="javascript:selectTSpoints(68098,157, 50)">';
mtxt += '<area shape="circle" coords="162, 50,3" href="javascript:selectTSpoints(68099,162, 50)">';
mtxt += '<area shape="circle" coords="168, 50,3" href="javascript:selectTSpoints(68100,168, 50)">';
mtxt += '<area shape="circle" coords="173, 50,3" href="javascript:selectTSpoints(68101,173, 50)">';
mtxt += '<area shape="circle" coords="178, 50,3" href="javascript:selectTSpoints(68102,178, 50)">';
mtxt += '<area shape="circle" coords="183, 50,3" href="javascript:selectTSpoints(68103,183, 50)">';
mtxt += '<area shape="circle" coords="188, 50,3" href="javascript:selectTSpoints(68104,188, 50)">';
mtxt += '<area shape="circle" coords="193, 50,3" href="javascript:selectTSpoints(68105,193, 50)">';
mtxt += '<area shape="circle" coords="198, 50,3" href="javascript:selectTSpoints(68106,198, 50)">';
mtxt += '<area shape="circle" coords="203, 50,3" href="javascript:selectTSpoints(68107,203, 50)">';
mtxt += '<area shape="circle" coords="208, 50,3" href="javascript:selectTSpoints(68108,208, 50)">';
mtxt += '<area shape="circle" coords="213, 50,3" href="javascript:selectTSpoints(68109,213, 50)">';
mtxt += '<area shape="circle" coords="218, 50,3" href="javascript:selectTSpoints(68110,218, 50)">';
mtxt += '<area shape="circle" coords="224, 50,3" href="javascript:selectTSpoints(68111,224, 50)">';
mtxt += '<area shape="circle" coords="229, 50,3" href="javascript:selectTSpoints(68112,229, 50)">';
mtxt += '<area shape="circle" coords="234, 50,3" href="javascript:selectTSpoints(68113,234, 50)">';
mtxt += '<area shape="circle" coords="239, 50,3" href="javascript:selectTSpoints(68114,239, 50)">';
mtxt += '<area shape="circle" coords="244, 50,3" href="javascript:selectTSpoints(68115,244, 50)">';
mtxt += '<area shape="circle" coords="249, 50,3" href="javascript:selectTSpoints(68116,249, 50)">';
mtxt += '<area shape="circle" coords="254, 50,3" href="javascript:selectTSpoints(68117,254, 50)">';
mtxt += '<area shape="circle" coords="259, 50,3" href="javascript:selectTSpoints(68118,259, 50)">';
mtxt += '<area shape="circle" coords="264, 50,3" href="javascript:selectTSpoints(68119,264, 50)">';
mtxt += '<area shape="circle" coords="269, 50,3" href="javascript:selectTSpoints(68120,269, 50)">';
mtxt += '<area shape="circle" coords="274, 50,3" href="javascript:selectTSpoints(68121,274, 50)">';
mtxt += '<area shape="circle" coords="280, 50,3" href="javascript:selectTSpoints(68122,280, 50)">';
mtxt += '<area shape="circle" coords="285, 50,3" href="javascript:selectTSpoints(68123,285, 50)">';
mtxt += '<area shape="circle" coords="290, 50,3" href="javascript:selectTSpoints(68124,290, 50)">';
mtxt += '<area shape="circle" coords="295, 50,3" href="javascript:selectTSpoints(68125,295, 50)">';
mtxt += '<area shape="circle" coords="300, 50,3" href="javascript:selectTSpoints(68126,300, 50)">';
mtxt += '<area shape="circle" coords="305, 50,3" href="javascript:selectTSpoints(68127,305, 50)">';
mtxt += '<area shape="circle" coords="310, 50,3" href="javascript:selectTSpoints(68128,310, 50)">';
mtxt += '<area shape="circle" coords="315, 50,3" href="javascript:selectTSpoints(68129,315, 50)">';
mtxt += '<area shape="circle" coords="320, 50,3" href="javascript:selectTSpoints(68130,320, 50)">';
mtxt += '<area shape="circle" coords="325, 50,3" href="javascript:selectTSpoints(68131,325, 50)">';
mtxt += '<area shape="circle" coords="330, 50,3" href="javascript:selectTSpoints(68132,330, 50)">';
mtxt += '<area shape="circle" coords="336, 50,3" href="javascript:selectTSpoints(68133,336, 50)">';
mtxt += '<area shape="circle" coords="341, 50,3" href="javascript:selectTSpoints(68134,341, 50)">';
mtxt += '<area shape="circle" coords="346, 50,3" href="javascript:selectTSpoints(68135,346, 50)">';
mtxt += '<area shape="circle" coords="351, 50,3" href="javascript:selectTSpoints(68136,351, 50)">';
mtxt += '<area shape="circle" coords="356, 50,3" href="javascript:selectTSpoints(68137,356, 50)">';
mtxt += '<area shape="circle" coords="361, 50,3" href="javascript:selectTSpoints(68138,361, 50)">';
mtxt += '<area shape="circle" coords="366, 50,3" href="javascript:selectTSpoints(68139,366, 50)">';
mtxt += '<area shape="circle" coords="371, 50,3" href="javascript:selectTSpoints(68140,371, 50)">';
mtxt += '<area shape="circle" coords="376, 50,3" href="javascript:selectTSpoints(68141,376, 50)">';
mtxt += '<area shape="circle" coords="381, 50,3" href="javascript:selectTSpoints(68142,381, 50)">';
mtxt += '<area shape="circle" coords="386, 50,3" href="javascript:selectTSpoints(68143,386, 50)">';
mtxt += '<area shape="circle" coords="392, 50,3" href="javascript:selectTSpoints(68144,392, 50)">';
mtxt += '<area shape="circle" coords="397, 50,3" href="javascript:selectTSpoints(68001,397, 50)">';
mtxt += '<area shape="circle" coords="402, 50,3" href="javascript:selectTSpoints(68002,402, 50)">';
mtxt += '<area shape="circle" coords="407, 50,3" href="javascript:selectTSpoints(68003,407, 50)">';
mtxt += '<area shape="circle" coords="412, 50,3" href="javascript:selectTSpoints(68004,412, 50)">';
mtxt += '<area shape="circle" coords="417, 50,3" href="javascript:selectTSpoints(68005,417, 50)">';
mtxt += '<area shape="circle" coords="422, 50,3" href="javascript:selectTSpoints(68006,422, 50)">';
mtxt += '<area shape="circle" coords="427, 50,3" href="javascript:selectTSpoints(68007,427, 50)">';
mtxt += '<area shape="circle" coords="432, 50,3" href="javascript:selectTSpoints(68008,432, 50)">';
mtxt += '<area shape="circle" coords="437, 50,3" href="javascript:selectTSpoints(68009,437, 50)">';
mtxt += '<area shape="circle" coords="442, 50,3" href="javascript:selectTSpoints(68010,442, 50)">';
mtxt += '<area shape="circle" coords="447, 50,3" href="javascript:selectTSpoints(68011,447, 50)">';
mtxt += '<area shape="circle" coords="453, 50,3" href="javascript:selectTSpoints(68012,453, 50)">';
mtxt += '<area shape="circle" coords="458, 50,3" href="javascript:selectTSpoints(68013,458, 50)">';
mtxt += '<area shape="circle" coords="463, 50,3" href="javascript:selectTSpoints(68014,463, 50)">';
mtxt += '<area shape="circle" coords="468, 50,3" href="javascript:selectTSpoints(68015,468, 50)">';
mtxt += '<area shape="circle" coords="473, 50,3" href="javascript:selectTSpoints(68016,473, 50)">';
mtxt += '<area shape="circle" coords="478, 50,3" href="javascript:selectTSpoints(68017,478, 50)">';
mtxt += '<area shape="circle" coords="483, 50,3" href="javascript:selectTSpoints(68018,483, 50)">';
mtxt += '<area shape="circle" coords="488, 50,3" href="javascript:selectTSpoints(68019,488, 50)">';
mtxt += '<area shape="circle" coords="493, 50,3" href="javascript:selectTSpoints(68020,493, 50)">';
mtxt += '<area shape="circle" coords="498, 50,3" href="javascript:selectTSpoints(68021,498, 50)">';
mtxt += '<area shape="circle" coords="503, 50,3" href="javascript:selectTSpoints(68022,503, 50)">';
mtxt += '<area shape="circle" coords="509, 50,3" href="javascript:selectTSpoints(68023,509, 50)">';
mtxt += '<area shape="circle" coords="514, 50,3" href="javascript:selectTSpoints(68024,514, 50)">';
mtxt += '<area shape="circle" coords="519, 50,3" href="javascript:selectTSpoints(68025,519, 50)">';
mtxt += '<area shape="circle" coords="524, 50,3" href="javascript:selectTSpoints(68026,524, 50)">';
mtxt += '<area shape="circle" coords="529, 50,3" href="javascript:selectTSpoints(68027,529, 50)">';
mtxt += '<area shape="circle" coords="534, 50,3" href="javascript:selectTSpoints(68028,534, 50)">';
mtxt += '<area shape="circle" coords="539, 50,3" href="javascript:selectTSpoints(68029,539, 50)">';
mtxt += '<area shape="circle" coords="544, 50,3" href="javascript:selectTSpoints(68030,544, 50)">';
mtxt += '<area shape="circle" coords="549, 50,3" href="javascript:selectTSpoints(68031,549, 50)">';
mtxt += '<area shape="circle" coords="554, 50,3" href="javascript:selectTSpoints(68032,554, 50)">';
mtxt += '<area shape="circle" coords="559, 50,3" href="javascript:selectTSpoints(68033,559, 50)">';
mtxt += '<area shape="circle" coords="565, 50,3" href="javascript:selectTSpoints(68034,565, 50)">';
mtxt += '<area shape="circle" coords="570, 50,3" href="javascript:selectTSpoints(68035,570, 50)">';
mtxt += '<area shape="circle" coords="575, 50,3" href="javascript:selectTSpoints(68036,575, 50)">';
mtxt += '<area shape="circle" coords="580, 50,3" href="javascript:selectTSpoints(68037,580, 50)">';
mtxt += '<area shape="circle" coords="585, 50,3" href="javascript:selectTSpoints(68038,585, 50)">';
mtxt += '<area shape="circle" coords="590, 50,3" href="javascript:selectTSpoints(68039,590, 50)">';
mtxt += '<area shape="circle" coords="595, 50,3" href="javascript:selectTSpoints(68040,595, 50)">';
mtxt += '<area shape="circle" coords="600, 50,3" href="javascript:selectTSpoints(68041,600, 50)">';
mtxt += '<area shape="circle" coords="605, 50,3" href="javascript:selectTSpoints(68042,605, 50)">';
mtxt += '<area shape="circle" coords="610, 50,3" href="javascript:selectTSpoints(68043,610, 50)">';
mtxt += '<area shape="circle" coords="615, 50,3" href="javascript:selectTSpoints(68044,615, 50)">';
mtxt += '<area shape="circle" coords="621, 50,3" href="javascript:selectTSpoints(68045,621, 50)">';
mtxt += '<area shape="circle" coords="626, 50,3" href="javascript:selectTSpoints(68046,626, 50)">';
mtxt += '<area shape="circle" coords="631, 50,3" href="javascript:selectTSpoints(68047,631, 50)">';
mtxt += '<area shape="circle" coords="636, 50,3" href="javascript:selectTSpoints(68048,636, 50)">';
mtxt += '<area shape="circle" coords="641, 50,3" href="javascript:selectTSpoints(68049,641, 50)">';
mtxt += '<area shape="circle" coords="646, 50,3" href="javascript:selectTSpoints(68050,646, 50)">';
mtxt += '<area shape="circle" coords="651, 50,3" href="javascript:selectTSpoints(68051,651, 50)">';
mtxt += '<area shape="circle" coords="656, 50,3" href="javascript:selectTSpoints(68052,656, 50)">';
mtxt += '<area shape="circle" coords="661, 50,3" href="javascript:selectTSpoints(68053,661, 50)">';
mtxt += '<area shape="circle" coords="666, 50,3" href="javascript:selectTSpoints(68054,666, 50)">';
mtxt += '<area shape="circle" coords="671, 50,3" href="javascript:selectTSpoints(68055,671, 50)">';
mtxt += '<area shape="circle" coords="677, 50,3" href="javascript:selectTSpoints(68056,677, 50)">';
mtxt += '<area shape="circle" coords="682, 50,3" href="javascript:selectTSpoints(68057,682, 50)">';
mtxt += '<area shape="circle" coords="687, 50,3" href="javascript:selectTSpoints(68058,687, 50)">';
mtxt += '<area shape="circle" coords="692, 50,3" href="javascript:selectTSpoints(68059,692, 50)">';
mtxt += '<area shape="circle" coords="697, 50,3" href="javascript:selectTSpoints(68060,697, 50)">';
mtxt += '<area shape="circle" coords="702, 50,3" href="javascript:selectTSpoints(68061,702, 50)">';
mtxt += '<area shape="circle" coords="707, 50,3" href="javascript:selectTSpoints(68062,707, 50)">';
mtxt += '<area shape="circle" coords="712, 50,3" href="javascript:selectTSpoints(68063,712, 50)">';
mtxt += '<area shape="circle" coords="717, 50,3" href="javascript:selectTSpoints(68064,717, 50)">';
mtxt += '<area shape="circle" coords="722, 50,3" href="javascript:selectTSpoints(68065,722, 50)">';
mtxt += '<area shape="circle" coords="727, 50,3" href="javascript:selectTSpoints(68066,727, 50)">';
mtxt += '<area shape="circle" coords="733, 50,3" href="javascript:selectTSpoints(68067,733, 50)">';
mtxt += '<area shape="circle" coords="738, 50,3" href="javascript:selectTSpoints(68068,738, 50)">';
mtxt += '<area shape="circle" coords="743, 50,3" href="javascript:selectTSpoints(68069,743, 50)">';
mtxt += '<area shape="circle" coords="748, 50,3" href="javascript:selectTSpoints(68070,748, 50)">';
mtxt += '<area shape="circle" coords="753, 50,3" href="javascript:selectTSpoints(68071,753, 50)">';
mtxt += '<area shape="circle" coords="758, 50,3" href="javascript:selectTSpoints(68072,758, 50)">';
mtxt += '<area shape="circle" coords=" 30, 45,3" href="javascript:selectTSpoints(69073, 30, 45)">';
mtxt += '<area shape="circle" coords=" 35, 45,3" href="javascript:selectTSpoints(69074, 35, 45)">';
mtxt += '<area shape="circle" coords=" 40, 45,3" href="javascript:selectTSpoints(69075, 40, 45)">';
mtxt += '<area shape="circle" coords=" 45, 45,3" href="javascript:selectTSpoints(69076, 45, 45)">';
mtxt += '<area shape="circle" coords=" 50, 45,3" href="javascript:selectTSpoints(69077, 50, 45)">';
mtxt += '<area shape="circle" coords=" 56, 45,3" href="javascript:selectTSpoints(69078, 56, 45)">';
mtxt += '<area shape="circle" coords=" 61, 45,3" href="javascript:selectTSpoints(69079, 61, 45)">';
mtxt += '<area shape="circle" coords=" 66, 45,3" href="javascript:selectTSpoints(69080, 66, 45)">';
mtxt += '<area shape="circle" coords=" 71, 45,3" href="javascript:selectTSpoints(69081, 71, 45)">';
mtxt += '<area shape="circle" coords=" 76, 45,3" href="javascript:selectTSpoints(69082, 76, 45)">';
mtxt += '<area shape="circle" coords=" 81, 45,3" href="javascript:selectTSpoints(69083, 81, 45)">';
mtxt += '<area shape="circle" coords=" 86, 45,3" href="javascript:selectTSpoints(69084, 86, 45)">';
mtxt += '<area shape="circle" coords=" 91, 45,3" href="javascript:selectTSpoints(69085, 91, 45)">';
mtxt += '<area shape="circle" coords=" 96, 45,3" href="javascript:selectTSpoints(69086, 96, 45)">';
mtxt += '<area shape="circle" coords="101, 45,3" href="javascript:selectTSpoints(69087,101, 45)">';
mtxt += '<area shape="circle" coords="106, 45,3" href="javascript:selectTSpoints(69088,106, 45)">';
mtxt += '<area shape="circle" coords="112, 45,3" href="javascript:selectTSpoints(69089,112, 45)">';
mtxt += '<area shape="circle" coords="117, 45,3" href="javascript:selectTSpoints(69090,117, 45)">';
mtxt += '<area shape="circle" coords="122, 45,3" href="javascript:selectTSpoints(69091,122, 45)">';
mtxt += '<area shape="circle" coords="127, 45,3" href="javascript:selectTSpoints(69092,127, 45)">';
mtxt += '<area shape="circle" coords="132, 45,3" href="javascript:selectTSpoints(69093,132, 45)">';
mtxt += '<area shape="circle" coords="137, 45,3" href="javascript:selectTSpoints(69094,137, 45)">';
mtxt += '<area shape="circle" coords="142, 45,3" href="javascript:selectTSpoints(69095,142, 45)">';
mtxt += '<area shape="circle" coords="147, 45,3" href="javascript:selectTSpoints(69096,147, 45)">';
mtxt += '<area shape="circle" coords="152, 45,3" href="javascript:selectTSpoints(69097,152, 45)">';
mtxt += '<area shape="circle" coords="157, 45,3" href="javascript:selectTSpoints(69098,157, 45)">';
mtxt += '<area shape="circle" coords="162, 45,3" href="javascript:selectTSpoints(69099,162, 45)">';
mtxt += '<area shape="circle" coords="168, 45,3" href="javascript:selectTSpoints(69100,168, 45)">';
mtxt += '<area shape="circle" coords="173, 45,3" href="javascript:selectTSpoints(69101,173, 45)">';
mtxt += '<area shape="circle" coords="178, 45,3" href="javascript:selectTSpoints(69102,178, 45)">';
mtxt += '<area shape="circle" coords="183, 45,3" href="javascript:selectTSpoints(69103,183, 45)">';
mtxt += '<area shape="circle" coords="188, 45,3" href="javascript:selectTSpoints(69104,188, 45)">';
mtxt += '<area shape="circle" coords="193, 45,3" href="javascript:selectTSpoints(69105,193, 45)">';
mtxt += '<area shape="circle" coords="198, 45,3" href="javascript:selectTSpoints(69106,198, 45)">';
mtxt += '<area shape="circle" coords="203, 45,3" href="javascript:selectTSpoints(69107,203, 45)">';
mtxt += '<area shape="circle" coords="208, 45,3" href="javascript:selectTSpoints(69108,208, 45)">';
mtxt += '<area shape="circle" coords="213, 45,3" href="javascript:selectTSpoints(69109,213, 45)">';
mtxt += '<area shape="circle" coords="218, 45,3" href="javascript:selectTSpoints(69110,218, 45)">';
mtxt += '<area shape="circle" coords="224, 45,3" href="javascript:selectTSpoints(69111,224, 45)">';
mtxt += '<area shape="circle" coords="229, 45,3" href="javascript:selectTSpoints(69112,229, 45)">';
mtxt += '<area shape="circle" coords="234, 45,3" href="javascript:selectTSpoints(69113,234, 45)">';
mtxt += '<area shape="circle" coords="239, 45,3" href="javascript:selectTSpoints(69114,239, 45)">';
mtxt += '<area shape="circle" coords="244, 45,3" href="javascript:selectTSpoints(69115,244, 45)">';
mtxt += '<area shape="circle" coords="249, 45,3" href="javascript:selectTSpoints(69116,249, 45)">';
mtxt += '<area shape="circle" coords="254, 45,3" href="javascript:selectTSpoints(69117,254, 45)">';
mtxt += '<area shape="circle" coords="259, 45,3" href="javascript:selectTSpoints(69118,259, 45)">';
mtxt += '<area shape="circle" coords="264, 45,3" href="javascript:selectTSpoints(69119,264, 45)">';
mtxt += '<area shape="circle" coords="269, 45,3" href="javascript:selectTSpoints(69120,269, 45)">';
mtxt += '<area shape="circle" coords="274, 45,3" href="javascript:selectTSpoints(69121,274, 45)">';
mtxt += '<area shape="circle" coords="280, 45,3" href="javascript:selectTSpoints(69122,280, 45)">';
mtxt += '<area shape="circle" coords="285, 45,3" href="javascript:selectTSpoints(69123,285, 45)">';
mtxt += '<area shape="circle" coords="290, 45,3" href="javascript:selectTSpoints(69124,290, 45)">';
mtxt += '<area shape="circle" coords="295, 45,3" href="javascript:selectTSpoints(69125,295, 45)">';
mtxt += '<area shape="circle" coords="300, 45,3" href="javascript:selectTSpoints(69126,300, 45)">';
mtxt += '<area shape="circle" coords="305, 45,3" href="javascript:selectTSpoints(69127,305, 45)">';
mtxt += '<area shape="circle" coords="310, 45,3" href="javascript:selectTSpoints(69128,310, 45)">';
mtxt += '<area shape="circle" coords="315, 45,3" href="javascript:selectTSpoints(69129,315, 45)">';
mtxt += '<area shape="circle" coords="320, 45,3" href="javascript:selectTSpoints(69130,320, 45)">';
mtxt += '<area shape="circle" coords="325, 45,3" href="javascript:selectTSpoints(69131,325, 45)">';
mtxt += '<area shape="circle" coords="330, 45,3" href="javascript:selectTSpoints(69132,330, 45)">';
mtxt += '<area shape="circle" coords="336, 45,3" href="javascript:selectTSpoints(69133,336, 45)">';
mtxt += '<area shape="circle" coords="341, 45,3" href="javascript:selectTSpoints(69134,341, 45)">';
mtxt += '<area shape="circle" coords="346, 45,3" href="javascript:selectTSpoints(69135,346, 45)">';
mtxt += '<area shape="circle" coords="351, 45,3" href="javascript:selectTSpoints(69136,351, 45)">';
mtxt += '<area shape="circle" coords="356, 45,3" href="javascript:selectTSpoints(69137,356, 45)">';
mtxt += '<area shape="circle" coords="361, 45,3" href="javascript:selectTSpoints(69138,361, 45)">';
mtxt += '<area shape="circle" coords="366, 45,3" href="javascript:selectTSpoints(69139,366, 45)">';
mtxt += '<area shape="circle" coords="371, 45,3" href="javascript:selectTSpoints(69140,371, 45)">';
mtxt += '<area shape="circle" coords="376, 45,3" href="javascript:selectTSpoints(69141,376, 45)">';
mtxt += '<area shape="circle" coords="381, 45,3" href="javascript:selectTSpoints(69142,381, 45)">';
mtxt += '<area shape="circle" coords="386, 45,3" href="javascript:selectTSpoints(69143,386, 45)">';
mtxt += '<area shape="circle" coords="392, 45,3" href="javascript:selectTSpoints(69144,392, 45)">';
mtxt += '<area shape="circle" coords="397, 45,3" href="javascript:selectTSpoints(69001,397, 45)">';
mtxt += '<area shape="circle" coords="402, 45,3" href="javascript:selectTSpoints(69002,402, 45)">';
mtxt += '<area shape="circle" coords="407, 45,3" href="javascript:selectTSpoints(69003,407, 45)">';
mtxt += '<area shape="circle" coords="412, 45,3" href="javascript:selectTSpoints(69004,412, 45)">';
mtxt += '<area shape="circle" coords="417, 45,3" href="javascript:selectTSpoints(69005,417, 45)">';
mtxt += '<area shape="circle" coords="422, 45,3" href="javascript:selectTSpoints(69006,422, 45)">';
mtxt += '<area shape="circle" coords="427, 45,3" href="javascript:selectTSpoints(69007,427, 45)">';
mtxt += '<area shape="circle" coords="432, 45,3" href="javascript:selectTSpoints(69008,432, 45)">';
mtxt += '<area shape="circle" coords="437, 45,3" href="javascript:selectTSpoints(69009,437, 45)">';
mtxt += '<area shape="circle" coords="442, 45,3" href="javascript:selectTSpoints(69010,442, 45)">';
mtxt += '<area shape="circle" coords="447, 45,3" href="javascript:selectTSpoints(69011,447, 45)">';
mtxt += '<area shape="circle" coords="453, 45,3" href="javascript:selectTSpoints(69012,453, 45)">';
mtxt += '<area shape="circle" coords="458, 45,3" href="javascript:selectTSpoints(69013,458, 45)">';
mtxt += '<area shape="circle" coords="463, 45,3" href="javascript:selectTSpoints(69014,463, 45)">';
mtxt += '<area shape="circle" coords="468, 45,3" href="javascript:selectTSpoints(69015,468, 45)">';
mtxt += '<area shape="circle" coords="473, 45,3" href="javascript:selectTSpoints(69016,473, 45)">';
mtxt += '<area shape="circle" coords="478, 45,3" href="javascript:selectTSpoints(69017,478, 45)">';
mtxt += '<area shape="circle" coords="483, 45,3" href="javascript:selectTSpoints(69018,483, 45)">';
mtxt += '<area shape="circle" coords="488, 45,3" href="javascript:selectTSpoints(69019,488, 45)">';
mtxt += '<area shape="circle" coords="493, 45,3" href="javascript:selectTSpoints(69020,493, 45)">';
mtxt += '<area shape="circle" coords="498, 45,3" href="javascript:selectTSpoints(69021,498, 45)">';
mtxt += '<area shape="circle" coords="503, 45,3" href="javascript:selectTSpoints(69022,503, 45)">';
mtxt += '<area shape="circle" coords="509, 45,3" href="javascript:selectTSpoints(69023,509, 45)">';
mtxt += '<area shape="circle" coords="514, 45,3" href="javascript:selectTSpoints(69024,514, 45)">';
mtxt += '<area shape="circle" coords="519, 45,3" href="javascript:selectTSpoints(69025,519, 45)">';
mtxt += '<area shape="circle" coords="524, 45,3" href="javascript:selectTSpoints(69026,524, 45)">';
mtxt += '<area shape="circle" coords="529, 45,3" href="javascript:selectTSpoints(69027,529, 45)">';
mtxt += '<area shape="circle" coords="534, 45,3" href="javascript:selectTSpoints(69028,534, 45)">';
mtxt += '<area shape="circle" coords="539, 45,3" href="javascript:selectTSpoints(69029,539, 45)">';
mtxt += '<area shape="circle" coords="544, 45,3" href="javascript:selectTSpoints(69030,544, 45)">';
mtxt += '<area shape="circle" coords="549, 45,3" href="javascript:selectTSpoints(69031,549, 45)">';
mtxt += '<area shape="circle" coords="554, 45,3" href="javascript:selectTSpoints(69032,554, 45)">';
mtxt += '<area shape="circle" coords="559, 45,3" href="javascript:selectTSpoints(69033,559, 45)">';
mtxt += '<area shape="circle" coords="565, 45,3" href="javascript:selectTSpoints(69034,565, 45)">';
mtxt += '<area shape="circle" coords="570, 45,3" href="javascript:selectTSpoints(69035,570, 45)">';
mtxt += '<area shape="circle" coords="575, 45,3" href="javascript:selectTSpoints(69036,575, 45)">';
mtxt += '<area shape="circle" coords="580, 45,3" href="javascript:selectTSpoints(69037,580, 45)">';
mtxt += '<area shape="circle" coords="585, 45,3" href="javascript:selectTSpoints(69038,585, 45)">';
mtxt += '<area shape="circle" coords="590, 45,3" href="javascript:selectTSpoints(69039,590, 45)">';
mtxt += '<area shape="circle" coords="595, 45,3" href="javascript:selectTSpoints(69040,595, 45)">';
mtxt += '<area shape="circle" coords="600, 45,3" href="javascript:selectTSpoints(69041,600, 45)">';
mtxt += '<area shape="circle" coords="605, 45,3" href="javascript:selectTSpoints(69042,605, 45)">';
mtxt += '<area shape="circle" coords="610, 45,3" href="javascript:selectTSpoints(69043,610, 45)">';
mtxt += '<area shape="circle" coords="615, 45,3" href="javascript:selectTSpoints(69044,615, 45)">';
mtxt += '<area shape="circle" coords="621, 45,3" href="javascript:selectTSpoints(69045,621, 45)">';
mtxt += '<area shape="circle" coords="626, 45,3" href="javascript:selectTSpoints(69046,626, 45)">';
mtxt += '<area shape="circle" coords="631, 45,3" href="javascript:selectTSpoints(69047,631, 45)">';
mtxt += '<area shape="circle" coords="636, 45,3" href="javascript:selectTSpoints(69048,636, 45)">';
mtxt += '<area shape="circle" coords="641, 45,3" href="javascript:selectTSpoints(69049,641, 45)">';
mtxt += '<area shape="circle" coords="646, 45,3" href="javascript:selectTSpoints(69050,646, 45)">';
mtxt += '<area shape="circle" coords="651, 45,3" href="javascript:selectTSpoints(69051,651, 45)">';
mtxt += '<area shape="circle" coords="656, 45,3" href="javascript:selectTSpoints(69052,656, 45)">';
mtxt += '<area shape="circle" coords="661, 45,3" href="javascript:selectTSpoints(69053,661, 45)">';
mtxt += '<area shape="circle" coords="666, 45,3" href="javascript:selectTSpoints(69054,666, 45)">';
mtxt += '<area shape="circle" coords="671, 45,3" href="javascript:selectTSpoints(69055,671, 45)">';
mtxt += '<area shape="circle" coords="677, 45,3" href="javascript:selectTSpoints(69056,677, 45)">';
mtxt += '<area shape="circle" coords="682, 45,3" href="javascript:selectTSpoints(69057,682, 45)">';
mtxt += '<area shape="circle" coords="687, 45,3" href="javascript:selectTSpoints(69058,687, 45)">';
mtxt += '<area shape="circle" coords="692, 45,3" href="javascript:selectTSpoints(69059,692, 45)">';
mtxt += '<area shape="circle" coords="697, 45,3" href="javascript:selectTSpoints(69060,697, 45)">';
mtxt += '<area shape="circle" coords="702, 45,3" href="javascript:selectTSpoints(69061,702, 45)">';
mtxt += '<area shape="circle" coords="707, 45,3" href="javascript:selectTSpoints(69062,707, 45)">';
mtxt += '<area shape="circle" coords="712, 45,3" href="javascript:selectTSpoints(69063,712, 45)">';
mtxt += '<area shape="circle" coords="717, 45,3" href="javascript:selectTSpoints(69064,717, 45)">';
mtxt += '<area shape="circle" coords="722, 45,3" href="javascript:selectTSpoints(69065,722, 45)">';
mtxt += '<area shape="circle" coords="727, 45,3" href="javascript:selectTSpoints(69066,727, 45)">';
mtxt += '<area shape="circle" coords="733, 45,3" href="javascript:selectTSpoints(69067,733, 45)">';
mtxt += '<area shape="circle" coords="738, 45,3" href="javascript:selectTSpoints(69068,738, 45)">';
mtxt += '<area shape="circle" coords="743, 45,3" href="javascript:selectTSpoints(69069,743, 45)">';
mtxt += '<area shape="circle" coords="748, 45,3" href="javascript:selectTSpoints(69070,748, 45)">';
mtxt += '<area shape="circle" coords="753, 45,3" href="javascript:selectTSpoints(69071,753, 45)">';
mtxt += '<area shape="circle" coords="758, 4