////////////////////////////////////////////////////////////////////////////////////
// 	dispTciList.js holds functions for the composite TCI lists
//    	(displayed either on the main page or a remote page)
//	- global variables used are located in accessData.js
//	
//	FUNCTIONS: 
// (1) showtciGmap() 
// (2) createtciGmapB()
// (3) hidetciGmap()
// (4) generateTciList(nodeID,icoord,jcoord,iflg)
//    showing composite member TCI names and numbers 
///////// global variables for all data defined here  //////////////////
/* Global variable isweb is set within this javascript file. isweb==1 implies that the 
tool is accessible from a server. isweb==0 means the tool is run on a local machine */

/*  global variables */

//var cvarcomp = new Array();  // array of variable names
//var n10p = 0;

////////////  FUNCTION showtciGmap()  ///////////////////////////////////////////////
//	(1) creates disp_tciList, which creates the image map (gmap) with nodeIDs and
//		the number of high and moderate member TCIs
//	(2) displays, hides, and detaches
/////////////////////////////////////////////////////////////////////////////////////
function showtciGmap() { 
//alert('enter showtciGmap: thecvar='+thecvar+' idisp_tciList='+idisp_tciList);
//
// remove the disp_mbrtol, disp_crank, disp_cyears divs
//alert('idisp_mbrtol='+idisp_mbrtol+' idisp_crank='+idisp_crank+' idisp_cyears='+idisp_cyears);
	if(idisp_focusregion==1) {
	document.getElementById("disp_mbrtol").style.display="none"; 
	document.getElementById("disp_crank").style.display="none"; 
	document.getElementById("disp_cyears").style.display="none"; 
	}
//------------------------------------------------------------------
//  	if exists, show the map and "hide button; hide the "show" button
//------------------------------------------------------------------
	if(idisp_tciList==1) {
	document.getElementById("disp_tciList").style.display="block";  // the gmap
	if(idisp_detachB==1) {
	document.getElementById("disp_detachB").style.display="block";
	}
	document.getElementById("disp_tciGmapB").style.display="none";  // the showB
	document.getElementById("disp_detachGMB").style.display="block";  // the detachB
	document.getElementById("hide_tciGmapB").style.display="block";  // the hideB
	if (igrid_locator==1) {
	document.getElementById('grid_locator').style.display="block";
	document.getElementById('disp_sigtcis').style.display="block";
	}
	if (idisp_focusregion==1) {
	hideRegion(0)
	}
	return;
	}

//------------------------------------------------------------------
//create the appropriate variable-dependent map, if it dosn't exist
//------------------------------------------------------------------
var dmap = document.createElement('div');
var divIdName = "disp_tciList";
dmap.setAttribute('id',divIdName);
dmap.style.width = "770px";
dmap.style.height = "402px";
dmap.style.left = "5px";
dmap.style.top = "10px";
dmap.style.position = "absolute";
dmap.style.zIndex = 150;
mtxt = '<table class="map_table" width="770" height="402" border="0" cellpadding="0" cellspacing="0">';
mtxt += '<tr><td valign="top">';
mtxt += '<img class="gimap-ovrlay" src="dated/'+theaDate+'/figs-tcilist/tcilist-imap-'+thecvar+'.jpg"';
mtxt += ' width="770" height="402" border="0" usemap="#zgimap-ovrlay" alt=""/>';
mtxt += '<map id="zgimap-ovrlay" name="zgimap-ovrlay">';
mtxt += '<area shape="circle" coords="410, 65,12" href="javascript:generateTciList(10004,410, 65,0)">';
mtxt += '<area shape="circle" coords="440, 65,12" href="javascript:generateTciList(10010,440, 65,0)">';
mtxt += '<area shape="circle" coords="471, 65,12" href="javascript:generateTciList(10016,471, 65,0)">';
mtxt += '<area shape="circle" coords="502, 65,12" href="javascript:generateTciList(10022,502, 65,0)">';
mtxt += '<area shape="circle" coords="532, 65,12" href="javascript:generateTciList(10028,532, 65,0)">';
mtxt += '<area shape="circle" coords="562, 65,12" href="javascript:generateTciList(10034,562, 65,0)">';
mtxt += '<area shape="circle" coords="592, 65,12" href="javascript:generateTciList(10040,592, 65,0)">';
mtxt += '<area shape="circle" coords="624, 65,12" href="javascript:generateTciList(10046,624, 65,0)">';
mtxt += '<area shape="circle" coords="654, 65,12" href="javascript:generateTciList(10052,654, 65,0)">';
mtxt += '<area shape="circle" coords="684, 65,12" href="javascript:generateTciList(10058,684, 65,0)">';
mtxt += '<area shape="circle" coords="715, 65,12" href="javascript:generateTciList(10064,715, 65,0)">';
mtxt += '<area shape="circle" coords="746, 65,12" href="javascript:generateTciList(10070,746, 65,0)">';
mtxt += '<area shape="circle" coords=" 44, 65,12" href="javascript:generateTciList(10076, 44, 65,0)">';
mtxt += '<area shape="circle" coords=" 75, 65,12" href="javascript:generateTciList(10082, 75, 65,0)">';
mtxt += '<area shape="circle" coords="105, 65,12" href="javascript:generateTciList(10088,105, 65,0)">';
mtxt += '<area shape="circle" coords="135, 65,12" href="javascript:generateTciList(10094,135, 65,0)">';
mtxt += '<area shape="circle" coords="166, 65,12" href="javascript:generateTciList(10100,166, 65,0)">';
mtxt += '<area shape="circle" coords="197, 65,12" href="javascript:generateTciList(10106,197, 65,0)">';
mtxt += '<area shape="circle" coords="227, 65,12" href="javascript:generateTciList(10112,227, 65,0)">';
mtxt += '<area shape="circle" coords="257, 65,12" href="javascript:generateTciList(10118,257, 65,0)">';
mtxt += '<area shape="circle" coords="288, 65,12" href="javascript:generateTciList(10124,288, 65,0)">';
mtxt += '<area shape="circle" coords="319, 65,12" href="javascript:generateTciList(10130,319, 65,0)">';
mtxt += '<area shape="circle" coords="349, 65,12" href="javascript:generateTciList(10136,349, 65,0)">';
mtxt += '<area shape="circle" coords="379, 65,12" href="javascript:generateTciList(10142,379, 65,0)">';
mtxt += '<area shape="circle" coords="410, 95,12" href="javascript:generateTciList(16004,410, 95,0)">';
mtxt += '<area shape="circle" coords="440, 95,12" href="javascript:generateTciList(16010,440, 95,0)">';
mtxt += '<area shape="circle" coords="471, 95,12" href="javascript:generateTciList(16016,471, 95,0)">';
mtxt += '<area shape="circle" coords="502, 95,12" href="javascript:generateTciList(16022,502, 95,0)">';
mtxt += '<area shape="circle" coords="532, 95,12" href="javascript:generateTciList(16028,532, 95,0)">';
mtxt += '<area shape="circle" coords="562, 95,12" href="javascript:generateTciList(16034,562, 95,0)">';
mtxt += '<area shape="circle" coords="592, 95,12" href="javascript:generateTciList(16040,592, 95,0)">';
mtxt += '<area shape="circle" coords="624, 95,12" href="javascript:generateTciList(16046,624, 95,0)">';
mtxt += '<area shape="circle" coords="654, 95,12" href="javascript:generateTciList(16052,654, 95,0)">';
mtxt += '<area shape="circle" coords="684, 95,12" href="javascript:generateTciList(16058,684, 95,0)">';
mtxt += '<area shape="circle" coords="715, 95,12" href="javascript:generateTciList(16064,715, 95,0)">';
mtxt += '<area shape="circle" coords="746, 95,12" href="javascript:generateTciList(16070,746, 95,0)">';
mtxt += '<area shape="circle" coords=" 44, 95,12" href="javascript:generateTciList(16076, 44, 95,0)">';
mtxt += '<area shape="circle" coords=" 75, 95,12" href="javascript:generateTciList(16082, 75, 95,0)">';
mtxt += '<area shape="circle" coords="105, 95,12" href="javascript:generateTciList(16088,105, 95,0)">';
mtxt += '<area shape="circle" coords="135, 95,12" href="javascript:generateTciList(16094,135, 95,0)">';
mtxt += '<area shape="circle" coords="166, 95,12" href="javascript:generateTciList(16100,166, 95,0)">';
mtxt += '<area shape="circle" coords="197, 95,12" href="javascript:generateTciList(16106,197, 95,0)">';
mtxt += '<area shape="circle" coords="227, 95,12" href="javascript:generateTciList(16112,227, 95,0)">';
mtxt += '<area shape="circle" coords="257, 95,12" href="javascript:generateTciList(16118,257, 95,0)">';
mtxt += '<area shape="circle" coords="288, 95,12" href="javascript:generateTciList(16124,288, 95,0)">';
mtxt += '<area shape="circle" coords="319, 95,12" href="javascript:generateTciList(16130,319, 95,0)">';
mtxt += '<area shape="circle" coords="349, 95,12" href="javascript:generateTciList(16136,349, 95,0)">';
mtxt += '<area shape="circle" coords="379, 95,12" href="javascript:generateTciList(16142,379, 95,0)">';
mtxt += '<area shape="circle" coords="410,126,12" href="javascript:generateTciList(22004,410,126,0)">';
mtxt += '<area shape="circle" coords="440,126,12" href="javascript:generateTciList(22010,440,126,0)">';
mtxt += '<area shape="circle" coords="471,126,12" href="javascript:generateTciList(22016,471,126,0)">';
mtxt += '<area shape="circle" coords="502,126,12" href="javascript:generateTciList(22022,502,126,0)">';
mtxt += '<area shape="circle" coords="532,126,12" href="javascript:generateTciList(22028,532,126,0)">';
mtxt += '<area shape="circle" coords="562,126,12" href="javascript:generateTciList(22034,562,126,0)">';
mtxt += '<area shape="circle" coords="592,126,12" href="javascript:generateTciList(22040,592,126,0)">';
mtxt += '<area shape="circle" coords="624,126,12" href="javascript:generateTciList(22046,624,126,0)">';
mtxt += '<area shape="circle" coords="654,126,12" href="javascript:generateTciList(22052,654,126,0)">';
mtxt += '<area shape="circle" coords="684,126,12" href="javascript:generateTciList(22058,684,126,0)">';
mtxt += '<area shape="circle" coords="715,126,12" href="javascript:generateTciList(22064,715,126,0)">';
mtxt += '<area shape="circle" coords="746,126,12" href="javascript:generateTciList(22070,746,126,0)">';
mtxt += '<area shape="circle" coords=" 44,126,12" href="javascript:generateTciList(22076, 44,126,0)">';
mtxt += '<area shape="circle" coords=" 75,126,12" href="javascript:generateTciList(22082, 75,126,0)">';
mtxt += '<area shape="circle" coords="105,126,12" href="javascript:generateTciList(22088,105,126,0)">';
mtxt += '<area shape="circle" coords="135,126,12" href="javascript:generateTciList(22094,135,126,0)">';
mtxt += '<area shape="circle" coords="166,126,12" href="javascript:generateTciList(22100,166,126,0)">';
mtxt += '<area shape="circle" coords="197,126,12" href="javascript:generateTciList(22106,197,126,0)">';
mtxt += '<area shape="circle" coords="227,126,12" href="javascript:generateTciList(22112,227,126,0)">';
mtxt += '<area shape="circle" coords="257,126,12" href="javascript:generateTciList(22118,257,126,0)">';
mtxt += '<area shape="circle" coords="288,126,12" href="javascript:generateTciList(22124,288,126,0)">';
mtxt += '<area shape="circle" coords="319,126,12" href="javascript:generateTciList(22130,319,126,0)">';
mtxt += '<area shape="circle" coords="349,126,12" href="javascript:generateTciList(22136,349,126,0)">';
mtxt += '<area shape="circle" coords="379,126,12" href="javascript:generateTciList(22142,379,126,0)">';
mtxt += '<area shape="circle" coords="410,157,12" href="javascript:generateTciList(28004,410,157,0)">';
mtxt += '<area shape="circle" coords="440,157,12" href="javascript:generateTciList(28010,440,157,0)">';
mtxt += '<area shape="circle" coords="471,157,12" href="javascript:generateTciList(28016,471,157,0)">';
mtxt += '<area shape="circle" coords="502,157,12" href="javascript:generateTciList(28022,502,157,0)">';
mtxt += '<area shape="circle" coords="532,157,12" href="javascript:generateTciList(28028,532,157,0)">';
mtxt += '<area shape="circle" coords="562,157,12" href="javascript:generateTciList(28034,562,157,0)">';
mtxt += '<area shape="circle" coords="592,157,12" href="javascript:generateTciList(28040,592,157,0)">';
mtxt += '<area shape="circle" coords="624,157,12" href="javascript:generateTciList(28046,624,157,0)">';
mtxt += '<area shape="circle" coords="654,157,12" href="javascript:generateTciList(28052,654,157,0)">';
mtxt += '<area shape="circle" coords="684,157,12" href="javascript:generateTciList(28058,684,157,0)">';
mtxt += '<area shape="circle" coords="715,157,12" href="javascript:generateTciList(28064,715,157,0)">';
mtxt += '<area shape="circle" coords="746,157,12" href="javascript:generateTciList(28070,746,157,0)">';
mtxt += '<area shape="circle" coords=" 44,157,12" href="javascript:generateTciList(28076, 44,157,0)">';
mtxt += '<area shape="circle" coords=" 75,157,12" href="javascript:generateTciList(28082, 75,157,0)">';
mtxt += '<area shape="circle" coords="105,157,12" href="javascript:generateTciList(28088,105,157,0)">';
mtxt += '<area shape="circle" coords="135,157,12" href="javascript:generateTciList(28094,135,157,0)">';
mtxt += '<area shape="circle" coords="166,157,12" href="javascript:generateTciList(28100,166,157,0)">';
mtxt += '<area shape="circle" coords="197,157,12" href="javascript:generateTciList(28106,197,157,0)">';
mtxt += '<area shape="circle" coords="227,157,12" href="javascript:generateTciList(28112,227,157,0)">';
mtxt += '<area shape="circle" coords="257,157,12" href="javascript:generateTciList(28118,257,157,0)">';
mtxt += '<area shape="circle" coords="288,157,12" href="javascript:generateTciList(28124,288,157,0)">';
mtxt += '<area shape="circle" coords="319,157,12" href="javascript:generateTciList(28130,319,157,0)">';
mtxt += '<area shape="circle" coords="349,157,12" href="javascript:generateTciList(28136,349,157,0)">';
mtxt += '<area shape="circle" coords="379,157,12" href="javascript:generateTciList(28142,379,157,0)">';
mtxt += '<area shape="circle" coords="410,187,12" href="javascript:generateTciList(34004,410,187,0)">';
mtxt += '<area shape="circle" coords="440,187,12" href="javascript:generateTciList(34010,440,187,0)">';
mtxt += '<area shape="circle" coords="471,187,12" href="javascript:generateTciList(34016,471,187,0)">';
mtxt += '<area shape="circle" coords="502,187,12" href="javascript:generateTciList(34022,502,187,0)">';
mtxt += '<area shape="circle" coords="532,187,12" href="javascript:generateTciList(34028,532,187,0)">';
mtxt += '<area shape="circle" coords="562,187,12" href="javascript:generateTciList(34034,562,187,0)">';
mtxt += '<area shape="circle" coords="592,187,12" href="javascript:generateTciList(34040,592,187,0)">';
mtxt += '<area shape="circle" coords="624,187,12" href="javascript:generateTciList(34046,624,187,0)">';
mtxt += '<area shape="circle" coords="654,187,12" href="javascript:generateTciList(34052,654,187,0)">';
mtxt += '<area shape="circle" coords="684,187,12" href="javascript:generateTciList(34058,684,187,0)">';
mtxt += '<area shape="circle" coords="715,187,12" href="javascript:generateTciList(34064,715,187,0)">';
mtxt += '<area shape="circle" coords="746,187,12" href="javascript:generateTciList(34070,746,187,0)">';
mtxt += '<area shape="circle" coords=" 44,187,12" href="javascript:generateTciList(34076, 44,187,0)">';
mtxt += '<area shape="circle" coords=" 75,187,12" href="javascript:generateTciList(34082, 75,187,0)">';
mtxt += '<area shape="circle" coords="105,187,12" href="javascript:generateTciList(34088,105,187,0)">';
mtxt += '<area shape="circle" coords="135,187,12" href="javascript:generateTciList(34094,135,187,0)">';
mtxt += '<area shape="circle" coords="166,187,12" href="javascript:generateTciList(34100,166,187,0)">';
mtxt += '<area shape="circle" coords="197,187,12" href="javascript:generateTciList(34106,197,187,0)">';
mtxt += '<area shape="circle" coords="227,187,12" href="javascript:generateTciList(34112,227,187,0)">';
mtxt += '<area shape="circle" coords="257,187,12" href="javascript:generateTciList(34118,257,187,0)">';
mtxt += '<area shape="circle" coords="288,187,12" href="javascript:generateTciList(34124,288,187,0)">';
mtxt += '<area shape="circle" coords="319,187,12" href="javascript:generateTciList(34130,319,187,0)">';
mtxt += '<area shape="circle" coords="349,187,12" href="javascript:generateTciList(34136,349,187,0)">';
mtxt += '<area shape="circle" coords="379,187,12" href="javascript:generateTciList(34142,379,187,0)">';
mtxt += '<area shape="circle" coords="410,218,12" href="javascript:generateTciList(40004,410,218,0)">';
mtxt += '<area shape="circle" coords="440,218,12" href="javascript:generateTciList(40010,440,218,0)">';
mtxt += '<area shape="circle" coords="471,218,12" href="javascript:generateTciList(40016,471,218,0)">';
mtxt += '<area shape="circle" coords="502,218,12" href="javascript:generateTciList(40022,502,218,0)">';
mtxt += '<area shape="circle" coords="532,218,12" href="javascript:generateTciList(40028,532,218,0)">';
mtxt += '<area shape="circle" coords="562,218,12" href="javascript:generateTciList(40034,562,218,0)">';
mtxt += '<area shape="circle" coords="592,218,12" href="javascript:generateTciList(40040,592,218,0)">';
mtxt += '<area shape="circle" coords="624,218,12" href="javascript:generateTciList(40046,624,218,0)">';
mtxt += '<area shape="circle" coords="654,218,12" href="javascript:generateTciList(40052,654,218,0)">';
mtxt += '<area shape="circle" coords="684,218,12" href="javascript:generateTciList(40058,684,218,0)">';
mtxt += '<area shape="circle" coords="715,218,12" href="javascript:generateTciList(40064,715,218,0)">';
mtxt += '<area shape="circle" coords="746,218,12" href="javascript:generateTciList(40070,746,218,0)">';
mtxt += '<area shape="circle" coords=" 44,218,12" href="javascript:generateTciList(40076, 44,218,0)">';
mtxt += '<area shape="circle" coords=" 75,218,12" href="javascript:generateTciList(40082, 75,218,0)">';
mtxt += '<area shape="circle" coords="105,218,12" href="javascript:generateTciList(40088,105,218,0)">';
mtxt += '<area shape="circle" coords="135,218,12" href="javascript:generateTciList(40094,135,218,0)">';
mtxt += '<area shape="circle" coords="166,218,12" href="javascript:generateTciList(40100,166,218,0)">';
mtxt += '<area shape="circle" coords="197,218,12" href="javascript:generateTciList(40106,197,218,0)">';
mtxt += '<area shape="circle" coords="227,218,12" href="javascript:generateTciList(40112,227,218,0)">';
mtxt += '<area shape="circle" coords="257,218,12" href="javascript:generateTciList(40118,257,218,0)">';
mtxt += '<area shape="circle" coords="288,218,12" href="javascript:generateTciList(40124,288,218,0)">';
mtxt += '<area shape="circle" coords="319,218,12" href="javascript:generateTciList(40130,319,218,0)">';
mtxt += '<area shape="circle" coords="349,218,12" href="javascript:generateTciList(40136,349,218,0)">';
mtxt += '<area shape="circle" coords="379,218,12" href="javascript:generateTciList(40142,379,218,0)">';
mtxt += '<area shape="circle" coords="410,249,12" href="javascript:generateTciList(46004,410,249,0)">';
mtxt += '<area shape="circle" coords="440,249,12" href="javascript:generateTciList(46010,440,249,0)">';
mtxt += '<area shape="circle" coords="471,249,12" href="javascript:generateTciList(46016,471,249,0)">';
mtxt += '<area shape="circle" coords="502,249,12" href="javascript:generateTciList(46022,502,249,0)">';
mtxt += '<area shape="circle" coords="532,249,12" href="javascript:generateTciList(46028,532,249,0)">';
mtxt += '<area shape="circle" coords="562,249,12" href="javascript:generateTciList(46034,562,249,0)">';
mtxt += '<area shape="circle" coords="592,249,12" href="javascript:generateTciList(46040,592,249,0)">';
mtxt += '<area shape="circle" coords="624,249,12" href="javascript:generateTciList(46046,624,249,0)">';
mtxt += '<area shape="circle" coords="654,249,12" href="javascript:generateTciList(46052,654,249,0)">';
mtxt += '<area shape="circle" coords="684,249,12" href="javascript:generateTciList(46058,684,249,0)">';
mtxt += '<area shape="circle" coords="715,249,12" href="javascript:generateTciList(46064,715,249,0)">';
mtxt += '<area shape="circle" coords="746,249,12" href="javascript:generateTciList(46070,746,249,0)">';
mtxt += '<area shape="circle" coords=" 44,249,12" href="javascript:generateTciList(46076, 44,249,0)">';
mtxt += '<area shape="circle" coords=" 75,249,12" href="javascript:generateTciList(46082, 75,249,0)">';
mtxt += '<area shape="circle" coords="105,249,12" href="javascript:generateTciList(46088,105,249,0)">';
mtxt += '<area shape="circle" coords="135,249,12" href="javascript:generateTciList(46094,135,249,0)">';
mtxt += '<area shape="circle" coords="166,249,12" href="javascript:generateTciList(46100,166,249,0)">';
mtxt += '<area shape="circle" coords="197,249,12" href="javascript:generateTciList(46106,197,249,0)">';
mtxt += '<area shape="circle" coords="227,249,12" href="javascript:generateTciList(46112,227,249,0)">';
mtxt += '<area shape="circle" coords="257,249,12" href="javascript:generateTciList(46118,257,249,0)">';
mtxt += '<area shape="circle" coords="288,249,12" href="javascript:generateTciList(46124,288,249,0)">';
mtxt += '<area shape="circle" coords="319,249,12" href="javascript:generateTciList(46130,319,249,0)">';
mtxt += '<area shape="circle" coords="349,249,12" href="javascript:generateTciList(46136,349,249,0)">';
mtxt += '<area shape="circle" coords="379,249,12" href="javascript:generateTciList(46142,379,249,0)">';
mtxt += '<area shape="circle" coords="410,279,12" href="javascript:generateTciList(52004,410,279,0)">';
mtxt += '<area shape="circle" coords="440,279,12" href="javascript:generateTciList(52010,440,279,0)">';
mtxt += '<area shape="circle" coords="471,279,12" href="javascript:generateTciList(52016,471,279,0)">';
mtxt += '<area shape="circle" coords="502,279,12" href="javascript:generateTciList(52022,502,279,0)">';
mtxt += '<area shape="circle" coords="532,279,12" href="javascript:generateTciList(52028,532,279,0)">';
mtxt += '<area shape="circle" coords="562,279,12" href="javascript:generateTciList(52034,562,279,0)">';
mtxt += '<area shape="circle" coords="592,279,12" href="javascript:generateTciList(52040,592,279,0)">';
mtxt += '<area shape="circle" coords="624,279,12" href="javascript:generateTciList(52046,624,279,0)">';
mtxt += '<area shape="circle" coords="654,279,12" href="javascript:generateTciList(52052,654,279,0)">';
mtxt += '<area shape="circle" coords="684,279,12" href="javascript:generateTciList(52058,684,279,0)">';
mtxt += '<area shape="circle" coords="715,279,12" href="javascript:generateTciList(52064,715,279,0)">';
mtxt += '<area shape="circle" coords="746,279,12" href="javascript:generateTciList(52070,746,279,0)">';
mtxt += '<area shape="circle" coords=" 44,279,12" href="javascript:generateTciList(52076, 44,279,0)">';
mtxt += '<area shape="circle" coords=" 75,279,12" href="javascript:generateTciList(52082, 75,279,0)">';
mtxt += '<area shape="circle" coords="105,279,12" href="javascript:generateTciList(52088,105,279,0)">';
mtxt += '<area shape="circle" coords="135,279,12" href="javascript:generateTciList(52094,135,279,0)">';
mtxt += '<area shape="circle" coords="166,279,12" href="javascript:generateTciList(52100,166,279,0)">';
mtxt += '<area shape="circle" coords="197,279,12" href="javascript:generateTciList(52106,197,279,0)">';
mtxt += '<area shape="circle" coords="227,279,12" href="javascript:generateTciList(52112,227,279,0)">';
mtxt += '<area shape="circle" coords="257,279,12" href="javascript:generateTciList(52118,257,279,0)">';
mtxt += '<area shape="circle" coords="288,279,12" href="javascript:generateTciList(52124,288,279,0)">';
mtxt += '<area shape="circle" coords="319,279,12" href="javascript:generateTciList(52130,319,279,0)">';
mtxt += '<area shape="circle" coords="349,279,12" href="javascript:generateTciList(52136,349,279,0)">';
mtxt += '<area shape="circle" coords="379,279,12" href="javascript:generateTciList(52142,379,279,0)">';
mtxt += '<area shape="circle" coords="410,310,12" href="javascript:generateTciList(58004,410,310,0)">';
mtxt += '<area shape="circle" coords="440,310,12" href="javascript:generateTciList(58010,440,310,0)">';
mtxt += '<area shape="circle" coords="471,310,12" href="javascript:generateTciList(58016,471,310,0)">';
mtxt += '<area shape="circle" coords="502,310,12" href="javascript:generateTciList(58022,502,310,0)">';
mtxt += '<area shape="circle" coords="532,310,12" href="javascript:generateTciList(58028,532,310,0)">';
mtxt += '<area shape="circle" coords="562,310,12" href="javascript:generateTciList(58034,562,310,0)">';
mtxt += '<area shape="circle" coords="592,310,12" href="javascript:generateTciList(58040,592,310,0)">';
mtxt += '<area shape="circle" coords="624,310,12" href="javascript:generateTciList(58046,624,310,0)">';
mtxt += '<area shape="circle" coords="654,310,12" href="javascript:generateTciList(58052,654,310,0)">';
mtxt += '<area shape="circle" coords="684,310,12" href="javascript:generateTciList(58058,684,310,0)">';
mtxt += '<area shape="circle" coords="715,310,12" href="javascript:generateTciList(58064,715,310,0)">';
mtxt += '<area shape="circle" coords="746,310,12" href="javascript:generateTciList(58070,746,310,0)">';
mtxt += '<area shape="circle" coords=" 44,310,12" href="javascript:generateTciList(58076, 44,310,0)">';
mtxt += '<area shape="circle" coords=" 75,310,12" href="javascript:generateTciList(58082, 75,310,0)">';
mtxt += '<area shape="circle" coords="105,310,12" href="javascript:generateTciList(58088,105,310,0)">';
mtxt += '<area shape="circle" coords="135,310,12" href="javascript:generateTciList(58094,135,310,0)">';
mtxt += '<area shape="circle" coords="166,310,12" href="javascript:generateTciList(58100,166,310,0)">';
mtxt += '<area shape="circle" coords="197,310,12" href="javascript:generateTciList(58106,197,310,0)">';
mtxt += '<area shape="circle" coords="227,310,12" href="javascript:generateTciList(58112,227,310,0)">';
mtxt += '<area shape="circle" coords="257,310,12" href="javascript:generateTciList(58118,257,310,0)">';
mtxt += '<area shape="circle" coords="288,310,12" href="javascript:generateTciList(58124,288,310,0)">';
mtxt += '<area shape="circle" coords="319,310,12" href="javascript:generateTciList(58130,319,310,0)">';
mtxt += '<area shape="circle" coords="349,310,12" href="javascript:generateTciList(58136,349,310,0)">';
mtxt += '<area shape="circle" coords="379,310,12" href="javascript:generateTciList(58142,379,310,0)">';
mtxt += '<area shape="circle" coords="410,341,12" href="javascript:generateTciList(64004,410,341,0)">';
mtxt += '<area shape="circle" coords="440,341,12" href="javascript:generateTciList(64010,440,341,0)">';
mtxt += '<area shape="circle" coords="471,341,12" href="javascript:generateTciList(64016,471,341,0)">';
mtxt += '<area shape="circle" coords="502,341,12" href="javascript:generateTciList(64022,502,341,0)">';
mtxt += '<area shape="circle" coords="532,341,12" href="javascript:generateTciList(64028,532,341,0)">';
mtxt += '<area shape="circle" coords="562,341,12" href="javascript:generateTciList(64034,562,341,0)">';
mtxt += '<area shape="circle" coords="592,341,12" href="javascript:generateTciList(64040,592,341,0)">';
mtxt += '<area shape="circle" coords="624,341,12" href="javascript:generateTciList(64046,624,341,0)">';
mtxt += '<area shape="circle" coords="654,341,12" href="javascript:generateTciList(64052,654,341,0)">';
mtxt += '<area shape="circle" coords="684,341,12" href="javascript:generateTciList(64058,684,341,0)">';
mtxt += '<area shape="circle" coords="715,341,12" href="javascript:generateTciList(64064,715,341,0)">';
mtxt += '<area shape="circle" coords="746,341,12" href="javascript:generateTciList(64070,746,341,0)">';
mtxt += '<area shape="circle" coords=" 44,341,12" href="javascript:generateTciList(64076, 44,341,0)">';
mtxt += '<area shape="circle" coords=" 75,341,12" href="javascript:generateTciList(64082, 75,341,0)">';
mtxt += '<area shape="circle" coords="105,341,12" href="javascript:generateTciList(64088,105,341,0)">';
mtxt += '<area shape="circle" coords="135,341,12" href="javascript:generateTciList(64094,135,341,0)">';
mtxt += '<area shape="circle" coords="166,341,12" href="javascript:generateTciList(64100,166,341,0)">';
mtxt += '<area shape="circle" coords="197,341,12" href="javascript:generateTciList(64106,197,341,0)">';
mtxt += '<area shape="circle" coords="227,341,12" href="javascript:generateTciList(64112,227,341,0)">';
mtxt += '<area shape="circle" coords="257,341,12" href="javascript:generateTciList(64118,257,341,0)">';
mtxt += '<area shape="circle" coords="288,341,12" href="javascript:generateTciList(64124,288,341,0)">';
mtxt += '<area shape="circle" coords="319,341,12" href="javascript:generateTciList(64130,319,341,0)">';
mtxt += '<area shape="circle" coords="349,341,12" href="javascript:generateTciList(64136,349,341,0)">';
mtxt += '<area shape="circle" coords="379,341,12" href="javascript:generateTciList(64142,379,341,0)">';
mtxt += '</map></td></tr></table>';
dmap.innerHTML = mtxt;
var node = document.getElementById("div_ovrlay");
node.appendChild(dmap);
idisp_tciList=1;             // set exists flag
//-------------------------------------------------------------------
// if a comp-grid node is displayed, generate the associated TCI list
//--------------------------------------------------------------------
//alert('cnodeID='+cnodeID+' cicoord='+cicoord+' cjcoord='+cjcoord);
	if(igrid_locator==1) {
	generateTciList(cnodeID,cicoord,cjcoord,0)
	}
	document.getElementById("disp_tciGmapB").style.display="none";// the showB
	document.getElementById("disp_detachGMB").style.display="block";// the detachB
	document.getElementById("hide_tciGmapB").style.display="block";// the hideB
//	removeDiv(icomp_mssg2,"comp_mssg2") 
//	icomp_mssg2==0;
//--------------------------------------------------------------------
// if the region focus is enabled, hide all related divs
//--------------------------------------------------------------------
	hideRegion()
	hideOvrlay()
} // end function
////////////  FUNCTION createtciGmapB()  ///////////////////////////////////////////////
//	(1) create the select, hide and detach TCI grid map buttons
/////////////////////////////////////////////////////////////////////////////////////
/////////// create the select, hide and detach TCI grid map buttons ///////////////
function createtciGmapB() {
//alert('enter createDetachB, theMapFile='+theMapFile);
	if(idisp_tciGmapB==0) {
	var dvdet= document.createElement('div'); 
	var divIdName = "disp_tciGmapB"; 
	dvdet.setAttribute('id',divIdName); 
	dvdet.style.color = "#116457"; 
	dvdet.style.left = "430px"; 
	dvdet.style.top = "420px"; 
	dvdet.style.position = "absolute"; 
	dtxt = '<div><input type="button" onClick="showtciGmap(';
	dtxt +=');" value="Show TCI Grid Map"/></div>';
	dvdet.innerHTML = dtxt;
	var node = document.getElementById("div_ovrlay");
	node.appendChild(dvdet);
	idisp_tciGmapB=1;
// the hide button
	var dvdet= document.createElement('div'); 
	var divIdName = "hide_tciGmapB"; 
	dvdet.setAttribute('id',divIdName); 
	dvdet.style.color = "#116457"; 
	dvdet.style.left = "433px"; 
	dvdet.style.top = "420px"; 
	dvdet.style.position = "absolute"; 
	dtxt = '<div><input type="button" onClick="hidetciGmap(';
	dtxt +=');" value="Hide TCI Grid Map"/></div>';
	dvdet.innerHTML = dtxt;
	var node = document.getElementById("div_ovrlay");
	node.appendChild(dvdet);
	idisp_hideGMB=1;
// the detach button
	var dvdet= document.createElement('div'); 
	var divIdName = "disp_detachGMB"; 
	dvdet.setAttribute('id',divIdName); 
	dvdet.style.color = "#116457"; 
	dvdet.style.left = "550px"; 
	dvdet.style.top = "420px"; 
	dvdet.style.position = "absolute"; 
	dtxt = '<div><input type="button" onClick="accessRemTci()"';
	dtxt += ' value="Detach TCI Grid Map"/></div>';
	dvdet.innerHTML = dtxt;
	var node = document.getElementById("div_ovrlay");
	node.appendChild(dvdet);
	idisp_detachGMB=1;
// 
	document.getElementById("hide_tciGmapB").style.display="none";
	}
}
//////////////////////////// create and hide TCI grid map button ///////////////

function hidetciGmap() {
//alert('enter hidetciGmap(): icomp_mssg2='+icomp_mssg2+' igrid_locator='+igrid_locator);
	if(idisp_tciList==1) {
	document.getElementById("disp_tciGmapB").style.display="block";
	document.getElementById("disp_detachGMB").style.display="none";
	document.getElementById("disp_tciList").style.display="none";
	document.getElementById("hide_tciGmapB").style.display="none";
	if (icomp_mssg2==1) {
	document.getElementById('comp_mssg2').style.display="none";
	}
//alert('enter igrid_locator='+igrid_locator);
	if (igrid_locator==1) {
	document.getElementById('grid_locator').style.display="none";
	document.getElementById('disp_sigtcis').style.display="none";
	}
	if (idisp_focusregion==1) {
	document.getElementById("disp_focusregion").style.display="block"; 
	document.getElementById("disp_mbrtol").style.display="block"; 
	document.getElementById("disp_crank").style.display="block"; 
	document.getElementById("disp_cyears").style.display="block"; 
	}
	}
}

///////////////////////////  generateTciList(nodeID,icoord,jcoord,iflg) ///////////////
//	This function is accessed when clicking on a 15 x 15 deg grid. It reads the
//	list of TCIs available for highly (sig-1) and moderately (isig=2) 
//	significan composites. NOTE iflg-1 acts on remote TCImap
///////////////////////////////////////////////////////////////////////////////////
function generateTciList(nodeID,icoord,jcoord,iflg) {
//alert('generateTciList: nodeID='+nodeID+' icoord='+icoord+' jcoord='+jcoord);

////   save the input parameters into global variables
	if(iflg==0) {
	cnodeID=nodeID;
	cicoord=icoord;
	cjcoord=jcoord;
	} else {
	rnodeID=nodeID;
	ricoord=icoord;
	rjcoord=jcoord;
	}
//alert('enter generateTciList: nodeID='+nodeID+' icoord'+icoord+' jcoord='+jcoord+' iflg='+iflg); 
accessNodeSigs(nodeID,iflg)
//alert('sig1 nodes='+tcisig1);
//alert('sig2 nodes='+tcisig2);
// needed global variables for file access
	if(iflg==0) {
	var tcimnth=theaDate.substring(4,6);
	var filed = 'dated/'+theaDate+'/figs-comp1';
	var filem = thecvar+'-'+tcimnth;
	removeDiv(idisp_sigtcis,"disp_sigtcis") 
	idisp_sigtcis=0;
	removeDiv(igrid_locator,"grid_locator") 
	igrid_locator=0;
	} else {
	var filed = '../figs-comp1';
	var filem = rmtcvar+'-'+rthemnth;
//alert('generateTciList(1): irdisp_sigtcis='+irdisp_sigtcis+' irgrid_locator='+irgrid_locator); 
//alert('generateTciList: remove divs: irgrid_locator='+irgrid_locator);
	removeDiv(igrid_locator,"grid_locator") 
	igrid_locator=0;
//alert('generateTciList: remove divs: irdisp_sigtcis='+irdisp_sigtcis);
	removeDiv(idisp_sigtcis,"disp_sigtcis") 
	idisp_sigtcis=0;
	}
//alert('filem='+filem);
// destroy old idisp_sigtcis
//	removeDiv(idisp_sigtcis,"disp_sigtcis") 
//	idisp_sigtcis=0;

//alert('generateTciList;produce the listings of tsci');
// produce the listings of tsci
	if(iflg==1 && rnodeID=="") return;
	var dvsel= document.createElement('div'); 
	var divIdName = "disp_sigtcis"; 
	dvsel.setAttribute('ID',divIdName); 
	dvsel.style.color = "#116457"; 
	dvsel.style.left = "10px"; 
	dvsel.style.top = "0px"; 
	dvsel.style.position = "absolute"; 
	var thehgt=Math.ceil(12*tcisig1.length);
	var divtxt = '<p align="center"><font size=2><b>Teleconnection Indices are<br />';
	divtxt +=        'selected on the basis of their<br />';
	divtxt +=        'signatures and the anomaly<br />';
	divtxt +=        'strengths in the selected<br />';
	divtxt +=        'region (click TCIs for<br />';
	divtxt +=        'signatures). Two tolerance<br />';
	divtxt +=        'levels are considered:<br /></b></b></font></p>';
	divtxt += '<table border="1" cellpadding="0" bgcolor="#FFFFFF"';
	divtxt += ' style="width: 160;">';
	divtxt += '<th width="80">Loose</th><th width="80">Tight</th>';
	if(tcisig1.length==0 && tcisig2.length==0) {
	divtxt += '<tr><td colspan=2 width="160" align="center">';
	divtxt += '<b>No Composites Generated<br \>for this Focus Region';
	divtxt += '</b></td></tr>';
	}
	if(tcisig1.length>0 && tcisig2.length>=0) {
	for(i=0;i<=tcisig1.length-1;i++) {
//	if both entries are available
	if(i<=tcisig2.length-1) {
		divtxt += '<tr><td width="80" align="center">';
		divtxt += '<a href="javascript:openSideWindow(';
		divtxt += "'"+filed+"/"+tcisig1[i]+"-"+filem+"-25p.jpg";
		divtxt += "','rm0t"+tcisig1[i]+"',766,400,0)";
		divtxt += '"><font size=2>'+tcisig1[i]+'</font></a></td>';
		divtxt += '<td width="80" align="center">';
		divtxt += '<a href="javascript:openSideWindow(';
		divtxt += "'"+filed+"/"+tcisig2[i]+"-"+filem+"-10p.jpg";
		divtxt += "','rm0t"+tcisig2[i]+"',766,400,0)";
		divtxt += '"><font size=2>'+tcisig2[i]+'</font></a></td>';
		divtxt += '</tr>';
		} else {
//	if one entry is available
		divtxt += '<tr><td width="80" align="center">';
		divtxt += '<a href="javascript:openSideWindow(';
		divtxt += "'"+filed+"/"+tcisig1[i]+"-"+filem+"-25p.jpg";
		divtxt += "','rm0t"+tcisig1[i]+"',766,400,0)";
		divtxt += '"><font size=2>'+tcisig1[i]+'</font></a></td>';
		divtxt += '<td width="80" align="center"></td>';
		divtxt += '</tr>';
		}
	} //i loop
	divtxt += '</table>';
	} tcisig1.length>0
	dvsel.innerHTML = divtxt;
	if(iflg==0) {
	var node = document.getElementById("sel_accS");
	ipos=0.997*Math.round(cicoord)-11;
	jpos=0.99*Math.round(cjcoord)-6;
	} else {
	var node = document.getElementById("sel_raccS");
	ipos=0.999*Math.round(ricoord)-16;
	jpos=1.0*Math.round(rjcoord)-16;
	}
	node.appendChild(dvsel);
	idisp_sigtcis=1;

// Now, add the  grid locator
//alert('icoord='+icoord+' jcoord='+jcoord);
	var dvsel= document.createElement('div'); 
	var divIdName = "grid_locator"; 
	dvsel.setAttribute('ID',divIdName); 
	dvsel.style.position = "absolute"; 
	dvsel.style.top = jpos+"px";
	dvsel.style.left = ipos+"px";
	dvsel.style.zIndex = 180;
	dtxt = '<img src="images/focus_u.png" width "34" height="34"/>';
	dvsel.innerHTML = dtxt;
	if(iflg==1) {
	var node = document.getElementById("remote_gmap");
	} else {
	var node = document.getElementById("div_ovrlay");
	}
	node.appendChild(dvsel);
	igrid_locator=1;
	

} // end generateTciList


