// dispPanels: this set of functions regulates the major panels
// of the page display and displays appropriate information
// (1) initialize() initialized the display with latest anomaly plot
// (2) getCriteria() determines what information to display
////// //////////////////////////////////////////////////////////////////
//////    function initialize() /////////////////////////////////////////
////// //////////////////////////////////////////////////////////////////
function initialize() {  // creates <div>s disp_aDate,disp_cvar,disp_field
//// This function generates the forms needed to display items in the 'selection',
// 'display criiteria' and 'Teleconnection Indices' boxes.
//=========================
//   Selections
//=========================
// create disp_aDate div
//-----------------------------
//	window.location.reload(true);
	accessCfile("list_aDates.txt");         // read list of available dates
	var dvadate= document.createElement('div'); 
	var divIdName = "disp_aDate"; 
	dvadate.setAttribute('id',divIdName); 
	dvadate.style.color = "#116457"; 
	dvadate.style.left = "775px"; 
	dvadate.style.top = "19px"; 
	dvadate.style.position = "absolute"; 
	divtxt = '<form name="aDate_form">';
	divtxt += 'Analysis Date&nbsp<select name="selectaDate" size=1 ';
	divtxt += 'onChange="getCriteria(0)">';
//alert('aDates.length='+aDates.length);
	for(i=1;i<=aDates.length;i++) {
	if(i==aDates.length) {
	divtxt += '<option value="'+aDates[i-1]+'" selected>'+aDatesL[i-1]+'</option>';
	} else {
	divtxt += '<option value="'+aDates[i-1]+'">'+aDatesL[i-1]+'</option>';
	}
	}
	divtxt += '</select>';
	divtxt += '<a href="javascript:openSideWindow(';
	divtxt += "'help/adates.html','rmtHTL',";
	divtxt += '600,175,0)">';
	divtxt += '<img src="images/info-button.png"></a>';
	divtxt += '</form>';
	dvadate.innerHTML = divtxt;
	var node = document.getElementById("sel_aDate");
	node.appendChild(dvadate);
//-----------------------------
// create disp_field div (Analysis Type)
//-----------------------------
//fields initialize
//	fields = ["anomaly","correlation","composite:t","TCIimpacts"];  
	if(mmflag == "mm") {
		fields = ["anomaly","correlation","composite:t","composite:s","TCIimpacts","analog_yrs","timeSeries"];  
		} else {
		fields = ["anomaly","correlation","composite:t","composite:s","composite:r","TCIimpacts","analog_yrs","timeSeries"];  
//		fields = ["anomaly","correlation","composite:t","composite:s","TCIimpacts","analog_yrs"];  
		}
	var dvfield= document.createElement('div'); 
	var divIdName = "disp_field"; 
	dvfield.setAttribute('id',divIdName); 
	dvfield.style.color = "#116457"; 
	dvfield.style.left = "767px"; 
	dvfield.style.top = "39px"; 
	dvfield.style.position = "absolute"; 
	dvfield.style.display = "none"; 
	divtxt = '<form name="field_form">';
	divtxt += '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Analysis Only<select name="selectfield" size=1 ';
	divtxt += 'onChange="getCriteria(0)">';
//alert('cvars.length='+fields.length);
	divtxt += '<option value="'+fields[0]+'" selected>'+fields[0]+'</option>';
	thefield=fields[0];
	divtxt += '</select>';
	divtxt += '</form>';
	dvfield.innerHTML = divtxt;
	var node = document.getElementById("sel_field");
	node.appendChild(dvfield);
//-----------------------------
// create disp_cvar div
//-----------------------------
	accessDfile("list-cvar.txt");         // read list of available cvars

	var dvcvar= document.createElement('div'); 
	var divIdName = "disp_cvar"; 
	dvcvar.setAttribute('id',divIdName); 
	dvcvar.style.color = "#116457"; 
	dvcvar.style.left = "765px"; 
	dvcvar.style.top = "39px"; 
	dvcvar.style.position = "absolute"; 
	divtxt = '<form name="cvar_form">';
	divtxt += '&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbspWeather Variable&nbsp'
	divtxt += '<a href="javascript:openSideWindow(';
	divtxt += "'help/cvars.html','rmtHTL',";
	divtxt += '600,300,0)">';
	divtxt += '<img src="images/info-button.png"><br /></a>';
	divtxt += '<select name="selectcvar" size=1 ';
	divtxt += 'onChange="dispMap(1)">';
//alert('cvars.length='+cvars.length);
	for(i=1;i<=cvars.length;i++) {
	if(i==1) {
	divtxt += '<option value="'+cvars[i-1]+'" selected>'
	divtxt += '500 hPa geopotential height: '+cvars[i-1]+'</option>';
	oldcvar=cvars[i-1];
	} 
	if(i==2) {
	divtxt += '<option value="'+cvars[i-1]+'">850 hPa temperature: '+cvars[i-1]+'</option>';
	}
	if(i==3) {
	divtxt += '<option value="'+cvars[i-1]+'">Relative humidity at 2 meters: '+cvars[i-1]+'</option>';
	}
	if(i==4) {
	divtxt += '<option value="'+cvars[i-1]+'">Sea-level temperature (deg F): '+cvars[i-1]+'</option>';
	}
	if(i==5) {
	divtxt += '<option value="'+cvars[i-1]+'">Daily precipitation total (in/d): '+cvars[i-1]+'</option>';
	}
	if(i==6) {
	divtxt += '<option value="'+cvars[i-1]+'">Mean sea-level pressure (mb): '+cvars[i-1]+'</option>';
	}
	if(i==7) {
	divtxt += '<option value="'+cvars[i-1]+'">Water-equivalent snow depth: '+cvars[i-1]+'</option>';
	}
	if(i==8) {
	divtxt += '<option value="'+cvars[i-1]+'">Atlantic Basin hurricane activity: '+cvars[i-1]+'</option>';
	}
	if(i==9) {
	divtxt += '<option value="'+cvars[i-1]+'">African ITCZ (see info): '+cvars[i-1]+'</option>';
	}
	}
	divtxt += '</select>';
	divtxt += '</form></div>';
	dvcvar.innerHTML = divtxt;
	var node = document.getElementById("sel_cvar");
	node.appendChild(dvcvar);
//-----------------------------------------------------------------------
// generate info to display
//-----------------------------------------------------------------------
	getCriteria(0)
//alert('leave initialize()');
} // initialize

////// //////////////////////////////////////////////////////////////////
//////    function getcriteria(iflg) /////////////////////////////////////////
////// //////////////////////////////////////////////////////////////////
//	function criteria -- determines what to display 
// 	if iflg=0, initialize display (fill globals theaDate,thecvar,thefield

function getCriteria(iflg) {
	var ind = document.forms['field_form'].selectfield.selectedIndex;
	thefield = fields[ind];
//alert('thecvar='+thecvar+' oldcvar='+oldcvar+' thefield='+thefield);
// until all debugging has been finalized, produce an alert recommending refresk
	if(oldcvar=='atlh' || thecvar=='atlh') {
	if(thefield=='TCIimpacts'||thefield=='composite:s'||thefield=='composite:r') {
	alert('Variable atlh is not available for selected tool. Please REFRESH the browser and select another weather variable');
	return;
	}
	}
	if(oldcvar=='itcz' || thecvar=='itcz') {
	if(thefield=='TCIimpacts'||thefield=='composite:t'||thefield=='composite:s'||thefield=='composite:r'
		||thefield=='correlation'||thefield=='analog_yrs'||thefield=='timeSeries') {
	alert('Variable itcz is not available for selected tool. Please REFRESH the browser and select another weather variable');
	return;
	}
	}

// remove the comps imap javascript, if created
//alert('idisp_map='+idisp_map);
	removeDiv(idisp_map,"disp_map") 
	idisp_map=0;
//alert('enter getCriteria('+iflg+') idisp_Lookback='+idisp_Lookback);
	theLinkmnth=theaMnth;  // reset TCI link month
var ind = document.forms['aDate_form'].selectaDate.selectedIndex;
	theaDate = aDates[ind];
	theaMnth = theaDate.substring(4,6);
	theaYear = theaDate.substring(0,4);
//alert('theaMnth:'+theaMnth+' theaYear='+theaYear);
	oldaDate = aDates[ind];
var ind = document.forms['cvar_form'].selectcvar.selectedIndex;
	thecvar = cvars[ind];
	oldcvar = cvars[ind];
//	var ind = document.forms['field_form'].selectfield.selectedIndex;
//	thefield = fields[ind];
	if(iflg==0) {                // set selected year and month
	lastyr = theaDate.substring(0,4);
	lastmo = theaDate.substring(4,6);
//alert(' in getCriteria with iflg='+iflg+' reset compID');
//	compID = "";
//	compIDy = "";
//alert('getCriteria: theaDate='+theaDate+' thecvar='+thecvar+' thefield='+thefield);
}
//alert('getCriteria: thefield='+thefield);
//===================================================
//////////////// anomaly //////////////////////////// 
//===================================================
if(thefield == "anomaly") {
//	document.getElementById("tutorial").style.display="block";
	removeDiv(ineeda_region,"needa_region") 
	ineeda_region=0;

//////eliminate divs associated with previous anomaly
// display criteria
	removeDiv(idisp_mnth,"disp_mnth")
	idisp_mnth=0; 
	removeDiv(idisp_mnth,"disp_mnth")
	idisp_mnth=0; 
// teleconnection forms
//alert('anomaly: removing disp_tcis');
	removeDiv(idisp_tcis,"disp_tcis") 
	idisp_tcis=0;
// the region focus buttons
	removeDiv(idisp_nodeenable,"disp_enablenode")
	idisp_nodeenable=0;

//////eliminate divs associated with correlations
//alert('eliminate disp_Lookback: idisp_Lookback='+idisp_Lookback);
	removeDiv(idisp_Lookback,"disp_Lookback")
	idisp_Lookback=0; 
	removeDiv(idisp_Lead,"disp_Lead") 
	idisp_Lead=0;
	removeDiv(idisp_corrtcis,"disp_corrtcis")
	idisp_corrtcis=0;
	removeDiv(icorr_mssg,"corr_mssg")
	icorr_mssg=0;


//////eliminate divs associated with composite:e
	removeDiv(idisp_tciList,"disp_tciList")
	idisp_tciList=0; 
	removeDiv(idisp_sigtcis,"disp_sigtcis")
	idisp_sigtcis=0; 
	removeDiv(idisp_mbrtol,"disp_mbrtol") 
	idisp_mbrtol=0;
	removeDiv(idisp_crank,"disp_crank") 
	idisp_crank=0;
	removeDiv(idisp_cyears,"disp_cyears")
	idisp_cyears=0; 
	removeDiv(idisp_comptcis,"disp_comptcis") 
	idisp_comptcis=0;
	removeDiv(idisp_tcis,"disp_tcis") 
	idisp_tcis=0;

// eliminate the sigificance info, if displayed
	removeDiv(idisp_nodeID,"disp_nodeID")
	idisp_nodeID=0; 

/////////eliminate divs associated with composite:t
	removeDiv(idisp_analogSig,"disp_analogSig") 
	idisp_analogSig=0;
	removeDiv(idisp_compttcis,"disp_compttcis")
	disp_compttcis=0; 
	removeDiv(irestore_compt,"restore_compt")
	irestore_compt=0; 
	removeDiv(idisp_quantlist,"disp_quantlist")
	idisp_quantlist=0; 
	removeDiv(idisp_ctyears,"disp_ctyears")
	idisp_ctyears=0; 
	removeDiv(idisp_ctleads,"disp_ctleads")
	idisp_ctleads=0; 
	removeDiv(idisp_leadtcis,"disp_leadtcis")
	idisp_leadtcis=0; 
	removeDiv(ilinked_tcis,"linked_tcis")
	ilinked_tcis=0; 
	removeDiv(icompt_mssg,"compt_mssg")
	icompt_mssg=0;

/////////eliminate divs associated with composite:s
	removeDiv(idisp_csigChkBxa,"disp_csigChkBxa") 
	idisp_csigChkBxa=0;
	removeDiv(idisp_csigChkBxo,"disp_csigChkBxo") 
	idisp_csigChkBxo=0;
	removeDiv(idisp_compstcis,"disp_compstcis")
	idisp_compstcis=0; 
	removeDiv(idisp_newregion,"disp_newregion") 
	idisp_newregion=0;
	removeDiv(idisp_newpoint,"disp_newpoint") 
	idisp_newpoint=0;

/////////eliminate divs associated with composite:r
	removeDiv(idisp_subreg_map,"disp_subreg_map")
	idisp_subreg_map=0;
	removeDiv(idisp_regsize,"disp_regsize")
	idisp_regsize=0;
	removeDiv(idisp_newregion,"disp_newregion")
	idisp_newregion=0;
	removeDiv(idisp_curanom,"disp_curanom")
	idisp_curanom=0;
	removeDiv(itheCanvas,"theCanvas")
	itheCanvas=0;
	removeDiv(itheCanvas2,"theCanvas2")
	itheCanvas2=0;
	removeDiv(idisp_cryears,"disp_cryears")
	idisp_cryears=0;


// remove divs associated with analog_yrs
	removeDiv(idisp_1or3mo,"disp_1or3mo")
	idisp_1or3mo=0;
	removeDiv(idisp_filterData,"disp_filterData")
	idisp_filterData=0;
	removeDiv(idisp_clearData,"disp_clearData")
	idisp_clearData=0;
	removeDiv(idisp_anlgyrstcis,"disp_anlgyrstcis")
	idisp_anlgyrstcis=0;
	removeDiv(idisp_rangeinit,"disp_rangeinit")
	idisp_rangeinit=0;
	removeDiv(idisp_mssngdata,"disp_mssngdata")
	idisp_mssngdata=0;
	removeDiv(idisp_anlglist,"disp_anlglist")
	idisp_anlglist=0;
	removeDiv(idisp_leadfnctn,"disp_leadfnctn")
	idisp_leadfnctn=0;


//////////// eliminate divs associated with TCIimpacts
	impgridID="";
	impregID="";
// eliminate divs associated with TCIimpacts
// the  hilo list
	removeDiv(idisp_hilolist,"disp_hilolist")
	idisp_hilolist=0;
// the  lkbk list
	removeDiv(idisp_lkbklist,"disp_lkbklist")
	idisp_lkbklist=0;
// the  impact type radio buttons
	removeDiv(idisp_imptype,"disp_imptype")
	idisp_imptype=0;
// the  impact conditional dropdown
	removeDiv(idisp_impcndtnl,"disp_impcndtnl")
	idisp_impcndtnl=0;
// the  commodity region selection dropdown
	removeDiv(idisp_cregdropdown,"disp_cregdropdown")
	idisp_cregdropdown=0;
// the  commodity region overlay display image 
	removeDiv(idisp_reg_ovrlay,"disp_reg_ovrlay")
	idisp_reg_ovrlay=0;
	removeDiv(idisp_xx_ovrlay,"disp_xx_ovrlay") 
	idisp_xx_ovrlay=0;
// the colored boxes
	removeDiv(idisp_impboxes,"disp_impboxes")
	idisp_impboxes=0; 
	removeDiv(idisp_leaddropdown,"disp_leaddropdown")
	idisp_leaddropdown=0;
// the TCI impact info (side panel)
//alert('removing tciimp_info, itciimp_info='+itciimp_info);
	removeDiv(idisp_point_ovrlay,"disp_point_ovrlay")
	idisp_point_ovrlay=0;
	removeDiv(idispcom_image,"dispcom_image")
	idispcom_image=0;
	removeDiv(itciimp_info,"tciimp_info")
	itciimp_info=0;
	removeDiv(itciimp_anom,"tciimp_anom")
	itciimp_anom=0;
	removeDiv(itciimp_lead,"tciimp_lead")
	itciimp_lead=0;
	removeDiv(idisp_cregdropdown,"disp_cregdropdown")
	idisp_cregdropdown=0;
	removeDiv(idisp_impcndtnl,"disp_impcndtnl")
	idisp_impcndtnl=0;
	removeDiv(ichckbox_button,"chckbox_button")
	ichckbox_button=0;

//	eliminate the divs associated with the hurricane information
//alert('eliminate the hurricane divs');
	removeDiv(idisp_hprmbl,"disp_hprmbl")
	idisp_hprmbl=0;
	removeDiv(idisp_shmssg,"disp_shmssg")
	idisp_shmssg=0;
	removeDiv(idisp_hlead,"disp_hlead")
	idisp_hlead=0;
	removeDiv(idisp_htype,"disp_htype")
	idisp_htype=0;
	removeDiv(idisp_hplot,"disp_hplot")
	idisp_hplot=0;
	removeDiv(idisp_hmssg,"disp_hmssg")
	idisp_hmssg=0;
	removeDiv(idisp_hbckg,"disp_hbckg")
	idisp_hbckg=0;
	removeDiv(idisp_hinfo,"disp_hinfo")
	idisp_hinfo=0;
	removeDiv(idisp_back2ay,"disp_back2ay")
	idisp_back2ay=0;
	removeDiv(idisp_quantlist,"disp_quantlist")
	idisp_quantlist=0; 

//	eliminate the divs associated with the ITCZ information
	removeDiv(idisp_ilead,"disp_ilead")
	idisp_ilead=0;
	removeDiv(idisp_iplot,"disp_iplot")
	idisp_iplot=0;
//var idisp_hcplot=0;  // hurricane composite plots superimposed
	removeDiv(idisp_iyplot,"disp_iyplot")
	idisp_iyplot=0;
//var idisp_htype=0;
	removeDiv(idisp_ibckg,"disp_ibckg")
	idisp_ibckg=0;
//var idisp_hmssg=0;
//var idisp_hinfo=0;
	removeDiv(idisp_iprmbl,"disp_iprmbl")
	idisp_iprmbl=0;
//var idisp_back2ay=0;
//var idisp_shmssg=0;
//var idisp_hclabel=0;

//	eliminate the divs associated with timeseries information
	tsClearGrids(0)
	removeDiv(idisp_firstmnth,"disp_firstmnth")
	idisp_firstmnth=0;
	removeDiv(idisp_tsgrid_ovrlay,"disp_tsgrid_ovrlay")
	idisp_tsgrid_ovrlay=0;
	removeDiv(idisp_prcs_detachB,"disp_prcs_detachB")
	idisp_prcs_detachB=0;
	deselectTsAyears(1)
	removeDiv(idisp_mnth_range,"disp_mnth_range")
	idisp_mnth_range=0;
	removeDiv(idisp_ts_bkgrnd,"disp_ts_bkgrnd")
	idisp_ts_bkgrnd=0;
	removeDiv(idisp_clear_grids,"disp_clear_grids")
	idisp_clear_grids=0;
	removeDiv(idisp_prcs_Ayears,"disp_prcs_Ayears")
	idisp_prcs_Ayears=0;
	removeDiv(itheCanvasTS,"theCanvasTS")
	itheCanvasTS=0;
	removeDiv(idisp_deselect_button,"disp_deselect_button")
	idisp_deselect_button=0;
	removeDiv(idisp_deselect_Ayears,"disp_deselect_Ayears")
	idisp_deselect_Ayears=0;
	removeDiv(idisp_detrend_grids,"disp_detrend_grids")
	idisp_detrend_grids=0;
	removeDiv(idisp_tsatcirange,"disp_tsatcirange")
	idisp_tsatcirange=0;
	removeDiv(idisp_tsotcirange,"disp_tsotcirange")
	idisp_tsotcirange=0;
	removeDiv(idisp_firstmnth,"disp_firstmnth")
	idisp_firstmnth=0;

	tsActive= false;




 // in Display Criteria Panel, display drop down menus for year and month
	dispAnomYr()
	dispAnomMn(iflg)


}  // thefield == "anomaly"
//================================================================
//=================================================================
//////////////// timeSeries //////////////////////////// 
//===================================================
//alert('leave getCriteria('+iflg+')');
}  // end function getCriteria(iflg)

///////////////// getAnalysisInfo()   ///////////////////////////////////////////////
function getAnalysisInfo() {
// This function is activated when clicking on the "Analysis Type" info button
// It provides info conditioned on the seected analysis type
var ind = document.forms['field_form'].selectfield.selectedIndex;
	var selfield = fields[ind];
	if(selfield == "anomaly") openSideWindow('help/f_anom.html','rmt_anom','500','225','0')
	if(selfield == "correlation") openSideWindow('help/f_corr.html','rmt_corr','500','275','0')
	if(selfield == "composite:t") openSideWindow('help/f_compt.html','rmt_compt','500','725','0')
	if(selfield == "composite:s") openSideWindow('help/f_comps.html','rmt_comps','500','375','0')
	if(selfield == "composite:r") openSideWindow('help/f_compr.html','rmt_comps','690','500','0')
	if(selfield == "TCIimpacts") openSideWindow('help/f_tciimp.html','rmt_tciimp','500','325','0')
	if(selfield == "analog_yrs") openSideWindow('help/f_anlgyrs.html','rmt_anlgyrs','550','480','0')
	if(selfield == "timeSeries") openSideWindow('help/time_series.html','rmt_tstool','550','570','0')
}  // getAnalysisType
///////////////// getImpCondition()   ///////////////////////////////////////////////
function getImpCondition() {
// get the impact condition from the dropdown
	var ind=document.forms["impcndtnl_form"].sel_impcndtnl.selectedIndex;
	valcond = document.forms["impcndtnl_form"].sel_impcndtnl.value;
//	
//	conditioned on anomaly
	if(valcond == 'cond1') {
	removeDiv(idisp_leaddropdown,"disp_leaddropdown")
	idisp_leaddropdown=0;
	}
//	
//	NOT conditioned on anomaly
	if(valcond == 'cond2') {
// produce dropdown list
	if(idisp_leaddropdown ==0) {
	var dvql= document.createElement('div'); 
	var divIdName = "disp_leaddropdown"; 
	dvql.setAttribute('id',divIdName); 
	dvql.style.color = "#116457"; 
	dvql.style.left = "924px"; 
	dvql.style.top = "114px"; 
	dvql.style.width = "180px"; 
	dvql.style.position = "absolute";
	dvql.style.z_index = 150; 
	divtxt = '<form name="leaddropdown_form" onChange="displayBoxes()">';
	divtxt += '<select name="sel_ilead" size=1>';
	divtxt += '<option value="lead0" selected>lead0</option>';
	divtxt += '<option value="lead1">lead1</option>';
	divtxt += '<option value="lead2">lead2</option>';
	divtxt += '<option value="lead3">lead3</option>';
	divtxt += '<option value="lead4">lead4</option>';
	divtxt += '<option value="lead5">lead5</option>';
	divtxt += '</select></form>';
	dvql.innerHTML = divtxt;
	var node = document.getElementById("all_tcis");
	node.appendChild(dvql);
	idisp_leaddropdown=1;
	}
	}
	displayBoxes()

}  // getImpCondition
