// this set of accesses data from external files
// (1) accessCfile(filename) accesses "constant" data
// (2) accessDfile(filename) accesses "dated" data (updated each month)
// (3) accessTcis()  access tcis name and filename
// (4) accessTcivalues() call two functions below
// (5) accessATciv(file) access atmospheric tci data (from file) 
// (6) accessOTciv(file) access oceanic tci data (from file) 
// (6a) accessTciquants() 
// (6b) accessTcivalidity() 
// (6c)function accessAllcompt() access cmposite members
// (6d)function accessComptYears() access cmposite years
// (7) accessNodeInfo(nodeid) fills arrays lalos[ ], tcisig1[ ], tcisig2[ ]
//	and scalars thenodeID
// (8) accessNodeSigs(nodeid,iflg) accesses node significanvce levels
// (9) accessComp() access composite info 
//(10) accessCompyrs() access composite year info 
//(11) accessComptci() access tci labeling info? 
//(12) splitComptci() splits arrays onto aindxtci,atrndtci,oindxtci,otrndtci
//
//   contains functions: accessCdata(filename) - accesses non-dated (Constant) files

///////// global variables for all data defined here  //////////////////

var aDates = new Array();  // array of monthly dates (yyyymm)
var aDatesL = new Array();  // array of monthly dates (yyyymm)
var cvars = new Array();  // array of 4-char variable names
var fields = new Array(); // array of plot fields (anom, corr, comp)
var atcis = new Array(); // atmos tci names
var numatcic = new Array(); // number of characters in atmos tci names
var otcis = new Array(); // ocean tci names
var numotcic = new Array(); // number of characters in oceanic tci names
var fatcis = new Array(); // atmos tci filenames
var fotcis = new Array(); // ocean tci filenames 
var datcis = new Array(); // atmos tci directory names
var dotcis = new Array(); // ocean tci directory names 
var atcivalues = new Array();// atmos tci monthly values 
var otcivalues = new Array();// ocean tci monthly values 
var yranom = new Array(); // array of years for anomaly data
var mnanom = new Array(); // array of months for anomaly data (char format)
var lalos= new Array();  // holds lat/lon range for region display
var tcisig1 = new Array(); // holds names of tcis at sig level 1 (low)
var tcisig2 = new Array(); // holds names of tcis at sig level 2 (high)
var sigval1 = new Array(); // holds avg significance is sig level 1 (low)
var sigval2 = new Array(); // hholds avg significance is sig level 2 (high)
var allnodes = new Array(); // holds nodeIDs for all nodes
var latrgn = new Array();  // holds the latitude range for the selected focus region
var lonrgn = new Array();  // holds the longitude range for the selected focus region
var c1yrs10 = new Array();  // array of 10-set composite years (sig=1)
var c1yrs25 = new Array();  // array of 25-set composite years (sig=1)
var c2yrs10 = new Array();  // array of 10-set composite years (sig=2)
var c2yrs25 = new Array();  // array of 25-set composite years (sig=2)
var c1tci10 = new Array();  // array of 10-set tcis (sig=1)
var c1tci25 = new Array();  // array of 25-set tcis (sig=1)
var c2tci10 = new Array();  // array of 10-set tcis (sig=2)
var c2tci25 = new Array();  // array of 25-set tcis (sig=2)
var aindxtci = new Array(); // array of atmos comp member index existence
var atrndtci = new Array(); // array of atmos comp member trend existence
var oindxtci = new Array(); // array of ocean comp member index existence
var otrndtci = new Array(); // array of ocean comp member trend existence
var mmflag = "";             // flag == "mm" for mid-month update

/// currently selected or last value of elements of arrays //////////
var theaDate =""; // current selected value of aDates[ ] (analysis dates)
var theaMnth =""; // current selected month value of aDates[ ] (analysis dates)
var theaYear =""; // current selected year value of aDates[ ] (analysis dates)
var theaYrinc=""; // year increment (for lag-selected anomalies)
var thesaMnth =""; // lag-selected  month value
var theLinkmnth =""; // the date controllong the generic TCI composite links 
var thecvar=""; // current selected value of cvars[ ]
var theaycvar=""; // current selected value of cvars[ ] for analog years
var oldaDate =""; // previous selected value of aDates[ ] (analysis dates)
var oldcvar=""; // previous selected value of cvars[ ]
var thefield = ""; // current selected value of fields[ ]
var lastyr=""; // last value of yranom[ ]
var lastmn=""; // last value of mnanom[ ]
var thetci=""; // current selection (name) of either atcis[ ] or otcis[ ] 
var thetcivalue=""; // current selection's (of either atcis[] or otcis[]) value 
var theyear = ""; // current selected value of yranom[ ]
var themnth = ""; // current selected value of mnanom[ ]
var theMrange = ""; // current selected value of Mnth range
var thelookback = ""; // current selected value of selected lookback
var thelead = ""; // current selected value of selected lead
var atciv= ""; // current value of atcis[ ]
var otciv=""; // current value of otcis[ ]
var atcid=""; // current date (yyyymm) of atcis[ ]
var otcid=""; // current date (yyyymm) of otcis[ ]
var theSig = 0; // selected significance level (0=none, 1=low, 0=high)
var thenodeID="";  // holds the current node ID for the selected focus region
var thenodeInfo = 0; // flag indicates node info read
var oldnodeID="";  // holds the previous node ID for the selected focus region
var igrid_locator=0; // existance of the gmap grid locator image
var thelatrgn ="";  // holds the latitude range for the selected focus region
var thelonrgn ="";  // holds the longitude range for the selected focus region
var thetcidir="";  // holds current tci directory
var thetciname="";  // holds current tci name
var thesigval="";  // holds current sigvalue
var theMapFile="";  // holds current map filename
var cnodeID="";  // global composite node ID
var cicoord="";  // global composite node i-coordinate
var cjcoord="";  // global composite node j-coordinate

// composite plot variables
//var ranklength=0;  // the length of the ranked composite list
var thecrank=0;  // index of the ranked composite
var thecset=0;  // the ranked composite set (10 or 25)
var complen=0;  // the the length of available composites
var theclead=""; // the composite lead time
var anomdir=""; // historical anomaly image directory
var comptype=""; // traditional composite type ("-1" or "-3")

/// div existence flags (=1 for existence; =0 for non-existence) //////////
var idisp_point_ovrlay=0;  // existence of <div> disp_map
var idisp_map=0;  // existence of <div> disp_map
var idisp_detachB=0;  // existence of <div> disp_detachB
var idisp_analogSig=0; //existence of analog Significance toggle
// display criteria (anomaly) related
var idisp_year=0;  // existence of <div> disp_year
var idisp_mnth=0;  // existence of <div> disp_mnth

// TCI panel related
var idisp_tcis=0;  // existence of TCI 2-row panel
var idisp_corrtcis=0;  // existence of the TCI correlation radio buttons 
var idisp_comptcis=0;  // existence of the TCI composite checkboxes 
var idisp_nodeimap=0;  // existence of node-imap overlay
//var idisp_nodesig=0;  // existence of 'significance'  buttons
var idisp_Drange=0;  // existence of the lat/lon range div
// display criteria (correlation) related
//var idisp_Mrange=0;  // existence of the mnths range div-inactive
var idisp_Lookback=0;  // existence of the lookback div
var idisp_Lead=0;  // existence of the leads div
var idisp_hinfo=0; // hurricane info button

// focus enable related flags
var idisp_focusregion=0;  // existence of imap focus region overlay
var idisp_showregB=0;  // existence of show region button
var idisp_ovrlayB=0; // existence of overlay button
var idisp_hideregB=0; // existence of hide region button
var idisp_showovrlayB=0;  // existence of show overlay button
var idisp_hideovrlayB=0;  // existence of hide overlay button
var idisp_ovrlay=0; // existence of map overlay
var idisp_nodeenable=0;  // existence of 'Region Focus' enable buttons
var idisp_nodeselect=0;  // existence of red 'select a focus region' text
var idisp_lalo=0;  // existence of the lat/lon range div
var idisp_hidelalo=0;  // existence of the hide lat/lon range div

// composite TCI list overlay related
var idisp_detachGMB=0;  // existence of <div> disp_detachGMB (the tci Gmap overlay)
var idisp_tciGmapB=0; // existence of TCI grid map button
var idisp_hideGMB=0;  // existence of <div> disp_detachGMB (the tci Gmap overlay)
var thenodeInfo = 0;  // flag indicating the load status of all node info
var idisp_sigtcis=0;  // existence of tci list
var idisp_tciwarn=0; // existence tci selection warning message
var idisp_nodeID=0; // existence significance and nodeID display
var igrid_locator=0; // existence significance and nodeID display
var nopen=0;  // keeps track of number of detached windows (for naming them)
var idisp_tciList=0;  // existence of the tci list gmap 
var icomp_mssg1=0; //existence of the composite messages1 div
var icomp_mssg2=0; //existence of the composite messages2 div
var icorr_mssg=0; //existence of the correlation messages div
var idisp_mbrtol=0; //existence of the member/tolerance  div
var idisp_crank=0;  // existence of the composite rank list
var itoprank=-1;  // is 1 for display top ranked composite, else 0
var idisp_cyears=0;  // existence of the composite year list
var iaccessTcis=0;
var iaccessTcivalues=0;
var idisp_wesdkey=0;
///global variables for composite:t  //////////
var idisp_tabdata=0; // holds the button for displaying tabulated TCI data
var thequant="";
var validtcs = "";    // holds initial 32-char ID for all qualifying TCs
var newvalid = "";    // holds 32-char ID for all qualifying TCs with comp selected
var qvalue = new Array();    // holds  dcile, qtile, or dcile TCI values 
var quantiles = new Array(); // array holds strings 'tcile','qtile','dcile'
var idisp_quantlist=0;
var idisp_compttcis=0;
var irestore_compt=0;
var mbrsqtile = new Array();  // holds members of the qtile set
var mbrsdcile = new Array();  // holds members of the dcile set
var mbrsqtiley = new Array();  // holds the analog yearID of members of the qtile set
var mbrsdciley = new Array();  // holds the analog yearID of members of the qtile set
var iloadMbrsqtile = 0;  // indicator that mbrsqtile is read
var iloadMbrsdcile = 0;  // indicator that mbrsdcile is read
var yrscompt = new Array();  // holds composite members years for the compID
var quantcomp = new Array(); // holds the current member selection
var compID = "";  // holds 32-character composite ID
var compIDy = ""; // holds 3-character analogYearID associated with composite ID
var itheCanvas = 0;
var mergedImage= new Image();
var icompt_mssg=0;
var idisp_ctyears=0;
var idisp_ctleads=0;
var idisp_leadtcis=0;
var ikeeptci=0;       // flag to hang onto disp_leadtcis
var savethetcidir="";
var ilinked_tcis=0;
var itcitype_id=0;  // the tcitype_form id
var fadatet = new Array(); // holds array of displays dates for compt, compr

///global variables for composite:s  //////////
var iimap_js=0;
var idisp_compstcis=0;
var idisp_newpoint=0;
var idisp_newregion=0;
var bleft="";  // following 5 variables due to overlay on comps
var btop="";
var biw=0;
var bih=0;
var bfile='';
var fadates = new Array(); // holds array of displayes dates for comps
// global variables for comps

///global variables for composite:r  //////////
var ayrs = new Array(); // array of analog years
var rmse = new Array(); // array of rmse for compr analogs
var scor = new Array(); // array of rmse for compr analogs
var mtch = new Array(); // array of rmse for compr analogs
var theanyear= new Array();  // holds list of analog year (with lag)
var theregsize='lrg';
var idisp_regsize=0;
var idisp_newregion=0;
var idisp_subreg_ovrlay=0;
var idisp_subreg_map=0;
var idisp_curanom=0;
var idisp_anom_ovrlay=0;
var itheCanvas=0;
var itheCanvas2=0;
var itheCanvas5=0;
var itheCanvas4=0;
var idisp_cryears=0;
var theRegID="";
var theix=0;
var thejy=0;
var theiw=0;
var theih=0;
var pt1x=0; 
var pt2x=0; 
var pt3x=0; 
var pt4x=0; // for svg subregion plot
var pt1y=0; 
var pt2y=0; 
var pt3y=0; 
var pt4y=0; // for svg subregion plot

///global variables for TCIimpacts  //////////
var idispcom_image=0;  // existence of commosity images
var idisp_hilolist=0;  // hi/lo percentage dropdown
var idisp_lkbklist=0;  // 10y/30y lookback dropdown
var idisp_imptype=0;  // point or region radio buttons
var idisp_impcndtnl=0;  // impact: current anomaly conditional
var idisp_csigChkBxa=0;  // existence of atmos csig checkboxes
var idisp_csigChkBxo=0;  // existence of oceanic csig checkboxes
var ineeda_region=0;
var idisp_impboxes=0;
var idisp_mssngdata=0;
var impgridID="";
var csiggridID="";  // selected grid point for tool composite:s
var impregID="";
var theimpcvar="";
var mnthNames = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
// global variables for TCIimpacts

///global variables for analog_yrs  //////////
var idisp_1or3mo=0;
var idisp_filterData=0;
var idisp_clearData=0;
var idisp_anlgyrstcis=0;
var idisp_hilolist=0;
var idisp_rangeinit=0;
var idisp_anlglist=0;
var idisp_leadfnctn=0;
var idisp_svgmap=0;
var ndisp_svgmap=0;  // conuts displayed analog year composite maps
var nowtci = new Array();  // holds members of the analog_yrs dataset
var mbrstci = new Array();  // holds members of the analog_yrs dataset
var anlgdate = new Array(); // holds date member of analog_yrs dataset
var fanlgdate = new Array(); // holds date member of filtered analog_yrs dataset
var fanlgdateold = new Array(); // holds date member of filtered analog_yrs dataset
var fanlgmnth = ""; // holds character month  of filtered analog_yrs dataset

// global variables for dispATLhur() functionality
var aceinfo = new Array();  // holds analog year's ace, nTS, nH, nMH
var acehinfo = new Array();  // holds historical  ace, nTS, nH, nMH
var theHanom="";
var idisp_hlead=0;
var idisp_hplot=0;   // hurricane analog year plot
var idisp_hcplot=0;  // hurricane composite plots superimposed
var idisp_hyplot=0;
var idisp_htype=0;
var idisp_hbckg=0;
var idisp_hmssg=0;
var idisp_hinfo=0;
var idisp_hprmbl=0;
var idisp_back2ay=0;
var idisp_shmssg=0;
var idisp_hclabel=0;

// global variables for dispITCZ() functionality
var theIanom="";
var idisp_ilead=0;
var idisp_iplot=0;   // hurricane analog year plot
//var idisp_hcplot=0;  // hurricane composite plots superimposed
var idisp_iyplot=0;
//var idisp_htype=0;
var idisp_ibckg=0;
//var idisp_hmssg=0;
//var idisp_hinfo=0;
var idisp_iprmbl=0;
//var idisp_back2ay=0;
//var idisp_shmssg=0;
//var idisp_hclabel=0;

// global variables for Time Series processing
var tsData = new Array();
var tsgrids = new Array();
var firstmnth = new Array();
var tsvstd = new Array();
var tsmnth1 = 0;
var tsmnth2 = 0;
var tsmnths = new Array();
var tsayyrmo = new Array();
var idisp_firstmnth="";
var idisp_tsGrid=0;
var idisp_tsgrid_ovrlay=0;
var idisp_prcs_detachB=0;
var idisp_ts_bkgrnd=0;
var idisp_prcs_Ayears=0;
var idisp_clear_grids=0;
var idisp_mnth_range=0;
var idisp_WESDtoggle=0;
var tsNselg=0;
var tsvariance=0;
var tsstd=0;
var itheCanvasTS=0;   // holds the set of time series for all cvar
var idisp_aygrid_ovrlay=0;
var tsAYpoints = new Array();
var ntsAYpoints = 0;
var ayinc = 0;
var idisp_deselect_Ayears=0;
var idisp_deselect_button=0;
var idisp_detrend_grids=0;
var idisp_tsatcirange=0;
var idisp_tsotcirange=0;
var tsActive = false;
var tsayDate = new Array();
var tsayqtile = new Array();
var tsaydcile = new Array();
var mintciq = new Array();
var mintcid = new Array();
var maxtciq = new Array();
var maxtcid = new Array();

///////////////// access 'constant' data files  ////////////////////////////
function accessCfile(filename) {   
//alert('accessCfile('+filename+')');
var txtFile = new XMLHttpRequest();
txtFile.open("GET","data/"+filename,false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n"); 
	for (i=0;i<=tmp.length-2;i++) {
		aDatesL[i] = tmp[i];
		mmflag = tmp[i].substring(4,6); 
		if(tmp[i].substring(4,6)=="mm") {
		aDates[i]='20'+tmp[i].substring(0,4);
		} else {
		aDates[i] = tmp[i];
		}
		}
	}
	}
}
txtFile.send(null);
} 
///////////////// access 'dated' data files  ////////////////////////////
function accessDfile(filename) {
//alert('enter accessDfile');

var ind = document.forms['aDate_form'].selectaDate.selectedIndex;
var diraDate = aDates[ind];

var txtFile = new XMLHttpRequest();
txtFile.open("GET","dated/"+diraDate+"/"+filename,false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n"); 
	for (i=0;i<=tmp.length-2;i++) {
		cvars[i] = tmp[i];
		}
	} 
	}
}
txtFile.send(null);
}
////////////////// access tcis by name  ////////////////////////////////
function accessTcis() {

// atci character names
var txtFile = new XMLHttpRequest();
txtFile.open("GET","data/list-atcis.txt",false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n"); 
	for (i=0;i<=tmp.length-2;i++) {
		atcis[i] = tmp[i];
		numatcic[i] = atcis[i].length;
		}
	} 
	}
}
txtFile.send(null);

//otci characternames
var txtFile = new XMLHttpRequest();
txtFile.open("GET","data/list-otcis.txt",false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n"); 
	if(tmp.length==2) {
		otcis[0]=tmp[0];
	} else {
	for (i=0;i<=tmp.length-2;i++) {
		otcis[i] = tmp[i];
		numotcic[i] = otcis[i].length;
		}
	} 
	}
	}
}
txtFile.send(null);

// atci filenames
var txtFile = new XMLHttpRequest();
txtFile.open("GET","data/list_fatcis.txt",false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n"); 
	if(tmp.length==2) {
		fatcis[0]=tmp[0];
	} else {
	for (i=0;i<=tmp.length-2;i++) {
		fatcis[i] = tmp[i];
		}
	} 
	}
	}
}
txtFile.send(null);

// otci filenames
var txtFile = new XMLHttpRequest();
txtFile.open("GET","data/list_fotcis.txt",false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n"); 
	if(tmp.length==2) {
		fotcis[0]=tmp[0];
	} else {
	for (i=0;i<=tmp.length-2;i++) {
		fotcis[i] = tmp[i];
		}
	} 
	}
	}
}
txtFile.send(null);

// atci directory names
var txtFile = new XMLHttpRequest();
txtFile.open("GET","data/list_datcis.txt",false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n"); 
	if(tmp.length==2) {
		datcis[0]=tmp[0];
	} else {
	for (i=0;i<=tmp.length-2;i++) {
		datcis[i] = tmp[i];
		}
	} 
	}
	}
}
txtFile.send(null);

// otci directory names
var txtFile = new XMLHttpRequest();
txtFile.open("GET","data/list_dotcis.txt",false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n"); 
	if(tmp.length==2) {
		dotcis[0]=tmp[0];
	} else {
	for (i=0;i<=tmp.length-2;i++) {
		dotcis[i] = tmp[i];
		}
	} 
	}
	}
}
txtFile.send(null);
iaccessTcis=1;
}
///////////////////// access atmospheric and oceanic tci values //////////////////////////////////////////////////////////
function accessTcivalues() {
// this function calls within a TCI loop over files, the functions 
// accessATciv(file) and accessOTciv(file)
//
// access the monthly tci index values- access returns for each file
// atciv, atcid, otciv,otcid (v=value, d=date)
// atmos
	if(fatcis.length==1) {
	var file = fatcis[0];
	accessATciv(file)	
	} else {
	for(i=0;i<=fatcis.length-1;i++) {
	var file = fatcis[i];
	accessATciv(file)
	atcivalues[i]=atciv;
	if(i==3 && (atciv > 10 || atciv < -10)) atcivalues[i]= Math.round(10 * atciv) / 10;
	if(file=='MJO') atcivalues[i]= Math.round(atciv);
	} // i loop
	} 
//alert('dispTcis:   atcivalues='+atcivalues);
// ocean
	if(fotcis.length==1) {
	var file = fotcis[0];
	accessOTciv(file)	
//	var otcidate=otcid;
	otcivalues[0]=otciv;
	} else {
	for(i=0;i<=fotcis.length-1;i++) {
	var file = fotcis[i];
	accessOTciv(file)
	otcivalues[i]=otciv;
	} // i loop
	} 
iaccessTcivalues=1;
}
///////////////////// access atmospheric tci values //////////////////////////////////////////////////////////
function accessATciv(file) {
//alert('accessATciv with file='+file);
var i;
var theyearmnth = theyear+themnth;
//alert('theyear='+theyear+' themnth='+themnth+' theaDate='+theaDate+' theyearmnth='+theyearmnth);
var txtFile = new XMLHttpRequest();
txtFile.open("GET","dated/"+theaDate+"/atci_values/"+file+".txt",false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
//	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n"); 
//alert('accessATciv: tmp='+tmp);
	for (i=0;i<=tmp.length-1;i++) {
		var date = tmp[i].substring(0,6);
			if(date==theyearmnth) {
			atciv=tmp[i].substring(8,14);
			if(atciv == -99.90) atciv = 888;
			if(atciv == 999.9) atciv = 999;
			atcid=tmp[i].substring(0,6);
			}
		}
//alert('accessATciv: atciv='+atciv);
	if(tmp[0].substring(0,6) > theyearmnth) atciv = 999;
	} 
	}
}
txtFile.send(null);
}
///////////////////// access oceanic tci values //////////////////////////////////////////////////////////
function accessOTciv(file) {
var i;
var theyearmnth = theyear+themnth;
var txtFile = new XMLHttpRequest();
txtFile.open("GET","dated/"+theaDate+"/otci_values/"+file+".txt",false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
//	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n"); 
	for (i=0;i<=tmp.length-2;i++) {
			var date = tmp[i].substring(0,6);
			if(date==theyearmnth) {
			otciv=tmp[i].substring(8,14);
			otcid=tmp[i].substring(0,6);
//alert('accessATciv: otciv='+otciv);
			}
		}
	if(tmp[0].substring(0,6) > theyearmnth) otciv = 999;
	}
	}
}
txtFile.send(null);

}
////////// composite:t access qantile value information for this quant ////////////////////
function accessTciquants() {
//alert("enter accessTciquants(), thefield="+thefield);
// get the selected quantile
	var ind = document.forms["quantlist_form"].selectquant.selectedIndex;
	thequant = document.forms["quantlist_form"].selectquant[ind].value;
//alert("accessTciquants: thequant="+thequant);
//alert('accessTciquants;theaDate='+theaDate);
var i;
var theyearmnth = theyear+themnth;
var txtFile = new XMLHttpRequest();
txtFile.open("GET","dated/"+theaDate+"/wdat-compt/"+thequant+"/values.txt",false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("  "); 
	for (i=1;i<=tmp.length-2;i++) {
			qvalue[i]=tmp[i+1];
		}
	var num=Math.round(tmp[1]);  // to eliminate first space in _5 as 1st element
	qvalue[0]=num.toString();
	}
	}
}
txtFile.send(null);
//alert("qvalue="+qvalue+" qvalue.length="+ qvalue.length);
accessTcivalidity()
}
////////// analog_yrs access qantile values for this quant and data-type////////////////////
function accessQuantDat() {
//alert("enter accessQuantDat(), thefield="+thefield);
// get the selected quantile
	var ind = document.forms["hilolist_form"].selecthilo.selectedIndex;
	var val = document.forms["hilolist_form"].selecthilo[ind].value;
	if(val=='10p') thequant='dcile';
	if(val=='25p') thequant='qtile';
// get the selected dataset
	var ind = document.forms["1or3mo_form"].select1or3mo.selectedIndex;
	var mosel = document.forms["1or3mo_form"].select1or3mo[ind].value;
//alert('accessQuantDat: mosel='+mosel);
// get the proper filter functionality (and set lead)
	var ind = document.forms["leadtype_form"].sel_leadtype.selectedIndex;
	var leadtype = document.forms["leadtype_form"].sel_leadtype[ind].value;
	if(leadtype == "type1") {
	var file="dated/"+theaDate+"/wdat-anlgyr/"+thequant+mosel+"-l0.txt";
	} else {
		for(i=0;i<=5;i++) {
		if(document.forms['ctleadtime'].radioclead[i].checked==true) var lead = "-l"+i;
		}
	var file="dated/"+theaDate+"/wdat-anlgyr/"+thequant+mosel+lead+".txt";
	}
//alert("accessTciquants: file="+file);
//alert("accessTciquants: thequant="+thequant+' ind='+ind);
//alert('accessTciquants;theaDate='+theaDate+' mosel='+mosel);
var i;
var j;
var theyearmnth = theyear+themnth;
var txtFile = new XMLHttpRequest();
anlgdate=[];
mbrstci=[];
//alert('theaDate='+theaDate+' file='+file);
txtFile.open("GET",file,false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n");
	var dat=new Array();
		for(i=1; i<= tmp.length; i++) {
		dat[i-1] = tmp[i-1].split("  ");
		anlgdate[i-1] = dat[i-1][1].substring(1,7);
//alert("anlgdate[i-1]="+anlgdate[i-1]);
		mbrstci[i-1]=[];
			for(j=1;j<=dat[i-1].length-2;j++) {
			mbrstci[i-1][j-1]=dat[i-1][j+1];
			}
//alert("mbrstci="+mbrstci[i-1]+' mbrstci.mbrstci='+mbrstci[i-1].length);
		if(anlgdate[i-1]==theaDate) {
			for(j=1;j<=dat[i-1].length-2;j++) {
				nowtci[j-1]=mbrstci[i-1][j-1];
			}
//alert("nowtci="+nowtci+' nowtci.length='+nowtci.length);
		}

		} // i-loop
	}
	}
}
txtFile.send(null);
//alert('accessQuantDat: anlgdate='+anlgdate);
//alert("anlgdate.length="+anlgdate.length);
} // accessQuantDat
////////// composite:t access the TCI validity information for this quant ////////////////////
function accessTcivalidity() {
//alert("enter accessTcivalidity()");
// get the validity 32-char array
var ind = document.forms["quantlist_form"].selectquant.selectedIndex;
thequant = document.forms["quantlist_form"].selectquant[ind].value;
//alert("thequant="+thequant);

var i;
var theyearmnth = theyear+themnth;
var txtFile = new XMLHttpRequest();
txtFile.open("GET","dated/"+theaDate+"/wdat-compt/"+thequant+"/valid-tcs.txt",false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\r"); 
			validtcs=tmp[0].substring(1,33);
	}
	}
}
txtFile.send(null);
//alert("validtcs="+validtcs+" 3rd element="+validtcs.substring(2,3));

}
////////// composite:t access all composite members ////////////////////
function accessAllcompt() {
//alert("enter accessAllcompt("+thequant+"): iloadMbrsqtile="+iloadMbrsqtile+" iloadMbrsdcile="+iloadMbrsdcile+" theaDate="+theaDate);
// 	check whether the data are already read and only read if necessary
	var ind = document.forms["quantlist_form"].selectquant.selectedIndex;
	thequant = document.forms["quantlist_form"].selectquant[ind].value;
//	alert("thequant="+thequant);
	if(thequant == "qtile" && iloadMbrsqtile == 1) {
	return;
	} else {
	mbrsqtile=[];
	}
	if(thequant == "dcile" && iloadMbrsdcile == 1) {
	return;
	} else {
	mbrsdcile=[];
	}
var i;
var theyearmnth = theyear+themnth;
//alert("accessAllcompt: getting dated/"+theaDate+"/wdat-compt/"+thequant+"/compt-list.txt");
var txtFile="";
var txtFile = new XMLHttpRequest();
txtFile.open("GET","dated/"+theaDate+"/wdat-compt/"+thequant+"/compt-list.txt",false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n");
		for(i=1; i<= tmp.length-1; i++) {
			if(thequant == "qtile") {
				mbrsqtile[i-1]=tmp[i-1].substring(0,32);
				mbrsqtiley[i-1]=tmp[i-1].substring(33,36);
	}
			if(thequant == "dcile") {
				mbrsdcile[i-1]=tmp[i-1].substring(0,32);
				mbrsdciley[i-1]=tmp[i-1].substring(33,36);
			}
		}
	if(thequant == "qtile") iloadMbrsqtile=1;
	if(thequant == "dcile") iloadMbrsdcile=1;
//alert('mbrsdciley='+mbrsdciley);
	}
	}
}
txtFile.send(null);
}
/////////////////// accessComptYears(compID,compIDy) ////////////////////////////
function accessComptYears(compID,compIDy) {
//alert("enter accessComptYears with compID="+compID);
// 	check whether the data are already read and only read if necessary
	var ind = document.forms["quantlist_form"].selectquant.selectedIndex;
	thequant = document.forms["quantlist_form"].selectquant[ind].value;
//	alert("thequant="+thequant);
//	alert("compID="+compID);
//	alert("compIDy="+compIDy);
//	alert("theaDate="+theaDate);
var i;
yrscompt=[];
var txtFile = new XMLHttpRequest();
txtFile.open("GET","dated/"+theaDate+"/wdat-compt/yrcomp/"+thequant+"/"+compID+"."+compIDy,false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("  ");
	var nyears = tmp[1];
//alert("nyears="+nyears);
		for(i=1;i<=nyears;i++) {
		yrscompt[i-1]=tmp[i+1];
		}
//alert("yrscompt="+yrscompt);
	}
	}
}
txtFile.send(null);
//alert("mbrsdcile="+mbrsdcile);


} //accessComptYears(compID,cpmpIDy)
/////////////   accessNodeInfo  /////////////////////////////
function accessNodeInfo(nodeid) {
//
//	this function accesses the CPAweb/data/imap-data.txt file
//	and fills in global arrays lalos[ ], tcisig1[ ], tcisig2[ ]
//	and scalars thenodeID
var txtFile = new XMLHttpRequest();
txtFile.open("GET","data/imap-data.txt",false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText.split("\n");
// following split creates one extra because of final return in file. do not include this
	for (i=0;i<=allText.length-2;i++) {
			var therec=allText[i].split("  ");
			allnodes[i] = therec[0];
			var lat1 = therec[3];
			var lat2 = therec[4];
			var lon1 = therec[5];
			var lon2 = therec[6];
		if(lon1 > 4000) lon1=lon1-5000;
		if(lon2 > 4000) lon2=lon2-5000;
		if(lat1 > 4000) lat1=lat1-5000;
		if(lat2 > 4000) lat2=lat2-5000;
			latrgn[i] = lat1+" to "+lat2;
			lonrgn[i] = lon1+" to "+lon2;
				if(allnodes[i]==nodeid) {
				thenodeID=nodeid;
				thelatrgn=latrgn[i];
				thelonrgn=lonrgn[i];
				}
		}
	}
	}
}
txtFile.send(null);
thenodeInfo=1;  // node information loaded
}
///////////////////// access node Sigs  //////////////////////////////////
function accessNodeSigs(nodeid,iflg) {
//alert(' inside accessNodeSigs');
//alert(' thelookback='+thelookback);
//alert(' theMrange='+theMrange);
//alert(' thelead='+thelead);
//alert(' accessNodeSigs: nodeid='+nodeid);
//alert(' accessNodeSigs: theaDate='+theaDate);
//alert(' accessNodeSigs: thecvar='+thecvar);
	if(iflg==0) {
	var file = 'dated/'+theaDate+'/wdat-comp/'+thecvar+'/'+nodeid+'-w.txt';
	} else {
	var file = '../wdat-comp/'+rmtcvar+'/'+nodeid+'-w.txt';
	}
//alert('file='+file);
// zero out the old arrays 
	tcisig1.length=0;
	tcisig2.length=0;
// given a nodeid, read the appropriate file an fill in arrays tcisig1 
var txtFile = new XMLHttpRequest();
txtFile.open("GET",''+file+'',false); // false=synchronous request
//alert('after the open');
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	var allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=allText.split("\n"); 
	var nsig1=tmp[0]*1;
// check value of nsig2 
	if(nsig1>0) {
		var jj=0;
		for (i=1;i<=nsig1;i++) {
		jj++;
		tcisig1[jj-1] = tmp[i];
		sigval1[jj-1] = 1;
		}
		} // nsig1>0
		jj++;
	var nsig2=tmp[jj]*1;
	if(nsig2>0) {
		for (i=1;i<=nsig2;i++) {
		var jji=jj+i;
		tcisig2[i-1] = tmp[jji];
		sigval2[jj-1] = 2;
		}
		}  // nsig2>0
	}
	}
}
txtFile.send(null);
//alert('accessNodeSigs: tcisig1.length='+tcisig1.length+' tcisig1='+tcisig1);
//alert('accessNodeSigs: tcisig2.length='+tcisig2.length+' tcisig2='+tcisig2);
//alert('accessNodeSigs: sigval1.length='+sigval1.length+' sigval1='+sigval1);
//alert('accessNodeSigs: sigval2.length='+sigval2.length+' sigval2='+sigval2);
} // access node Sigs
//////////////// accessComp ////////////////////////////////////////
function accessComp() {
//alert('enter accessComp: thenodeID='+thenodeID);
c1yrs10.length = 0;  // zero out global variable
c2yrs10.length = 0;  // zero out global variable
c1yrs25.length = 0;  // zero out global variable
c2yrs25.length = 0;  // zero out global variable
c1tci10.length = 0;  // zero out global variable
c2tci10.length = 0;  // zero out global variable
c1tci25.length = 0;  // zero out global variable
c2tci25.length = 0;  // zero out global variable
// first, read the nodeID-w.txt data only for the values of sig1 and sig2
var file = 'dated/'+theaDate+'/wdat-comp/'+thecvar+'/'+thenodeID+'-w.txt';
//alert('accessComp: file='+file);
var txtFile = new XMLHttpRequest();
txtFile.open("GET",''+file+'',false); // false=synchronous request
//alert('after the open');
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	var allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=allText.split("\n"); 
	var nsig1=tmp[0]*1;
	var nsig2=tmp[nsig1+1]*1;
//alert('nsig1='+nsig1+' nsig2='+nsig2);
accessCompyrs(nsig1,1,10);
//alert('c1yrs10='+c1yrs10);
accessCompyrs(nsig2,2,10);
//alert('c2yrs10='+c2yrs10);
accessCompyrs(nsig1,1,25);
//alert('c1yrs25='+c1yrs25);
accessCompyrs(nsig2,2,25);
//alert('c2yrs25='+c2yrs25);
accessComptci(nsig1,1,10);
//alert('c1tci10='+c1tci10+' length='+c1tci10.length);
accessComptci(nsig2,2,10);
//alert('c2tci10='+c2tci10+' length='+c2tci10.length);
accessComptci(nsig1,1,25);
//alert('c1tci25='+c1tci25+' length='+c1tci25.length);
accessComptci(nsig2,2,25);
//alert('c2tci25='+c2tci25+' length='+c2tci25.length);
	}
	}
}
txtFile.send(null);
}
////////////////////////  accessCompyrs  /////////////////////////////////
function accessCompyrs(nsig,sval,iset) {
// next, if nsig1 (nsig2) > 0, read the '10' and '25' sets of tcis and cyrs files
//alert('enter accessCompyrs: nsig='+nsig+' sval='+sval+' set='+set);
var fileb = 'dated/'+theaDate+'/wdat-comp/'+thecvar+'/';

	if(nsig > 0) {
	var file = fileb+thenodeID+'-'+sval+'-cyrs'+iset+'.txt';
	var txtFile = new XMLHttpRequest();
	txtFile.open("GET",''+file+'',false); // false=synchronous request
	txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	var allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=allText.split("\n"); 
	for (i=1;i<=tmp.length-1;i++) {
	if(sval==1 && iset==10) c1yrs10[i-1]=tmp[i-1];
	if(sval==2 && iset==10) c2yrs10[i-1]=tmp[i-1];
	if(sval==1 && iset==25) c1yrs25[i-1]=tmp[i-1];
	if(sval==2 && iset==25) c2yrs25[i-1]=tmp[i-1];
	}
	}
	}
}
	txtFile.send(null);
	}  // nsig >0
}
////////////////////////  accessCompyrs  /////////////////////////////////
function accessComptci(nsig,sval,iset) {
// next, if nsig1 (nsig2) > 0, read the '10' and '25' sets of tcis and cyrs files
//alert('enter accessComptci: nsig='+nsig+' sval='+sval+' set='+set);
var fileb = 'dated/'+theaDate+'/wdat-comp/'+thecvar+'/';

	if(nsig > 0) {
	var file = fileb+thenodeID+'-'+sval+'-tcis'+iset+'.txt';
//alert('file='+file);
	var txtFile = new XMLHttpRequest();
	txtFile.open("GET",''+file+'',false); // false=synchronous request
	txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	var allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=allText.split("\n"); 
	for (i=1;i<=tmp.length-1;i++) {
	if(sval==1 && iset==10) c1tci10[i-1]=tmp[i-1];
	if(sval==2 && iset==10) c2tci10[i-1]=tmp[i-1];
	if(sval==1 && iset==25) c1tci25[i-1]=tmp[i-1];
	if(sval==2 && iset==25) c2tci25[i-1]=tmp[i-1];
	}
	}
	}
}
	txtFile.send(null);
	}  // nsig >0
}
////////////////////////////////// accessCompTcis() /////////////////////////////
function splitCompTcis() {
var comptci = new Array();
//alert('enter splitCompTcis: idisp_focusregion='+idisp_focusregion);
// accessComptci(nsig,sval,iset) has already filled arrays:
// c1tci10,c2tci10,c1tci25,c2tci25. This function splits the appropriate file and
// fills arrays aindxtci,atrndtci,oindxtci,otrndtci
//alert('splitCompTcis: thesigval='+thesigval);
//alert('splitCompTcis: thecset='+thecset);
//alert('splitCompTcis: thecrank='+thecrank);
if(idisp_focusregion==1) {
if(thesigval==1 && thecset==10) var ctcicomp=c1tci10[thecrank-1];
if(thesigval==2 && thecset==10) var ctcicomp=c2tci10[thecrank-1];
if(thesigval==1 && thecset==25) var ctcicomp=c1tci25[thecrank-1];
if(thesigval==2 && thecset==25) var ctcicomp=c2tci25[thecrank-1];
//
// split and fill arrays aindxtci,atrndtci,oindxtci,otrndtci
//
//alert('splitCompTcis: ctcicomp='+ctcicomp);
var comps = ctcicomp.split(" "); 
//alert('splitCompTcis: comps='+comps);
if(comps[0]=="") var inmbr = 1;           // element 0 is blank
if(comps[0]!="") var inmbr = 0;           // element 0 is not blank
var nmbr = comps[inmbr];
//alert('splitCompTcis: nmbr='+nmbr);
//alert('splitCompTcis: datcis='+datcis);
// loop over composite mmbers
	for(i=1;i<=datcis.length;i++) {
	aindxtci[i-1]=" ";
	atrndtci[i-1]=" ";
	}
//alert('splitCompTcis: dotcis='+dotcis);
	for(i=1;i<=dotcis.length;i++) {
	oindxtci[i-1]=" ";
	otrndtci[i-1]=" ";
	}
// loop over composite members
	for(i=1;i<=nmbr;i++) {
	comptci[i-1]=comps[inmbr+i];
	var dcomptci =comptci[i-1].substring(0,5);
	var vcomptci =comptci[i-1].substring(5,6);
// loop over atmos directory names to match dcomptci
		for(j=1;j<=datcis.length;j++) {
			if(dcomptci==datcis[j-1]) {
				if(vcomptci=="_") aindxtci[j-1]="I";
				if(vcomptci=="t") atrndtci[j-1]="T";
			} 
		}  // j<=fatcis.length
// loop over ocean directory names to match dcomptci
		for(j=1;j<=dotcis.length;j++) {
			if(dcomptci==dotcis[j-1]) {
				if(vcomptci=="_") oindxtci[j-1]="I";
				if(vcomptci=="t") otrndtci[j-1]="T";
			} 
		}  // j<=fotcis.length
	} // i<=nmbr
//alert('splitCompTcis: atmos aindxtci='+aindxtci);
//alert('splitCompTcis: atmos atrndtci='+atrndtci);
//alert('splitCompTcis: ocean oindxtci='+oindxtci);
//alert('splitCompTcis: ocean otrndtci='+otrndtci);
}
//
}  // splitCompTcis()
////////////////////////////////// accessCsigPoint(gridID,cvar,quant) /////////////////////////////
function accessCsigPoint(gridID,cvar,quant) {
//alert('enter accessCsigPoint');

	var file = 'dated/'+theaDate+'/wdat-comps/'+cvar+'/'+quant+'/'+gridID+'-1mo.txt';
//alert('file='+file);
	var txtFile = new XMLHttpRequest();
	txtFile.open("GET",''+file+'',false); // false=synchronous request
	txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	var allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=allText.split("\n"); 
	var tmp2=tmp[0].split(".")
	compID=tmp2[0];
	var tmp2=tmp[1].split(".")
	compIDy=tmp2[1];
	}
	}
}
	txtFile.send(null);
//alert('compID='+compID+' compIDy='+compIDy);
} // accessCsigPoint(gridID,cvar,quant)
////////////////////////////////// accessCsigReg() /////////////////////////////
function accessCsigReg(IDr,cvar,quant) {
//alert('enter accessCsigReg:');

	var file = 'dated/'+theaDate+'/wdat-comps/'+cvar+'/'+quant+'/'+IDr+'-1mo.txt';
	var txtFile = new XMLHttpRequest();
	txtFile.open("GET",''+file+'',false); // false=synchronous request
	txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	var allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=allText.split("\n"); 
	var tmp2=tmp[0].split(".")
	compID=tmp2[0];
	var tmp2=tmp[1].split(".")
	compIDy=tmp2[1];
	}
	}
}
	txtFile.send(null);
//alert('compID='+compID+' compIDy='+compIDy);
} // accessCsigReg(IDr,cvar,quant)
////////////////////////////////// accessCsigYrs() /////////////////////////////
function accessCsigYrs() {
// for composite significance, we have the name of the appropriate file
//	containing the composite compID+"."+compIDy
//	This function accesses the appropriate
//	wdat-compt file and load the analog years for this composite
//
//alert('enter accessCsigYrs with compID='+compID+' compIDy='+compIDy+' thequant='+thequant+' theaDate='+theaDate);
var i;
yrscompt=[];
var file = "dated/"+theaDate+"/wdat-compt/yrcomp/"+thequant+"/"+compID+"."+compIDy;
//alert('file='+file);
var txtFile = new XMLHttpRequest();
txtFile.open("GET",''+file+'',false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("  ");
	var nyears = tmp[1];
		for(i=1;i<=nyears;i++) {
		yrscompt[i-1]=tmp[i+1];
		}
//alert("accessCsigYrs: nyears="+nyears+"  yrscompt="+yrscompt);
	}
	}
}
txtFile.send(null);
//
} // accessCsigYrs()
////////////////////////////////// accessComprInfo() /////////////////////////////
function accessComprInfo(regID) {
//
//	This function reads the file /dated/data-compr/cvar-regID.txt
//	which contains a list of analog years and the stats for that region
//
//
//alert('accessComprInfo: regID='+regID+' theaDate='+theaDate+' cvar='+thecvar);
var i;
var ID;
var dat = new Array();
var file = "dated/"+theaDate+"/data-compr/"+thecvar+"-"+regID+".txt";
var txtFile = new XMLHttpRequest();
txtFile.open("GET",''+file+'',false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n");
	for(i=1;i<=tmp.length-1;i++) {
		dat = tmp[i-1].split("  ");
		ayrs[i-1]  = dat[1]; // array of analog years
		rmse[i-1]  = dat[2]; // array of rmse for compr analogs
		scor[i-1]  = dat[3]; // array of rmse for compr analogs
		mtch[i-1]  = dat[4]; // array of rmse for compr analogs
	}
//alert('ayrs='+ayrs);
//alert('rmse='+rmse);
//alert('scor='+scor);
//alert('mtch='+mtch);
	}
	}
}
txtFile.send(null);
//

} // accessComprInfo(regID)
////////////////////////////////// accessACEinfo() /////////////////////////////
function accessACEinfo(hafile) {
//alert('accessACEinfo; file='+hafile);
// array,aceinfo[] of length 4 filled for this dated file

var txtFile = new XMLHttpRequest();
var i;
txtFile.open("GET",hafile,false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split(" "); 
	for (i=0;i<=tmp.length-1;i++) {
		aceinfo[i] = tmp[i];
		if(i == tmp.length-1) aceinfoNS = parseInt(aceinfo[1]) + parseInt(aceinfo[2]);
		}
	} 
	}
}
txtFile.send(null);
}  // ccessACEinfo(hafile)
////////////////////////////////// accessACEinfo() /////////////////////////////
function accesshACEinfo(hafile) {
var txtFile = new XMLHttpRequest();
var i;
txtFile.open("GET",hafile,false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split(" "); 
	for (i=0;i<=tmp.length-1;i++) {
		acehinfo[i] = tmp[i];
		}
	} 
	}
}
		acehinfoNS = parseInt(acehinfo[1]) + parseInt(acehinfo[2]);
txtFile.send(null);

}  // accesshACEinfo(hafile) 
////////////////////////////////// accessTSdata() /////////////////////////////
function accessTSdata(cfile) {
//alert('enter accessTSdata: cfile='+cfile);
var txtFile = new XMLHttpRequest();
txtFile.open("GET",cfile,false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\r"); 
//	There will be 12 historical time series (one for each calendar month) with the 
//	leading array element the month index (1,2,...12)
	for (i=0;i<=11;i++) {
		tsData[i] = tmp[i].split(" ");  // tsData is global
		}
	} 
	}
}
txtFile.send(null);

}  // accessTSdata(cfile)
////////////////////////////////// accessTSanyrs() /////////////////////////////
function accessTSanyrs(cfile) {
var txtFile = new XMLHttpRequest();
txtFile.open("GET",cfile,false); // false=synchronous request
txtFile.onreadystatechange=function() {
	if(txtFile.readyState == 4) {         // makes sure document is ready to parse
	if(txtFile.status == 0 || txtFile.status == 200) { // makes sure file is found
	allText=txtFile.responseText;
// following split creates one extra because of final return in file. do not include this
	var tmp=txtFile.responseText.split("\n"); 
//	There will be 12 historical time series (one for each calendar month) with the 
//	leading array element the month index (1,2,...12)
	for (i=0;i<=tmp.length-1;i++) {
		tsayDate[i] = tmp[i].split(" ")[0];  // tsData is global
		tsayqtile[i] = tmp[i].split(" ")[1];  // tsData is global
		tsaydcile[i] = tmp[i].split(" ")[2];  // tsData is global
		}
	}
	}
}
txtFile.send(null);

}  // accessTSanyrs(cfile)
 

